/*
 * Symphony - A modern community (forum/BBS/SNS/blog) platform written in Java.
 * Copyright (C) 2012-2018, b3log.org & hacpai.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.b3log.symphony.model;

/**
 * This class defines all visit model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.0.0.0, Jul 27, 2018
 * @since 3.2.0
 */
public final class Visit {

    /**
     * Visit.
     */
    public static final String VISIT = "visit";

    /**
     * Visits.
     */
    public static final String VISITS = "visits";

    /**
     * Key of visit URL.
     */
    public static final String VISIT_URL = "visitURL";

    /**
     * Key of visit IP.
     */
    public static final String VISIT_IP = "visitIP";

    /**
     * Key of visit UA.
     */
    public static final String VISIT_UA = "visitUA";

    /**
     * Key of visit city.
     */
    public static final String VISIT_CITY = "visitCity";

    /**
     * Key of visit device id.
     */
    public static final String VISIT_DEVICE_ID = "visitDeviceId";

    /**
     * Key of visit user id.
     */
    public static final String VISIT_USER_ID = "visitUserId";

    /**
     * Key of visit referer URL.
     */
    public static final String VISIT_REFERER_URL = "visitRefererURL";

    /**
     * Key of visit created.
     */
    public static final String VISIT_CREATED = "visitCreated";

    /**
     * Key of visit expired.
     */
    public static final String VISIT_EXPIRED = "visitExpired";

}
