/*
 * Symphony - A modern community (forum/BBS/SNS/blog) platform written in Java.
 * Copyright (C) 2012-2018, b3log.org & hacpai.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
/**
 * @fileoverview add svg sprite.
 *
 * @author <a href="http://vanessa.b3log.org">Liyuan Li</a>
 * @version 0.4.0.0, Jul 5, 2018
 * @since 2.2.0
 */

var svg = '<svg style="position: absolute; width: 0; height: 0; overflow: hidden;" version="1.1" xmlns="http://www.w3.org/2000/svg"><defs><symbol id="logo" viewBox="0 0 16 16"><path d="M10.098 3.919c-0.565 0.565-1.525 2.197-2.063 3.508l-0.197 0.485-0.405 0.059c-0.224 0.037-0.704 0.149-1.066 0.256-0.368 0.101-0.677 0.181-0.688 0.165-0.011-0.011 0.037-0.293 0.107-0.629 0.592-2.73 0.053-4.047-1.429-3.498-0.357 0.133-0.464 0.251-0.352 0.384 0.059 0.069 0.128 0.080 0.357 0.048 0.24-0.027 0.304-0.016 0.395 0.064 0.288 0.261 0.4 0.826 0.32 1.599-0.091 0.8-0.325 2.271-0.384 2.378-0.027 0.048-0.16 0.155-0.293 0.235-0.704 0.411-1.413 1.146-1.722 1.781-0.165 0.341-0.192 0.453-0.192 0.773 0 0.293 0.027 0.416 0.123 0.565 0.133 0.219 0.432 0.368 0.736 0.368 0.261 0 0.666-0.224 0.901-0.491 0.288-0.341 0.725-1.253 1.013-2.133l0.261-0.773 0.347-0.139c0.437-0.165 1.349-0.448 1.615-0.496l0.203-0.032-0.080 0.229c-0.149 0.421-0.293 1.258-0.293 1.711 0 0.746 0.219 1.269 0.533 1.269 0.245 0 0.288-0.107 0.155-0.432-0.203-0.501-0.123-1.461 0.203-2.453 0.123-0.373 0.149-0.411 0.293-0.443 0.203-0.043 0.736-0.043 0.736 0 0 0.027-0.075 0.57-0.139 0.954-0.011 0.085-0.048 0.725-0.080 1.413-0.064 1.424-0.048 1.546 0.219 1.546 0.197 0 0.453-0.123 0.501-0.24 0.016-0.048 0.032-0.213 0.032-0.368 0-0.352 0.149-1.482 0.203-1.53 0.021-0.021 0.187-0.080 0.373-0.128 0.965-0.245 1.717-0.656 2.335-1.274 0.805-0.81 1.002-1.631 0.597-2.479-0.16-0.347-0.901-1.061-1.312-1.274-0.427-0.229-1.024-0.432-1.381-0.475-0.155-0.016-0.283-0.043-0.283-0.053s0.059-0.101 0.133-0.197c0.32-0.421 0.043-0.634-0.331-0.256zM10.956 5.252c0.746 0.245 1.386 0.757 1.674 1.344 0.192 0.389 0.203 1.029 0.027 1.36-0.24 0.453-0.768 0.933-1.376 1.237-0.283 0.144-1.205 0.453-1.242 0.416-0.016-0.016 0-0.272 0.032-0.565 0.059-0.475 0.080-0.554 0.197-0.645 0.144-0.112 0.176-0.315 0.059-0.411-0.064-0.053-0.059-0.128 0.027-0.501 0.053-0.24 0.16-0.656 0.24-0.917 0.224-0.757 0.256-0.976 0.16-1.12s-0.299-0.192-0.549-0.123c-0.155 0.043-0.208 0.096-0.32 0.347-0.128 0.277-0.549 1.855-0.549 2.053 0 0.085-0.053 0.096-0.405 0.096h-0.405l0.037-0.149c0.064-0.283 0.656-1.615 0.938-2.122l0.283-0.512 0.379 0.037c0.203 0.021 0.56 0.101 0.794 0.176zM4.489 9.81c-0.059 0.16-0.24 0.565-0.411 0.896-0.427 0.837-0.704 1.125-0.949 0.997-0.080-0.043-0.091-0.096-0.069-0.288 0.037-0.352 0.288-0.794 0.704-1.237 0.347-0.373 0.768-0.73 0.81-0.688 0.011 0.011-0.032 0.155-0.085 0.32z"></path><path d="M1.077 5.572c-0.363 0.181-0.384 0.256-0.395 1.296-0.011 1.093-0.043 1.178-0.443 1.285-0.224 0.064-0.24 0.080-0.224 0.224 0.016 0.133 0.043 0.165 0.197 0.197 0.096 0.021 0.24 0.101 0.32 0.176 0.139 0.139 0.139 0.149 0.144 1.024 0.005 0.565 0.032 0.938 0.075 1.040 0.091 0.213 0.4 0.368 0.746 0.368 0.261 0 0.267-0.005 0.267-0.16 0-0.139-0.021-0.16-0.144-0.16-0.203 0-0.485-0.181-0.522-0.331-0.011-0.069-0.032-0.501-0.037-0.96l-0.016-0.837-0.155-0.16c-0.091-0.091-0.197-0.165-0.24-0.165-0.053 0-0.021-0.043 0.075-0.107 0.304-0.197 0.347-0.357 0.347-1.306 0.005-0.586 0.021-0.88 0.069-0.938 0.096-0.128 0.277-0.208 0.459-0.208 0.155 0 0.165-0.016 0.165-0.187v-0.187h-0.251c-0.144 0-0.336 0.043-0.437 0.096z"></path><path d="M14.294 5.657c0 0.171 0.011 0.181 0.219 0.208 0.416 0.053 0.443 0.123 0.475 1.173 0.027 0.965 0.059 1.088 0.293 1.242l0.123 0.080-0.192 0.181-0.197 0.176-0.027 0.901c-0.016 0.565-0.053 0.938-0.091 1.008-0.069 0.117-0.32 0.235-0.501 0.235-0.075 0-0.101 0.037-0.101 0.16 0 0.16 0.005 0.16 0.283 0.16 0.181 0 0.336-0.037 0.448-0.107 0.315-0.192 0.336-0.267 0.352-1.274l0.011-0.922 0.176-0.155c0.096-0.085 0.229-0.155 0.304-0.155 0.117 0 0.133-0.021 0.133-0.187s-0.016-0.187-0.181-0.219c-0.101-0.016-0.24-0.091-0.309-0.165-0.117-0.128-0.123-0.165-0.133-1.093-0.011-1.088-0.032-1.157-0.405-1.328-0.123-0.053-0.325-0.101-0.448-0.101-0.224 0-0.229 0.005-0.229 0.181z"></path></symbol><symbol id="userrole" viewBox="0 0 16 16"><path d="M4.667 12.667q0 0.271-0.198 0.469t-0.469 0.198-0.469-0.198-0.198-0.469 0.198-0.469 0.469-0.198 0.469 0.198 0.198 0.469zM15.333 13.302q0 1.26-0.76 1.979t-2.021 0.719h-9.104q-1.26 0-2.021-0.719t-0.76-1.979q0-0.708 0.057-1.365t0.25-1.437 0.495-1.38 0.844-1.073 1.25-0.63q-0.229 0.542-0.229 1.25v2.115q-0.604 0.208-0.969 0.729t-0.365 1.156q0 0.833 0.583 1.417t1.417 0.583 1.417-0.583 0.583-1.417q0-0.635-0.37-1.156t-0.964-0.729v-2.115q0-0.646 0.26-0.969 1.375 1.083 3.073 1.083t3.073-1.083q0.26 0.323 0.26 0.969v0.667q-1.104 0-1.885 0.781t-0.781 1.885v0.927q-0.333 0.302-0.333 0.74 0 0.417 0.292 0.708t0.708 0.292 0.708-0.292 0.292-0.708q0-0.438-0.333-0.74v-0.927q0-0.542 0.396-0.937t0.937-0.396 0.937 0.396 0.396 0.937v0.927q-0.333 0.302-0.333 0.74 0 0.417 0.292 0.708t0.708 0.292 0.708-0.292 0.292-0.708q0-0.438-0.333-0.74v-0.927q0-0.708-0.359-1.328t-0.974-0.974q0-0.104 0.005-0.443t0-0.5-0.026-0.432-0.073-0.49-0.135-0.417q0.708 0.156 1.25 0.63t0.844 1.073 0.495 1.38 0.25 1.437 0.057 1.365zM12 4q0 1.656-1.172 2.828t-2.828 1.172-2.828-1.172-1.172-2.828 1.172-2.828 2.828-1.172 2.828 1.172 1.172 2.828z"></path></symbol><symbol id="addfile" viewBox="0 0 16 16"><path d="M10.667 3.81v1.524h-4.571v-1.524h4.571zM10.667 6.857h-6.857v-0.762h6.857v0.762zM3.81 7.619h6.095v0.762h-6.095v-0.762zM3.81 9.905v-0.762h5.333v0.762h-5.333zM10.667 9.143h2.286v2.286h2.286v2.286h-2.286v2.286h-2.286v-2.286h-2.286v-2.286h2.286v-2.286zM13.714 0v7.619h-1.524v-6.095h-9.905v12.952h5.061l0.762 1.524h-7.347v-16h12.952z"></path></symbol><symbol id="flag" viewBox="0 0 16 16"><path d="M15.754 3.619c-8.178 11.881-5.379-0.228-12.292 5.567l1.572 6.182h-1.768l-3.209-12.619 1.62-0.581c7.749-5.667 3.702 5.097 13.693 1.098 0.319-0.129 0.574 0.079 0.384 0.354z"></path></symbol><symbol id="remove" viewBox="0 0 32 32"><path d="M5 10v20c0 1.1 0.9 2 2 2h18c1.1 0 2-0.9 2-2v-20h-22zM11 28h-2v-14h2v14zM15 28h-2v-14h2v14zM19 28h-2v-14h2v14zM23 28h-2v-14h2v14z"></path><path d="M27.5 4h-6.5v-2.5c0-0.825-0.675-1.5-1.5-1.5h-7c-0.825 0-1.5 0.675-1.5 1.5v2.5h-6.5c-0.825 0-1.5 0.675-1.5 1.5v2.5h26v-2.5c0-0.825-0.675-1.5-1.5-1.5zM19 4h-6v-1.975h6v1.975z"></path></symbol><symbol id="refresh" viewBox="0 0 32 32"><path d="M27.802 5.197c-2.925-3.194-7.13-5.197-11.803-5.197-8.837 0-16 7.163-16 16h3c0-7.18 5.82-13 13-13 3.844 0 7.298 1.669 9.678 4.322l-4.678 4.678h11v-11l-4.198 4.197zM29 16c0 7.18-5.82 13-13 13-3.844 0-7.298-1.669-9.678-4.322l4.678-4.678h-11v11l4.197-4.197c2.925 3.194 7.13 5.197 11.803 5.197 8.837 0 16-7.163 16-16h-3z"></path></symbol><symbol id="google" viewBox="0 0 32 32"><path d="M19.958 16.236q0 2.889-1.208 5.146t-3.444 3.528-5.125 1.271q-2.069 0-3.958-0.806t-3.25-2.167-2.167-3.25-0.806-3.958 0.806-3.958 2.167-3.25 3.25-2.167 3.958-0.806q3.972 0 6.819 2.667l-2.764 2.653q-1.625-1.569-4.056-1.569-1.708 0-3.16 0.861t-2.299 2.34-0.847 3.229 0.847 3.229 2.299 2.34 3.16 0.861q1.153 0 2.118-0.319t1.59-0.799 1.090-1.090 0.681-1.153 0.299-1.028h-5.778v-3.5h9.611q0.167 0.875 0.167 1.694zM32 14.542v2.917h-2.903v2.903h-2.917v-2.903h-2.903v-2.917h2.903v-2.903h2.917v2.903h2.903z"></path></symbol><symbol id="wechat" viewBox="0 0 32 32"><path d="M9.062 9.203q0-0.641-0.391-1.031t-1.031-0.391q-0.672 0-1.188 0.398t-0.516 1.023q0 0.609 0.516 1.008t1.188 0.398q0.641 0 1.031-0.383t0.391-1.023zM20.672 17.125q0-0.438-0.398-0.781t-1.023-0.344q-0.422 0-0.773 0.352t-0.352 0.773q0 0.438 0.352 0.789t0.773 0.352q0.625 0 1.023-0.344t0.398-0.797zM16.984 9.203q0-0.641-0.383-1.031t-1.023-0.391q-0.672 0-1.188 0.398t-0.516 1.023q0 0.609 0.516 1.008t1.188 0.398q0.641 0 1.023-0.383t0.383-1.023zM26.906 17.125q0-0.438-0.406-0.781t-1.016-0.344q-0.422 0-0.773 0.352t-0.352 0.773q0 0.438 0.352 0.789t0.773 0.352q0.609 0 1.016-0.344t0.406-0.797zM22.75 10.922q-0.484-0.063-1.094-0.063-2.641 0-4.859 1.203t-3.492 3.258-1.273 4.492q0 1.219 0.359 2.375-0.547 0.047-1.062 0.047-0.406 0-0.781-0.023t-0.859-0.102-0.695-0.109-0.852-0.164-0.781-0.164l-3.953 1.984 1.125-3.406q-4.531-3.172-4.531-7.656 0-2.641 1.523-4.859t4.125-3.492 5.68-1.273q2.75 0 5.195 1.031t4.094 2.852 2.133 4.070zM32 19.688q0 1.828-1.070 3.492t-2.898 3.023l0.859 2.828-3.109-1.703q-2.344 0.578-3.406 0.578-2.641 0-4.859-1.102t-3.492-2.992-1.273-4.125 1.273-4.125 3.492-2.992 4.859-1.102q2.516 0 4.734 1.102t3.555 3 1.336 4.117z"></path></symbol><symbol id="weibo" viewBox="0 0 32 32"><path d="M13.242 27.106c-5.22 0.517-9.727-1.847-10.065-5.27-0.339-3.429 3.62-6.618 8.834-7.135 5.22-0.517 9.727 1.847 10.059 5.27 0.345 3.429-3.614 6.624-8.828 7.135zM23.677 15.735c-0.443-0.135-0.751-0.222-0.517-0.806 0.505-1.268 0.554-2.358 0.006-3.14-1.022-1.459-3.823-1.385-7.030-0.037 0 0-1.010 0.437-0.751-0.357 0.492-1.588 0.419-2.912-0.351-3.681-1.742-1.742-6.372 0.068-10.342 4.038-2.967 2.961-4.691 6.119-4.691 8.846 0 5.208 6.686 8.379 13.224 8.379 8.569 0 14.276-4.98 14.276-8.933 0-2.395-2.013-3.749-3.823-4.309z"></path><path d="M29.371 6.193c-2.069-2.296-5.122-3.17-7.942-2.573v0c-0.653 0.142-1.065 0.782-0.923 1.428 0.142 0.653 0.776 1.065 1.428 0.923 2.007-0.425 4.174 0.197 5.645 1.828s1.872 3.854 1.237 5.799v0c-0.203 0.634 0.142 1.311 0.776 1.521 0.634 0.203 1.311-0.142 1.521-0.776v-0.006c0.887-2.721 0.326-5.848-1.742-8.145z"></path><path d="M26.189 9.068c-1.010-1.12-2.499-1.545-3.866-1.25-0.56 0.117-0.917 0.677-0.8 1.237 0.123 0.56 0.677 0.917 1.231 0.794v0c0.671-0.142 1.397 0.068 1.89 0.609 0.492 0.548 0.628 1.293 0.412 1.945v0c-0.172 0.542 0.123 1.133 0.671 1.311 0.548 0.172 1.133-0.123 1.311-0.671 0.431-1.336 0.16-2.863-0.85-3.977z"></path><path d="M13.531 20.907c-0.185 0.314-0.585 0.462-0.899 0.332-0.314-0.123-0.406-0.48-0.228-0.782 0.185-0.302 0.573-0.449 0.88-0.332 0.308 0.111 0.419 0.462 0.246 0.782zM11.863 23.037c-0.505 0.806-1.588 1.157-2.401 0.788-0.8-0.363-1.040-1.299-0.536-2.087 0.499-0.782 1.545-1.133 2.352-0.794 0.819 0.351 1.084 1.28 0.585 2.093zM13.759 17.336c-2.481-0.646-5.288 0.591-6.366 2.776-1.102 2.229-0.037 4.709 2.469 5.522 2.598 0.837 5.664-0.449 6.729-2.85 1.053-2.358-0.259-4.777-2.832-5.448z"></path></symbol><symbol id="twitter" viewBox="0 0 32 32"><path d="M32 6.077c-1.175 0.525-2.443 0.875-3.768 1.031 1.356-0.812 2.393-2.1 2.887-3.631-1.268 0.75-2.674 1.3-4.168 1.593-1.2-1.275-2.906-2.068-4.793-2.068-3.624 0-6.561 2.937-6.561 6.561 0 0.512 0.056 1.012 0.169 1.493-5.455-0.275-10.292-2.887-13.529-6.861-0.562 0.969-0.887 2.1-0.887 3.299 0 2.275 1.156 4.287 2.918 5.461-1.075-0.031-2.087-0.331-2.974-0.819 0 0.025 0 0.056 0 0.081 0 3.181 2.262 5.836 5.268 6.436-0.55 0.15-1.131 0.231-1.731 0.231-0.425 0-0.831-0.044-1.237-0.119 0.837 2.606 3.262 4.505 6.13 4.562-2.25 1.762-5.074 2.812-8.155 2.812-0.531 0-1.050-0.031-1.568-0.094 2.912 1.868 6.361 2.949 10.067 2.949 12.073 0 18.678-10.004 18.678-18.678 0-0.287-0.006-0.569-0.019-0.85 1.281-0.919 2.393-2.075 3.274-3.393z"></path></symbol><symbol id="link" viewBox="0 0 32 32"><path d="M29.187 2.933l-0.12-0.121c-2.813-2.812-7.415-2.812-10.228 0l-6.516 6.517c-2.812 2.812-2.812 7.415 0 10.227l0.12 0.12c0.234 0.234 0.482 0.446 0.739 0.641l2.386-2.386c-0.278-0.164-0.542-0.361-0.78-0.599l-0.121-0.121c-1.527-1.527-1.527-4.012 0-5.539l6.517-6.516c1.527-1.527 4.012-1.527 5.539 0l0.121 0.12c1.527 1.527 1.527 4.012 0 5.539l-2.948 2.948c0.512 1.264 0.754 2.611 0.733 3.955l4.559-4.559c2.812-2.812 2.812-7.415-0-10.227zM19.557 12.323c-0.234-0.234-0.482-0.446-0.739-0.641l-2.386 2.385c0.278 0.164 0.542 0.361 0.78 0.599l0.121 0.121c1.527 1.527 1.527 4.012 0 5.539l-6.517 6.517c-1.527 1.527-4.012 1.527-5.539 0l-0.121-0.121c-1.527-1.527-1.527-4.012 0-5.539l2.948-2.948c-0.512-1.264-0.754-2.611-0.733-3.955l-4.559 4.559c-2.812 2.812-2.812 7.415 0 10.228l0.12 0.12c2.813 2.812 7.415 2.812 10.228 0l6.516-6.517c2.812-2.812 2.812-7.415 0-10.228l-0.12-0.12z"></path></symbol><symbol id="qq" viewBox="0 0 32 32"><path d="M4.821 14.393c-0.125-0.304-0.143-0.607-0.143-0.929 0-0.5 0.321-1.304 0.625-1.679-0.018-0.464 0.179-1.411 0.536-1.714 0-3.304 2.554-7.464 5.536-8.893 1.839-0.875 3.768-1.179 5.786-1.179 1.571 0 3.286 0.375 4.75 0.982 4.196 1.768 5.143 5.054 6.036 9.25l0.018 0.089c0.518 0.786 0.982 1.714 0.982 2.679 0 0.482-0.321 0.964-0.321 1.393 0 0.036 0.107 0.179 0.125 0.214 1.536 2.268 2.929 4.732 2.929 7.554 0 0.625-0.339 2.804-1.339 2.804-0.696 0-1.464-1.696-1.714-2.161-0.018-0.018-0.036-0.018-0.054-0.018l-0.089 0.071c-0.571 1.482-1.196 2.875-2.357 3.982 1.018 0.982 2.661 0.893 2.964 2.589-0.089 0.196-0.054 0.411-0.196 0.607-1.018 1.536-3.75 1.732-5.393 1.732-2.179 0-3.946-0.571-6-1.179-0.429-0.125-1.071-0.054-1.536-0.107-1.089 1.196-3.75 1.518-5.286 1.518-1.357 0-6.607-0.089-6.607-2.411 0-1 0.214-1.286 0.911-1.929 0.554-0.107 0.964-0.411 1.607-0.446 0.089 0 0.161-0.018 0.25-0.036 0.018-0.018 0.036-0.018 0.036-0.071l-0.036-0.054c-1.232-0.286-2.964-3.393-3.232-4.679l-0.089-0.054c-0.125 0-0.179 0.268-0.214 0.357-0.393 0.911-1.321 1.893-2.357 2h-0.018c-0.143 0-0.089-0.143-0.196-0.179-0.25-0.589-0.411-1.125-0.411-1.786 0-3.571 1.714-6.214 4.5-8.321z"></path></symbol><symbol id="github" viewBox="0 0 32 32"><path d="M16 0.331c-8.836 0-16 7.163-16 16 0 7.069 4.585 13.067 10.942 15.182 0.8 0.148 1.094-0.347 1.094-0.77 0-0.381-0.015-1.642-0.022-2.979-4.452 0.968-5.391-1.888-5.391-1.888-0.728-1.849-1.776-2.341-1.776-2.341-1.452-0.993 0.11-0.973 0.11-0.973 1.606 0.113 2.452 1.649 2.452 1.649 1.427 2.446 3.743 1.739 4.656 1.33 0.143-1.034 0.558-1.74 1.016-2.14-3.554-0.404-7.29-1.777-7.29-7.907 0-1.747 0.625-3.174 1.649-4.295-0.166-0.403-0.714-2.030 0.155-4.234 0 0 1.344-0.43 4.401 1.64 1.276-0.355 2.645-0.532 4.005-0.539 1.359 0.006 2.729 0.184 4.008 0.539 3.054-2.070 4.395-1.64 4.395-1.64 0.871 2.204 0.323 3.831 0.157 4.234 1.026 1.12 1.647 2.548 1.647 4.295 0 6.145-3.743 7.498-7.306 7.895 0.574 0.497 1.085 1.47 1.085 2.963 0 2.141-0.019 3.864-0.019 4.391 0 0.426 0.288 0.925 1.099 0.768 6.354-2.118 10.933-8.113 10.933-15.18 0-8.837-7.164-16-16-16z"></path></symbol><symbol id="tags" viewBox="0 0 34 32"><path d="M31.004 1.996h-6.991c-1.648 0-3.949 0.953-5.115 2.119l-11.742 11.742c-1.165 1.165-1.165 3.072 0 4.237l8.746 8.746c1.165 1.165 3.072 1.165 4.237 0l11.742-11.742c1.165-1.165 2.119-3.467 2.119-5.115v-6.991c0-1.648-1.348-2.996-2.996-2.996zM27.009 11.983c-1.655 0-2.996-1.341-2.996-2.996s1.341-2.996 2.996-2.996 2.996 1.341 2.996 2.996-1.341 2.996-2.996 2.996zM2.749 18.681l10.685 10.685c-1.132 0.598-2.573 0.422-3.523-0.527l-8.746-8.746c-1.165-1.165-1.165-3.072 0-4.237l11.742-11.742c1.165-1.165 3.467-2.119 5.115-2.119l-15.273 15.273c-0.388 0.388-0.388 1.024 0 1.412z"></path></symbol><symbol id="articles" viewBox="0 0 32 32"><path d="M28.681 11.159c-0.694-0.947-1.662-2.053-2.724-3.116s-2.169-2.030-3.116-2.724c-1.612-1.182-2.393-1.319-2.841-1.319h-11.5c-1.379 0-2.5 1.121-2.5 2.5v23c0 1.378 1.121 2.5 2.5 2.5h19c1.378 0 2.5-1.122 2.5-2.5v-15.5c0-0.448-0.137-1.23-1.319-2.841zM24.543 9.457c0.959 0.959 1.712 1.825 2.268 2.543h-4.811v-4.811c0.718 0.556 1.584 1.309 2.543 2.268v0zM28 29.5c0 0.271-0.229 0.5-0.5 0.5h-19c-0.271 0-0.5-0.229-0.5-0.5v-23c0-0.271 0.229-0.5 0.5-0.5 0 0 11.499-0 11.5 0v7c0 0.552 0.448 1 1 1h7v15.5zM18.841 1.319c-1.612-1.182-2.393-1.319-2.841-1.319h-11.5c-1.378 0-2.5 1.121-2.5 2.5v23c0 1.207 0.86 2.217 2 2.45v-25.45c0-0.271 0.229-0.5 0.5-0.5h15.215c-0.301-0.248-0.595-0.477-0.873-0.681z"></path></symbol><symbol id="article" viewBox="0 0 32 32"><path d="M32 4h-32v-4h32zM20 12h-20v-4h20zM32 24h-32v-4h32zM24 32h-24v-4h24zM32 30c0 1.105-0.897 2-1.998 2-1.108 0-2.002-0.895-2.002-2s0.894-2 2.002-2c1.101 0 1.998 0.895 1.998 2z"></path></symbol><symbol id="video" viewBox="0 0 32 32"><path d="M18.286 5.714c-1.262 0-2.286 1.023-2.286 2.286s1.023 2.286 2.286 2.286 2.286-1.023 2.286-2.286-1.023-2.286-2.286-2.286zM29.714 12.571l-4.571 4.571v-2.286c0-1.094-0.768-2.008-1.795-2.232 1.115-1.219 1.795-2.843 1.795-4.625 0-3.787-3.070-6.857-6.857-6.857-3.612 0-6.571 2.792-6.838 6.335-1.216-1.096-2.825-1.764-4.591-1.764-3.787 0-6.857 3.070-6.857 6.857s3.070 6.857 6.857 6.857h-2.286v4.571h2.286v4.571c0 1.262 1.023 2.286 2.286 2.286h13.714c1.262 0 2.286-1.023 2.286-2.286v-2.286l4.571 4.571h2.286v-18.286h-2.286zM6.857 10.286c-1.262 0-2.286 1.023-2.286 2.286s1.023 2.286 2.286 2.286v2.286c-2.525 0-4.571-2.047-4.571-4.571s2.047-4.571 4.571-4.571 4.571 2.047 4.571 4.571h-2.286c0-1.262-1.023-2.286-2.286-2.286zM18.286 24h-4.571v-4.571h4.571v4.571zM22.857 20.1c-1.197-1.198-2.51-2.511-2.62-2.622-0.207-0.207-0.492-0.335-0.808-0.335h-6.857c-0.631 0-1.143 0.512-1.143 1.143v6.857c0 0.297 0.114 0.568 0.3 0.772 0.019 0.021 1.397 1.399 2.657 2.657h-4.1c-0.631 0-1.143-0.512-1.143-1.143v-11.429c0-0.631 0.512-1.143 1.143-1.143h11.429c0.631 0 1.143 0.512 1.143 1.143v4.1zM18.286 12.571c-2.525 0-4.571-2.047-4.571-4.571s2.047-4.571 4.571-4.571 4.571 2.047 4.571 4.571c0 2.525-2.047 4.571-4.571 4.571zM29.714 24l-2.286-2.286 0.003-4.574 2.283-2.283v9.143z"></path></symbol><symbol id="locked" viewBox="0 0 32 32"><path d="M3.31 32v-17.655h3.31v-5.517c0-4.875 3.951-8.828 8.828-8.828h1.103c4.875 0 8.828 3.953 8.828 8.828v5.517h3.31v17.655h-25.379zM15.166 22.937l-0.821 5.752h3.31l-0.822-5.752c0.804-0.329 1.374-1.118 1.374-2.041 0-1.218-0.989-2.207-2.207-2.207-1.219 0-2.207 0.989-2.207 2.207 0 0.924 0.568 1.713 1.373 2.041zM22.069 9.379c0-3.352-2.718-6.069-6.069-6.069-3.352 0-6.069 2.717-6.069 6.069v4.966h12.138v-4.966z"></path></symbol><symbol id="feed" viewBox="0 0 32 32"><path d="M12 16c0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.209-1.791 4-4 4s-4-1.791-4-4zM20.761 7.204c3.12 1.692 5.239 4.997 5.239 8.796s-2.119 7.104-5.239 8.796c1.377-2.191 2.239-5.321 2.239-8.796s-0.862-6.605-2.239-8.796zM9 16c0 3.475 0.862 6.605 2.239 8.796-3.12-1.692-5.239-4.997-5.239-8.796s2.119-7.104 5.239-8.796c-1.377 2.191-2.239 5.321-2.239 8.796zM3 16c0 5.372 1.7 10.193 4.395 13.491-4.447-2.842-7.395-7.822-7.395-13.491s2.948-10.649 7.395-13.491c-2.695 3.298-4.395 8.119-4.395 13.491zM24.605 2.509c4.447 2.842 7.395 7.822 7.395 13.491s-2.948 10.649-7.395 13.491c2.695-3.298 4.395-8.119 4.395-13.491s-1.7-10.193-4.395-13.491z"></path></symbol><symbol id="perfect" viewBox="0 0 28 32"><path d="M22.93 19.257c-0.052 0.155-0.090 0.306-0.099 0.442-0.081 1.367-1.258 2.524-2.626 2.579-0.571 0.022-1.473 0.533-1.788 1.012-0.171 0.259-0.389 0.482-0.639 0.666l5.296 5.296v-4.926h4.926l-5.070-5.070zM9.961 23.924c-0.276-0.197-0.526-0.427-0.708-0.714-0.318-0.502-1.177-1.008-1.769-1.042-1.367-0.081-2.524-1.259-2.581-2.626-0.005-0.104-0.039-0.224-0.070-0.341l-4.833 4.833h4.926v4.926l5.036-5.035zM24.046 11.892c0.419-0.798 0.145-1.851-0.606-2.346-0.753-0.496-1.395-1.632-1.433-2.533s-0.8-1.676-1.7-1.729c-0.884-0.052-2.031-0.728-2.506-1.476-0.456-0.718-1.568-1.033-2.337-0.648-0.756 0.38-2.16 0.367-2.909-0.025-0.739-0.387-1.892-0.083-2.346 0.607-0.481 0.728-1.664 1.398-2.533 1.433-0.884 0.036-1.677 0.815-1.728 1.699-0.053 0.883-0.728 2.031-1.476 2.506-0.761 0.483-1.053 1.531-0.648 2.337 0.403 0.806 0.393 2.11-0.025 2.909-0.419 0.798-0.145 1.851 0.606 2.346 0.753 0.496 1.395 1.631 1.433 2.531s0.8 1.677 1.7 1.731c0.884 0.052 2.031 0.728 2.506 1.476 0.456 0.718 1.57 1.033 2.336 0.648 0.368-0.185 0.871-0.287 1.418-0.287 0.577 0 1.106 0.11 1.491 0.312 0.382 0.199 0.848 0.246 1.287 0.134 0.446-0.115 0.822-0.379 1.061-0.741 0.48-0.729 1.664-1.399 2.533-1.433 0.884-0.035 1.675-0.814 1.728-1.699 0.052-0.884 0.728-2.032 1.476-2.506 0.761-0.483 1.052-1.531 0.648-2.337-0.406-0.806-0.394-2.11 0.023-2.909zM13.923 21.196c-4.372 0-7.93-3.557-7.93-7.93s3.557-7.93 7.93-7.93 7.93 3.557 7.93 7.93-3.557 7.93-7.93 7.93zM13.923 6.272c-3.856 0-6.993 3.138-6.993 6.993s3.138 6.993 6.993 6.993 6.993-3.138 6.993-6.993-3.138-6.993-6.993-6.993z"></path></symbol><symbol id="view" viewBox="0 0 32 32"><path d="M16 7.53c-10.379 0-15.561 7.594-15.777 7.918-0.223 0.335-0.223 0.771 0 1.106 0.216 0.323 5.398 7.917 15.777 7.917s15.561-7.594 15.777-7.918c0.223-0.335 0.223-0.771 0-1.106-0.216-0.323-5.398-7.917-15.777-7.917zM16 22.477c-7.726 0-12.34-4.822-13.696-6.479 1.352-1.661 5.941-6.475 13.696-6.475 7.726 0 12.34 4.822 13.696 6.479-1.352 1.661-5.941 6.475-13.696 6.475zM16 11.516c-2.473 0-4.484 2.012-4.484 4.484s2.011 4.484 4.484 4.484 4.484-2.012 4.484-4.484-2.011-4.484-4.484-4.484zM16 18.491c-1.374 0-2.491-1.118-2.491-2.491s1.118-2.491 2.491-2.491 2.491 1.118 2.491 2.491-1.118 2.491-2.491 2.491z"></path></symbol><symbol id="local" viewBox="0 0 32 32"><path d="M16 0c-6.62 0-12 5-12 11 0 9.040 12 21 12 21s12-11.96 12-21c0-6-5.38-11-12-11zM16 29.1c-3.72-4.060-10-12.22-10-18.1 0-4.96 4.5-9 10-9 2.68 0 5.22 0.96 7.12 2.72 1.84 1.72 2.88 3.94 2.88 6.28 0 5.88-6.28 14.040-10 18.1zM20 11c0 2.22-1.78 4-4 4s-4-1.78-4-4 1.78-4 4-4 4 1.78 4 4z"></path></symbol><symbol id="star" viewBox="0 0 32 32"><path d="M21.865 19.433l5.885-5.712-8.115-1.192-3.635-7.346-3.635 7.346-8.115 1.192 5.885 5.712-1.404 8.096 7.269-3.827 7.25 3.827zM32 12.567q0 0.423-0.5 0.923l-6.981 6.808 1.654 9.615q0.019 0.135 0.019 0.385 0 0.962-0.788 0.962-0.365 0-0.769-0.231l-8.635-4.538-8.635 4.538q-0.423 0.231-0.769 0.231-0.404 0-0.606-0.279t-0.202-0.683q0-0.115 0.038-0.385l1.654-9.615-7-6.808q-0.481-0.519-0.481-0.923 0-0.712 1.077-0.885l9.654-1.404 4.327-8.75q0.365-0.788 0.942-0.788t0.942 0.788l4.327 8.75 9.654 1.404q1.077 0.173 1.077 0.885z"></path></symbol><symbol id="goods" viewBox="0 0 32 32"><path d="M32 16.665h-13.99v-2.010h11.98v-3.98h-27.98v3.98h11.98v2.010h-13.99v-8h32z"></path><path d="M4.020 29.631h23.961v2.010h-23.961v-2.010z"></path><path d="M2.995 15.68h2.010v15.961h-2.010v-15.961z"></path><path d="M26.995 15.68h2.010v15.961h-2.010v-15.961z"></path><path d="M18.995 31.64h-5.99v-22.975h5.99v22.975zM15.015 29.631h1.97v-18.956h-1.97v18.956z"></path><path d="M15.267 10.259c-1.364 0-3.901-0.249-5.567-1.916-1.097-1.096-1.89-2.386-2.234-3.633-0.398-1.444-0.166-2.691 0.654-3.51 0.551-0.55 1.312-0.84 2.203-0.84 1.576 0 3.423 0.905 4.94 2.421 2.337 2.336 1.889 6.385 1.869 6.556l-0.092 0.782-0.782 0.093c-0.041 0.005-0.416 0.047-0.99 0.047zM10.323 2.357c-0.355 0-0.621 0.086-0.792 0.256-0.285 0.284-0.336 0.855-0.14 1.566 0.25 0.905 0.877 1.908 1.721 2.752 1.126 1.127 2.997 1.321 4.069 1.33-0.009-1.079-0.204-2.943-1.329-4.068-1.117-1.116-2.502-1.836-3.529-1.836z"></path><path d="M17.178 10.241c-0 0-0 0-0 0-0.574 0-0.949-0.034-0.99-0.039l-0.782-0.088-0.092-0.78c-0.020-0.171-0.469-4.219 1.868-6.555 1.518-1.516 3.364-2.42 4.94-2.42 0.89 0 1.652 0.291 2.203 0.84 0.82 0.82 1.052 2.066 0.654 3.51-0.344 1.246-1.137 2.528-2.234 3.625-1.666 1.666-4.203 1.907-5.567 1.907zM22.123 2.357c-1.027 0-2.412 0.721-3.529 1.837-1.125 1.124-1.32 2.988-1.329 4.068 1.072-0.010 2.942-0.203 4.068-1.33 0.844-0.844 1.471-1.847 1.721-2.752 0.196-0.711 0.145-1.281-0.14-1.566-0.17-0.17-0.436-0.256-0.791-0.256z"></path></symbol><symbol id="bagua" viewBox="0 0 32 32"><path d="M30.523 10.196c-0.343-0.667-0.515-1.391-0.934-2.020-0.8-1.525-1.906-2.935-3.202-4.136-0.686-0.438-1.258-0.991-1.944-1.429-0.61-0.4-1.277-0.724-1.906-1.067-0.972-0.381-1.906-0.781-2.916-1.029-0.4-0.038-0.743-0.229-1.143-0.229l-1.658-0.191c-0.858-0.095-1.753-0.019-2.63 0.038-1.963 0.153-3.697 0.8-5.432 1.563-2.992 1.487-5.679 4.059-7.147 7.109-1.105 2.306-1.715 4.936-1.639 7.452 0 0.324 0.095 0.8 0.057 1.105 0.152 0.591 0.133 1.143 0.286 1.696 0.915 4.25 3.64 8.214 7.642 10.444 0.724 0.534 1.563 0.762 2.363 1.086 2.821 1.067 6.385 1.258 9.358 0.457 4.25-0.972 8.176-4.040 10.139-8.062 0.038-0.038 0.095-0.038 0.057-0.114 1.906-3.85 2.23-8.538 0.648-12.674zM12.341 7.128c0.495-0.419 1.105-0.762 1.849-0.591 0.534 0.133 0.991 0.515 1.277 1.010 0.267 0.495 0.362 1.315 0 1.811-0.324 0.553-0.953 1.010-1.601 1.029-0.743-0.038-1.544-0.362-1.83-1.125-0.4-0.705-0.172-1.525 0.305-2.134zM29.474 22.031c-1.258 2.916-3.869 5.718-6.747 7.090-0.896 0.476-1.811 0.915-2.802 1.067-0.438 0-0.819 0.114-1.258 0.114l-1.143-0.114c-0.247-0.057-0.476-0.229-0.743-0.172-1.296-0.21-2.497-0.915-3.488-1.849-1.811-1.868-2.535-4.631-1.811-7.052 0.362-1.201 1.086-2.344 2.039-3.202 1.163-0.82 2.344-1.582 3.469-2.516 1.353-0.972 2.859-2.020 3.507-3.583 0.534-0.781 0.629-1.734 0.8-2.668 0.286-2.783-1.086-5.66-3.602-7.109-0.495-0.343-1.086-0.496-1.601-0.781-0.591-0.095-1.105-0.343-1.677-0.343-0.057-0.038 0.019-0.038-0.019-0.057 1.372-0.229 3.145-0.076 4.593 0.229 3.888 0.82 7.585 3.411 9.643 6.88l0.591 1.048c2.039 3.85 2.135 9.148 0.248 13.017zM19.983 22.66c0.248 0.743 0.076 1.62-0.514 2.173-0.553 0.4-1.258 0.743-1.963 0.496-0.534-0.191-1.086-0.591-1.353-1.086-0.248-0.534-0.172-1.22 0.076-1.734 0.362-0.705 1.144-0.972 1.811-1.22 0.858-0.019 1.62 0.61 1.944 1.372zM21.942 33.581l-0.019 0.019-0.057-0.076c0.019 0.019 0.038 0.038 0.076 0.057zM19.655 33.962h0.019zM19.445 33.981c0 0.019-0.019 0.019-0.057 0.019 0.019-0.038 0.038-0.019 0.057-0.019z"></path></symbol><symbol id="book" viewBox="0 0 32 32"><path d="M16 29.987c-2.607-4.267-16-3.556-16-3.556s0-21.689 0-21.689c0 0 1.422 0 1.422 0s0 20.267 0 20.267c12.533 0 14.578 3.2 14.578 3.2 3.644-3.763 14.578-3.2 14.578-3.2s0-20.267 0-20.267c0 0 1.422 0 1.422 0s0 21.689 0 21.689c-13.778-0.8-16 3.556-16 3.556zM16 26.431c-3.122-3.142-13.156-2.878-13.156-2.878s0-21.3 0-21.3c0 0 10.033-0.24 13.156 2.902 3.122-3.142 13.156-2.902 13.156-2.902s0 21.3 0 21.3c0 0-10.033-0.264-13.156 2.878zM4.257 22.088c0 0 7.685-0.202 11.031 2.018 0 0 0-17.814 0-17.814-3.346-2.304-11.031-2.669-11.031-2.669s0 18.464 0 18.464zM27.743 3.624c0 0-7.685 0.365-11.031 2.669 0 0 0 17.814 0 17.814 3.346-2.22 11.031-2.018 11.031-2.018s0-18.464 0-18.464z"></path></symbol><symbol id="check" viewBox="0 0 32 32"><path d="M32 7.333l-21.333 21.333-10.667-10.667 4-4 6.667 6.667 17.333-17.333z"></path></symbol>';
svg += '<symbol id="emoji" viewBox="0 0 32 32"><path d="M16 24.789c-3.756 0-6.911-2.254-8.188-5.559h16.376c-1.277 3.305-4.432 5.559-8.188 5.559zM10.366 14.423c-1.352 0-2.404-1.052-2.404-2.404s1.052-2.404 2.404-2.404 2.404 1.052 2.404 2.404-1.052 2.404-2.404 2.404zM21.634 14.423c-1.352 0-2.404-1.052-2.404-2.404s1.052-2.404 2.404-2.404 2.404 1.052 2.404 2.404-1.052 2.404-2.404 2.404zM16 28.845c7.061 0 12.845-5.784 12.845-12.845s-5.784-12.845-12.845-12.845-12.845 5.784-12.845 12.845 5.784 12.845 12.845 12.845zM16 0c8.864 0 16 7.136 16 16s-7.136 16-16 16-16-7.136-16-16 7.136-16 16-16z"></path></symbol>';
svg += '<symbol id="bold" viewBox="0 0 32 32"><path d="M22.996 15.023c1.339-1.591 2.147-3.643 2.147-5.88 0-5.041-4.102-9.143-9.143-9.143h-11.429v32h13.714c5.041 0 9.143-4.102 9.143-9.143 0-3.32-1.779-6.232-4.433-7.834zM11.429 4.571h3.625c1.999 0 3.625 2.051 3.625 4.571s-1.626 4.571-3.625 4.571h-3.625v-9.143zM17.107 27.429h-5.679v-9.143h5.679c2.087 0 3.786 2.051 3.786 4.571s-1.698 4.571-3.786 4.571z"></path></symbol>';
svg += '<symbol id="italic" viewBox="0 0 32 32"><path d="M29.714 0v2.286h-4.571l-11.429 27.429h4.571v2.286h-16v-2.286h4.571l11.429-27.429h-4.571v-2.286z"></path></symbol>';
svg += '<symbol id="quote" viewBox="0 0 32 32"><path d="M7.024 13.003c3.862 0 6.993 3.131 6.993 6.993s-3.131 6.993-6.993 6.993-6.993-3.131-6.993-6.993l-0.031-0.999c0-7.724 6.262-13.986 13.986-13.986v3.996c-2.668 0-5.177 1.039-7.064 2.926-0.363 0.363-0.695 0.75-0.994 1.156 0.357-0.056 0.723-0.086 1.096-0.086zM25.007 13.003c3.862 0 6.993 3.131 6.993 6.993s-3.131 6.993-6.993 6.993-6.993-3.131-6.993-6.993l-0.031-0.999c0-7.724 6.262-13.986 13.986-13.986v3.996c-2.668 0-5.177 1.039-7.064 2.926-0.363 0.363-0.695 0.75-0.994 1.156 0.357-0.056 0.723-0.086 1.096-0.086z"></path></symbol>';
svg += '<symbol id="unordered-list" viewBox="0 0 32 32"><path d="M12 2h20v4h-20v-4zM12 14h20v4h-20v-4zM12 26h20v4h-20v-4zM0 4c0 2.209 1.791 4 4 4s4-1.791 4-4c0-2.209-1.791-4-4-4s-4 1.791-4 4zM0 16c0 2.209 1.791 4 4 4s4-1.791 4-4c0-2.209-1.791-4-4-4s-4 1.791-4 4zM0 28c0 2.209 1.791 4 4 4s4-1.791 4-4c0-2.209-1.791-4-4-4s-4 1.791-4 4z"></path></symbol>';
svg += '<symbol id="ordered-list" viewBox="0 0 32 32"><path d="M11 26h20v4h-20zM11 14h20v4h-20zM11 2h20v4h-20zM5 0v8h-2v-6h-2v-2zM3 16.438v1.563h4v2h-6v-4.563l4-1.875v-1.563h-4v-2h6v4.563zM7 22v10h-6v-2h4v-2h-4v-2h4v-2h-4v-2z"></path></symbol>';
svg += '<symbol id="fullscreen" viewBox="0 0 32 32"><path d="M32 0v13l-5-5-6 6-3-3 6-6-5-5zM14 21l-6 6 5 5h-13v-13l5 5 6-6z"></path></symbol>';
svg += '<symbol id="question" viewBox="0 0 32 32"><path d="M14 22h4v4h-4zM22 8c1.105 0 2 0.895 2 2v6l-6 4h-4v-2l6-4v-2h-10v-4h12zM16 3c-3.472 0-6.737 1.352-9.192 3.808s-3.808 5.72-3.808 9.192c0 3.472 1.352 6.737 3.808 9.192s5.72 3.808 9.192 3.808c3.472 0 6.737-1.352 9.192-3.808s3.808-5.72 3.808-9.192c0-3.472-1.352-6.737-3.808-9.192s-5.72-3.808-9.192-3.808zM16 0v0c8.837 0 16 7.163 16 16s-7.163 16-16 16c-8.837 0-16-7.163-16-16s7.163-16 16-16z"></path></symbol>';
svg += '<symbol id="contract" viewBox="0 0 32 32"><path d="M14 18v13l-5-5-6 6-3-3 6-6-5-5zM32 3l-6 6 5 5h-13v-13l5 5 6-6z"></path></symbol>';
svg += '<symbol id="email" viewBox="0 0 32 32"><path d="M0 25c0 1.473 1.193 2.667 2.667 2.667h26.667c1.473 0 2.667-1.193 2.667-2.667l-0-18c0-1.473-1.193-2.667-2.667-2.667l-26.667 0c-1.473 0-2.667 1.193-2.667 2.667v18zM9.813 16.020l-6.1-6.14c-0.506-0.507-0.506-1.327 0-1.833 0.507-0.507 1.327-0.507 1.833 0l9.733 9.746c0.393 0.387 1.041 0.387 1.427 0l9.746-9.746c0.507-0.507 1.327-0.507 1.833 0s0.507 1.327 0 1.833l-6.107 6.14 6.107 6.099c0.507 0.507 0.507 1.327 0 1.833s-1.327 0.507-1.833 0l-6.1-6.093c0 0-1.906 1.94-2.253 2.287-0.541 0.527-1.287 0.854-2.101 0.854-0.827 0-1.573-0.333-2.113-0.874-0.353-0.347-2.247-2.266-2.247-2.266l-6.094 6.093c-0.506 0.507-1.326 0.507-1.833 0-0.506-0.507-0.506-1.327 0-1.833l6.101-6.1z"></path></symbol>';
svg += '<symbol id="cmts" viewBox="0 0 32 32"><path d="M9.28 19.52v-9.92h-6.080c-1.76 0-3.2 1.44-3.2 3.2v9.6c0 1.76 1.44 3.2 3.2 3.2h1.6v4.8l4.8-4.8h8c1.76 0 3.2-1.44 3.2-3.2v-2.912c-0.102 0.022-0.211 0.034-0.32 0.034h-11.2zM28.8 1.6h-14.4c-1.76 0-3.2 1.44-3.2 3.2v12.8h11.2l4.8 4.8v-4.8h1.6c1.76 0 3.2-1.44 3.2-3.2v-9.6c0-1.76-1.44-3.2-3.2-3.2z"></path></symbol>';
svg += '<symbol id="date" viewBox="0 0 32 32"><path d="M22 0h4v4h-4v-4zM6 0h4v4h-4v-4zM30 0h-2v6h-8v-6h-8v6h-8v-6h-2c-1.105 0-2 0.895-2 2v28c0 1.105 0.894 2 2 2h28c1.105 0 2-0.895 2-2v-28c0-1.105-0.895-2-2-2zM28 28h-24v-18h24v18z"></path></symbol>';
svg += '<symbol id="edit" viewBox="0 0 32 32"><path d="M5 0c-2.761 0-5 2.239-5 5 0 1.126 0.372 2.164 1 3l2 2 7-7-2-2c-0.836-0.628-1.874-1-3-1zM30 23l2 9-9-2-18.5-18.5 7-7 18.5 18.5zM9.638 11.362l14 14 1.724-1.724-14-14-1.724 1.724z"></path></symbol>';
svg += '<symbol id="heart" viewBox="0 0 32 32"><path d="M29.714 10.643q0-1.446-0.384-2.554t-0.982-1.759-1.455-1.063-1.679-0.554-1.75-0.143-2 0.455-1.973 1.143-1.545 1.286-1.071 1.098q-0.321 0.393-0.875 0.393t-0.875-0.393q-0.429-0.5-1.071-1.098t-1.545-1.286-1.973-1.143-2-0.455-1.75 0.143-1.679 0.554-1.455 1.063-0.982 1.759-0.384 2.554q0 3 3.339 6.339l10.375 10 10.357-9.982q3.357-3.357 3.357-6.357zM32 10.643q0 3.946-4.089 8.036l-11.125 10.714q-0.321 0.321-0.786 0.321t-0.786-0.321l-11.143-10.75q-0.179-0.143-0.491-0.464t-0.991-1.17-1.214-1.741-0.955-2.161-0.42-2.464q0-3.929 2.268-6.143t6.268-2.214q1.107 0 2.259 0.384t2.143 1.036 1.705 1.223 1.357 1.214q0.643-0.643 1.357-1.214t1.705-1.223 2.143-1.036 2.259-0.384q4 0 6.268 2.214t2.268 6.143z"></path></symbol>';
svg += '<symbol id="history" viewBox="0 0 32 32"><path d="M32 16q0 3.25-1.271 6.208t-3.417 5.104-5.104 3.417-6.208 1.271q-3.583 0-6.812-1.51t-5.5-4.26q-0.146-0.208-0.135-0.469t0.177-0.427l2.854-2.875q0.208-0.188 0.521-0.188 0.333 0.042 0.479 0.25 1.521 1.979 3.729 3.062t4.688 1.083q2.167 0 4.135-0.844t3.406-2.281 2.281-3.406 0.844-4.135-0.844-4.135-2.281-3.406-3.406-2.281-4.135-0.844q-2.042 0-3.917 0.74t-3.333 2.114l2.854 2.875q0.646 0.625 0.292 1.438-0.354 0.833-1.229 0.833h-9.333q-0.542 0-0.938-0.396t-0.396-0.938v-9.333q0-0.875 0.833-1.229 0.812-0.354 1.438 0.292l2.708 2.688q2.229-2.104 5.094-3.26t5.927-1.156q3.25 0 6.208 1.271t5.104 3.417 3.417 5.104 1.271 6.208zM18.666 10v9.333q0 0.292-0.188 0.479t-0.479 0.188h-6.667q-0.292 0-0.479-0.188t-0.188-0.479v-1.333q0-0.292 0.188-0.479t0.479-0.188h4.667v-7.333q0-0.292 0.188-0.479t0.479-0.188h1.333q0.292 0 0.479 0.188t0.188 0.479z"></path></symbol>';
svg += '<symbol id="close" viewBox="0 0 32 32"><path d="M32 3.221l-12.779 12.779 12.779 12.779-3.221 3.221-12.779-12.779-12.779 12.779-3.221-3.221 12.779-12.779-12.779-12.779 3.221-3.221 12.779 12.779 12.779-12.779z"></path></symbol>';
svg += '<symbol id="pin" viewBox="0 0 32 32"><path d="M20.015 18.592l-10.584-6.111c-1.298-0.751-2.96-0.306-3.71 0.993-0.75 1.3-0.304 2.96 0.994 3.71l10.582 6.111c1.3 0.751 2.96 0.306 3.71-0.994 0.752-1.298 0.307-2.959-0.993-3.709zM11.286 11.984l8.232 4.753 2.8-7.792-5.684-3.281-5.348 6.32zM5.217 32l7.875-9.565-3.528-2.037-4.347 11.602zM25.72 4.636l-7.055-4.074c-0.975-0.562-2.22-0.229-2.782 0.746-0.564 0.975-0.228 2.22 0.746 2.782l7.056 4.074c0.975 0.562 2.22 0.229 2.782-0.746s0.228-2.22-0.747-2.782z"></path></symbol>';
svg += '<symbol id="setting" viewBox="0 0 32 32"><path d="M29.181 19.070c-1.679-2.908-0.669-6.634 2.255-8.328l-3.145-5.447c-0.898 0.527-1.943 0.829-3.058 0.829-3.36 0-6.085-2.742-6.085-6.125h-6.289c0.008 1.044-0.252 2.103-0.811 3.070-1.679 2.908-5.411 3.897-8.339 2.211l-3.144 5.447c0.905 0.515 1.689 1.268 2.246 2.234 1.676 2.903 0.672 6.623-2.241 8.319l3.145 5.447c0.895-0.522 1.935-0.82 3.044-0.82 3.35 0 6.067 2.725 6.084 6.092h6.289c-0.003-1.034 0.259-2.080 0.811-3.038 1.676-2.903 5.399-3.894 8.325-2.219l3.145-5.447c-0.899-0.515-1.678-1.266-2.232-2.226zM16 22.479c-3.578 0-6.479-2.901-6.479-6.479s2.901-6.479 6.479-6.479c3.578 0 6.479 2.901 6.479 6.479s-2.901 6.479-6.479 6.479z"></path></symbol>';
svg += '<symbol id="reply-to" viewBox="0 0 32 32"><path d="M19.583 9.75q-8.667 1.25-13.375 6.625t-6.208 12.958q6.417-9.083 19.583-9.083v7.25l12.417-12.417-12.417-12.417v7.083z"></path></symbol>';
svg += '<symbol id="reply" viewBox="0 0 32 32"><path d="M12.417 9.75q8.667 1.25 13.375 6.625t6.208 12.958q-6.417-9.083-19.583-9.083v7.25l-12.417-12.417 12.417-12.417v7.083z"></path></symbol>';
svg += '<symbol id="thumbs-up" viewBox="0 0 32 32"><path d="M6.154 25.846q0-0.5-0.365-0.865t-0.865-0.365-0.865 0.365-0.365 0.865 0.365 0.865 0.865 0.365 0.865-0.365 0.365-0.865zM28.308 14.769q0-0.981-0.75-1.721t-1.712-0.74h-6.769q0-1.115 0.923-3.067t0.923-3.087q0-1.885-0.615-2.788t-2.462-0.904q-0.5 0.5-0.731 1.635t-0.587 2.413-1.144 2.106q-0.423 0.442-1.481 1.75-0.077 0.096-0.442 0.577t-0.606 0.788-0.663 0.817-0.769 0.846-0.74 0.683-0.769 0.519-0.683 0.173h-0.615v12.308h0.615q0.25 0 0.606 0.058t0.635 0.125 0.731 0.212 0.673 0.221 0.683 0.24 0.558 0.202q4.058 1.404 6.577 1.404h2.327q3.692 0 3.692-3.212 0-0.5-0.096-1.077 0.577-0.308 0.913-1.010t0.337-1.413-0.346-1.327q1.019-0.962 1.019-2.288 0-0.481-0.192-1.067t-0.481-0.913q0.615-0.019 1.029-0.904t0.413-1.558zM30.769 14.75q0 1.712-0.942 3.135 0.173 0.635 0.173 1.327 0 1.481-0.731 2.769 0.058 0.404 0.058 0.827 0 1.942-1.154 3.423 0.019 2.673-1.635 4.221t-4.365 1.548h-2.481q-1.846 0-3.644-0.433t-4.163-1.26q-2.231-0.769-2.654-0.769h-5.538q-1.019 0-1.74-0.721t-0.721-1.74v-12.308q0-1.019 0.721-1.74t1.74-0.721h5.269q0.692-0.462 2.635-2.981 1.115-1.442 2.058-2.462 0.462-0.481 0.683-1.644t0.587-2.433 1.192-2.077q0.75-0.712 1.731-0.712 1.615 0 2.904 0.625t1.962 1.952 0.673 3.577q0 1.788-0.923 3.692h3.385q2 0 3.462 1.462t1.462 3.442z"></path></symbol>';
svg += '<symbol id="thumbs-down" viewBox="0 0 32 32"><path d="M6.154 6.154q0-0.5-0.365-0.865t-0.865-0.365-0.865 0.365-0.365 0.865 0.365 0.865 0.865 0.365 0.865-0.365 0.365-0.865zM28.308 17.231q0-0.673-0.413-1.558t-1.029-0.904q0.288-0.327 0.481-0.913t0.192-1.067q0-1.327-1.019-2.288 0.346-0.596 0.346-1.327 0-0.712-0.337-1.413t-0.913-1.010q0.096-0.577 0.096-1.077 0-1.635-0.942-2.423t-2.615-0.788h-2.462q-2.519 0-6.577 1.404-0.096 0.038-0.558 0.202t-0.683 0.24-0.673 0.221-0.731 0.212-0.635 0.125-0.606 0.058h-0.615v12.308h0.615q0.308 0 0.683 0.173t0.769 0.519 0.74 0.683 0.769 0.846 0.663 0.817 0.606 0.788 0.442 0.577q1.058 1.308 1.481 1.75 0.788 0.827 1.144 2.106t0.587 2.413 0.731 1.635q1.846 0 2.462-0.904t0.615-2.788q0-1.135-0.923-3.087t-0.923-3.067h6.769q0.962 0 1.712-0.74t0.75-1.721zM30.769 17.25q0 1.981-1.462 3.442t-3.462 1.462h-3.385q0.923 1.904 0.923 3.692 0 2.269-0.673 3.577-0.673 1.327-1.962 1.952t-2.904 0.625q-0.981 0-1.731-0.712-0.654-0.635-1.038-1.577t-0.49-1.74-0.337-1.625-0.596-1.231q-0.923-0.962-2.058-2.442-1.942-2.519-2.635-2.981h-5.269q-1.019 0-1.74-0.721t-0.721-1.74v-12.308q0-1.019 0.721-1.74t1.74-0.721h5.538q0.423 0 2.654-0.769 2.462-0.846 4.288-1.269t3.846-0.423h2.154q2.692 0 4.356 1.519t1.644 4.154v0.096q1.154 1.481 1.154 3.423 0 0.423-0.058 0.827 0.731 1.288 0.731 2.769 0 0.692-0.173 1.327 0.942 1.404 0.942 3.135z"></path></symbol>';
svg += '<symbol id="chevron-down" viewBox="0 0 32 32"><path d="M32 9q0 0.812-0.594 1.406l-14 14q-0.594 0.594-1.406 0.594t-1.406-0.594l-14-14q-0.594-0.594-0.594-1.406t0.594-1.406 1.406-0.594h28q0.812 0 1.406 0.594t0.594 1.406z"></path></symbol>';
svg += '<symbol id="chevron-right" viewBox="0 0 32 32"><path d="M9 0q0.812 0 1.406 0.594l14 14q0.594 0.594 0.594 1.406t-0.594 1.406l-14 14q-0.594 0.594-1.406 0.594t-1.406-0.594-0.594-1.406v-28q0-0.812 0.594-1.406t1.406-0.594z"></path></symbol>';
svg += '<symbol id="chevron-left" viewBox="0 0 32 32"><path d="M23 32q-0.812 0-1.406-0.594l-14-14q-0.594-0.594-0.594-1.406t0.594-1.406l14-14q0.594-0.594 1.406-0.594t1.406 0.594 0.594 1.406v28q0 0.812-0.594 1.406t-1.406 0.594z"></path></symbol>';
svg += '<symbol id="chevron-up" viewBox="0 0 32 32"><path d="M0 23q0-0.812 0.594-1.406l14-14q0.594-0.594 1.406-0.594t1.406 0.594l14 14q0.594 0.594 0.594 1.406t-0.594 1.406-1.406 0.594h-28q-0.812 0-1.406-0.594t-0.594-1.406z"></path></symbol>';
svg += '<symbol id="down" viewBox="0 0 32 32"><path d="M28.954 19.764l-11.349 11.349c-0.886 0.886-2.324 0.886-3.21 0l-11.349-11.349c-0.886-0.886-0.886-2.324 0-3.21s2.324-0.887 3.21 0l7.474 7.475v-21.759c0-1.254 1.016-2.27 2.27-2.27s2.27 1.016 2.27 2.27v21.759l7.475-7.475c0.443-0.443 1.024-0.665 1.605-0.665s1.162 0.222 1.605 0.665c0.886 0.886 0.886 2.324 0 3.21z"></path></symbol>';
svg += '<symbol id="points" viewBox="0 0 32 32"><path d="M13.027 18.403c0 1.902 1.482 2.643 3.164 2.643 1.101 0 2.783-0.32 2.783-1.782 0-1.542-2.142-1.802-4.245-2.363-2.122-0.561-4.265-1.382-4.265-4.065 0-2.923 2.763-4.325 5.346-4.325 2.983 0 5.726 1.301 5.726 4.605h-3.043c-0.1-1.722-1.322-2.162-2.823-2.162-1.001 0-2.162 0.42-2.162 1.622 0 1.101 0.681 1.241 4.265 2.162 1.041 0.26 4.245 0.921 4.245 4.165 0 2.623-2.062 4.585-5.947 4.585-3.164 0-6.127-1.562-6.087-5.086h3.043zM17.052 9.705c0 0.242-0.197 0.439-0.439 0.439h-1.097c-0.242 0-0.439-0.197-0.439-0.439v-2.268c0-0.242 0.197-0.439 0.439-0.439h1.097c0.242 0 0.439 0.197 0.439 0.439v2.268zM17.052 24.519c0 0.242-0.197 0.439-0.439 0.439h-1.097c-0.242 0-0.439-0.197-0.439-0.439v-2.268c0-0.242 0.197-0.439 0.439-0.439h1.097c0.242 0 0.439 0.197 0.439 0.439v2.268zM16 0.017c-8.827 0-15.983 7.156-15.983 15.983s7.156 15.983 15.983 15.983 15.983-7.156 15.983-15.983c0-8.827-7.156-15.983-15.983-15.983zM15.982 29.040c-7.181 0-13.003-5.822-13.003-13.003s5.822-13.003 13.003-13.003c7.181 0 13.003 5.822 13.003 13.003s-5.822 13.003-13.003 13.003z"></path></symbol>';
svg += '<symbol id="upload" viewBox="0 0 32 32"><path d="M21.334 16.532q0-0.233-0.15-0.384l-5.867-5.867q-0.15-0.15-0.384-0.15t-0.384 0.15l-5.85 5.85q-0.167 0.2-0.167 0.399 0 0.233 0.15 0.384t0.384 0.15h3.733v5.867q0 0.217 0.159 0.375t0.375 0.159h3.2q0.217 0 0.375-0.159t0.159-0.375v-5.867h3.734q0.217 0 0.375-0.159t0.159-0.375zM32 21.332q0 2.65-1.875 4.525t-4.525 1.875h-18.133q-3.083 0-5.275-2.192t-2.192-5.275q0-2.166 1.167-4t3.134-2.75q-0.034-0.5-0.034-0.717 0-3.533 2.5-6.033t6.033-2.5q2.6 0 4.759 1.45t3.142 3.849q1.184-1.033 2.767-1.033 1.767 0 3.017 1.25t1.25 3.017q0 1.267-0.683 2.3 2.166 0.516 3.558 2.258t1.392 3.975z"></path></symbol>';
svg += '<symbol id="icon-telegram" viewBox="0 0 32 32"><path d="M12.036 27.787c-0.952 0-0.791-0.361-1.119-1.266l-2.805-9.23 21.577-12.802z"></path><path d="M12.036 27.787c0.736 0 1.060-0.336 1.474-0.738l3.923-3.811-4.896-2.953z"></path><path d="M12.536 20.285l11.857 8.76c1.354 0.747 2.331 0.361 2.668-1.256l4.828-22.745c0.496-1.983-0.752-2.88-2.046-2.294l-28.348 10.933c-1.934 0.776-1.925 1.857-0.352 2.338l7.276 2.267 16.838-10.621c0.794-0.48 1.525-0.223 0.926 0.309z"></path></symbol>';
svg += '<symbol id="iconAsk" viewBox="0 0 32 32"><path d="M25.353 1.668c1.385 0 2.509 1.121 2.509 2.502v12.258l0.24-0.585-14.231 14.423 0.597-0.249h-10.048c-1.386 0-2.508-1.116-2.508-2.493v-26.689l-0.837 0.834h24.278zM0.238 0v27.523c0 2.299 1.872 4.161 4.182 4.161h10.399l14.717-14.916v-12.599c0-2.301-1.873-4.169-4.183-4.169h-25.115zM26.56 21.784l-0.403 0.402 3.088 3.076 2.518-2.508-3.088-3.076-2.114 2.106zM28.27 20.883l2.282 2.272v-0.803l-1.712 1.704h0.807l-2.282-2.273v0.804l1.711-1.705h-0.807zM20.286 28.034l-0.123 0.121-0.034 0.169-0.57 2.841-0.167 0.836 3.86-0.769 0.123-0.122 6.677-6.651-3.088-3.076-0.403 0.402-6.274 6.25zM26.56 22.588l2.281 2.272v-0.803l-6.274 6.249 0.292-0.156-2.852 0.569 0.671 0.669 0.57-2.841-0.156 0.291 6.274-6.249-0.806 0zM14.757 21.415c0.631 0 1.143 0.509 1.143 1.138v0.302c0 0.628-0.508 1.138-1.143 1.138-0.632 0-1.144-0.51-1.144-1.138v-0.302c-0-0.628 0.508-1.138 1.144-1.138zM9.446 12.309s0.090 0.786 0.972 0.786c0.882 0 0.934-0.786 0.934-0.786-0.058-2.546 1.126-3.756 3.551-3.635 1.614 0.182 2.45 1.089 2.506 2.725-0.112 0.729-0.725 1.671-1.815 2.821-1.444 1.455-2.166 2.757-2.166 3.908v1.18s0.111 0.703 0.909 0.703c0.798 0 0.909-0.703 0.909-0.703v-0.819c0-0.961 0.691-2.116 2.076-3.454 1.449-1.329 2.168-2.544 2.168-3.635-0.119-3.027-1.703-4.604-4.763-4.727-3.521-0.059-5.282 1.82-5.282 5.637z"></path></symbol>';
svg += '<symbol id="icon-accept" viewBox="0 0 32 32"><path d="M12.42 28.678l-12.433-12.238 6.168-6.071 6.265 6.167 13.426-13.214 6.168 6.071-19.594 19.285zM3.372 16.441l9.048 8.905 16.208-15.953-2.782-2.739-13.426 13.214-6.265-6.167-2.782 2.739z"></path></symbol>';
svg += '<symbol id="icon-report" viewBox="0 0 32 32"><path d="M29.822 3.266c-4.281-0.382-8.228-1.256-11.966-2.571l0.342 0.105-2.234-0.767-1.621 0.576c-3.368 1.241-7.285 2.153-11.35 2.568l-0.207 0.017-1.627 0.161v3.153c0 9.421 4.568 18.256 12.254 23.703l2.479 1.757 2.532-1.768c7.78-5.434 12.415-14.326 12.415-23.816v-3.028l-1.018-0.089zM28.462 6.383c-0 2.269-0.283 4.472-0.816 6.575l0.040-0.184c-0.566 2.258-1.335 4.235-2.314 6.084l0.070-0.145c-1.050 1.993-2.24 3.712-3.609 5.271l0.026-0.030c-1.415 1.61-2.987 3.024-4.71 4.24l-0.084 0.056-1.16 0.81-1.114-0.789c-1.783-1.273-3.336-2.686-4.708-4.261l-0.027-0.032c-1.324-1.522-2.5-3.234-3.467-5.073l-0.070-0.146c-0.897-1.693-1.655-3.658-2.174-5.719l-0.039-0.184c-0.486-1.906-0.765-4.093-0.766-6.346v-1.001c4.305-0.48 8.233-1.415 11.959-2.77l-0.357 0.113 0.837-0.298 1.447 0.497c3.198 1.141 6.934 2.010 10.801 2.45l0.235 0.022v0.861z"></path><path d="M16.077 6.398c-0.876 0-1.586 0.71-1.586 1.586v8.234c0 0.839 0.68 1.519 1.519 1.519h0.134c0.839 0 1.519-0.68 1.519-1.519v-8.234c0-0.876-0.71-1.586-1.586-1.586zM16.144 19.481h-0.134c-0.839 0-1.519 0.68-1.519 1.519s0.68 1.519 1.519 1.519h0.134c0.839 0 1.519-0.68 1.519-1.519s-0.68-1.519-1.519-1.519z"></path></symbol>';
svg += '<symbol id="iconRss" viewBox="0 0 32 32"><path d="M29 0h-26c-1.65 0-3 1.35-3 3v26c0 1.65 1.35 3 3 3h26c1.65 0 3-1.35 3-3v-26c0-1.65-1.35-3-3-3zM8.719 25.975c-1.5 0-2.719-1.206-2.719-2.706 0-1.488 1.219-2.712 2.719-2.712 1.506 0 2.719 1.225 2.719 2.712 0 1.5-1.219 2.706-2.719 2.706zM15.544 26c0-2.556-0.994-4.962-2.794-6.762-1.806-1.806-4.2-2.8-6.75-2.8v-3.912c7.425 0 13.475 6.044 13.475 13.475h-3.931zM22.488 26c0-9.094-7.394-16.5-16.481-16.5v-3.912c11.25 0 20.406 9.162 20.406 20.413h-3.925z"></path></symbol>';
svg += '<symbol id="iconAdopt" viewBox="0 0 32 32"><path d="M16.356 25.244c-6.933 0-12.622-5.689-12.622-12.622s5.689-12.622 12.622-12.622 12.622 5.689 12.622 12.622c0 6.933-5.689 12.622-12.622 12.622zM16.356 2.133c-5.689 0-10.489 4.8-10.489 10.489 0 5.867 4.8 10.489 10.489 10.489s10.489-4.622 10.489-10.489c0-5.689-4.622-10.489-10.489-10.489z"></path><path d="M17.244 6.4l1.422 2.667c0.178 0.356 0.356 0.533 0.711 0.533l3.022 0.356c0.889 0.178 1.067 1.067 0.533 1.778l-2.133 2.133c-0.178 0.178-0.356 0.533-0.356 0.889l0.533 2.844c0.178 0.889-0.711 1.422-1.422 1.067l-2.667-1.422c-0.356-0.178-0.711-0.178-0.889 0l-2.844 1.422c-0.711 0.356-1.6-0.178-1.422-1.067l0.533-2.844c0-0.356 0-0.711-0.356-0.889l-2.133-2.133c-0.533-0.533-0.356-1.6 0.533-1.778l3.022-0.356c0.356 0 0.533-0.178 0.711-0.533l1.422-2.667c0.356-0.889 1.422-0.889 1.778 0z"></path><path d="M21.867 31.644l-5.511-3.2-5.511 3.378c-1.244 0.533-2.489-0.356-2.489-1.6v-8l7.644 1.778 8.356-1.778v8c0 1.067-1.244 1.956-2.489 1.422z"></path></symbol>'
document.body.insertAdjacentHTML('afterBegin', svg + '</defs></svg>');
