
<h1 align="center"> 为梦想而创作：JavaWeb权限(RBAC)及内容管理框架</h1>

<p align="center">
	<a href="http://spring.io/projects/spring-boot">
        <img src="https://img.shields.io/badge/spring--boot-2.1.6-green.svg" alt="spring-boot">
    </a>
    <a href="http://mp.baomidou.com">
        <img src="https://img.shields.io/badge/mybatis--plus-3.0-blue.svg" alt="mybatis-plus">
    </a>  
    <a href="https://www.thymeleaf.org/">
        <img src="https://img.shields.io/badge/thymeleaf-2.9.3-yellow.svg" alt="thymeleaf">
    </a> 
	<a href="https://www.layui.com/">
        <img src="https://img.shields.io/badge/layui-2.5.6-blue.svg" alt="layui">
    </a>
	<a href='https://gitee.com/javaweb520/JavaWeb/stargazers'>
	    <img src='https://gitee.com/javaweb520/JavaWeb/badge/star.svg?theme=white' alt='star'></img>
	</a>
    <a href='https://gitee.com/javaweb520/JavaWeb/members'>
        <img src='https://gitee.com/javaweb520/JavaWeb/badge/fork.svg?theme=white' alt='fork'></img>
    </a>
</p>


### 如果对您有帮助，您可以点右上角 "Star" 支持一下 谢谢！
### 如果您想获悉项目实时更新信息，您可以点右上角 <a href='https://gitee.com/javaweb520/JavaWeb'><img src='https://gitee.com/javaweb520/JavaWeb/widgets/widget_3.svg' alt='Fork me on Gitee'></img></a> 感谢您的支持！git 
### 官方网址：http://www.javaweb.vip/
### 帮助文档：http://docs.javaweb.vip
### 本项目还在不断开发完善中,如有建议或问题请官方论坛反馈，论坛地址:http://www.javaweb.vip

### 项目介绍
JavaWeb是基于 SpringBoot2+Layui2.5.6+Thymeleaf++Shiro+MybatisPlus 研发的权限(RBAC)及内容管理系统，致力于做更简洁的后台管理框架，包含系统管理、代码生成、权限管理、站点、广告、布局、字段、配置等一系列常用的模块，整套系统一键生成所有模块（包括前端UI），一键实现CRUD，简化了传统手动抒写重复性代码的工作。
同时，框架提供长大量常规组件，如上传单图、上传多图、上传文件、下拉选择、复选框按钮、单选按钮，城市选择、富文本编辑器、权限颗粒度控制等高频使用的组件，代码简介，使用方便，节省了大量重复性的劳动，降低了开发成本，提高了整体开发效率，整体开发效率提交80%以上，JavaWeb框架专注于为中小企业提供最佳的行业基础后台框架解决方案，执行效率、扩展性、稳定性值得信赖，操作体验流畅，使用非常优化，欢迎大家使用及进行二次开发。

* 模块化：全新的架构和模块化的开发机制，便于灵活扩展和二次开发。
* 模型/栏目/分类信息体系：通过栏目和模型绑定，以及不同的模型类型，不同栏目可以实现差异化的功能，轻松实现诸如资讯、下载、讨论和图片等功能。通过分类信息和栏目绑定，可以自动建立索引表，轻松实现复杂的信息检索。
* SpringBoot2 + Layui开发出来的框架。
* 支持SQLServer、MySQL、Oracle、PostgreSQL、SQLite等多数据库类型。模块化设计，层次结构清晰。  
* AUTH权限认证，操作权限控制精密细致，对所有管理链接都进行权限验证，可控制到导航菜单、功能按钮。提高开发效率及质量。
* 常用类封装，日志、缓存、验证、字典、文件（本地、七牛云）。等等，目前兼容浏览器（Chrome、Firefox、360浏览器等）
* 适用范围：可以开发OA、ERP、BPM、CRM、WMS、TMS、MIS、BI、电商平台后台、物流管理系统、快递管理系统、教务管理系统等各类管理软件。

### 功能特性
- **严谨规范：** 提供一套有利于团队协作的结构设计、编码、数据等规范。
- **高效灵活：** 清晰的分层设计、钩子行为扩展机制，解耦设计更能灵活应对需求变更。
- **严谨安全：** 清晰的系统执行流程，严谨的异常检测和安全机制，详细的日志统计，为系统保驾护航。
- **组件化：** 完善的组件化设计，丰富的表单组件，让开发列表和表单更得心应手。无需前端开发，省时省力。
- **简单上手快：** 结构清晰、代码规范、在开发快速的同时还兼顾性能的极致追求。
- **自身特色：** 权限管理、组件丰富、第三方应用多、分层解耦化设计和先进的设计思想。
- **高级进阶：** 分布式、负载均衡、集群、Redis、分库分表。 
- **命令行：** 命令行功能，一键管理应用扩展。 
- **基于SpringBoot** 简化了大量项目配置和maven依赖，让您更专注于业务开发，独特的分包方式，代码多而不乱。
- **利用Thymeleaf模板引擎** 对前台页面进行封装和拆分，使臃肿的html代码变得简洁，更加易维护。
- **JS封装** 对常用js插件进行二次封装，使js代码变得简洁，更加易维护。
- **参数配置** 灵活控制常用功能的开关，无需重启项目即可生效，实时刷新。


## 开发者信息
* 系统名称：JavaWeb权限(RBAC)及内容管理框架  
* 作者：鲲鹏
* 作者QQ：1175401194  
* 官网网址：[http://www.javaweb.vip/](http://www.javaweb.vip/)  
* 文档网址：[http://docs.javaweb.vip](http://docs.javaweb.vip)

## 后台演示（用户名:admin 密码:123456）
- JavaWeb混编版：[http://manage.javaweb.vip](http://manage.javaweb.vip)
- 登录用户名：admin
- 登录密码：123456
- 验证码：520

## 技术支持

[技术支持QQ：1175401194](http://wpa.qq.com/msgrd?v=3&amp;uin=1175401194&amp;site=qq&amp;menu=yes)


### 日志管理
日志记录采用AOP切面的方式对所有包含@BussinessLog注解的方法进行aop切入，会完成的记录下当前用户所有的操作记录（即@BussinessLog value属性的内容）。


### 版权声明
JavaWeb采用LGPL-3.0开源协议


### 版本说明

| 版本名称 | 说明 | 地址 |
| :---: | :---: | :---: |
| JavaWeb 混编版 | 采用SpringBoot2+Thymeleaf+layui | https://gitee.com/javaweb520/JavaWeb |
| JavaWeb_Vue版本 | 前后端分离版，采用SpringBoot2+Vue | https://gitee.com/javaweb520/JavaWeb_Vue |
| JavaWeb_Vue_UI前端 | 基于element-ui自定义编写 | https://gitee.com/javaweb520/JavaWeb_Vue_UI |
| JavaWeb_Ant版本 | 前后端分离版，采用SpringBoot2+AntDesign | https://gitee.com/javaweb520/JavaWeb_Ant |
| JavaWeb_Ant_UI前端 | 基于AntDesign自定义编写 | https://gitee.com/javaweb520/JavaWeb_Ant_UI |
| JavaWeb_Cloud版本 | 基于微服务架构编写 | https://gitee.com/javaweb520/JavaWeb_Cloud |


### Thymeleaf模板引擎页面拆分
例如，把主页拆分成三部分，每个部分单独一个页面，更加便于维护
```
<!DOCTYPE html>
<html>
<body>
<!-- 引入头部 -->
<header th:replace="./public/header :: header"></header>
<!-- 正文开始 -->
<div class="layui-fluid">
    <div class="layui-card">
        <!-- 内容区 -->
        <div class="layui-card-body" layout:fragment="content">
            内容区
        </div>
    </div>
</div>
<!-- 引入脚部 -->
<footer th:replace="./public/footer :: footer"></footer>
</body>
</html>
```
以上是对整个页面进行的拆分，把公共部分抽离出来，子页面只需继承当前页面专心处理业务UI即可

开发业务模块时使用如下
```
<html layout:decorator="public/layout" xmlns:miguo="http://www.w3.org/1999/html">
<div layout:fragment="content">

    此处为子页面业务UI部分，此处使用Layout模板继承

</div>
</html>
```

业务模块列表页使用方法如下：
```
<html layout:decorator="public/layout" xmlns:miguo="http://www.w3.org/1999/html">
<div layout:fragment="content">

    <!-- 表格工具栏 -->
    <form class="layui-form toolbar">
        <div class="layui-form-item">
            <div class="layui-inline">
                <div class="layui-input-inline">
                    <input type="text" name="name" placeholder="请输入职级名称" autocomplete="off" class="layui-input">
                </div>
            </div>
            <!-- 状态下拉单选 -->
            <div class="layui-inline">
                <div class="layui-input-inline">
                    <!-- 下拉单选 -->
                    <widget:singleSelect name="status|0|状态|name|id" th:data="${LEVEL_STATUS_LIST}" value="0"/>
                </div>
            </div>
            <div class="layui-inline">
                <div class="layui-input-inline" style="width: auto;">
                    <widget:btnQuery name="查询"/>
                    <widget:btnAdd name="添加职级"/>
                    <widget:btnDAll name="批量删除"/>
                </div>
            </div>
        </div>
    </form>

    <!-- 数据表格 -->
    <table class="layui-hide" id="tableList" lay-filter="tableList"></table>

    <!-- 表格操作列 -->
    <script type="text/html" id="toolBar">
        <widget:btnEdit name="编辑"/>
        <widget:btnDel name="删除"/>
    </script>

    <!-- 状态 -->
    <script type="text/html" id="statusTpl">
        <input type="checkbox" name="status" value="{{ d.id }}" lay-skin="switch" lay-text="正常|停用" lay-filter="status" {{ d.status == 1 ? 'checked' : '' }} >
    </script>
</div>
</html>
```

业务模块表单编辑页使用方法如下：
```
<html layout:decorator="public/form" xmlns:miguo="http://www.w3.org/1999/html">
<div layout:fragment="content">
	<form class="layui-form model-form" action="">
		<input name="id" type="hidden" th:value="${info['id']}?:0">
		<div class="layui-form-item">
			<label class="layui-form-label">职级名称：</label>
			<div class="layui-input-block">
				<input name="name" th:value="${info['name']}" lay-verify="required" autocomplete="off" placeholder="请输入职级名称" class="layui-input" type="text">
			</div>
		</div>
		<div class="layui-form-item">
			<label class="layui-form-label">状态：</label>
			<div class="layui-input-block">
				<widget:switchCheck name="status" data="正常|停用" th:value="${info['status']} ?: 1"/>
			</div>
		</div>
		<div class="layui-form-item">
			<label class="layui-form-label">显示顺序：</label>
			<div class="layui-input-block">
				<input name="sort" th:value="${info['sort']}" lay-verify="required|number" autocomplete="off" placeholder="请输入显示顺序" class="layui-input" type="text">
			</div>
		</div>
		<widget:btnSubmit name="submit|立即保存,close|关闭"/>
	</form>
</div>
</html>
```

业务模块JS部分
```
/**
 * 职级
 * @auth 鲲鹏
 * @date 2020-04-20
 */
layui.use(['func'], function () {

    //声明变量
    var func = layui.func
        , $ = layui.$;

    if (A == 'index') {
        //【TABLE列数组】
        var cols = [
            {type: 'checkbox', fixed: 'left'}
            , {field: 'id', width: 80, title: 'ID', align: 'center', sort: true, fixed: 'left'}
            , {field: 'name', width: 200, title: '职级名称', align: 'center'}
            , {field: 'status', width: 100, title: '状态', align: 'center', templet: '#statusTpl'}
            , {field: 'sort', width: 100, title: '显示顺序', align: 'center'}
            , {field: 'createUserName', width: 100, title: '添加人', align: 'center'}
            , {field: 'createTime', width: 180, title: '创建时间', align: 'center'}
            , {field: 'updateUserName', width: 100, title: '更新人', align: 'center'}
            , {field: 'updateTime', width: 180, title: '更新时间', align: 'center'}
            , {fixed: 'right', width: 150, title: '功能操作', align: 'center', toolbar: '#toolBar'}
        ];

        //【渲染TABLE】
        func.tableIns(cols, "tableList");

        //【设置弹框】
        func.setWin("职级", 500, 300);

        //【设置状态】
        func.formSwitch('status', null, function (data, res) {
            console.log("开关回调成功");
        });
    }
});
```

以上是Thymeleaf模板的拆分与集成，详细说明请参开官方文档。

## 常规组件
1、上传图片图片及裁剪
```
<widget:uploadSingleImage name="avatar|头像|90x90|admin|建议上传尺寸450x450" th:value="${info['avatar']}"/>
```
2、下拉单选
```
<widget:singleSelect name="gender|1|性别|name|id" th:data="${ADMIN_GENDER_LIST}" th:value="${info['gender']}?:3"/>
```
3、日期选择
```
<widget:dateSelect name="birthday|出生日期|date" th:value="${info['birthday']}"/>
```
4、分组下拉选择
```
<widget:complexSelect name="deptId|0|部门|name|id" sql="SELECT id,`name` FROM sys_dep WHERE pid=? AND mark=1 ORDER BY sort ASC;" th:value="${info['deptId']}?:0"/>
```
5、城市选择
```
<widget:citySingleSelect th:value="${info['districtId']} ?: 0" limit="3"/>
```
6、开关
```
<widget:switchCheck name="status" data="正常|禁用" th:value="${info['status']} ?: 1"/>
```
7、复选框选择(如：角色多选)
```
<widget:checkboxSingleSelect name="roleIds|name|id" sql="SELECT id,`name` FROM sys_role WHERE mark=1 ORDER BY sort ASC;" th:value="${info['roleIds']}?:[]"/>
```
8、下拉多选
```
<widget:xmSelect name="test|1|请选择角色|name|id|pid" sql="SELECT id, `name`, pid FROM sys_dep WHERE mark=1 ORDER BY sort ASC;" value="1,2"/>
```


## 效果图展示
 
#### 1、系统登录
 ![系统登录](http://images.javaweb.rxthink.cn/demo/0.png)
 
#### 2、系统欢迎页
 ![系统欢迎页](http://images.javaweb.rxthink.cn/demo/2.png)
 
#### 3、人员管理
 ![人员管理](http://images.javaweb.rxthink.cn/demo/3.png)
 
#### 4、图片裁剪
 ![图片裁剪](http://images.javaweb.rxthink.cn/demo/4.png)
 
#### 5、角色权限配置
 ![角色权限配置](http://images.javaweb.rxthink.cn/demo/5.png)
 
#### 6、职级管理
 ![职级管理](http://images.javaweb.rxthink.cn/demo/6.png)
 
#### 7、岗位管理
 ![岗位管理](http://images.javaweb.rxthink.cn/demo/7.png)
 
#### 8、部门管理
 ![部门管理](http://images.javaweb.rxthink.cn/demo/8.png)
 
#### 9、菜单管理
 ![菜单管理](http://images.javaweb.rxthink.cn/demo/9.png)
 
#### 10、代码生成
 ![代码生成](http://images.javaweb.rxthink.cn/demo/10.png)
 
#### 11、网站配置
 ![网站配置](http://images.javaweb.rxthink.cn/demo/11.png)
 
#### 12、通知公告
 ![通知公告](http://images.javaweb.rxthink.cn/demo/12.png)
 
#### 13、消息模板
 ![消息模板](http://images.javaweb.rxthink.cn/demo/13.png)
 
#### 14、系统配置
 ![系统配置](http://images.javaweb.rxthink.cn/demo/14.png)
 
#### 15、操作日志
![操作日志](http://images.javaweb.rxthink.cn/demo/16.png)

#### 16、商品信息
![SKU设置](http://images.javaweb.rxthink.cn/demo/17.png)

#### 17、商品SKU
![SKU设置](http://images.javaweb.rxthink.cn/demo/18.png)

#### 18、框架结构
 ![项目结构](http://images.javaweb.rxthink.cn/demo/15.png)


## 更新说明

# 2020-06-22更新  
1、【优化】优化富文本编辑器组件

2、【优化】优化日期选择组件；

# 2020-06-16更新  
1、【新增】优化数据库连接池，新增DbConfig数据库配置读取文件；

2、【优化】优化组件动态获取数据库数据的方式；

3、【修复】解决系统中客户反馈的BUG;


# 2020-06-15更新  
1、【修复】修复树状结构数据列表展开JS报错的问题；

2、【新增】新增全部展开、全部折叠权限按钮组件；

3、【修复】修复客户使用过程中发现的BUG;


# 2020-06-13新增 
1、【新增】新增商品管理商品类型模块；

2、【新增】新增商品管理商品属性模块；

3、【新增】新增商品管理商品属性值模块；

4、【新增】新增商品管理模块；

5、【新增】新增商品SKU设置模块；


# 2020-05-25更新  
1、【优化】优化布局模板的区域层级划分；

2、【修复】解决列表数据分页失效的问题；

3、【优化】优化代码生成器生成服务类文件；


# 2020-05-20更新  
1、【完成】主要完成登录日志模块的开发及线程处理；

2、【完成】主要完成操作日志等模块的开发以及菜单管理模块和权限分配等工作；


# 2020-05-15更新  
1、【完成】完成模块站点管理、栏目管理、布局描述、布局管理、友链管理等模块的开发；

2、【完成】完成系统登录和后端欢迎页及菜单渲染等开发；


# 2020-05-12更新  
1、【完成】完成管理段模板开发，包括：广告位管理、广告管理、城市管理、配置分组、配置管理；

2、【完成】完成模板网站配置、定时任务管理、部门、字典类型、字典管理等模块的研发；


# 2020-05-10更新  
1、【完成】主要完成常规组件的研发，包括:上传单图、上传多图、TAB选项卡、下拉单选、日期组件、Tree组件、Icon、富文本编辑器组件、radio组件、switch组件、TagsInput组件、城市选择组件、复选框组件、权限按钮组件；

2、【完成】完成主模块人员管理、职级管理、岗位管理的开发；


# 2020-05-08更新  
1、【完成】完成框架前端JS类库及JS组件的研发，主要涉及common.js和func.js库的研发，包括：showWin弹窗组件、ajaxPost网络POST请求、ajaxGet网络GET请求、formSwitch开关、uploadFile上传文件、initDate日期、submitForm提交表单、searchForm搜索、add,edit,detail,delete等主要JS类库及组件；

2、【完成】完成功能函数类库：tableIns数据表格组件、treetable树状表单组件、getCheckData函数等常用前端JS函数和组件库；


# 2020-05-05更新  
1、【完成】完成框架核心公共层的建设，包括基本的常用工具，如：CommonUtils常用工具类、StringUtils字符串处理工具、MailUtils邮件发送工具、JPushUtils消息推送工具类、ExcelUtils文档操作类、AliSmsUtils阿狸短信操作类、ZipUtils文件压缩类、UploadUtils上传文件类等等 ；

2、【完成】完成框架底层架构设计及开发，重点完善javaweb-common模块的建设；


# 2020-05-03更新  
1、【完成】完成代码生成器的程序开发工作；

2、【完成】制作了模板，包括：Constant模板、Controller模板、Dao模板、Edit模板、Entity模板、EntityListVo模板、Index模板、IService模板、Js模板、Mapper模板、Query模板、ServiceImpl模板；

3、【完成】完成代码生成器的模板公里模块；

4、【完成】完成UI界面操作与代码生成程序的对接工作，已经可以完整的生成整个单模块的代码，生成后可直接运行进行增删改查操作（即：一键CRUD操作）；


# 2020-05-02更新  
1、【完成】完成系统框架及模块的划分；

2、【完成】研发完Shiro权限架构的设计与对接工作；


# 2020-05-01更新  
1、【完成】完成系统基础架构的设计及数据表结构的设计工作 ；

2、【完成】准备系统所需要的素材及UI准备接入工作；


## 安全&缺陷
如果你发现了一个安全漏洞或缺陷，请发送邮件到 1175401194@qq.com,所有的安全漏洞都将及时得到解决。


## 鸣谢
感谢[MybatisPlus](https://mp.baomidou.com/)、[JQuery](http://jquery.com)、[Layui](http://www.layui.com)等优秀开源项目。

## 版权信息

JavaWeb商业版使用需授权，未授权禁止恶意传播和用于商业用途，否则将追究相关人的法律责任。

本项目包含的第三方源码和二进制文件之版权信息另行标注。

版权所有Copyright © 2019-2020 javaweb.vip (http://www.javaweb.vip)

All rights reserved。

更多细节参阅 [LICENSE.txt](LICENSE.txt)
