package com.javaweb.admin.controller;


import com.javaweb.common.utils.JsonResult;
import com.javaweb.common.annotation.Log;
import com.javaweb.common.enums.BusinessType;
import com.javaweb.admin.entity.BrandCompany;
import com.javaweb.admin.query.BrandCompanyQuery;
import com.javaweb.admin.service.IBrandCompanyService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.javaweb.common.common.BaseController;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 品牌商 控制器
 * </p>
 *
 * @author 鲲鹏
 * @since 2020-05-05
 */
@Controller
@RequestMapping("/brandcompany")
public class BrandCompanyController extends BaseController {

    @Autowired
    private IBrandCompanyService brandCompanyService;

    /**
     * 获取数据列表
     *
     * @param query 查询条件
     * @return
     */
//    @RequiresPermissions("sys:brandcompany:list")
    @ResponseBody
    @PostMapping("/list")
    public JsonResult list(BrandCompanyQuery query) {
        return brandCompanyService.getList(query);
    }

    /**
     * 添加记录
     *
     * @param entity 实体对象
     * @return
     */
//    @RequiresPermissions("sys:brandcompany:add")
    @Log(title = "品牌商", businessType = BusinessType.INSERT)
    @ResponseBody
    @PostMapping("/add")
    public JsonResult add(@RequestBody BrandCompany entity) {
        return brandCompanyService.edit(entity);
    }

    /**
     * 修改记录
     *
     * @param entity 实体对象
     * @return
     */
//    @RequiresPermissions("sys:brandcompany:update")
    @Log(title = "品牌商", businessType = BusinessType.UPDATE)
    @ResponseBody
    @PostMapping("/update")
    public JsonResult update(@RequestBody BrandCompany entity) {
        return brandCompanyService.edit(entity);
    }

    /**
     * 获取记录详情
     *
     * @param id    记录ID
     * @param model 模型
     * @return
     */
    @Override
    public String edit(Integer id, Model model) {
        Map<String, Object> info = new HashMap<>();
        if (id != null && id > 0) {
            info = brandCompanyService.info(id);
        }
        model.addAttribute("info", info);
        return super.edit(id, model);
    }

    /**
     * 删除记录
     *
     * @param id 记录ID
     * @return
     */
//    @RequiresPermissions("sys:brandcompany:delete")
    @Log(title = "品牌商", businessType = BusinessType.DELETE)
    @Override
    public JsonResult delete(Integer id) {
        return brandCompanyService.deleteById(id);
    }

}
