/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.entity.AppState;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.DeskState;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.entity.DockerState;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.SystemInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.FormatUtil;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.TokenUtils;
import com.wgcloud.util.msg.WarnMailUtil;
import com.wgcloud.util.staticvar.BatchData;
import com.wgcloud.util.staticvar.StaticKeys;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agentGo"})
public class AgentGoController {
    private static final Logger logger = LoggerFactory.getLogger(AgentGoController.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private SystemInfoService systemInfoService;
    @Autowired
    private TokenUtils tokenUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/minTask"})
    public JSONObject minTask(@RequestBody String paramBean) {
        JSONObject agentJsonObject = (JSONObject)JSONUtil.parse((Object)paramBean);
        JSONObject resultJson = new JSONObject();
        if (!this.tokenUtils.checkAgentToken(agentJsonObject)) {
            logger.error("token is invalidate");
            resultJson.put("result", (Object)"error\uff1atoken is invalidate");
            return resultJson;
        }
        JSONObject diskInfoListJson = agentJsonObject.getJSONObject((Object)"diskInfoList");
        String hostNameJson = agentJsonObject.getStr((Object)"hostName");
        JSONObject hostInfoJson = agentJsonObject.getJSONObject((Object)"hostInfo");
        JSONObject dockersJson = agentJsonObject.getJSONObject((Object)"dockers");
        JSONObject loadJson = agentJsonObject.getJSONObject((Object)"load");
        String submitSeconds = agentJsonObject.getStr((Object)"submitSeconds");
        JSONArray cpuInfoJson = null;
        try {
            cpuInfoJson = agentJsonObject.getJSONArray((Object)"cpuInfo");
        }
        catch (Exception e) {
            logger.error("cpuInfoJson is error : ", (Throwable)e);
            JSONObject cpuInfoJsonTmp = new JSONObject();
            cpuInfoJsonTmp.put("cores", (Object)0);
            cpuInfoJsonTmp.put("modelName", (Object)"?");
            cpuInfoJson = new JSONArray();
            cpuInfoJson.add((Object)cpuInfoJsonTmp);
        }
        Double cpuPercentJson = agentJsonObject.getDouble((Object)"cpuPercent");
        JSONObject virtualMemoryJson = agentJsonObject.getJSONObject((Object)"virtualMemory");
        JSONObject swapMemoryStatJson = agentJsonObject.getJSONObject((Object)"swapMemoryStat");
        JSONObject netIOCountersJson = agentJsonObject.getJSONObject((Object)"netIOCounters");
        JSONObject processListJson = agentJsonObject.getJSONObject((Object)"processList");
        String bindIp = agentJsonObject.getStr((Object)"bindIp");
        Double cpuPercentVal = null;
        Double memTotalVal = null;
        Double memPercentVal = null;
        Object swapMemPercentVal = null;
        Timestamp nowtime = DateUtil.getNowTime();
        if (StringUtils.isEmpty((CharSequence)bindIp)) {
            logger.error("bindIp is null");
            resultJson.put("result", (Object)"error\uff1abindIp is null");
            return resultJson;
        }
        try {
            if (cpuPercentJson != null) {
                cpuPercentVal = FormatUtil.formatDouble((Double)cpuPercentJson, (int)2);
                this.addCpuState(cpuPercentJson, (Date)nowtime, bindIp);
            }
            if (virtualMemoryJson != null) {
                MemState bean = new MemState();
                memTotalVal = FormatUtil.formatDouble((Double)((double)virtualMemoryJson.getLong((Object)"total").longValue() / 1024.0 / 1024.0 / 1024.0), (int)2);
                bean.setUsePer(Double.valueOf(FormatUtil.formatDouble((Double)virtualMemoryJson.getDouble((Object)"usedPercent"), (int)2)));
                memPercentVal = bean.getUsePer();
                bean.setCreateTime((Date)nowtime);
                bean.setHostname(bindIp);
                BatchData.MEM_STATE_LIST.add(bean);
                Runnable runnable = () -> WarnMailUtil.sendWarnInfo((MemState)bean);
                ThreadPoolUtil.executor.execute(runnable);
            }
            if (loadJson != null) {
                this.addLoadState(loadJson, (Date)nowtime, bindIp);
            }
            if (netIOCountersJson != null) {
                this.addNetIoState(netIOCountersJson, (Date)nowtime, bindIp);
            }
            if (processListJson != null) {
                this.addAppState(processListJson, (Date)nowtime, bindIp);
            }
            if (dockersJson != null) {
                this.addDockerState(dockersJson, (Date)nowtime, bindIp);
            }
            if (hostInfoJson != null && cpuInfoJson != null) {
                this.addSystemInfo(hostInfoJson, cpuInfoJson.getJSONObject((Object)0), cpuPercentVal, memPercentVal, memTotalVal, (Date)nowtime, bindIp, submitSeconds);
            }
            if (diskInfoListJson != null) {
                this.addDeskState(diskInfoListJson, (Date)nowtime, bindIp);
            }
            resultJson.put("result", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
            resultJson.put("result", (Object)("error\uff1a" + e.toString()));
        }
        finally {
            return resultJson;
        }
    }

    private void addCpuState(Double cpuPercentJson, Date nowtime, String bindIp) throws Exception {
        CpuState bean = new CpuState();
        bean.setHostname(bindIp);
        Double cpuPercentVal = FormatUtil.formatDouble((Double)cpuPercentJson, (int)2);
        bean.setSys(cpuPercentVal);
        bean.setCreateTime(nowtime);
        BatchData.CPU_STATE_LIST.add(bean);
        Runnable runnable = () -> WarnMailUtil.sendCpuWarnInfo((CpuState)bean);
        ThreadPoolUtil.executor.execute(runnable);
    }

    private void addLoadState(JSONObject loadJson, Date nowtime, String bindIp) throws Exception {
        SysLoadState bean = new SysLoadState();
        bean.setHostname(bindIp);
        bean.setOneLoad(loadJson.getDouble((Object)"load1"));
        bean.setFiveLoad(loadJson.getDouble((Object)"load5"));
        bean.setFifteenLoad(loadJson.getDouble((Object)"load15"));
        bean.setCreateTime(nowtime);
        BatchData.SYSLOAD_STATE_LIST.add(bean);
    }

    private void addNetIoState(JSONObject netIOCountersJson, Date nowtime, String bindIp) throws Exception {
        NetIoState bean = new NetIoState();
        bean.setRxbyt(FormatUtil.formatDouble((Double)netIOCountersJson.getDouble((Object)"res_recv_bytes"), (int)2) + "");
        bean.setTxbyt(FormatUtil.formatDouble((Double)netIOCountersJson.getDouble((Object)"res_sent_bytes"), (int)2) + "");
        bean.setTxpck(FormatUtil.formatDouble((Double)netIOCountersJson.getDouble((Object)"res_sent_packets"), (int)2) + "");
        bean.setRxpck(FormatUtil.formatDouble((Double)netIOCountersJson.getDouble((Object)"res_recv_packets"), (int)2) + "");
        bean.setCreateTime(nowtime);
        bean.setHostname(bindIp);
        BatchData.NETIO_STATE_LIST.add(bean);
    }

    private void addAppState(JSONObject processListJson, Date nowtime, String bindIp) throws Exception {
        ArrayList keys = new ArrayList(processListJson.keySet());
        for (String proId : keys) {
            String[] vals = processListJson.getStr((Object)proId).split(",");
            AppInfo appInfo = new AppInfo();
            appInfo.setHostname(bindIp);
            appInfo.setId(proId);
            appInfo.setCreateTime(nowtime);
            appInfo.setState(StaticKeys.ON_STATE);
            appInfo.setMemPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[1]), (int)2)));
            appInfo.setCpuPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[0]), (int)2)));
            if (appInfo.getCpuPer() < 0.0) continue;
            BatchData.APP_INFO_LIST.add(appInfo);
            AppState appState = new AppState();
            appState.setAppInfoId(proId);
            appState.setCreateTime(nowtime);
            appState.setCpuPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[0]), (int)2)));
            appState.setMemPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[1]), (int)2)));
            BatchData.APP_STATE_LIST.add(appState);
        }
    }

    private void addDockerState(JSONObject dockersJson, Date nowtime, String bindIp) throws Exception {
        ArrayList keys = new ArrayList(dockersJson.keySet());
        for (String dockerId : keys) {
            String[] vals = dockersJson.getStr((Object)dockerId).split(",");
            DockerInfo dockerInfo = new DockerInfo();
            dockerInfo.setId(dockerId);
            dockerInfo.setCreateTime(nowtime);
            dockerInfo.setState(StaticKeys.ON_STATE);
            dockerInfo.setHostname(bindIp);
            dockerInfo.setMemPer(Double.valueOf(FormatUtil.formatDouble((Double)Double.valueOf(vals[2]), (int)2)));
            dockerInfo.setSystemTime(FormatUtil.formatDouble((Double)Double.valueOf(vals[0]), (int)2) + "");
            dockerInfo.setUserTime(FormatUtil.formatDouble((Double)Double.valueOf(vals[1]), (int)2) + "");
            if (Double.valueOf(vals[0]) < 0.0) continue;
            BatchData.DOCKER_INFO_LIST.add(dockerInfo);
            DockerState dockerState = new DockerState();
            dockerState.setDockerInfoId(dockerId);
            dockerState.setCreateTime(nowtime);
            dockerState.setMemPer(dockerInfo.getMemPer());
            BatchData.DOCKER_STATE_LIST.add(dockerState);
        }
    }

    private void addSystemInfo(JSONObject hostInfoJson, JSONObject cpuInfoJson, Double cpuPercentVal, Double memPercentVal, Double memTotalVal, Date nowtime, String bindIp, String submitSeconds) throws Exception {
        SystemInfo bean = new SystemInfo();
        bean.setSubmitSeconds(submitSeconds);
        bean.setState(StaticKeys.ON_STATE);
        bean.setHostname(bindIp);
        bean.setCreateTime(nowtime);
        bean.setBootTime(hostInfoJson.getLong((Object)"bootTime"));
        bean.setUptime(hostInfoJson.getLong((Object)"uptime"));
        bean.setCpuPer(cpuPercentVal);
        bean.setMemPer(memPercentVal);
        bean.setProcs(hostInfoJson.getStr((Object)"procs"));
        bean.setCpuCoreNum(cpuInfoJson.getInt((Object)"cores") + "");
        bean.setCpuXh(cpuInfoJson.getStr((Object)"modelName"));
        bean.setPlatForm(hostInfoJson.getStr((Object)"platform"));
        bean.setPlatformVersion(hostInfoJson.getStr((Object)"platformVersion"));
        bean.setTotalMem(memTotalVal + "G");
        BatchData.SYSTEM_INFO_LIST.add(bean);
    }

    private void addDeskState(JSONObject diskInfoListJson, Date nowtime, String bindIp) throws Exception {
        ArrayList keys = new ArrayList(diskInfoListJson.keySet());
        int usedSum = 0;
        int availSum = 0;
        int sizeSum = 0;
        for (String diskname : keys) {
            JSONObject diskJson = diskInfoListJson.getJSONObject((Object)diskname);
            DeskState bean = new DeskState();
            bean.setFileSystem(diskname);
            bean.setHostname(bindIp);
            bean.setCreateTime(nowtime);
            usedSum = (int)((long)usedSum + diskJson.getLong((Object)"used") / 1024L / 1024L / 1024L);
            availSum = (int)((long)availSum + diskJson.getLong((Object)"free") / 1024L / 1024L / 1024L);
            sizeSum = (int)((long)sizeSum + diskJson.getLong((Object)"total") / 1024L / 1024L / 1024L);
            bean.setUsed(diskJson.getLong((Object)"used") / 1024L / 1024L / 1024L + "G");
            bean.setAvail(diskJson.getLong((Object)"free") / 1024L / 1024L / 1024L + "G");
            bean.setSize(diskJson.getLong((Object)"total") / 1024L / 1024L / 1024L + "G");
            bean.setUsePer(FormatUtil.formatDouble((Double)diskJson.getDouble((Object)"usedPercent"), (int)2) + "%");
            BatchData.DESK_STATE_LIST.add(bean);
        }
    }
}

