/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/code"})
public class CodeController {
    private static final Logger logger = LoggerFactory.getLogger(CodeController.class);
    private int codeCount = 4;
    char[] codeSequence = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    @RequestMapping(value={"get"})
    public void hostInfoList(Model model, HttpServletRequest req, HttpServletResponse resp) {
        int xx = 13;
        int codeY = 22;
        int width = 70;
        int height = 30;
        int fontHeight = 20;
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics gd = buffImg.getGraphics();
        Random random = new Random();
        gd.setColor(Color.getColor("#ef3f22"));
        gd.fillRect(0, 0, width, height);
        Font font = new Font("ITALIC", 0, fontHeight);
        gd.setFont(font);
        gd.setColor(Color.BLACK);
        gd.drawRect(0, 0, width - 1, height - 1);
        StringBuilder randomCode = new StringBuilder();
        int red = 0;
        int green = 0;
        int blue = 0;
        Font font2 = new Font("Fixedsys", 1, fontHeight);
        gd.setFont(font2);
        for (int i = 0; i < this.codeCount; ++i) {
            String code = String.valueOf(this.codeSequence[random.nextInt(this.codeSequence.length)]);
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            gd.drawString(code, (i + 1) * xx, codeY);
            randomCode.append(code);
        }
        HttpSession session = req.getSession();
        session.setAttribute("valcode", (Object)randomCode.toString());
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setDateHeader("Expires", 0L);
        resp.setContentType("image/jpeg");
        try {
            ServletOutputStream sos = resp.getOutputStream();
            ImageIO.write((RenderedImage)buffImg, "jpeg", (OutputStream)sos);
            sos.close();
        }
        catch (IOException e) {
            logger.error("\u751f\u6210\u9a8c\u8bc1\u7801\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

