/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.DbInfo;
import com.wgcloud.entity.DbTable;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.DbInfoService;
import com.wgcloud.service.DbTableCountService;
import com.wgcloud.service.DbTableService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/dbTable"})
public class DbTableController {
    private static final Logger logger = LoggerFactory.getLogger(DbTableController.class);
    @Resource
    private DbInfoService dbInfoService;
    @Resource
    private DbTableService dbTableService;
    @Resource
    private DbTableCountService dbTableCountService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private DashboardService dashboardService;

    @RequestMapping(value={"list"})
    public String DbTableList(DbTable DbTable2, Model model) {
        HashMap params = new HashMap();
        try {
            PageInfo pageInfo = this.dbTableService.selectByParams(params, DbTable2.getPage().intValue(), DbTable2.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            List dbInfoList = this.dbInfoService.selectAllByParams(params);
            for (DbTable dbTable : pageInfo.getList()) {
                for (DbInfo dbInfo : dbInfoList) {
                    if (!dbInfo.getId().equals(dbTable.getDbInfoId())) continue;
                    dbTable.setTableName(dbInfo.getAliasName());
                }
            }
            model.addAttribute("pageUrl", (Object)"/dbTable/list?1=1");
            model.addAttribute("page", (Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u8868\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u6570\u636e\u8868\u4fe1\u606f\u9519\u8bef", e.toString(), "1");
        }
        return "mysql/list";
    }

    @RequestMapping(value={"save"})
    public String saveDbTable(DbTable DbTable2, Model model, HttpServletRequest request) {
        try {
            String whereVal = DbTable2.getWhereVal().toLowerCase();
            if (!StringUtils.isEmpty((CharSequence)whereVal)) {
                String[] sqlinkeys = "execute,update,delete,insert,create,drop,alter,rename,modify".split(",");
                whereVal = whereVal.toLowerCase();
                for (String sqlinkey : sqlinkeys) {
                    if (whereVal.indexOf(sqlinkey) <= -1) continue;
                    model.addAttribute("dbTable", (Object)DbTable2);
                    List dbInfoList = this.dbInfoService.selectAllByParams(new HashMap());
                    model.addAttribute("dbInfoList", (Object)dbInfoList);
                    model.addAttribute("msg", (Object)("where\u8bed\u53e5\u542b\u6709sql\u654f\u611f\u5b57\u7b26" + sqlinkey + "\uff0c\u8bf7\u68c0\u67e5"));
                    return "mysql/add";
                }
            }
            if (StringUtils.isEmpty((CharSequence)DbTable2.getId())) {
                this.dbTableService.save(DbTable2);
            } else {
                this.dbTableService.updateById(DbTable2);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u8868\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u4fdd\u5b58\u6570\u636e\u8868\u9519\u8bef", e.toString(), "1");
        }
        return "redirect:/dbTable/list";
    }

    @RequestMapping(value={"edit"})
    public String editDbTable(DbTable DbTable2, Model model, HttpServletRequest request) {
        try {
            String id = request.getParameter("id");
            DbTable dbTableInfo = new DbTable();
            if (!StringUtils.isEmpty((CharSequence)id)) {
                dbTableInfo = this.dbTableService.selectById(id);
            }
            List dbInfoList = this.dbInfoService.selectAllByParams(new HashMap());
            model.addAttribute("dbInfoList", (Object)dbInfoList);
            model.addAttribute("dbTable", (Object)dbTableInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u6570\u636e\u8868\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u67e5\u770b\u6570\u636e\u8868\u9519\u8bef", e.toString(), "1");
        }
        return "mysql/add";
    }

    @RequestMapping(value={"viewChart"})
    public String viewChartDbTable(DbTable DbTable2, Model model, HttpServletRequest request) {
        try {
            String id = request.getParameter("id");
            String date = request.getParameter("date");
            if (!StringUtils.isEmpty((CharSequence)id)) {
                DbTable dbTableInfo = this.dbTableService.selectById(id);
                HashMap<String, String> params = new HashMap<String, String>();
                if (StringUtils.isEmpty((CharSequence)date)) {
                    date = DateUtil.getCurrentDate();
                }
                this.dashboardService.setDateParam(date, params);
                model.addAttribute("datenow", (Object)date);
                model.addAttribute("dateList", (Object)this.dashboardService.getDateList());
                params.put("dbTableId", id);
                List dbTableCounts = this.dbTableCountService.selectAllByParams(params);
                model.addAttribute("dbTableCounts", (Object)JSONUtil.parseArray((Object)dbTableCounts));
                model.addAttribute("dbTable", (Object)dbTableInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u6570\u636e\u8868\u56fe\u8868\u7edf\u8ba1\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u67e5\u770b\u6570\u636e\u8868\u56fe\u8868\u7edf\u8ba1\u9519\u8bef", e.toString(), "1");
        }
        return "mysql/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u6570\u636e\u6e90\u8868\u4fe1\u606f\u9519\u8bef\uff1a";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                DbTable dbTable = this.dbTableService.selectById(request.getParameter("id"));
                this.logInfoService.save("\u5220\u9664\u6570\u636e\u8868\uff1a" + dbTable.getTableName(), "\u5220\u9664\u6570\u636e\u8868\uff1a" + dbTable.getTableName(), "1");
                this.dbTableService.deleteById(request.getParameter("id").split(","));
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(errorMsg, e.toString(), "1");
        }
        return "redirect:/dbTable/list";
    }
}

