/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import cn.hutool.json.JSONUtil;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.service.DashboardService;
import com.wgcloud.service.HeathMonitorService;
import com.wgcloud.service.HeathStateService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.PageUtil;
import com.wgcloud.util.license.LicenseUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/heathMonitor"})
public class HeathMonitorController {
    private static final Logger logger = LoggerFactory.getLogger(HeathMonitorController.class);
    @Resource
    private HeathMonitorService heathMonitorService;
    @Resource
    private HeathStateService heathStateService;
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private DashboardService dashboardService;

    @RequestMapping(value={"list"})
    public String heathMonitorList(HeathMonitor HeathMonitor2, Model model, HttpServletRequest request) {
        String liceFlage = request.getParameter("liceFlage");
        HashMap params = new HashMap();
        try {
            if (!StringUtils.isEmpty((CharSequence)liceFlage)) {
                LicenseUtil.checkHeathList((Model)model);
            }
            PageInfo pageInfo = this.heathMonitorService.selectByParams(params, HeathMonitor2.getPage().intValue(), HeathMonitor2.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)"/heathMonitor/list?1=1");
            model.addAttribute("page", (Object)pageInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u670d\u52a1\u5fc3\u8df3\u76d1\u63a7\u9519\u8bef", (Throwable)e);
            this.logInfoService.save("\u67e5\u8be2\u5fc3\u8df3\u76d1\u63a7\u9519\u8bef", e.toString(), "1");
        }
        return "heath/list";
    }

    @RequestMapping(value={"save"})
    public String saveHeathMonitor(HeathMonitor HeathMonitor2, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)HeathMonitor2.getId())) {
                this.heathMonitorService.save(HeathMonitor2);
            } else {
                this.heathMonitorService.updateById(HeathMonitor2);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u670d\u52a1\u5fc3\u8df3\u76d1\u63a7\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(HeathMonitor2.getAppName(), "\u4fdd\u5b58\u5fc3\u8df3\u76d1\u63a7\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "redirect:/heathMonitor/list";
    }

    @RequestMapping(value={"edit"})
    public String edit(Model model, HttpServletRequest request) {
        String errorMsg = "\u7f16\u8f91\u670d\u52a1\u5fc3\u8df3\u76d1\u63a7\uff1a";
        String id = request.getParameter("id");
        HeathMonitor heathMonitor = new HeathMonitor();
        try {
            if (StringUtils.isEmpty((CharSequence)id)) {
                model.addAttribute("heathMonitor", (Object)heathMonitor);
                HashMap params = new HashMap();
                int dbSize = this.heathMonitorService.countByParams(params);
                if (dbSize >= 10 && !StaticKeys.LICENSE_STATE.equals("1")) {
                    return "redirect:/heathMonitor/list?liceFlage=1";
                }
                return "heath/add";
            }
            heathMonitor = this.heathMonitorService.selectById(id);
            model.addAttribute("heathMonitor", (Object)heathMonitor);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(heathMonitor.getAppName(), errorMsg + e.toString(), "1");
        }
        return "heath/add";
    }

    @RequestMapping(value={"view"})
    public String view(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u670d\u52a1\u5fc3\u8df3\u7edf\u8ba1\u56fe\u8868\u9519\u8bef\uff1a";
        String id = request.getParameter("id");
        String date = request.getParameter("date");
        HeathMonitor heathMonitor = new HeathMonitor();
        try {
            heathMonitor = this.heathMonitorService.selectById(id);
            HashMap<String, String> params = new HashMap<String, String>();
            model.addAttribute("heathMonitor", (Object)heathMonitor);
            if (StringUtils.isEmpty((CharSequence)date)) {
                date = DateUtil.getCurrentDate();
            }
            this.dashboardService.setDateParam(date, params);
            model.addAttribute("datenow", (Object)date);
            model.addAttribute("dateList", (Object)this.dashboardService.getDateList());
            model.addAttribute("amList", (Object)this.dashboardService.getAmList());
            params.put("heathId", heathMonitor.getId());
            List appStateList = this.heathStateService.selectAllByParams(params);
            model.addAttribute("heathStateList", (Object)JSONUtil.parseArray((Object)appStateList));
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(heathMonitor.getAppName(), errorMsg + e.toString(), "1");
        }
        return "heath/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u670d\u52a1\u5fc3\u8df3\u76d1\u63a7\u9519\u8bef\uff1a";
        HeathMonitor HeathMonitor2 = new HeathMonitor();
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                HeathMonitor2 = this.heathMonitorService.selectById(request.getParameter("id"));
                this.logInfoService.save("\u5220\u9664\u670d\u52a1\u5fc3\u8df3\u76d1\u63a7\uff1a" + HeathMonitor2.getAppName(), "\u5220\u9664\u670d\u52a1\u5fc3\u8df3\u76d1\u63a7\uff1a" + HeathMonitor2.getAppName() + "\uff1a" + HeathMonitor2.getHeathUrl(), "1");
                this.heathMonitorService.deleteById(request.getParameter("id").split(","));
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(HeathMonitor2.getAppName(), errorMsg + e.toString(), "1");
        }
        return "redirect:/heathMonitor/list";
    }
}

