/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.HostGroup;
import com.wgcloud.service.HostGroupService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.service.SystemInfoService;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hostGroup"})
public class HostGroupController {
    private static final Logger logger = LoggerFactory.getLogger(HostGroupController.class);
    @Resource
    private HostGroupService hostGroupService;
    @Resource
    private SystemInfoService systemInfoService;
    @Resource
    private LogInfoService logInfoService;

    @RequestMapping(value={"list"})
    public String HostGroupList(HostGroup HostGroup2, Model model, HttpServletRequest request) {
        HashMap params = new HashMap();
        try {
            PageInfo pageInfo = this.hostGroupService.selectByParams(params, Integer.valueOf(HostGroup2.getPage()).intValue(), Integer.valueOf(HostGroup2.getPageSize()).intValue());
            model.addAttribute("page", (Object)pageInfo);
            String msg = request.getParameter("msg");
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                model.addAttribute("msg", (Object)"\u5220\u9664\u5931\u8d25\uff0c\u673a\u7ec4\u5df2\u7ecf\u88ab\u5e94\u7528");
            } else {
                model.addAttribute("msg", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            this.logInfoService.save("HostGroupList", "\u67e5\u8be2\u673a\u7ec4\u5217\u8868\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "hostGroup/list";
    }

    @RequestMapping(value={"add"})
    public String addHostGroup(HostGroup HostGroup2, Model model) {
        return "hostGroup/add";
    }

    @ResponseBody
    @RequestMapping(value={"save"})
    public String saveHostGroup(HostGroup HostGroup2, Model model, HttpServletRequest request) {
        try {
            if (StringUtils.isEmpty((CharSequence)HostGroup2.getId())) {
                this.hostGroupService.save(HostGroup2);
            } else {
                HostGroup ho = this.hostGroupService.selectById(HostGroup2.getId());
                ho.setRemark(HostGroup2.getRemark());
                ho.setGroupName(HostGroup2.getGroupName());
                this.hostGroupService.updateById(ho);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u673a\u7ec4\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save(HostGroup2.getGroupName(), "\u4fdd\u5b58\u673a\u7ec4\u9519\u8bef\uff1a" + e.toString(), "1");
        }
        return "redirect:/hostGroup/list";
    }

    @RequestMapping(value={"view"})
    public String viewHostGroup(Model model, HttpServletRequest request) {
        String errorMsg = "\u67e5\u770b\u673a\u7ec4\u9519\u8bef\uff1a";
        String id = request.getParameter("id");
        HostGroup HostGroup2 = new HostGroup();
        try {
            HostGroup2 = this.hostGroupService.selectById(id);
            model.addAttribute("HostGroup", (Object)HostGroup2);
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(HostGroup2.getGroupName(), errorMsg + e.toString(), "1");
        }
        return "hostGroup/view";
    }

    @RequestMapping(value={"del"})
    public String delete(Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String errorMsg = "\u5220\u9664\u673a\u7ec4\u4fe1\u606f\u9519\u8bef\uff1a";
        String groupName = "";
        try {
            if (!StringUtils.isEmpty((CharSequence)request.getParameter("id"))) {
                HostGroup HostGroup2 = this.hostGroupService.selectById(request.getParameter("id"));
                groupName = HostGroup2.getGroupName();
                HashMap<String, String> searchMap = new HashMap<String, String>();
                searchMap.put("groupId", HostGroup2.getId());
                int count = this.systemInfoService.countByParams(searchMap);
                if (count > 0) {
                    this.logInfoService.save(groupName, "\u673a\u7ec4\u5df2\u7ecf\u88ab\u5e94\u7528\uff0c\u65e0\u6cd5\u5220\u9664", "1");
                } else {
                    this.hostGroupService.deleteById(request.getParameter("id").split(","));
                }
            }
        }
        catch (Exception e) {
            logger.error(errorMsg, (Throwable)e);
            this.logInfoService.save(groupName, errorMsg + e.toString(), "1");
        }
        return "redirect:/hostGroup/list?msg=delErr";
    }
}

