/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.controller;

import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.LogInfo;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.CodeUtil;
import com.wgcloud.util.PageUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/log"})
public class LogInfoController {
    private static final Logger logger = LoggerFactory.getLogger(LogInfoController.class);
    @Resource
    private LogInfoService logInfoService;

    @RequestMapping(value={"list"})
    public String LogInfoList(LogInfo logInfo, Model model) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            StringBuffer url = new StringBuffer();
            String hostname = null;
            if (!StringUtils.isEmpty((CharSequence)logInfo.getHostname())) {
                hostname = CodeUtil.unescape((String)logInfo.getHostname());
                params.put("hostname", hostname.trim());
                url.append("&hostname=").append(CodeUtil.escape((String)hostname));
            }
            PageInfo pageInfo = this.logInfoService.selectByParams(params, logInfo.getPage().intValue(), logInfo.getPageSize().intValue());
            PageUtil.initPageNumber((PageInfo)pageInfo, (Model)model);
            model.addAttribute("pageUrl", (Object)("/log/list?1=1" + url.toString()));
            model.addAttribute("page", (Object)pageInfo);
            model.addAttribute("logInfo", (Object)logInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
        return "log/list";
    }

    @RequestMapping(value={"view"})
    public String viewLogInfo(Model model, HttpServletRequest request) {
        String id = request.getParameter("id");
        try {
            LogInfo logInfo = this.logInfoService.selectById(id);
            model.addAttribute("logInfo", (Object)logInfo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return "log/view";
    }
}

