/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.wgcloud.dto.MessageDto;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    public List<String> getDateList() {
        int days = 10;
        if (!StaticKeys.LICENSE_STATE.equals("1")) {
            days = 5;
        }
        ArrayList<String> dateList = new ArrayList<String>();
        String nowTime = DateUtil.getCurrentDateTime();
        String sevenDayBefore = DateUtil.getDateBefore((String)nowTime, (int)days);
        for (int i = 0; i < days; ++i) {
            sevenDayBefore = DateUtil.getDateBefore((String)nowTime, (int)i);
            dateList.add(sevenDayBefore.substring(0, 10));
        }
        return dateList;
    }

    public List<MessageDto> getAmList() {
        MessageDto dto1 = new MessageDto();
        dto1.setCode("am1");
        dto1.setMsg("00:00\u81f305:59");
        MessageDto dto2 = new MessageDto();
        dto2.setCode("am2");
        dto2.setMsg("06:00\u81f311:59");
        MessageDto dto3 = new MessageDto();
        dto3.setCode("am3");
        dto3.setMsg("12:00\u81f317:59");
        MessageDto dto4 = new MessageDto();
        dto4.setCode("am4");
        dto4.setMsg("18:00\u81f323:59");
        ArrayList<MessageDto> timeList = new ArrayList<MessageDto>();
        timeList.add(dto1);
        timeList.add(dto2);
        timeList.add(dto3);
        timeList.add(dto4);
        return timeList;
    }

    public String getDefaultAm() {
        int hour = DateUtil.getHour((Date)new Date());
        if (hour > 0 && hour < 6) {
            return "am1";
        }
        if (hour >= 6 && hour < 12) {
            return "am2";
        }
        if (hour >= 12 && hour < 18) {
            return "am3";
        }
        if (hour >= 18 && hour <= 23) {
            return "am4";
        }
        return "am2";
    }

    public void setDateParam(String am, String date, Map<String, Object> params) {
        if ("am1".equals(am)) {
            params.put("startTime", date + " 00:00:00");
            params.put("endTime", date + " 05:59:59");
        }
        if ("am2".equals(am)) {
            params.put("startTime", date + " 06:00:00");
            params.put("endTime", date + " 11:59:59");
        }
        if ("am3".equals(am)) {
            params.put("startTime", date + " 12:00:00");
            params.put("endTime", date + " 17:59:59");
        }
        if ("am4".equals(am)) {
            params.put("startTime", date + " 18:00:00");
            params.put("endTime", date + " 23:59:59");
        }
    }

    public void setDateParam(String date, Map<String, Object> params) {
        params.put("startTime", date + " 00:00:00");
        params.put("endTime", date + " 23:59:59");
    }
}

