/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.DockerInfo;
import com.wgcloud.mapper.DockerInfoMapper;
import com.wgcloud.mapper.DockerStateMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DockerInfoService {
    @Autowired
    private DockerInfoMapper dockerInfoMapper;
    @Autowired
    private DockerStateMapper dockerStateMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.dockerInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(DockerInfo DockerInfo2) throws Exception {
        DockerInfo2.setId(UUIDUtil.getUUID());
        DockerInfo2.setCreateTime((Date)DateUtil.getNowTime());
        if (!StringUtils.isEmpty((CharSequence)DockerInfo2.getDockerId())) {
            DockerInfo2.setDockerId(DockerInfo2.getDockerId().trim());
        }
        this.dockerInfoMapper.save(DockerInfo2);
    }

    public int deleteByHostName(Map<String, Object> map) throws Exception {
        return this.dockerInfoMapper.deleteByHostName(map);
    }

    @Transactional
    public void saveRecord(List<DockerInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        for (DockerInfo as : recordList) {
            as.setId(UUIDUtil.getUUID());
        }
        this.dockerInfoMapper.insertList(recordList);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.dockerInfoMapper.countByParams(params);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        for (String DockerInfoId : id) {
            this.dockerStateMapper.deleteByDockerInfoId(DockerInfoId);
        }
        return this.dockerInfoMapper.deleteById(id);
    }

    @Transactional
    public void updateRecord(List<DockerInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        this.dockerInfoMapper.updateList(recordList);
    }

    public void updateById(DockerInfo DockerInfo2) throws Exception {
        this.dockerInfoMapper.updateById(DockerInfo2);
    }

    public DockerInfo selectById(String id) throws Exception {
        return this.dockerInfoMapper.selectById(id);
    }

    public List<DockerInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.dockerInfoMapper.selectAllByParams(params);
    }
}

