/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.HeathMonitor;
import com.wgcloud.mapper.HeathMonitorMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HeathMonitorService {
    @Autowired
    private HeathMonitorMapper heathMonitorMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.heathMonitorMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(HeathMonitor HeathMonitor2) throws Exception {
        HeathMonitor2.setId(UUIDUtil.getUUID());
        HeathMonitor2.setCreateTime((Date)DateUtil.getNowTime());
        if (StringUtils.isEmpty((CharSequence)HeathMonitor2.getHeathUrl())) {
            HeathMonitor2.setHeathUrl(HeathMonitor2.getHeathUrl().trim());
        }
        this.heathMonitorMapper.save(HeathMonitor2);
    }

    @Transactional
    public void saveRecord(List<HeathMonitor> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        for (HeathMonitor as : recordList) {
            as.setId(UUIDUtil.getUUID());
        }
        this.heathMonitorMapper.insertList(recordList);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.heathMonitorMapper.countByParams(params);
    }

    @Transactional
    public int deleteById(String[] id) throws Exception {
        return this.heathMonitorMapper.deleteById(id);
    }

    public void updateById(HeathMonitor HeathMonitor2) throws Exception {
        if (StringUtils.isEmpty((CharSequence)HeathMonitor2.getHeathUrl())) {
            HeathMonitor2.setHeathUrl(HeathMonitor2.getHeathUrl().trim());
        }
        this.heathMonitorMapper.updateById(HeathMonitor2);
    }

    public HeathMonitor selectById(String id) throws Exception {
        return this.heathMonitorMapper.selectById(id);
    }

    @Transactional
    public void updateRecord(List<HeathMonitor> recordList) throws Exception {
        this.heathMonitorMapper.updateList(recordList);
    }

    public List<HeathMonitor> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.heathMonitorMapper.selectAllByParams(params);
    }
}

