/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.LogInfo;
import com.wgcloud.mapper.LogInfoMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogInfoService {
    private static final Logger logger = LoggerFactory.getLogger(LogInfoService.class);
    @Autowired
    private LogInfoMapper logInfoMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.logInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void saveRecord(List<LogInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        HashMap map = new HashMap();
        for (LogInfo as : recordList) {
            as.setId(UUIDUtil.getUUID());
        }
        this.logInfoMapper.insertList(recordList);
    }

    public void save(String hostname, String infoContent, String state) {
        LogInfo logInfo = new LogInfo();
        logInfo.setHostname(hostname);
        logInfo.setInfoContent(infoContent);
        logInfo.setState(state);
        logInfo.setId(UUIDUtil.getUUID());
        logInfo.setCreateTime((Date)DateUtil.getNowTime());
        try {
            this.logInfoMapper.save(logInfo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.logInfoMapper.countByParams(params);
    }

    public int deleteById(String[] id) throws Exception {
        return this.logInfoMapper.deleteById(id);
    }

    public LogInfo selectById(String id) throws Exception {
        return this.logInfoMapper.selectById(id);
    }

    public List<LogInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.logInfoMapper.selectAllByParams(params);
    }
}

