/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wgcloud.entity.SystemInfo;
import com.wgcloud.mapper.SystemInfoMapper;
import com.wgcloud.util.DateUtil;
import com.wgcloud.util.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemInfoService {
    @Autowired
    private SystemInfoMapper systemInfoMapper;

    public PageInfo selectByParams(Map<String, Object> params, int currPage, int pageSize) throws Exception {
        PageHelper.startPage((int)currPage, (int)pageSize);
        List list = this.systemInfoMapper.selectByParams(params);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public void save(SystemInfo SystemInfo2) throws Exception {
        SystemInfo2.setId(UUIDUtil.getUUID());
        SystemInfo2.setCreateTime((Date)DateUtil.getNowTime());
        this.systemInfoMapper.save(SystemInfo2);
    }

    @Transactional
    public void saveRecord(List<SystemInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        for (SystemInfo as : recordList) {
            as.setId(UUIDUtil.getUUID());
            as.setCreateTime((Date)DateUtil.getNowTime());
        }
        this.systemInfoMapper.insertList(recordList);
    }

    @Transactional
    public void updateRecord(List<SystemInfo> recordList) throws Exception {
        if (recordList.size() < 1) {
            return;
        }
        this.systemInfoMapper.updateList(recordList);
    }

    @Transactional
    public void updateById(SystemInfo SystemInfo2) throws Exception {
        this.systemInfoMapper.updateById(SystemInfo2);
    }

    public int deleteById(String[] id) throws Exception {
        return this.systemInfoMapper.deleteById(id);
    }

    public SystemInfo selectById(String id) throws Exception {
        return this.systemInfoMapper.selectById(id);
    }

    public List<SystemInfo> selectAllByParams(Map<String, Object> params) throws Exception {
        return this.systemInfoMapper.selectAllByParams(params);
    }

    public int countByParams(Map<String, Object> params) throws Exception {
        return this.systemInfoMapper.countByParams(params);
    }

    public List<SystemInfo> selectByAccountId(String accountId) throws Exception {
        return this.systemInfoMapper.selectByAccountId(accountId);
    }

    public int deleteByAccHname(Map<String, Object> params) throws Exception {
        return this.systemInfoMapper.deleteByAccHname(params);
    }
}

