/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud.util.jdbc;

import com.wgcloud.entity.DbInfo;
import com.wgcloud.service.DbInfoService;
import com.wgcloud.service.LogInfoService;
import com.wgcloud.util.ThreadPoolUtil;
import com.wgcloud.util.msg.WarnMailUtil;
import com.wgcloud.util.staticvar.StaticKeys;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

@Component
public class ConnectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionUtil.class);
    @Resource
    private LogInfoService logInfoService;
    @Resource
    private DbInfoService dbInfoService;

    public JdbcTemplate getJdbcTemplate(DbInfo dbInfo) throws Exception {
        JdbcTemplate jdbcTemplate = null;
        String driver = "";
        String url = "";
        if ("mysql".equals(dbInfo.getDbType())) {
            driver = "com.mysql.jdbc.Driver";
            url = "jdbc:mysql://{ip}:{port}/{dbname}?characterEncoding=utf-8&characterSetResults=utf8&autoReconnect=true&useSSL=false";
        } else if ("postgresql".equals(dbInfo.getDbType())) {
            driver = "org.postgresql.Driver";
            url = "jdbc:postgresql://{ip}:{port}/{dbname}";
        } else if ("sqlserver".equals(dbInfo.getDbType())) {
            driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            url = "jdbc:sqlserver://{ip}:{port};DatabaseName={dbname}";
        } else if ("db2".equals(dbInfo.getDbType())) {
            driver = "com.ibm.db2.jdbc.app.DB2Driver";
            url = "jdbc:db2://{ip}:{port}/{dbname}";
        } else {
            driver = "oracle.jdbc.driver.OracleDriver";
            url = "jdbc:oracle:thin:@{ip}:{port}:{dbname}";
        }
        url = url.replace("{ip}", dbInfo.getIp()).replace("{port}", dbInfo.getPort()).replace("{dbname}", dbInfo.getDbName());
        try {
            DriverManagerDataSource dataSource = new DriverManagerDataSource();
            dataSource.setDriverClassName(driver);
            dataSource.setUrl(url);
            dataSource.setUsername(dbInfo.getUser());
            dataSource.setPassword(dbInfo.getPasswd());
            jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
            jdbcTemplate.setQueryTimeout(30);
            if ("mysql".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select version()");
            } else if ("postgresql".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("select version()");
            } else if ("sqlserver".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("SELECT @@VERSION");
            } else if ("db2".equals(dbInfo.getDbType())) {
                jdbcTemplate.queryForRowSet("SELECT SERVICE_LEVEL FROM SYSIBMADM.ENV_INST_INFO");
            } else {
                jdbcTemplate.queryForRowSet("select * from v$version");
            }
            dbInfo.setDbState(StaticKeys.ON_STATE);
            this.dbInfoService.updateById(dbInfo);
            return jdbcTemplate;
        }
        catch (Exception e) {
            jdbcTemplate = null;
            logger.error("\u8fde\u63a5\u6570\u636e\u5e93\u9519\u8bef", (Throwable)e);
            dbInfo.setDbState(StaticKeys.DOWN_STATE);
            this.dbInfoService.updateById(dbInfo);
            Runnable runnable = () -> WarnMailUtil.sendDbDown((DbInfo)dbInfo, (boolean)true);
            ThreadPoolUtil.executor.execute(runnable);
            return null;
        }
    }

    public long queryTableCount(DbInfo dbInfo, String sql) {
        try {
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate(dbInfo);
            if (null == jdbcTemplate) {
                return 0L;
            }
            return (Long)jdbcTemplate.queryForObject(sql, Long.class);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u6570\u636e\u8868\u9519\u8bef\uff1a", (Throwable)e);
            this.logInfoService.save("\u7edf\u8ba1\u6570\u636e\u8868sql\u6267\u884c\u9519\u8bef\uff1a" + dbInfo.getAliasName(), "IP\uff1a" + dbInfo.getIp() + "\uff0c\u7aef\u53e3\uff1a" + dbInfo.getPort() + "\uff0c\u6570\u636e\u5e93\u522b\u540d\uff1a" + dbInfo.getAliasName() + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.toString(), "1");
            return 0L;
        }
    }
}

