/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.code.commons.plugin;

import cn.wizzer.app.code.commons.plugin.ui.ConfigDialog;
import cn.wizzer.app.code.commons.plugin.ui.ErrorDialog;
import cn.wizzer.app.code.commons.plugin.utils.GenerateConfig;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;

public class GeneratorAction
extends AnAction {
    Project project = null;

    public void actionPerformed(AnActionEvent e) {
        this.project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiClass rootClass = this.getTargetClass(e, editor);
        if (null == rootClass) {
            new ErrorDialog(this.project).show();
            return;
        }
        ConfigDialog fieldDialog = null;
        try {
            fieldDialog = new ConfigDialog(rootClass);
        }
        catch (Exception ex) {
            new ErrorDialog(this.project, "error", "\npackage\u540d\u6210\u4e0d\u89c4\u8303").show();
            return;
        }
        fieldDialog.show();
        if (!fieldDialog.isOK()) {
            return;
        }
        this.generateCode(rootClass, fieldDialog.getGenerateConfig());
    }

    private void generateCode(PsiClass rootClass, GenerateConfig generateConfig) {
        Module[] modules;
        RunManager runManager = RunManager.getInstance((Project)this.project);
        ApplicationConfiguration appConfig = new ApplicationConfiguration("generator", this.project, ApplicationConfigurationType.getInstance());
        appConfig.MAIN_CLASS_NAME = "cn.wizzer.app.code.commons.builder.Generator";
        String entityClassName = rootClass.getName();
        StringBuilder programArgs = new StringBuilder();
        programArgs.append("-i ").append(entityClassName).append(" -u ").append(generateConfig.getBaseUri()).append(" -b ").append(generateConfig.getBaseModelPath()).append(" -y ").append(generateConfig.getBaseComPath()).append(" -n ").append(generateConfig.getBaseNbPath()).append(" -j ").append(this.project.getBasePath()).append(" -o ").append(generateConfig.getBasePath()).append(" -p ").append(generateConfig.getBasePackage()).append(generateConfig.isForce() ? " -f" : "").append(generateConfig.getPages().length() > 1 ? " -v " + generateConfig.getPages() : "").append(" -mod ").append(generateConfig.getModelPakName()).append(" -ctr ").append(generateConfig.getControllerPakName()).append(" -sev ").append(generateConfig.getServicePakName()).append(" -vue ").append(generateConfig.isVue()).append(generateConfig.isConroller() ? " controller" : "").append(generateConfig.isService() ? " service" : "").append(generateConfig.isLocale() ? " locale" : "").append(generateConfig.isView() ? " view" : "");
        appConfig.PROGRAM_PARAMETERS = programArgs.toString();
        appConfig.WORKING_DIRECTORY = this.project.getBasePath();
        if (!generateConfig.getBasePath().isEmpty()) {
            appConfig.WORKING_DIRECTORY = this.project.getBasePath() + "/" + generateConfig.getBaseModelPath();
        }
        System.out.println("project.getBasePath()::" + this.project.getBasePath());
        System.out.println("generateConfig.getBaseModelPath()::" + generateConfig.getBaseModelPath());
        System.out.println("generateConfig.getBasePath()::" + generateConfig.getBasePath());
        System.out.println("appConfig.WORKING_DIRECTORY::" + appConfig.WORKING_DIRECTORY);
        for (Module module : modules = ModuleManager.getInstance((Project)this.project).getModules()) {
            if (!module.getName().contains("model")) continue;
            appConfig.setModule(module);
            break;
        }
        RunnerAndConfigurationSettings configuration = runManager.createConfiguration((RunConfiguration)appConfig, appConfig.getFactory());
        runManager.addConfiguration(configuration, true);
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
    }

    private PsiClass getTargetClass(AnActionEvent e, Editor editor) {
        PsiFile file = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiClass psiClass = this.getTargetClass(e, editor);
        e.getPresentation().setVisible(null != project && null != editor && null != psiClass && !psiClass.isEnum() && 0 != psiClass.getAllFields().length);
    }
}

