/*QUARTZ_23*/
CREATE TABLE sys_qrtz_job_details(SCHED_NAME VARCHAR2(120) NOT NULL,JOB_NAME  VARCHAR2(200) NOT NULL,JOB_GROUP VARCHAR2(200) NOT NULL,DESCRIPTION VARCHAR2(250) NULL,JOB_CLASS_NAME   VARCHAR2(250) NOT NULL, IS_DURABLE VARCHAR2(1) NOT NULL,IS_NONCONCURRENT VARCHAR2(1) NOT NULL,IS_UPDATE_DATA VARCHAR2(1) NOT NULL,REQUESTS_RECOVERY VARCHAR2(1) NOT NULL,JOB_DATA BLOB NULL,CONSTRAINT JOB_DETAILS_PK PRIMARY KEY (SCHED_NAME,JOB_NAME,JOB_GROUP))
/*QUARTZ_24*/
CREATE TABLE sys_qrtz_triggers(SCHED_NAME VARCHAR2(120) NOT NULL,TRIGGER_NAME VARCHAR2(200) NOT NULL,TRIGGER_GROUP VARCHAR2(200) NOT NULL,JOB_NAME  VARCHAR2(200) NOT NULL, JOB_GROUP VARCHAR2(200) NOT NULL,DESCRIPTION VARCHAR2(250) NULL,NEXT_FIRE_TIME NUMBER(13) NULL,PREV_FIRE_TIME NUMBER(13) NULL,PRIORITY NUMBER(13) NULL,TRIGGER_STATE VARCHAR2(16) NOT NULL,TRIGGER_TYPE VARCHAR2(8) NOT NULL,START_TIME NUMBER(13) NOT NULL,END_TIME NUMBER(13) NULL,CALENDAR_NAME VARCHAR2(200) NULL,MISFIRE_INSTR NUMBER(2) NULL,JOB_DATA BLOB NULL,CONSTRAINT TRIGGERS_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),CONSTRAINT TRIGGER_TO_JOBS_FK FOREIGN KEY (SCHED_NAME,JOB_NAME,JOB_GROUP) REFERENCES sys_qrtz_JOB_DETAILS(SCHED_NAME,JOB_NAME,JOB_GROUP))
/*QUARTZ_25*/
CREATE TABLE sys_qrtz_simple_triggers(SCHED_NAME VARCHAR2(120) NOT NULL,TRIGGER_NAME VARCHAR2(200) NOT NULL,TRIGGER_GROUP VARCHAR2(200) NOT NULL, REPEAT_COUNT NUMBER(7) NOT NULL,REPEAT_INTERVAL NUMBER(12) NOT NULL,TIMES_TRIGGERED NUMBER(10) NOT NULL,CONSTRAINT SIMPLE_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP), CONSTRAINT SIMPLE_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) REFERENCES sys_qrtz_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP))
/*QUARTZ_26*/
CREATE TABLE sys_qrtz_cron_triggers(SCHED_NAME VARCHAR2(120) NOT NULL,TRIGGER_NAME VARCHAR2(200) NOT NULL,TRIGGER_GROUP VARCHAR2(200) NOT NULL, CRON_EXPRESSION VARCHAR2(120) NOT NULL, TIME_ZONE_ID VARCHAR2(80),CONSTRAINT CRON_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),CONSTRAINT CRON_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)  REFERENCES sys_qrtz_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP))
/*QUARTZ_27*/
CREATE TABLE sys_qrtz_simprop_triggers(SCHED_NAME VARCHAR2(120) NOT NULL,TRIGGER_NAME VARCHAR2(200) NOT NULL,TRIGGER_GROUP VARCHAR2(200) NOT NULL,STR_PROP_1 VARCHAR2(512) NULL,STR_PROP_2 VARCHAR2(512) NULL,STR_PROP_3 VARCHAR2(512) NULL,INT_PROP_1 NUMBER(10) NULL,INT_PROP_2 NUMBER(10) NULL,LONG_PROP_1 NUMBER(13) NULL,LONG_PROP_2 NUMBER(13) NULL,DEC_PROP_1 NUMERIC(13,4) NULL,DEC_PROP_2 NUMERIC(13,4) NULL,BOOL_PROP_1 VARCHAR2(1) NULL,BOOL_PROP_2 VARCHAR2(1) NULL,CONSTRAINT SIMPROP_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),CONSTRAINT SIMPROP_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) REFERENCES sys_qrtz_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP))
/*QUARTZ_28*/
CREATE TABLE sys_qrtz_blob_triggers(SCHED_NAME VARCHAR2(120) NOT NULL,TRIGGER_NAME VARCHAR2(200) NOT NULL,TRIGGER_GROUP VARCHAR2(200) NOT NULL,BLOB_DATA BLOB NULL,CONSTRAINT BLOB_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),CONSTRAINT BLOB_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)REFERENCES sys_qrtz_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP))
/*QUARTZ_29*/
CREATE TABLE sys_qrtz_calendars(SCHED_NAME VARCHAR2(120) NOT NULL,CALENDAR_NAME  VARCHAR2(200) NOT NULL,CALENDAR BLOB NOT NULL,CONSTRAINT CALENDARS_PK PRIMARY KEY (SCHED_NAME,CALENDAR_NAME))
/*QUARTZ_30*/
CREATE TABLE sys_qrtz_paused_trigger_grps(SCHED_NAME VARCHAR2(120) NOT NULL,TRIGGER_GROUP  VARCHAR2(200) NOT NULL,CONSTRAINT PAUSED_TRIG_GRPS_PK PRIMARY KEY (SCHED_NAME,TRIGGER_GROUP))
/*QUARTZ_31*/
CREATE TABLE sys_qrtz_fired_triggers(SCHED_NAME VARCHAR2(120) NOT NULL,ENTRY_ID VARCHAR2(95) NOT NULL,TRIGGER_NAME VARCHAR2(200) NOT NULL,TRIGGER_GROUP VARCHAR2(200) NOT NULL,INSTANCE_NAME VARCHAR2(200) NOT NULL,FIRED_TIME NUMBER(13) NOT NULL,SCHED_TIME NUMBER(13) NOT NULL,PRIORITY NUMBER(13) NOT NULL,STATE VARCHAR2(16) NOT NULL,JOB_NAME VARCHAR2(200) NULL,JOB_GROUP VARCHAR2(200) NULL,IS_NONCONCURRENT VARCHAR2(1) NULL,REQUESTS_RECOVERY VARCHAR2(1) NULL,CONSTRAINT FIRED_TRIGGER_PK PRIMARY KEY (SCHED_NAME,ENTRY_ID))
/*QUARTZ_32*/
CREATE TABLE sys_qrtz_scheduler_state  (SCHED_NAME VARCHAR2(120) NOT NULL,INSTANCE_NAME VARCHAR2(200) NOT NULL,LAST_CHECKIN_TIME NUMBER(13) NOT NULL,CHECKIN_INTERVAL NUMBER(13) NOT NULL,CONSTRAINT SCHEDULER_STATE_PK PRIMARY KEY (SCHED_NAME,INSTANCE_NAME))
/*QUARTZ_33*/
CREATE TABLE sys_qrtz_locks(SCHED_NAME VARCHAR2(120) NOT NULL,LOCK_NAME  VARCHAR2(40) NOT NULL, CONSTRAINT LOCKS_PK PRIMARY KEY (SCHED_NAME,LOCK_NAME))
/*QUARTZ_34*/
create index qz_j_req_recovery on sys_qrtz_job_details(SCHED_NAME,REQUESTS_RECOVERY)
/*QUARTZ_35*/
create index qz_j_grp on sys_qrtz_job_details(SCHED_NAME,JOB_GROUP)
/*QUARTZ_36*/
create index qz_t_j on sys_qrtz_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP)
/*QUARTZ_37*/
create index qz_t_jg on sys_qrtz_triggers(SCHED_NAME,JOB_GROUP)
/*QUARTZ_38*/
create index qz_t_c on sys_qrtz_triggers(SCHED_NAME,CALENDAR_NAME)
/*QUARTZ_39*/
create index qz_t_g on sys_qrtz_triggers(SCHED_NAME,TRIGGER_GROUP)
/*QUARTZ_40*/
create index qz_t_state on sys_qrtz_triggers(SCHED_NAME,TRIGGER_STATE)
/*QUARTZ_41*/
create index qz_t_n_state on sys_qrtz_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE)
/*QUARTZ_42*/
create index qz_t_n_g_state on sys_qrtz_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE)
/*QUARTZ_43*/
create index qz_t_next_fire_time on sys_qrtz_triggers(SCHED_NAME,NEXT_FIRE_TIME)
/*QUARTZ_44*/
create index qz_t_nft_st on sys_qrtz_triggers(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME)
/*QUARTZ_45*/
create index qz_t_nft_misfire on sys_qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME)
/*QUARTZ_46*/
create index qz_t_nft_st_misfire on sys_qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE)
/*QUARTZ_47*/
create index qz_t_nft_st_misfire_grp on sys_qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE)
/*QUARTZ_48*/
create index qz_ft_trig_inst_name on sys_qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME)
/*QUARTZ_49*/
create index qz_ft_inst_job_req_rcvry on sys_qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY)
/*QUARTZ_50*/
create index qz_ft_j_g on sys_qrtz_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP)
/*QUARTZ_51*/
create index qz_ft_jg on sys_qrtz_fired_triggers(SCHED_NAME,JOB_GROUP)
/*QUARTZ_52*/
create index qz_ft_t_g on sys_qrtz_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
/*QUARTZ_53*/
create index qz_ft_tg on sys_qrtz_fired_triggers(SCHED_NAME,TRIGGER_GROUP)