## Maven命令启动

* 项目根目录执行: `mvn clean install -Dmaven.test.skip=true`

* 在单个NB模块下执行 `mvn compile nutzboot:run` 运行或 `mvn package nutzboot:shade` 生成可执行jar包

* 在项目根目录执行 `mvn -Dnutzboot.dst=E:/dst clean package nutzboot:shade` 将所有可运行jar包生成到指定位置

* jar包使用命令启动 `java -jar wk-nb-service-sys-5.xxxx.jar` 若加上 `-Dnutz.profiles.active=prod `可指定使用application-prod.properties配置文件

* maven插件使用说明详见：[https://github.com/nutzam/nutzboot-maven-plugin](https://github.com/nutzam/nutzboot-maven-plugin)

## IDEA配置启动

* 项目根目录执行: `mvn clean install -Dmaven.test.skip=true`

* IDEA --> Run --> Edit Configurations

![run01](../images/03.png)

* 绿色 + 按钮，选择 Application

![run01](../images/04.png)


* 先选择模块 module，然后选择 Main class 入口类，-Dnutz.profiles.active=prod 运行参数可以让项目加载 application-prod.properties 配置文件

![run01](../images/05.png)

*   启动顺序是 sys --> cms[可选] --> wx[可选] --> task[可选] --> web-platform 或 web-vue --> web-api[可选]

## 模块说明

| 名称                                     | 介绍                                     |
| ---------------------------------------- | ---------------------------------------- |
|[wk-framework](wk-framework) |一些基类及公共方法的封装|
|[wk-model](wk-app/wk-model) |POJO类|
|[wk-common](wk-app/wk-common) |接口类|
|[wk-nb-service-sys](wk-app/wk-nb-service-sys) |系统管理模块,dubbo服务端,NB项目,权限体系|
|[wk-nb-service-cms](wk-app/wk-nb-service-cms) |CMS管理模块,dubbo服务端,NB项目,ig及wkcache演示|
|[wk-nb-service-wx](wk-app/wk-nb-service-wx) |微信管理模块,dubbo服务端,NB项目,微信及微信支付功能演示|
|[wk-nb-task](wk-app/wk-nb-task) |定时任务模块,dubbo服务端,NB项目,支持quartz集群|
|[wk-nb-web-api](wk-app/wk-nb-web-api) |API JWT Token示例,dubbo消费端,NB项目,Mvc|
|[wk-nb-web-platform](wk-app/wk-nb-web-platform) |WEB管理后台模块,dubbo消费端,NB项目,Mvc|
|[wk-nb-web-vue](wk-app/wk-nb-web-vue) |WEB管理后台Vue.js混合版(可选),dubbo消费端,NB项目,Mvc|

*   确保 MySql、Redis、Zookeeper 默认配置并已启动好[application.properties 可更改配置项]
*   MySql 创建名为 nutzwk_nb 的空数据库,在每个NB项目启动时会自动建表,同时初始化数据
*   项目根目录执行 `mvn clean install -Dmaven.test.skip=true`
*   在单个NB模块下执行 `mvn compile nutzboot:run` 运行或 `mvn package nutzboot:shade` 生成可执行jar包
*   在项目根目录执行 `mvn -Dnutzboot.dst=E:/dst clean package nutzboot:shade` 将所有可运行jar包生成到指定位置
*   启动顺序是 sys --> cms[可选] --> wx[可选] --> task[可选] --> web-platform 或 web-vue --> web-api[可选]
*   可选择使用运行参数 `-Dnutz.profiles.active=prod` 加载 application-prod.properties 配置文件
*   正常启动后访问 `http://127.0.0.1:8080/sysadmin` 用户名 superadmin 密码 1