/*
 * Copyright 2007-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.cache;

import net.ymate.platform.core.support.IInitializable;

/**
 * @author 刘镇 (suninformation@163.com) on 15/12/6 上午7:23
 * @version 1.0
 */
public interface ICacheEventListener extends IInitializable<ICaches> {

    void notifyElementRemoved(String cacheName, Object key);

    void notifyElementPut(String cacheName, Object key, Object value);

    void notifyElementUpdated(String cacheName, Object key, Object value);

    void notifyElementExpired(String cacheName, Object key);

    void notifyElementEvicted(String cacheName, Object key);

    void notifyRemoveAll(String cacheName);
}
