/*
 * Copyright 2007-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.configuration;

/**
 * @author 刘镇 (suninformation@163.com) on 2018/2/24 下午3:39
 * @version 1.0
 */
public abstract class AbstractConfigurable<T extends IConfiguration> implements IConfigurable {

    private T __config;

    @Override
    public T getConfig() {
        return __config;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void setConfig(IConfiguration config) {
        __config = (T) config;
    }
}
