/*
 * Copyright 2007-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.configuration;

/**
 * 配置能力接口, 实现此接口的具体类将具备赋予其配置对象的能力
 *
 * @author 刘镇 (suninformation@163.com) on 2011-8-27 上午12:21:26
 * @version 1.0
 */
public interface IConfigurable {

    /**
     * 获取配置对象类实例
     *
     * @return 继承IConfiguration接口的具体类
     */
    IConfiguration getConfig();

    /**
     * 设置配置对象类实例
     *
     * @param config 任何继承IConfiguration接口的具体类
     */
    void setConfig(IConfiguration config);

}