/*
 * Copyright 2007-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.core.module;

import net.ymate.platform.core.YMP;
import net.ymate.platform.core.support.IInitializable;

/**
 * 模块接口定义
 *
 * @author 刘镇 (suninformation@163.com) on 2012-11-24 下午6:13:22
 * @version 1.0
 */
public interface IModule extends IInitializable<YMP> {

    /**
     * @return 返回模块名称
     */
    String getName();

    /**
     * @return 返回模块是否已初始化
     */
    boolean isInited();

    /**
     * @return 返回所属YMP框架管理器实例
     */
    YMP getOwner();
}
