/*
 * Copyright 2007-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.serv;

import net.ymate.platform.core.util.RuntimeUtils;

import java.io.IOException;

/**
 * @param <T> 会话类型
 * @author 刘镇 (suninformation@163.com) on 15/11/15 下午6:01
 * @version 1.0
 */
public abstract class AbstractListener<T extends ISession> implements IListener<T> {

    @Override
    public void onClientReconnected(IClient client) throws IOException {
    }

    @Override
    public void onExceptionCaught(Throwable e, T session) throws IOException {
        if (e instanceof IOException) {
            throw (IOException) e;
        } else if (e instanceof RuntimeException) {
            throw (RuntimeException) e;
        }
        throw RuntimeUtils.wrapRuntimeThrow(e);
    }
}
