/*
 * Copyright 2007-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.serv.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;

/**
 * @author 刘镇 (suninformation@163.com) on 15/11/15 下午6:31
 * @version 1.0
 */
public interface INioEventProcessor<SESSION extends INioSession> extends Closeable {

    void registerEvent(SelectableChannel channel, int ops, SESSION session) throws IOException;

    void unregisterEvent(SESSION session);

    Selector selector();

    void start();
}
