/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.common;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCacheUtils {
    private static final Logger logger = LoggerFactory.getLogger(NettyCacheUtils.class);
    private static Map<String, Set<Channel>> channelIdCache = new HashMap<String, Set<Channel>>();
    public static Map<Channel, String> keyChannelCache = new HashMap<Channel, String>();
    public static Map<String, Set<String>> userKey = new HashMap<String, Set<String>>();

    public static void storeChannel(String key, Channel channel) {
        logger.debug("store channel with key:{}, channel id:{}", (Object)key, (Object)channel.id().asLongText());
        Set<Channel> set = channelIdCache.get(key);
        if (set == null) {
            set = new HashSet<Channel>();
            set.add(channel);
            channelIdCache.put(key, set);
        } else if (!set.contains(channel)) {
            set.add(channel);
        }
    }

    public static Set<Channel> getChannel(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            logger.debug("\u6ca1\u6709\u8ba2\u9605[{}]\u7684channel!", (Object)key);
        }
        return channelIdCache.get(key);
    }

    public static void removeChannel(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            logger.debug("\u6ca1\u6709\u8ba2\u9605[{}]\u7684channel!", (Object)key);
        }
        channelIdCache.remove(key);
    }

    public static Set<Channel> getAllChannels() {
        HashSet<Channel> channels = new HashSet<Channel>();
        channelIdCache.forEach((key, value) -> channels.addAll((Collection<Channel>)value));
        return channels;
    }
}

