/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.filter;

import com.aqmd.netty.annotation.HawkFilter;
import com.aqmd.netty.core.common.NettySpringContextUtils;
import com.aqmd.netty.entity.RequestPacket;
import com.aqmd.netty.entity.ResponsePacket;
import com.aqmd.netty.exception.NettyException;
import com.aqmd.netty.filter.FilterChain;
import com.aqmd.netty.filter.HFilter;
import com.aqmd.netty.shiro.filter.AbstractShiroFilter;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;

@HawkFilter(order=1)
public class DelegatingHawkFilterProxy
extends HFilter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ApplicationContext applicationContext;
    private String contextAttribute;
    private String targetBeanName;
    private Environment environment = new StandardEnvironment();
    private boolean targetFilterLifecycle = true;
    private final Object delegateMonitor = new Object();
    private volatile HFilter delegate;

    public DelegatingHawkFilterProxy() {
        this.init();
    }

    public void doFilter(RequestPacket request, ResponsePacket response, ChannelHandlerContext ctx, FilterChain chain) throws IOException, NettyException {
        this.doFilterInternal(request, response, ctx, chain);
    }

    public DelegatingHawkFilterProxy(HFilter delegate) {
        Assert.notNull((Object)delegate, (String)"delegate Filter object must not be null");
        this.delegate = delegate;
    }

    public DelegatingHawkFilterProxy(String targetBeanName) {
        this(targetBeanName, null);
    }

    public DelegatingHawkFilterProxy(String targetBeanName, ApplicationContext ac) {
        Assert.hasText((String)targetBeanName, (String)"target Filter bean name must not be null or empty");
        this.setTargetBeanName(targetBeanName);
        this.applicationContext = ac;
        if (ac != null) {
            this.setEnvironment(ac.getEnvironment());
        }
    }

    public void init() {
        this.initFilterBean();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Filter  configured successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFilterBean() throws NettyException {
        Object object = this.delegateMonitor;
        synchronized (object) {
            if (this.delegate == null) {
                ApplicationContext wac;
                if (this.targetBeanName == null) {
                    this.targetBeanName = "hawkShiroFilter";
                }
                if ((wac = this.findApplicationContext()) != null) {
                    this.delegate = this.initDelegate(wac);
                }
            }
        }
    }

    protected HFilter initDelegate(ApplicationContext wac) throws NettyException {
        HFilter delegate = (HFilter)wac.getBean(this.getTargetBeanName(), AbstractShiroFilter.class);
        if (this.isTargetFilterLifecycle()) {
            delegate.init();
        }
        return delegate;
    }

    protected ApplicationContext findApplicationContext() {
        if (this.applicationContext != null) {
            ConfigurableApplicationContext cac;
            if (this.applicationContext instanceof ConfigurableApplicationContext && !(cac = (ConfigurableApplicationContext)this.applicationContext).isActive()) {
                cac.refresh();
            }
            return this.applicationContext;
        }
        return NettySpringContextUtils.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(RequestPacket request, ResponsePacket response, ChannelHandlerContext ctx, FilterChain chain) throws NettyException, IOException {
        HFilter delegateToUse = this.delegate;
        if (delegateToUse == null) {
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    ApplicationContext wac = this.findApplicationContext();
                    if (wac == null) {
                        throw new IllegalStateException("No applicationContext found: no ContextLoaderListener or DispatcherServlet registered?");
                    }
                    this.delegate = this.initDelegate(wac);
                }
                delegateToUse = this.delegate;
            }
        }
        this.invokeDelegate(delegateToUse, request, response, ctx, chain);
    }

    protected void invokeDelegate(HFilter delegate, RequestPacket request, ResponsePacket response, ChannelHandlerContext ctx, FilterChain chain) throws NettyException, IOException {
        delegate.doFilter(request, response, ctx, chain);
    }

    public void destroy() {
        HFilter delegateToUse = this.delegate;
        if (delegateToUse != null) {
            this.destroyDelegate(delegateToUse);
        }
    }

    protected void destroyDelegate(HFilter delegate) {
        if (this.isTargetFilterLifecycle()) {
            delegate.destroy();
        }
    }

    public String getContextAttribute() {
        return this.contextAttribute;
    }

    public void setContextAttribute(String contextAttribute) {
        this.contextAttribute = contextAttribute;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean isTargetFilterLifecycle() {
        return this.targetFilterLifecycle;
    }

    public void setTargetFilterLifecycle(boolean targetFilterLifecycle) {
        this.targetFilterLifecycle = targetFilterLifecycle;
    }

    public HFilter getDelegate() {
        return this.delegate;
    }

    public void setDelegate(HFilter delegate) {
        this.delegate = delegate;
    }

    public Object getDelegateMonitor() {
        return this.delegateMonitor;
    }
}

