/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.handler;

import com.aqmd.netty.annotation.HawkBean;
import com.aqmd.netty.annotation.HawkMethod;
import com.aqmd.netty.common.constant.NettyResponseCode;
import com.aqmd.netty.entity.HawkResponseMessage;
import com.aqmd.netty.entity.LoginMessage;
import com.aqmd.netty.exception.NettyException;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HawkBean
public class LoginHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @HawkMethod(cmd=11002, version=1)
    public HawkResponseMessage.CommonResult login(long seqId, byte[] body, ChannelHandlerContext ctx) {
        Subject subject = SecurityUtils.getSubject();
        String loginIp = "";
        try {
            LoginMessage.LoginUser user = ((LoginMessage.LoginUser.Builder)LoginMessage.LoginUser.newBuilder().mergeFrom(body)).build();
            UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getPasswd());
            subject.login((AuthenticationToken)token);
            loginIp = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.error(NettyResponseCode.BODY_FORMAT_ERROR.getResponseString());
            throw new NettyException((Throwable)e, NettyResponseCode.BODY_FORMAT_ERROR.getResponseString());
        }
        catch (IncorrectCredentialsException | UnknownAccountException e) {
            throw new NettyException(e, NettyResponseCode.LOGIN_AUTH_ERROR.getResponseCode() + "~" + NettyResponseCode.LOGIN_AUTH_ERROR.getResponseMessage());
        }
        Session session = subject.getSession();
        session.setAttribute((Object)"loginUser", subject.getPrincipal());
        String userName = Objects.toString(subject.getPrincipal());
        String channelId = ctx.channel().id().asLongText();
        this.logger.info("[{}]\u7528\u6237\u767b\u5f55\u6210\u529f,\u767b\u9646ip\u4e3a[{}]\uff0c\u7f13\u5b58Channel\u53caSession\u4fe1\u606f\uff0cid\u5206\u522b\u4e3a\uff1a[{}]\uff0c[{}]", new Object[]{userName, loginIp, channelId, session.getId()});
        return HawkResponseMessage.CommonResult.newBuilder().setResultCode(NettyResponseCode.SUCCESS.getResponseCode()).setResultMsg(NettyResponseCode.SUCCESS.getResponseMessage()).build();
    }
}

