/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.push.impl;

import com.aqmd.netty.common.constant.NettyResponseCode;
import com.aqmd.netty.entity.ResponsePacket;
import com.aqmd.netty.push.HawkPushServiceApi;
import com.google.protobuf.MessageLite;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawkPushServiceImpl
implements HawkPushServiceApi {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int MIN_SEQ_ID = 0x1FFFFFFF;
    private static AtomicInteger idWoker = new AtomicInteger(0x1FFFFFFF);

    @Override
    public void pushMsg(Set<Channel> channels, short cmd, String msg) {
        if (CollectionUtils.isEmpty(channels)) {
            return;
        }
        Iterator<Channel> iterable = channels.iterator();
        while (iterable.hasNext()) {
            Channel channel = iterable.next();
            try {
                if (channel != null && channel.isActive()) {
                    channel.writeAndFlush((Object)this.buildResponsePacket(cmd, msg.getBytes()));
                    continue;
                }
                this.logger.debug("\u63a8\u9001\u901a\u9053\u88ab\u5173\u95ed\uff0c\u79fb\u9664\u8be5\u63a8\u9001\u901a\u9053");
                iterable.remove();
                this.logger.debug("\u901a\u9053\u79fb\u9664\u7ed3\u679c:true");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void pushMsg(Set<Channel> channels, short cmd, byte[] msg) {
        if (channels == null || CollectionUtils.isEmpty(channels)) {
            return;
        }
        try {
            Iterator<Channel> iterable = channels.iterator();
            while (iterable.hasNext()) {
                Channel channel = iterable.next();
                if (channel != null && channel.isActive()) {
                    channel.writeAndFlush((Object)this.buildResponsePacket(cmd, msg));
                    continue;
                }
                this.logger.debug("\u63a8\u9001\u901a\u9053\u88ab\u5173\u95ed\uff0c\u79fb\u9664\u8be5\u63a8\u9001\u901a\u9053");
                iterable.remove();
                this.logger.debug("\u901a\u9053\u79fb\u9664\u7ed3\u679c:true");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void pushMsg(Set<Channel> channels, short cmd, MessageLite msg) {
        if (channels == null || CollectionUtils.isEmpty(channels)) {
            return;
        }
        try {
            Iterator<Channel> iterable = channels.iterator();
            while (iterable.hasNext()) {
                Channel channel = iterable.next();
                if (channel != null && channel.isActive()) {
                    channel.writeAndFlush((Object)this.buildResponsePacket(cmd, msg.toByteArray()));
                    continue;
                }
                this.logger.debug("\u63a8\u9001\u901a\u9053\u88ab\u5173\u95ed\uff0c\u79fb\u9664\u8be5\u63a8\u9001\u901a\u9053");
                iterable.remove();
                this.logger.debug("\u901a\u9053\u79fb\u9664\u7ed3\u679c:true");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, ChannelPromise> syncPushMsg(Set<Channel> channels, short cmd, String msg) {
        if (CollectionUtils.isEmpty(channels)) {
            return null;
        }
        HashMap<String, ChannelPromise> channelPromiseMap = new HashMap<String, ChannelPromise>();
        Iterator<Channel> iterable = channels.iterator();
        while (iterable.hasNext()) {
            Channel channel = iterable.next();
            try {
                if (channel != null && channel.isActive()) {
                    channelPromiseMap.put(channel.id().asLongText(), channel.writeAndFlush((Object)this.buildResponsePacket(cmd, msg.getBytes())).channel().newPromise());
                    continue;
                }
                this.logger.debug("\u63a8\u9001\u901a\u9053\u88ab\u5173\u95ed\uff0c\u79fb\u9664\u8be5\u63a8\u9001\u901a\u9053");
                iterable.remove();
                this.logger.debug("\u901a\u9053\u79fb\u9664\u7ed3\u679c:true");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return channelPromiseMap;
    }

    @Override
    public Map<String, ChannelPromise> syncPushMsg(Set<Channel> channels, short cmd, byte[] msg) {
        if (CollectionUtils.isEmpty(channels)) {
            return null;
        }
        HashMap<String, ChannelPromise> channelPromiseMap = new HashMap<String, ChannelPromise>();
        Iterator<Channel> iterable = channels.iterator();
        while (iterable.hasNext()) {
            Channel channel = iterable.next();
            try {
                if (channel != null && channel.isActive()) {
                    channelPromiseMap.put(channel.id().asLongText(), channel.writeAndFlush((Object)this.buildResponsePacket(cmd, msg)).channel().newPromise());
                    continue;
                }
                this.logger.debug("\u63a8\u9001\u901a\u9053\u88ab\u5173\u95ed\uff0c\u79fb\u9664\u8be5\u63a8\u9001\u901a\u9053");
                iterable.remove();
                this.logger.debug("\u901a\u9053\u79fb\u9664\u7ed3\u679c:true");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return channelPromiseMap;
    }

    @Override
    public Map<String, ChannelPromise> syncPushMsg(Set<Channel> channels, short cmd, MessageLite msg) {
        if (CollectionUtils.isEmpty(channels)) {
            return null;
        }
        HashMap<String, ChannelPromise> channelPromiseMap = new HashMap<String, ChannelPromise>();
        Iterator<Channel> iterable = channels.iterator();
        while (iterable.hasNext()) {
            Channel channel = iterable.next();
            try {
                if (channel != null && channel.isActive()) {
                    channelPromiseMap.put(channel.id().asLongText(), channel.writeAndFlush((Object)this.buildResponsePacket(cmd, msg.toByteArray())).channel().newPromise());
                    continue;
                }
                this.logger.debug("\u63a8\u9001\u901a\u9053\u88ab\u5173\u95ed\uff0c\u79fb\u9664\u8be5\u63a8\u9001\u901a\u9053");
                iterable.remove();
                this.logger.debug("\u901a\u9053\u79fb\u9664\u7ed3\u679c:true");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return channelPromiseMap;
    }

    private ResponsePacket buildResponsePacket(short cmd, byte[] body) {
        ResponsePacket packet = new ResponsePacket();
        packet.setCmd(cmd);
        packet.setSequenceId((long)HawkPushServiceImpl.nextSeqId());
        packet.setCode(NettyResponseCode.SUCCESS.getResponseCode());
        packet.setBody(body);
        return packet;
    }

    private static int nextSeqId() {
        int seqId = idWoker.getAndIncrement();
        while (seqId < 0x1FFFFFFF) {
            seqId = idWoker.addAndGet(0x1FFFFFFF);
        }
        return seqId;
    }
}

