/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.server;

import com.aqmd.netty.common.NettyCacheUtils;
import com.aqmd.netty.server.HawkServerHandler;
import com.aqmd.netty.service.ChannelEventDealService;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ChannelHandler.Sharable
public class HawkServerRealHandler
extends HawkServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(HawkServerRealHandler.class);
    @Autowired
    private ChannelEventDealService channelEventDealService;

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (IdleState.READER_IDLE == event.state()) {
                logger.info("id:0x{}\uff0c\u8bfb\u7a7a\u95f2", (Object)ctx.channel().id().asLongText());
            } else if (IdleState.WRITER_IDLE == event.state()) {
                logger.info("id:0x{}\uff0c\u5199\u7a7a\u95f2", (Object)ctx.channel().id().asLongText());
            } else if (IdleState.ALL_IDLE == event.state()) {
                logger.info("id:0x{}\uff0c\u8bfb\u5199\u7a7a\u95f2", (Object)ctx.channel().id().asLongText());
                ctx.close(new DefaultChannelPromise(ctx.channel()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                    logger.error("timeoutClose");
                    logger.info("channel[0x{}] timeout closed", (Object)ctx.channel().id().asLongText());
                })));
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        try {
            InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
            logger.info("channel[{}] from {}:{} actived.", new Object[]{ctx.channel().id().asLongText(), remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort()});
            this.channelEventDealService.dealChannelActive(localAddress.getAddress().getHostAddress(), remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        try {
            InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
            Channel channel = ctx.channel();
            logger.info("channel[{}] from {}:{} disconnected.", new Object[]{ctx.channel().id().asLongText(), remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort()});
            String user = NettyCacheUtils.keyChannelCache.get(channel);
            if (user != null) {
                Set<String> keys;
                logger.info("remove the push request from memeory");
                Set<Channel> channels = NettyCacheUtils.getChannel(user);
                if (!CollectionUtils.isEmpty(channels)) {
                    boolean flag = channels.remove(channel);
                    logger.info("user[{}] channel remove :" + flag, (Object)user);
                }
                if (!CollectionUtils.isEmpty(keys = NettyCacheUtils.userKey.get(user))) {
                    logger.info("need remove keys,total[{}]", (Object)keys.size());
                    keys.forEach(key -> {
                        Set<Channel> keyChannels = NettyCacheUtils.getChannel(key);
                        if (!CollectionUtils.isEmpty(keyChannels)) {
                            boolean flag = keyChannels.remove(channel);
                            logger.debug("key[{}] channel remove :" + flag, key);
                        }
                    });
                }
            }
            this.channelEventDealService.dealChannelDestory(localAddress.getAddress().getHostAddress(), remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int writeAndFlush(String username, short cmd, byte[] body) {
        return 1;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close(new DefaultChannelPromise(ctx.channel()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> logger.error("exception-" + cause.getMessage() + "\u5bfc\u81f4\u7684channel\u5173\u95ed"))));
    }
}

