/*
 * Decompiled with CFR 0.152.
 */
package com.cdeer.apns.http2.core.netty;

import com.cdeer.apns.http2.core.model.PushNotification;
import com.cdeer.apns.http2.core.netty.NettyApnsConnectionPool;
import com.cdeer.apns.http2.core.netty.http2.Http2ClientInitializer;
import com.cdeer.apns.http2.core.netty.http2.Http2SettingsHandler;
import com.cdeer.apns.http2.core.netty.http2.HttpResponseHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyApnsConnection {
    private static final Logger log = LoggerFactory.getLogger(NettyApnsConnection.class);
    private static final int INITIAL_STREAM_ID = 3;
    private int retryTimes;
    private KeyManagerFactory keyManagerFactory;
    private Channel channel;
    private AtomicInteger streamId = new AtomicInteger(3);
    private Http2ClientInitializer http2ClientInitializer;
    public NettyApnsConnectionPool connectionPool;
    private String host;
    private String name;
    private int port;
    private int timeout;
    private String topic;

    public NettyApnsConnection(String name, String host, int port, int retryTimes, int timeout, String topic, KeyManagerFactory keyManagerFactory) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.retryTimes = retryTimes;
        this.timeout = timeout;
        this.topic = topic;
        this.keyManagerFactory = keyManagerFactory;
    }

    public void setConnectionPool(NettyApnsConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public boolean sendNotification(PushNotification notification) {
        if (this.connectionPool.isShutdown()) {
            log.error("\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u6b7b\u6389");
            return false;
        }
        if (this.channel == null || !this.channel.isActive()) {
            try {
                this.initializeNettyClient();
            }
            catch (Exception e) {
                log.error("initializeNettyClient", (Throwable)e);
                this.http2ClientInitializer = null;
                return false;
            }
        }
        DefaultFullHttpRequest request = null;
        HttpResponseHandler responseHandler = this.http2ClientInitializer.responseHandler();
        if (request == null) {
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "https://" + this.host + "/3/device/" + notification.getToken(), Unpooled.copiedBuffer((byte[])notification.getPayload().toString().getBytes()));
            request.headers().add("apns-topic", (Object)this.topic);
            if (this.streamId.get() > 200000000) {
                this.streamId.set(3);
            }
            int streamId = this.streamId.getAndAdd(2);
            ChannelFuture channelFuture = this.channel.writeAndFlush((Object)request);
            responseHandler.put(streamId, notification, channelFuture, this.channel.newPromise());
            channelFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                }
            });
            channelFuture.awaitUninterruptibly();
            boolean success = channelFuture.isSuccess();
            return success;
        }
        return false;
    }

    private void initializeNettyClient() throws Exception {
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        Http2ClientInitializer http2ClientInitializer = new Http2ClientInitializer(this.name, this.createSslContext(), Integer.MAX_VALUE);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress(this.host, this.port).handler((ChannelHandler)http2ClientInitializer);
        log.info("connecting to " + this.host);
        this.channel = bootstrap.connect().syncUninterruptibly().channel();
        log.info("connected");
        Http2SettingsHandler http2SettingsHandler = http2ClientInitializer.settingsHandler();
        log.info("await setting");
        http2SettingsHandler.awaitSettings(30L, TimeUnit.SECONDS);
        log.info("setting success");
        this.streamId.set(3);
        this.http2ClientInitializer = http2ClientInitializer;
    }

    private SslContext createSslContext() throws SSLException {
        SslProvider provider = SslProvider.JDK;
        return SslContextBuilder.forClient().sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(this.keyManagerFactory).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).build();
    }
}

