/*
 * Decompiled with CFR 0.152.
 */
package com.cdeer.apns.http2.core.service;

import com.cdeer.apns.http2.core.model.ApnsConfig;
import com.cdeer.apns.http2.core.model.PushNotification;
import com.cdeer.apns.http2.core.netty.NettyApnsConnection;
import com.cdeer.apns.http2.core.netty.NettyApnsConnectionPool;
import com.cdeer.apns.http2.core.service.AbstractApnsService;

public class NettyApnsService
extends AbstractApnsService {
    private NettyApnsConnectionPool connectionPool;

    private NettyApnsService(ApnsConfig config) {
        super(config);
        this.connectionPool = new NettyApnsConnectionPool(config);
    }

    public static NettyApnsService create(ApnsConfig apnsConfig) {
        return new NettyApnsService(apnsConfig);
    }

    @Override
    public void sendNotification(PushNotification notification) {
        this.executorService.execute(() -> {
            NettyApnsConnection connection = null;
            try {
                boolean result;
                connection = this.connectionPool.acquire();
                if (connection != null && !(result = connection.sendNotification(notification))) {
                    log.debug("\u53d1\u9001\u901a\u77e5\u5931\u8d25");
                }
            }
            catch (Exception e) {
                log.error("sendNotification", (Throwable)e);
            }
            finally {
                this.connectionPool.release(connection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendNotificationSynch(PushNotification notification) {
        NettyApnsConnection connection = null;
        try {
            connection = this.connectionPool.acquire();
            if (connection != null) {
                boolean result;
                boolean bl = result = connection.sendNotification(notification);
                return bl;
            }
        }
        catch (Exception e) {
            log.error("sendNotification", (Throwable)e);
        }
        finally {
            this.connectionPool.release(connection);
        }
        return false;
    }

    @Override
    public void shutdown() {
        this.connectionPool.shutdown();
        super.shutdown();
    }
}

