/*
 * Decompiled with CFR 0.152.
 */
package com.aqmd.netty.context;

import com.aqmd.netty.annotation.HawkBean;
import com.aqmd.netty.annotation.HawkFilter;
import com.aqmd.netty.annotation.HawkFilterValue;
import com.aqmd.netty.annotation.HawkMethod;
import com.aqmd.netty.annotation.HawkMethodHandler;
import com.aqmd.netty.annotation.HawkMethodValue;
import com.aqmd.netty.annotation.ObsoletedType;
import com.aqmd.netty.exception.NettyException;
import com.aqmd.netty.filter.HFilter;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class HawkContext
implements BeanPostProcessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, HawkMethodHandler> hawkMethodHandlerMap = new HashMap<String, HawkMethodHandler>();
    private TreeSet<HawkFilterValue> filters = new TreeSet();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        HawkFilter HawkFilter2;
        if (AnnotationUtils.findAnnotation(bean.getClass(), HawkBean.class) != null) {
            ReflectionUtils.doWithMethods(bean.getClass(), method -> {
                HawkMethod hawkMethod = (HawkMethod)AnnotationUtils.findAnnotation((Method)method, HawkMethod.class);
                HawkMethodValue HawkMethodValue2 = new HawkMethodValue(hawkMethod.cmd(), hawkMethod.version(), ObsoletedType.isObsoleted(hawkMethod.obsoleted()));
                HawkMethodHandler HawkMethodHandler2 = new HawkMethodHandler();
                HawkMethodHandler2.setHawkMethodValue(HawkMethodValue2);
                HawkMethodHandler2.setHandler(bean);
                HawkMethodHandler2.setHandlerMethod(method);
                String handlerKey = this.buildeHandlerKey(HawkMethodValue2.getCmd(), HawkMethodValue2.getVersion());
                if (this.hawkMethodHandlerMap.get(handlerKey) != null) {
                    throw new NettyException("\u91cd\u590d\u7684\u6307\u4ee4\uff0c " + handlerKey);
                }
                if (method.getParameterTypes().length > 3) {
                    throw new NettyException(String.format("%s#%s\u6700\u591a\u5305\u542b\u4e09\u4e2a\u4e2a\u53c2\u6570", method.getDeclaringClass().getCanonicalName(), method.getName()));
                }
                if (method.getParameterTypes().length == 1) {
                    if (!(ClassUtils.isAssignable(Long.TYPE, method.getParameterTypes()[0]) || ClassUtils.isAssignable(byte[].class, method.getParameterTypes()[0]) || ClassUtils.isAssignable(ChannelHandlerContext.class, method.getParameterTypes()[0]))) {
                        throw new NettyException(String.format("\u5141\u8bb8%s#%s(long)\u3001(byte[])\u6216(ChannelHandlerContext\uff09", method.getDeclaringClass().getCanonicalName(), method.getName()));
                    }
                } else if (method.getParameterTypes().length == 2) {
                    boolean fail = true;
                    if (ClassUtils.isAssignable(Long.TYPE, method.getParameterTypes()[0]) && (ClassUtils.isAssignable(byte[].class, method.getParameterTypes()[1]) || ClassUtils.isAssignable(ChannelHandlerContext.class, method.getParameterTypes()[1]))) {
                        fail = false;
                    }
                    if (ClassUtils.isAssignable(byte[].class, method.getParameterTypes()[0]) && (ClassUtils.isAssignable(Long.TYPE, method.getParameterTypes()[1]) || ClassUtils.isAssignable(ChannelHandlerContext.class, method.getParameterTypes()[1]))) {
                        fail = false;
                    }
                    if (ClassUtils.isAssignable(ChannelHandlerContext.class, method.getParameterTypes()[0]) && (ClassUtils.isAssignable(Long.TYPE, method.getParameterTypes()[1]) || ClassUtils.isAssignable(byte[].class, method.getParameterTypes()[1]))) {
                        fail = false;
                    }
                    if (fail) {
                        throw new NettyException(String.format("\u5141\u8bb8%s#%s(long, byte[])\u6216(long, ChannelHandlerContext)\u3001(byte[], long)\u6216(byte[], ChannelHandlerContext)\u3001(ChannelHandlerContext, long)\u6216(ChannelHandlerContext, byte[])", method.getDeclaringClass().getCanonicalName(), method.getName()));
                    }
                } else if (!(method.getParameterTypes().length != 3 || ClassUtils.isAssignable(Long.TYPE, method.getParameterTypes()[0]) && ClassUtils.isAssignable(byte[].class, method.getParameterTypes()[1]) && ClassUtils.isAssignable(ChannelHandlerContext.class, method.getParameterTypes()[2]))) {
                    throw new NettyException(String.format("\u5141\u8bb8%s#%s(long, byte[], ChannelHandlerContext)", method.getDeclaringClass().getCanonicalName(), method.getName()));
                }
                this.hawkMethodHandlerMap.put(handlerKey, HawkMethodHandler2);
                this.logger.info(String.format("\u6ce8\u518c\u6307\u4ee4%s", handlerKey));
            }, method -> !method.isSynthetic() && AnnotationUtils.findAnnotation((Method)method, HawkMethod.class) != null);
        }
        if ((HawkFilter2 = (HawkFilter)AnnotationUtils.findAnnotation(bean.getClass(), HawkFilter.class)) != null) {
            this.logger.info(String.format("\u589e\u52a0\u8fc7\u6ee4\u5668%s", bean.getClass()));
            this.filters.add(new HawkFilterValue(HawkFilter2.order(), HawkFilter2.cmds(), HawkFilter2.ignoreCmds(), (HFilter)bean));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public HawkMethodHandler getHawkMethodHandler(int cmd, int version) {
        String handlerKey = this.buildeHandlerKey(cmd, version);
        HawkMethodHandler handler = this.hawkMethodHandlerMap.get(handlerKey);
        return handler;
    }

    public TreeSet<HawkFilterValue> getFilters() {
        return this.filters;
    }

    private String buildeHandlerKey(int cmd, int version) {
        return cmd + "#" + version;
    }
}

