/*
 * Decompiled with CFR 0.152.
 */
package com.sparkframework.security;

public class Base64 {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    static {
        int i = 0;
        while (i < 256) {
            Base64.codes[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            Base64.codes[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            Base64.codes[i] = (byte)(26 + i - 97);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            Base64.codes[i] = (byte)(52 + i - 48);
            ++i;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }

    public static String encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static String encode(String input) {
        return Base64.encode(input.getBytes());
    }

    public static byte[] decode(char[] data) throws Exception {
        int len = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == '=') {
            --len;
        }
        if (data.length > 1 && data[data.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix = 0;
        while (ix < data.length) {
            byte value = codes[data[ix] & 0xFF];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix;
        }
        if (index != out.length) {
            throw new Exception("miscalculated data length!");
        }
        return out;
    }

    public static String decode(String input) throws Exception {
        char[] chars = input.toCharArray();
        byte[] buff = Base64.decode(chars);
        return new String(buff);
    }
}

