/*
 * Decompiled with CFR 0.152.
 */
package com.sparkframework.sql;

import com.sparkframework.sql.DataException;
import com.sparkframework.sql.Parameter;
import com.sparkframework.sql.ParameterDirection;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB {
    private static Log log = LogFactory.getLog(DB.class);
    public boolean debugMode = true;
    public boolean safeMode = false;
    private DataSource dataSource;
    private DataSource forWriteDataSource;
    private static DB instance;

    static {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.initSynchronization();
        }
    }

    public DB() {
    }

    public DB(DataSource ds, boolean debugMode) {
        this.dataSource = ds;
        this.debugMode = debugMode;
        instance = this;
    }

    public static DB getInstance() {
        if (instance == null) {
            instance = new DB();
        }
        return instance;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void setDebugMode(boolean mode) {
        this.debugMode = mode;
    }

    public void setSafeMode(boolean mode) {
        this.safeMode = mode;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getForWriteDataSource() {
        return this.forWriteDataSource;
    }

    public void setForWriteDataSource(DataSource forWriteDataSource) {
        this.forWriteDataSource = forWriteDataSource;
    }

    public static void rollback() throws SQLException {
        DB.getConnection().rollback();
    }

    public static void commit() throws SQLException {
        DB.getConnection().commit();
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            DataSource ds = DB.getInstance().getDataSource();
            if (ds == null) {
                throw new RuntimeException("no datasource specified");
            }
            conn = DataSourceUtils.getConnection((DataSource)ds);
        }
        catch (Exception e) {
            log.error((Object)("get connection failure!" + e.getMessage()));
            e.printStackTrace();
        }
        return conn;
    }

    public static void closeConnection(Connection conn) {
        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)DB.getInstance().getDataSource());
    }

    private static void prepare(PreparedStatement statement, Object ... parameters) throws SQLException {
        if (parameters.length == 0) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            statement.setObject(i + 1, parameters[i]);
            ++i;
        }
    }

    protected static void prepare(CallableStatement paramCallableStatement, Parameter[] parameters) throws SQLException {
        if (parameters.length == 0) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].direction == ParameterDirection.OUT || parameters[i].direction == ParameterDirection.INOUT) {
                paramCallableStatement.registerOutParameter(i + 1, parameters[i].type);
            }
            if (parameters[i].direction == ParameterDirection.IN || parameters[i].direction == ParameterDirection.INOUT) {
                paramCallableStatement.setObject(i + 1, parameters[i].value);
            }
            ++i;
        }
    }

    public static long exec(String command, Object ... params) throws SQLException {
        Connection conn = DB.getConnection();
        DB.log(command, params);
        Statement preparedStatement = null;
        long ret = -1L;
        try {
            try {
                try {
                    preparedStatement = conn.prepareStatement(command, 1);
                }
                catch (SQLException e) {
                    preparedStatement = conn.prepareStatement(command);
                }
                DB.prepare((PreparedStatement)preparedStatement, params);
                ret = preparedStatement.executeUpdate();
                ResultSet rs = preparedStatement.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    ret = rs.getLong(1);
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                preparedStatement.close();
                DB.closeConnection(conn);
            }
        }
        finally {
            preparedStatement.close();
            DB.closeConnection(conn);
        }
        return ret;
    }

    public static long exec(String command) throws SQLException {
        Connection conn = DB.getConnection();
        DB.log(command);
        Statement preparedStatement = null;
        long ret = -1L;
        try {
            try {
                try {
                    preparedStatement = conn.prepareStatement(command, 1);
                }
                catch (SQLException e) {
                    preparedStatement = conn.prepareStatement(command);
                }
                ret = preparedStatement.executeUpdate();
                ResultSet rs = preparedStatement.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    ret = rs.getLong(1);
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                DB.closeConnection(conn);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            DB.closeConnection(conn);
        }
        return ret;
    }

    public static List<Map<String, String>> query(String command, Object ... params) throws SQLException, DataException {
        Connection conn = DB.getConnection();
        List<Map<String, String>> list = null;
        try {
            try {
                PreparedStatement ps = conn.prepareStatement(command);
                DB.log(command, params);
                if (params != null && params.length > 0) {
                    DB.prepare(ps, params);
                }
                ResultSet rs = ps.executeQuery();
                list = DB.parseResult(rs);
                ps.close();
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DB.closeConnection(conn);
            }
        }
        finally {
            DB.closeConnection(conn);
        }
        return list;
    }

    public static List<Map<String, String>> query(String command) throws SQLException, DataException {
        Connection conn = DB.getConnection();
        List<Map<String, String>> list = null;
        try {
            try {
                PreparedStatement ps = conn.prepareStatement(command);
                DB.log(command);
                ResultSet rs = ps.executeQuery();
                list = DB.parseResult(rs);
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DB.closeConnection(conn);
            }
        }
        finally {
            DB.closeConnection(conn);
        }
        return list;
    }

    public static List<Map<String, String>> executeProcedure(String ProcedureName, List<Object> outParameterValues, Parameter ... params) throws SQLException, DataException {
        Connection conn = DB.getConnection();
        List<Map<String, String>> list = null;
        try {
            try {
                String sql = "{ call " + ProcedureName + "(";
                int i = 0;
                while (i < params.length) {
                    sql = String.valueOf(sql) + (i > 0 ? ", ?" : "?");
                    ++i;
                }
                sql = String.valueOf(sql) + ") }";
                DB.log(sql, params);
                CallableStatement statement = conn.prepareCall(sql);
                DB.prepare(statement, params);
                statement.execute();
                ResultSet rs = statement.getResultSet();
                if (rs != null) {
                    list = DB.parseResult(rs);
                    rs.close();
                }
                int i2 = 0;
                while (i2 < params.length) {
                    if (params[i2].direction == ParameterDirection.OUT || params[i2].direction == ParameterDirection.INOUT) {
                        outParameterValues.add(statement.getObject(i2 + 1));
                    }
                    ++i2;
                }
                statement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DB.closeConnection(conn);
            }
        }
        finally {
            DB.closeConnection(conn);
        }
        return list;
    }

    public static List<Object> executeProcedure(String ProcedureName, Parameter ... params) throws SQLException, DataException {
        Connection conn = DB.getConnection();
        ArrayList<Object> outParams = new ArrayList<Object>();
        try {
            try {
                String sql = "{ call " + ProcedureName + "(";
                int i = 0;
                while (i < params.length) {
                    sql = String.valueOf(sql) + (i > 0 ? ", ?" : "?");
                    ++i;
                }
                sql = String.valueOf(sql) + ") }";
                DB.log(sql, params);
                CallableStatement statement = conn.prepareCall(sql);
                DB.prepare(statement, params);
                statement.execute();
                int i2 = 0;
                while (i2 < params.length) {
                    if (params[i2].direction == ParameterDirection.OUT || params[i2].direction == ParameterDirection.INOUT) {
                        outParams.add(statement.getObject(i2 + 1));
                    }
                    ++i2;
                }
                statement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DB.closeConnection(conn);
            }
        }
        finally {
            DB.closeConnection(conn);
        }
        return outParams;
    }

    public static List<Map<String, String>> executeProcedure(String ProcedureName, Object ... params) throws SQLException, DataException {
        Connection conn = DB.getConnection();
        List<Map<String, String>> list = null;
        try {
            try {
                String sql = "{ call " + ProcedureName + "(";
                int i = 0;
                while (i < params.length) {
                    sql = String.valueOf(sql) + (i > 0 ? ", ?" : "?");
                    ++i;
                }
                sql = String.valueOf(sql) + ") }";
                DB.log(sql, params);
                CallableStatement statement = conn.prepareCall(sql);
                DB.prepare((PreparedStatement)statement, params);
                statement.execute();
                ResultSet rs = statement.getResultSet();
                if (rs != null) {
                    list = DB.parseResult(rs);
                    rs.close();
                }
                statement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DB.closeConnection(conn);
            }
        }
        finally {
            DB.closeConnection(conn);
        }
        return list;
    }

    private static List<Map<String, String>> parseResult(ResultSet rs) throws SQLException, DataException {
        ResultSetMetaData metaData = rs.getMetaData();
        int j = metaData.getColumnCount();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            int i = 0;
            while (i < j) {
                String columnName = metaData.getColumnLabel(i + 1);
                String typeName = metaData.getColumnTypeName(i + 1);
                if (rs.getObject(i + 1) == null) {
                    map.put(columnName, null);
                } else if (typeName.equalsIgnoreCase("CLOB")) {
                    Clob clob = rs.getClob(i + 1);
                    BufferedReader br = new BufferedReader(clob.getCharacterStream());
                    String content = "";
                    try {
                        String strTmp = br.readLine();
                        while (strTmp != null) {
                            content = String.valueOf(strTmp) + content;
                            strTmp = br.readLine();
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    map.put(columnName, content);
                } else if (typeName.equalsIgnoreCase("DATETIME")) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    map.put(columnName, df.format(rs.getTimestamp(i + 1)));
                } else {
                    map.put(columnName, rs.getObject(i + 1).toString());
                }
                ++i;
            }
            list.add(map);
        }
        return list;
    }

    private static void log(String command, Object ... params) {
        if (params == null) {
            DB.log(command);
            return;
        }
        if (DB.getInstance().debugMode) {
            StringBuffer sb = new StringBuffer("[SQL]\uff1a " + command);
            sb.append("; params [");
            int i = 0;
            while (i < params.length) {
                sb.append(params[i]);
                if (i != params.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("]");
            log.info((Object)sb.toString());
        }
    }

    private static void log(String commond, Parameter[] params) {
        if (DB.getInstance().debugMode) {
            StringBuffer sb = new StringBuffer("[SQL]:" + commond);
            sb.append("; params [");
            int i = 0;
            while (i < params.length) {
                sb.append(params[i].value);
                if (i != params.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("]");
            log.info((Object)sb.toString());
        }
    }

    private static void log(String commond) {
        if (DB.getInstance().debugMode) {
            log.info((Object)("[SQL]: " + commond));
        }
    }
}

