(function () {

    /*
    Longcase Clock Dial
    kurt.grigg@yahoo.co.uk
    */

    /* ^^^^^^^^^^^^^^ Config below ^^^^^^^^^^^^^^ */

    var clockSize = 350;
    var dialColour = 'rgba(235,230,255,1.0)';
    var handColour = 'rgb(30,30,40)';
    var markColour = 'rgb(20,20,30)';

    /* ^^^^^^^^^^^^^^^^ End config ^^^^^^^^^^^^^^ */

    var d = document;
    var tmr;
    var mls = 100;
    var dum = '';
    var prevsec, prevmin;
    var sincr = new Date().getSeconds() - 1;
    var mincr = new Date().getMinutes() - 1;
    var hincr = new Date().getHours();
    var rnd = 'id'+Math.random() * 1;
    var idx = d.getElementsByTagName('div').length;
    var cbcbzr = '.4s cubic-bezier(0.666, 1.91, 0.333, 0)';
    var vb = '<svg height="'+xy(100)+'" width="'+xy(100)+'" viewBox="0 0 200 200">';
    d.write('<div id = "'+rnd+'" style="display:inline-block;line-height:0px;"></div>');
    var dum = '';
    var radi = Math.PI / 180;
    var dgts = [];
    var mdgts = [];
    var svgNums ='';
    var e = 360/12;
    var degr = 0;
    var mdgts = [];
    var secOffset = -60;

    var svgNums ='';
    var numerals = ['<path d="m 41.311003,17.5 0,1.774038 1.435629,0 c 0.957089,0 1.874301,0.383264 2.751629,1.150213 0.618119,0.575216 1.027732,1.262246 1.22713,2.06116 0.259209,1.054561 0.387963,3.22695 0.387963,6.51846 l 0,41.992269 c 0,3.898683 -0.239274,6.358946 -0.717823,7.381549 -0.757691,1.565863 -1.973996,2.348283 -3.648899,2.348283 l -1.435629,0 0,1.774028 17.377993,0 0,-1.774028 -1.466396,0 c -0.957088,0 -1.863477,-0.383264 -2.720862,-1.150213 -0.638062,-0.575216 -1.056792,-1.262255 -1.256182,-2.06116 -0.259217,-1.054561 -0.389669,-3.226949 -0.389669,-6.518459 l 0,-41.992268 c 0,-3.898683 0.25009,-6.358947 0.748572,-7.381551 0.757699,-1.565863 1.963172,-2.348282 3.618141,-2.348282 l 1.466397,0 0,-1.774038 -17.377993,0 z" />',
    '<path d="m 32.622002,17.5 0,1.774033 1.435632,0 c 0.957089,0 1.874303,0.383267 2.751631,1.150215 0.61812,0.575216 1.027727,1.262245 1.227125,2.061159 0.259208,1.054561 0.387962,3.226948 0.387962,6.518458 l 0,41.99227 c 0,3.898683 -0.239268,6.358943 -0.717817,7.381547 -0.757689,1.565863 -1.973996,2.348285 -3.6489,2.348285 l -1.435633,0 0,1.774033 17.377998,0 17.377998,0 0,-1.774033 -1.466397,0 c -0.95709,0 -1.863482,-0.383267 -2.720867,-1.150215 -0.638062,-0.575216 -1.05679,-1.262254 -1.256179,-2.061159 -0.259218,-1.054561 -0.389673,-3.226948 -0.389673,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250098,-6.358943 0.748581,-7.381547 0.757699,-1.565863 1.963167,-2.348285 3.618137,-2.348285 l 1.466397,0 0,-1.774033 -17.377998,0 -17.377997,0 z m 15.9116,1.774033 1.466397,0 1.435634,0 c 0.957088,0 1.874302,0.383267 2.75163,1.150215 0.618119,0.575216 1.027725,1.262245 1.227123,2.061159 0.259209,1.054561 0.387964,3.226948 0.387964,6.518458 l 0,41.99227 c 0,3.898683 -0.239268,6.358943 -0.717817,7.381547 -0.757691,1.565863 -1.973997,2.348285 -3.6489,2.348285 l -1.435634,0 -1.466397,0 c -0.957089,0 -1.863481,-0.383267 -2.720867,-1.150215 -0.638062,-0.575216 -1.056789,-1.262254 -1.256179,-2.061159 -0.259216,-1.054561 -0.389671,-3.226948 -0.389671,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250098,-6.358943 0.74858,-7.381547 0.7577,-1.565863 1.963168,-2.348285 3.618137,-2.348285 z" />',
    '<path d="m 23.933004,17.5 0,1.774033 1.435633,0 c 0.957089,0 1.874302,0.383267 2.75163,1.150215 0.61812,0.575216 1.027727,1.262245 1.227125,2.061159 0.259209,1.054561 0.387962,3.226948 0.387962,6.518458 l 0,41.99227 c 0,3.898683 -0.239266,6.358943 -0.717816,7.381547 -0.757689,1.565863 -1.973998,2.348285 -3.648901,2.348285 l -1.435633,0 0,1.774033 17.377997,0 17.377998,0 17.377997,0 0,-1.774033 -1.466396,0 c -0.957089,0 -1.863481,-0.383267 -2.720867,-1.150215 -0.638061,-0.575216 -1.056788,-1.262254 -1.256179,-2.061159 -0.259216,-1.054561 -0.389672,-3.226948 -0.389672,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250099,-6.358942 0.74858,-7.381547 0.7577,-1.565863 1.963169,-2.348285 3.618138,-2.348285 l 1.466396,0 0,-1.774033 -17.377997,0 -17.377998,0 -17.377997,0 z m 15.911601,1.774033 1.466396,0 1.435634,0 c 0.957088,0 1.874302,0.383267 2.75163,1.150215 0.61812,0.575216 1.027726,1.262245 1.227124,2.061159 0.259208,1.054561 0.387963,3.226948 0.387963,6.518458 l 0,41.99227 c 0,3.898683 -0.239267,6.358942 -0.717816,7.381547 -0.75769,1.565863 -1.973997,2.348285 -3.648901,2.348285 l -1.435634,0 -1.466396,0 c -0.957089,0 -1.863481,-0.383267 -2.720867,-1.150215 -0.638061,-0.575216 -1.056789,-1.262254 -1.256179,-2.061159 -0.259217,-1.054561 -0.389672,-3.226948 -0.389672,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250099,-6.358943 0.74858,-7.381547 0.7577,-1.565863 1.963169,-2.348285 3.618138,-2.348285 z m 17.377997,0 1.466397,0 1.435633,0 c 0.957089,0 1.874302,0.383267 2.75163,1.150215 0.61812,0.575216 1.027727,1.262245 1.227125,2.061159 0.259209,1.054561 0.387962,3.226948 0.387962,6.518458 l 0,41.99227 c 0,3.898683 -0.239266,6.358942 -0.717816,7.381547 -0.75769,1.565863 -1.973998,2.348285 -3.648901,2.348285 l -1.435633,0 -1.466397,0 c -0.957088,0 -1.863481,-0.383267 -2.720866,-1.150215 -0.638061,-0.575216 -1.05679,-1.262254 -1.256179,-2.061159 -0.259217,-1.054561 -0.389673,-3.226948 -0.389673,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250099,-6.358943 0.748581,-7.381547 0.757699,-1.565863 1.963168,-2.348285 3.618137,-2.348285 z" />',
    '<path d="M15.244 17.5v1.773h1.436c.957 0 1.874.384 2.752 1.15.618.576 1.027 1.262 1.226 2.06.26 1.056.39 3.23.39 6.52v41.993c0 3.9-.24 6.358-.72 7.38-.758 1.567-1.973 2.35-3.648 2.35h-1.436V82.5h69.512v-1.775H83.29c-.956 0-1.864-.382-2.722-1.15-.638-.574-1.056-1.262-1.256-2.06-.26-1.056-.388-3.227-.388-6.52v-41.99c0-3.9.25-6.36.748-7.384.758-1.565 1.964-2.347 3.62-2.347h1.464V17.5H15.242zm15.912 1.773h2.903c.956 0 1.873.384 2.75 1.15.62.576 1.028 1.262 1.227 2.06.26 1.056.39 3.23.39 6.52v41.993c0 3.9-.24 6.358-.72 7.38-.758 1.567-1.974 2.35-3.648 2.35h-2.904c-.957 0-1.863-.383-2.72-1.15-.64-.575-1.057-1.263-1.256-2.062-.26-1.055-.39-3.226-.39-6.518V29.004c0-3.9.25-6.36.747-7.383.758-1.565 1.964-2.347 3.62-2.347zm17.377 0h2.903c.957 0 1.874.384 2.75 1.15.62.576 1.03 1.262 1.228 2.06.26 1.056.39 3.23.39 6.52v41.993c0 3.9-.24 6.358-.718 7.38-.758 1.567-1.976 2.35-3.65 2.35h-2.903c-.957 0-1.863-.383-2.72-1.15-.64-.575-1.057-1.263-1.256-2.062-.26-1.055-.39-3.226-.39-6.518V29.004c0-3.9.25-6.36.75-7.383.757-1.565 1.96-2.347 3.616-2.347zm17.38 0h2.9c.958 0 1.875.384 2.752 1.15.62.576 1.028 1.262 1.227 2.06.26 1.056.39 3.23.39 6.52v41.993c0 3.9-.242 6.358-.72 7.38-.758 1.567-1.974 2.35-3.65 2.35h-2.902c-.957 0-1.863-.383-2.72-1.15-.64-.575-1.057-1.263-1.256-2.062-.26-1.055-.39-3.226-.39-6.518V29.004c0-3.9.25-6.36.75-7.383.757-1.565 1.96-2.347 3.616-2.347z" />',
    '<path d="m 28.553545,17.5 0,1.734399 c 1.234615,0.156219 2.210362,0.515367 2.927233,1.077741 0.736787,0.531123 1.354094,1.28052 1.851921,2.24904 0.318608,0.624858 0.865374,2.342915 1.641985,5.154749 L 50.148498,82.5 l 1.106028,0 14.127526,-54.080614 c 0.816435,-3.155505 1.752358,-5.49863 2.807753,-7.029506 0.736787,-1.031013 1.822908,-1.749326 3.25665,-2.155481 l 0,-1.734399 -12.485542,0 0,1.734399 c 0.23896,0.06248 0.40737,0.109116 0.506934,0.140358 1.37401,0.343662 2.349749,0.937645 2.927232,1.781188 0.577484,0.81231 0.867078,1.670508 0.867078,2.576544 0,1.405908 -0.468814,3.921682 -1.404729,7.545816 L 52.299119,68.066696 41.994917,30.808784 c -0.916007,-3.311706 -1.374002,-5.748094 -1.374002,-7.31023 0,-1.12473 0.278784,-2.046767 0.836351,-2.765351 0.557568,-0.718575 1.772266,-1.217617 3.644104,-1.498795 l 0,-1.734408 -16.547825,0 z" />',
    '<path d="m 19.875925,17.5 0,1.734153 c 1.234616,0.156219 2.210364,0.51635 2.927237,1.078724 0.736788,0.531124 1.354095,1.279391 1.851924,2.247912 0.318608,0.624859 0.865373,2.34283 1.641984,5.154667 L 41.470905,82.5 l 1.106034,0 14.127541,-54.081324 c 0.816437,-3.15551 1.752361,-5.497902 2.807757,-7.02878 0.736788,-1.031014 1.822913,-1.749588 3.256657,-2.155743 l 0,0.08022 1.433747,0 c 0.955833,0 1.871842,0.382764 2.748018,1.148705 0.617308,0.574461 1.026377,1.260588 1.225514,2.058453 0.258868,1.053177 0.387452,3.222711 0.387452,6.509899 l 0,41.937137 c 0,3.893564 -0.238953,6.350593 -0.716874,7.371855 -0.756695,1.563807 -1.971404,2.345202 -3.64411,2.345202 l -1.433748,0 0,1.771704 17.355182,0 0,-1.771704 -1.464472,0 c -0.955834,0 -1.861034,-0.382763 -2.717296,-1.148705 -0.637223,-0.574461 -1.0554,-1.260597 -1.254529,-2.058453 -0.258875,-1.053176 -0.38916,-3.22271 -0.38916,-6.509899 l 0,-41.937137 c 0,-3.893564 0.249769,-6.350594 0.747597,-7.371855 0.756706,-1.563807 1.960591,-2.345202 3.613387,-2.345202 l 1.464472,0 0,-1.771703 -17.355181,0 0,-0.04267 -12.485558,0 0,1.734152 c 0.238961,0.06248 0.407368,0.108719 0.506932,0.139961 1.374013,0.343663 2.349753,0.938401 2.927236,1.781945 0.577485,0.812311 0.867076,1.669589 0.867076,2.575626 0,1.40591 -0.468816,3.921814 -1.404732,7.545954 L 43.621527,68.066934 33.317315,30.808255 c -0.916008,-3.31171 -1.37401,-5.748271 -1.37401,-7.310408 0,-1.124732 0.278785,-2.046501 0.836353,-2.765086 0.557568,-0.718576 1.772271,-1.21743 3.644111,-1.498608 l 0,-1.734153 -16.547844,0 z" />',
    '<path d="m 11.198334,17.5 0,1.734153 c 1.234616,0.156219 2.210364,0.51635 2.927236,1.078724 0.736788,0.531124 1.354097,1.279391 1.851926,2.247912 0.318608,0.624859 0.865371,2.34283 1.641983,5.154667 L 32.793314,82.5 l 1.106034,0 14.127541,-54.081324 c 0.816437,-3.155511 1.752362,-5.497902 2.807757,-7.02878 0.736789,-1.031014 1.822913,-1.749588 3.256657,-2.155743 l 0,0.08022 1.433748,0 c 0.955832,0 1.871841,0.382764 2.748017,1.148705 0.617307,0.574461 1.026378,1.260588 1.225514,2.058453 0.258868,1.053177 0.387453,3.222711 0.387454,6.509899 l 0,41.937137 c 0,3.893564 -0.238954,6.350592 -0.716875,7.371855 -0.756697,1.563807 -1.971405,2.345202 -3.64411,2.345202 l -1.433748,0 0,1.771704 17.355181,0 17.355182,0 0,-1.771704 -1.46447,0 c -0.955832,0 -1.861039,-0.382763 -2.717297,-1.148705 -0.637224,-0.574461 -1.055402,-1.260597 -1.25453,-2.058453 -0.258876,-1.053176 -0.38916,-3.22271 -0.38916,-6.509899 l 0,-41.937137 c 0,-3.893564 0.249769,-6.350594 0.747597,-7.371855 0.756704,-1.563807 1.960593,-2.345202 3.61339,-2.345202 l 1.46447,0 0,-1.771703 -17.355182,0 -17.355181,0 0,-0.04267 -12.485558,0 0,1.734152 c 0.238961,0.06248 0.407369,0.108719 0.506933,0.139961 1.374012,0.343663 2.349752,0.938401 2.927235,1.781945 0.577484,0.812311 0.867077,1.669589 0.867077,2.575626 0,1.40591 -0.468816,3.921814 -1.404732,7.545954 L 34.943937,68.066934 24.639724,30.808255 c -0.916009,-3.31171 -1.374008,-5.748271 -1.374008,-7.310408 0,-1.124732 0.278785,-2.046501 0.836353,-2.765086 0.557568,-0.718576 1.772269,-1.21743 3.64411,-1.498608 l 0,-1.734153 -16.547845,0 z m 58.783678,1.814374 1.464472,0 1.433748,0 c 0.955832,0 1.871841,0.382764 2.748017,1.148706 0.617307,0.57446 1.026377,1.260587 1.225514,2.058453 0.258867,1.053176 0.387453,3.22271 0.387453,6.509899 l 0,41.937136 c 0,3.893564 -0.238953,6.350594 -0.716874,7.371856 -0.756697,1.563807 -1.971406,2.345202 -3.64411,2.345202 l -1.433748,0 -1.464472,0 c -0.955832,0 -1.861033,-0.382764 -2.717294,-1.148706 -0.637223,-0.57446 -1.055401,-1.260596 -1.25453,-2.058453 -0.258875,-1.053176 -0.389159,-3.22271 -0.389159,-6.509899 l 0,-41.937136 c 0,-3.893564 0.249768,-6.350594 0.747596,-7.371856 0.756706,-1.563807 1.960592,-2.345202 3.613387,-2.345202 z" />',
    '<path d="m 2.5207472,17.500005 0,1.735859 c 1.2346161,0.156219 2.2103644,0.51465 2.9272363,1.077019 0.7367882,0.531124 1.3540962,1.281099 1.8519241,2.249619 0.3186078,0.624853 0.8653708,2.342828 1.6419836,5.154665 L 24.115725,82.5 l 1.106034,0 14.12754,-54.079613 c 0.816436,-3.155508 1.752361,-5.499604 2.807756,-7.030486 0.736788,-1.031007 1.822913,-1.747885 3.256657,-2.154037 l 0,0.07851 1.433748,0 c 0.955832,0 1.871842,0.382764 2.748017,1.148705 0.617309,0.574461 1.026377,1.260588 1.225514,2.058453 0.258868,1.053176 0.387453,3.22271 0.387453,6.509899 l 0,41.937133 c 0,3.893564 -0.238953,6.350592 -0.716874,7.371854 -0.756695,1.563807 -1.971405,2.345202 -3.64411,2.345202 l -1.433748,0 0,1.771704 17.35518,0 17.355179,0 17.355182,0 0,-1.771704 -1.46447,0 c -0.955833,0 -1.861039,-0.382763 -2.717298,-1.148705 -0.637223,-0.57446 -1.0554,-1.260596 -1.254529,-2.058453 -0.258875,-1.053176 -0.389161,-3.22271 -0.389161,-6.509898 l 0,-41.937133 c 0,-3.893564 0.249771,-6.350592 0.747598,-7.371855 0.756704,-1.563807 1.960593,-2.345202 3.61339,-2.345202 l 1.46447,0 0,-1.771703 -17.355182,0 -17.355179,0 -17.35518,0 0,-0.04267 -12.485556,0 0,1.735859 c 0.23896,0.06246 0.407368,0.108716 0.506932,0.139961 1.374013,0.343666 2.349751,0.936695 2.927236,1.780238 0.577484,0.812313 0.867076,1.671298 0.867076,2.577332 0,1.405912 -0.468816,3.921817 -1.404732,7.545953 L 26.266348,68.06693 15.962136,30.809962 c -0.916008,-3.311707 -1.374009,-5.748279 -1.374009,-7.310409 0,-1.124734 0.278785,-2.046502 0.836353,-2.765085 0.557568,-0.718582 1.77227,-1.217429 3.64411,-1.498609 l 0,-1.735859 -16.5478428,0 z m 58.7836728,1.814374 1.464472,0 1.433748,0 c 0.955832,0 1.871841,0.382764 2.748017,1.148706 0.61731,0.57446 1.026378,1.260587 1.225513,2.058453 0.258867,1.053176 0.387453,3.22271 0.387453,6.509898 l 0,41.937133 c 0,3.893564 -0.238953,6.350591 -0.716873,7.371854 -0.756696,1.563808 -1.971406,2.345203 -3.64411,2.345203 l -1.433748,0 -1.464472,0 c -0.955832,0 -1.861034,-0.382764 -2.717294,-1.148705 -0.637223,-0.574461 -1.055402,-1.260597 -1.254529,-2.058453 -0.258877,-1.053177 -0.389161,-3.22271 -0.389161,-6.509899 l 0,-41.937133 c 0,-3.893564 0.249771,-6.350594 0.747598,-7.371854 0.756704,-1.563808 1.96059,-2.345203 3.613386,-2.345203 z m 17.355179,0 1.464472,0 1.433748,0 c 0.955833,0 1.871842,0.382764 2.748017,1.148706 0.617309,0.57446 1.026378,1.260587 1.225514,2.058453 0.258869,1.053176 0.387453,3.22271 0.387453,6.509898 l 0,41.937133 c 0,3.893564 -0.238953,6.350591 -0.716874,7.371854 -0.756695,1.563808 -1.971406,2.345203 -3.64411,2.345203 l -1.433748,0 -1.464472,0 c -0.955832,0 -1.861033,-0.382764 -2.717294,-1.148705 -0.637222,-0.574461 -1.055402,-1.260597 -1.254528,-2.058453 -0.258878,-1.053177 -0.389161,-3.22271 -0.389161,-6.509899 l 0,-41.937133 c 0,-3.893564 0.24977,-6.350592 0.747597,-7.371854 0.756706,-1.563808 1.96059,-2.345203 3.613386,-2.345203 z" />',
    '<path d="m 19.776507,17.5 0,1.774033 1.435632,0 c 0.957089,0 1.874302,0.383265 2.75163,1.150213 0.61812,0.575216 1.027727,1.262246 1.227125,2.06116 0.259209,1.054561 0.387962,3.226949 0.387962,6.518459 l 0,41.992265 c 0,3.898683 -0.239267,6.358945 -0.717816,7.381549 -0.757691,1.565863 -1.973997,2.348282 -3.648901,2.348282 l -1.435632,0 0,1.774038 17.377995,0 14.387094,0 0,-1.774038 c -1.515389,-0.09587 -2.543124,-0.479126 -3.081484,-1.150212 -0.538367,-0.671087 -0.806689,-1.518812 -0.806689,-2.541415 0,-0.671087 0.08887,-1.308711 0.268327,-1.915884 0.179456,-0.63913 0.717816,-1.886009 1.615087,-3.739485 L 58.030999,53.9309 64.910074,70.611588 c 0.957089,2.268907 1.506281,3.674766 1.645851,4.218025 0.179455,0.735 0.268327,1.46972 0.268327,2.204721 0,0.607173 -0.139576,1.214713 -0.418727,1.821886 -0.259216,0.575216 -0.598175,1.00617 -1.016906,1.293783 -0.558301,0.351517 -1.415697,0.544002 -2.572176,0.575959 l 0,1.774038 17.40705,0 0,-1.774038 c -1.79454,-0.159784 -3.279169,-0.989894 -4.45559,-2.491843 -1.156486,-1.533906 -2.941909,-5.177458 -5.354568,-10.929616 L 61.710663,46.501495 69.755335,30.010517 c 1.635027,-3.355424 2.902031,-5.654992 3.799301,-6.901294 0.897271,-1.246302 1.883413,-2.237107 2.960139,-2.972098 0.717822,-0.479354 1.645849,-0.76722 2.782393,-0.863091 l 0,-1.774033 -14.387094,0 0,1.774033 c 1.435638,0.03194 2.383606,0.190937 2.842212,0.47854 0.458606,0.255656 0.83745,0.720116 1.136543,1.391202 0.239274,0.511302 0.358908,1.101237 0.358908,1.772323 0,0.671087 -0.0997,1.326317 -0.299091,1.965447 -0.179455,0.639129 -0.688761,1.822419 -1.526214,3.548066 l -7.207219,14.619529 -6.221077,-14.90666 c -0.957098,-2.268906 -1.435633,-3.994431 -1.435633,-5.176819 0,-0.894785 0.288272,-1.71071 0.866507,-2.445702 0.598186,-0.735 1.694841,-1.150055 3.289993,-1.245926 l 0,-1.774033 -18.752103,0 0,1.774033 c 1.973996,0.09587 3.717836,0.94188 5.233225,2.5397 1.51539,1.565863 3.360638,4.88975 5.534023,9.970812 l 7.984855,18.741849 -9.570887,19.365665 c -1.435639,2.908035 -2.711754,5.06623 -3.828355,6.472317 -1.116602,1.406078 -2.293025,2.524071 -3.529264,3.354934 -0.737758,0.511302 -1.615088,0.846867 -2.631995,1.006651 l -1.466396,0 c -0.957089,0 -1.863481,-0.383265 -2.720867,-1.150213 -0.638061,-0.575215 -1.056788,-1.262254 -1.256179,-2.061159 -0.259216,-1.054561 -0.389672,-3.226949 -0.389672,-6.518459 l 0,-41.992265 c 0,-3.898683 0.250099,-6.358946 0.74858,-7.38155 0.757701,-1.565862 1.963169,-2.348282 3.618138,-2.348282 l 1.466396,0 0,-1.774033 -17.377995,0 z" />',
    '<path d="m 29.273902,17.5 0,1.774038 c 1.973996,0.09587 3.717836,0.94188 5.233226,2.5397 1.515389,1.565863 3.360639,4.88975 5.534025,9.970813 l 7.984856,18.74185 -9.570888,19.365666 c -1.435638,2.908036 -2.711753,5.066231 -3.828355,6.472318 -1.116602,1.406078 -2.293023,2.524072 -3.529262,3.354934 -0.737757,0.511302 -1.615094,0.846867 -2.632001,1.006652 l 0,1.774029 14.387098,0 0,-1.774029 c -1.515389,-0.09587 -2.543121,-0.479126 -3.08148,-1.150213 -0.538367,-0.671087 -0.806693,-1.518811 -0.806693,-2.541415 0,-0.671087 0.08887,-1.308711 0.268326,-1.915884 0.179456,-0.63913 0.717814,-1.88601 1.615084,-3.739485 l 8.494171,-17.448067 6.879068,16.68069 c 0.957089,2.268906 1.506281,3.674766 1.645852,4.218025 0.179455,0.735 0.268326,1.46972 0.268326,2.204721 0,0.607173 -0.139571,1.214713 -0.418722,1.821886 -0.259216,0.575215 -0.598177,1.00617 -1.016907,1.293782 -0.558301,0.351518 -1.415695,0.544003 -2.572173,0.57596 l 0,1.774029 17.407044,0 0,-1.774029 c -1.79454,-0.159785 -3.279163,-0.989895 -4.455584,-2.491852 -1.156487,-1.533906 -2.94191,-5.17745 -5.35457,-10.929608 L 53.021665,46.5015 61.066339,30.010522 c 1.635027,-3.355424 2.902033,-5.654993 3.799304,-6.901295 0.897269,-1.246302 1.883411,-2.237107 2.960136,-2.972099 0.717823,-0.479353 1.645851,-0.767219 2.782397,-0.86309 l 0,-1.774038 -14.387099,0 0,1.774038 c 1.435637,0.03194 2.383608,0.190936 2.842215,0.47854 0.458606,0.255655 0.837451,0.720116 1.136544,1.391202 0.239275,0.511302 0.358912,1.101236 0.358912,1.772323 0,0.671087 -0.0997,1.326317 -0.299093,1.965447 -0.179456,0.63913 -0.688763,1.822419 -1.526215,3.548067 l -7.207222,14.61953 -6.221072,-14.906661 c -0.957097,-2.268907 -1.435637,-3.994431 -1.435637,-5.17682 0,-0.894785 0.288268,-1.71071 0.866503,-2.445702 0.598186,-0.735 1.694846,-1.150055 3.289997,-1.245926 l 0,-1.774038 -18.752106,0 z" />',
    '<path d="m 20.584902,17.5 0,1.774033 c 1.973996,0.09587 3.717835,0.941883 5.233225,2.539702 1.51539,1.565863 3.360639,4.889752 5.534024,9.970815 l 7.984855,18.741848 -9.570888,19.365667 c -1.435637,2.908036 -2.711753,5.066225 -3.828355,6.472312 -1.116602,1.406078 -2.293025,2.524076 -3.529264,3.354939 -0.737757,0.511302 -1.615088,0.846867 -2.631994,1.006651 l 0,1.774033 14.387094,0 0,-1.774033 c -1.515389,-0.09587 -2.543125,-0.479129 -3.081484,-1.150215 -0.538367,-0.671087 -0.806689,-1.518809 -0.806689,-2.541413 0,-0.671086 0.08887,-1.308713 0.268327,-1.915886 0.179456,-0.63913 0.717817,-1.886007 1.615086,-3.739482 l 8.494163,-17.44807 6.879075,16.68069 c 0.95709,2.268905 1.50628,3.674767 1.645851,4.218026 0.179457,0.735001 0.268327,1.469722 0.268327,2.204722 0,0.607173 -0.139575,1.214714 -0.418726,1.821887 -0.259217,0.575216 -0.598175,1.006167 -1.016906,1.293779 -0.558301,0.351518 -1.415698,0.544005 -2.572176,0.575962 l 0,1.774033 17.407052,0 17.377996,0 0,-1.774033 -1.466396,0 c -0.957089,0 -1.863482,-0.383267 -2.720867,-1.150215 -0.63806,-0.575216 -1.056788,-1.262254 -1.256179,-2.061159 -0.259216,-1.054561 -0.389672,-3.226948 -0.389672,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250098,-6.358943 0.74858,-7.381547 0.757699,-1.565863 1.963169,-2.348285 3.618138,-2.348285 l 1.466396,0 0,-1.774033 -17.377997,0 0,1.774033 1.435633,0 c 0.95709,0 1.874302,0.383267 2.75163,1.150215 0.618119,0.575216 1.027727,1.262245 1.227125,2.061159 0.259208,1.054561 0.387962,3.226948 0.387962,6.518458 l 0,41.99227 c 0,3.898683 -0.239267,6.358943 -0.717816,7.381547 -0.757691,1.565863 -1.973997,2.348285 -3.648901,2.348285 l -1.435633,0 c -1.794541,-0.159784 -3.27917,-0.989891 -4.45559,-2.491848 -1.156487,-1.533906 -2.941911,-5.177454 -5.35457,-10.929612 L 44.332667,46.501499 52.37734,30.010517 c 1.635027,-3.355424 2.90203,-5.654991 3.799301,-6.901293 0.897271,-1.246303 1.883414,-2.237111 2.960139,-2.972103 0.717823,-0.479353 1.64585,-0.767218 2.782393,-0.863088 l 0,-1.774033 -14.387096,0 0,1.774033 c 1.43564,0.03194 2.383606,0.19094 2.842213,0.478544 0.458607,0.255655 0.837449,0.720111 1.136543,1.391197 0.239274,0.511301 0.358908,1.101236 0.358908,1.772323 0,0.671086 -0.0997,1.326321 -0.29909,1.96545 -0.179456,0.63913 -0.688762,1.822417 -1.526214,3.548065 L 42.837215,43.049143 36.616139,28.142485 c -0.957096,-2.268906 -1.435633,-3.994436 -1.435633,-5.176824 0,-0.894785 0.288272,-1.710712 0.866507,-2.445704 0.598186,-0.735 1.694843,-1.150054 3.289993,-1.245924 l 0,-1.774033 -18.752104,0 z" />',
    '<path d="m 11.895902,17.5 0,1.774033 c 1.973997,0.09587 3.717834,0.941882 5.233224,2.539702 1.51539,1.565863 3.360638,4.889752 5.534025,9.970815 l 7.984854,18.741849 -9.570888,19.365666 c -1.435637,2.908036 -2.711752,5.066226 -3.828355,6.472312 -1.116602,1.406078 -2.293025,2.524076 -3.529264,3.354939 -0.737757,0.511302 -1.615087,0.846867 -2.631994,1.006651 l 0,1.774033 14.387094,0 0,-1.774033 c -1.515388,-0.09587 -2.543126,-0.479129 -3.081483,-1.150215 -0.538367,-0.671087 -0.806688,-1.518808 -0.806688,-2.541413 0,-0.671086 0.08887,-1.308713 0.268325,-1.915887 0.179456,-0.639129 0.717817,-1.886006 1.615088,-3.739481 l 8.494162,-17.44807 6.879076,16.68069 c 0.957089,2.268904 1.50628,3.674768 1.645851,4.218026 0.179457,0.735001 0.268326,1.469722 0.268326,2.204722 0,0.607173 -0.139575,1.214714 -0.418726,1.821887 -0.259217,0.575216 -0.598174,1.006167 -1.016907,1.293779 -0.558299,0.351517 -1.415698,0.544005 -2.572177,0.575962 l 0,1.774033 17.407053,0 17.377997,0 17.378001,0 0,-1.774033 -1.466396,0 c -0.957088,0 -1.863485,-0.383267 -2.72087,-1.150215 -0.638063,-0.575216 -1.05679,-1.262253 -1.256179,-2.061159 -0.259218,-1.054561 -0.389673,-3.226943 -0.389673,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250099,-6.358943 0.748581,-7.381547 0.7577,-1.565863 1.963171,-2.348285 3.618141,-2.348285 l 1.466395,0 0,-1.774033 -17.378,0 -17.377997,0 0,1.774033 1.435633,0 c 0.957089,0 1.874303,0.383267 2.75163,1.150215 0.618121,0.575215 1.027728,1.262245 1.227125,2.061159 0.259209,1.054561 0.387963,3.226947 0.387963,6.518458 l 0,41.99227 c 0,3.898683 -0.239267,6.358941 -0.717818,7.381547 -0.75769,1.565863 -1.973996,2.348285 -3.6489,2.348285 l -1.435633,0 c -1.794541,-0.159784 -3.279169,-0.98989 -4.45559,-2.491848 -1.156485,-1.533906 -2.941911,-5.177454 -5.35457,-10.929612 L 35.643667,46.501499 43.688339,30.010518 c 1.635028,-3.355425 2.902031,-5.654992 3.799301,-6.901295 0.897272,-1.246301 1.883414,-2.23711 2.960139,-2.972101 0.717823,-0.479354 1.645851,-0.767219 2.782394,-0.863089 l 0,-1.774033 -14.387095,0 0,1.774033 c 1.435638,0.03194 2.383605,0.19094 2.842211,0.478544 0.458607,0.255655 0.837451,0.720111 1.136543,1.391197 0.239275,0.511301 0.358909,1.101236 0.358909,1.772323 0,0.671086 -0.0997,1.326321 -0.299091,1.965451 -0.179454,0.639129 -0.688761,1.822416 -1.526214,3.548064 L 34.148215,43.049143 27.927138,28.142485 c -0.957096,-2.268906 -1.435632,-3.994435 -1.435632,-5.176824 0,-0.894785 0.288272,-1.710712 0.866507,-2.445704 0.598185,-0.735001 1.694842,-1.150054 3.289992,-1.245924 l 0,-1.774033 -18.752103,0 z m 58.172196,1.774033 1.466397,0 1.435634,0 c 0.957089,0 1.874302,0.383267 2.75163,1.150215 0.61812,0.575216 1.027726,1.262245 1.227124,2.061159 0.259209,1.054561 0.387965,3.226947 0.387965,6.518458 l 0,41.99227 c 0,3.898688 -0.23927,6.358942 -0.717818,7.381547 -0.757691,1.565863 -1.973997,2.348285 -3.6489,2.348285 l -1.435634,0 -1.466397,0 c -0.957089,0 -1.863481,-0.383267 -2.720866,-1.150215 -0.638061,-0.575215 -1.056789,-1.262253 -1.256179,-2.061159 -0.259217,-1.054561 -0.389672,-3.226947 -0.389672,-6.518458 l 0,-41.99227 c 0,-3.898683 0.250099,-6.358942 0.748579,-7.381547 0.7577,-1.565863 1.96317,-2.348285 3.618138,-2.348285 z" />'];

    function xy (v) {
        return (v * clockSize / 100);
    }

    function genShadKillClone(c, v, x, y) {
        c.style.left = xy(x)+'px';
        c.style.top = xy(y)+'px';
        c.style.zIndex--;   
        var s = 'filter="url(#handShadow)"';
        var r = v.split('filter="url()"').join("");
        r = r.replace(/""/g, s);
        c.innerHTML = r;
    }

    /* Dial */

    var dial = d.createElement('div');
    dial.setAttribute('style', 'display: block;'
        +'position: relative;'
        +'height: '+xy(99.8)+'px;'
        +'width: '+xy(99.8)+'px;'
        +'margin: auto; top: 0; bottom: 0;left: 0;right: 0;' 
        +'border-radius: 0%;'
        +'background-color: '+dialColour+';'
        +'border: '+xy(0.2)+'px solid #fff000;'
        +'letter-spacing: -4px;font-style: normal;'
        +'overflow: hidden;');
    d.getElementById(rnd).appendChild(dial);

    /* Clock markers  */

    var face = '<svg id="sfc'+idx+'" xmlns="http://www.w3.org/2000/svg"'+ 
        'viewBox="0 0 200 200" width="100%" height="100%">'+
        '<defs>'+
        '<clipPath id="dialPath">'+
        '<circle cx="100" cy="100" r="100"/>'+
        '</clipPath>'+
        '<filter id="handShadow" color-interpolation-filters="sRGB">'+
        '<feFlood result="flood" flood-color="#000" flood-opacity=".4"/>'+
        '<feComposite result="composite1" operator="in" in2="SourceGraphic" in="flood"/>'+
        '<feGaussianBlur result="blur" stdDeviation="0.3" in="composite1"/>'+
        '<feOffset result="offset" dy="0" dx="0"/>'+
        '<feComposite result="composite2" operator="atop" in2="offset" in="offset"/>'+
        '</filter>'+
        '<filter id="shadow" >'+
        '<feGaussianBlur in="SourceAlpha" stdDeviation="0.2"/>'+
        '<feOffset dx="0" dy="0.3" result="offsetblur"/>'+
        '<feFlood flood-color="#111100" flood-opacity="0.8"/>'+
        '<feComposite in2="offsetblur" operator="in"/>'+
        '<feMerge>'+
        '<feMergeNode/>'+
        '<feMergeNode in="SourceGraphic"/>'+
        '</feMerge>'+
        '</filter>'+
        '</defs>'+
        
        '<g filter="url(#shadow)"><path d="M16.746 2.322c-.17 0-.335.02-.504.026H2.348v13.894c-.006.17-.026.334-.026.504 0 .17.02.335.026.504v45.277l.875.174C15.02 34.64 35.243 15.086 62.71 3.224l-.183-.875H17.25c-.17-.006-.334-.026-.504-.026zm166.508 0c-.17 0-.335.02-.504.026h-45.277l-.182.875c27.468 11.862 47.69 31.415 59.487 59.478l.875-.173V17.25c.006-.17.026-.334.026-.504 0-.17-.02-.335-.026-.504V2.348h-13.894c-.17-.006-.334-.026-.504-.026zM3.26 3.26h8.408C7.795 4.72 4.72 7.795 3.26 11.668V3.26zm18.562 0h17.416c-.794.51-1.474 1.215-1.955 2.082-1.018 1.837-1.018 4.093 0 5.93.843 1.52 2.286 2.553 3.92 2.87-3.727 2.58-7.27 5.324-11.758 9.434 1.098-2.034 1.723-4.358 1.723-6.83 0-6.17-3.89-11.428-9.346-13.486zm20.545 0h18.166c-6.482 2.917-12.552 6.278-18.2 10.086-.028-.006-.057-.007-.087-.006-1.714 0-3.3-.95-4.166-2.51-.864-1.56-.864-3.488 0-5.047.865-1.56 2.452-2.51 4.166-2.51.04 0 .082-.003.12-.013zm97.1 0h18.166c.04.01.08.014.12.013 1.715 0 3.302.95 4.167 2.51.864 1.56.864 3.488 0 5.047-.865 1.56-2.452 2.51-4.166 2.51-.03 0-.06 0-.088.006-5.647-3.808-11.717-7.17-18.2-10.086zm21.295 0h17.416c-5.455 2.058-9.346 7.315-9.346 13.486 0 2.472.625 4.796 1.723 6.83-4.49-4.11-8.03-6.855-11.758-9.435 1.634-.315 3.077-1.35 3.92-2.87 1.018-1.835 1.018-4.09 0-5.928-.48-.867-1.16-1.572-1.955-2.082zm27.57 0h8.408v8.408c-1.46-3.873-4.535-6.947-8.408-8.408zm-171.586.035c.188 0 .37.022.555.03 2.527.31 4.513 2.707 4.513 5.702v2.65h2.652c2.995 0 5.39 1.986 5.7 4.512.01.185.03.368.03.556 0 .188-.02.37-.03.555-.31 2.527-2.705 4.512-5.7 4.512h-2.652v2.653c0 2.995-1.986 5.39-4.512 5.7-.185.01-.366.03-.554.03-.188 0-.37-.02-.557-.03-2.527-.31-4.512-2.705-4.512-5.7v-2.653h-2.65c-2.996 0-5.394-1.985-5.704-4.51-.007-.187-.027-.368-.027-.556 0-.188.02-.37.027-.557.31-2.527 2.708-4.512 5.703-4.512h2.65v-2.65c0-2.996 1.986-5.394 4.512-5.704.185-.007.368-.03.556-.03zm166.508 0c.188 0 .37.022.557.03 2.527.31 4.512 2.707 4.512 5.702v2.65h2.65c2.996 0 5.394 1.986 5.704 4.512.008.185.027.368.027.556 0 .188-.02.37-.027.555-.31 2.527-2.708 4.513-5.703 4.512h-2.65v2.653c0 2.995-1.986 5.39-4.512 5.7-.185.01-.368.03-.556.03-.188 0-.37-.02-.555-.03-2.527-.31-4.512-2.705-4.512-5.7v-2.653h-2.653c-2.995 0-5.39-1.985-5.7-4.51-.01-.187-.03-.368-.03-.556 0-.188.02-.37.03-.557.31-2.527 2.705-4.512 5.7-4.512h2.652v-2.65c0-2.996 1.986-5.394 4.512-5.704.185-.007.366-.03.554-.03zM13.06 3.818c-1.386 1.218-2.27 3.104-2.27 5.21v1.76H9.026c-2.105 0-3.99.886-5.21 2.273 1.27-4.464 4.78-7.973 9.244-9.242zm7.37 0c4.464 1.27 7.973 4.778 9.242 9.243-1.218-1.386-3.102-2.27-5.207-2.27H22.7V9.026c0-2.105-.883-3.99-2.27-5.21zm159.14 0c-1.387 1.218-2.27 3.104-2.27 5.21v1.76h-1.765c-2.105 0-3.99.886-5.207 2.273 1.27-4.464 4.778-7.973 9.242-9.242zm7.37 0c4.464 1.27 7.973 4.778 9.242 9.243-1.218-1.386-3.104-2.27-5.21-2.27h-1.76V9.026c0-2.105-.886-3.99-2.273-5.21zM3.817 20.43c1.218 1.387 3.104 2.27 5.21 2.27h1.76v1.765c0 2.105.886 3.99 2.273 5.207-4.464-1.27-7.973-4.778-9.242-9.242zm25.854 0c-1.27 4.464-4.778 7.973-9.242 9.242 1.387-1.218 2.27-3.102 2.27-5.207V22.7h1.765c2.105 0 3.99-.883 5.207-2.27zm140.656 0c1.218 1.387 3.102 2.27 5.207 2.27h1.764v1.765c0 2.105.883 3.99 2.27 5.207-4.464-1.27-7.973-4.778-9.242-9.242zm25.854 0c-1.27 4.464-4.778 7.973-9.243 9.242 1.386-1.218 2.27-3.102 2.27-5.207V22.7h1.763c2.105 0 3.99-.883 5.21-2.27zM3.26 21.822c2.058 5.455 7.315 9.346 13.486 9.346 2.46 0 4.775-.62 6.803-1.71-4.02 4.333-6.82 7.8-9.345 11.417-.3-1.662-1.344-3.033-2.885-3.887-1.837-1.018-4.092-1.018-5.93 0-.893.496-1.617 1.2-2.13 2.026V21.822zm193.48 0v17.192c-.513-.827-1.237-1.53-2.13-2.026-1.838-1.018-4.093-1.018-5.93 0-1.54.854-2.586 2.225-2.885 3.887-2.525-3.618-5.326-7.084-9.344-11.416 2.03 1.087 4.343 1.708 6.804 1.708 6.17 0 11.428-3.89 13.486-9.346zM8.355 37.137c.872 0 1.744.216 2.524.648 1.558.865 2.51 2.45 2.51 4.164-.002.048.006.096.02.142C9.56 47.76 6.168 53.895 3.258 60.51V42.187c.043-.072.065-.154.064-.238 0-1.715.95-3.3 2.51-4.165.78-.432 1.65-.648 2.523-.648zm183.29 0c.872 0 1.743.216 2.523.648 1.56.865 2.51 2.45 2.51 4.164 0 .083.02.165.064.237V60.51c-2.91-6.615-6.302-12.75-10.152-18.418.014-.046.022-.094.02-.143 0-1.715.952-3.3 2.51-4.165.78-.432 1.653-.648 2.525-.648zM3.223 137.3l-.875.173v45.277c-.006.17-.026.334-.026.504 0 .17.02.335.026.504v13.894h13.894c.17.006.334.026.504.026.17 0 .335-.02.504-.026h45.277l.182-.875C35.24 184.915 15.02 165.362 3.222 137.3zm193.554 0c-11.797 28.062-32.02 47.615-59.486 59.477l.183.875h45.277c.17.006.334.026.504.026.17 0 .335-.02.504-.026h13.894v-13.894c.006-.17.026-.334.026-.504 0-.17-.02-.335-.026-.504v-45.277l-.875-.174zm-193.52 2.19c2.91 6.615 6.303 12.75 10.153 18.418-.014.046-.022.095-.02.143 0 1.715-.952 3.3-2.51 4.165-.78.432-1.653.648-2.525.648-.872 0-1.743-.216-2.523-.648-1.56-.865-2.51-2.45-2.51-4.164 0-.083-.02-.165-.064-.238V139.49zm193.485 0v18.322c-.043.073-.065.155-.064.24 0 1.713-.95 3.298-2.51 4.163-.78.432-1.652.648-2.524.648-.87 0-1.743-.216-2.523-.648-1.558-.865-2.51-2.45-2.51-4.164.002-.048-.006-.096-.02-.142 3.85-5.668 7.242-11.803 10.152-18.418zM14.205 159.125c2.525 3.618 5.326 7.084 9.344 11.416-2.03-1.087-4.343-1.708-6.804-1.708-6.17 0-11.428 3.89-13.486 9.346v-17.192c.513.827 1.237 1.53 2.13 2.026 1.838 1.018 4.093 1.018 5.93 0 1.54-.854 2.586-2.225 2.885-3.887zm171.59 0c.3 1.662 1.344 3.033 2.885 3.887 1.837 1.018 4.092 1.018 5.93 0 .893-.496 1.617-1.2 2.13-2.026v17.192c-2.058-5.455-7.315-9.346-13.486-9.346-2.46 0-4.775.62-6.803 1.71 4.02-4.333 6.82-7.8 9.345-11.417zm-169.05 10.68c.19 0 .37.02.556.03 2.527.31 4.513 2.705 4.513 5.7v2.653h2.652c2.995 0 5.39 1.985 5.7 4.51.01.187.03.368.03.556 0 .188-.02.37-.03.557-.31 2.527-2.705 4.512-5.7 4.512h-2.652v2.65c0 2.996-1.986 5.394-4.512 5.704-.185.008-.366.03-.554.03-.188 0-.37-.023-.557-.03-2.527-.31-4.512-2.708-4.512-5.703v-2.65h-2.65c-2.996 0-5.394-1.986-5.704-4.512-.008-.185-.027-.368-.027-.556 0-.188.02-.37.027-.555.31-2.527 2.708-4.512 5.703-4.512h2.65v-2.653c0-2.995 1.986-5.39 4.512-5.7.185-.01.368-.03.556-.03zm166.51 0c.187 0 .37.02.556.03 2.527.31 4.512 2.705 4.512 5.7v2.653h2.65c2.996 0 5.394 1.985 5.704 4.51.008.187.027.368.027.556 0 .188-.02.37-.027.557-.31 2.527-2.708 4.512-5.703 4.512h-2.65v2.65c0 2.996-1.986 5.394-4.512 5.704-.185.008-.368.03-.556.03-.188 0-.37-.022-.555-.03-2.527-.31-4.512-2.708-4.512-5.703v-2.65h-2.653c-2.995 0-5.39-1.986-5.7-4.512-.01-.185-.03-.368-.03-.556 0-.188.02-.37.03-.555.31-2.527 2.705-4.512 5.7-4.512h2.652v-2.653c0-2.995 1.986-5.39 4.512-5.7.185-.01.366-.03.554-.03zm-170.194.523c-1.386 1.218-2.27 3.102-2.27 5.207v1.764H9.026c-2.105 0-3.99.883-5.21 2.27 1.27-4.464 4.78-7.973 9.244-9.242zm7.37 0c4.464 1.27 7.973 4.778 9.242 9.242-1.218-1.387-3.102-2.27-5.207-2.27H22.7v-1.765c0-2.105-.883-3.99-2.27-5.207zm159.14 0c-1.387 1.218-2.27 3.102-2.27 5.207v1.764h-1.765c-2.105 0-3.99.883-5.207 2.27 1.27-4.464 4.778-7.973 9.242-9.242zm7.37 0c4.464 1.27 7.973 4.778 9.242 9.242-1.218-1.387-3.104-2.27-5.21-2.27h-1.76v-1.765c0-2.105-.886-3.99-2.273-5.207zm-157.495 6.096c4.49 4.11 8.03 6.855 11.758 9.435-1.634.315-3.077 1.35-3.92 2.87-1.018 1.835-1.018 4.09 0 5.928.48.867 1.16 1.572 1.955 2.082H21.822c5.455-2.058 9.346-7.315 9.346-13.486 0-2.472-.625-4.796-1.723-6.83zm141.11 0c-1.098 2.034-1.723 4.358-1.723 6.83 0 6.17 3.89 11.428 9.346 13.486h-17.416c.794-.51 1.474-1.215 1.955-2.082 1.018-1.837 1.018-4.093 0-5.93-.843-1.52-2.286-2.553-3.92-2.87 3.727-2.58 7.27-5.324 11.758-9.434zm-128.22 10.23c5.646 3.808 11.716 7.17 18.198 10.086H42.367c-.04-.01-.08-.014-.12-.013-1.715 0-3.302-.95-4.167-2.51-.864-1.56-.864-3.488 0-5.047.865-1.56 2.452-2.51 4.166-2.51.03 0 .06 0 .088-.006zm115.33 0c.03.005.06.006.09.006 1.713 0 3.3.95 4.165 2.51.864 1.56.864 3.488 0 5.047-.865 1.56-2.452 2.51-4.166 2.51-.04 0-.082.004-.12.013h-18.167c6.482-2.917 12.552-6.278 18.2-10.086zM3.82 186.94c1.218 1.386 3.104 2.27 5.21 2.27h1.76v1.763c0 2.105.886 3.99 2.273 5.21-4.464-1.27-7.973-4.78-9.242-9.244zm25.854 0c-1.27 4.464-4.778 7.973-9.242 9.242 1.387-1.218 2.27-3.104 2.27-5.21v-1.76h1.765c2.105 0 3.99-.886 5.207-2.273zm140.656 0c1.218 1.386 3.102 2.27 5.207 2.27h1.764v1.763c0 2.105.883 3.99 2.27 5.21-4.464-1.27-7.973-4.78-9.242-9.244zm25.854 0c-1.27 4.464-4.778 7.973-9.243 9.242 1.386-1.218 2.27-3.104 2.27-5.21v-1.76h1.763c2.105 0 3.99-.886 5.21-2.273zM3.26 188.33c1.46 3.873 4.535 6.947 8.408 8.408H3.26v-8.408zm193.48 0v8.408h-8.408c3.873-1.46 6.947-4.535 8.408-8.408z" fill="#ffff00"/></g>'+
        '<circle cx="100" cy="50%" r="99" fill="'+dialColour+'" stroke="'+markColour+'" stroke-width="0.5"/>'+ 
        '<circle cx="100" cy="50%" r="94" fill="'+dialColour+'" stroke="'+markColour+'" stroke-width="0.5"/>'+  
        '<g  filter="url(#shadow)" transform="translate(-39.8, -40.2) scale(1.4, 1.4)"><g><circle cx="100" cy="0" fill="none" stroke="#000" stroke-width=".4" stroke-linecap="square"/><path d="M100 50c-27.612 0-50 22.388-50 50s22.388 50 50 50 50-22.388 50-50-22.388-50-50-50zm-.2.406v1.504l-5.52 6.455-6.862-6.35c3.957-1.036 8.106-1.592 12.383-1.61zm.4 0c4.277.017 8.427.573 12.384 1.608l-6.863 6.35-5.52-6.456v-1.502zM86.9 52.16l-2.765 8.924-8.008-2.832-.753-1.303c3.585-2.056 7.45-3.677 11.525-4.79zm26.198 0c4.075 1.113 7.938 2.735 11.523 4.79l-.752 1.304-8.01 2.83-2.76-8.924zm-13.1.113l5.438 6.356L100 63.66l-5.436-5.033L100 52.272zm-12.76.104l6.787 6.283-3.886 4.545-5.638-1.994 2.738-8.833zm25.522 0l2.736 8.834-5.64 1.995-3.883-4.545 6.787-6.283zM75.03 57.15l.75 1.303-1.55 8.35-9.103-2.067c2.958-2.925 6.286-5.474 9.902-7.586zm49.94 0c3.617 2.112 6.945 4.66 9.903 7.586l-9.102 2.07-1.55-8.353.75-1.303zm-48.835 1.518l7.886 2.787-2.19 7.074-7.223-1.64 1.528-8.222zm47.728 0l1.53 8.223-7.223 1.64-2.193-7.075 7.886-2.787zm-29.55.256l5.496 5.086v10.433c-.234-1.34-.563-2.42-.966-3.287-.782-1.68-1.84-2.6-2.944-3.24-1.102-.64-2.24-1.012-3.218-1.62-.933-.582-1.727-1.374-2.252-2.833l3.882-4.54zm11.376 0l3.882 4.54c-.525 1.458-1.32 2.25-2.252 2.83-.977.61-2.116.982-3.218 1.622-1.103.64-2.164 1.56-2.946 3.24-.403.868-.732 1.946-.965 3.287v-10.43l5.5-5.09zm-21.3 2.658l5.63 1.99c.277 1.527-.016 2.608-.534 3.578-.542 1.017-1.34 1.908-1.976 3.014-.635 1.106-1.093 2.433-.93 4.277.084.954.34 2.053.81 3.33l-5.218-9.034 2.22-7.154zm31.22 0l2.218 7.154-5.217 9.035c.47-1.277.728-2.374.812-3.327.163-1.844-.297-3.173-.932-4.28-.635-1.105-1.432-1.994-1.974-3.01-.518-.97-.81-2.054-.536-3.58l5.63-1.99zm-25.1 2.996c.53.952 1.215 1.575 1.967 2.043 1.03.643 2.172 1.015 3.23 1.63 1.058.615 2.04 1.46 2.787 3.068.744 1.6 1.25 3.965 1.313 7.586-.27.577-.685.933-1.16 1.27-.49.35-1.045.678-1.504 1.217-.46.54-.812 1.285-.91 2.438-.058.705-.01 1.59.146 2.654-.4-1-.8-1.788-1.204-2.37-.66-.95-1.34-1.42-2.006-1.657-.667-.236-1.312-.243-1.914-.3-.578-.056-1.112-.157-1.633-.52-1.758-3.168-2.503-5.47-2.658-7.227-.156-1.766.27-2.99.88-4.05.608-1.062 1.412-1.957 1.983-3.028.417-.782.7-1.662.682-2.752zm18.982 0c-.018 1.09.265 1.972.682 2.754.57 1.07 1.375 1.964 1.984 3.025.61 1.062 1.033 2.285.877 4.05-.155 1.758-.898 4.06-2.656 7.226-.523.364-1.057.466-1.636.52-.602.06-1.247.066-1.914.302-.667.237-1.345.708-2.006 1.658-.404.58-.805 1.37-1.203 2.37.157-1.065.205-1.95.146-2.655-.097-1.153-.45-1.9-.91-2.437-.458-.538-1.012-.866-1.504-1.216-.474-.337-.887-.693-1.157-1.268.06-3.622.57-5.99 1.313-7.588.748-1.607 1.73-2.453 2.787-3.068 1.058-.615 2.2-.987 3.23-1.63.752-.467 1.438-1.09 1.967-2.042zm25.77.547c2.926 2.96 5.476 6.288 7.588 9.904l-1.303.75-8.35-1.55 2.065-9.105zm-70.524.002l2.067 9.102-8.352 1.55-1.303-.75c2.112-3.617 4.662-6.945 7.588-9.903zm.4.01l9.02 2.047-1.094 5.88-5.878 1.092-2.05-9.02zm69.725 0l-2.047 9.02-5.88-1.093-1.092-5.878 9.02-2.05zM74.535 67.27l7.303 1.66 5.217 9.033c-.872-1.046-1.694-1.816-2.477-2.365-1.516-1.064-2.895-1.33-4.17-1.334-1.275-.004-2.446.243-3.597.205-1.098-.038-2.182-.326-3.367-1.327l1.092-5.873zm50.932 0l1.092 5.875c-1.186 1-2.27 1.287-3.37 1.324-1.15.037-2.323-.208-3.598-.204-1.276.003-2.652.268-4.168 1.332-.783.55-1.606 1.32-2.48 2.365l5.216-9.033 7.307-1.66zm-52.322 6.173c1 1.185 1.287 2.267 1.324 3.366.037 1.15-.208 2.323-.204 3.598.003 1.275.268 2.652 1.332 4.168.55.783 1.32 1.606 2.365 2.48l-9.035-5.216-1.657-7.307 5.875-1.09zm53.712.002l5.873 1.09-1.66 7.303-9.033 5.217c1.046-.872 1.816-1.694 2.365-2.477 1.064-1.516 1.33-2.895 1.334-4.17.003-1.275-.243-2.446-.205-3.597.04-1.098.326-2.18 1.327-3.365zm-52.79.62c.936.563 1.84.76 2.728.79 1.213.04 2.39-.208 3.613-.205 1.224.004 2.496.246 3.947 1.264 1.444 1.012 3.063 2.807 4.926 5.912.056.635-.12 1.15-.362 1.678-.25.55-.57 1.113-.7 1.808-.128.696-.058 1.52.434 2.567.3.64.785 1.38 1.452 2.224-.844-.667-1.585-1.15-2.225-1.452-.525-.246-.993-.384-1.417-.447-.424-.063-.805-.05-1.152.014-.695.127-1.256.445-1.806.696-.528.24-1.04.42-1.674.367-3.106-1.864-4.903-3.486-5.916-4.93-1.018-1.45-1.258-2.723-1.262-3.947-.003-1.224.244-2.4.203-3.613-.03-.886-.227-1.79-.79-2.727zm51.867 0c-.562.938-.76 1.843-.79 2.73-.04 1.213.21 2.39.206 3.613-.003 1.224-.246 2.496-1.264 3.947-1.012 1.444-2.807 3.065-5.912 4.928-.635.055-1.15-.123-1.678-.365-.55-.25-1.113-.57-1.808-.7-.348-.064-.727-.076-1.15-.013-.425.063-.893.2-1.417.447-.64.3-1.38.785-2.224 1.452.667-.844 1.15-1.585 1.452-2.225.492-1.048.562-1.872.433-2.567-.127-.696-.445-1.26-.696-1.81-.242-.527-.42-1.04-.367-1.673 1.864-3.106 3.486-4.9 4.93-5.914 1.45-1.018 2.723-1.26 3.947-1.264 1.224-.003 2.398.244 3.61.203.887-.03 1.794-.227 2.73-.79zm-59.043.542l1.64 7.223-7.075 2.193-2.79-7.886 8.226-1.53zm66.22 0l8.222 1.53-2.787 7.886-7.074-2.193 1.64-7.223zm-76.16.77l1.302.752 2.832 8.005L52.16 86.9c1.113-4.075 2.735-7.938 4.79-11.523zm86.1 0c2.056 3.585 3.677 7.45 4.79 11.525l-8.924-2.765 2.832-8.008 1.303-.753zM100 79.152c.305.56.703.986 1.15 1.305.51.362 1.03.673 1.446 1.158.414.486.732 1.147.824 2.244.092 1.094-.048 2.62-.568 4.794-.158-.03-.32-.05-.487-.05-1.09 0-2.012.7-2.365 1.67-.353-.97-1.277-1.67-2.367-1.67-.166 0-.327.02-.485.05-.52-2.175-.66-3.7-.568-4.795.092-1.098.41-1.76.824-2.245.415-.485.937-.796 1.446-1.158.447-.32.845-.746 1.15-1.305zm-10.422 2.795c.543.33 1.098.5 1.645.55.62.06 1.228.07 1.83.284.602.215 1.21.627 1.84 1.53.627.903 1.27 2.296 1.908 4.446-.98.346-1.693 1.274-1.693 2.373 0 .163.02.324.05.48-.12-.104-.25-.198-.393-.28-.952-.55-2.11-.4-2.9.275-1.543-1.627-2.43-2.88-2.9-3.875-.468-.996-.52-1.727-.403-2.355.117-.628.41-1.16.67-1.727.23-.5.363-1.065.348-1.7zm20.846 0c-.016.636.115 1.202.344 1.7.26.57.557 1.1.673 1.728.118.628.063 1.36-.405 2.355-.468.996-1.357 2.25-2.9 3.877-.79-.677-1.95-.827-2.9-.277-.143.082-.272.176-.39.28.03-.156.048-.317.048-.48 0-1.1-.71-2.028-1.692-2.374.64-2.15 1.28-3.543 1.907-4.445.63-.903 1.238-1.315 1.84-1.53.602-.212 1.21-.223 1.83-.282.547-.052 1.104-.22 1.647-.55zm-41.688.225l9.035 5.217c-1.277-.47-2.374-.728-3.327-.812-1.844-.163-3.173.297-4.28.932-1.105.635-1.994 1.432-3.01 1.974-.97.518-2.054.81-3.58.536l-1.99-5.63 7.153-2.218zm62.528 0l7.154 2.22-1.99 5.63c-1.527.275-2.608-.018-3.578-.536-1.017-.542-1.91-1.34-3.016-1.976-1.106-.635-2.43-1.093-4.275-.93-.954.084-2.053.34-3.33.81l9.034-5.218zm-70.053 2.33l1.995 5.64-4.545 3.883-6.283-6.787 8.834-2.736zm77.58.002l8.833 2.736-6.283 6.787-4.545-3.884 1.994-5.64zM73.77 86.93c.204.002.415.013.636.033 1.757.155 4.06.9 7.227 2.658.364.523.466 1.057.52 1.636.058.602.065 1.247.302 1.914.237.667.708 1.345 1.658 2.006.58.404 1.37.807 2.37 1.205-1.065-.155-1.95-.205-2.655-.146-1.153.098-1.9.45-2.437.91-.538.458-.866 1.012-1.216 1.504-.337.474-.693.887-1.268 1.157-3.622-.062-5.99-.57-7.588-1.313-1.607-.748-2.453-1.73-3.068-2.787-.615-1.058-.987-2.2-1.63-3.23-.467-.752-1.092-1.438-2.044-1.967 1.09.017 1.974-.263 2.756-.68 1.07-.57 1.964-1.377 3.025-1.986.93-.533 1.98-.927 3.413-.912zm52.46.002c1.432-.015 2.484.38 3.413.912 1.06.61 1.956 1.415 3.027 1.986.782.417 1.662.697 2.752.68-.952.53-1.577 1.215-2.045 1.967-.642 1.03-1.012 2.172-1.627 3.23-.615 1.058-1.46 2.04-3.068 2.787-1.6.744-3.965 1.25-7.586 1.313-.577-.27-.933-.685-1.27-1.16-.35-.49-.68-1.045-1.22-1.504-.537-.46-1.28-.812-2.434-.91-.705-.058-1.59-.008-2.654.148 1-.397 1.788-.8 2.37-1.204.95-.66 1.42-1.34 1.657-2.006.236-.667.243-1.312.3-1.914.056-.578.157-1.112.52-1.633 3.168-1.758 5.47-2.503 7.227-2.658.22-.02.434-.03.638-.033zm-74.216.484l6.35 6.863-6.456 5.52h-1.502c.017-4.277.573-8.427 1.608-12.384zm95.972.002c1.035 3.957 1.59 8.106 1.608 12.383h-1.504l-6.455-5.52 6.35-6.862zm-62.117 1.09c.517-.012 1.113.107 1.86.46.994.466 2.246 1.35 3.87 2.89-.106.12-.202.25-.286.396-.545.944-.4 2.092.262 2.883-1.016-.18-2.08.27-2.627 1.215-.084.144-.152.293-.204.445-2.144-.637-3.534-1.278-4.435-1.904-.903-.63-1.315-1.238-1.53-1.84-.212-.602-.223-1.207-.282-1.828-.052-.548-.22-1.106-.55-1.65.635.016 1.2-.114 1.7-.343.568-.26 1.1-.557 1.727-.673.157-.03.322-.048.494-.052zm28.26.002c.173.004.338.022.495.05.628.117 1.16.413 1.727.672.5.23 1.065.36 1.7.346-.33.543-.498 1.1-.55 1.647-.06.62-.07 1.228-.283 1.83-.215.602-.627 1.21-1.53 1.838-.902.626-2.294 1.267-4.438 1.904-.052-.152-.118-.3-.2-.445-.546-.945-1.612-1.395-2.628-1.215.663-.79.807-1.94.262-2.883-.083-.144-.178-.274-.284-.395 1.624-1.538 2.874-2.426 3.868-2.893.747-.352 1.344-.47 1.86-.457zm-16.497.414c1.22 0 2.207.984 2.207 2.205 0 1.22-.987 2.206-2.207 2.206-1.22 0-2.205-.987-2.205-2.207 0-1.222.984-2.206 2.205-2.206zm4.732 0c1.22 0 2.207.984 2.207 2.205 0 1.22-.986 2.206-2.207 2.206-1.22 0-2.207-.987-2.207-2.207 0-1.222.987-2.206 2.207-2.206zm-38.902 1.504c1.46.525 2.25 1.32 2.83 2.252.61.977.983 2.118 1.623 3.22.64 1.103 1.56 2.162 3.24 2.944.868.403 1.946.732 3.287.965h-10.43l-5.09-5.5 4.54-3.882zm73.074.002l4.54 3.882-5.087 5.497h-10.433c1.34-.234 2.42-.56 3.287-.964 1.68-.782 2.6-1.84 3.24-2.944.64-1.102 1.012-2.243 1.62-3.22.582-.933 1.374-1.727 2.833-2.252zm-43.19.884c.424-.03.86.063 1.257.29 1.057.612 1.416 1.956.806 3.013-.61 1.057-1.956 1.42-3.014.81-1.057-.61-1.416-1.958-.806-3.015.38-.66 1.05-1.048 1.758-1.098zm13.305 0c.707.05 1.375.437 1.756 1.098.61 1.057.25 2.405-.806 3.016-1.057.61-2.402.246-3.012-.81-.61-1.058-.252-2.402.805-3.013.396-.228.834-.32 1.257-.29zm-6.652.674c.353.97 1.275 1.668 2.365 1.668.643 0 1.224-.25 1.67-.646-.12.584-.044 1.213.278 1.77.545.944 1.61 1.394 2.626 1.214-.665.79-.808 1.938-.262 2.883.32.556.826.935 1.392 1.123-.566.188-1.07.567-1.392 1.123-.546.945-.403 2.094.26 2.885-1.015-.18-2.08.268-2.626 1.213-.32.557-.397 1.186-.277 1.77-.446-.396-1.025-.646-1.668-.646-1.09 0-2.014.698-2.367 1.668-.353-.97-1.275-1.668-2.365-1.668-.643 0-1.224.25-1.67.646.12-.584.044-1.213-.278-1.77-.545-.944-1.61-1.392-2.626-1.212.665-.79.808-1.94.262-2.885-.32-.556-.827-.935-1.392-1.123.565-.188 1.07-.567 1.392-1.123.546-.945.403-2.092-.26-2.883 1.015.18 2.08-.27 2.626-1.215.32-.557.397-1.186.277-1.77.446.396 1.025.646 1.668.646 1.09 0 2.014-.698 2.367-1.668zm-41.37 2.575L63.66 100l-5.03 5.436L52.272 100l6.356-5.438zm82.74 0l6.357 5.437-6.356 5.438L136.34 100l5.033-5.436zm-50.388.85c.424-.03.86.06 1.256.29 1.057.61 1.417 1.96.807 3.016s-1.955 1.416-3.012.805c-1.057-.61-1.42-1.956-.808-3.013.38-.66 1.05-1.05 1.757-1.1zm18.036 0c.706.05 1.376.438 1.757 1.1.61 1.056.25 2.402-.808 3.012-1.057.61-2.404.25-3.014-.806-.61-1.058-.25-2.407.807-3.017.396-.23.834-.32 1.258-.29zm-24.252 1.142c.994.025 2.263.204 3.898.595-.19 1.024.255 2.1 1.207 2.65.144.083.292.148.442.2-.15.052-.298.12-.44.2-.953.55-1.4 1.626-1.208 2.65-2.18.522-3.71.664-4.807.572-1.097-.092-1.756-.412-2.242-.826-.485-.415-.796-.937-1.158-1.446-.32-.447-.746-.845-1.305-1.15.56-.305.986-.703 1.305-1.15.362-.51.673-1.03 1.158-1.444.486-.414 1.145-.734 2.242-.826.275-.023.577-.034.91-.025zm30.468 0c.332-.01.632.002.907.025 1.098.092 1.76.412 2.245.826.486.415.796.937 1.158 1.446.32.447.746.843 1.305 1.148-.56.305-.986.705-1.305 1.152-.362.51-.672 1.03-1.158 1.444-.486.414-1.147.733-2.244.826-1.095.092-2.624-.05-4.804-.572.19-1.024-.257-2.1-1.21-2.65-.142-.08-.288-.148-.44-.2.152-.052.298-.117.44-.2.953-.55 1.4-1.626 1.21-2.65 1.635-.39 2.904-.57 3.898-.595zm-23.945 3.63c.705.05 1.374.436 1.755 1.096.61 1.058.25 2.407-.807 3.017-1.057.61-2.403.248-3.013-.81-.61-1.056-.25-2.402.808-3.012.397-.23.832-.32 1.256-.29zm17.42 0c.425-.03.86.06 1.257.29 1.057.61 1.42 1.956.808 3.013-.61 1.057-1.958 1.42-3.015.81-1.057-.61-1.417-1.96-.807-3.017.38-.66 1.052-1.045 1.758-1.094zm-44.7.008h10.433c-1.34.233-2.42.56-3.287.963-1.68.782-2.6 1.84-3.24 2.944-.64 1.102-1.014 2.24-1.623 3.218-.58.933-1.37 1.727-2.83 2.252l-4.54-3.88 5.087-5.497zm61.547 0h10.43l5.09 5.498-4.54 3.882c-1.46-.525-2.25-1.32-2.832-2.252-.61-.977-.98-2.116-1.62-3.218-.642-1.103-1.562-2.162-3.24-2.944-.87-.403-1.947-.732-3.288-.965zm-46.653.002c.577.27.933.683 1.27 1.157.35.492.678 1.046 1.217 1.505.54.46 1.285.812 2.438.91.705.057 1.59.01 2.654-.146-1 .4-1.788.802-2.37 1.206-.95.66-1.42 1.337-1.657 2.004-.236.667-.243 1.314-.3 1.916-.056.578-.157 1.11-.52 1.63-3.168 1.76-5.472 2.506-7.23 2.66-1.765.157-2.986-.27-4.048-.88-1.06-.61-1.956-1.41-3.027-1.982-.783-.418-1.664-.698-2.756-.68.954-.53 1.578-1.218 2.047-1.97.643-1.03 1.015-2.17 1.63-3.23.615-1.057 1.46-2.04 3.068-2.788 1.6-.744 3.965-1.25 7.586-1.31zm42.19.002c3.622.06 5.99.57 7.588 1.313 1.607.748 2.453 1.73 3.068 2.787.615 1.058.985 2.198 1.627 3.228.468.752 1.093 1.44 2.045 1.97-1.09-.02-1.972.262-2.754.68-1.07.57-1.964 1.374-3.025 1.983-1.062.61-2.285 1.035-4.05.88-1.758-.156-4.06-.9-7.226-2.66-.364-.52-.466-1.053-.52-1.632-.058-.602-.065-1.25-.302-1.916-.237-.667-.708-1.343-1.658-2.004-.58-.404-1.37-.807-2.37-1.205 1.065.157 1.95.205 2.655.146 1.153-.097 1.897-.45 2.435-.91.54-.458.87-1.012 1.22-1.504.336-.474.692-.885 1.267-1.155zm-70.688.002h1.504l6.455 5.52-6.35 6.862c-1.036-3.957-1.592-8.106-1.61-12.383zm97.686 0h1.502c-.017 4.277-.573 8.427-1.608 12.384l-6.35-6.863 6.456-5.52zm-59.346 3.005c.052.152.12.3.203.445.545.945 1.61 1.395 2.626 1.215-.663.79-.807 1.937-.262 2.88.083.145.178.277.284.398-1.624 1.537-2.874 2.425-3.868 2.892-.996.47-1.727.523-2.355.406-.628-.115-1.16-.41-1.727-.67-.5-.23-1.065-.36-1.7-.346.33-.543.498-1.1.55-1.647.06-.62.07-1.228.283-1.83.215-.602.627-1.21 1.53-1.838.902-.627 2.292-1.268 4.436-1.905zm22.506 0c2.144.637 3.536 1.278 4.437 1.904.903.628 1.315 1.235 1.53 1.837.212.602.223 1.21.282 1.83.052.547.22 1.106.55 1.65-.635-.017-1.2.114-1.7.343-.568.26-1.1.557-1.727.673-.628.116-1.36.06-2.355-.408-.994-.467-2.246-1.352-3.87-2.89.106-.122.202-.254.286-.4.545-.943.4-2.09-.262-2.88 1.016.18 2.082-.27 2.627-1.215.084-.144.15-.293.202-.445zm-17.596 1.078c.706.05 1.373.44 1.754 1.1.61 1.057.25 2.4-.806 3.012-1.058.61-2.404.25-3.014-.807-.61-1.057-.25-2.405.806-3.016.397-.23.837-.32 1.26-.29zm12.688 0c.423-.03.86.06 1.258.29 1.057.61 1.416 1.958.806 3.015-.61 1.057-1.956 1.417-3.013.807s-1.415-1.955-.805-3.012c.38-.66 1.048-1.05 1.754-1.1zm-47.684 1.69l4.545 3.886-1.994 5.638-8.833-2.736 6.283-6.79zm82.68.002l6.283 6.79-8.834 2.735-1.995-5.64 4.545-3.885zm-43.705.69c1.22 0 2.207.986 2.207 2.206 0 1.222-.987 2.206-2.207 2.206-1.22 0-2.207-.984-2.207-2.205 0-1.22.986-2.204 2.207-2.204zm4.732 0c1.22 0 2.205.986 2.205 2.206 0 1.222-.984 2.206-2.205 2.206-1.22 0-2.207-.984-2.207-2.205 0-1.22.987-2.204 2.207-2.204zm-7.21 1.726c-.03.156-.05.317-.05.48 0 1.1.712 2.028 1.694 2.374-.637 2.15-1.28 3.545-1.907 4.447-.63.905-1.238 1.317-1.84 1.53-.602.214-1.21.225-1.83.284-.547.052-1.104.22-1.647.55.015-.635-.117-1.203-.346-1.702-.26-.568-.555-1.1-.67-1.727-.118-.628-.064-1.36.405-2.355.468-.996 1.355-2.25 2.898-3.877.79.677 1.95.83 2.9.28.143-.083.274-.18.393-.282zm9.687 0c.12.104.248.2.39.282.952.55 2.11.4 2.9-.277 1.543 1.627 2.433 2.88 2.9 3.875.47.996.522 1.727.405 2.355-.117.628-.413 1.16-.672 1.727-.23.5-.36 1.067-.346 1.703-.543-.33-1.098-.5-1.645-.55-.62-.06-1.228-.07-1.83-.284-.602-.213-1.21-.625-1.84-1.53-.627-.9-1.27-2.296-1.908-4.446.98-.346 1.693-1.274 1.693-2.373 0-.163-.02-.324-.05-.48zM100 109.73c.353.968 1.277 1.666 2.367 1.666.166 0 .327-.018.485-.048.52 2.175.66 3.7.568 4.795-.092 1.097-.41 1.756-.824 2.242-.415.485-.937.798-1.446 1.16-.447.32-.845.746-1.15 1.305-.305-.56-.705-.986-1.152-1.305-.51-.362-1.03-.675-1.444-1.16-.414-.486-.732-1.145-.824-2.242-.092-1.095.048-2.62.568-4.795.158.03.32.048.487.048 1.09 0 2.012-.698 2.365-1.667zm-35.36.145c.992-.01 1.783.253 2.51.64 1.017.543 1.908 1.342 3.014 1.977 1.106.635 2.433 1.093 4.277.93.954-.084 2.053-.34 3.33-.81l-9.034 5.218-7.154-2.22 1.99-5.63c.382-.068.736-.102 1.067-.105zm70.72.002c.333.003.686.037 1.068.105l1.99 5.63-7.154 2.218-9.035-5.217c1.277.47 2.374.727 3.327.81 1.844.164 3.17-.296 4.277-.93 1.106-.636 1.997-1.433 3.014-1.975.727-.39 1.52-.65 2.513-.64zm-45.256.02c-.667.845-1.15 1.586-1.452 2.226-.492 1.047-.562 1.87-.433 2.566.127.695.445 1.258.696 1.808.24.528.42 1.04.365 1.674-1.863 3.106-3.483 4.903-4.926 5.916-1.452 1.018-2.724 1.258-3.948 1.262-1.224.003-2.4-.244-3.613-.204-.886.03-1.79.226-2.727.788.562-.936.76-1.84.79-2.727.04-1.213-.21-2.39-.206-3.613.004-1.224.244-2.494 1.262-3.946 1.013-1.443 2.81-3.066 5.914-4.93.635-.054 1.15.124 1.678.366.55.25 1.11.57 1.807.7.696.128 1.522.057 2.57-.434.64-.3 1.38-.785 2.224-1.452zm19.792 0c.844.668 1.585 1.152 2.225 1.453 1.048.492 1.872.562 2.567.433.696-.13 1.26-.446 1.81-.697.527-.242 1.04-.42 1.673-.367 3.106 1.863 4.903 3.485 5.916 4.928 1.018 1.452 1.258 2.724 1.262 3.948.003 1.223-.244 2.398-.203 3.61.03.887.225 1.793.785 2.728-.935-.56-1.84-.758-2.725-.788-1.213-.04-2.39.21-3.613.206-1.224-.003-2.494-.246-3.946-1.264-1.443-1.013-3.066-2.807-4.93-5.912-.054-.635.124-1.15.366-1.678.25-.55.57-1.113.7-1.81.128-.694.057-1.518-.434-2.565-.3-.64-.785-1.38-1.452-2.225zm-31.933 3.05c-1.046.872-1.816 1.694-2.365 2.477-1.064 1.516-1.33 2.894-1.334 4.17-.004 1.275.243 2.446.205 3.597-.038 1.1-.326 2.184-1.327 3.37l-5.873-1.093 1.658-7.303 9.035-5.217zm44.074 0l9.033 5.215 1.66 7.307-5.875 1.09c-1-1.186-1.287-2.268-1.324-3.367-.038-1.15.208-2.324.204-3.6-.003-1.275-.268-2.65-1.332-4.167-.55-.783-1.32-1.606-2.365-2.48zm-69.877.15l8.924 2.766-2.832 8.008-1.303.753c-2.056-3.585-3.677-7.45-4.79-11.525zm95.68.003c-1.113 4.075-2.735 7.938-4.79 11.523l-1.306-.754-2.828-8.007 8.924-2.763zm-51.46.42c-.157 1.064-.205 1.95-.146 2.654.098 1.153.45 1.897.91 2.435.458.538 1.012.868 1.504 1.218.474.337.887.693 1.157 1.268-.062 3.622-.57 5.99-1.313 7.588-.748 1.607-1.73 2.453-2.787 3.068-1.058.615-2.2.987-3.23 1.63-.752.467-1.438 1.09-1.967 2.042.017-1.09-.265-1.972-.682-2.754-.57-1.07-1.375-1.964-1.984-3.025-.61-1.062-1.035-2.287-.88-4.053.156-1.757.9-4.056 2.66-7.223.52-.365 1.055-.467 1.634-.522.602-.057 1.247-.064 1.914-.3.667-.238 1.345-.71 2.006-1.66.404-.58.805-1.37 1.203-2.368zm7.24 0c.4 1 .8 1.788 1.204 2.37.66.95 1.34 1.42 2.006 1.657.667.236 1.312.243 1.914.3.578.055 1.112.157 1.633.52 1.758 3.168 2.503 5.47 2.658 7.227.156 1.766-.27 2.99-.88 4.05-.608 1.062-1.41 1.957-1.98 3.028-.42.783-.7 1.664-.683 2.756-.53-.955-1.216-1.578-1.97-2.047-1.03-.64-2.17-1.013-3.23-1.628-1.057-.615-2.038-1.46-2.786-3.068-.744-1.6-1.25-3.965-1.313-7.586.27-.577.685-.933 1.16-1.27.49-.35 1.045-.68 1.504-1.22.46-.537.81-1.28.91-2.434.057-.705.01-1.59-.146-2.654zm-42.165 2.46l7.074 2.192-1.64 7.223-8.224-1.528 2.79-7.888zm77.09 0l2.787 7.887-8.223 1.528-1.64-7.223 7.075-2.193zm-51.49 6.06l-5.215 9.032-7.307 1.658-1.092-5.873c1.186-1 2.27-1.287 3.37-1.324 1.15-.04 2.323.207 3.598.203 1.275-.003 2.652-.268 4.168-1.332.783-.55 1.606-1.32 2.48-2.365zm25.89 0c.872 1.045 1.694 1.815 2.477 2.364 1.516 1.064 2.894 1.33 4.17 1.334 1.275.003 2.446-.243 3.597-.205 1.098.038 2.182.325 3.367 1.326l-1.092 5.872-7.303-1.66-5.217-9.033zm-25.556.19c-.47 1.28-.728 2.376-.812 3.33-.163 1.843.297 3.17.932 4.276.635 1.106 1.432 1.997 1.974 3.014.518.97.81 2.053.536 3.58l-5.63 1.99-2.218-7.154 5.217-9.036zm25.22 0l5.218 9.036-2.22 7.154-5.63-1.99c-.275-1.527.02-2.608.536-3.578.542-1.017 1.34-1.91 1.976-3.016.635-1.106 1.093-2.43.93-4.275-.084-.952-.34-2.05-.81-3.33zm-54.157 1.99l8.35 1.55-2.067 9.103c-2.925-2.958-5.474-6.286-7.586-9.902l1.303-.75zm83.094 0l1.303.75c-2.112 3.617-4.662 6.946-7.588 9.905l-2.067-9.104 8.352-1.55zm-41.738 1.34v10.43l-5.5 5.088-3.882-4.54c.525-1.458 1.32-2.25 2.252-2.83.977-.61 2.116-.982 3.218-1.622 1.103-.64 2.162-1.56 2.944-3.24.403-.868.734-1.946.967-3.287zm.38 0c.234 1.34.56 2.418.964 3.286.782 1.68 1.843 2.6 2.946 3.24 1.102.64 2.24 1.012 3.218 1.62.933.582 1.727 1.374 2.252 2.833l-3.882 4.538-5.497-5.086V125.56zm-33.006.284l5.88 1.092 1.092 5.88-9.02 2.05 2.048-9.022zm65.63.002l2.05 9.02-9.022-2.048 1.092-5.88 5.88-1.092zm-50.984 5.627l2.19 7.074-7.883 2.787-1.53-8.223 7.223-1.637zm36.34 0l7.223 1.638-1.528 8.224-7.888-2.787 2.193-7.074zm-43.94 1.722l1.55 8.352-.75 1.303c-3.617-2.112-6.945-4.662-9.903-7.588l9.102-2.067zm51.54.002l9.103 2.067c-2.958 2.925-6.286 5.474-9.902 7.586l-.75-1.303 1.55-8.35zM100 136.34l5.436 5.033L100 147.73l-5.438-6.357L100 136.34zm-9.86.457l3.885 4.545-6.787 6.283-2.738-8.834 5.64-1.993zm19.717 0l5.64 1.994-2.737 8.835-6.787-6.283 3.884-4.545zm-25.722 2.12l2.765 8.923c-4.075-1.113-7.938-2.735-11.523-4.79l.754-1.306 8.005-2.828zm31.728 0l8.008 2.83.753 1.304c-3.585 2.056-7.45 3.677-11.525 4.79l2.765-8.924zm-21.586 2.718l5.524 6.457v1.502c-4.277-.017-8.427-.573-12.384-1.608l6.86-6.35zm11.442 0l6.862 6.35c-3.957 1.036-8.106 1.592-12.383 1.61v-1.505l5.52-6.455z" fill="#fff800"/></g></g>'+
               
        '<circle id="secOuterRing" cx="100" cy="62" r="25" fill="'+dialColour+'" stroke="'+markColour+'" stroke-width="0.5"/>'+
        '<circle id="secInnerRing" cx="100" cy="62" r="22" fill="none" stroke="'+markColour+'" stroke-width="0.5"/>'+
        '</svg>';
    dial.innerHTML = face;

    for (var i = 0; i < 60; i++) {
        var mrkrLength = 6;
        var mrkrWidth = (i % 5) ? 0.5 : 3;

        var secmrkrWidth = (i % 5) ? 0.5 : 0.8;
        var secmrkrLength = 44;
        if (i % 10) {
            secmrkrLength = 42;
        }
        if (i % 5) { 
            secmrkrLength = 40;
        }

        /* Outer ticks  */
        var ot = document.createElementNS("http://www.w3.org/2000/svg", "line");
        with(ot) {
            if (i % 5) {
                setAttribute('x1', '100');
                setAttribute('y1', '1');
                setAttribute('x2', '100');
                setAttribute('y2', '6.0');
                setAttribute('stroke', markColour);
                setAttribute('stroke-width', '0.5');

                setAttribute('stroke-linecap', 'butt');
                setAttribute("transform","rotate("+i * 6+", 100, 100)"); 
            }
        } 
        d.getElementById('sfc'+idx).appendChild(ot);


        /* Ticks for seconds dial */
        var sec = document.createElementNS("http://www.w3.org/2000/svg", 'line');
        with(sec) {
            setAttribute('x1', '100');
            setAttribute('y1', '37');
            setAttribute('x2', '100');
            setAttribute('y2', secmrkrLength);
            setAttribute('stroke', markColour);
            setAttribute('stroke-width', secmrkrWidth);
            setAttribute('stroke-linecap', 'butt');
            setAttribute('clip-path', 'url(#dialPath)');
            setAttribute( 'transform','rotate('+i * 6+', 100, 62)');
        }
        d.getElementById('sfc'+idx).appendChild(sec);
    }//End loop

    /* Digits for seconds dial */
    for (var i = 0; i < 6; i++) {
        var tos = (i == 0)? 0 : 60;
        var nms = parseInt(60 + ((i*10)-tos));
        mdgts[i] = d.createElement('div');
        mdgts[i].setAttribute('style', 'display: block;'
            +'position: absolute;'
            +'width: '+xy(5)+'px;'
            +'height: '+xy(5)+'px;'
            +'margin: auto;top: 0;bottom: 0; left: 0;right: 0;'
            +'font: bold '+xy(2.7)+'px times;color:'+markColour+';line-height:'+xy(5)+'px;letter-spacing:'+xy(0.09)+'px;text-align:center;'
            +'border-radius:50%;');
        mdgts[i].innerHTML = nms;
        dial.appendChild(mdgts[i]);
        secOffset += 60;
        mdgts[i].style.top = xy(-38.0) + xy(14.5) * Math.sin(-(90 * radi) + (360/6) * i * radi) + 'px';
        mdgts[i].style.left= xy(0) + xy(14.5) * Math.cos(-(90 * radi) + (360/6) * i * radi) + 'px';
        mdgts[i].style.transform = 'rotate(' + (secOffset) + 'deg)';
        mdgts[i].style.transformOrigin = 'center center';
    }

    /* Main digits  */
    for (var i = 0; i < 12; i++) {
        svgNums = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" width="100%" height="100%" fill="'+markColour+'"> '+ numerals[i] +'</svg>';
        dgts[i] = d.createElement('div');
        dgts[i].setAttribute('style', 'display: block;'
            +'position: absolute;'
            +'width: '+xy(16)+'px;'
            +'height: '+xy(16)+'px;'
            +'padding:0;margin: auto;top: 0;bottom: 0; left: 0;right: 0;');
        dgts[i].innerHTML = svgNums;
        dial.appendChild(dgts[i]);
        degr += 30;
        dgts[i].style.top = xy(0) + xy(81.5) * Math.sin(-(60 * radi) + (360/12) * i * radi) + 'px';
        dgts[i].style.left= xy(0) + xy(81.5) * Math.cos(-(60 * radi) + (360/12) * i * radi) + 'px';
        dgts[i].style.transform = 'rotate(' + (degr) + 'deg)';
        dgts[i].style.transformOrigin = 'center center';

        /* Outer triangle markers */
        var hdt = document.createElementNS ("http://www.w3.org/2000/svg", "path");
        with(hdt) {
            setAttribute("fill", markColour);
            setAttribute("stroke", "none");
            setAttribute("d", "m 100,6 4,-5 -8,0 z");
            setAttribute("transform","rotate("+i * 30+", 100, 100)"); 
        }
        d.getElementById('sfc'+idx).appendChild(hdt);
    }

    /* Generic container for all hands */

    var handContainers = 'display: block;'
        +'position: absolute;'
        +'height: '+xy(100)+'px;'
        +'width: '+xy(100)+'px;'
        +'font-size: 0px; line-height: 0px; padding: 0;'
        +'margin: auto; top: 0;bottom: 0; left: 0; right: 0;'
        +'transform-origin: center center;';

    /* Seconds hand */

    var secContainer = d.createElement('div');
    secContainer.setAttribute('style','display: block;'
        +'position: absolute;'
        +'top: '+xy(15.92)+'px;'
        +'height: '+xy(30)+'px;'
        +'width: '+xy(30)+'px;'
        +'margin: auto; left: 0; right: 0;'
        +'transition: .5s cubic-bezier(0.405,0,0.570,1);'
        +'transform-origin: center center;'
        +'z-index: 48;');
    dial.appendChild(secContainer);
    var secHand = d.createElement('div');
    var secsvg =  vb +
    '<g transform="scale(0.30, 0.30)"><path d="M 99.152344 15.466797 L 99.152344 90.724609 A 9.3220339 9.3220339 0 0 0 90.677734 100 A 9.3220339 9.3220339 0 0 0 98.755859 109.22852 L 98.755859 113.85547 C 97.299529 114.05418 95.87482 114.59794 94.59375 115.49414 C 91.30348 117.79592 89.431897 122.3897 89.560547 126.73633 C 89.608447 128.4268 91.463149 128.35251 91.412109 126.66211 C 91.306649 123.09639 93.562952 120.99608 96.044922 119.25977 C 97.291222 118.38789 98.65455 118.18768 100.01758 118.19141 C 101.36901 118.19441 102.71941 118.39532 103.95508 119.25977 C 106.43705 120.99607 108.76179 123.09639 108.65625 126.66211 C 108.60525 128.35249 110.3915 128.42678 110.43945 126.73633 C 110.56808 122.3897 108.69653 117.79592 105.40625 115.49414 C 104.12402 114.59713 102.70089 114.05373 101.24414 113.85547 L 101.24414 109.22656 A 9.3220339 9.3220339 0 0 0 109.32227 100 A 9.3220339 9.3220339 0 0 0 100.84766 90.720703 L 100.84766 15.466797 L 99.152344 15.466797 z " fill="'+handColour+'" "'+dum+'"/></g></svg>';
    secHand.innerHTML = secsvg;
    secContainer.appendChild(secHand);
    var secShad = secContainer.cloneNode(true);
    dial.appendChild(secShad);
    genShadKillClone(secShad,secsvg, 0, 16.5);

    /* Hour hand */

    var houContainer = d.createElement('div');
    houContainer.setAttribute('style', handContainers + 'transition: '+cbcbzr+';'); 
    houContainer.style.zIndex = 50;
    dial.appendChild(houContainer);
    var houHand = d.createElement('div');
    var housvg = vb + '<path d="M102.853 43.52c-.466.316-1.013.472-1.196 1.356.123 8.414 5.54 8.17 8.145 9.994 5.38 3.767 2.628 10.392-5.272 9.46-.297-.034-.587-.104-.882-.15-.295-.046-.596-.067-.914-.004l.2 11.645c.413.573.995.943 1.674 1.197-.436.2-.865.416-1.196.877-.607 3.575 1.1 5.453 3.668 6.7-1.96 1.168-4.25.702-3.987 7.497l.398 20.26c.185 5.86 2.995 6.477 4.15 9.41.45 5.037-5.532 4.577-7.645 7.582-2.113-3.015-8.086-2.545-7.634-7.582 1.155-2.933 3.965-3.55 4.15-9.41l.397-20.26c.262-6.794-2.026-6.328-3.987-7.496 2.567-1.247 4.275-3.125 3.668-6.7-.33-.46-.76-.677-1.196-.877.68-.254 1.26-.624 1.675-1.196l.2-11.644c-.32-.063-.62-.042-.915.004-.295.046-.585.116-.882.15-7.9.93-10.65-5.693-5.272-9.46 2.605-1.824 8.022-1.58 8.145-9.994-.183-.884-.73-1.04-1.196-1.356 1.163-.73 2.02-1.768 2.853-2.87.833 1.102 1.69 2.14 2.853 2.87z" fill-rule="evenodd" fill="'+handColour+'" "'+dum+'"/>';
    houHand.innerHTML = housvg;
    houContainer.appendChild(houHand);
    var houShad = houContainer.cloneNode(true);
    dial.appendChild(houShad);
    genShadKillClone(houShad,housvg, 0, 2);

    /* Minute hand */

    var minContainer = d.createElement('div');
    minContainer.setAttribute('style',handContainers + 'transition: '+cbcbzr+';');
    minContainer.style.zIndex = 52;
    dial.appendChild(minContainer);
    var minHand = d.createElement('div');
    var minsvg =  vb +
    '<path d="M100 0c-.204 0-.407.072-.59.215-.365.285-.59.81-.603 2.148l-1.89 89.79a8.433 8.433 0 0 0-5.35 7.847 8.433 8.433 0 0 0 5.02 7.705l-.15 7.283h.004c-.246 2.86.14 5.875-3.588 7.895l-.717 2.87c3.712.357 6.443 1.475 7.865 3.59 1.423-2.115 4.153-3.233 7.865-3.59l-.717-2.87c-3.73-2.02-3.342-5.034-3.59-7.895h.007l-.155-7.287a8.433 8.433 0 0 0 5.024-7.7 8.433 8.433 0 0 0-5.35-7.84l-1.89-89.767c-.016-1.368-.24-1.893-.604-2.178C100.407.072 100.204 0 100 0z" fill="'+handColour+'" "'+dum+'"/></svg>';
    minHand.innerHTML = minsvg;
    minContainer.appendChild(minHand);
    var minShad = minContainer.cloneNode(true);
    dial.appendChild(minShad);
    genShadKillClone(minShad,minsvg, 0, 3);

    var keyhole1 = d.createElement('div');
    keyhole1.setAttribute('style', 'display: block;'
        +'position: absolute;'
        +'height: '+xy(4)+'px;'
        +'width: '+xy(4)+'px;'
        +'top: '+xy(60.5)+'px;'
        +'left: '+xy(35.5)+'px;' 
        +'border: '+xy(0.1)+'px solid #000;'
        +'border-radius: 50%;'
        +'background-color: #111;'
        +'box-shadow: 0 0 '+xy(0.2)+'px '+xy(0.2)+'px #333, inset 0 -'+xy(0.3)+'px '+xy(0.6)+'px 0 #ccc;'
        +'z-index: 49;');
    dial.appendChild(keyhole1);

    var keyhole2 = keyhole1.cloneNode(true);
    dial.appendChild(keyhole2);
    keyhole2.style.left = xy(60.5) + 'px';

    function Clock() {
        var x = new Date();

        var pressec = x.getSeconds();
        if (pressec !== prevsec) {
            sincr++;
        }
        prevsec = pressec;

        var presmin = x.getMinutes();
        if (presmin !== prevmin) {
            mincr++;
        }
        prevmin = presmin;

        secContainer.style.transform = 'rotate(' + (sincr * 6) + 'deg) translateZ(0)';
         secShad.style.transform = 'rotate(' + (sincr * 6) + 'deg) translateZ(0)';
        minContainer.style.transform = 'rotate(' + (mincr * 6) + 'deg) translateZ(0)';
         minShad.style.transform = 'rotate(' + (mincr * 6) + 'deg) translateZ(0)';
        houContainer.style.transform = 'rotate(' + ((hincr * 30) + (mincr / 2)) + 'deg) translateZ(0)';
         houShad.style.transform = 'rotate(' + ((hincr * 30) + (mincr / 2)) + 'deg) translateZ(0)';

        tmr = setTimeout(Clock, mls);
    }

    window.addEventListener('load', Clock, false);
})();