if (console.clear) {
  console.clear();
}

const BIRDS_COUNT = 50;
const RADIUS = 5;
const SPEED = 5; // in seconds

const $viewport = document.querySelector('.viewport');

const { offsetWidth: width, offsetHeight: height } = $viewport;

const scene = new THREE.Scene();

const renderer = new THREE.WebGLRenderer({
  antialias: true });


renderer.setSize(width, height);
renderer.setClearColor(0xffffff, 1.0);
renderer.setPixelRatio(window.devicePixelRatio || 1);
$viewport.appendChild(renderer.domElement);

const camera = new THREE.PerspectiveCamera(45, width / height, 1, 100);

// HERE
camera.position.z = 15;
camera.position.y = -10;
// HERE

camera.lookAt(new THREE.Vector3(0, 0, 0));

const material = new THREE.RawShaderMaterial({
  vertexShader: `
	precision mediump float;

	mat3 rotateY(float rad) {
		float c = cos(rad);
		float s = sin(rad);
		return mat3(
			c, 0.0, -s,
			0.0, 1.0, 0.0,
			s, 0.0, c
		);
	}

	mat3 rotateZ(float rad) {
			float c = cos(rad);
			float s = sin(rad);
			return mat3(
					c, s, 0.0,
					-s, c, 0.0,
					0.0, 0.0, 1.0
			);
	}

	#define PI 3.14

	float map(float value, float inMin, float inMax, float outMin, float outMax) {
		return outMin + (outMax - outMin) * (value - inMin) / (inMax - inMin);
	}

	attribute vec3 position;
	attribute vec3 highPosition;
	attribute vec2 uv;
	attribute float timeOffset;
	attribute float scale;
	attribute float angle;
	attribute float radius;

	uniform mat4 projectionMatrix;
	uniform mat4 modelViewMatrix;
	uniform float time;

	varying vec2 vUv;

	void main() {
		vUv = uv;

		float totalTime = mod(time + timeOffset, 1.0);

		// float factor = (sin(totalTime) * 2.0) * sin(tan(cos((totalTime) * 0.01) * 1.3) * 2.1);
		float normalizedTime = map(totalTime, 0.0, 1.0, -1.0, 1.0);
		float factor =
			(sin(normalizedTime * 10.0 * PI) * 2.0)
			* sin(tan(cos((normalizedTime * 1.0 * PI)))
		);

		vec3 finalPosition = mix(position, highPosition, factor);
		finalPosition *= scale;
		finalPosition *= rotateZ(-sin(angle + timeOffset) * 0.2);
		finalPosition *= rotateY(2.0 * PI - angle);
		
		float x = radius * sin(angle);
		float y = sin(angle + timeOffset);
		// y = 0.0;
		float z = radius * cos(angle);

		finalPosition += vec3(x, y, z);

		gl_Position = projectionMatrix * modelViewMatrix * vec4(finalPosition, 1.0);
	}
	`,
  fragmentShader: `
	precision mediump float;

	varying vec2 vUv;

	uniform sampler2D diffuse;

	void main() {
		gl_FragColor = texture2D(diffuse, vUv);
	}
	`,
  uniforms: {
    time: {
      type: 'f',
      value: 0 },

    diffuse: {
      type: 't',
      value: null } },


  side: THREE.DoubleSide,
  transparent: true,
  depthTest: false });


const image = document.createElement('img');

image.addEventListener('load', () => {
  const texture = new THREE.Texture(image);
  texture.minFilter = texture.magFilter = THREE.LinearFilter;
  texture.generateMipmaps = false;
  texture.needsUpdate = true;
  material.uniforms.diffuse.value = texture;
});

image.crossOrigin = 'anonymous';
image.src = 'img/Diffuse.001.png';

const geometry = new THREE.InstancedBufferGeometry();

const basePositions = new Float32Array([
0.0895063, -0.0185687, 0.0709558, -0.0727707, -0.0794421, 3.47253e-09, 0.0912849, -0.0519555, 2.27105e-09, -0.0727707, 0.084598, -3.69789e-09, 0.0750339, 0.0887785, 0.0619846, 0.0542565, 0.0919133, -4.01766e-09, 0.129246, 0.0664866, 0.0546474, 0.0997983, 0.0963658, -4.21228e-09, -0.0467212, 0.014974, 0.0802083, -0.0674604, -0.0498929, 0.0802083, 0.107452, 0.0356424, 0.0777734, 0.134194, 0.0064688, 0.0546474, 0.150436, 0.0809997, 0.0417724, 0.151735, 0.119531, -5.22487e-09, 0.160156, 0.0395288, 0.0360384, 0.134194, -0.0230804, 1.00888e-09, 0.150436, 0.0809997, 0.0417724, 0.219558, 0.105317, -4.60354e-09, 0.151735, 0.119531, -5.22487e-09, 0.160156, 0.0395288, 0.0360384, 0.191972, 0.0795657, 0.0472161, 0.206117, 0.015499, -6.77485e-10, 0.194939, 0.0349201, 0.0397858, 0.254891, 0.0731465, -3.19733e-09, 0.22886, 0.0635111, 0.018125, 0.311872, 0.0430828, -1.88321e-09, 0.251397, 0.0474041, -2.0721e-09, -0.174415, -0.0126411, 0.0542961, -0.207226, 0.00679739, 0.0308756, -0.169294, -0.0303536, 0.0497064, -0.040306, 0.06624, 0.0721547, -0.164409, -0.0528347, 2.30948e-09, -0.218021, 0.0135101, -5.90547e-10, -0.040306, 0.06624, 0.0721547, 0.0626402, 0.095545, 0.211644, 0.0750339, 0.0887785, 0.0619846, -0.0467212, 0.014974, 0.0802083, 0.00542577, 0.0834842, 0.238884, 0.107452, 0.0356424, 0.0777734, 0.0831033, 0.0862359, 0.212608, -0.0467212, 0.014974, 0.0802083, 0.0831033, 0.0862359, 0.212608, -0.0157337, 0.0709532, 0.24046, 0.0586132, 0.116195, 0.41038, -0.0157337, 0.0709532, 0.24046, -0.152323, 0.0952852, 0.410337, -0.0126231, 0.110429, 0.410337, -0.0157337, 0.0709532, 0.24046, -0.0126231, 0.110429, 0.410337, 0.0586132, 0.116195, 0.41038, -0.0126231, 0.110429, 0.410337, -0.0467212, 0.014974, 0.0802083, -0.191073, 0.0437618, 0.24046, -0.0126231, 0.116613, 0.479695, 0.0469384, 0.120983, 0.460252, 0.0586132, 0.116195, 0.41038, -0.207226, 0.00679739, 0.0308756, -0.382857, -0.00807613, 3.53019e-10, -0.366605, -0.0188572, 0.0619692, -0.174415, -0.0126411, 0.0542961, -0.0727707, -0.0794421, 3.47253e-09, 0.0895063, -0.0185687, -0.0709558, 0.0912849, -0.0519555, 2.27105e-09, 0.0750339, 0.0887785, -0.0619846, 0.129246, 0.0664866, -0.0546474, -0.0467212, 0.0149739, -0.0802083, 0.107452, 0.0356424, -0.0777734, 0.134194, 0.0064688, -0.0546474, 0.150436, 0.0809997, -0.0417724, 0.160156, 0.0395288, -0.0360384, 0.134194, -0.0230804, 1.00888e-09, 0.150436, 0.0809997, -0.0417724, 0.191972, 0.0795657, -0.0472161, 0.160156, 0.0395288, -0.0360384, 0.206117, 0.015499, -6.77485e-10, 0.167394, 0.0099796, -4.36222e-10, 0.22886, 0.0635111, -0.018125, 0.251397, 0.0474041, -2.0721e-09, 0.194939, 0.0349201, -0.0397858, -0.174415, -0.0126411, -0.0542961, -0.169294, -0.0303536, -0.0497064, -0.207226, 0.00679739, -0.0308756, -0.040306, 0.06624, -0.0721547, -0.164409, -0.0528347, 2.30948e-09, 0.0626402, 0.095545, -0.211644, -0.040306, 0.06624, -0.0721547, 0.0750339, 0.0887785, -0.0619846, 0.00542577, 0.0834842, -0.238884, -0.0467212, 0.0149739, -0.0802083, 0.107452, 0.0356424, -0.0777734, -0.0467212, 0.0149739, -0.0802083, 0.0831033, 0.0862359, -0.212608, 0.107452, 0.0356424, -0.0777734, 0.0586132, 0.116195, -0.41038, -0.0157337, 0.0709532, -0.24046, -0.152323, 0.0952852, -0.410337, -0.191073, 0.0437618, -0.24046, -0.0126231, 0.110429, -0.410337, -0.0157337, 0.0709532, -0.24046, 0.0831033, 0.0862359, -0.212608, -0.0157337, 0.0709532, -0.24046, 0.0586132, 0.116195, -0.41038, -0.0467212, 0.0149739, -0.0802083, -0.127924, 0.00162715, -0.0802083, -0.0126231, 0.116613, -0.479695, -0.0603874, 0.110429, -0.500181, -0.0126231, 0.110429, -0.410337, 0.0469384, 0.120983, -0.460252, -0.207226, 0.00679739, -0.0308756, -0.218021, 0.0135101, -5.90547e-10, -0.174415, -0.0126411, -0.0542961, -0.366605, -0.0188572, -0.0619692, -0.0674604, -0.0498929, -0.0802083, 0.167394, 0.0099796, -4.36222e-10, 0.167394, 0.0099796, -4.36222e-10, 0.107452, 0.0356424, 0.0777734, -0.127924, 0.00162716, 0.0802083, -0.0603874, 0.110429, 0.500181, -0.338864, -0.0348399, 0.0968035, 0.167394, 0.0099796, -4.36222e-10, -0.0126231, 0.110429, -0.410337, 0.0586132, 0.116195, -0.41038, -0.338864, -0.0348399, -0.0968035]);


const highPositions = new Float32Array([
0.0871827, -0.012192, 0.0709558, -0.0727707, -0.0728962, 3.1864e-09, 0.087738, -0.0451964, 1.9756e-09, -0.0727707, 0.0909086, -3.97374e-09, 0.0771327, 0.103361, 0.0619846, 0.0554695, 0.101077, -4.4182e-09, 0.130661, 0.0720023, 0.0546474, 0.102898, 0.10364, -4.53024e-09, -0.0467212, 0.0244225, 0.0802083, -0.0674604, -0.0451277, 0.0802083, 0.106685, 0.0437638, 0.0777734, 0.13074, 0.00948083, 0.0546474, 0.153029, 0.082166, 0.0417724, 0.157629, 0.117926, -5.15472e-09, 0.158686, 0.0376536, 0.0360384, 0.128495, -0.020488, 8.9556e-10, 0.153029, 0.082166, 0.0417724, 0.223511, 0.0937452, -4.09773e-09, 0.157629, 0.117926, -5.15472e-09, 0.158686, 0.0376536, 0.0360384, 0.193884, 0.0728707, 0.0472161, 0.201887, 0.00559588, -2.44604e-10, 0.192605, 0.0266702, 0.0397858, 0.25574, 0.0584528, -2.55505e-09, 0.228935, 0.0512476, 0.018125, 0.309722, 0.0232855, -1.01784e-09, 0.249898, 0.0331398, -1.44858e-09, -0.174415, -0.0125362, 0.0542962, -0.207226, 0.00682717, 0.0308756, -0.169294, -0.0296584, 0.0497064, -0.040306, 0.0791623, 0.0721547, -0.164409, -0.050691, 2.21577e-09, -0.218021, 0.0135101, -5.90546e-10, -0.040306, 0.0791623, 0.0721547, 0.0626402, 0.159396, 0.211644, 0.0771327, 0.103361, 0.0619846, -0.0467212, 0.0244225, 0.0802083, 0.00542577, 0.147336, 0.238884, 0.106685, 0.0437638, 0.0777734, 0.0831033, 0.146703, 0.212608, -0.0467212, 0.0244225, 0.0802083, 0.0831033, 0.146703, 0.212608, -0.0157337, 0.134805, 0.24046, 0.0586132, 0.254849, 0.41038, -0.0157337, 0.134805, 0.24046, -0.152323, 0.225563, 0.410337, -0.0126231, 0.279435, 0.410337, -0.0157337, 0.134805, 0.24046, -0.0126231, 0.279435, 0.410337, 0.0586132, 0.254849, 0.41038, -0.0126231, 0.279435, 0.410337, -0.0467212, 0.0244225, 0.0802083, -0.191074, 0.107613, 0.24046, -0.0126231, 0.28958, 0.479695, 0.0469384, 0.262363, 0.460252, 0.0586132, 0.254849, 0.41038, -0.207226, 0.00682717, 0.0308756, -0.382857, 0.00352616, -1.54133e-10, -0.366605, -0.00725494, 0.0619692, -0.174415, -0.0125362, 0.0542962, -0.0727707, -0.0728962, 3.1864e-09, 0.0871827, -0.012192, -0.0709558, 0.087738, -0.0451964, 1.9756e-09, 0.0771327, 0.103361, -0.0619846, 0.130661, 0.0720023, -0.0546474, -0.0467212, 0.0244225, -0.0802083, 0.106685, 0.0437638, -0.0777734, 0.13074, 0.00948082, -0.0546474, 0.153029, 0.082166, -0.0417724, 0.158686, 0.0376536, -0.0360384, 0.128495, -0.020488, 8.9556e-10, 0.153029, 0.082166, -0.0417724, 0.193884, 0.0728707, -0.0472161, 0.158686, 0.0376536, -0.0360384, 0.201887, 0.00559588, -2.44604e-10, 0.163029, 0.0059117, -2.58409e-10, 0.228935, 0.0512476, -0.0181251, 0.249898, 0.0331398, -1.44858e-09, 0.192605, 0.0266702, -0.0397858, -0.174415, -0.0125362, -0.0542962, -0.169294, -0.0296584, -0.0497064, -0.207226, 0.00682716, -0.0308756, -0.040306, 0.0791623, -0.0721547, -0.164409, -0.050691, 2.21577e-09, 0.0626402, 0.159396, -0.211644, -0.040306, 0.0791623, -0.0721547, 0.0771327, 0.103361, -0.0619846, 0.00542577, 0.147335, -0.238884, -0.0467212, 0.0244225, -0.0802083, 0.106685, 0.0437638, -0.0777734, -0.0467212, 0.0244225, -0.0802083, 0.0831033, 0.146703, -0.212608, 0.106685, 0.0437638, -0.0777734, 0.0586132, 0.254344, -0.41038, -0.0157337, 0.134804, -0.24046, -0.152323, 0.252968, -0.410337, -0.191074, 0.107613, -0.24046, -0.0126231, 0.26724, -0.410337, -0.0157337, 0.134804, -0.24046, 0.0831033, 0.146703, -0.212608, -0.0157337, 0.134804, -0.24046, 0.0586132, 0.254344, -0.41038, -0.0467212, 0.0244225, -0.0802083, -0.127924, 0.0048191, -0.0802083, -0.0126231, 0.252232, -0.479695, -0.0603874, 0.213113, -0.500182, -0.0126231, 0.26724, -0.410337, 0.0469384, 0.252621, -0.460252, -0.207226, 0.00682716, -0.0308756, -0.218021, 0.0135101, -5.90546e-10, -0.174415, -0.0125362, -0.0542962, -0.366605, -0.00725495, -0.0619692, -0.0674604, -0.0451277, -0.0802083, 0.163029, 0.0059117, -2.58409e-10, 0.163029, 0.0059117, -2.58409e-10, 0.106685, 0.0437638, 0.0777734, -0.127924, 0.00481911, 0.0802083, -0.0603874, 0.266995, 0.500182, -0.338864, -0.0232377, 0.0968035, 0.163029, 0.0059117, -2.58409e-10, -0.0126231, 0.26724, -0.410337, 0.0586132, 0.254344, -0.41038, -0.338864, -0.0232377, -0.0968035]);


const baseUvs = new Float32Array([0.145786, 0.575152, 0.370935, 0.729914, 0.159423, 0.795379, 0.226967, 0.399615, 0.119826, 0.525956, 0.0774827, 0.397813, 0.0892465, 0.543857, 0.0463773, 0.397813, 0.168041, 0.544419, 0.181529, 0.560442, 0.132331, 0.555084, 0.110206, 0.590191, 0.0577237, 0.522816, 0.000246496, 0.397813, 0.0310268, 0.597824, 0.0940873, 0.784436, 0.429531, 0.65635, 0.456595, 0.760909, 0.415186, 0.760909, 0.468174, 0.630699, 0.453057, 0.664984, 0.560926, 0.676221, 0.471728, 0.656282, 0.496669, 0.760909, 0.489825, 0.704823, 0.548073, 0.760909, 0.545391, 0.720352, 0.21318, 0.532056, 0.249748, 0.495463, 0.223017, 0.540942, 0.158107, 0.524073, 0.414693, 0.581962, 0.349304, 0.397813, 0.634908, 0.013204, 0.609791, 0.269268, 0.579834, 0.000246496, 0.67087, 0.025175, 0.641503, 0.316397, 0.543397, 0.031762, 0.598706, 0.271925, 0.934924, 0.0052133, 0.999754, 0.226218, 0.957974, 0.27247, 0.638979, 0.628988, 0.861081, 0.464815, 0.766561, 0.165348, 0.829354, 0.157567, 0.654632, 0.318063, 0.67087, 0.626518, 0.995741, 0.554679, 0.966147, 0.555009, 0.859589, 0.75815, 0.780271, 0.47285, 0.814559, 0.0339897, 0.845372, 0.0652878, 0.861081, 0.153497, 0.943284, 0.748237, 0.861574, 0.805913, 0.867421, 0.690359, 0.956787, 0.702047, 0.370935, 0.0657111, 0.145786, 0.220473, 0.159422, 0.000246496, 0.119826, 0.26967, 0.0892465, 0.251768, 0.168041, 0.251206, 0.132331, 0.240541, 0.110206, 0.205434, 0.0577237, 0.27281, 0.0310268, 0.197801, 0.0940872, 0.0111896, 0.42953, 0.865468, 0.453057, 0.856835, 0.468174, 0.89112, 0.560926, 0.845598, 0.566567, 0.87117, 0.489825, 0.816996, 0.545391, 0.801466, 0.471728, 0.865536, 0.21318, 0.263569, 0.223017, 0.254683, 0.249748, 0.300162, 0.158107, 0.271553, 0.414693, 0.213663, 0.481707, 0.36067, 0.506872, 0.617224, 0.451694, 0.630206, 0.513481, 0.31345, 0.542904, 0.60523, 0.415186, 0.59863, 0.861574, 0.618132, 0.934431, 0.369758, 0.934431, 0.623714, 0.51095, 0.000246496, 0.766068, 0.296943, 0.671363, 0.596997, 0.685102, 0.288893, 0.542904, 0.00272165, 0.526635, 0.31178, 0.470601, 0.358009, 0.887478, 0.317778, 0.929922, 0.000617736, 0.764576, 0.00304692, 0.727131, 0.000246496, 0.719455, 0.728612, 0.693282, 0.762421, 0.734279, 0.604793, 0.750328, 0.697253, 0.943284, 0.86359, 0.939326, 0.805913, 0.956787, 0.90978, 0.867421, 0.921467, 0.181529, 0.235183, 0.0281489, 0.76816, 0.566567, 0.650649, 0.999754, 0.000246496, 0.822215, 0.760944, 0.788437, 0.000246496, 0.877937, 0.624207, 0.028149, 0.0274651, 0.896663, 0.000246496, 0.766068, 0.608872, 0.877937, 0.987619]);


const baseIndices = new Uint16Array([0, 1, 2, 3, 4, 5, 5, 6, 7, 0, 8, 9, 4, 10, 6, 2, 11, 0, 7, 12, 13, 6, 14, 12, 15, 14, 11, 16, 17, 18, 19, 20, 16, 19, 21, 22, 23, 24, 25, 24, 26, 25, 17, 24, 23, 20, 22, 24, 21, 24, 22, 27, 28, 29, 28, 30, 3, 31, 28, 32, 33, 34, 35, 27, 8, 30, 36, 37, 33, 10, 11, 6, 38, 34, 39, 40, 41, 42, 37, 43, 34, 44, 45, 46, 37, 47, 48, 39, 34, 43, 42, 49, 50, 51, 52, 44, 45, 53, 46, 46, 54, 55, 56, 57, 58, 58, 59, 56, 3, 32, 28, 1, 29, 31, 27, 9, 8, 60, 61, 62, 63, 3, 5, 5, 64, 63, 61, 65, 66, 63, 64, 66, 67, 62, 61, 7, 68, 64, 64, 69, 67, 69, 70, 67, 17, 71, 18, 72, 73, 71, 73, 74, 75, 23, 25, 76, 76, 25, 77, 17, 76, 72, 72, 76, 78, 76, 74, 78, 79, 80, 81, 81, 82, 79, 83, 81, 80, 84, 85, 86, 79, 82, 65, 87, 88, 85, 67, 66, 64, 89, 84, 86, 90, 91, 92, 93, 87, 84, 94, 95, 96, 87, 97, 98, 99, 93, 84, 100, 101, 91, 102, 96, 103, 95, 104, 105, 106, 107, 104, 108, 57, 109, 110, 111, 108, 3, 81, 32, 60, 80, 112, 79, 112, 80, 0, 9, 1, 3, 30, 4, 5, 4, 6, 0, 10, 8, 2, 15, 11, 7, 6, 12, 6, 11, 14, 15, 113, 14, 16, 20, 17, 19, 22, 20, 19, 114, 21, 17, 20, 24, 21, 26, 24, 28, 27, 30, 31, 29, 28, 33, 37, 34, 36, 47, 37, 10, 0, 11, 38, 35, 34, 40, 115, 41, 37, 48, 43, 44, 52, 45, 42, 41, 49, 51, 116, 52, 45, 117, 53, 46, 53, 54, 56, 109, 57, 58, 118, 59, 1, 9, 29, 27, 29, 9, 60, 112, 61, 63, 82, 3, 5, 7, 64, 61, 112, 65, 67, 70, 62, 7, 13, 68, 64, 68, 69, 69, 119, 70, 17, 72, 71, 72, 78, 73, 73, 78, 74, 17, 23, 76, 76, 77, 74, 81, 3, 82, 83, 32, 81, 84, 87, 85, 87, 98, 88, 67, 61, 66, 89, 99, 84, 90, 100, 91, 93, 97, 87, 94, 106, 95, 100, 120, 101, 102, 94, 96, 95, 106, 104, 106, 121, 107, 108, 111, 57, 110, 122, 111, 60, 83, 80, 79, 65, 112]);


const angles = new Float32Array(BIRDS_COUNT);
const angleOffsets = new Float32Array(BIRDS_COUNT);
const speeds = new Float32Array(BIRDS_COUNT);
const timeOffsets = new Float32Array(BIRDS_COUNT);
const scales = new Float32Array(BIRDS_COUNT);
const radiuses = new Float32Array(BIRDS_COUNT);

for (let i = 0; i < BIRDS_COUNT; ++i) {
  angles[i] = 0;
  angleOffsets[i] = Math.random() * 2 * Math.PI;
  speeds[i] = (Math.random() * 0.05 + 0.05) * 0.2;
  timeOffsets[i] = Math.random() * 100;
  scales[i] = Math.random() * 0.5 + 0.3;
  radiuses[i] = Math.random() * 2 + 4;
}

const anglesBuffer = new THREE.InstancedBufferAttribute(angles, 1, 1).setDynamic(true);

geometry.addAttribute('position', new THREE.BufferAttribute(basePositions, 3));
geometry.addAttribute('highPosition', new THREE.BufferAttribute(highPositions, 3));
geometry.addAttribute('uv', new THREE.BufferAttribute(baseUvs, 2));
geometry.addAttribute('timeOffset', new THREE.InstancedBufferAttribute(timeOffsets, 1, 1));
geometry.addAttribute('scale', new THREE.InstancedBufferAttribute(scales, 1, 1));
geometry.addAttribute('radius', new THREE.InstancedBufferAttribute(radiuses, 1, 1));
geometry.addAttribute('angle', anglesBuffer);
geometry.setIndex(new THREE.BufferAttribute(baseIndices, 1));

console.log(geometry);

const mesh = new THREE.Mesh(geometry, material);
scene.add(mesh);

function tick() {
  window.requestAnimationFrame(tick);


  // material.uniforms.time.value += 0.2

  // 	const { array: angles } = anglesBuffer

  // 	for (let i = 0; i < angles.length; i++) {
  // 		angles[i] += speeds[i / 3]

  // 		if (angles[i] > 2 * Math.PI) {
  // 			angles[i] = 0
  // 		}
  // 	}

  // 	anglesBuffer.needsUpdate = true

  renderer.render(scene, camera);
}

window.requestAnimationFrame(tick);

window.addEventListener('resize', () => {
  const { offsetWidth: width, offsetHeight: height } = $viewport;

  renderer.setSize(width, height);

  camera.aspect = width / height;
  camera.updateProjectionMatrix();
});

const props = {
  progress: 0


  // const gui = new dat.GUI()

  // gui.add(props, 'progress').min(0).max(1).onChange(updateProgress)
};
const $indicator = document.createElement('div');
$indicator.style.position = 'absolute';
$indicator.style.width = '50px';
$indicator.style.height = '50px';
$indicator.style.backgroundColor = 'red';
$indicator.style.bottom = '0';
$indicator.style.right = '0';
document.body.appendChild($indicator);

TweenMax.to(props, SPEED, {
  progress: 1,
  repeat: -1,
  ease: Linear.easeNone,
  onUpdate: updateProgress,
  onRepeat: () => $indicator.style.display = 'block' });


function updateProgress() {
  $indicator.style.display = 'none';

  const { progress } = props;

  const angle = progress * Math.PI * 2;
  const time = progress;

  material.uniforms.time.value = time;

  const { array: angles } = anglesBuffer;

  for (let i = 0; i < angles.length; i++) {
    angles[i] = angle - angleOffsets[i];
  }

  anglesBuffer.needsUpdate = true;
}

console.log(window);