const engine = new BABYLON.Engine(elCanvas, true);

let lightPos = new BABYLON.Vector3(0, 8, 0);
let lightDiffuse = new BABYLON.Color3(1, 1, 1);

// scene
const scene = (() => {
    const scene = new BABYLON.Scene(engine);

    // mats
    const matEmit = new BABYLON.StandardMaterial('matEmit', scene);
    matEmit.emissiveColor = lightDiffuse;
    matEmit.disableLighting = true;

    const matMetal = new BABYLON.PBRMetallicRoughnessMaterial('matMetal', scene);
    matMetal.metallic = 0.9;
    matMetal.roughness = 0.1;
    matMetal.baseColor = new BABYLON.Color3(1, 1, 1);

    const matWall = new BABYLON.PBRMetallicRoughnessMaterial('matWall', scene);
    matWall.metallic = 0.0;
    matWall.roughness = 1.0;
    matWall.baseColor = new BABYLON.Color3(0.9, 0.1, 0.1);

    // meshes 
    const torus = BABYLON.MeshBuilder.CreateTorusKnot('torus', { radialSegments: 200, tubularSegments: 50 }, scene);
    torus.position.y = 3.3;
    torus.sideOrientation = BABYLON.Mesh.FRONTSIDE;
    torus.material = matMetal;

    const bulb = BABYLON.MeshBuilder.CreateSphere('bulb', { diameter: 2 }, scene);
    bulb.position = lightPos;
    bulb.material = matEmit;

    const room = BABYLON.MeshBuilder.CreateBox('room', { width: 20, height: 20, depth: 20, sideOrientation: BABYLON.Mesh.BACKSIDE }, scene);
    room.material = matWall;

    const ground = BABYLON.MeshBuilder.CreateBox('ground', { width: 6, height: 10, depth: 6 }, scene);
    ground.material = matWall;
    ground.position.y = -5;

    //
    // "pointlight" does not cast self-shadow but "spotlight" does
    // 
    let light0; // spotlight that only lits the torus
    {
        const light = new BABYLON.SpotLight('light0', lightPos, torus.position.subtract(lightPos), Math.PI * 2 / 3, 0, scene);
        light.diffuse = lightDiffuse;
        light.intensity = 20;
        light.includedOnlyMeshes.push(torus); // <<<<<<<<<<<<<<<<<<<<<
        const shadowGen = new BABYLON.ShadowGenerator(2048, light);
        shadowGen.useCloseExponentialShadowMap = true;
        shadowGen.addShadowCaster(torus); // caster
        torus.receiveShadows = true; // receiver  
        shadowGen.setDarkness(0);
        light0 = light;
    }
    let light1; // pointlight that lits all meshes excepts the bulb
    {
        const light = new BABYLON.PointLight('light1', lightPos, scene);
        light.diffuse = lightDiffuse;
        light.intensity = 200;
        light.excludedMeshes.push(bulb); // <<<<<<<<<<<<<<
        const shadowGen = new BABYLON.ShadowGenerator(1024, light);
        shadowGen.bias = 0.0005;
        shadowGen.usePercentageCloserFiltering = true;
        shadowGen.setDarkness(0.3);
        shadowGen.addShadowCaster(torus); // caster
        shadowGen.addShadowCaster(ground);
        torus.receiveShadows = true; // receiver
        room.receiveShadows = true; // receiver  
        ground.receiveShadows = true; // receiver
        light1 = light;
    }

    // camera
    const camera = new BABYLON.ArcRotateCamera('camera', Math.PI / 3, Math.PI * 3/5, 9, torus, scene, true);
    camera.attachControl(elCanvas);
    camera.upperBetaLimit = Math.PI * 3 / 4;
    camera.wheelPrecision = 10;
    camera.upperRadiusLimit = 11;
    camera.lowerRadiusLimit = 5;

    // update 
    let i = 0;
    engine.runRenderLoop(() => {
        i += 0.008;

        lightPos.x = -Math.cos(i) * 8;
        lightPos.z = Math.sin(i) * 8;

        light0.position = lightPos;
        light0.direction = torus.position.subtract(lightPos);

        light1.position = lightPos;

        bulb.position = lightPos;
    });
    return scene;
})();

// loop
engine.runRenderLoop(() => {
    scene.render();
});

// ev
addEventListener('resize', () => {
    engine.resize();
});