(function($){

    $.fn.design_7_countdown = function(options){

        var settings = $.extend({
            days : 0,
            month : 0,
            year : 0,
            hours : 0,
            mins : 0,
            secs : 0,
            darkcolor : '#0fb4e7',
            lightcolor: '#a9e4f7',
            turn : 6,
            animate : 'no',
            animationspeed : 500,

        },options);


        var $elem = $(this);

        var timer_label = ['Days','Hours','Minutes','Seconds'];


        for(var j =0 ; j < 4; j++){
            $elem.append('<div class="timer_wrapper"><div class="label">'+timer_label[j]+'</div><div class="timer"></div></div>');

            for(var i = 0 ; i < 60 ; i++){
                $elem.find('.timer_wrapper').eq(j).find('.label').after('<div class="circle"></div>');
            }
        }
        

        //assign value to all timer divs
        var assign_val = function(){
            //calculate days differences

            var today = new Date();
            var setDate = new Date(settings.year,settings.month-1,settings.days,settings.hours,settings.mins,settings.secs);
            var difference = setDate - today;


            //calculate days,hours,minutes and seconds
            set_days = Math.floor(difference/(1000 * 60 * 60 * 24));
            var set_hrs = Math.floor(((difference/(1000 * 60 * 60 * 24)) - set_days)*24);
            var set_mins = Math.floor(((((difference/(1000 * 60 * 60 * 24)) - set_days)*24) - set_hrs)*60);
            var set_secs = Math.floor(((((((difference/(1000 * 60 * 60 * 24)) - set_days)*24) - set_hrs)*60)- set_mins) * 60);
           
            if(setDate > today){
                $elem.find('.timer').eq(0).text(set_days);
                $elem.find('.timer').eq(1).text(set_hrs);
                $elem.find('.timer').eq(2).text(set_mins);
                $elem.find('.timer').eq(3).text(set_secs);
            }
            else if(setDate < today){
                $elem.find('.timer').text(0);
            }
        }

        assign_val();
        
        //start countdown

        var count_down_sec = function(){

            //if seconds goes zero change minutes and re-run second timer

            if($elem.find('.timer').eq(3).text() == 0 && $elem.find('.timer').eq(2).text() > 0){
                $elem.find('.timer').eq(3).text(59);
                var deduct_min = ($elem.find('.timer').eq(2).text()-1)
                $elem.find('.timer').eq(2).text(deduct_min);
            }

            //run second timer

            else if($elem.find('.timer').eq(3).text() > 0){
                var deduct_sec = ($elem.find('.timer').eq(3).text()-1)
                $elem.find('.timer').eq(3).text(deduct_sec);
            }


            //if hours goes zero change minutes and re-run second timer

            else if($elem.find('.timer').eq(2).text() == 0 && $elem.find('.timer').eq(1).text() > 0){
                var deduct_hours = ($elem.find('.timer').eq(1).text()-1)
                $elem.find('.timer').eq(1).text(deduct_hours);
                $elem.find('.timer').eq(2).text(59);
                $elem.find('.timer').eq(3).text(59);
            }

            else if($elem.find('.timer').eq(1).text() == 0 && $elem.find('.timer').eq(0).text() > 0){
                var deduct_days = ($elem.find('.timer').eq(0).text()-1)
                $elem.find('.timer').eq(0).text(deduct_days);
                $elem.find('.timer').eq(1).text(23);
                $elem.find('.timer').eq(2).text(59);
                $elem.find('.timer').eq(3).text(59);
            }

        }

        setInterval(count_down_sec,1000);


        turn = 0;

        //if animate circle

        if(settings.animate == 'yes'){
             var animate_circle =function(){
                 turn+= 10;
                }
            setInterval(animate_circle,settings.animationspeed);
        }
       

        var set_circle = function(){

            for(var j = 0; j < $elem.find('.timer_wrapper').length ; j++){
                
                width = $elem.find('.timer_wrapper').eq(j).width();
                height = $elem.find('.timer_wrapper').eq(j).width();
                var radius = width/3;
                var angle = 0;
                var rotate = (2*Math.PI) / $elem.find('.timer_wrapper').eq(j).find('.circle').length;
                

                $elem.find('.timer_wrapper').eq(j).find('.circle').each(function(){
                    var x = Math.round(width/2 + radius * Math.cos(angle) - $(this).width()/2);
                    var y = Math.round(height/2 + radius * Math.sin(angle) - $(this).height()/2);
               
                    $(this).css({left: x + 'px',top: y + 'px','transform':'rotate('+turn+'deg)','-webkit-transform':'rotate('+turn+'deg)','-ms-transform':'rotate('+turn+'deg)','-moz-transform':'rotate('+turn+'deg)'});
                    angle += rotate;
                    turn += settings.turn;

                 });
            }

        }
        set_circle()

        if(settings.animate == 'yes'){
            setInterval(set_circle,settings.animationspeed);
        }
        


        circle_array = [46,47,48,49,50,51,52,53,54,55,56,57,58,59];
        for(var k = 0; k < 46 ; k++){
            circle_array.push(k)
        }



        var change_color = function(){

            $elem.find('.timer_wrapper').find('.circle').css('background',settings.lightcolor);

             var sec_value = $elem.find('.timer').eq(3).text();
             var min_value = $elem.find('.timer').eq(2).text();
             var hr_value = $elem.find('.timer').eq(1).text();
             var day_value = $elem.find('.timer').eq(0).text();
             var sec_circle = parseInt(sec_value);
             var min_circle = parseInt(min_value);
             var hr_circle = parseInt(hr_value*2.5);
             var day_circle = parseInt(day_value/(set_days/60));



             
             

              $elem.find('.timer_wrapper').eq(3).find('.circle').eq(45).css('background',settings.darkcolor);
              $elem.find('.timer_wrapper').eq(2).find('.circle').eq(45).css('background',settings.darkcolor);
              $elem.find('.timer_wrapper').eq(1).find('.circle').eq(45).css('background',settings.darkcolor);
              $elem.find('.timer_wrapper').eq(0).find('.circle').eq(45).css('background',settings.darkcolor);

             for(var j = 0 ; j < sec_circle ; j++){
                $elem.find('.timer_wrapper').eq(3).find('.circle').eq(circle_array[j]).css('background',settings.darkcolor);
             }
             for(var j = 0 ; j < min_circle ; j++){  
                $elem.find('.timer_wrapper').eq(2).find('.circle').eq(circle_array[j]).css('background',settings.darkcolor);
             }
             for(var j = 0 ; j < hr_circle ; j++){  
                $elem.find('.timer_wrapper').eq(1).find('.circle').eq(circle_array[j]).css('background',settings.darkcolor);
             }
             for(var j = 0 ; j < day_circle ; j++){  
                $elem.find('.timer_wrapper').eq(0).find('.circle').eq(circle_array[j]).css('background',settings.darkcolor);
             }
             

        }
        change_color();
        setInterval(change_color,1000)




    };
})(jQuery);