/*
 * ROUND WIRE
 * Made with p5 - Enjoy!
 *
 * Inspired by one of the p5js examples in docu:
 * https://p5js.org/examples/simulate-particle-system.html
 *
 * #047 - #100DaysOfCode
 * By ilithya | 2020
 * https://www.ilithya.rocks/
 * https://twitter.com/ilithya_net
 */

const bgColor = "#7c4de1"; // purple
const wireColor = "hotpink";

let wire;
function setup() {
  createCanvas(windowWidth, windowHeight);

  // Note to myself: width & height - system vars that store the w/h of the drawing canvas.
  const xcenter = width / 2;
  const ycenter = height / 2.05;
  wire = Object.create(Roundwire).init(createVector(xcenter, ycenter));
}

function draw() {
  background(bgColor);

  wire.createCircles();
  wire.addMotion();
}

// Let's code this with OLOO style
const Cable = {
  init(pos) {
    this.acceleration = createVector(0, 0.05);

    const v = 1.3;
    this.velocity = createVector(random(v * -1, v), random(v * -1, v));
    this.position = pos.copy();
    this.lifespan = 340;

    return this;
  },
  update() {
    this.velocity.add(this.acceleration);
    this.position.add(this.velocity);
    // The smaller the value the more waterfall-y effect :D
    this.lifespan -= 10;
  },
  create() {
    stroke(wireColor);
    strokeWeight(1);
    noFill();

    const sizeMax = min(width, height);
    const d = floor(sizeMax / 1.6);
    circle(this.position.x, this.position.y, d);
  },
  generate() {
    this.update();
    this.create();
  },
  isDead() {
    const min = -20;
    // We don't want to count below the min val!
    return this.lifespan < min;
  } };


const Roundwire = {
  init(pos) {
    this.origin = pos.copy();
    this.wireArray = [];

    return this;
  },
  createCircles() {
    const thinWire = Object.create(Cable).init(this.origin);
    this.wireArray.push(thinWire);
  },
  addMotion() {
    const totalWire = this.wireArray.length - 1;

    for (let i = totalWire; i >= 0; i--) {
      let elWire = this.wireArray[i];
      elWire.generate();

      // If dead, remove only 1 el from index i
      if (elWire.isDead()) this.wireArray.splice(i, 1);
    }
  } };