$(document).ready(function(){
	
	// screen size detect
	
	var is_mobile;
	
	function switch_desktop(){
		$('#menu').removeClass('mobile-menu');
		$('#menu.menu-open').removeClass('menu-open').
		find('#primary-nav').css('height', 0);
		is_mobile = false;
	}
	
	function switch_mobile(){
		$('#menu').addClass('mobile-menu');
		is_mobile = true;
	}
		
	$(window).resize(function(){
		
		var screen_width = $(window).width();
		
		if(screen_width < 758 && is_mobile === false) {
			switch_mobile();
		}
		
		if(screen_width > 757 && is_mobile === true){
			switch_desktop();
		}
		
		if(is_mobile === undefined) {
			if(screen_width < 758) {
				switch_mobile();
			} else {
				switch_desktop();
			}
		}
	
	}).trigger('resize');
	
	
	// mobile menu
	
	$('#menu-icon').click(function(e){
		
		var menu_height = $('#primary-nav > ul').outerHeight();
		
		if($('#menu').hasClass('menu-open')) {
			
			if(Modernizr.csstransitions) {
				$('#primary-nav').css('height', 0);
			} else {
				$('#primary-nav').stop().animate({height: 0}, 300);
			}
		
		} else {
			
			if(Modernizr.csstransitions) {
				$('#primary-nav').css('height', menu_height);
			} else {
				$('#primary-nav').stop().animate({height: menu_height}, 300);
			}
		}
		
		$('#menu').toggleClass('menu-open');
		e.preventDefault();
		
	});
	
	
	// menu active change
	
	$('#primary-nav').on('click','a',function(){
		$('#primary-nav a.active').removeClass('active');
		$(this).addClass('active');
	});
	
	
	// anchor smooth scroll
	
	$('a[href^="#"]').click(function(e){

		var hash = $(this).attr('href');
		var target = $(hash);
		
		if(target.length) {
			$('html, body').stop().animate({scrollTop: target.offset().top - 20}, 300, 'easeOutQuad', function(){
				window.location.hash = hash;
			});
		}
		
		e.preventDefault();
		
	});
	
	
	// scroll top
	
	$('#scroll-top').click(function(){
		$('html, body').stop().animate({scrollTop: 1}, 300, 'easeOutQuad');
	});
	
	$(window).on('scroll', function(){
		
		var scroll = $(this).scrollTop();
		var visible = $('#scroll-top').data('is_visible');
		
		if(scroll > 200 && !visible) {
			$('#scroll-top').data('is_visible', true).fadeIn(300);
		}
		
		if(scroll < 200 && visible) {
			$('#scroll-top').data('is_visible', false).fadeOut(300);
		}
				
	});
	
	// google prettify
	
	prettyPrint();
	
});
