(function ($hx_exports) { "use strict";
$hx_exports.openfl = $hx_exports.openfl || {};
$hx_exports.lime = $hx_exports.lime || {};
var $hxClasses = {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var haxe = {};
haxe.Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe.Timer;
haxe.Timer.__name__ = ["haxe","Timer"];
haxe.Timer.delay = function(f,time_ms) {
	var t = new haxe.Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe.Timer.measure = function(f,pos) {
	var t0 = haxe.Timer.stamp();
	var r = f();
	haxe.Log.trace(haxe.Timer.stamp() - t0 + "s",pos);
	return r;
};
haxe.Timer.stamp = function() {
	return new Date().getTime() / 1000;
};
haxe.Timer.prototype = {
	stop: function() {
		if(this.id == null) return;
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe.Timer
};
var lime = {};
lime.system = {};
lime.system.System = function() { };
$hxClasses["lime.system.System"] = lime.system.System;
lime.system.System.__name__ = ["lime","system","System"];
lime.system.System.disableCFFI = null;
lime.system.System.embed = $hx_exports.lime.embed = function(element,width,height,background,assetsPrefix) {
	var htmlElement = null;
	if(typeof(element) == "string") htmlElement = window.document.getElementById(js.Boot.__cast(element , String)); else if(element == null) htmlElement = window.document.createElement("div"); else htmlElement = element;
	var color = null;
	if(background != null) {
		background = StringTools.replace(background,"#","");
		if(background.indexOf("0x") > -1) color = Std.parseInt(background); else color = Std.parseInt("0x" + background);
	}
	if(width == null) width = 0;
	if(height == null) height = 0;
	ApplicationMain.config.background = color;
	ApplicationMain.config.element = htmlElement;
	ApplicationMain.config.width = width;
	ApplicationMain.config.height = height;
	ApplicationMain.config.assetsPrefix = assetsPrefix;
	ApplicationMain.create();
};
lime.system.System.findHaxeLib = function(library) {
	return "";
};
lime.system.System.getTimer = function() {
	return Std["int"]((haxe.Timer.stamp() - lime.system.System.__startTime) * 1000);
};
lime.system.System.load = function(library,method,args,lazy) {
	if(lazy == null) lazy = false;
	if(args == null) args = 0;
	if(lime.system.System.disableCFFI) return Reflect.makeVarArgs(function(__) {
		return { };
	});
	if(lazy) {
	}
	var result = null;
	return result;
};
lime.system.System.sysName = function() {
	return null;
};
lime.system.System.tryLoad = function(name,library,func,args) {
	return null;
};
lime.system.System.loaderTrace = function(message) {
};
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
};
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.setField = function(o,field,value) {
	o[field] = value;
};
Reflect.getProperty = function(o,field) {
	var tmp;
	if(o == null) return null; else if(o.__properties__ && (tmp = o.__properties__["get_" + field])) return o[tmp](); else return o[field];
};
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
};
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
};
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
};
Reflect.compare = function(a,b) {
	if(a == b) return 0; else if(a > b) return 1; else return -1;
};
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
};
Reflect.isEnumValue = function(v) {
	return v != null && v.__enum__ != null;
};
Reflect.deleteField = function(o,field) {
	if(!Object.prototype.hasOwnProperty.call(o,field)) return false;
	delete(o[field]);
	return true;
};
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
};
lime.utils = {};
lime.utils.ByteArray = function(size) {
	if(size == null) size = 0;
	this.littleEndian = false;
	this.allocated = 0;
	this.position = 0;
	this.length = 0;
	if(size > 0) this.allocated = size;
	this.___resizeBuffer(this.allocated);
	this.set_length(this.allocated);
};
$hxClasses["lime.utils.ByteArray"] = lime.utils.ByteArray;
lime.utils.ByteArray.__name__ = ["lime","utils","ByteArray"];
lime.utils.ByteArray.fromBytes = function(bytes) {
	var result = new lime.utils.ByteArray();
	result.byteView = new Uint8Array(bytes.b);
	result.set_length(result.byteView.length);
	result.allocated = result.length;
	return result;
};
lime.utils.ByteArray.readFile = function(path) {
	return null;
};
lime.utils.ByteArray.__ofBuffer = function(buffer) {
	var bytes = new lime.utils.ByteArray();
	bytes.set_length(bytes.allocated = buffer.byteLength);
	bytes.data = new DataView(buffer);
	bytes.byteView = new Uint8Array(buffer);
	return bytes;
};
lime.utils.ByteArray.prototype = {
	clear: function() {
		if(this.allocated < 0) this.___resizeBuffer(this.allocated = Std["int"](Math.max(0,this.allocated * 2))); else if(this.allocated > 0) this.___resizeBuffer(this.allocated = 0);
		this.length = 0;
		0;
		this.position = 0;
	}
	,compress: function(algorithm) {
	}
	,deflate: function() {
		this.compress(lime.utils.CompressionAlgorithm.DEFLATE);
	}
	,inflate: function() {
		this.uncompress(lime.utils.CompressionAlgorithm.DEFLATE);
	}
	,readBoolean: function() {
		return this.readByte() != 0;
	}
	,readByte: function() {
		var data = this.data;
		return data.getInt8(this.position++);
	}
	,readBytes: function(bytes,offset,length) {
		if(length == null) length = 0;
		if(offset == null) offset = 0;
		if(offset < 0 || length < 0) throw "Read error - Out of bounds";
		if(length == 0) length = this.length - this.position;
		var lengthToEnsure = offset + length;
		if(bytes.length < lengthToEnsure) {
			if(bytes.allocated < lengthToEnsure) bytes.___resizeBuffer(bytes.allocated = Std["int"](Math.max(lengthToEnsure,bytes.allocated * 2))); else if(bytes.allocated > lengthToEnsure) bytes.___resizeBuffer(bytes.allocated = lengthToEnsure);
			bytes.length = lengthToEnsure;
			lengthToEnsure;
		}
		bytes.byteView.set(this.byteView.subarray(this.position,this.position + length),offset);
		bytes.position = offset;
		this.position += length;
		if(bytes.position + length > bytes.length) bytes.set_length(bytes.position + length);
	}
	,readDouble: function() {
		var $double = this.data.getFloat64(this.position,this.littleEndian);
		this.position += 8;
		return $double;
	}
	,readFloat: function() {
		var $float = this.data.getFloat32(this.position,this.littleEndian);
		this.position += 4;
		return $float;
	}
	,readInt: function() {
		var $int = this.data.getInt32(this.position,this.littleEndian);
		this.position += 4;
		return $int;
	}
	,readMultiByte: function(length,charSet) {
		return this.readUTFBytes(length);
	}
	,readShort: function() {
		var $short = this.data.getInt16(this.position,this.littleEndian);
		this.position += 2;
		return $short;
	}
	,readUnsignedByte: function() {
		var data = this.data;
		return data.getUint8(this.position++);
	}
	,readUnsignedInt: function() {
		var uInt = this.data.getUint32(this.position,this.littleEndian);
		this.position += 4;
		return uInt;
	}
	,readUnsignedShort: function() {
		var uShort = this.data.getUint16(this.position,this.littleEndian);
		this.position += 2;
		return uShort;
	}
	,readUTF: function() {
		var bytesCount = this.readUnsignedShort();
		return this.readUTFBytes(bytesCount);
	}
	,readUTFBytes: function(len) {
		var value = "";
		var max = this.position + len;
		while(this.position < max) {
			var data = this.data;
			var c = data.getUint8(this.position++);
			if(c < 128) {
				if(c == 0) break;
				value += String.fromCharCode(c);
			} else if(c < 224) value += String.fromCharCode((c & 63) << 6 | data.getUint8(this.position++) & 127); else if(c < 240) {
				var c2 = data.getUint8(this.position++);
				value += String.fromCharCode((c & 31) << 12 | (c2 & 127) << 6 | data.getUint8(this.position++) & 127);
			} else {
				var c21 = data.getUint8(this.position++);
				var c3 = data.getUint8(this.position++);
				value += String.fromCharCode((c & 15) << 18 | (c21 & 127) << 12 | c3 << 6 & 127 | data.getUint8(this.position++) & 127);
			}
		}
		return value;
	}
	,toString: function() {
		var cachePosition = this.position;
		this.position = 0;
		var value = this.readUTFBytes(this.length);
		this.position = cachePosition;
		return value;
	}
	,uncompress: function(algorithm) {
		null;
	}
	,write_uncheck: function($byte) {
	}
	,writeBoolean: function(value) {
		this.writeByte(value?1:0);
	}
	,writeByte: function(value) {
		var lengthToEnsure = this.position + 1;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		var data = this.data;
		data.setInt8(this.position,value);
		this.position += 1;
	}
	,writeBytes: function(bytes,offset,length) {
		if(length == null) length = 0;
		if(offset == null) offset = 0;
		if(bytes.length == 0) return;
		if((function($this) {
			var $r;
			var aNeg = 0 < 0;
			var bNeg = offset < 0;
			$r = aNeg != bNeg?aNeg:0 > offset;
			return $r;
		}(this)) || (function($this) {
			var $r;
			var aNeg1 = 0 < 0;
			var bNeg1 = length < 0;
			$r = aNeg1 != bNeg1?aNeg1:0 > length;
			return $r;
		}(this))) throw "Write error - Out of bounds";
		if((function($this) {
			var $r;
			var $int = length;
			$r = $int < 0?4294967296.0 + $int:$int + 0.0;
			return $r;
		}(this)) == 0) length = bytes.length;
		var lengthToEnsure = this.position + length;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.byteView.set(bytes.byteView.subarray(offset,offset + length),this.position);
		this.position = this.position + length;
	}
	,writeDouble: function(x) {
		var lengthToEnsure = this.position + 8;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.data.setFloat64(this.position,x,this.littleEndian);
		this.position += 8;
	}
	,writeFile: function(path) {
	}
	,writeFloat: function(x) {
		var lengthToEnsure = this.position + 4;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.data.setFloat32(this.position,x,this.littleEndian);
		this.position += 4;
	}
	,writeInt: function(value) {
		var lengthToEnsure = this.position + 4;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.data.setInt32(this.position,value,this.littleEndian);
		this.position += 4;
	}
	,writeShort: function(value) {
		var lengthToEnsure = this.position + 2;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.data.setInt16(this.position,value,this.littleEndian);
		this.position += 2;
	}
	,writeUnsignedInt: function(value) {
		var lengthToEnsure = this.position + 4;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.data.setUint32(this.position,value,this.littleEndian);
		this.position += 4;
	}
	,writeUnsignedShort: function(value) {
		var lengthToEnsure = this.position + 2;
		if(this.length < lengthToEnsure) {
			if(this.allocated < lengthToEnsure) this.___resizeBuffer(this.allocated = Std["int"](Math.max(lengthToEnsure,this.allocated * 2))); else if(this.allocated > lengthToEnsure) this.___resizeBuffer(this.allocated = lengthToEnsure);
			this.length = lengthToEnsure;
			lengthToEnsure;
		}
		this.data.setUint16(this.position,value,this.littleEndian);
		this.position += 2;
	}
	,writeUTF: function(value) {
		this.writeUnsignedShort(this.__getUTFBytesCount(value));
		this.writeUTFBytes(value);
	}
	,writeUTFBytes: function(value) {
		var _g1 = 0;
		var _g = value.length;
		while(_g1 < _g) {
			var i = _g1++;
			var c = value.charCodeAt(i);
			if(c <= 127) this.writeByte(c); else if(c <= 2047) {
				this.writeByte(192 | c >> 6);
				this.writeByte(128 | c & 63);
			} else if(c <= 65535) {
				this.writeByte(224 | c >> 12);
				this.writeByte(128 | c >> 6 & 63);
				this.writeByte(128 | c & 63);
			} else {
				this.writeByte(240 | c >> 18);
				this.writeByte(128 | c >> 12 & 63);
				this.writeByte(128 | c >> 6 & 63);
				this.writeByte(128 | c & 63);
			}
		}
	}
	,__fromBytes: function(bytes) {
		this.byteView = new Uint8Array(bytes.b);
		this.set_length(this.byteView.length);
		this.allocated = this.length;
	}
	,__get: function(pos) {
		return this.data.getInt8(pos);
	}
	,__getBuffer: function() {
		return this.data.buffer;
	}
	,__getUTFBytesCount: function(value) {
		var count = 0;
		var _g1 = 0;
		var _g = value.length;
		while(_g1 < _g) {
			var i = _g1++;
			var c = value.charCodeAt(i);
			if(c <= 127) count += 1; else if(c <= 2047) count += 2; else if(c <= 65535) count += 3; else count += 4;
		}
		return count;
	}
	,___resizeBuffer: function(len) {
		var oldByteView = this.byteView;
		var newByteView = new Uint8Array(len);
		if(oldByteView != null) {
			if(oldByteView.length <= len) newByteView.set(oldByteView); else newByteView.set(oldByteView.subarray(0,len));
		}
		this.byteView = newByteView;
		this.data = new DataView(newByteView.buffer);
	}
	,__set: function(pos,v) {
		this.data.setUint8(pos,v);
	}
	,get_bytesAvailable: function() {
		return this.length - this.position;
	}
	,get_endian: function() {
		if(this.littleEndian) return "littleEndian"; else return "bigEndian";
	}
	,set_endian: function(endian) {
		this.littleEndian = endian == "littleEndian";
		return endian;
	}
	,set_length: function(value) {
		if(this.allocated < value) this.___resizeBuffer(this.allocated = Std["int"](Math.max(value,this.allocated * 2))); else if(this.allocated > value) this.___resizeBuffer(this.allocated = value);
		this.length = value;
		return value;
	}
	,__class__: lime.utils.ByteArray
	,__properties__: {set_length:"set_length",set_endian:"set_endian",get_endian:"get_endian",get_bytesAvailable:"get_bytesAvailable"}
};
var __ASSET__data_gameplay_js = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__data_gameplay_js.resourceName));
};
$hxClasses["__ASSET__data_gameplay_js"] = __ASSET__data_gameplay_js;
__ASSET__data_gameplay_js.__name__ = ["__ASSET__data_gameplay_js"];
__ASSET__data_gameplay_js.__super__ = lime.utils.ByteArray;
__ASSET__data_gameplay_js.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__data_gameplay_js
});
var __ASSET__images_atlas_0_json = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__images_atlas_0_json.resourceName));
};
$hxClasses["__ASSET__images_atlas_0_json"] = __ASSET__images_atlas_0_json;
__ASSET__images_atlas_0_json.__name__ = ["__ASSET__images_atlas_0_json"];
__ASSET__images_atlas_0_json.__super__ = lime.utils.ByteArray;
__ASSET__images_atlas_0_json.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__images_atlas_0_json
});
var __ASSET__images_atlas_1_json = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__images_atlas_1_json.resourceName));
};
$hxClasses["__ASSET__images_atlas_1_json"] = __ASSET__images_atlas_1_json;
__ASSET__images_atlas_1_json.__name__ = ["__ASSET__images_atlas_1_json"];
__ASSET__images_atlas_1_json.__super__ = lime.utils.ByteArray;
__ASSET__images_atlas_1_json.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__images_atlas_1_json
});
var __ASSET__images_atlas_2_json = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__images_atlas_2_json.resourceName));
};
$hxClasses["__ASSET__images_atlas_2_json"] = __ASSET__images_atlas_2_json;
__ASSET__images_atlas_2_json.__name__ = ["__ASSET__images_atlas_2_json"];
__ASSET__images_atlas_2_json.__super__ = lime.utils.ByteArray;
__ASSET__images_atlas_2_json.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__images_atlas_2_json
});
var __ASSET__images_fonts_purple_kern_txt = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__images_fonts_purple_kern_txt.resourceName));
};
$hxClasses["__ASSET__images_fonts_purple_kern_txt"] = __ASSET__images_fonts_purple_kern_txt;
__ASSET__images_fonts_purple_kern_txt.__name__ = ["__ASSET__images_fonts_purple_kern_txt"];
__ASSET__images_fonts_purple_kern_txt.__super__ = lime.utils.ByteArray;
__ASSET__images_fonts_purple_kern_txt.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__images_fonts_purple_kern_txt
});
var __ASSET__images_fonts_yellow_big_kern_txt = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__images_fonts_yellow_big_kern_txt.resourceName));
};
$hxClasses["__ASSET__images_fonts_yellow_big_kern_txt"] = __ASSET__images_fonts_yellow_big_kern_txt;
__ASSET__images_fonts_yellow_big_kern_txt.__name__ = ["__ASSET__images_fonts_yellow_big_kern_txt"];
__ASSET__images_fonts_yellow_big_kern_txt.__super__ = lime.utils.ByteArray;
__ASSET__images_fonts_yellow_big_kern_txt.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__images_fonts_yellow_big_kern_txt
});
var __ASSET__images_fonts_yellow_small_kern_txt = function(size) {
	if(size == null) size = 0;
	lime.utils.ByteArray.call(this);
	this.__fromBytes(haxe.Resource.getBytes(__ASSET__images_fonts_yellow_small_kern_txt.resourceName));
};
$hxClasses["__ASSET__images_fonts_yellow_small_kern_txt"] = __ASSET__images_fonts_yellow_small_kern_txt;
__ASSET__images_fonts_yellow_small_kern_txt.__name__ = ["__ASSET__images_fonts_yellow_small_kern_txt"];
__ASSET__images_fonts_yellow_small_kern_txt.__super__ = lime.utils.ByteArray;
__ASSET__images_fonts_yellow_small_kern_txt.prototype = $extend(lime.utils.ByteArray.prototype,{
	__class__: __ASSET__images_fonts_yellow_small_kern_txt
});
var ApplicationMain = function() { };
$hxClasses["ApplicationMain"] = ApplicationMain;
ApplicationMain.__name__ = ["ApplicationMain"];
ApplicationMain.config = null;
ApplicationMain.preloader = null;
ApplicationMain.create = function() {
	var app = new openfl.display.Application();
	app.create(ApplicationMain.config);
	var display = new co.doubleduck.pinata.Preloader();
	ApplicationMain.preloader = new openfl.display.Preloader(display);
	ApplicationMain.preloader.onComplete = ApplicationMain.init;
	ApplicationMain.preloader.create(ApplicationMain.config);
	var urls = [];
	var types = [];
	urls.push("data/gameplay.js");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__data_gameplay_js,[]) , lime.utils.ByteArray));
	urls.push("sounds/eating_candies.ogg");
	types.push("SOUND");
	urls.push("sounds/hit1.ogg");
	types.push("SOUND");
	urls.push("sounds/hit2.ogg");
	types.push("SOUND");
	urls.push("sounds/hit3.ogg");
	types.push("SOUND");
	urls.push("sounds/hit4.ogg");
	types.push("SOUND");
	urls.push("sounds/menu_open.ogg");
	types.push("SOUND");
	urls.push("sounds/new_level_unlocked.ogg");
	types.push("SOUND");
	urls.push("sounds/pinata_crack.ogg");
	types.push("SOUND");
	urls.push("sounds/purchase.ogg");
	types.push("SOUND");
	urls.push("sounds/eating_candies.mp3");
	types.push("SOUND");
	urls.push("sounds/hit1.mp3");
	types.push("SOUND");
	urls.push("sounds/hit2.mp3");
	types.push("SOUND");
	urls.push("sounds/hit3.mp3");
	types.push("SOUND");
	urls.push("sounds/hit4.mp3");
	types.push("SOUND");
	urls.push("sounds/menu_open.mp3");
	types.push("SOUND");
	urls.push("sounds/new_level_unlocked.mp3");
	types.push("SOUND");
	urls.push("sounds/pinata_crack.mp3");
	types.push("SOUND");
	urls.push("sounds/purchase.mp3");
	types.push("SOUND");
	urls.push("musics/music_loop.ogg");
	types.push("MUSIC");
	urls.push("musics/music_loop.mp3");
	types.push("MUSIC");
	urls.push("images/atlas_0.json");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__images_atlas_0_json,[]) , lime.utils.ByteArray));
	urls.push("images/atlas_0.png");
	types.push("IMAGE");
	urls.push("images/atlas_1.json");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__images_atlas_1_json,[]) , lime.utils.ByteArray));
	urls.push("images/atlas_1.png");
	types.push("IMAGE");
	urls.push("images/atlas_2.json");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__images_atlas_2_json,[]) , lime.utils.ByteArray));
	urls.push("images/atlas_2.png");
	types.push("IMAGE");
	urls.push("images/backs/back1.jpg");
	types.push("IMAGE");
	urls.push("images/backs/back2.jpg");
	types.push("IMAGE");
	urls.push("images/backs/back3.jpg");
	types.push("IMAGE");
	urls.push("images/backs/bonus.jpg");
	types.push("IMAGE");
	urls.push("images/fonts/purple/kern.txt");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__images_fonts_purple_kern_txt,[]) , lime.utils.ByteArray));
	urls.push("images/fonts/yellow_big/kern.txt");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__images_fonts_yellow_big_kern_txt,[]) , lime.utils.ByteArray));
	urls.push("images/fonts/yellow_small/kern.txt");
	types.push("TEXT");
	ApplicationMain.embeddedFiles.push(js.Boot.__cast(Type.createInstance(__ASSET__images_fonts_yellow_small_kern_txt,[]) , lime.utils.ByteArray));
	urls.push("images/missions/paintings/paint3.jpg");
	types.push("IMAGE");
	urls.push("images/missions/paintings/paint4.jpg");
	types.push("IMAGE");
	urls.push("images/missions/paintings/paint6.jpg");
	types.push("IMAGE");
	if(ApplicationMain.config.assetsPrefix != null) {
		var _g1 = 0;
		var _g = urls.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(types[i] != "FONT") urls[i] = ApplicationMain.config.assetsPrefix + urls[i];
		}
	}
	ApplicationMain.preloader.load(urls,types);
	var result = app.exec();
};
ApplicationMain.init = function() {
	var loaded = 0;
	var total = 0;
	var library_onLoad = function(__) {
		loaded++;
		if(loaded == total) ApplicationMain.start();
	};
	ApplicationMain.preloader = null;
	if(loaded == total) ApplicationMain.start();
};
ApplicationMain.main = function() {
	ApplicationMain.config = { antialiasing : 0, background : 0, borderless : false, depthBuffer : false, fps : 0, fullscreen : false, height : 480, orientation : "portrait", resizable : true, stencilBuffer : false, title : "Pinata", vsync : false, width : 320};
};
ApplicationMain.start = function() {
	var hasMain = false;
	var entryPoint = Type.resolveClass("Main");
	var _g = 0;
	var _g1 = Type.getClassFields(entryPoint);
	while(_g < _g1.length) {
		var methodName = _g1[_g];
		++_g;
		if(methodName == "main") {
			hasMain = true;
			break;
		}
	}
	if(hasMain) Reflect.callMethod(entryPoint,Reflect.field(entryPoint,"main"),[]); else {
		var instance = Type.createInstance(DocumentClass,[]);
	}
	openfl.Lib.current.stage.dispatchEvent(new openfl.events.Event(openfl.events.Event.RESIZE,false,false));
};
var openfl = {};
openfl.events = {};
openfl.events.IEventDispatcher = function() { };
$hxClasses["openfl.events.IEventDispatcher"] = openfl.events.IEventDispatcher;
openfl.events.IEventDispatcher.__name__ = ["openfl","events","IEventDispatcher"];
openfl.events.IEventDispatcher.prototype = {
	__class__: openfl.events.IEventDispatcher
};
openfl.events.EventDispatcher = function(target) {
	if(target != null) this.__targetDispatcher = target;
};
$hxClasses["openfl.events.EventDispatcher"] = openfl.events.EventDispatcher;
openfl.events.EventDispatcher.__name__ = ["openfl","events","EventDispatcher"];
openfl.events.EventDispatcher.__interfaces__ = [openfl.events.IEventDispatcher];
openfl.events.EventDispatcher.__sortByPriority = function(l1,l2) {
	if(l1.priority == l2.priority) return 0; else if(l1.priority > l2.priority) return -1; else return 1;
};
openfl.events.EventDispatcher.prototype = {
	addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) useWeakReference = false;
		if(priority == null) priority = 0;
		if(useCapture == null) useCapture = false;
		if(this.__eventMap == null) this.__eventMap = new haxe.ds.StringMap();
		if(!this.__eventMap.exists(type)) {
			var list = new Array();
			list.push(new openfl.events._EventDispatcher.Listener(listener,useCapture,priority));
			this.__eventMap.set(type,list);
		} else {
			var list1 = this.__eventMap.get(type);
			var _g1 = 0;
			var _g = list1.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(Reflect.compareMethods(list1[i].callback,listener)) return;
			}
			list1.push(new openfl.events._EventDispatcher.Listener(listener,useCapture,priority));
			list1.sort(openfl.events.EventDispatcher.__sortByPriority);
		}
	}
	,dispatchEvent: function(event) {
		if(this.__eventMap == null || event == null) return false;
		var list = this.__eventMap.get(event.type);
		if(list == null) return false;
		if(event.target == null) {
			if(this.__targetDispatcher != null) event.target = this.__targetDispatcher; else event.target = this;
		}
		event.currentTarget = this;
		var capture = event.eventPhase == openfl.events.EventPhase.CAPTURING_PHASE;
		var index = 0;
		var listener;
		while(index < list.length) {
			listener = list[index];
			if(listener.useCapture == capture) {
				listener.callback(event);
				if(event.__isCancelledNow) return true;
			}
			if(listener == list[index]) index++;
		}
		return true;
	}
	,hasEventListener: function(type) {
		if(this.__eventMap == null) return false;
		return this.__eventMap.exists(type);
	}
	,removeEventListener: function(type,listener,capture) {
		if(capture == null) capture = false;
		if(this.__eventMap == null) return;
		var list = this.__eventMap.get(type);
		if(list == null) return;
		var _g1 = 0;
		var _g = list.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(list[i].match(listener,capture)) {
				list.splice(i,1);
				break;
			}
		}
		if(list.length == 0) this.__eventMap.remove(type);
		if(!this.__eventMap.iterator().hasNext()) this.__eventMap = null;
	}
	,toString: function() {
		var full = Type.getClassName(Type.getClass(this));
		var $short = full.split(".").pop();
		return "[object " + $short + "]";
	}
	,willTrigger: function(type) {
		return this.hasEventListener(type);
	}
	,__class__: openfl.events.EventDispatcher
};
openfl.display = {};
openfl.display.IBitmapDrawable = function() { };
$hxClasses["openfl.display.IBitmapDrawable"] = openfl.display.IBitmapDrawable;
openfl.display.IBitmapDrawable.__name__ = ["openfl","display","IBitmapDrawable"];
openfl.display.IBitmapDrawable.prototype = {
	__class__: openfl.display.IBitmapDrawable
};
openfl.display.DisplayObject = function() {
	openfl.events.EventDispatcher.call(this);
	this.__alpha = 1;
	this.__rotation = 0;
	this.__scaleX = 1;
	this.__scaleY = 1;
	this.__visible = true;
	this.__x = 0;
	this.__y = 0;
	this.__worldAlpha = 1;
	this.__worldTransform = new openfl.geom.Matrix();
	this.__rotationCache = 0;
	this.__rotationSine = 0;
	this.__rotationCosine = 1;
	this.set_name("instance" + ++openfl.display.DisplayObject.__instanceCount);
};
$hxClasses["openfl.display.DisplayObject"] = openfl.display.DisplayObject;
openfl.display.DisplayObject.__name__ = ["openfl","display","DisplayObject"];
openfl.display.DisplayObject.__interfaces__ = [openfl.display.IBitmapDrawable];
openfl.display.DisplayObject.__super__ = openfl.events.EventDispatcher;
openfl.display.DisplayObject.prototype = $extend(openfl.events.EventDispatcher.prototype,{
	dispatchEvent: function(event) {
		var result = openfl.events.EventDispatcher.prototype.dispatchEvent.call(this,event);
		if(event.__isCancelled) return true;
		if(event.bubbles && this.parent != null && this.parent != this) {
			event.eventPhase = openfl.events.EventPhase.BUBBLING_PHASE;
			this.parent.dispatchEvent(event);
		}
		return result;
	}
	,getBounds: function(targetCoordinateSpace) {
		var matrix = this.__getTransform();
		if(targetCoordinateSpace != null) {
			matrix = new openfl.geom.Matrix(matrix.a,matrix.b,matrix.c,matrix.d,matrix.tx,matrix.ty);
			matrix.concat(targetCoordinateSpace.__worldTransform.clone().invert());
		}
		var bounds = new openfl.geom.Rectangle();
		this.__getBounds(bounds,matrix);
		return bounds;
	}
	,getRect: function(targetCoordinateSpace) {
		return this.getBounds(targetCoordinateSpace);
	}
	,globalToLocal: function(pos) {
		return this.__getTransform().clone().invert().transformPoint(pos);
	}
	,hitTestObject: function(obj) {
		if(obj != null && obj.parent != null && this.parent != null) {
			var currentBounds = this.getBounds(this);
			var targetBounds = obj.getBounds(this);
			return currentBounds.intersects(targetBounds);
		}
		return false;
	}
	,hitTestPoint: function(x,y,shapeFlag) {
		if(shapeFlag == null) shapeFlag = false;
		if(this.parent != null) {
			var currentBounds = this.getBounds(this);
			return currentBounds.containsPoint(new openfl.geom.Point(x,y));
		}
		return false;
	}
	,localToGlobal: function(point) {
		return this.__getTransform().transformPoint(point);
	}
	,__broadcast: function(event,notifyChilden) {
		if(this.__eventMap != null && this.hasEventListener(event.type)) {
			var result = openfl.events.EventDispatcher.prototype.dispatchEvent.call(this,event);
			if(event.__isCancelled) return true;
			return result;
		}
		return false;
	}
	,__getBounds: function(rect,matrix) {
	}
	,__getInteractive: function(stack) {
	}
	,__getLocalBounds: function(rect) {
		this.__getTransform();
		this.__getBounds(rect,new openfl.geom.Matrix());
	}
	,__getTransform: function() {
		if(this.__transformDirty || openfl.display.DisplayObject.__worldTransformDirty > 0) {
			var list = [];
			var current = this;
			var transformDirty = this.__transformDirty;
			if(this.parent == null) {
				if(transformDirty) this.__update(true,false);
			} else while(current.parent != null) {
				list.push(current);
				current = current.parent;
				if(current.__transformDirty) transformDirty = true;
			}
			if(transformDirty) {
				var i = list.length;
				while(--i >= 0) list[i].__update(true,false);
			}
		}
		return this.__worldTransform;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly) {
		return false;
	}
	,__renderCanvas: function(renderSession) {
	}
	,__renderDOM: function(renderSession) {
	}
	,__renderGL: function(renderSession) {
	}
	,__renderMask: function(renderSession) {
	}
	,__setStageReference: function(stage) {
		if(this.stage != stage) {
			if(this.stage != null) this.dispatchEvent(new openfl.events.Event(openfl.events.Event.REMOVED_FROM_STAGE,false,false));
			this.stage = stage;
			if(stage != null) this.dispatchEvent(new openfl.events.Event(openfl.events.Event.ADDED_TO_STAGE,false,false));
		}
	}
	,__setRenderDirty: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			openfl.display.DisplayObject.__worldRenderDirty++;
		}
	}
	,__setTransformDirty: function() {
		if(!this.__transformDirty) {
			this.__transformDirty = true;
			openfl.display.DisplayObject.__worldTransformDirty++;
		}
	}
	,__update: function(transformOnly,updateChildren) {
		this.__renderable = this.get_visible() && this.get_scaleX() != 0 && this.get_scaleY() != 0 && !this.__isMask;
		if(this.get_rotation() != this.__rotationCache) {
			this.__rotationCache = this.get_rotation();
			var radians = this.get_rotation() * (Math.PI / 180);
			this.__rotationSine = Math.sin(radians);
			this.__rotationCosine = Math.cos(radians);
		}
		if(this.parent != null) {
			var parentTransform = this.parent.__worldTransform;
			var a00 = this.__rotationCosine * this.get_scaleX();
			var a01 = this.__rotationSine * this.get_scaleX();
			var a10 = -this.__rotationSine * this.get_scaleY();
			var a11 = this.__rotationCosine * this.get_scaleY();
			var b00 = parentTransform.a;
			var b01 = parentTransform.b;
			var b10 = parentTransform.c;
			var b11 = parentTransform.d;
			if(this.__worldTransform == null) this.__worldTransform = new openfl.geom.Matrix();
			this.__worldTransform.a = a00 * b00 + a01 * b10;
			this.__worldTransform.b = a00 * b01 + a01 * b11;
			this.__worldTransform.c = a10 * b00 + a11 * b10;
			this.__worldTransform.d = a10 * b01 + a11 * b11;
			if(this.get_scrollRect() == null) {
				this.__worldTransform.tx = this.get_x() * b00 + this.get_y() * b10 + parentTransform.tx;
				this.__worldTransform.ty = this.get_x() * b01 + this.get_y() * b11 + parentTransform.ty;
			} else {
				this.__worldTransform.tx = (this.get_x() - this.get_scrollRect().x) * b00 + (this.get_y() - this.get_scrollRect().y) * b10 + parentTransform.tx;
				this.__worldTransform.ty = (this.get_x() - this.get_scrollRect().x) * b01 + (this.get_y() - this.get_scrollRect().y) * b11 + parentTransform.ty;
			}
		} else {
			this.__worldTransform.a = this.__rotationCosine * this.get_scaleX();
			this.__worldTransform.c = -this.__rotationSine * this.get_scaleY();
			this.__worldTransform.b = this.__rotationSine * this.get_scaleX();
			this.__worldTransform.d = this.__rotationCosine * this.get_scaleY();
			if(this.get_scrollRect() == null) {
				this.__worldTransform.tx = this.get_x();
				this.__worldTransform.ty = this.get_y();
			} else {
				this.__worldTransform.tx = this.get_y() - this.get_scrollRect().x;
				this.__worldTransform.ty = this.get_y() - this.get_scrollRect().y;
			}
		}
		if(updateChildren && this.__transformDirty) {
			this.__transformDirty = false;
			openfl.display.DisplayObject.__worldTransformDirty--;
		}
		if(!transformOnly) {
			if(this.parent != null) this.__worldAlpha = this.get_alpha() * this.parent.__worldAlpha; else this.__worldAlpha = this.get_alpha();
			if(updateChildren && this.__renderDirty) this.__renderDirty = false;
		}
	}
	,__updateChildren: function(transformOnly) {
		this.__renderable = this.get_visible() && this.get_scaleX() != 0 && this.get_scaleY() != 0 && !this.__isMask;
		if(!this.__renderable && !this.__isMask) return;
		this.__worldAlpha = this.get_alpha();
		if(this.__transformDirty) {
			this.__transformDirty = false;
			openfl.display.DisplayObject.__worldTransformDirty--;
		}
	}
	,get_alpha: function() {
		return this.__alpha;
	}
	,set_alpha: function(value) {
		if(value != this.__alpha) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				openfl.display.DisplayObject.__worldRenderDirty++;
			}
		}
		return this.__alpha = value;
	}
	,get_filters: function() {
		if(this.__filters == null) return new Array(); else return this.__filters.slice();
	}
	,set_filters: function(value) {
		return value;
	}
	,get_height: function() {
		var bounds = new openfl.geom.Rectangle();
		this.__getTransform();
		this.__getBounds(bounds,new openfl.geom.Matrix());
		return bounds.height * this.get_scaleY();
	}
	,set_height: function(value) {
		var bounds = new openfl.geom.Rectangle();
		this.__getTransform();
		this.__getBounds(bounds,new openfl.geom.Matrix());
		if(value != bounds.height) this.set_scaleY(value / bounds.height); else this.set_scaleY(1);
		return value;
	}
	,get_mask: function() {
		return this.__mask;
	}
	,set_mask: function(value) {
		if(value != this.__mask) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				openfl.display.DisplayObject.__worldRenderDirty++;
			}
		}
		if(this.__mask != null) this.__mask.__isMask = false;
		if(value != null) value.__isMask = true;
		return this.__mask = value;
	}
	,get_mouseX: function() {
		if(this.stage != null) return this.globalToLocal(new openfl.geom.Point(this.stage.__mouseX,0)).x;
		return 0;
	}
	,get_mouseY: function() {
		if(this.stage != null) return this.globalToLocal(new openfl.geom.Point(0,this.stage.__mouseY)).y;
		return 0;
	}
	,get_name: function() {
		return this.__name;
	}
	,set_name: function(value) {
		return this.__name = value;
	}
	,get_root: function() {
		if(this.stage != null) return openfl.Lib.current;
		return null;
	}
	,get_rotation: function() {
		return this.__rotation;
	}
	,set_rotation: function(value) {
		if(value != this.__rotation) {
			if(!this.__transformDirty) {
				this.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
		}
		return this.__rotation = value;
	}
	,get_scaleX: function() {
		return this.__scaleX;
	}
	,set_scaleX: function(value) {
		if(value != this.__scaleX) {
			if(!this.__transformDirty) {
				this.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
		}
		return this.__scaleX = value;
	}
	,get_scaleY: function() {
		return this.__scaleY;
	}
	,set_scaleY: function(value) {
		if(this.__scaleY != value) {
			if(!this.__transformDirty) {
				this.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
		}
		return this.__scaleY = value;
	}
	,get_scrollRect: function() {
		return this.__scrollRect;
	}
	,set_scrollRect: function(value) {
		if(value != this.__scrollRect) {
			if(!this.__transformDirty) {
				this.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
		}
		return this.__scrollRect = value;
	}
	,get_transform: function() {
		if(this.__transform == null) this.__transform = new openfl.geom.Transform(this);
		return this.__transform;
	}
	,set_transform: function(value) {
		if(value == null) throw new openfl.errors.TypeError("Parameter transform must be non-null.");
		if(this.__transform == null) this.__transform = new openfl.geom.Transform(this);
		if(!this.__transformDirty) {
			this.__transformDirty = true;
			openfl.display.DisplayObject.__worldTransformDirty++;
		}
		this.__transform.set_matrix(value.get_matrix().clone());
		this.__transform.set_colorTransform(new openfl.geom.ColorTransform(value.get_colorTransform().redMultiplier,value.get_colorTransform().greenMultiplier,value.get_colorTransform().blueMultiplier,value.get_colorTransform().alphaMultiplier,value.get_colorTransform().redOffset,value.get_colorTransform().greenOffset,value.get_colorTransform().blueOffset,value.get_colorTransform().alphaOffset));
		return this.__transform;
	}
	,get_visible: function() {
		return this.__visible;
	}
	,set_visible: function(value) {
		if(value != this.__visible) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				openfl.display.DisplayObject.__worldRenderDirty++;
			}
		}
		return this.__visible = value;
	}
	,get_width: function() {
		var bounds = new openfl.geom.Rectangle();
		this.__getTransform();
		this.__getBounds(bounds,new openfl.geom.Matrix());
		return bounds.width * this.get_scaleX();
	}
	,set_width: function(value) {
		var bounds = new openfl.geom.Rectangle();
		this.__getTransform();
		this.__getBounds(bounds,new openfl.geom.Matrix());
		if(value != bounds.width) this.set_scaleX(value / bounds.width); else this.set_scaleX(1);
		return value;
	}
	,get_x: function() {
		return this.__x;
	}
	,set_x: function(value) {
		if(value != this.__x) {
			if(!this.__transformDirty) {
				this.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
		}
		return this.__x = value;
	}
	,get_y: function() {
		return this.__y;
	}
	,set_y: function(value) {
		if(value != this.__y) {
			if(!this.__transformDirty) {
				this.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
		}
		return this.__y = value;
	}
	,__class__: openfl.display.DisplayObject
	,__properties__: {set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",set_width:"set_width",get_width:"get_width",set_visible:"set_visible",get_visible:"get_visible",set_transform:"set_transform",get_transform:"get_transform",set_scrollRect:"set_scrollRect",get_scrollRect:"get_scrollRect",set_scaleY:"set_scaleY",get_scaleY:"get_scaleY",set_scaleX:"set_scaleX",get_scaleX:"get_scaleX",set_rotation:"set_rotation",get_rotation:"get_rotation",get_root:"get_root",set_name:"set_name",get_name:"get_name",get_mouseY:"get_mouseY",get_mouseX:"get_mouseX",set_mask:"set_mask",get_mask:"get_mask",set_height:"set_height",get_height:"get_height",set_filters:"set_filters",get_filters:"get_filters",set_alpha:"set_alpha",get_alpha:"get_alpha"}
});
openfl.display.InteractiveObject = function() {
	openfl.display.DisplayObject.call(this);
	this.doubleClickEnabled = false;
	this.mouseEnabled = true;
	this.needsSoftKeyboard = false;
	this.tabEnabled = true;
	this.tabIndex = -1;
};
$hxClasses["openfl.display.InteractiveObject"] = openfl.display.InteractiveObject;
openfl.display.InteractiveObject.__name__ = ["openfl","display","InteractiveObject"];
openfl.display.InteractiveObject.__super__ = openfl.display.DisplayObject;
openfl.display.InteractiveObject.prototype = $extend(openfl.display.DisplayObject.prototype,{
	requestSoftKeyboard: function() {
		openfl.Lib.notImplemented("InteractiveObject.requestSoftKeyboard");
		return false;
	}
	,__getInteractive: function(stack) {
		stack.push(this);
		if(this.parent != null) this.parent.__getInteractive(stack);
	}
	,__class__: openfl.display.InteractiveObject
});
openfl.display.DisplayObjectContainer = function() {
	openfl.display.InteractiveObject.call(this);
	this.mouseChildren = true;
	this.__children = new Array();
	this.__removedChildren = new Array();
};
$hxClasses["openfl.display.DisplayObjectContainer"] = openfl.display.DisplayObjectContainer;
openfl.display.DisplayObjectContainer.__name__ = ["openfl","display","DisplayObjectContainer"];
openfl.display.DisplayObjectContainer.__super__ = openfl.display.InteractiveObject;
openfl.display.DisplayObjectContainer.prototype = $extend(openfl.display.InteractiveObject.prototype,{
	addChild: function(child) {
		if(child != null) {
			if(child.parent != null) child.parent.removeChild(child);
			this.__children.push(child);
			child.parent = this;
			if(this.stage != null) child.__setStageReference(this.stage);
			if(!child.__transformDirty) {
				child.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				openfl.display.DisplayObject.__worldRenderDirty++;
			}
			var event = new openfl.events.Event(openfl.events.Event.ADDED,true);
			event.target = child;
			child.dispatchEvent(event);
		}
		return child;
	}
	,addChildAt: function(child,index) {
		if(index > this.__children.length || index < 0) throw "Invalid index position " + index;
		if(child.parent == this) HxOverrides.remove(this.__children,child); else {
			if(child.parent != null) child.parent.removeChild(child);
			child.parent = this;
			if(this.stage != null) child.__setStageReference(this.stage);
			if(!child.__transformDirty) {
				child.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				openfl.display.DisplayObject.__worldRenderDirty++;
			}
			var event = new openfl.events.Event(openfl.events.Event.ADDED,true);
			event.target = child;
			child.dispatchEvent(event);
		}
		this.__children.splice(index,0,child);
		return child;
	}
	,areInaccessibleObjectsUnderPoint: function(point) {
		return false;
	}
	,contains: function(child) {
		return HxOverrides.indexOf(this.__children,child,0) > -1;
	}
	,getChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) return this.__children[index];
		return null;
	}
	,getChildByName: function(name) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == name) return child;
		}
		return null;
	}
	,getChildIndex: function(child) {
		var _g1 = 0;
		var _g = this.__children.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.__children[i] == child) return i;
		}
		return -1;
	}
	,getObjectsUnderPoint: function(point) {
		point = this.localToGlobal(point);
		var stack = new Array();
		this.__hitTest(point.x,point.y,false,stack,false);
		stack.reverse();
		return stack;
	}
	,removeChild: function(child) {
		if(child != null && child.parent == this) {
			if(this.stage != null) child.__setStageReference(null);
			child.parent = null;
			HxOverrides.remove(this.__children,child);
			this.__removedChildren.push(child);
			if(!child.__transformDirty) {
				child.__transformDirty = true;
				openfl.display.DisplayObject.__worldTransformDirty++;
			}
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				openfl.display.DisplayObject.__worldRenderDirty++;
			}
			child.dispatchEvent(new openfl.events.Event(openfl.events.Event.REMOVED,true));
		}
		return child;
	}
	,removeChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) return this.removeChild(this.__children[index]);
		return null;
	}
	,removeChildren: function(beginIndex,endIndex) {
		if(endIndex == null) endIndex = 2147483647;
		if(beginIndex == null) beginIndex = 0;
		if(endIndex == 2147483647) {
			endIndex = this.__children.length - 1;
			if(endIndex < 0) return;
		}
		if(beginIndex > this.__children.length - 1) return; else if(endIndex < beginIndex || beginIndex < 0 || endIndex > this.__children.length) throw new openfl.errors.RangeError("The supplied index is out of bounds.");
		var numRemovals = endIndex - beginIndex;
		while(numRemovals >= 0) {
			this.removeChildAt(beginIndex);
			numRemovals--;
		}
	}
	,setChildIndex: function(child,index) {
		if(index >= 0 && index <= this.__children.length && child.parent == this) {
			HxOverrides.remove(this.__children,child);
			this.__children.splice(index,0,child);
		}
	}
	,swapChildren: function(child1,child2) {
		if(child1.parent == this && child2.parent == this) {
			var index1 = HxOverrides.indexOf(this.__children,child1,0);
			var index2 = HxOverrides.indexOf(this.__children,child2,0);
			this.__children[index1] = child2;
			this.__children[index2] = child1;
		}
	}
	,swapChildrenAt: function(child1,child2) {
		var swap = this.__children[child1];
		this.__children[child1] = this.__children[child2];
		this.__children[child2] = swap;
		swap = null;
	}
	,__broadcast: function(event,notifyChilden) {
		if(event.target == null) event.target = this;
		if(notifyChilden) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__broadcast(event,true);
				if(event.__isCancelled) return true;
			}
		}
		return openfl.display.InteractiveObject.prototype.__broadcast.call(this,event,notifyChilden);
	}
	,__getBounds: function(rect,matrix) {
		if(this.__children.length == 0) return;
		var matrixCache = null;
		if(matrix != null) {
			matrixCache = this.__worldTransform;
			this.__worldTransform = matrix;
			this.__updateChildren(true);
		}
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(!child.__renderable) continue;
			child.__getBounds(rect,null);
		}
		if(matrix != null) {
			this.__worldTransform = matrixCache;
			this.__updateChildren(true);
		}
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly) {
		if(!this.get_visible() || interactiveOnly && !this.mouseEnabled) return false;
		var i = this.__children.length;
		if(interactiveOnly) {
			if(stack == null || !this.mouseChildren) {
				while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,null,true)) {
					if(stack != null) stack.push(this);
					return true;
				}
			} else if(stack != null) {
				var length = stack.length;
				while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,stack,interactiveOnly)) {
					stack.splice(length,0,this);
					return true;
				}
			}
		} else while(--i >= 0) this.__children[i].__hitTest(x,y,shapeFlag,stack,false);
		return false;
	}
	,__renderCanvas: function(renderSession) {
		if(!this.__renderable || this.__worldAlpha <= 0) return;
		if(this.get_scrollRect() != null) {
		}
		if(this.__mask != null) renderSession.maskManager.pushMask(this.__mask);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__renderCanvas(renderSession);
		}
		this.__removedChildren = [];
		if(this.__mask != null) renderSession.maskManager.popMask();
		if(this.get_scrollRect() != null) {
		}
	}
	,__renderDOM: function(renderSession) {
		if(this.__mask != null) renderSession.maskManager.pushMask(this.__mask);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__renderDOM(renderSession);
		}
		var _g2 = 0;
		var _g11 = this.__removedChildren;
		while(_g2 < _g11.length) {
			var orphan = _g11[_g2];
			++_g2;
			if(orphan.stage == null) orphan.__renderDOM(renderSession);
		}
		this.__removedChildren = [];
		if(this.__mask != null) renderSession.maskManager.popMask();
	}
	,__renderGL: function(renderSession) {
		if(!this.__renderable || this.__worldAlpha <= 0) return;
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__renderGL(renderSession);
		}
		this.__removedChildren = [];
	}
	,__renderMask: function(renderSession) {
		var bounds = new openfl.geom.Rectangle();
		this.__getTransform();
		this.__getBounds(bounds,new openfl.geom.Matrix());
		renderSession.context.rect(0,0,bounds.width,bounds.height);
	}
	,__setStageReference: function(stage) {
		if(this.stage != stage) {
			if(this.stage != null) this.dispatchEvent(new openfl.events.Event(openfl.events.Event.REMOVED_FROM_STAGE,false,false));
			this.stage = stage;
			if(stage != null) this.dispatchEvent(new openfl.events.Event(openfl.events.Event.ADDED_TO_STAGE,false,false));
			if(this.__children != null) {
				var _g = 0;
				var _g1 = this.__children;
				while(_g < _g1.length) {
					var child = _g1[_g];
					++_g;
					child.__setStageReference(stage);
				}
			}
		}
	}
	,__update: function(transformOnly,updateChildren) {
		openfl.display.InteractiveObject.prototype.__update.call(this,transformOnly,updateChildren);
		if(!this.__renderable) return;
		if(updateChildren) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__update(transformOnly,true);
			}
		}
	}
	,__updateChildren: function(transformOnly) {
		openfl.display.InteractiveObject.prototype.__updateChildren.call(this,transformOnly);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__update(transformOnly,true);
		}
	}
	,get_numChildren: function() {
		return this.__children.length;
	}
	,__class__: openfl.display.DisplayObjectContainer
	,__properties__: $extend(openfl.display.InteractiveObject.prototype.__properties__,{get_numChildren:"get_numChildren"})
});
openfl.display.Sprite = function() {
	openfl.display.DisplayObjectContainer.call(this);
	this.buttonMode = false;
	this.useHandCursor = true;
	this.loaderInfo = openfl.display.LoaderInfo.create(null);
};
$hxClasses["openfl.display.Sprite"] = openfl.display.Sprite;
openfl.display.Sprite.__name__ = ["openfl","display","Sprite"];
openfl.display.Sprite.__super__ = openfl.display.DisplayObjectContainer;
openfl.display.Sprite.prototype = $extend(openfl.display.DisplayObjectContainer.prototype,{
	startDrag: function(lockCenter,bounds) {
		if(lockCenter == null) lockCenter = false;
		if(this.stage != null) this.stage.__startDrag(this,lockCenter,bounds);
	}
	,stopDrag: function() {
		if(this.stage != null) this.stage.__stopDrag(this);
	}
	,__getBounds: function(rect,matrix) {
		openfl.display.DisplayObjectContainer.prototype.__getBounds.call(this,rect,matrix);
		if(this.__graphics != null) this.__graphics.__getBounds(rect,matrix != null?matrix:this.__worldTransform);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly) {
		if(!this.get_visible() || interactiveOnly && !this.mouseEnabled) return false;
		var length = 0;
		if(stack != null) length = stack.length;
		if(openfl.display.DisplayObjectContainer.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly)) return interactiveOnly; else if(this.__graphics != null && this.__graphics.__hitTest(x,y,shapeFlag,this.__getTransform())) {
			if(stack != null) stack.push(this);
			return true;
		}
		return false;
	}
	,__renderCanvas: function(renderSession) {
		openfl._internal.renderer.canvas.CanvasShape.render(this,renderSession);
		openfl.display.DisplayObjectContainer.prototype.__renderCanvas.call(this,renderSession);
	}
	,__renderDOM: function(renderSession) {
		openfl._internal.renderer.dom.DOMShape.render(this,renderSession);
		openfl.display.DisplayObjectContainer.prototype.__renderDOM.call(this,renderSession);
	}
	,__renderGL: function(renderSession) {
		if(!this.__renderable || this.__worldAlpha <= 0) return;
		if(this.__graphics != null) openfl._internal.renderer.opengl.utils.GraphicsRenderer.render(this,renderSession);
		openfl.display.DisplayObjectContainer.prototype.__renderGL.call(this,renderSession);
	}
	,__renderMask: function(renderSession) {
		if(this.__graphics != null) openfl._internal.renderer.canvas.CanvasGraphics.renderMask(this.__graphics,renderSession); else openfl.display.DisplayObjectContainer.prototype.__renderMask.call(this,renderSession);
	}
	,get_graphics: function() {
		if(this.__graphics == null) this.__graphics = new openfl.display.Graphics();
		return this.__graphics;
	}
	,__class__: openfl.display.Sprite
	,__properties__: $extend(openfl.display.DisplayObjectContainer.prototype.__properties__,{get_graphics:"get_graphics"})
});
var Main = function() {
	openfl.display.Sprite.call(this);
	this.addEventListener(openfl.events.Event.ADDED_TO_STAGE,$bind(this,this.handleAddedToStage));
};
$hxClasses["Main"] = Main;
Main.__name__ = ["Main"];
Main.__super__ = openfl.display.Sprite;
Main.prototype = $extend(openfl.display.Sprite.prototype,{
	handleAddedToStage: function(e) {
		this.removeEventListener(openfl.events.Event.ADDED_TO_STAGE,$bind(this,this.handleAddedToStage));
		this.addChild(new co.doubleduck.pinata.Game());
	}
	,__class__: Main
});
var DocumentClass = function() {
	openfl.Lib.current.addChild(this);
	Main.call(this);
	this.dispatchEvent(new openfl.events.Event(openfl.events.Event.ADDED_TO_STAGE,false,false));
};
$hxClasses["DocumentClass"] = DocumentClass;
DocumentClass.__name__ = ["DocumentClass"];
DocumentClass.__super__ = Main;
DocumentClass.prototype = $extend(Main.prototype,{
	__class__: DocumentClass
});
var DateTools = function() { };
$hxClasses["DateTools"] = DateTools;
DateTools.__name__ = ["DateTools"];
DateTools.__format_get = function(d,e) {
	switch(e) {
	case "%":
		return "%";
	case "C":
		return StringTools.lpad(Std.string(Std["int"](d.getFullYear() / 100)),"0",2);
	case "d":
		return StringTools.lpad(Std.string(d.getDate()),"0",2);
	case "D":
		return DateTools.__format(d,"%m/%d/%y");
	case "e":
		return Std.string(d.getDate());
	case "H":case "k":
		return StringTools.lpad(Std.string(d.getHours()),e == "H"?"0":" ",2);
	case "I":case "l":
		var hour = d.getHours() % 12;
		return StringTools.lpad(Std.string(hour == 0?12:hour),e == "I"?"0":" ",2);
	case "m":
		return StringTools.lpad(Std.string(d.getMonth() + 1),"0",2);
	case "M":
		return StringTools.lpad(Std.string(d.getMinutes()),"0",2);
	case "n":
		return "\n";
	case "p":
		if(d.getHours() > 11) return "PM"; else return "AM";
		break;
	case "r":
		return DateTools.__format(d,"%I:%M:%S %p");
	case "R":
		return DateTools.__format(d,"%H:%M");
	case "s":
		return Std.string(Std["int"](d.getTime() / 1000));
	case "S":
		return StringTools.lpad(Std.string(d.getSeconds()),"0",2);
	case "t":
		return "\t";
	case "T":
		return DateTools.__format(d,"%H:%M:%S");
	case "u":
		var t = d.getDay();
		if(t == 0) return "7"; else if(t == null) return "null"; else return "" + t;
		break;
	case "w":
		return Std.string(d.getDay());
	case "y":
		return StringTools.lpad(Std.string(d.getFullYear() % 100),"0",2);
	case "Y":
		return Std.string(d.getFullYear());
	default:
		throw "Date.format %" + e + "- not implemented yet.";
	}
};
DateTools.__format = function(d,f) {
	var r = new StringBuf();
	var p = 0;
	while(true) {
		var np = f.indexOf("%",p);
		if(np < 0) break;
		r.addSub(f,p,np - p);
		r.add(DateTools.__format_get(d,HxOverrides.substr(f,np + 1,1)));
		p = np + 2;
	}
	r.addSub(f,p,f.length - p);
	return r.b;
};
DateTools.format = function(d,f) {
	return DateTools.__format(d,f);
};
lime.AssetLibrary = function() {
};
$hxClasses["lime.AssetLibrary"] = lime.AssetLibrary;
lime.AssetLibrary.__name__ = ["lime","AssetLibrary"];
lime.AssetLibrary.prototype = {
	exists: function(id,type) {
		return false;
	}
	,getAudioBuffer: function(id) {
		return null;
	}
	,getBytes: function(id) {
		return null;
	}
	,getFont: function(id) {
		return null;
	}
	,getImage: function(id) {
		return null;
	}
	,getPath: function(id) {
		return null;
	}
	,getText: function(id) {
		var bytes = this.getBytes(id);
		if(bytes == null) return null; else return bytes.readUTFBytes(bytes.length);
	}
	,isLocal: function(id,type) {
		return true;
	}
	,list: function(type) {
		return null;
	}
	,load: function(handler) {
		handler(this);
	}
	,loadAudioBuffer: function(id,handler) {
		handler(this.getAudioBuffer(id));
	}
	,loadBytes: function(id,handler) {
		handler(this.getBytes(id));
	}
	,loadFont: function(id,handler) {
		handler(this.getFont(id));
	}
	,loadImage: function(id,handler) {
		handler(this.getImage(id));
	}
	,loadText: function(id,handler) {
		var callback = function(bytes) {
			if(bytes == null) handler(null); else handler(bytes.readUTFBytes(bytes.length));
		};
		this.loadBytes(id,callback);
	}
	,__class__: lime.AssetLibrary
};
var DefaultAssetLibrary = function() {
	this.atlasAssets = new haxe.ds.StringMap();
	this.type = new haxe.ds.StringMap();
	this.path = new haxe.ds.StringMap();
	this.className = new haxe.ds.StringMap();
	lime.AssetLibrary.call(this);
	var id;
	id = "data/gameplay.js";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "sounds/eating_candies.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit1.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit2.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit3.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit4.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/menu_open.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/new_level_unlocked.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/pinata_crack.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/purchase.ogg";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/eating_candies.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit1.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit2.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit3.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/hit4.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/menu_open.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/new_level_unlocked.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/pinata_crack.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "sounds/purchase.mp3";
	this.path.set(id,id);
	this.type.set(id,"SOUND");
	id = "musics/music_loop.ogg";
	this.path.set(id,id);
	this.type.set(id,"MUSIC");
	id = "musics/music_loop.mp3";
	this.path.set(id,id);
	this.type.set(id,"MUSIC");
	id = "images/atlas_0.json";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "images/atlas_0.png";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/atlas_1.json";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "images/atlas_1.png";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/atlas_2.json";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "images/atlas_2.png";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/backs/back1.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/backs/back2.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/backs/back3.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/backs/bonus.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/fonts/purple/kern.txt";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "images/fonts/yellow_big/kern.txt";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "images/fonts/yellow_small/kern.txt";
	this.path.set(id,id);
	this.type.set(id,"TEXT");
	id = "images/missions/paintings/paint3.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/missions/paintings/paint4.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	id = "images/missions/paintings/paint6.jpg";
	this.path.set(id,id);
	this.type.set(id,"IMAGE");
	var assetsPrefix = ApplicationMain.config.assetsPrefix;
	if(assetsPrefix != null) {
		var $it0 = this.path.keys();
		while( $it0.hasNext() ) {
			var k = $it0.next();
			var value = assetsPrefix + this.path.get(k);
			this.path.set(k,value);
		}
	}
	this.addAssetsFromAtlas();
};
$hxClasses["DefaultAssetLibrary"] = DefaultAssetLibrary;
DefaultAssetLibrary.__name__ = ["DefaultAssetLibrary"];
DefaultAssetLibrary.__super__ = lime.AssetLibrary;
DefaultAssetLibrary.prototype = $extend(lime.AssetLibrary.prototype,{
	addAssetsFromAtlas: function() {
		var $it0 = this.type.keys();
		while( $it0.hasNext() ) {
			var asset = $it0.next();
			if(this.type.get(asset) == "TEXT" && asset.indexOf("atlas") != -1) {
				var json = JSON.parse(this.getText(asset));
				var assetsArr = json.data;
				var atlasFile = asset.split(".")[0] + ".png";
				var atlasBd = this.getImage(atlasFile);
				var _g = 0;
				while(_g < assetsArr.length) {
					var atlasAsset = assetsArr[_g];
					++_g;
					var key = atlasAsset.path;
					this.type.set(key,"IMAGE");
					var bd = new lime.graphics.Image(null,0,0,atlasAsset.width,atlasAsset.height);
					bd.copyPixels(atlasBd,new lime.math.Rectangle(atlasAsset.x,atlasAsset.y,atlasAsset.width,atlasAsset.height),new lime.math.Vector2(0,0));
					var key1 = atlasAsset.path;
					this.atlasAssets.set(key1,bd);
				}
				atlasBd = null;
			}
		}
	}
	,exists: function(id,type) {
		var requestedType;
		if(type != null) requestedType = js.Boot.__cast(type , String); else requestedType = null;
		var assetType = this.type.get(id);
		if(assetType != null) {
			if(assetType == requestedType || (requestedType == "SOUND" || requestedType == "MUSIC") && (assetType == "MUSIC" || assetType == "SOUND")) return true;
			if(requestedType == "BINARY" || requestedType == null || assetType == "BINARY" && requestedType == "TEXT") return true;
		}
		return false;
	}
	,getAudioBuffer: function(id) {
		return null;
	}
	,getBytes: function(id) {
		var bytes = null;
		var data = ((function($this) {
			var $r;
			var key = $this.path.get(id);
			$r = lime.app.Preloader.loaders.get(key);
			return $r;
		}(this))).data;
		if(typeof(data) == "string") {
			bytes = new lime.utils.ByteArray();
			bytes.writeUTFBytes(data);
		} else if(js.Boot.__instanceof(data,lime.utils.ByteArray)) bytes = data; else bytes = null;
		if(bytes != null) {
			bytes.position = 0;
			return bytes;
		} else return null;
	}
	,getFont: function(id) {
		return js.Boot.__cast(Type.createInstance(this.className.get(id),[]) , openfl.text.Font);
		return null;
	}
	,getImage: function(id) {
		if(this.path.get(id) == null) {
			if(this.atlasAssets.exists(id)) {
				var ret = this.atlasAssets.get(id);
				this.atlasAssets.remove(id);
				return ret;
			}
			return null;
		}
		return lime.graphics.Image.fromImageElement((function($this) {
			var $r;
			var key = $this.path.get(id);
			$r = lime.app.Preloader.images.get(key);
			return $r;
		}(this)));
	}
	,getPath: function(id) {
		return this.path.get(id);
	}
	,getText: function(id) {
		var bytes = null;
		var data = ((function($this) {
			var $r;
			var key = $this.path.get(id);
			$r = lime.app.Preloader.loaders.get(key);
			return $r;
		}(this))).data;
		if(typeof(data) == "string") return data; else if(js.Boot.__instanceof(data,lime.utils.ByteArray)) bytes = data; else bytes = null;
		if(bytes != null) {
			bytes.position = 0;
			return bytes.readUTFBytes(bytes.length);
		} else return null;
	}
	,isLocal: function(id,type) {
		var requestedType;
		if(type != null) requestedType = js.Boot.__cast(type , String); else requestedType = null;
		return true;
	}
	,list: function(type) {
		var requestedType;
		if(type != null) requestedType = js.Boot.__cast(type , String); else requestedType = null;
		var items = [];
		var $it0 = this.type.keys();
		while( $it0.hasNext() ) {
			var id = $it0.next();
			if(requestedType == null || this.exists(id,type)) items.push(id);
		}
		return items;
	}
	,loadAudioBuffer: function(id,handler) {
		handler(this.getAudioBuffer(id));
	}
	,loadBytes: function(id,handler) {
		handler(this.getBytes(id));
	}
	,loadImage: function(id,handler) {
		handler(this.getImage(id));
	}
	,loadText: function(id,handler) {
		var callback = function(bytes) {
			if(bytes == null) handler(null); else handler(bytes.readUTFBytes(bytes.length));
		};
		this.loadBytes(id,callback);
	}
	,__class__: DefaultAssetLibrary
});
var EReg = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
$hxClasses["EReg"] = EReg;
EReg.__name__ = ["EReg"];
EReg.prototype = {
	replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,__class__: EReg
};
var GlobalVars = function() { };
$hxClasses["GlobalVars"] = GlobalVars;
GlobalVars.__name__ = ["GlobalVars"];
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
};
HxOverrides.strDate = function(s) {
	var _g = s.length;
	switch(_g) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k1 = s.split("-");
		return new Date(k1[0],k1[1] - 1,k1[2],0,0,0);
	case 19:
		var k2 = s.split(" ");
		var y = k2[0].split("-");
		var t = k2[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
};
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
};
HxOverrides.indexOf = function(a,obj,i) {
	var len = a.length;
	if(i < 0) {
		i += len;
		if(i < 0) i = 0;
	}
	while(i < len) {
		if(a[i] === obj) return i;
		i++;
	}
	return -1;
};
HxOverrides.remove = function(a,obj) {
	var i = HxOverrides.indexOf(a,obj,0);
	if(i == -1) return false;
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Lambda = function() { };
$hxClasses["Lambda"] = Lambda;
Lambda.__name__ = ["Lambda"];
Lambda.exists = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) return true;
	}
	return false;
};
Lambda.filter = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) l.add(x);
	}
	return l;
};
var List = function() {
	this.length = 0;
};
$hxClasses["List"] = List;
List.__name__ = ["List"];
List.prototype = {
	add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,__class__: List
};
var IMap = function() { };
$hxClasses["IMap"] = IMap;
IMap.__name__ = ["IMap"];
IMap.prototype = {
	__class__: IMap
};
Math.__name__ = ["Math"];
var NMEPreloader = function() {
	openfl.display.Sprite.call(this);
	var backgroundColor = this.getBackgroundColor();
	var r = backgroundColor >> 16 & 255;
	var g = backgroundColor >> 8 & 255;
	var b = backgroundColor & 255;
	var perceivedLuminosity = 0.299 * r + 0.587 * g + 0.114 * b;
	var color = 0;
	if(perceivedLuminosity < 70) color = 16777215;
	var x = 30;
	var height = 7;
	var y = this.getHeight() / 2 - height / 2;
	var width = this.getWidth() - x * 2;
	var padding = 2;
	this.outline = new openfl.display.Sprite();
	this.outline.get_graphics().beginFill(color,0.07);
	this.outline.get_graphics().drawRect(0,0,width,height);
	this.outline.set_x(x);
	this.outline.set_y(y);
	this.addChild(this.outline);
	this.progress = new openfl.display.Sprite();
	this.progress.get_graphics().beginFill(color,0.35);
	this.progress.get_graphics().drawRect(0,0,width - padding * 2,height - padding * 2);
	this.progress.set_x(x + padding);
	this.progress.set_y(y + padding);
	this.progress.set_scaleX(0);
	this.addChild(this.progress);
};
$hxClasses["NMEPreloader"] = NMEPreloader;
NMEPreloader.__name__ = ["NMEPreloader"];
NMEPreloader.__super__ = openfl.display.Sprite;
NMEPreloader.prototype = $extend(openfl.display.Sprite.prototype,{
	getBackgroundColor: function() {
		return 0;
	}
	,getHeight: function() {
		var height = 480;
		if(height > 0) return height; else return openfl.Lib.current.stage.stageHeight;
	}
	,getWidth: function() {
		var width = 320;
		if(width > 0) return width; else return openfl.Lib.current.stage.stageWidth;
	}
	,onInit: function() {
	}
	,onLoaded: function() {
		this.dispatchEvent(new openfl.events.Event(openfl.events.Event.COMPLETE));
	}
	,onUpdate: function(bytesLoaded,bytesTotal) {
		var percentLoaded = bytesLoaded / bytesTotal;
		if(percentLoaded > 1) percentLoaded = 1;
		this.progress.set_scaleX(percentLoaded);
	}
	,__class__: NMEPreloader
});
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
};
Std["int"] = function(x) {
	return x | 0;
};
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
};
Std.parseFloat = function(x) {
	return parseFloat(x);
};
Std.random = function(x) {
	if(x <= 0) return 0; else return Math.floor(Math.random() * x);
};
var StringBuf = function() {
	this.b = "";
};
$hxClasses["StringBuf"] = StringBuf;
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	add: function(x) {
		this.b += Std.string(x);
	}
	,addSub: function(s,pos,len) {
		if(len == null) this.b += HxOverrides.substr(s,pos,null); else this.b += HxOverrides.substr(s,pos,len);
	}
	,__class__: StringBuf
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
};
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
};
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
};
StringTools.lpad = function(s,c,l) {
	if(c.length <= 0) return s;
	while(s.length < l) s = c + s;
	return s;
};
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
};
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
};
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] };
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; };
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; };
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return js.Boot.getClass(o);
};
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
};
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
};
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
};
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
};
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
};
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
};
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
};
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
};
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
};
Type["typeof"] = function(v) {
	var _g = typeof(v);
	switch(_g) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = js.Boot.getClass(v);
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
};
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2;
		var _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e1 ) {
		return false;
	}
	return true;
};
var co = {};
co.doubleduck = {};
co.doubleduck.d2p2 = {};
co.doubleduck.d2p2.P2Log = function() { };
$hxClasses["co.doubleduck.d2p2.P2Log"] = co.doubleduck.d2p2.P2Log;
co.doubleduck.d2p2.P2Log.__name__ = ["co","doubleduck","d2p2","P2Log"];
co.doubleduck.d2p2.P2Log._data = null;
co.doubleduck.d2p2.P2Log._dataAdapter = null;
co.doubleduck.d2p2.P2Log.init = function(gameDomain) {
	if(co.doubleduck.d2p2.P2Log._dataAdapter == null) co.doubleduck.d2p2.P2Log._dataAdapter = co.doubleduck.utils.data.StorageAdapter.get("d2p2",co.doubleduck.utils.data.StorageAdapterType.LOCAL_STORAGE);
	co.doubleduck.d2p2.P2Log._data = co.doubleduck.d2p2.P2Log._dataAdapter.getValue(co.doubleduck.d2p2.P2Log.DATA_KEY);
	if(co.doubleduck.d2p2.P2Log._data == null || co.doubleduck.d2p2.P2Log._data.data_ver != co.doubleduck.d2p2.P2Log.DATA_VER) {
		var id;
		if(co.doubleduck.d2p2.P2Log._data != null) id = co.doubleduck.d2p2.P2Log._data.p2id; else {
			var seed = "" + gameDomain;
			seed += Std.random(9999999);
			seed += Std.random(9999999);
			seed += new Date().getTime();
			seed += Math.random();
			id = haxe.crypto.Sha1.encode(seed);
		}
		co.doubleduck.d2p2.P2Log._data = { };
		co.doubleduck.d2p2.P2Log._data.p2id = id;
		co.doubleduck.d2p2.P2Log._data.data_ver = co.doubleduck.d2p2.P2Log.DATA_VER;
		co.doubleduck.d2p2.P2Log._data.runs = 0;
		co.doubleduck.d2p2.P2Log._data.domains = "";
		co.doubleduck.d2p2.P2Log._data.skill = co.doubleduck.d2p2.P2Log.newP2Value();
		co.doubleduck.d2p2.P2Log._data.strategy = co.doubleduck.d2p2.P2Log.newP2Value();
	}
	co.doubleduck.d2p2.P2Log._data.runs++;
	var domains = [];
	if(co.doubleduck.d2p2.P2Log._data.domains != "") domains = co.doubleduck.d2p2.P2Log._data.domains.split(",");
	domains.sort(co.doubleduck.d2p2.P2Log.alphabeticSort);
	if(HxOverrides.indexOf(domains,gameDomain,0) == -1) {
		domains.push(gameDomain);
		co.doubleduck.d2p2.P2Log._data.domains = domains.join(",");
	}
	var skillCalc = co.doubleduck.d2p2.P2Log.calcFromSamples(co.doubleduck.d2p2.P2Log._data.skill);
	var strategyCalc = co.doubleduck.d2p2.P2Log.calcFromSamples(co.doubleduck.d2p2.P2Log._data.strategy);
	co.doubleduck.d2p2.P2Log._dataAdapter.setValue(co.doubleduck.d2p2.P2Log.DATA_KEY,co.doubleduck.d2p2.P2Log._data);
	if(skillCalc != null) {
		var event = { };
		event.p2id = co.doubleduck.d2p2.P2Log._data.p2id;
		event.dataver = co.doubleduck.d2p2.P2Log._data.data_ver;
		event.runs = "" + co.doubleduck.d2p2.P2Log._data.runs;
		event.domains = co.doubleduck.d2p2.P2Log._data.domains;
		event.calcVal = "" + Std.string(skillCalc.val);
		event.calcConf = "" + Std.string(skillCalc.conf);
		event.integVal = "" + co.doubleduck.d2p2.P2Log._data.skill.currVal;
		event.integConf = "" + co.doubleduck.d2p2.P2Log._data.skill.currConf;
		event.integCount = "" + co.doubleduck.d2p2.P2Log._data.skill.integCount;
		com.funtomic.GameOps.reportEvent("p2calc_skill",event);
	}
	if(strategyCalc != null) {
		var event1 = { };
		event1.p2id = co.doubleduck.d2p2.P2Log._data.p2id;
		event1.dataver = co.doubleduck.d2p2.P2Log._data.data_ver;
		event1.runs = "" + co.doubleduck.d2p2.P2Log._data.runs;
		event1.domains = co.doubleduck.d2p2.P2Log._data.domains;
		event1.calcVal = "" + Std.string(strategyCalc.val);
		event1.calcConf = "" + Std.string(strategyCalc.conf);
		event1.integVal = "" + co.doubleduck.d2p2.P2Log._data.strategy.currVal;
		event1.integConf = "" + co.doubleduck.d2p2.P2Log._data.strategy.currConf;
		event1.integCount = "" + co.doubleduck.d2p2.P2Log._data.strategy.integCount;
		com.funtomic.GameOps.reportEvent("p2calc_strategy",event1);
	}
	var event2 = { };
	event2.p2id = co.doubleduck.d2p2.P2Log._data.p2id;
	event2.dataver = co.doubleduck.d2p2.P2Log._data.data_ver;
	event2.runs = "" + co.doubleduck.d2p2.P2Log._data.runs;
	event2.domains = co.doubleduck.d2p2.P2Log._data.domains;
	event2.skillVal = "" + co.doubleduck.d2p2.P2Log._data.skill.currVal;
	event2.skillConf = "" + co.doubleduck.d2p2.P2Log._data.skill.currConf;
	event2.skillIntegCount = "" + co.doubleduck.d2p2.P2Log._data.skill.integCount;
	event2.strategyVal = "" + co.doubleduck.d2p2.P2Log._data.strategy.currVal;
	event2.strategyConf = "" + co.doubleduck.d2p2.P2Log._data.strategy.currConf;
	event2.strategyIntegCount = "" + co.doubleduck.d2p2.P2Log._data.strategy.integCount;
	com.funtomic.GameOps.reportEvent("p2data",event2);
};
co.doubleduck.d2p2.P2Log.getP2ID = function() {
	return co.doubleduck.d2p2.P2Log._data.p2id;
};
co.doubleduck.d2p2.P2Log.logSkill = function(value) {
	co.doubleduck.d2p2.P2Log.addSample(co.doubleduck.d2p2.P2Log._data.skill,value);
	co.doubleduck.d2p2.P2Log._dataAdapter.setValue(co.doubleduck.d2p2.P2Log.DATA_KEY,co.doubleduck.d2p2.P2Log._data);
};
co.doubleduck.d2p2.P2Log.logStrategy = function(value) {
	co.doubleduck.d2p2.P2Log.addSample(co.doubleduck.d2p2.P2Log._data.strategy,value);
	co.doubleduck.d2p2.P2Log._dataAdapter.setValue(co.doubleduck.d2p2.P2Log.DATA_KEY,co.doubleduck.d2p2.P2Log._data);
};
co.doubleduck.d2p2.P2Log.addSample = function(p2val,sample) {
	if(p2val.samples == null) p2val.samples = new Array();
	p2val.samples.push(sample);
};
co.doubleduck.d2p2.P2Log.newP2Value = function() {
	var val = { };
	val.samples = new Array();
	val.currVal = 0.5;
	val.currConf = 0;
	val.integCount = 0;
	return val;
};
co.doubleduck.d2p2.P2Log.calcFromSamples = function(p2val) {
	if(p2val.samples == null || p2val.samples.length == 0) return null;
	var mean = 0;
	var _g1 = 0;
	var _g = p2val.samples.length;
	while(_g1 < _g) {
		var i = _g1++;
		mean += p2val.samples[i];
	}
	mean /= p2val.samples.length;
	var stdDev = 0;
	var _g11 = 0;
	var _g2 = p2val.samples.length;
	while(_g11 < _g2) {
		var i1 = _g11++;
		stdDev += Math.pow(p2val.samples[i1] - mean,2);
	}
	stdDev /= p2val.samples.length;
	stdDev = Math.sqrt(stdDev);
	var devConf = co.doubleduck.utils.Utils.map(p2val.samples.length,1,6,0.2,1);
	var meanConf = (1 - 4 * stdDev) * devConf;
	var newVal = co.doubleduck.d2p2.P2Log.integrateVals(mean,meanConf,p2val.currVal,p2val.currConf);
	p2val.currVal = co.doubleduck.d2p2.P2Log.trimFloat(newVal.val);
	p2val.currConf = co.doubleduck.d2p2.P2Log.trimFloat(newVal.conf);
	p2val.samples = new Array();
	p2val.integCount++;
	var calcVal = { };
	calcVal.val = co.doubleduck.d2p2.P2Log.trimFloat(mean);
	calcVal.conf = co.doubleduck.d2p2.P2Log.trimFloat(meanConf);
	return calcVal;
};
co.doubleduck.d2p2.P2Log.integrateVals = function(aVal,aConf,bVal,bConf) {
	var res = { };
	res.val = aVal * aConf + bVal * bConf;
	res.val /= aConf + bConf;
	var delta = Math.abs(aVal - bVal);
	var maxConf = co.doubleduck.utils.Utils.map(Math.abs(aConf - bConf),0,1,aConf / 2,Math.max(aConf,bConf));
	res.conf = co.doubleduck.utils.Utils.map(delta,0,1,Math.max(aConf,bConf),maxConf);
	return res;
};
co.doubleduck.d2p2.P2Log.trimFloat = function(src) {
	return Math.round(src * 10000) / 10000;
};
co.doubleduck.d2p2.P2Log.alphabeticSort = function(a,b) {
	var i = 0;
	a = a.toLowerCase();
	b = b.toLowerCase();
	while(i < a.length || i < b.length) {
		if(i >= a.length && i < b.length) return -1; else if(i < a.length && i >= b.length) return 1; else if(i >= a.length && i >= b.length) return 0;
		if(HxOverrides.cca(a,i) != HxOverrides.cca(b,i)) return HxOverrides.cca(a,i) - HxOverrides.cca(b,i);
		i++;
	}
	return 0;
};
co.doubleduck.pinata = {};
co.doubleduck.pinata.Game = function() {
	openfl.display.Sprite.call(this);
	this.addEventListener(openfl.events.Event.ADDED_TO_STAGE,$bind(this,this.handleAddedToStage));
};
$hxClasses["co.doubleduck.pinata.Game"] = co.doubleduck.pinata.Game;
co.doubleduck.pinata.Game.__name__ = ["co","doubleduck","pinata","Game"];
co.doubleduck.pinata.Game._screenSize = null;
co.doubleduck.pinata.Game._viewportSize = null;
co.doubleduck.pinata.Game.getScreenSize = function() {
	return co.doubleduck.pinata.Game._screenSize;
};
co.doubleduck.pinata.Game.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.Game.prototype = $extend(openfl.display.Sprite.prototype,{
	handleAddedToStage: function(e) {
		this.removeEventListener(openfl.events.Event.ADDED_TO_STAGE,$bind(this,this.handleAddedToStage));
		this.initGame();
	}
	,initGame: function() {
		co.doubleduck.pinata.data.Persistence.init("pinata_muncher");
		co.doubleduck.pinata.data.Persistence.initGameData();
		co.doubleduck.utils.SoundMgr.init(co.doubleduck.pinata.data.Persistence.adapter());
		co.doubleduck.utils.SoundMgr.available = true;
		this.stage.addEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleMusic));
		co.doubleduck.utils.DDAssets.activeLocale = "en";
		co.doubleduck.utils.DDAssets.availLocales = ["en","de","es"];
		co.doubleduck.pinata.Game._viewportSize = new openfl.geom.Rectangle(0,0,this.stage.stageWidth,this.stage.stageHeight);
		co.doubleduck.pinata.Game._screenSize = new openfl.geom.Rectangle(0,0,320,320 * this.stage.stageHeight / this.stage.stageWidth);
		co.doubleduck.utils.DDAssets.prefix = "";
		co.doubleduck.utils.DDAssets.scale = 1.0;
		co.doubleduck.utils.DDAssets.globalSmoothing = true;
		flambe.Storage.setStorageAdapter("pinata_muncher",co.doubleduck.pinata.data.Persistence.adapter());
		com.funtomic.GameOps.init("pinata_muncher",GlobalVars.gameVersion,co.doubleduck.pinata.data.GameplayDB.getData(),{ },$bind(this,this.handleGameOps));
		co.doubleduck.d2p2.P2Log.init("pinata_muncher");
	}
	,handleMusic: function(e) {
		this.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleMusic));
		co.doubleduck.utils.SoundMgr.playSound("music_loop",true,0,true);
	}
	,handleGameOps: function(flag) {
		if(com.funtomic.GameOps.getConfig().levelsData != null) co.doubleduck.pinata.data.GameplayDB.setData(com.funtomic.GameOps.getConfig());
		this.startFlow();
	}
	,startFlow: function() {
		this.startSession();
	}
	,addMenu: function(data) {
		this._menu = new co.doubleduck.pinata.meta.Menu(data);
		this._menu.addEventListener(co.doubleduck.pinata.meta.FlowEvents.START_SESSION,$bind(this,this.handleStartSession));
		this.addChild(this._menu);
	}
	,removeMenu: function() {
		this._menu.removeEventListener(co.doubleduck.pinata.meta.FlowEvents.START_SESSION,$bind(this,this.handleStartSession));
		this._menu.destroy();
		this.removeChild(this._menu);
		this._menu = null;
	}
	,startSession: function(data) {
		this._session = new co.doubleduck.pinata.core.Session(data);
		this._session.addEventListener(co.doubleduck.pinata.meta.FlowEvents.BACK_TO_MENU,$bind(this,this.handleBackToMenu));
		this._session.addEventListener(co.doubleduck.pinata.meta.FlowEvents.RESTART_SESSION,$bind(this,this.handleRestartSession));
		this.addChild(this._session);
	}
	,removeSession: function() {
		this._session.removeEventListener(co.doubleduck.pinata.meta.FlowEvents.START_SESSION,$bind(this,this.handleBackToMenu));
		this._session.removeEventListener(co.doubleduck.pinata.meta.FlowEvents.RESTART_SESSION,$bind(this,this.handleRestartSession));
		this._session.destroy();
		this.removeChild(this._session);
		this._session = null;
	}
	,handleStartSession: function(e) {
		var data = null;
		if(e.data != "") data = JSON.parse(e.data);
		this.removeMenu();
		this.startSession(data);
	}
	,handleBackToMenu: function(e) {
		var data = { levelId : 1};
		if(e.data != "") data = JSON.parse(e.data);
		this.removeSession();
		this.addMenu(data);
	}
	,handleRestartSession: function(e) {
		var data = null;
		if(e.data != "") data = JSON.parse(e.data);
		this.removeSession();
		this.startSession(data);
	}
	,__class__: co.doubleduck.pinata.Game
});
co.doubleduck.utils = {};
co.doubleduck.utils.KiziPreloader = function(progbarData,maskFrom,maskTo) {
	if(maskTo == null) maskTo = 1;
	if(maskFrom == null) maskFrom = 0;
	this.KIZI = false;
	this.MINIMUM_DISPLAY_TIME = 1500;
	NMEPreloader.call(this);
	this._isShowingAd = false;
	if(this.KIZI) {
		com.funtomic.KiziWidget.preloaderStarted();
		com.funtomic.KiziWidget.onAdStart($bind(this,this.handleAdStarted));
	}
	this._progBarData = progbarData;
	this.addSplash();
	this.addProgressBar();
	this._progBar.set_maskFrom(maskFrom);
	this._progBar.set_maskTo(maskTo);
	this._displayStartTime = haxe.Timer.stamp();
};
$hxClasses["co.doubleduck.utils.KiziPreloader"] = co.doubleduck.utils.KiziPreloader;
co.doubleduck.utils.KiziPreloader.__name__ = ["co","doubleduck","utils","KiziPreloader"];
co.doubleduck.utils.KiziPreloader.__super__ = NMEPreloader;
co.doubleduck.utils.KiziPreloader.prototype = $extend(NMEPreloader.prototype,{
	addSplash: function() {
		this._splashBmpData = new co.doubleduck.utils.SplashBG(320,568);
		this._splash = new openfl.display.Bitmap(this._splashBmpData);
		this._splash.smoothing = true;
		var frameWidth = 320 * this._splash.get_scaleX();
		var frameHeight = 568 * this._splash.get_scaleY();
		this.addChild(this._splash);
		this._splash.set_x(this.getWidth() / 2 - frameWidth / 2);
		this._splash.set_y(this.getHeight() / 2 - frameHeight / 2);
	}
	,addProgressBar: function() {
		var fill = new openfl.display.Bitmap(new co.doubleduck.utils.ProgFill(this._progBarData.width | 0,this._progBarData.height | 0));
		fill.smoothing = true;
		var bg = new openfl.display.Bitmap(new co.doubleduck.utils.ProgBG(this._progBarData.width | 0,this._progBarData.height | 0));
		bg.smoothing = true;
		this._progBar = new co.doubleduck.utils.ProgBar(bg,fill);
		this.addChild(this._progBar);
		this._progBar.setFillVals(this._progBarData.width,this._progBarData.height);
		this._progBar.setFillPerc(0);
		this._progBar.set_x(this._splash.get_x() + this._progBarData.x);
		this._progBar.set_y(this._splash.get_y() + this._progBarData.y);
	}
	,getHeight: function() {
		return openfl.Lib.current.stage.stageHeight;
	}
	,getWidth: function() {
		return openfl.Lib.current.stage.stageWidth;
	}
	,onLoaded: function() {
		var now = haxe.Timer.stamp();
		var delta = now - this._displayStartTime;
		if(this._isShowingAd) this._callWhenAdComplete = $bind(this,this.endSplash); else if(this.KIZI) {
			com.funtomic.KiziWidget.onAdStart(null);
			if(!this._isShowingAd) co.doubleduck.utils.Utils.delayedCall(0.5,$bind(this,this.endSplash));
		} else if(delta < this.MINIMUM_DISPLAY_TIME) co.doubleduck.utils.Utils.delayedCall((this.MINIMUM_DISPLAY_TIME - delta) / 1000,$bind(this,this.endSplash)); else this.endSplash();
	}
	,onUpdate: function(bytesLoaded,bytesTotal) {
		var percentLoaded = bytesLoaded / bytesTotal;
		if(percentLoaded > 1) percentLoaded = 1;
		this._progBar.setFillPerc(percentLoaded);
	}
	,endSplash: function() {
		if(this.KIZI) com.funtomic.KiziWidget.preloaderEnded();
		this.destroy();
		this.dispatchEvent(new openfl.events.Event(openfl.events.Event.COMPLETE));
	}
	,handleAdStarted: function() {
		com.funtomic.KiziWidget.onAdStart(null);
		this._isShowingAd = true;
		com.funtomic.KiziWidget.onAdComplete($bind(this,this.handleAdComplete));
	}
	,handleAdComplete: function() {
		com.funtomic.KiziWidget.onAdComplete(null);
		this._isShowingAd = false;
		if(this._callWhenAdComplete != null) {
			this._callWhenAdComplete();
			this._callWhenAdComplete = null;
		}
	}
	,destroy: function() {
		this.removeChild(this._splash);
		this._splash.bitmapData = null;
		this._splash = null;
		this._splashBmpData.dispose();
		this._splashBmpData = null;
		this.removeChild(this._progBar);
		this._progBar = null;
	}
	,__class__: co.doubleduck.utils.KiziPreloader
});
co.doubleduck.pinata.Preloader = function() {
	this.KIZI = true;
	co.doubleduck.utils.KiziPreloader.call(this,new openfl.geom.Rectangle(10,460,215,40),0,1);
};
$hxClasses["co.doubleduck.pinata.Preloader"] = co.doubleduck.pinata.Preloader;
co.doubleduck.pinata.Preloader.__name__ = ["co","doubleduck","pinata","Preloader"];
co.doubleduck.pinata.Preloader.__super__ = co.doubleduck.utils.KiziPreloader;
co.doubleduck.pinata.Preloader.prototype = $extend(co.doubleduck.utils.KiziPreloader.prototype,{
	__class__: co.doubleduck.pinata.Preloader
});
co.doubleduck.pinata.core = {};
co.doubleduck.pinata.core.LevelsBar = function() {
	openfl.display.Sprite.call(this);
	this._back = co.doubleduck.utils.DDAssets.getImage("images/ui/scroll_back.png");
	this._back.set_y(-this._back.get_height());
	this._back.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2 - this._back.get_width() / 2);
	this.addChild(this._back);
	var scrollRect = new openfl.geom.Rectangle();
	scrollRect.width = co.doubleduck.pinata.Game.getScreenSize().width * 0.77;
	scrollRect.height = 50;
	this._list = new co.doubleduck.pinata.meta.ScrolledList(scrollRect,false);
	this._list.itemPadding = 0.7;
	this._list.itemSnap = true;
	this._list.set_x((co.doubleduck.pinata.Game.getScreenSize().width - scrollRect.width) / 2);
	this._list.set_y(this._back.get_y() + this._back.get_height() / 2 - scrollRect.height / 2 + 1.5);
	this.addChild(this._list);
	this._front = new openfl.display.Sprite();
	var img = co.doubleduck.utils.DDAssets.getImage("images/ui/scroll_front.png");
	this._front.addChild(img);
	this._front.set_y(-this._front.get_height());
	this._front.mouseChildren = this._front.mouseEnabled = false;
	this.addChild(this._front);
	var levelsData = co.doubleduck.pinata.data.GameplayDB.getLevels();
	var _g = 0;
	while(_g < levelsData.length) {
		var level = levelsData[_g];
		++_g;
		var lvlId = Std["int"](level.id);
		if(lvlId <= co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL) + 1) {
			var levelBtn = new co.doubleduck.pinata.core.LevelBarItem(level);
			levelBtn.addEventListener("SelectedEvent",$bind(this,this.handleLevelSelect));
			this._list.addItem(levelBtn);
			if(lvlId == co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL) + 1) this._unlockingLevel = levelBtn;
		}
	}
	var activeLevel = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
	this._list.focusOnIndex(activeLevel - 1,true);
	(js.Boot.__cast(this._list.getItem(activeLevel - 1) , co.doubleduck.pinata.core.LevelBarItem)).toggleSelect(true);
	this._nextBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/scroll_arrow.png"));
	this._nextBtn.set_x(this._front.get_x() + this._front.get_width() - this._nextBtn.get_width() / 2);
	this._nextBtn.set_y(this._front.get_y() + this._front.get_height() / 2);
	this._nextBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleLevelSelect));
	this.addChild(this._nextBtn);
	this._prevBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/scroll_arrow.png"));
	this._prevBtn.set_scaleX(-1);
	this._prevBtn.set_x(Math.abs(this._prevBtn.get_width()) / 2);
	this._prevBtn.set_y(this._nextBtn.get_y());
	this._prevBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleLevelSelect));
	this.addChild(this._prevBtn);
};
$hxClasses["co.doubleduck.pinata.core.LevelsBar"] = co.doubleduck.pinata.core.LevelsBar;
co.doubleduck.pinata.core.LevelsBar.__name__ = ["co","doubleduck","pinata","core","LevelsBar"];
co.doubleduck.pinata.core.LevelsBar.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.LevelsBar.prototype = $extend(openfl.display.Sprite.prototype,{
	toggleScroll: function(flag) {
		this._list.scrollable = flag;
	}
	,incPinataCount: function() {
		if(this._unlockingLevel != null) {
			var activeLevel = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
			if(this._unlockingLevel.getLevelId() != activeLevel + 1) return;
			var res = this._unlockingLevel.incUnlockCount();
			if(res) {
				co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL,this._unlockingLevel.getLevelId());
				var newId = this._unlockingLevel.getLevelId() + 1;
				if(newId <= co.doubleduck.pinata.data.GameplayDB.getLevels().length) {
					var levelBtn = new co.doubleduck.pinata.core.LevelBarItem(co.doubleduck.pinata.data.GameplayDB.getLevelData(newId));
					levelBtn.addEventListener("SelectedEvent",$bind(this,this.handleLevelSelect));
					this._list.addItem(levelBtn);
					this._unlockingLevel = levelBtn;
					this._list.focusOnIndex(co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL) - 1);
					if(activeLevel == 1) co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.ADVANCE_LEVEL);
				} else this._unlockingLevel = null;
				if(com.funtomic.KiziWidget.showMidroll()) com.funtomic.KiziWidget.levelEnded();
			}
		}
	}
	,handleLevelSelect: function(e) {
		var newLevel = -1;
		var activeLevel = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
		if(e.target == this._nextBtn) {
			newLevel = activeLevel + 1;
			newLevel = Math.floor(Math.min(newLevel,co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL)));
		} else if(e.target == this._prevBtn) {
			newLevel = activeLevel - 1;
			newLevel = Math.floor(Math.max(newLevel,1));
		} else if(js.Boot.__instanceof(e.target,co.doubleduck.pinata.core.LevelBarItem)) {
			newLevel = (js.Boot.__cast(e.target , co.doubleduck.pinata.core.LevelBarItem)).getLevelId();
			if(newLevel > co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL)) newLevel = activeLevel;
		}
		if(newLevel != activeLevel) {
			(js.Boot.__cast(this._list.getItem(activeLevel - 1) , co.doubleduck.pinata.core.LevelBarItem)).toggleSelect(false);
			(js.Boot.__cast(this._list.getItem(newLevel - 1) , co.doubleduck.pinata.core.LevelBarItem)).toggleSelect(true);
			this._list.focusOnIndex(newLevel - 1);
			co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL,newLevel);
			this.dispatchEvent(new openfl.events.Event("LevelSelectedEvent"));
			if(newLevel == 2) co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.ADVANCE_LEVEL);
		}
	}
	,__class__: co.doubleduck.pinata.core.LevelsBar
});
co.doubleduck.pinata.meta = {};
co.doubleduck.pinata.meta.ScrolledItem = function() {
	openfl.display.Sprite.call(this);
};
$hxClasses["co.doubleduck.pinata.meta.ScrolledItem"] = co.doubleduck.pinata.meta.ScrolledItem;
co.doubleduck.pinata.meta.ScrolledItem.__name__ = ["co","doubleduck","pinata","meta","ScrolledItem"];
co.doubleduck.pinata.meta.ScrolledItem.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.meta.ScrolledItem.prototype = $extend(openfl.display.Sprite.prototype,{
	depressItem: function() {
	}
	,destroy: function() {
	}
	,__class__: co.doubleduck.pinata.meta.ScrolledItem
});
co.doubleduck.pinata.core.LevelBarItem = function(levelData) {
	co.doubleduck.pinata.meta.ScrolledItem.call(this);
	this._levelData = levelData;
	this._levelId = Std["int"](levelData.id);
	this._isGift = false;
	var imgName = "images/ui/scroll_item.png";
	if(levelData.type == "gift") {
		this._isGift = true;
		if(co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL) <= this._levelId) {
			imgName = "images/ui/scroll_item_bonus.png";
			this._giftLocked = true;
		} else {
			imgName = "images/ui/scroll_item_bonus_off.png";
			this._giftLocked = false;
		}
	}
	this._btn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage(imgName));
	this._btn.set_x(this._btn.get_width() / 2);
	this._btn.set_y(this._btn.get_height() / 2);
	this._btn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleBtn));
	this.addChild(this._btn);
	this._num = co.doubleduck.utils.Fonter.getString("" + this._levelId,"images/fonts/yellow_big");
	this._num.mouseEnabled = this._num.mouseChildren = false;
	this._num.set_x(this._btn.get_x());
	this._num.set_y(this._btn.get_y());
	this.addChild(this._num);
	this._sel = co.doubleduck.utils.DDAssets.getImage("images/ui/scroll_item_active.png");
	this._sel.set_x(this._btn.get_x() - this._sel.get_width() / 2);
	this._sel.set_y(this._btn.get_y() - this._sel.get_height() / 2);
	this._sel.set_visible(false);
	if(this._isGift) this.addChildAt(this._sel,0); else this.addChild(this._sel);
	if(this._levelId > co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL)) {
		this._unlockBar = new co.doubleduck.utils.ProgBar(co.doubleduck.utils.DDAssets.getImage("images/ui/level_bar_bg.png"),co.doubleduck.utils.DDAssets.getImage("images/ui/level_bar_fill.png"));
		this._unlockCount = 0;
		this._unlockTarget = Std["int"](this._levelData.countToUnlock);
		this._unlockBar.setFillPerc(0);
		this._unlockBar.set_x(this._btn.get_x() - this._unlockBar.get_width() / 2);
		this._unlockBar.set_y(this._btn.get_y() + 10);
		this.addChild(this._unlockBar);
		this._btn.set_alpha(this._num.set_alpha(0.6));
	}
};
$hxClasses["co.doubleduck.pinata.core.LevelBarItem"] = co.doubleduck.pinata.core.LevelBarItem;
co.doubleduck.pinata.core.LevelBarItem.__name__ = ["co","doubleduck","pinata","core","LevelBarItem"];
co.doubleduck.pinata.core.LevelBarItem.__super__ = co.doubleduck.pinata.meta.ScrolledItem;
co.doubleduck.pinata.core.LevelBarItem.prototype = $extend(co.doubleduck.pinata.meta.ScrolledItem.prototype,{
	getLevelId: function() {
		return this._levelId;
	}
	,toggleSelect: function(flag) {
		this._sel.set_visible(flag);
		if(flag) {
			co.doubleduck.utils.TweenChain.removeTweens(this._btn);
			if(this._redBtn != null) {
				co.doubleduck.utils.TweenChain.removeTweens(this._redBtn);
				this.removeChild(this._redBtn);
				this._redBtn = null;
			}
			this._btn.set_scaleX(this._btn.set_scaleY(1));
		} else if(this._isGift && (this._giftLocked && co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL) != this._levelId)) {
			this._giftLocked = false;
			var newBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/scroll_item_bonus_off.png"));
			newBtn.set_x(newBtn.get_width() / 2);
			newBtn.set_y(newBtn.get_height() / 2);
			newBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleBtn));
			this.addChildAt(newBtn,this.getChildIndex(this._btn));
			this.removeChild(this._btn);
			this._btn.removeEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleBtn));
			this._btn = newBtn;
		}
	}
	,incUnlockCount: function() {
		this._unlockCount++;
		this._unlockBar.setFillPerc(this._unlockCount / this._unlockTarget);
		if(this._unlockCount >= this._unlockTarget) {
			var data = { };
			data.level = this._levelId;
			data.candyCount = co.doubleduck.pinata.meta.Stats.getPCandies().toFullString();
			data.killCount = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT);
			data.toolsState = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.TOOLS_STATE);
			data.currTapHits = co.doubleduck.pinata.meta.Stats.getHitVal().toFullString();
			data.currHPS = co.doubleduck.pinata.meta.Stats.getHPS().toFullString();
			com.funtomic.GameOps.reportEvent("level_unlocked",data);
			this.removeChild(this._unlockBar);
			co.doubleduck.pinata.meta.Stats.notifyOnEvent("UpdateToolEvent");
			this._unlockBar = null;
			this._btn.set_alpha(this._num.set_alpha(1));
			if(!this._isGift) {
				this._redBtn = new openfl.display.Sprite();
				var red = co.doubleduck.utils.DDAssets.getImage("images/ui/scroll_item_alert.png");
				var _g = red;
				_g.set_x(_g.get_x() - red.get_width() / 2);
				var _g1 = red;
				_g1.set_y(_g1.get_y() - red.get_height() / 2);
				this._redBtn.addChild(red);
				this._redBtn.set_x(this._btn.get_x());
				this._redBtn.set_y(this._btn.get_y());
				this._redBtn.set_alpha(0);
				this._redBtn.mouseChildren = this._redBtn.mouseEnabled = false;
				this.addChildAt(this._redBtn,this.getChildIndex(this._btn) + 1);
				this.nudgeBtn();
			}
			co.doubleduck.utils.SoundMgr.playSound("new_level_unlocked");
			return true;
		}
		return false;
	}
	,nudgeBtn: function() {
		co.doubleduck.utils.TweenChain.removeTweens(this._btn);
		co.doubleduck.utils.TweenChain.removeTweens(this._redBtn);
		this._redBtn.set_scaleX(this._redBtn.set_scaleY(this._btn.set_scaleX(this._btn.set_scaleY(1))));
		co.doubleduck.utils.TweenChain.get(this._btn).tto({ scaleX : 1.08, scaleY : 1.08},300,motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},300,motion.easing.Sine.get_easeInOut()).call($bind(this,this.nudgeBtn));
		co.doubleduck.utils.TweenChain.get(this._redBtn).tto({ scaleX : 1.08, scaleY : 1.08, alpha : 0.7},300,motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1, alpha : 0.1},300,motion.easing.Sine.get_easeInOut()).call($bind(this,this.nudgeBtn));
	}
	,handleBtn: function(e) {
		this.dispatchEvent(new openfl.events.Event("SelectedEvent"));
	}
	,depressItem: function() {
		this._btn.dePress();
	}
	,destroy: function() {
		this._btn.removeEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleBtn));
	}
	,__class__: co.doubleduck.pinata.core.LevelBarItem
});
co.doubleduck.pinata.core.Muncher = function() {
	openfl.display.Sprite.call(this);
	this._box = new openfl.display.Sprite();
	this.addChild(this._box);
	this._anim = new co.doubleduck.pinata.core.MuncherAnim();
	this._anim.set_x(-65.);
	this._anim.set_y(-129);
	this._box.addChild(this._anim);
	this.jellyAnim();
};
$hxClasses["co.doubleduck.pinata.core.Muncher"] = co.doubleduck.pinata.core.Muncher;
co.doubleduck.pinata.core.Muncher.__name__ = ["co","doubleduck","pinata","core","Muncher"];
co.doubleduck.pinata.core.Muncher.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.Muncher.prototype = $extend(openfl.display.Sprite.prototype,{
	showEat: function(openDur) {
		if(openDur == null) openDur = 1;
		co.doubleduck.utils.SoundMgr.playSound("eating_candies");
		co.doubleduck.utils.TweenChain.removeTweens(this._box);
		this._box.set_scaleX(this._box.set_scaleY(1));
		var steps = new Array();
		steps.push("openMouth");
		var _g = 0;
		while(_g < openDur) {
			var i = _g++;
			steps.push("keepOpen");
		}
		steps = steps.concat(["closeMouth","chew","chew","swallow"]);
		this._anim.showBehaviors(steps);
		this._anim.addEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDoneEat));
	}
	,jellyAnim: function() {
		co.doubleduck.utils.TweenChain.removeTweens(this._box);
		this._box.set_scaleX(this._box.set_scaleY(1));
		var hTime = 700;
		co.doubleduck.utils.TweenChain.get(this._box).tto({ scaleX : 1.04, scaleY : 0.98},hTime,motion.easing.Sine.get_easeOut()).tto({ scaleX : 0.98, scaleY : 1.04},2 * hTime,motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},hTime,motion.easing.Sine.get_easeIn()).call($bind(this,this.jellyAnim));
	}
	,handleDoneEat: function(e) {
		this._anim.removeEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDoneEat));
		this._anim.showBehavior("idle");
		this.jellyAnim();
	}
	,__class__: co.doubleduck.pinata.core.Muncher
});
co.doubleduck.utils.AnimSprite = function(sheet,smoothing) {
	if(smoothing == null) smoothing = false;
	openfl.display.Sprite.call(this);
	this.smoothing = smoothing;
	this.spritesheet = sheet;
	this.behaviorQueue = new Array();
	this.bitmap = new openfl.display.Bitmap();
	this.addChild(this.bitmap);
};
$hxClasses["co.doubleduck.utils.AnimSprite"] = co.doubleduck.utils.AnimSprite;
co.doubleduck.utils.AnimSprite.__name__ = ["co","doubleduck","utils","AnimSprite"];
co.doubleduck.utils.AnimSprite.__super__ = openfl.display.Sprite;
co.doubleduck.utils.AnimSprite.prototype = $extend(openfl.display.Sprite.prototype,{
	getFrameData: function(index) {
		if(this.currentBehavior != null && this.currentBehavior.frameData.length > index) return this.currentBehavior.frameData[index]; else return null;
	}
	,queueBehavior: function(behavior) {
		var behaviorData = this.resolveBehavior(behavior);
		if(this.currentBehavior == null) this.updateBehavior(behaviorData); else this.behaviorQueue.push(behaviorData);
	}
	,resolveBehavior: function(behavior) {
		if(js.Boot.__instanceof(behavior,spritesheet.data.BehaviorData)) return behavior; else if(typeof(behavior) == "string") {
			if(this.spritesheet != null) return this.spritesheet.behaviors.get(behavior);
		}
		return null;
	}
	,showBehavior: function(behavior,restart) {
		if(restart == null) restart = true;
		this.behaviorQueue = new Array();
		this.updateBehavior(this.resolveBehavior(behavior),restart);
	}
	,showBehaviors: function(behaviors) {
		this.behaviorQueue = new Array();
		var _g = 0;
		while(_g < behaviors.length) {
			var behavior = behaviors[_g];
			++_g;
			this.behaviorQueue.push(this.resolveBehavior(behavior));
		}
		if(this.behaviorQueue.length > 0) this.updateBehavior(this.behaviorQueue.shift());
	}
	,update: function(deltaTime) {
		if(!this.behaviorComplete) {
			this.timeElapsed += deltaTime;
			if(this.timeElapsed >= this.loopTime) {
				if(this.currentBehavior.loop) this.timeElapsed = this.timeElapsed % this.loopTime; else {
					this.timeElapsed = this.loopTime;
					this.behaviorComplete = true;
				}
			}
			var ratio = this.timeElapsed / this.loopTime;
			var frameCount = this.currentBehavior.frames.length;
			var newIndex = Math.floor(ratio * frameCount);
			if(!this.currentBehavior.loop) newIndex = Math.min(frameCount - 1,newIndex);
			this.currentFrameIndex = newIndex;
			var frame = this.spritesheet.getFrame(this.currentBehavior.frames[this.currentFrameIndex]);
			this.bitmap.bitmapData = frame.bitmapData;
			this.bitmap.smoothing = this.smoothing;
			this.bitmap.set_x(frame.offsetX - this.currentBehavior.originX);
			this.bitmap.set_y(frame.offsetY - this.currentBehavior.originY);
			if(this.behaviorComplete) {
				if(this.behaviorQueue.length > 0) this.updateBehavior(this.behaviorQueue.shift()); else if(this.hasEventListener(openfl.events.Event.COMPLETE)) this.dispatchEvent(new openfl.events.Event(openfl.events.Event.COMPLETE));
			}
		}
	}
	,updateBehavior: function(behavior,restart) {
		if(restart == null) restart = true;
		if(behavior != null) {
			if(restart || behavior != this.currentBehavior) {
				this.currentBehavior = behavior;
				this.timeElapsed = 0;
				this.behaviorComplete = false;
				this.loopTime = behavior.frames.length / behavior.frameRate * 1000 | 0;
				if(this.bitmap.bitmapData == null) this.update(0);
			}
		} else {
			this.bitmap.bitmapData = null;
			this.currentBehavior = null;
			this.currentFrameIndex = -1;
			this.behaviorComplete = true;
		}
	}
	,__class__: co.doubleduck.utils.AnimSprite
});
co.doubleduck.pinata.core.MuncherAnim = function() {
	var behDatas = new Array();
	behDatas.push(new spritesheet.data.BehaviorData("idle",[0,0,0,0,0,0,0,0,0,0,11,0],true,5));
	behDatas.push(new spritesheet.data.BehaviorData("openMouth",[0,1,2,3],false,15));
	behDatas.push(new spritesheet.data.BehaviorData("keepOpen",[3,3],false,15));
	behDatas.push(new spritesheet.data.BehaviorData("closeMouth",[3,2],false,15));
	behDatas.push(new spritesheet.data.BehaviorData("chew",[4,5,6,7,8],false,18));
	behDatas.push(new spritesheet.data.BehaviorData("swallow",[9,9,9,9,10,10,0],false,17));
	var sheet = co.doubleduck.utils.DDAssets.getSpritesheet("images/muncher.png",4,3,130,129,behDatas);
	co.doubleduck.utils.AnimSprite.call(this,sheet);
	this.showBehavior("idle");
	this._lastTime = openfl.Lib.getTimer();
	this.addEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
};
$hxClasses["co.doubleduck.pinata.core.MuncherAnim"] = co.doubleduck.pinata.core.MuncherAnim;
co.doubleduck.pinata.core.MuncherAnim.__name__ = ["co","doubleduck","pinata","core","MuncherAnim"];
co.doubleduck.pinata.core.MuncherAnim.__super__ = co.doubleduck.utils.AnimSprite;
co.doubleduck.pinata.core.MuncherAnim.prototype = $extend(co.doubleduck.utils.AnimSprite.prototype,{
	handleTick: function(e) {
		var time = openfl.Lib.getTimer();
		var delta = time - this._lastTime;
		this.update(delta);
		this.bitmap.smoothing = true;
		this._lastTime = time;
	}
	,__class__: co.doubleduck.pinata.core.MuncherAnim
});
co.doubleduck.pinata.core.Session = function(data) {
	var _g = this;
	openfl.display.Sprite.call(this);
	this._prevBackName = "";
	this._currLvlId = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
	this._currLvlData = co.doubleduck.pinata.data.GameplayDB.getLevelData(this._currLvlId);
	co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.RUNS_COUNTER,co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.RUNS_COUNTER) + 1);
	this._bgBox = new openfl.display.Sprite();
	this._pinataBox = new openfl.display.Sprite();
	this.setupBack();
	if(!co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.SHOW_BUBBLE,{ handle : $bind(this,this.loadPinata)})) this.loadPinata();
	this._muncher = new co.doubleduck.pinata.core.Muncher();
	this._muncher.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2);
	this._muncher.set_y(co.doubleduck.pinata.Game.getScreenSize().height * 0.85);
	this._toolAnims = new co.doubleduck.pinata.core.tools.ToolAnims();
	this.addChild(this._bgBox);
	this.addChild(this._muncher);
	this.addChild(this._pinataBox);
	this.addChild(this._toolAnims);
	this._levelsBar = new co.doubleduck.pinata.core.LevelsBar();
	this._levelsBar.set_y(co.doubleduck.pinata.Game.getScreenSize().height);
	this._levelsBar.addEventListener("LevelSelectedEvent",$bind(this,this.handleLevelSelected));
	this.addChild(this._levelsBar);
	this._scrLayer = new openfl.display.Sprite();
	this.addChild(this._scrLayer);
	this._toolsScr = new co.doubleduck.pinata.core.tools.ToolsScr();
	this._toolsScr.addEventListener(openfl.events.Event.OPEN,$bind(this,this.handleScrOpened));
	this._toolsScr.set_visible(false);
	this._scrLayer.addChild(this._toolsScr);
	if(co.doubleduck.pinata.core.TutorOverlay.inst().hasPassedStep(co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN)) {
		if(this._prevBackName != "bonus") this._toolsScr.set_visible(true);
	} else this._toolsScr.handlePCandies();
	this._missionScr = new co.doubleduck.pinata.core.missions.MissionScr();
	this._missionScr.addEventListener(openfl.events.Event.OPEN,$bind(this,this.handleScrOpened));
	this._missionScr.addEventListener(openfl.events.Event.OPEN,$bind(this,this.handleMissionScr));
	this._missionScr.addEventListener(openfl.events.Event.CLOSE,$bind(this,this.handleMissionScr));
	this._missionScr.addEventListener("WonPinataEvent",$bind(this,this.handleMissionScr));
	this._missionScr.set_visible(false);
	this._scrLayer.addChild(this._missionScr);
	if(co.doubleduck.pinata.core.TutorOverlay.inst().hasPassedStep(co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS)) {
		if(this._prevBackName == "bonus") this._missionScr.regLevelShowing = false; else this._missionScr.set_visible(true);
	}
	this._hud = new openfl.display.Sprite();
	this.addChild(this._hud);
	this.addChild(co.doubleduck.pinata.core.TutorOverlay.inst());
	co.doubleduck.pinata.meta.Stats.addListener("UpdateCandiesEvent",$bind(this,this.updateCandies));
	this.updateCandies();
	co.doubleduck.pinata.meta.Stats.addListener("UpdateHPSEvent",$bind(this,this.updateHPS));
	this.updateHPS();
	var latest = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.LATEST_TIME_KEPT);
	if(latest > 0) {
		var curr = Math.floor(new Date().getTime() / 1000);
		var delta = curr - latest;
		var hps = co.doubleduck.pinata.meta.Stats.getHPS();
		if(!co.doubleduck.pinata.meta.BigInt.isZero(hps)) {
			var levelDat = co.doubleduck.pinata.data.GameplayDB.getLevelData(co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL));
			var hp = co.doubleduck.pinata.core.pinatas.Pinata.rollFromRange(levelDat.pinataHP,0.5);
			var reward = co.doubleduck.pinata.core.pinatas.Pinata.rollFromRange(levelDat.candyReward,0.5);
			var quant = delta / Math.max(co.doubleduck.pinata.meta.BigInt.roughDiv(hp,hps),1);
			quant = Math.min(10000,quant);
			var totalReward = co.doubleduck.pinata.meta.BigInt.mulScalar(reward,quant);
			if(!co.doubleduck.pinata.meta.BigInt.isZero(totalReward)) {
				var modal = new co.doubleduck.pinata.meta.AwayModal(totalReward);
				modal.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2);
				modal.set_y(co.doubleduck.pinata.Game.getScreenSize().height / 2);
				this.addChild(modal);
				var candies = co.doubleduck.pinata.meta.Stats.getPCandies();
				candies = co.doubleduck.pinata.meta.BigInt.add(candies,totalReward);
				co.doubleduck.pinata.meta.Stats.setPCandies(candies);
				this._missionScr.noModalShowing = false;
				modal.callWhenDone = function() {
					_g._missionScr.noModalShowing = true;
				};
			}
		}
	}
	this._timeKeeper = new co.doubleduck.utils.Delayer(2000);
	this._timeKeeper.handler = $bind(this,this.handleTimeKeep);
	this._timeKeeper.start();
};
$hxClasses["co.doubleduck.pinata.core.Session"] = co.doubleduck.pinata.core.Session;
co.doubleduck.pinata.core.Session.__name__ = ["co","doubleduck","pinata","core","Session"];
co.doubleduck.pinata.core.Session.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.Session.prototype = $extend(openfl.display.Sprite.prototype,{
	handleTimeKeep: function() {
		co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.LATEST_TIME_KEPT,Math.floor(new Date().getTime() / 1000));
	}
	,handleScrOpened: function(e) {
		var scr = e.target;
		this._scrLayer.addChild(this._scrLayer.removeChild(scr));
	}
	,handleMissionScr: function(e) {
		if(e.type == openfl.events.Event.OPEN) {
			this._levelsBar.toggleScroll(false);
			this._levelsBar.stopDrag();
			this._toolsScr.closeIdOpened();
		}
		if(e.type == openfl.events.Event.CLOSE) this._levelsBar.toggleScroll(true);
		if(e.type == "WonPinataEvent") {
			this.setupBack();
			this._toolAnims.toggleShow(false);
			this._pinata.animVanish();
			this._pinata.removeEventListener("OpenedEvent",$bind(this,this.handlePinata));
			this._pinata.removeEventListener("ClearingEvent",$bind(this,this.handlePinata));
			this.loadPinata((js.Boot.__cast(e , co.doubleduck.utils.DynamicEvent)).data,true);
			co.doubleduck.utils.TweenChain.get(this._pinata).wait(2500).call(($_=(js.Boot.__cast(this._pinata , co.doubleduck.pinata.core.pinatas.RegPinata)),$bind($_,$_.initHittable)));
		}
	}
	,updateCandies: function(e) {
		if(this._pCandies != null) {
			this._hud.removeChild(this._pCandies);
			this._pCandies = null;
		}
		this._pCandies = co.doubleduck.utils.Fonter.getString("$" + co.doubleduck.pinata.meta.Stats.getPCandies().toString(),"images/fonts/yellow_big");
		this._pCandies.set_x(co.doubleduck.pinata.Game.getScreenSize().width - 10 - this._pCandies.get_width() / 2);
		this._pCandies.set_y(22);
		this._hud.addChild(this._pCandies);
	}
	,updateHPS: function(e) {
		if(this._pHPS != null) {
			this._hud.removeChild(this._pHPS);
			this._pHPS = null;
		}
		var val = co.doubleduck.pinata.meta.Stats.getHPS();
		if(val.toFullString() != "0") {
			this._pHPS = co.doubleduck.utils.Fonter.getString(val.toString() + "~","images/fonts/yellow_small");
			this._pHPS.set_x(co.doubleduck.pinata.Game.getScreenSize().width - 12 - this._pHPS.get_width() / 2);
			this._pHPS.set_y(42);
			this._hud.addChild(this._pHPS);
		}
	}
	,setupBack: function() {
		var unlockedLvl = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL);
		var activeLvl = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
		var newData = co.doubleduck.pinata.data.GameplayDB.getLevelData(activeLvl);
		var newBack = "";
		if(newData.type == "gift" && activeLvl == unlockedLvl) newBack = "bonus"; else newBack = "back" + Std["int"](newData.back);
		if(newBack != "" && newBack != this._prevBackName) {
			this._prevBackName = newBack;
			newBack = "images/backs/" + newBack + ".jpg";
			if(this._back != null) {
				co.doubleduck.utils.TweenChain.get(this._back).tto({ alpha : 0},150).call(($_=this._bgBox,$bind($_,$_.removeChild)),[this._back]);
				this._back = null;
			}
			this._back = co.doubleduck.utils.DDAssets.getImage(newBack);
			this._back.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2 - this._back.get_width() / 2);
			this._back.set_y(co.doubleduck.pinata.Game.getScreenSize().height - this._back.get_height());
			this._bgBox.addChildAt(this._back,0);
			if(this._missionScr != null) {
				if(this._prevBackName == "bonus") {
					this._missionScr.set_visible(this._toolsScr.set_visible(false));
					this._missionScr.regLevelShowing = false;
				} else {
					this._missionScr.set_visible(this._toolsScr.set_visible(true));
					this._missionScr.regLevelShowing = true;
				}
			}
		}
	}
	,handleLevelSelected: function(e) {
		var activeLvl = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
		var newData = co.doubleduck.pinata.data.GameplayDB.getLevelData(activeLvl);
		this.setupBack();
		this._currLvlData = newData;
		this._pinata.animVanish();
		this._pinata.removeEventListener("OpenedEvent",$bind(this,this.handlePinata));
		this._pinata.removeEventListener("ClearingEvent",$bind(this,this.handlePinata));
		this.loadPinata();
	}
	,loadPinata: function(pData,instant) {
		if(instant == null) instant = false;
		if(pData == null) pData = this._currLvlData;
		this._pinata = co.doubleduck.pinata.core.pinatas.Pinata.create(pData);
		this._pinata.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2);
		this._pinata.set_y(co.doubleduck.pinata.Game.getScreenSize().height * 0.3);
		if(!instant) this._pinata.animIn();
		if(pData.type == "mission") this._pinata.set_y(pData.posY);
		this._pinata.addEventListener("OpenedEvent",$bind(this,this.handlePinata));
		this._pinata.addEventListener("ClearingEvent",$bind(this,this.handlePinata));
		this._pinata.addEventListener("ClearedEvent",$bind(this,this.handlePinata));
		this._pinataBox.addChild(this._pinata);
	}
	,handlePinata: function(e) {
		if(e.type == "OpenedEvent") {
			this._pinata.removeEventListener("OpenedEvent",$bind(this,this.handlePinata));
			var gotCandies = this._pinata.getReward();
			co.doubleduck.pinata.meta.Stats.setPCandies(co.doubleduck.pinata.meta.BigInt.add(co.doubleduck.pinata.meta.Stats.getPCandies(),gotCandies));
			co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.WORKS_OFFLINE);
			this._levelsBar.incPinataCount();
			if(co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS)) this._missionScr.set_visible(true);
			if(js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.GiftPinata) || js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.MissionPinata)) this.pourCandies(26,1900); else this.spreadCandies(4,850);
			var reward = co.doubleduck.utils.Fonter.getString("$" + gotCandies.toString(),"images/fonts/yellow_big");
			reward.set_x(this._muncher.get_x() + 70);
			reward.set_y(this._muncher.get_y() - 70);
			reward.set_alpha(0);
			this._pinataBox.addChild(reward);
			co.doubleduck.utils.TweenChain.get(reward).wait(600).tto({ y : reward.get_y() - 50},850);
			co.doubleduck.utils.TweenChain.get(reward).wait(600).tto({ alpha : 1},50).wait(500).tto({ alpha : 0},300).call(($_=this._pinataBox,$bind($_,$_.removeChild)),[reward]);
			var eatDur = 1;
			if(js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.GiftPinata) || js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.MissionPinata)) {
				var white = new openfl.display.Sprite();
				white.get_graphics().beginFill(14548991);
				white.get_graphics().drawRect(0,0,co.doubleduck.pinata.Game.getScreenSize().width,co.doubleduck.pinata.Game.getScreenSize().height);
				white.get_graphics().endFill();
				this.addChild(white);
				eatDur = 10;
				co.doubleduck.utils.TweenChain.get(white).tto({ alpha : 0},600).call($bind(this,this.removeChild),[white]);
			}
			co.doubleduck.utils.TweenChain.removeTweens(this._muncher);
			co.doubleduck.utils.TweenChain.get(this._muncher).wait(430).call(($_=this._muncher,$bind($_,$_.showEat)),[eatDur]);
		}
		if(e.type == "ClearingEvent") {
			this._pinata.removeEventListener("ClearingEvent",$bind(this,this.handlePinata));
			if(!js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.GiftPinata) && !js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.MissionPinata)) this.loadPinata();
			co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT,co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT) + 1);
			co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION,co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION) + 1);
			co.doubleduck.pinata.meta.Stats.notifyOnEvent("UpdateToolEvent");
		}
		if(e.type == "ClearedEvent") {
			var oldPinata = e.target;
			oldPinata.removeEventListener("ClearedEvent",$bind(this,this.handlePinata));
			this._pinataBox.removeChild(oldPinata);
			if(js.Boot.__instanceof(oldPinata,co.doubleduck.pinata.core.pinatas.GiftPinata)) {
				this.setupBack();
				if(this._pinata == oldPinata) this.loadPinata();
			} else if(js.Boot.__instanceof(this._pinata,co.doubleduck.pinata.core.pinatas.MissionPinata)) {
				if(this._pinata == oldPinata) co.doubleduck.utils.TweenChain.get(this._missionScr).wait(1850).call(($_=this._missionScr,$bind($_,$_.reshowNewPack))).wait(400).call(($_=this._toolAnims,$bind($_,$_.toggleShow)),[true]).call($bind(this,this.loadPinata));
			}
		}
	}
	,spreadCandies: function(amount,dur) {
		var _g = 0;
		while(_g < amount) {
			var i = _g++;
			var candy = new openfl.display.Sprite();
			var img = co.doubleduck.utils.DDAssets.getImage("images/candies" + (i % 3 + 1) + ".png");
			var _g1 = img;
			_g1.set_x(_g1.get_x() - img.get_width() / 2);
			var _g11 = img;
			_g11.set_y(_g11.get_y() - img.get_height() / 2);
			candy.addChild(img);
			candy.set_alpha(0);
			candy.set_scaleX(candy.set_scaleY(0.6));
			candy.set_x(this._pinata.get_x());
			candy.set_y(this._pinata.get_y() + 30);
			this._pinataBox.addChild(candy);
			var delay = Math.floor(Math.random() * 250);
			var centerFactor = 1 - Math.abs(i - (amount - 1) / 2) / ((amount - 1) / 2);
			co.doubleduck.utils.TweenChain.get(candy).tto({ x : candy.get_x() + (i + 1) / amount * 100 - 50},300,motion.easing.Sine.get_easeOut()).tto({ x : candy.get_x()},dur - delay - 300,motion.easing.Cubic.get_easeIn());
			co.doubleduck.utils.TweenChain.get(candy).tto({ y : candy.get_y() - (10 + centerFactor * 50 + co.doubleduck.utils.Utils.nrand() * 10)},300,motion.easing.Sine.get_easeOut()).tto({ y : this._muncher.get_y() - this._muncher.get_height() / 2},dur - delay - 300,motion.easing.Sine.get_easeIn());
			co.doubleduck.utils.TweenChain.get(candy).tto({ alpha : 1},100).tto({ rotation : 90 - Math.random() * 180},dur - delay - 200).tto({ alpha : 0},100).call(($_=this._pinataBox,$bind($_,$_.removeChild)),[candy]);
		}
	}
	,pourCandies: function(amount,dur) {
		var pourRatio = co.doubleduck.utils.Utils.map(amount,1,10,0,0.6);
		var canDelay = Math.floor(dur * pourRatio / amount);
		var halfDropTime = Math.floor(canDelay * amount / 2);
		var _g = 0;
		while(_g < amount) {
			var i = _g++;
			var candy = new openfl.display.Sprite();
			var img = co.doubleduck.utils.DDAssets.getImage("images/candies" + (i % 3 + 1) + ".png");
			var _g1 = img;
			_g1.set_x(_g1.get_x() - img.get_width() / 2);
			var _g11 = img;
			_g11.set_y(_g11.get_y() - img.get_height() / 2);
			candy.addChild(img);
			candy.set_alpha(0);
			candy.set_scaleX(candy.set_scaleY(0.6));
			candy.set_x(this._pinata.get_x());
			candy.set_y(this._pinata.get_y() + 30);
			this._pinataBox.addChild(candy);
			var delay = Math.floor(Math.random() * 250);
			co.doubleduck.utils.TweenChain.get(candy).wait(10 + i * canDelay).tto({ x : candy.get_x() + (50 - Math.random() * 100)},halfDropTime,motion.easing.Sine.get_easeOut()).tto({ x : candy.get_x()},halfDropTime,motion.easing.Sine.get_easeInOut());
			co.doubleduck.utils.TweenChain.get(candy).wait(10 + i * canDelay).tto({ y : this._muncher.get_y() - this._muncher.get_height() / 2},2 * halfDropTime,motion.easing.Sine.get_easeIn());
			co.doubleduck.utils.TweenChain.get(candy).wait(10 + i * canDelay).tto({ alpha : 1},100).tto({ rotation : 90 - Math.random() * 180},2 * halfDropTime - 200).tto({ alpha : 0},100).call(($_=this._pinataBox,$bind($_,$_.removeChild)),[candy]);
		}
	}
	,destroy: function() {
	}
	,__class__: co.doubleduck.pinata.core.Session
});
co.doubleduck.pinata.core.TutorStep = $hxClasses["co.doubleduck.pinata.core.TutorStep"] = { __ename__ : ["co","doubleduck","pinata","core","TutorStep"], __constructs__ : ["SHOW_BUBBLE","TAP_TAB_BTN","BUY_FIRST_UPGRADE","EXIT_SHOP","ADVANCE_LEVEL","SHOW_MISSIONS","CLOSE_MISSIONS","BUY_FIRST_AUTO","WORKS_OFFLINE","DONE_TUTOR"] };
co.doubleduck.pinata.core.TutorStep.SHOW_BUBBLE = ["SHOW_BUBBLE",0];
co.doubleduck.pinata.core.TutorStep.SHOW_BUBBLE.toString = $estr;
co.doubleduck.pinata.core.TutorStep.SHOW_BUBBLE.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN = ["TAP_TAB_BTN",1];
co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN.toString = $estr;
co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.BUY_FIRST_UPGRADE = ["BUY_FIRST_UPGRADE",2];
co.doubleduck.pinata.core.TutorStep.BUY_FIRST_UPGRADE.toString = $estr;
co.doubleduck.pinata.core.TutorStep.BUY_FIRST_UPGRADE.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.EXIT_SHOP = ["EXIT_SHOP",3];
co.doubleduck.pinata.core.TutorStep.EXIT_SHOP.toString = $estr;
co.doubleduck.pinata.core.TutorStep.EXIT_SHOP.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.ADVANCE_LEVEL = ["ADVANCE_LEVEL",4];
co.doubleduck.pinata.core.TutorStep.ADVANCE_LEVEL.toString = $estr;
co.doubleduck.pinata.core.TutorStep.ADVANCE_LEVEL.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS = ["SHOW_MISSIONS",5];
co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS.toString = $estr;
co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.CLOSE_MISSIONS = ["CLOSE_MISSIONS",6];
co.doubleduck.pinata.core.TutorStep.CLOSE_MISSIONS.toString = $estr;
co.doubleduck.pinata.core.TutorStep.CLOSE_MISSIONS.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.BUY_FIRST_AUTO = ["BUY_FIRST_AUTO",7];
co.doubleduck.pinata.core.TutorStep.BUY_FIRST_AUTO.toString = $estr;
co.doubleduck.pinata.core.TutorStep.BUY_FIRST_AUTO.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.WORKS_OFFLINE = ["WORKS_OFFLINE",8];
co.doubleduck.pinata.core.TutorStep.WORKS_OFFLINE.toString = $estr;
co.doubleduck.pinata.core.TutorStep.WORKS_OFFLINE.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorStep.DONE_TUTOR = ["DONE_TUTOR",9];
co.doubleduck.pinata.core.TutorStep.DONE_TUTOR.toString = $estr;
co.doubleduck.pinata.core.TutorStep.DONE_TUTOR.__enum__ = co.doubleduck.pinata.core.TutorStep;
co.doubleduck.pinata.core.TutorOverlay = function() {
	openfl.display.Sprite.call(this);
	var numSaved = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.TUTOR_STAGE);
	if(numSaved != 0) {
		this._currStep = co.doubleduck.pinata.core.TutorStep.DONE_TUTOR;
		co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.TUTOR_STAGE,-1);
		co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.TUTOR_STEP,co.doubleduck.pinata.core.TutorStep.DONE_TUTOR[0]);
	} else {
		var stepSaved = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.TUTOR_STEP);
		if(stepSaved == "") stepSaved = Type.getEnumConstructs(co.doubleduck.pinata.core.TutorStep)[0];
		this._currStep = Type.createEnum(co.doubleduck.pinata.core.TutorStep,stepSaved);
	}
	this._isStepShowing = false;
};
$hxClasses["co.doubleduck.pinata.core.TutorOverlay"] = co.doubleduck.pinata.core.TutorOverlay;
co.doubleduck.pinata.core.TutorOverlay.__name__ = ["co","doubleduck","pinata","core","TutorOverlay"];
co.doubleduck.pinata.core.TutorOverlay._tutor = null;
co.doubleduck.pinata.core.TutorOverlay.inst = function() {
	if(co.doubleduck.pinata.core.TutorOverlay._tutor == null) co.doubleduck.pinata.core.TutorOverlay._tutor = new co.doubleduck.pinata.core.TutorOverlay();
	return co.doubleduck.pinata.core.TutorOverlay._tutor;
};
co.doubleduck.pinata.core.TutorOverlay.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.TutorOverlay.prototype = $extend(openfl.display.Sprite.prototype,{
	hasPassedStep: function(step) {
		return this._currStep == null || this._currStep[1] > step[1];
	}
	,tryShowStep: function(step,arg) {
		var _g = this;
		if(step != this._currStep || this._isStepShowing) return false;
		this._isStepShowing = false;
		switch(step[1]) {
		case 0:
			this._bubble = new openfl.display.Sprite();
			var bbl = co.doubleduck.utils.DDAssets.getImage("images/tutorial/bubble.png");
			var handle = arg.handle;
			var _g1 = bbl;
			_g1.set_x(_g1.get_x() - bbl.get_width() / 2);
			var _g2 = bbl;
			_g2.set_y(_g2.get_y() - bbl.get_height() / 2);
			this._bubble.addChild(bbl);
			this._bubble.set_x(co.doubleduck.pinata.Game.getScreenSize().width * 0.8);
			this._bubble.set_y(co.doubleduck.pinata.Game.getScreenSize().height - 200);
			this._bubble.set_alpha(0);
			this.addChild(this._bubble);
			co.doubleduck.utils.TweenChain.get(this._bubble).wait(500).tto({ alpha : 1},300).wait(800).call(handle).wait(700).call(function() {
				_g.tapHand(new openfl.geom.Point(co.doubleduck.pinata.Game.getScreenSize().width * 0.6,co.doubleduck.pinata.Game.getScreenSize().height * 0.35));
			});
			this.jiggleThat(this._bubble,0.03,3000);
			this._isStepShowing = true;
			break;
		case 1:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(20,co.doubleduck.pinata.Game.getScreenSize().height / 2 - 43));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this.tapHand(new openfl.geom.Point(25,co.doubleduck.pinata.Game.getScreenSize().height * 0.5 - 25));
			this._isStepShowing = true;
			break;
		case 2:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(co.doubleduck.pinata.Game.getScreenSize().width * 0.8,122));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this._msg = new openfl.display.Sprite();
			var msg = co.doubleduck.utils.DDAssets.getImage("images/tutorial/increase_hits.png");
			this._msg.addChild(msg);
			this._msg.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2 - this._msg.get_width() / 2 - 15);
			this._msg.set_y(140);
			this._msg.mouseEnabled = this._msg.mouseChildren = false;
			this.addChild(this._msg);
			this.hoverThat(this._msg,1200);
			this.tapHand(new openfl.geom.Point(co.doubleduck.pinata.Game.getScreenSize().width * 0.91,125));
			this._isStepShowing = true;
			break;
		case 3:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(90,20));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this.tapHand(new openfl.geom.Point(140,30));
			this._isStepShowing = true;
			break;
		case 4:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(co.doubleduck.pinata.Game.getScreenSize().width * 0.42,co.doubleduck.pinata.Game.getScreenSize().height - 40));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this._msg = new openfl.display.Sprite();
			var msg1 = co.doubleduck.utils.DDAssets.getImage("images/tutorial/next_level.png");
			this._msg.addChild(msg1);
			this._msg.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2 - this._msg.get_width() / 2);
			this._msg.set_y(co.doubleduck.pinata.Game.getScreenSize().height - this._msg.get_height() - 60);
			this._msg.mouseEnabled = this._msg.mouseChildren = false;
			this.addChild(this._msg);
			this.hoverThat(this._msg,1200);
			this.tapHand(new openfl.geom.Point(co.doubleduck.pinata.Game.getScreenSize().width * 0.5,co.doubleduck.pinata.Game.getScreenSize().height - 50));
			this._isStepShowing = true;
			break;
		case 5:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(20,co.doubleduck.pinata.Game.getScreenSize().height / 2 + 43));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this.tapHand(new openfl.geom.Point(25,co.doubleduck.pinata.Game.getScreenSize().height * 0.5 + 55));
			this._isStepShowing = true;
			break;
		case 6:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(90,20));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this._isStepShowing = true;
			break;
		case 7:
			this._blockOverlay = this.getOverlay(new openfl.geom.Point(co.doubleduck.pinata.Game.getScreenSize().width * 0.8,215));
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			this._msg = new openfl.display.Sprite();
			var msg2 = co.doubleduck.utils.DDAssets.getImage("images/tutorial/auto_hit.png");
			this._msg.addChild(msg2);
			this._msg.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2 - this._msg.get_width() / 2);
			this._msg.set_y(230);
			this._msg.mouseEnabled = this._msg.mouseChildren = false;
			this.addChild(this._msg);
			this.hoverThat(this._msg,1200);
			this._isStepShowing = true;
			break;
		case 8:
			this._blockOverlay = new openfl.display.Sprite();
			this._blockOverlay.get_graphics().beginFill(0);
			this._blockOverlay.get_graphics().drawRect(0,0,co.doubleduck.pinata.Game.getScreenSize().width,co.doubleduck.pinata.Game.getScreenSize().height);
			this._blockOverlay.get_graphics().endFill();
			this._blockOverlay.set_alpha(0.01);
			this.addChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.get(this._blockOverlay).tto({ alpha : 0.7},150);
			this._msg = new openfl.display.Sprite();
			var msg3 = co.doubleduck.utils.DDAssets.getImage("images/tutorial/away.png");
			msg3.set_x(-msg3.get_width() / 2);
			msg3.set_y(-msg3.get_height() / 2);
			this._msg.addChild(msg3);
			var btn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/modal_away/btn_ok.png"));
			btn.set_y(msg3.get_height() * 0.3);
			btn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleAwayOk));
			btn.set_alpha(0);
			co.doubleduck.utils.TweenChain.get(btn).wait(800).tto({ alpha : 1},100);
			this._msg.addChild(btn);
			this._msg.set_x(co.doubleduck.pinata.Game.getScreenSize().width / 2);
			this._msg.set_y(co.doubleduck.pinata.Game.getScreenSize().height / 2);
			this.addChild(this._msg);
			this._isStepShowing = true;
			break;
		case 9:
			break;
		}
		if(this._isStepShowing) {
			var data = { };
			data.tutorStep = this._currStep[0];
			data.candyCount = co.doubleduck.pinata.meta.Stats.getPCandies().toFullString();
			com.funtomic.GameOps.reportEvent("tutorStepStart",data);
		}
		return this._isStepShowing;
	}
	,handleAwayOk: function(e) {
		(js.Boot.__cast(e.target , co.doubleduck.utils.Button)).removeEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleAwayOk));
		co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.WORKS_OFFLINE);
	}
	,tapHand: function(pos) {
		if(this._hand == null) {
			this._hand = new openfl.display.Sprite();
			var hand = co.doubleduck.utils.DDAssets.getImage("images/tutorial/hand.png");
			var _g = hand;
			_g.set_x(_g.get_x() - hand.get_width() * 0.35);
			var _g1 = hand;
			_g1.set_y(_g1.get_y() - hand.get_height() * 0.1);
			this._hand.set_visible(false);
			this._hand.addChild(hand);
			this.addChild(this._hand);
		}
		if(!this._hand.get_visible()) {
			this._hand.set_alpha(0.01);
			this._hand.set_visible(true);
			this._hand.mouseEnabled = this._hand.mouseChildren = false;
			co.doubleduck.utils.TweenChain.get(this._hand).tto({ alpha : 1},250);
		}
		this._hand.set_x(pos.x);
		this._hand.set_y(pos.y);
		this._hand.set_scaleX(this._hand.set_scaleY(1));
		co.doubleduck.utils.TweenChain.get(this._hand).tto({ scaleX : 0.8, scaleY : 0.8},200,motion.easing.Sine.get_easeIn()).tto({ scaleX : 1, scaleY : 1},300,motion.easing.Sine.get_easeOut()).call($bind(this,this.tapHand),[pos]);
	}
	,jiggleThat: function(obj,factor,duration) {
		obj.set_scaleX(obj.set_scaleY(1));
		var quart = Math.floor(duration / 4);
		co.doubleduck.utils.TweenChain.get(obj).tto({ scaleX : 1 + factor, scaleY : 1 - factor},quart,motion.easing.Sine.get_easeOut()).tto({ scaleX : 1 - factor, scaleY : 1 + factor},quart * 2,motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},quart,motion.easing.Sine.get_easeIn()).call($bind(this,this.jiggleThat),[obj,factor,duration]);
	}
	,hoverThat: function(obj,duration) {
		var half = Math.floor(duration / 2);
		co.doubleduck.utils.TweenChain.get(obj).tto({ y : obj.get_y() + 10},half,motion.easing.Sine.get_easeInOut()).tto({ y : obj.get_y()},half,motion.easing.Sine.get_easeInOut()).wait(30).call($bind(this,this.hoverThat),[obj,duration]);
	}
	,actedOnStep: function(step) {
		if(!(step == this._currStep && this._isStepShowing)) return false;
		var data = { };
		data.tutorStep = this._currStep[0];
		data.candyCount = co.doubleduck.pinata.meta.Stats.getPCandies().toFullString();
		com.funtomic.GameOps.reportEvent("tutorStepFinish",data);
		switch(step[1]) {
		case 0:
			co.doubleduck.utils.TweenChain.removeTweens(this._bubble);
			this.removeChild(this._bubble);
			if(this._hand != null) {
				co.doubleduck.utils.TweenChain.removeTweens(this._hand);
				this._hand.set_visible(false);
			}
			break;
		case 1:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.removeTweens(this._hand);
			this._hand.set_visible(false);
			break;
		case 2:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.removeTweens(this._msg);
			co.doubleduck.utils.TweenChain.get(this._msg).tto({ alpha : 0},150).call($bind(this,this.removeChild),[this._msg]);
			this._msg = null;
			co.doubleduck.utils.TweenChain.removeTweens(this._hand);
			this._hand.set_visible(false);
			break;
		case 3:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.removeTweens(this._hand);
			this._hand.set_visible(false);
			break;
		case 4:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.get(this._msg).tto({ alpha : 0},150).call($bind(this,this.removeChild),[this._msg]);
			this._msg = null;
			co.doubleduck.utils.TweenChain.removeTweens(this._hand);
			this._hand.set_visible(false);
			break;
		case 5:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.removeTweens(this._hand);
			this._hand.set_visible(false);
			break;
		case 6:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			break;
		case 7:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.removeTweens(this._msg);
			co.doubleduck.utils.TweenChain.get(this._msg).tto({ alpha : 0},150).call($bind(this,this.removeChild),[this._msg]);
			this._msg = null;
			break;
		case 8:
			co.doubleduck.utils.TweenChain.removeTweens(this._blockOverlay);
			this.removeChild(this._blockOverlay);
			co.doubleduck.utils.TweenChain.removeTweens(this._msg);
			co.doubleduck.utils.TweenChain.get(this._msg).tto({ alpha : 0},150).call($bind(this,this.removeChild),[this._msg]);
			this._msg = null;
			break;
		case 9:
			break;
		}
		this._isStepShowing = false;
		this._currStep = Type.createEnumIndex(co.doubleduck.pinata.core.TutorStep,this._currStep[1] + 1);
		co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.TUTOR_STEP,this._currStep[0]);
		return true;
	}
	,getOverlay: function(pos,rad) {
		if(rad == null) rad = 40;
		var over = new openfl.display.Sprite();
		var scr = co.doubleduck.pinata.Game.getScreenSize();
		var box;
		box = new openfl.display.Sprite();
		box.get_graphics().beginFill(8947848);
		box.get_graphics().drawRect(0,0,scr.width,pos.y - rad);
		box.get_graphics().endFill();
		over.addChild(box);
		box = new openfl.display.Sprite();
		box.get_graphics().beginFill(8947848);
		box.get_graphics().drawRect(0,pos.y - rad,pos.x - rad,2 * rad);
		box.get_graphics().endFill();
		over.addChild(box);
		box = new openfl.display.Sprite();
		box.get_graphics().beginFill(8947848);
		box.get_graphics().drawRect(pos.x + rad,pos.y - rad,scr.width - pos.x - rad,2 * rad);
		box.get_graphics().endFill();
		over.addChild(box);
		box = new openfl.display.Sprite();
		box.get_graphics().beginFill(8947848);
		box.get_graphics().drawRect(0,pos.y + rad,scr.width,scr.height - pos.y - rad);
		box.get_graphics().endFill();
		over.addChild(box);
		over.mouseEnabled = over.mouseChildren = true;
		return over;
	}
	,__class__: co.doubleduck.pinata.core.TutorOverlay
});
co.doubleduck.pinata.core.missions = {};
co.doubleduck.pinata.core.missions.MissionItem = function(packId,missionInd) {
	openfl.display.Sprite.call(this);
	this._done = false;
	this._data = co.doubleduck.pinata.data.GameplayDB.getMissionData(packId,missionInd);
	this._type = Type.createEnum(co.doubleduck.pinata.core.missions.MissionType,(js.Boot.__cast(this._data.id , String)).toUpperCase());
	this._back = co.doubleduck.utils.DDAssets.getImage("images/missions/mission_bg.png");
	var _g = this._back;
	_g.set_y(_g.get_y() - this._back.get_height() / 2);
	this.addChild(this._back);
	this._checkmark = new co.doubleduck.utils.SimpleAnimSprite("images/missions/checkmark.png",1,4,[0,1,2,3],false);
	this._checkmark.setAnimFPS(24);
	this._checkmark.stopAnim();
	var _g1 = this._checkmark;
	_g1.set_y(_g1.get_y() - this._checkmark.get_height() / 2);
	this._checkmark.set_x(10);
	this._checkmark.set_visible(false);
	this.addChild(this._checkmark);
	var descStr = this._data.desc;
	var parts = descStr.split("#");
	var displayVal;
	var _g2 = this._type;
	switch(_g2[1]) {
	case 0:case 3:
		displayVal = co.doubleduck.pinata.meta.BigInt.fromString(this._data.value).toString();
		break;
	case 1:case 4:
		displayVal = this._data.value;
		break;
	case 2:
		displayVal = "";
		break;
	}
	descStr = parts[0] + displayVal + parts[1];
	this._desc = co.doubleduck.utils.Fonter.getString(descStr,"images/fonts/purple/");
	this._desc.set_x(66 + this._desc.get_width() / 2);
	if(this._type == co.doubleduck.pinata.core.missions.MissionType.GET_TOOL) {
		var toolName = co.doubleduck.utils.DDAssets.getImage("images/tools_menu/tools/" + Std.string(this._data.value) + "/name.png");
		var _g3 = toolName;
		_g3.set_y(_g3.get_y() - toolName.get_height() / 2);
		toolName.set_x(this._desc.get_width() / 2);
		this._desc.addChild(toolName);
	}
	this.addChild(this._desc);
	if(this.hasProgBar()) {
		this._desc.set_y(-13);
		this._prog = new co.doubleduck.utils.ProgBar(co.doubleduck.utils.DDAssets.getImage("images/missions/bar_bg.png"),co.doubleduck.utils.DDAssets.getImage("images/missions/bar_fill.png"));
		this._prog.set_x(57);
		this._prog.set_y(-2);
		this._prog.set_maskFrom(0.02);
		this._prog.set_maskTo(0.97);
		this._prog.setFillPerc(this.getCompletePerc());
		this.addChild(this._prog);
	}
};
$hxClasses["co.doubleduck.pinata.core.missions.MissionItem"] = co.doubleduck.pinata.core.missions.MissionItem;
co.doubleduck.pinata.core.missions.MissionItem.__name__ = ["co","doubleduck","pinata","core","missions","MissionItem"];
co.doubleduck.pinata.core.missions.MissionItem.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.missions.MissionItem.prototype = $extend(openfl.display.Sprite.prototype,{
	getType: function() {
		return this._type;
	}
	,updateProgress: function(andNotify) {
		if(andNotify == null) andNotify = true;
		var perc = this.getCompletePerc();
		if(this.hasProgBar()) this._prog.setFillPerc(perc,150);
		if(andNotify && !this._done && perc >= 1) this.dispatchEvent(new openfl.events.Event("ReadyDoneEvent"));
	}
	,markIfDone: function() {
		if(this.hasProgBar()) this._prog.setFillPerc(this.getCompletePerc());
		if(this.getCompletePerc() >= 1) {
			this._done = true;
			this._checkmark.set_visible(true);
			this._checkmark.replayAnim();
			this._checkmark.update(0);
			co.doubleduck.utils.TweenChain.get(this._checkmark).wait(500).call($bind(this,this.dispatchEvent),[new openfl.events.Event("DoneEvent")]);
		} else this.dispatchEvent(new openfl.events.Event("OngoingEvent"));
	}
	,hasProgBar: function() {
		if(this._type == co.doubleduck.pinata.core.missions.MissionType.GET_TOOL) return false;
		return true;
	}
	,getCompletePerc: function() {
		var res;
		var _g = this._type;
		switch(_g[1]) {
		case 0:
			var curr = co.doubleduck.pinata.meta.Stats.getPCandies();
			var max = co.doubleduck.pinata.meta.BigInt.fromString(this._data.value);
			if(co.doubleduck.pinata.meta.BigInt.isEqual(curr,max) || co.doubleduck.pinata.meta.BigInt.isGT(curr,max)) res = 1; else res = Math.min(0.99,co.doubleduck.pinata.meta.BigInt.roughDiv(curr,max));
			break;
		case 1:
			res = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION) / Std["int"](this._data.value);
			break;
		case 2:
			if(co.doubleduck.pinata.meta.Stats.getToolLevel(this._data.value) > 0) res = 1; else res = 0;
			break;
		case 3:
			var curr1 = co.doubleduck.pinata.meta.Stats.getHPS();
			var max1 = co.doubleduck.pinata.meta.BigInt.fromString(this._data.value);
			if(co.doubleduck.pinata.meta.BigInt.isEqual(curr1,max1) || co.doubleduck.pinata.meta.BigInt.isGT(curr1,max1)) res = 1; else res = Math.min(0.99,co.doubleduck.pinata.meta.BigInt.roughDiv(curr1,max1));
			break;
		case 4:
			res = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL) / Std.parseInt(this._data.value);
			break;
		}
		res = Math.min(1,Math.max(0,res));
		return res;
	}
	,__class__: co.doubleduck.pinata.core.missions.MissionItem
});
co.doubleduck.pinata.core.missions.MissionType = $hxClasses["co.doubleduck.pinata.core.missions.MissionType"] = { __ename__ : ["co","doubleduck","pinata","core","missions","MissionType"], __constructs__ : ["HOLD_CANDIES","BEAT_PINATAS","GET_TOOL","REACH_HPS","REACH_LEVEL"] };
co.doubleduck.pinata.core.missions.MissionType.HOLD_CANDIES = ["HOLD_CANDIES",0];
co.doubleduck.pinata.core.missions.MissionType.HOLD_CANDIES.toString = $estr;
co.doubleduck.pinata.core.missions.MissionType.HOLD_CANDIES.__enum__ = co.doubleduck.pinata.core.missions.MissionType;
co.doubleduck.pinata.core.missions.MissionType.BEAT_PINATAS = ["BEAT_PINATAS",1];
co.doubleduck.pinata.core.missions.MissionType.BEAT_PINATAS.toString = $estr;
co.doubleduck.pinata.core.missions.MissionType.BEAT_PINATAS.__enum__ = co.doubleduck.pinata.core.missions.MissionType;
co.doubleduck.pinata.core.missions.MissionType.GET_TOOL = ["GET_TOOL",2];
co.doubleduck.pinata.core.missions.MissionType.GET_TOOL.toString = $estr;
co.doubleduck.pinata.core.missions.MissionType.GET_TOOL.__enum__ = co.doubleduck.pinata.core.missions.MissionType;
co.doubleduck.pinata.core.missions.MissionType.REACH_HPS = ["REACH_HPS",3];
co.doubleduck.pinata.core.missions.MissionType.REACH_HPS.toString = $estr;
co.doubleduck.pinata.core.missions.MissionType.REACH_HPS.__enum__ = co.doubleduck.pinata.core.missions.MissionType;
co.doubleduck.pinata.core.missions.MissionType.REACH_LEVEL = ["REACH_LEVEL",4];
co.doubleduck.pinata.core.missions.MissionType.REACH_LEVEL.toString = $estr;
co.doubleduck.pinata.core.missions.MissionType.REACH_LEVEL.__enum__ = co.doubleduck.pinata.core.missions.MissionType;
co.doubleduck.pinata.core.missions.MissionScr = function() {
	openfl.display.Sprite.call(this);
	this.noModalShowing = true;
	this.regLevelShowing = true;
	this._isOpened = false;
	this._midAnim = false;
	this._data = co.doubleduck.pinata.data.GameplayDB.getMissionPack(co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK));
	this._srcPaint = co.doubleduck.utils.DDAssets.getRawImage("images/missions/paintings/paint" + Std["int"](this._data.pinataId) + ".jpg");
	this._overlay = new openfl.display.Sprite();
	this.addChild(this._overlay);
	this._tabBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/btn_mission.png"));
	this._tabBtn.set_x(this._tabBtn.get_width() / 2 - 2);
	this._tabBtn.set_y(co.doubleduck.pinata.Game.getScreenSize().height / 2 + 45);
	this._tabBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleTabBtn));
	this.addChild(this._tabBtn);
	this._scrBox = new openfl.display.Sprite();
	this.addChild(this._scrBox);
	this._back = co.doubleduck.utils.DDAssets.getImage("images/missions/bg.png");
	var _g = this._scrBox;
	_g.set_x(_g.get_x() - this._back.get_width());
	this._backBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/missions/btn_back.png"));
	this._backBtn.set_x(this._backBtn.get_width() / 2 + 20);
	this._backBtn.set_y(this._backBtn.get_height() / 2 + 5);
	this._backBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleBackBtn));
	this._backBtn.enabled = false;
	this._painting = new openfl.display.Sprite();
	var piecesGot = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT).split(",");
	if(piecesGot.length > 0 && piecesGot[0] != "") {
		var _g1 = 0;
		while(_g1 < piecesGot.length) {
			var piece = piecesGot[_g1];
			++_g1;
			var pcImg = this.getPiece(Std.parseInt(piece));
			this._painting.addChild(pcImg);
		}
	}
	this._painting.set_x(this._back.get_width() / 2 - this._srcPaint.width / 2);
	this._painting.set_y(this._back.get_height() / 2 - this._srcPaint.height / 2 - 8);
	this._overlay.get_graphics().beginFill(0);
	this._overlay.get_graphics().drawRect(0,0,co.doubleduck.pinata.Game.getScreenSize().width + this._back.get_width(),co.doubleduck.pinata.Game.getScreenSize().height);
	this._overlay.get_graphics().endFill();
	this._overlay.set_x(this._scrBox.get_x());
	this._overlay.set_visible(false);
	this.setupMission();
	this._scrBox.addChild(this._back);
	this._scrBox.addChild(this._painting);
	this._scrBox.addChild(this._backBtn);
	this._scrBox.addChild(this._currMission);
	co.doubleduck.pinata.meta.Stats.addListener("UpdateCandiesEvent",$bind(this,this.handleStatsEvent));
	co.doubleduck.pinata.meta.Stats.addListener("UpdateToolEvent",$bind(this,this.handleStatsEvent));
	co.doubleduck.pinata.meta.Stats.addListener("UpdateToolEvent",$bind(this,this.handleStatsEvent));
	co.doubleduck.pinata.meta.Stats.addListener("UpdateHPSEvent",$bind(this,this.handleStatsEvent));
	co.doubleduck.pinata.meta.Stats.addListener("UpdateToolEvent",$bind(this,this.handleStatsEvent));
};
$hxClasses["co.doubleduck.pinata.core.missions.MissionScr"] = co.doubleduck.pinata.core.missions.MissionScr;
co.doubleduck.pinata.core.missions.MissionScr.__name__ = ["co","doubleduck","pinata","core","missions","MissionScr"];
co.doubleduck.pinata.core.missions.MissionScr.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.missions.MissionScr.prototype = $extend(openfl.display.Sprite.prototype,{
	setupMission: function() {
		this._currMission = new co.doubleduck.pinata.core.missions.MissionItem(co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK),co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND));
		this._currMission.addEventListener("ReadyDoneEvent",$bind(this,this.handleItem));
		this._currMission.set_x(this._back.get_width() / 2 - this._currMission.get_width() / 2);
		this._currMission.set_y(this._back.get_height() - 45);
	}
	,handleStatsEvent: function(e) {
		if(!co.doubleduck.pinata.core.TutorOverlay.inst().hasPassedStep(co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS)) return;
		if(!this.noModalShowing || !this.regLevelShowing) return;
		if(this._currMission == null) return;
		if(this._currMission.getType() == co.doubleduck.pinata.core.missions.MissionType.HOLD_CANDIES && e.type == "UpdateCandiesEvent" || this._currMission.getType() == co.doubleduck.pinata.core.missions.MissionType.BEAT_PINATAS && e.type == "UpdateToolEvent" || this._currMission.getType() == co.doubleduck.pinata.core.missions.MissionType.GET_TOOL && e.type == "UpdateToolEvent" || this._currMission.getType() == co.doubleduck.pinata.core.missions.MissionType.REACH_HPS && e.type == "UpdateHPSEvent" || this._currMission.getType() == co.doubleduck.pinata.core.missions.MissionType.REACH_LEVEL && e.type == "UpdateToolEvent") this._currMission.updateProgress();
	}
	,animOpen: function(openType) {
		var _g = this;
		if(this._isOpened) return;
		this._isOpened = true;
		this._midAnim = true;
		co.doubleduck.utils.SoundMgr.playSound("menu_open");
		this.dispatchEvent(new openfl.events.Event(openfl.events.Event.OPEN));
		this._tabBtn.enabled = false;
		if(openType == "firstShow") {
			var _g1 = this._currMission;
			_g1.set_x(_g1.get_x() - co.doubleduck.pinata.Game.getScreenSize().width);
			co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION,0);
		}
		co.doubleduck.utils.TweenChain.removeTweens(this._overlay);
		this._overlay.set_alpha(0);
		this._overlay.set_visible(true);
		co.doubleduck.utils.TweenChain.get(this._overlay).tto({ alpha : 0.65},300);
		this._backBtn.set_alpha(0);
		this._backBtn.enabled = false;
		this._currMission.addEventListener("DoneEvent",$bind(this,this.handleItem));
		this._currMission.addEventListener("OngoingEvent",$bind(this,this.handleItem));
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ x : -this._scrBox.get_x()},300,motion.easing.Sine.get_easeInOut()).wait(400).call(function() {
			if(openType == "firstShow") co.doubleduck.utils.TweenChain.get(_g._currMission).tto({ x : _g._currMission.get_x() + co.doubleduck.pinata.Game.getScreenSize().width},300,motion.easing.Sine.get_easeOut()).wait(400).call(($_=_g._currMission,$bind($_,$_.markIfDone))); else _g._currMission.markIfDone();
		});
	}
	,handleTabBtn: function(e) {
		if(co.doubleduck.pinata.core.TutorOverlay.inst().hasPassedStep(co.doubleduck.pinata.core.TutorStep.CLOSE_MISSIONS)) this.animOpen(""); else {
			co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.SHOW_MISSIONS);
			this.animOpen("firstShow");
		}
	}
	,handleItem: function(e) {
		var _g = this;
		if(e.type == "ReadyDoneEvent") {
			this._currMission.removeEventListener("ReadyDoneEvent",$bind(this,this.handleItem));
			if(this._isOpened) {
				if(!this._midAnim) {
					this._backBtn.set_alpha(0);
					this._backBtn.enabled = false;
					this._currMission.addEventListener("DoneEvent",$bind(this,this.handleItem));
					this._currMission.addEventListener("OngoingEvent",$bind(this,this.handleItem));
					this._currMission.markIfDone();
				}
			} else {
				if(this._midAnim) {
					co.doubleduck.utils.TweenChain.removeTweens(this._overlay);
					co.doubleduck.utils.TweenChain.removeTweens(this);
				}
				this.animOpen("");
			}
		}
		if(e.type == "DoneEvent") {
			this._currMission.removeEventListener("ReadyDoneEvent",$bind(this,this.handleItem));
			this._currMission.removeEventListener("DoneEvent",$bind(this,this.handleItem));
			this._currMission.removeEventListener("OngoingEvent",$bind(this,this.handleItem));
			var piecesLeft = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT).split(",");
			var posInd = Std.random(piecesLeft.length);
			var piece = Std.parseInt(piecesLeft.splice(posInd,1)[0]);
			co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT,piecesLeft.join(","));
			var piecesGot = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT).split(",");
			if(piecesGot.length == 1 && piecesGot[0] == "") piecesGot.pop();
			piecesGot.push("" + piece);
			co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT,piecesGot.join(","));
			co.doubleduck.utils.TweenChain.removeTweens(this._painting);
			this._painting.set_alpha(1);
			var newPiece = this.getPiece(piece);
			newPiece.set_alpha(0);
			newPiece.set_scaleX(newPiece.set_scaleY(1.7));
			this._painting.addChild(newPiece);
			co.doubleduck.utils.TweenChain.get(newPiece).tto({ alpha : 1, scaleX : 1, scaleY : 1},600,motion.easing.Sine.get_easeIn());
			co.doubleduck.utils.TweenChain.get(this._currMission).wait(1000).tto({ x : this._currMission.get_x() + co.doubleduck.pinata.Game.getScreenSize().width},300,motion.easing.Sine.get_easeIn()).call(($_=this._scrBox,$bind($_,$_.removeChild)),[this._currMission]);
			this._currMission = null;
			var data = { };
			data.missionInd = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND);
			data.missionPackInd = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK);
			data.level = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL);
			data.currLevel = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL);
			data.candyCount = co.doubleduck.pinata.meta.Stats.getPCandies().toFullString();
			data.killCount = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT);
			data.toolsState = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.TOOLS_STATE);
			data.currTapHits = co.doubleduck.pinata.meta.Stats.getHitVal().toFullString();
			data.currHPS = co.doubleduck.pinata.meta.Stats.getHPS().toFullString();
			com.funtomic.GameOps.reportEvent("mission_done",data);
			var missionInd = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND);
			if(missionInd < 8) {
				co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND,missionInd + 1);
				this.loadNextMission(1200);
			} else {
				co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND,0);
				co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT,"0,1,2,3,4,5,6,7,8");
				co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT,"");
				var packInd = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK);
				if(co.doubleduck.pinata.data.GameplayDB.getMissionPack(packInd + 1) == null) {
				} else {
					co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK,packInd + 1);
					var pData = { };
					pData.type = "mission";
					pData.pinId = Std["int"](this._data.pinataId);
					pData.pinReward = co.doubleduck.pinata.meta.BigInt.fromString(this._data.reward);
					pData.posY = this._painting.get_y() + this._srcPaint.height / 2;
					this.dispatchEvent(new co.doubleduck.utils.DynamicEvent("WonPinataEvent",pData));
					co.doubleduck.utils.TweenChain.get(this._back).wait(1400).tto({ alpha : 0},350);
					co.doubleduck.utils.TweenChain.get(this._overlay).wait(1400).tto({ alpha : 0.01},350);
					co.doubleduck.utils.TweenChain.get(this._painting).wait(1600).call(co.doubleduck.utils.TweenAnimator.shake,[this._painting,3,8,20]).wait(200).tto({ alpha : 0},600).wait(50).call(function() {
						while(_g._painting.get_numChildren() > 0) _g._painting.removeChildAt(0);
					});
				}
			}
		}
		if(e.type == "OngoingEvent") {
			this._currMission.removeEventListener("DoneEvent",$bind(this,this.handleItem));
			this._currMission.removeEventListener("OngoingEvent",$bind(this,this.handleItem));
			co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.CLOSE_MISSIONS);
			co.doubleduck.utils.TweenChain.get(this._backBtn).tto({ alpha : 1},200).call(function() {
				_g._backBtn.enabled = true;
				_g._midAnim = false;
			});
		}
	}
	,loadNextMission: function(delay) {
		co.doubleduck.pinata.data.Persistence.setInt(co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION,0);
		this.setupMission();
		var _g = this._currMission;
		_g.set_x(_g.get_x() - co.doubleduck.pinata.Game.getScreenSize().width);
		this._scrBox.addChild(this._currMission);
		this._currMission.addEventListener("DoneEvent",$bind(this,this.handleItem));
		this._currMission.addEventListener("OngoingEvent",$bind(this,this.handleItem));
		co.doubleduck.utils.TweenChain.get(this._currMission).wait(delay + 10).tto({ x : this._currMission.get_x() + co.doubleduck.pinata.Game.getScreenSize().width},300,motion.easing.Sine.get_easeOut()).wait(400).call(($_=this._currMission,$bind($_,$_.markIfDone)));
	}
	,getPiece: function(ind) {
		var rect = new openfl.geom.Rectangle();
		rect.width = Math.floor(this._srcPaint.width / 3);
		rect.height = Math.floor(this._srcPaint.height / 3);
		rect.x = ind % 3 * rect.width;
		rect.y = Math.floor(ind / 3) * rect.height;
		var newPiece = new openfl.display.BitmapData(Math.floor(rect.width),Math.floor(rect.height));
		newPiece.copyPixels(this._srcPaint,rect,new openfl.geom.Point(0,0));
		var piece = new openfl.display.Bitmap(newPiece);
		var _g = piece;
		_g.set_x(_g.get_x() - rect.width / 2);
		var _g1 = piece;
		_g1.set_y(_g1.get_y() - rect.height / 2);
		var spr = new openfl.display.Sprite();
		spr.addChild(piece);
		spr.set_x(rect.x + rect.width / 2);
		spr.set_y(rect.y + rect.height / 2);
		return spr;
	}
	,reshowNewPack: function() {
		co.doubleduck.utils.TweenChain.get(this._overlay).tto({ alpha : 0.65},250);
		co.doubleduck.utils.TweenChain.get(this._back).tto({ alpha : 1},150).call($bind(this,this.loadNextMission),[200]);
	}
	,handleBackBtn: function(e) {
		var _g = this;
		if(!this._isOpened) return;
		this._isOpened = false;
		this._midAnim = true;
		co.doubleduck.utils.SoundMgr.playSound("menu_open");
		co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.CLOSE_MISSIONS);
		this.dispatchEvent(new openfl.events.Event(openfl.events.Event.CLOSE));
		this._backBtn.enabled = false;
		co.doubleduck.utils.TweenChain.removeTweens(this._overlay);
		co.doubleduck.utils.TweenChain.get(this._overlay).tto({ alpha : 0},300);
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ x : 0},300,motion.easing.Sine.get_easeInOut()).call(function() {
			_g._overlay.set_visible(false);
			_g._tabBtn.enabled = true;
			_g._midAnim = false;
		});
	}
	,__class__: co.doubleduck.pinata.core.missions.MissionScr
});
co.doubleduck.pinata.core.pinatas = {};
co.doubleduck.pinata.core.pinatas.Pinata = function() {
	openfl.display.Sprite.call(this);
	this._hittable = false;
	var slashFactor = 0.45;
	this._slashRange = new openfl.geom.Rectangle(this._body.get_x() - this._body.get_width() * slashFactor * 0.5,this._body.get_y() - this._body.get_height() * slashFactor * 0.5,this._body.get_width() * slashFactor,this._body.get_height() * slashFactor);
	this._swipeRadSq = co.doubleduck.pinata.Game.getScreenSize().width * 0.17;
	this._swipeRadSq *= this._swipeRadSq;
	this._swipeInPos = null;
	this._swipeWasOut = false;
	this._tapBox = new openfl.display.Sprite();
	this._tapBox.set_alpha(0.01);
	this._tapBox.get_graphics().beginFill(8947848);
	this._tapBox.get_graphics().drawRect(0,0,co.doubleduck.pinata.Game.getScreenSize().width,co.doubleduck.pinata.Game.getScreenSize().height);
	this._tapBox.get_graphics().endFill();
	this._tapBox.addEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleTouch));
	this._tapBox.addEventListener(openfl.events.MouseEvent.MOUSE_MOVE,$bind(this,this.handleTouch));
	this._tapBox.set_x(-co.doubleduck.pinata.Game.getScreenSize().width / 2);
	this._tapBox.set_y(-co.doubleduck.pinata.Game.getScreenSize().height * 0.3);
	this.addChild(this._tapBox);
};
$hxClasses["co.doubleduck.pinata.core.pinatas.Pinata"] = co.doubleduck.pinata.core.pinatas.Pinata;
co.doubleduck.pinata.core.pinatas.Pinata.__name__ = ["co","doubleduck","pinata","core","pinatas","Pinata"];
co.doubleduck.pinata.core.pinatas.Pinata.create = function(data) {
	var pinType = data.type;
	if(pinType == "gift") {
		if(co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL) != Std["int"](data.id)) pinType = "normal";
	}
	if(pinType == "normal") {
		var pinatas = data.pinatas;
		var pinId = pinatas[Std.random(pinatas.length)];
		var pinHp = co.doubleduck.pinata.core.pinatas.Pinata.rollFromRange(data.pinataHP);
		var pinReward = co.doubleduck.pinata.core.pinatas.Pinata.rollFromRange(data.candyReward);
		return new co.doubleduck.pinata.core.pinatas.RegPinata(pinId,pinHp,pinReward);
	} else if(pinType == "gift") return new co.doubleduck.pinata.core.pinatas.GiftPinata(data.giftData); else if(pinType == "mission") return new co.doubleduck.pinata.core.pinatas.MissionPinata(data.pinId,data.pinReward);
	return null;
};
co.doubleduck.pinata.core.pinatas.Pinata.rollFromRange = function(range,forceRatio) {
	if(forceRatio == null) forceRatio = -1;
	var rangeVals = range.split("-");
	var min = co.doubleduck.pinata.meta.BigInt.fromString(rangeVals[0]);
	var max = co.doubleduck.pinata.meta.BigInt.fromString(rangeVals[1]);
	if(co.doubleduck.pinata.meta.BigInt.isEqual(min,max)) return min;
	var delta = co.doubleduck.pinata.meta.BigInt.subtract(max,min);
	var scalar = co.doubleduck.utils.Utils.nrand();
	if(forceRatio != -1) scalar = forceRatio;
	delta = co.doubleduck.pinata.meta.BigInt.mulScalar(delta,scalar);
	return co.doubleduck.pinata.meta.BigInt.add(min,delta);
};
co.doubleduck.pinata.core.pinatas.Pinata.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.pinatas.Pinata.prototype = $extend(openfl.display.Sprite.prototype,{
	animIn: function() {
	}
	,idleBodyAnim: function() {
		this._body.set_rotation(0);
		co.doubleduck.utils.TweenChain.get(this._body).tto({ rotation : 4},800,motion.easing.Sine.get_easeInOut()).tto({ rotation : 0},800,motion.easing.Sine.get_easeInOut()).wait(20).call($bind(this,this.idleBodyAnim));
	}
	,hit: function(amount,angle) {
		if(angle == null) angle = -1;
	}
	,getReward: function() {
		return this._reward;
	}
	,animVanish: function() {
	}
	,handleTouch: function(e) {
		if(e.type == openfl.events.MouseEvent.MOUSE_DOWN) this.hit(co.doubleduck.pinata.meta.Stats.getHitVal()); else if(e.type == openfl.events.MouseEvent.MOUSE_MOVE) {
			var dist = this.get_mouseX() * this.get_mouseX() + this.get_mouseY() * this.get_mouseY();
			if(dist <= this._swipeRadSq) {
				if(this._swipeWasOut) {
					if(this._swipeInPos == null) this._swipeInPos = new openfl.geom.Point(this.get_mouseX(),this.get_mouseY());
				}
			} else {
				if(!this._swipeWasOut) this._swipeWasOut = true;
				if(this._swipeInPos != null) {
					var angle = Math.atan2(this.get_mouseX() - this._swipeInPos.x,this._swipeInPos.y - this.get_mouseY());
					angle = angle * (180 / Math.PI) - 90;
					while(angle < 0) angle += 360;
					this.hit(co.doubleduck.pinata.meta.Stats.getHitVal(),angle);
					this._swipeInPos = null;
				}
			}
		}
	}
	,__class__: co.doubleduck.pinata.core.pinatas.Pinata
});
co.doubleduck.pinata.core.pinatas.GiftPinata = function(giftData) {
	this._hitDuration = Std["int"](giftData.duration);
	var hits = giftData.hitsRange.split("-");
	this._hitsMin = co.doubleduck.pinata.meta.BigInt.fromString(hits[0]);
	this._hitsMax = co.doubleduck.pinata.meta.BigInt.fromString(hits[1]);
	this._hitsRatioMax = co.doubleduck.pinata.meta.BigInt.roughDiv(this._hitsMax,this._hitsMin);
	var rewards = giftData.rewardRange.split("-");
	this._rewardMin = co.doubleduck.pinata.meta.BigInt.fromString(rewards[0]);
	this._rewardMax = co.doubleduck.pinata.meta.BigInt.fromString(rewards[1]);
	this._rewardRatioMax = co.doubleduck.pinata.meta.BigInt.roughDiv(this._rewardMax,this._rewardMin);
	this._hasStarted = false;
	this._totalHits = co.doubleduck.pinata.meta.BigInt.fromInt(0);
	this._body = new openfl.display.Sprite();
	var img = co.doubleduck.utils.DDAssets.getImage("images/pinatas/bonus.png");
	var _g = img;
	_g.set_x(_g.get_x() - img.get_width() / 2);
	var _g1 = img;
	_g1.set_y(_g1.get_y() - img.get_height() / 2);
	this._shakeBox = new openfl.display.Sprite();
	this._shakeBox.addChild(img);
	this._body.addChild(this._shakeBox);
	this._body.set_y(40);
	this._timeBar = new co.doubleduck.utils.ProgBar(co.doubleduck.utils.DDAssets.getImage("images/ui/time_bar_bg.png"),co.doubleduck.utils.DDAssets.getImage("images/ui/time_bar_fill.png"));
	this._timeBar.mouseEnabled = this._timeBar.mouseChildren = false;
	this._timeBar.set_x(-this._timeBar.get_width() / 2);
	this._timeBar.set_y(this._body.get_y() - this._body.get_height() / 2 - this._timeBar.get_height() - 30);
	this._timeBar.setFillPerc(1);
	this._timeBar.set_maskFrom(0.2);
	this._timeBar.set_maskTo(0.95);
	this._timeBar.set_alpha(0);
	this._shakeBox.set_scaleX(this._shakeBox.set_scaleY(0.6));
	co.doubleduck.pinata.core.pinatas.Pinata.call(this);
	this.addChildAt(this._timeBar,0);
	this.addChildAt(this._body,0);
	this._tapToStartTitle = new openfl.display.Sprite();
	var tapImg = co.doubleduck.utils.DDAssets.getImage("images/ui/tapfast.png");
	var _g2 = tapImg;
	_g2.set_x(_g2.get_x() - tapImg.get_width() / 2);
	var _g3 = tapImg;
	_g3.set_y(_g3.get_y() - tapImg.get_height() / 2);
	this._tapToStartTitle.addChild(tapImg);
	this._tapToStartTitle.set_y(this._body.get_y() - this._body.get_height());
	this._tapToStartTitle.set_alpha(0);
	this._tapToStartTitle.mouseChildren = this._tapToStartTitle.mouseEnabled = false;
	this.addChild(this._tapToStartTitle);
};
$hxClasses["co.doubleduck.pinata.core.pinatas.GiftPinata"] = co.doubleduck.pinata.core.pinatas.GiftPinata;
co.doubleduck.pinata.core.pinatas.GiftPinata.__name__ = ["co","doubleduck","pinata","core","pinatas","GiftPinata"];
co.doubleduck.pinata.core.pinatas.GiftPinata.__super__ = co.doubleduck.pinata.core.pinatas.Pinata;
co.doubleduck.pinata.core.pinatas.GiftPinata.prototype = $extend(co.doubleduck.pinata.core.pinatas.Pinata.prototype,{
	animIn: function() {
		var _g = this;
		co.doubleduck.utils.TweenChain.removeTweens(this._body);
		var _g1 = this._body;
		_g1.set_x(_g1.get_x() + 50);
		var _g2 = this._body;
		_g2.set_y(_g2.get_y() - 10);
		this._body.set_scaleX(this._body.set_scaleY(0.4));
		this._body.set_alpha(0);
		co.doubleduck.utils.TweenChain.get(this._body).wait(200).tto({ y : this._body.get_y() - 20},200,motion.easing.Sine.get_easeOut()).tto({ y : this._body.get_y() + 10},200,motion.easing.Sine.get_easeIn());
		co.doubleduck.utils.TweenChain.get(this._body).wait(200).tto({ x : 0, scaleX : 1, scaleY : 1, alpha : 1},400).call(function() {
			_g._hittable = true;
		});
		co.doubleduck.utils.TweenChain.get(this._tapToStartTitle).wait(450).tto({ alpha : 1},350);
		co.doubleduck.utils.TweenAnimator.nudge(this._tapToStartTitle);
	}
	,hit: function(amount,angle) {
		if(angle == null) angle = -1;
		if(!this._hittable) return;
		if(!this._hasStarted) {
			this._hasStarted = true;
			var dur = this._hitDuration * 1000;
			this._timeBar.setFillPerc(0,dur);
			co.doubleduck.utils.TweenChain.get(this._timeBar).wait(Math.floor(dur / 2)).call($bind(this,this.timeHalfPast)).wait(Math.floor(dur / 2)).call($bind(this,this.timeOver));
			this._hpsHitter = new co.doubleduck.utils.Delayer(250);
			this._hpsHitter.handler = $bind(this,this.handleHPS);
			this._hpsHitter.start();
			co.doubleduck.utils.TweenChain.removeTweens(this._tapToStartTitle);
			co.doubleduck.utils.TweenChain.get(this._tapToStartTitle).tto({ alpha : 0},150).call($bind(this,this.removeChild),[this._tapToStartTitle]);
			this._tapToStartTitle = null;
			co.doubleduck.utils.TweenChain.get(this._timeBar).tto({ alpha : 1},200);
		}
		this._totalHits = co.doubleduck.pinata.meta.BigInt.add(this._totalHits,amount);
		this.recalcReward();
		co.doubleduck.utils.SoundMgr.playSound("hit" + (Std.random(4) + 1));
		co.doubleduck.utils.TweenChain.removeTweens(this._body);
		this._body.set_scaleX(this._body.set_scaleY(1));
		var factor;
		if(Math.random() > 0.5) factor = 0.07; else factor = -0.07;
		co.doubleduck.utils.TweenChain.get(this._body).tto({ scaleX : 1 + factor, scaleY : 1 - factor},45,motion.easing.Sine.get_easeOut()).tto({ scaleX : 1, scaleY : 1},45,motion.easing.Sine.get_easeIn());
		var slash = co.doubleduck.pinata.core.pinatas.SlashAnim.createNew(this._slashRange,angle);
		this.addChild(slash);
		var dmgText = co.doubleduck.utils.Fonter.getString(amount.toString(),"images/fonts/yellow_big/");
		dmgText.set_alpha(0.8);
		this.addChild(dmgText);
		co.doubleduck.utils.TweenChain.get(dmgText).tto({ x : Math.random() * 60 + 30},300);
		co.doubleduck.utils.TweenChain.get(dmgText).tto({ y : -(Math.random() * 50 + 20)},300,motion.easing.Sine.get_easeOut());
		co.doubleduck.utils.TweenChain.get(dmgText).wait(200).tto({ alpha : 0},700,motion.easing.Sine.get_easeOut()).wait(20).call($bind(this,this.removeChild),[dmgText]);
	}
	,recalcReward: function() {
		var ratio = co.doubleduck.pinata.meta.BigInt.roughDiv(this._totalHits,this._hitsMin);
		var sizeRat = co.doubleduck.utils.Utils.map(ratio,0,this._hitsRatioMax,0.6,1);
		co.doubleduck.utils.TweenChain.get(this._shakeBox).tto({ scaleX : sizeRat, scaleY : sizeRat},100);
		ratio = co.doubleduck.utils.Utils.map(ratio,1,this._hitsRatioMax,1,this._rewardRatioMax);
		this._reward = co.doubleduck.pinata.meta.BigInt.mulScalar(this._rewardMin,ratio);
		if(this._rewardTitle != null) {
			this.removeChild(this._rewardTitle);
			this._rewardTitle = null;
		}
		this._rewardTitle = co.doubleduck.utils.Fonter.getString("$" + this._reward.toString(),"images/fonts/yellow_big/");
		this._rewardTitle.set_y(120);
		this._rewardTitle.mouseChildren = this._rewardTitle.mouseEnabled = false;
		this.addChild(this._rewardTitle);
	}
	,handleHPS: function() {
		var hpsPart = co.doubleduck.pinata.meta.BigInt.mulScalar(co.doubleduck.pinata.meta.Stats.getHPS(),0.25);
		this._totalHits = co.doubleduck.pinata.meta.BigInt.add(this._totalHits,hpsPart);
		this.recalcReward();
	}
	,timeHalfPast: function() {
		co.doubleduck.utils.TweenAnimator.shake(this._shakeBox,6,60);
	}
	,timeOver: function() {
		this._hpsHitter.stop();
		this._hittable = false;
		this.recalcReward();
		var data = { };
		data.level = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL);
		data.candyCount = co.doubleduck.pinata.meta.Stats.getPCandies().toFullString();
		data.killCount = co.doubleduck.pinata.data.Persistence.getInt(co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT);
		data.toolsState = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.TOOLS_STATE);
		data.currTapHits = co.doubleduck.pinata.meta.Stats.getHitVal().toFullString();
		data.currHPS = co.doubleduck.pinata.meta.Stats.getHPS().toFullString();
		data.totalHits = this._totalHits.toFullString();
		com.funtomic.GameOps.reportEvent("gift_won",data);
		co.doubleduck.utils.TweenChain.get(this._timeBar).tto({ alpha : 0},250).call($bind(this,this.removeChild),[this._timeBar]);
		co.doubleduck.utils.TweenChain.get(this._rewardTitle).wait(500).tto({ alpha : 0.01},200);
		co.doubleduck.utils.TweenChain.removeTweens(this._shakeBox);
		this._shakeBox.set_x(this._shakeBox.set_y(0));
		co.doubleduck.utils.TweenAnimator.shake(this._shakeBox,20,25);
		co.doubleduck.utils.TweenChain.get(this._shakeBox).wait(1200).call($bind(this,this.explodeGift));
	}
	,explodeGift: function() {
		var _g = this;
		var rpart = new openfl.display.Sprite();
		var img = co.doubleduck.utils.DDAssets.getImage("images/pinatas/bonus-r.png");
		img.set_x(-img.get_width());
		img.set_y(-img.get_height() / 2);
		rpart.set_scaleX(rpart.set_scaleY(this._shakeBox.get_scaleX()));
		rpart.addChild(img);
		var lpart = new openfl.display.Sprite();
		img = co.doubleduck.utils.DDAssets.getImage("images/pinatas/bonus-l.png");
		img.set_y(-img.get_height() / 2);
		lpart.set_scaleX(lpart.set_scaleY(this._shakeBox.get_scaleX()));
		lpart.addChild(img);
		rpart.set_x(this._body.get_x() + this._body.get_width() / 2);
		rpart.set_y(this._body.get_y());
		lpart.set_x(this._body.get_x() - this._body.get_width() / 2);
		lpart.set_y(this._body.get_y());
		co.doubleduck.utils.TweenChain.get(this).tto({ scaleX : 0.7, scaleY : 0.7},130,motion.easing.Sine.get_easeOut()).call(function() {
			_g.set_scaleX(_g.set_scaleY(1));
			_g.removeChild(_g._body);
			_g.addChildAt(rpart,_g.getChildIndex(_g._rewardTitle));
			_g.addChildAt(lpart,_g.getChildIndex(_g._rewardTitle));
			var dist = 50;
			_g.dispatchEvent(new openfl.events.Event("OpenedEvent"));
			co.doubleduck.utils.TweenChain.removeTweens(_g._rewardTitle);
			_g._rewardTitle.set_scaleY(_g._rewardTitle.set_scaleX(1.6));
			_g._rewardTitle.set_y(_g._body.get_y() - 90);
			_g._rewardTitle.set_alpha(1);
			co.doubleduck.utils.TweenChain.get(_g._rewardTitle).wait(1300).tto({ alpha : 0},600);
			co.doubleduck.utils.TweenChain.get(rpart).tto({ x : rpart.get_x() + dist, y : rpart.get_y() - dist, rotation : -20},350,motion.easing.Cubic.get_easeOut()).tto({ x : rpart.get_x() + dist * 1.05, y : rpart.get_y() - dist * 1.05, rotation : -22},300).tto({ x : rpart.get_x() + dist * 6, y : rpart.get_y() - dist * 3, rotation : -43},250,motion.easing.Cubic.get_easeIn());
			co.doubleduck.utils.TweenChain.get(lpart).tto({ x : lpart.get_x() - dist, y : lpart.get_y() - dist, rotation : 20},350,motion.easing.Cubic.get_easeOut()).call($bind(_g,_g.dispatchEvent),[new openfl.events.Event("ClearingEvent")]).tto({ x : lpart.get_x() - dist * 1.05, y : lpart.get_y() - dist * 1.05, rotation : 22},300).tto({ x : lpart.get_x() - dist * 6, y : lpart.get_y() - dist * 3, rotation : 43},250,motion.easing.Cubic.get_easeIn()).wait(1900).call($bind(_g,_g.dispatchEvent),[new openfl.events.Event("ClearedEvent")]);
			var explode = new co.doubleduck.pinata.core.pinatas.ExplodeAnim();
			explode.set_x(_g._body.get_x() - 59. * explode.get_scaleX());
			explode.set_y(_g._body.get_y() - 59. * explode.get_scaleY());
			_g.addChild(explode);
		});
	}
	,animVanish: function() {
		this._hittable = false;
		co.doubleduck.utils.TweenChain.removeTweens(this._body);
		co.doubleduck.utils.TweenChain.removeTweens(this._timeBar);
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ alpha : 0},200).call($bind(this,this.dispatchEvent),[new openfl.events.Event("ClearedEvent")]);
	}
	,__class__: co.doubleduck.pinata.core.pinatas.GiftPinata
});
co.doubleduck.pinata.core.pinatas.SlashAnim = function() {
	var behDatas = new Array();
	behDatas.push(new spritesheet.data.BehaviorData("idle",[0,1,2,3],false,19,80.,16.));
	var sheet = co.doubleduck.utils.DDAssets.getSpritesheet("images/strike.png",4,1,160,32,behDatas);
	co.doubleduck.utils.AnimSprite.call(this,sheet);
	this.showBehavior("idle");
	this.mouseChildren = this.mouseEnabled = false;
	this._lastTime = openfl.Lib.getTimer();
	this.addEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
	this.addEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDone));
};
$hxClasses["co.doubleduck.pinata.core.pinatas.SlashAnim"] = co.doubleduck.pinata.core.pinatas.SlashAnim;
co.doubleduck.pinata.core.pinatas.SlashAnim.__name__ = ["co","doubleduck","pinata","core","pinatas","SlashAnim"];
co.doubleduck.pinata.core.pinatas.SlashAnim.createNew = function(range,angle) {
	if(angle == null) angle = -1;
	var slash = new co.doubleduck.pinata.core.pinatas.SlashAnim();
	slash.set_x(range.x + Math.random() * range.width);
	slash.set_y(range.y + Math.random() * range.height);
	if(angle == -1) slash.set_rotation(Math.random() * 360); else slash.set_rotation(angle);
	return slash;
};
co.doubleduck.pinata.core.pinatas.SlashAnim.__super__ = co.doubleduck.utils.AnimSprite;
co.doubleduck.pinata.core.pinatas.SlashAnim.prototype = $extend(co.doubleduck.utils.AnimSprite.prototype,{
	handleTick: function(e) {
		var time = openfl.Lib.getTimer();
		var delta = time - this._lastTime;
		this.update(delta);
		this.bitmap.smoothing = true;
		this._lastTime = time;
	}
	,handleDone: function(e) {
		this.removeEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
		this.removeEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDone));
		if(this.parent != null) this.parent.removeChild(this);
	}
	,__class__: co.doubleduck.pinata.core.pinatas.SlashAnim
});
co.doubleduck.pinata.core.pinatas.ExplodeAnim = function() {
	var behDatas = new Array();
	behDatas.push(new spritesheet.data.BehaviorData("idle",[0,1,2,3,4,5],false,19));
	var sheet = co.doubleduck.utils.DDAssets.getSpritesheet("images/explosion.png",6,1,118,118,behDatas);
	co.doubleduck.utils.AnimSprite.call(this,sheet);
	this.showBehavior("idle");
	this._lastTime = openfl.Lib.getTimer();
	this.set_scaleX(this.set_scaleY(1.5));
	this.set_alpha(0.6);
	this.addEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
	this.addEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDone));
};
$hxClasses["co.doubleduck.pinata.core.pinatas.ExplodeAnim"] = co.doubleduck.pinata.core.pinatas.ExplodeAnim;
co.doubleduck.pinata.core.pinatas.ExplodeAnim.__name__ = ["co","doubleduck","pinata","core","pinatas","ExplodeAnim"];
co.doubleduck.pinata.core.pinatas.ExplodeAnim.__super__ = co.doubleduck.utils.AnimSprite;
co.doubleduck.pinata.core.pinatas.ExplodeAnim.prototype = $extend(co.doubleduck.utils.AnimSprite.prototype,{
	handleTick: function(e) {
		var time = openfl.Lib.getTimer();
		var delta = time - this._lastTime;
		this.update(delta);
		this.bitmap.smoothing = true;
		this._lastTime = time;
	}
	,handleDone: function(e) {
		this.removeEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
		this.removeEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDone));
		if(this.parent != null) this.parent.removeChild(this);
	}
	,__class__: co.doubleduck.pinata.core.pinatas.ExplodeAnim
});
co.doubleduck.pinata.core.pinatas.RegPinata = function(pinataID,hp,reward) {
	this._id = pinataID;
	this._hp = hp;
	this._initialHp = this._hp.clone();
	this._reward = reward;
	this._rope = co.doubleduck.utils.DDAssets.getImage("images/rope.png");
	this._body = new openfl.display.Sprite();
	var img = co.doubleduck.utils.DDAssets.getImage("images/pinatas/p" + pinataID + ".png");
	var _g = img;
	_g.set_x(_g.get_x() - img.get_width() / 2);
	var _g1 = img;
	_g1.set_y(_g1.get_y() - img.get_height() / 2);
	this._body.addChild(img);
	this._rope.set_y(this._body.get_y() - this._rope.get_height());
	this._hpBar = new co.doubleduck.utils.ProgBar(co.doubleduck.utils.DDAssets.getImage("images/ui/hp_bg.png"),co.doubleduck.utils.DDAssets.getImage("images/ui/hp_fill.png"));
	this._hpBar.mouseEnabled = this._hpBar.mouseChildren = false;
	this._hpBar.set_x(-this._hpBar.get_width() / 2);
	this._hpBar.set_y(this._body.get_height() * 0.5 + 5);
	this._hpBar.setFillPerc(1);
	this._hpBar.set_maskFrom(0.06);
	this._hpBar.set_maskTo(0.94);
	this._hpBar.set_alpha(0);
	co.doubleduck.pinata.core.pinatas.Pinata.call(this);
	this.addChildAt(this._hpBar,0);
	this.addChildAt(this._body,0);
	this.addChildAt(this._rope,0);
};
$hxClasses["co.doubleduck.pinata.core.pinatas.RegPinata"] = co.doubleduck.pinata.core.pinatas.RegPinata;
co.doubleduck.pinata.core.pinatas.RegPinata.__name__ = ["co","doubleduck","pinata","core","pinatas","RegPinata"];
co.doubleduck.pinata.core.pinatas.RegPinata.__super__ = co.doubleduck.pinata.core.pinatas.Pinata;
co.doubleduck.pinata.core.pinatas.RegPinata.prototype = $extend(co.doubleduck.pinata.core.pinatas.Pinata.prototype,{
	initHittable: function() {
		this._hittable = true;
		this.startTakeHPS(true);
		this.idleBodyAnim();
	}
	,animIn: function() {
		co.doubleduck.utils.TweenChain.removeTweens(this._body);
		this._body.set_y(-(this.get_y() + this._body.get_height() / 2 + 10));
		this._body.set_rotation(30);
		this._rope.set_y(this._body.get_y() - this._rope.get_height());
		co.doubleduck.utils.TweenChain.get(this._body).tto({ y : 0},900,motion.easing.Bounce.get_easeOut()).call($bind(this,this.initHittable));
		co.doubleduck.utils.TweenChain.get(this._body).tto({ rotation : 0},300).tto({ rotation : 12},300).tto({ rotation : 0},200);
		co.doubleduck.utils.TweenChain.get(this._rope).tto({ y : -this._rope.get_height()},900,motion.easing.Bounce.get_easeOut());
		this._rope.set_rotation(10);
		this._rope.set_x(10);
		co.doubleduck.utils.TweenChain.get(this._rope).tto({ rotation : 1, x : 5},300).tto({ rotation : -2, x : -7},300).tto({ rotation : 0, x : 0},200);
		co.doubleduck.utils.TweenChain.get(this._hpBar).wait(700).tto({ alpha : 1},150);
	}
	,hit: function(amount,angle) {
		if(angle == null) angle = -1;
		if(!this._hittable) return;
		co.doubleduck.utils.TweenChain.removeTweens(this._hpBar);
		this._hpBar.set_alpha(1);
		this._hpBar.setFillPerc(this._hpBar.getFillPerc());
		this._hp = co.doubleduck.pinata.meta.BigInt.mulScalar(this._initialHp,this._hpBar.getFillPerc());
		co.doubleduck.utils.SoundMgr.playSound("hit" + (Std.random(4) + 1));
		co.doubleduck.utils.TweenChain.removeTweens(this._body);
		this._body.set_scaleX(this._body.set_scaleY(1));
		var factor;
		if(Math.random() > 0.5) factor = 0.07; else factor = -0.07;
		co.doubleduck.utils.TweenChain.get(this._body).tto({ scaleX : 1 + factor, scaleY : 1 - factor},45,motion.easing.Sine.get_easeOut()).tto({ scaleX : 1, scaleY : 1},45,motion.easing.Sine.get_easeIn()).call($bind(this,this.idleBodyAnim));
		var slash = co.doubleduck.pinata.core.pinatas.SlashAnim.createNew(this._slashRange,angle);
		this.addChild(slash);
		var dmgText = co.doubleduck.utils.Fonter.getString(amount.toString(),"images/fonts/yellow_big/");
		dmgText.set_alpha(0.8);
		this.addChild(dmgText);
		co.doubleduck.utils.TweenChain.get(dmgText).tto({ x : Math.random() * 60 + 30},300);
		co.doubleduck.utils.TweenChain.get(dmgText).tto({ y : -(Math.random() * 50 + 20)},300,motion.easing.Sine.get_easeOut());
		co.doubleduck.utils.TweenChain.get(dmgText).wait(200).tto({ alpha : 0},700,motion.easing.Sine.get_easeOut()).wait(20).call($bind(this,this.removeChild),[dmgText]);
		this._hp = co.doubleduck.pinata.meta.BigInt.subtract(this._hp,amount);
		var ratio = co.doubleduck.pinata.meta.BigInt.roughDiv(this._hp,this._initialHp);
		this._hpBar.setFillPerc(ratio);
		if(co.doubleduck.pinata.meta.BigInt.isZero(this._hp)) {
			co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.SHOW_BUBBLE);
			this._hittable = false;
			this.animDie();
		} else this.startTakeHPS();
	}
	,animVanish: function() {
		if(co.doubleduck.pinata.meta.BigInt.isZero(this._hp)) return;
		this._hittable = false;
		if(this._rope != null) {
			co.doubleduck.utils.TweenChain.removeTweens(this._rope);
			co.doubleduck.utils.TweenChain.get(this._rope).tto({ alpha : 0},50);
		}
		co.doubleduck.utils.TweenChain.removeTweens(this._body);
		co.doubleduck.utils.TweenChain.removeTweens(this._hpBar);
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ alpha : 0},200).call($bind(this,this.dispatchEvent),[new openfl.events.Event("ClearedEvent")]);
	}
	,startTakeHPS: function(andListen) {
		if(andListen == null) andListen = false;
		var hps = co.doubleduck.pinata.meta.Stats.getHPS();
		if(!co.doubleduck.pinata.meta.BigInt.isZero(hps)) this.reapplyHPS(hps);
		if(andListen) co.doubleduck.pinata.meta.Stats.addListener("UpdateHPSEvent",$bind(this,this.updateHPS));
	}
	,updateHPS: function(e) {
		this._hpBar.setFillPerc(this._hpBar.getFillPerc());
		this._hp = co.doubleduck.pinata.meta.BigInt.mulScalar(this._initialHp,this._hpBar.getFillPerc());
		this.startTakeHPS();
	}
	,reapplyHPS: function(hps) {
		var _g = this;
		co.doubleduck.utils.TweenChain.removeTweens(this._hpBar);
		this._hpBar.set_alpha(1);
		this._hpBar.setFillPerc(this._hpBar.getFillPerc());
		var dur = Math.floor(co.doubleduck.pinata.meta.BigInt.roughDiv(this._hp,hps) * 1000) + 1;
		this._hpBar.setFillPerc(0,dur);
		co.doubleduck.utils.TweenChain.get(this._hpBar).wait(dur).call(function() {
			_g._hittable = false;
			_g._hp = co.doubleduck.pinata.meta.BigInt.fromInt(0);
			_g.animDie();
		});
	}
	,animDie: function() {
		var _g = this;
		co.doubleduck.pinata.meta.Stats.removeListener("UpdateHPSEvent",$bind(this,this.updateHPS));
		if(this.contains(this._hpBar)) co.doubleduck.utils.TweenChain.get(this._hpBar).tto({ alpha : 0},50).call($bind(this,this.removeChild),[this._hpBar]);
		if(this.contains(this._rope)) co.doubleduck.utils.TweenChain.get(this._rope).tto({ y : -(this.get_y() + this._rope.get_height() + 10)},100).call($bind(this,this.removeChild),[this._rope]);
		var rpart = new openfl.display.Sprite();
		var img = co.doubleduck.utils.DDAssets.getImage("images/pinatas/p" + this._id + "-r.png");
		img.set_x(-img.get_width());
		img.set_y(-img.get_height() / 2);
		rpart.addChild(img);
		var lpart = new openfl.display.Sprite();
		img = co.doubleduck.utils.DDAssets.getImage("images/pinatas/p" + this._id + "-l.png");
		img.set_y(-img.get_height() / 2);
		lpart.addChild(img);
		rpart.set_x(this._body.get_x() + this._body.get_width() / 2);
		rpart.set_y(this._body.get_y());
		lpart.set_x(this._body.get_x() - this._body.get_width() / 2);
		lpart.set_y(this._body.get_y());
		co.doubleduck.utils.TweenChain.get(this).tto({ scaleX : 0.7, scaleY : 0.7},130,motion.easing.Sine.get_easeOut()).call(function() {
			co.doubleduck.utils.SoundMgr.playSound("pinata_crack");
			_g.set_scaleX(_g.set_scaleY(1));
			_g.removeChild(_g._body);
			_g.addChild(rpart);
			_g.addChild(lpart);
			var dist = 50;
			_g.dispatchEvent(new openfl.events.Event("OpenedEvent"));
			co.doubleduck.utils.TweenChain.get(rpart).tto({ x : rpart.get_x() + dist, y : rpart.get_y() - dist, rotation : -20},250,motion.easing.Sine.get_easeOut()).tto({ x : rpart.get_x() + dist, y : rpart.get_y() - dist * 2, alpha : 0},700);
			co.doubleduck.utils.TweenChain.get(lpart).tto({ x : lpart.get_x() - dist, y : lpart.get_y() - dist, rotation : 20},250,motion.easing.Sine.get_easeOut()).call($bind(_g,_g.dispatchEvent),[new openfl.events.Event("ClearingEvent")]).tto({ x : lpart.get_x() - dist, y : lpart.get_y() - dist * 2, alpha : 0},700).wait(100).call($bind(_g,_g.dispatchEvent),[new openfl.events.Event("ClearedEvent")]);
			var explode = new co.doubleduck.pinata.core.pinatas.ExplodeAnim();
			explode.set_x(_g._body.get_x() - 59. * explode.get_scaleX());
			explode.set_y(_g._body.get_y() - 59. * explode.get_scaleY());
			_g.addChild(explode);
		});
	}
	,__class__: co.doubleduck.pinata.core.pinatas.RegPinata
});
co.doubleduck.pinata.core.pinatas.MissionPinata = function(pinataID,reward) {
	co.doubleduck.pinata.core.pinatas.RegPinata.call(this,pinataID,co.doubleduck.pinata.meta.BigInt.fromInt(1),reward);
	this.removeChild(this._hpBar);
	this.removeChild(this._rope);
};
$hxClasses["co.doubleduck.pinata.core.pinatas.MissionPinata"] = co.doubleduck.pinata.core.pinatas.MissionPinata;
co.doubleduck.pinata.core.pinatas.MissionPinata.__name__ = ["co","doubleduck","pinata","core","pinatas","MissionPinata"];
co.doubleduck.pinata.core.pinatas.MissionPinata.__super__ = co.doubleduck.pinata.core.pinatas.RegPinata;
co.doubleduck.pinata.core.pinatas.MissionPinata.prototype = $extend(co.doubleduck.pinata.core.pinatas.RegPinata.prototype,{
	__class__: co.doubleduck.pinata.core.pinatas.MissionPinata
});
co.doubleduck.pinata.core.tools = {};
co.doubleduck.pinata.core.tools.ToolAnims = function() {
	openfl.display.Sprite.call(this);
	this.mouseEnabled = this.mouseChildren = false;
	this._toolAnimsToShow = this.getToolsToShow();
	this._toolAnims = new haxe.ds.StringMap();
	var _g = 0;
	var _g1 = this._toolAnimsToShow;
	while(_g < _g1.length) {
		var toolId = _g1[_g];
		++_g;
		var toolAnim = this.getToolAnim(toolId);
		this._toolAnims.set(toolId,toolAnim);
		this.addChild(toolAnim);
	}
	co.doubleduck.pinata.meta.Stats.addListener("UpdateToolEvent",$bind(this,this.handleToolUpdrade));
};
$hxClasses["co.doubleduck.pinata.core.tools.ToolAnims"] = co.doubleduck.pinata.core.tools.ToolAnims;
co.doubleduck.pinata.core.tools.ToolAnims.__name__ = ["co","doubleduck","pinata","core","tools","ToolAnims"];
co.doubleduck.pinata.core.tools.ToolAnims.animRamInto = function(obj) {
	if(Math.random() > 0.5) {
		obj.set_x(-obj.get_width());
		var dir = Math.random();
		var scr = co.doubleduck.pinata.Game.getScreenSize();
		obj.set_y(scr.height * (dir * 0.4 + 0.1));
		obj.set_rotation((1 - dir) * 60 + 60);
		var targetPos = new openfl.geom.Point(scr.width * 0.35,scr.height * (dir * 0.2 + 0.2));
		var recoilPos = new openfl.geom.Point(co.doubleduck.utils.Utils.map(0.8,0,1,obj.get_x(),targetPos.x),co.doubleduck.utils.Utils.map(0.8,0,1,obj.get_y(),targetPos.y));
		co.doubleduck.utils.TweenChain.get(obj).tto({ x : targetPos.x, y : targetPos.y},300,motion.easing.Sine.get_easeOut()).tto({ x : recoilPos.x, y : recoilPos.y},100,motion.easing.Sine.get_easeOut()).tto({ x : targetPos.x, y : targetPos.y},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ x : recoilPos.x, y : recoilPos.y},100,motion.easing.Sine.get_easeOut()).tto({ x : targetPos.x, y : targetPos.y},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ x : recoilPos.x, y : recoilPos.y},100,motion.easing.Sine.get_easeOut()).tto({ x : targetPos.x, y : targetPos.y},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ x : obj.get_x(), y : obj.get_y()},300,motion.easing.Sine.get_easeIn()).wait(20 + Std.random(550)).call(co.doubleduck.pinata.core.tools.ToolAnims.animRamInto,[obj]);
	} else {
		var scr1 = co.doubleduck.pinata.Game.getScreenSize();
		obj.set_x(scr1.width + obj.get_width());
		var dir1 = Math.random();
		obj.set_y(scr1.height * (dir1 * 0.4 + 0.1));
		obj.set_rotation(dir1 * 60 - 120);
		var targetPos1 = new openfl.geom.Point(scr1.width * 0.65,scr1.height * (dir1 * 0.2 + 0.2));
		var recoilPos1 = new openfl.geom.Point(co.doubleduck.utils.Utils.map(0.8,0,1,obj.get_x(),targetPos1.x),co.doubleduck.utils.Utils.map(0.8,0,1,obj.get_y(),targetPos1.y));
		co.doubleduck.utils.TweenChain.get(obj).tto({ x : targetPos1.x, y : targetPos1.y},300,motion.easing.Sine.get_easeOut()).tto({ x : recoilPos1.x, y : recoilPos1.y},100,motion.easing.Sine.get_easeOut()).tto({ x : targetPos1.x, y : targetPos1.y},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ x : recoilPos1.x, y : recoilPos1.y},100,motion.easing.Sine.get_easeOut()).tto({ x : targetPos1.x, y : targetPos1.y},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ x : recoilPos1.x, y : recoilPos1.y},100,motion.easing.Sine.get_easeOut()).tto({ x : targetPos1.x, y : targetPos1.y},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ x : obj.get_x(), y : obj.get_y()},300,motion.easing.Sine.get_easeIn()).wait(20 + Std.random(550)).call(co.doubleduck.pinata.core.tools.ToolAnims.animRamInto,[obj]);
	}
};
co.doubleduck.pinata.core.tools.ToolAnims.animBatSmack = function(obj,init) {
	if(init == null) init = false;
	if(init) {
		var bmp = obj.getChildAt(0);
		var _g = bmp;
		_g.set_y(_g.get_y() - bmp.get_height());
	}
	if(Math.random() > 0.5) {
		var scr = co.doubleduck.pinata.Game.getScreenSize();
		obj.set_x(scr.width * 0.32);
		var dir = Math.random();
		obj.set_y(scr.height * (dir * 0.2 + 0.27));
		var baseRot = (1 - dir) * 60 - 30;
		obj.set_rotation(baseRot - 10);
		obj.set_alpha(0);
		co.doubleduck.utils.TweenChain.get(obj).tto({ alpha : 1, rotation : baseRot},200,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot - 20},100,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot + 20},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ rotation : baseRot - 20},100,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot + 20},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ rotation : baseRot - 20},100,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot + 20},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ rotation : baseRot},100,motion.easing.Sine.get_easeOut()).wait(50).tto({ alpha : 0, rotation : baseRot - 10},200,motion.easing.Sine.get_easeIn()).wait(20 + Std.random(550)).call(co.doubleduck.pinata.core.tools.ToolAnims.animBatSmack,[obj]);
	} else {
		var scr1 = co.doubleduck.pinata.Game.getScreenSize();
		obj.set_x(scr1.width * 0.68);
		var dir1 = Math.random();
		obj.set_y(scr1.height * (dir1 * 0.2 + 0.27));
		var baseRot1 = dir1 * 60 - 30;
		obj.set_rotation(baseRot1 + 10);
		co.doubleduck.utils.TweenChain.get(obj).tto({ alpha : 1, rotation : baseRot1},200,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot1 + 20},100,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot1 - 20},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ rotation : baseRot1 + 20},100,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot1 - 20},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ rotation : baseRot1 + 20},100,motion.easing.Sine.get_easeOut()).tto({ rotation : baseRot1 - 20},60,motion.easing.Sine.get_easeIn()).wait(30).tto({ rotation : baseRot1},100,motion.easing.Sine.get_easeOut()).wait(50).tto({ alpha : 0, rotation : baseRot1 + 10},200,motion.easing.Sine.get_easeIn()).wait(20 + Std.random(550)).call(co.doubleduck.pinata.core.tools.ToolAnims.animBatSmack,[obj]);
	}
};
co.doubleduck.pinata.core.tools.ToolAnims.animRandomly = function(obj) {
	co.doubleduck.utils.TweenChain.get(obj).tto({ x : 100 + Math.random() * 100, y : 100 + Math.random() * 100},400,motion.easing.Sine.get_easeInOut()).tto({ x : 100 + Math.random() * 100, y : 100 + Math.random() * 100},400,motion.easing.Sine.get_easeInOut()).wait(20).call(co.doubleduck.pinata.core.tools.ToolAnims.animRandomly,[obj]);
};
co.doubleduck.pinata.core.tools.ToolAnims.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.tools.ToolAnims.prototype = $extend(openfl.display.Sprite.prototype,{
	toggleShow: function(flag) {
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ alpha : flag?1:0},100);
	}
	,getToolsToShow: function() {
		var res = new Array();
		var _g = 0;
		var _g1 = co.doubleduck.pinata.data.GameplayDB.getTools();
		while(_g < _g1.length) {
			var curr = _g1[_g];
			++_g;
			if(curr.id == "good-ol-bat") continue;
			if(co.doubleduck.pinata.meta.Stats.getToolLevel(curr.id) >= 1) res.push(curr.id);
			if(res.length > 3) res.shift();
		}
		return res;
	}
	,handleToolUpdrade: function(e) {
		var currTools = this.getToolsToShow();
		if(currTools.join(",") != this._toolAnimsToShow.join(",")) {
			if(this._toolAnimsToShow.length == currTools.length) {
				var oldTool = this._toolAnims.get(this._toolAnimsToShow[0]);
				this._toolAnims.remove(this._toolAnimsToShow[0]);
				co.doubleduck.utils.TweenChain.removeTweens(oldTool);
				this.removeChild(oldTool);
				oldTool = null;
			}
			var newToolId = currTools[currTools.length - 1];
			var newTool = this.getToolAnim(newToolId);
			this._toolAnims.set(newToolId,newTool);
			this.addChild(newTool);
			this._toolAnimsToShow = currTools;
		}
	}
	,getToolAnim: function(toolId) {
		var tool = new openfl.display.Sprite();
		var bmp = co.doubleduck.utils.DDAssets.getImage("images/tools_menu/tools/" + toolId + "/anim.png");
		var _g = bmp;
		_g.set_x(_g.get_x() - bmp.get_width() / 2);
		tool.addChild(bmp);
		var type = co.doubleduck.pinata.data.GameplayDB.getToolData(toolId).animType;
		switch(type) {
		case "smack":
			co.doubleduck.pinata.core.tools.ToolAnims.animBatSmack(tool,true);
			break;
		case "ram":
			co.doubleduck.pinata.core.tools.ToolAnims.animRamInto(tool);
			break;
		}
		return tool;
	}
	,__class__: co.doubleduck.pinata.core.tools.ToolAnims
});
co.doubleduck.pinata.core.tools.ToolItem = function(data) {
	co.doubleduck.pinata.meta.ScrolledItem.call(this);
	this._data = data;
	this._id = this._data.id;
	this._dir = "images/tools_menu/tools/" + this._id + "/";
	var toolLvl = co.doubleduck.pinata.meta.Stats.getToolLevel(this._id);
	this._hasBuyNotif = false;
	this._back = co.doubleduck.utils.DDAssets.getImage("images/tools_menu/item_bg.png");
	this.addChild(this._back);
	this._icon = co.doubleduck.utils.DDAssets.getImage(this._dir + "pic.png");
	this._icon.set_y(this._back.get_height() / 2 - this._icon.get_height() / 2);
	this._icon.set_x(this._icon.get_y());
	this.addChild(this._icon);
	this._title = co.doubleduck.utils.DDAssets.getImage(this._dir + "name.png");
	this._title.set_y(this._icon.get_y());
	this._title.set_x(this._icon.get_x() + this._icon.get_width() + 5);
	this.addChild(this._title);
	this.setupVals();
	var notif = co.doubleduck.utils.DDAssets.getImage("images/ui/attention_tag.png");
	var _g = notif;
	_g.set_x(_g.get_x() - notif.get_width() / 2);
	var _g1 = notif;
	_g1.set_y(_g1.get_y() - notif.get_height() / 2);
	this._notif = new openfl.display.Sprite();
	this._notif.addChild(notif);
	this._notif.set_x(this._upgradeBtn.get_x() - this._upgradeBtn.get_width() / 2 + 10);
	this._notif.set_y(this._upgradeBtn.get_y() - this._upgradeBtn.get_height() / 2 + 10);
	this._notif.set_visible(false);
	this.addChild(this._notif);
	co.doubleduck.pinata.meta.Stats.addListener("UpdateCandiesEvent",$bind(this,this.handleCandies));
};
$hxClasses["co.doubleduck.pinata.core.tools.ToolItem"] = co.doubleduck.pinata.core.tools.ToolItem;
co.doubleduck.pinata.core.tools.ToolItem.__name__ = ["co","doubleduck","pinata","core","tools","ToolItem"];
co.doubleduck.pinata.core.tools.ToolItem.__super__ = co.doubleduck.pinata.meta.ScrolledItem;
co.doubleduck.pinata.core.tools.ToolItem.prototype = $extend(co.doubleduck.pinata.meta.ScrolledItem.prototype,{
	getToolId: function() {
		return this._id;
	}
	,setBuyNotif: function(flag) {
		if(this._notif.get_visible() == flag) return;
		if(flag) this.animNotif(); else co.doubleduck.utils.TweenChain.removeTweens(this._notif);
		this._notif.set_visible(flag);
	}
	,animNotif: function() {
		co.doubleduck.utils.TweenChain.removeTweens(this._notif);
		this._notif.set_scaleX(this._notif.set_scaleY(1));
		co.doubleduck.utils.TweenChain.get(this._notif).tto({ scaleX : 1.15, scaleY : 1.15},350,motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},250,motion.easing.Sine.get_easeInOut()).call($bind(this,this.animNotif),[]);
	}
	,setupVals: function() {
		if(this._upgradeBtn != null) {
			this._upgradeBtn.removeEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleUpgrade));
			this.removeChild(this._upgradeBtn);
			this._upgradeBtn = null;
		}
		if(this._hpsVal != null) {
			this.removeChild(this._hpsVal);
			this._hpsVal = null;
		}
		if(this._levelVal != null) {
			this.removeChild(this._levelVal);
			this._levelVal = null;
		}
		if(this._btnHPS != null) {
			this.removeChild(this._btnHPS);
			this._btnHPS = null;
		}
		if(this._btnPrice != null) {
			this.removeChild(this._btnPrice);
			this._btnPrice = null;
		}
		var toolLvl = co.doubleduck.pinata.meta.Stats.getToolLevel(this._id);
		if(toolLvl == 0) {
			this._icon.set_alpha(0.5);
			this._upgradeBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/tools_menu/btn_buy.png"));
		} else {
			this._icon.set_alpha(1);
			this._upgradeBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/tools_menu/btn_upgrade.png"));
			var hps = co.doubleduck.pinata.meta.Stats.getHPSForTool(this._id);
			this._hpsVal = co.doubleduck.utils.Fonter.getString(hps.toString() + (this._id == "good-ol-bat"?"#":"~"),"images/fonts/purple/");
			this._hpsVal.set_x(this._icon.get_x() + this._icon.get_width() + 5 + this._hpsVal.get_width() / 2);
			this._hpsVal.set_y(this._icon.get_y() + this._icon.get_height() - this._hpsVal.get_height() / 2);
			this.addChild(this._hpsVal);
			this._levelVal = co.doubleduck.utils.Fonter.getString("*" + toolLvl,"images/fonts/yellow_small/");
			this._levelVal.set_x(this._hpsVal.get_x() - this._hpsVal.get_width() / 2 + this._levelVal.get_width() / 2);
			this._levelVal.set_y(this._hpsVal.get_y() - this._hpsVal.get_height() / 2 - this._levelVal.get_height() / 2);
			this.addChild(this._levelVal);
		}
		this._upgradeBtn.set_y(this._back.get_height() - this._upgradeBtn.get_height() / 2 - 5);
		this._upgradeBtn.set_x(this._back.get_width() - this._upgradeBtn.get_width() / 2 - 4);
		this._upgradeBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleUpgrade));
		if(this._notif != null) this.addChildAt(this._upgradeBtn,this.getChildIndex(this._notif)); else this.addChild(this._upgradeBtn);
		var nextHps = co.doubleduck.pinata.meta.Stats.getHPSForTool(this._id,co.doubleduck.pinata.meta.Stats.getToolLevel(this._id) + 1);
		this._btnHPS = co.doubleduck.utils.Fonter.getString(nextHps.toString() + (this._id == "good-ol-bat"?"#":"~"),"images/fonts/purple/");
		this._btnHPS.mouseChildren = this._btnHPS.mouseEnabled = false;
		this._btnHPS.set_x(this._upgradeBtn.get_x());
		this._btnHPS.set_y(this._upgradeBtn.get_y() - this._upgradeBtn.get_height() * 0.08);
		this.addChild(this._btnHPS);
		this._nextPrice = co.doubleduck.pinata.meta.Stats.getPriceForTool(this._id,co.doubleduck.pinata.meta.Stats.getToolLevel(this._id) + 1);
		this._btnPrice = co.doubleduck.utils.Fonter.getString("$" + this._nextPrice.toString(),"images/fonts/yellow_small/");
		this._btnPrice.mouseChildren = this._btnPrice.mouseEnabled = false;
		this._btnPrice.set_x(this._upgradeBtn.get_x());
		this._btnPrice.set_y(this._upgradeBtn.get_y() + this._upgradeBtn.get_height() * 0.22);
		this.addChild(this._btnPrice);
		this.handleCandies();
	}
	,capPlayerBuy: function() {
		return this._upgradeBtn.enabled;
	}
	,handleCandies: function(e) {
		var prevVal = this._upgradeBtn.enabled;
		if(co.doubleduck.pinata.meta.BigInt.isGT(this._nextPrice,co.doubleduck.pinata.meta.Stats.getPCandies())) {
			this.set_alpha(0.5);
			this._upgradeBtn.enabled = false;
		} else {
			this.set_alpha(1);
			this._upgradeBtn.enabled = true;
		}
		if(this._upgradeBtn.enabled != prevVal) this.dispatchEvent(new openfl.events.Event("RetestNotifEvent"));
	}
	,depressItem: function() {
		if(this._upgradeBtn != null) this._upgradeBtn.dePress();
	}
	,handleUpgrade: function(e) {
		var toolLvl = co.doubleduck.pinata.meta.Stats.getToolLevel(this._id);
		var pcandies = co.doubleduck.pinata.meta.Stats.getPCandies();
		var nextPrice = co.doubleduck.pinata.meta.Stats.getPriceForTool(this._id,co.doubleduck.pinata.meta.Stats.getToolLevel(this._id) + 1);
		if(!co.doubleduck.pinata.meta.BigInt.isGT(nextPrice,pcandies)) {
			toolLvl = toolLvl + 1;
			pcandies = co.doubleduck.pinata.meta.BigInt.subtract(pcandies,nextPrice);
			co.doubleduck.pinata.meta.Stats.setPCandies(pcandies);
			co.doubleduck.pinata.meta.Stats.setToolLevel(this._id,toolLvl);
			co.doubleduck.utils.SoundMgr.playSound("purchase");
			this.setupVals();
			this.dispatchEvent(new openfl.events.Event("UpgradedEvent"));
			this.dispatchEvent(new openfl.events.Event("RetestNotifEvent"));
			var data = { };
			data.candyCount = co.doubleduck.pinata.meta.Stats.getPCandies().toFullString();
			data.toolName = this._id;
			data.toolLevel = toolLvl + "";
			com.funtomic.GameOps.reportEvent("toolUpgrade",data);
			if(this._id == "good-ol-bat" && toolLvl == 2) {
				co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.BUY_FIRST_UPGRADE);
				co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.EXIT_SHOP);
			}
			if(this._id == "pinata-smasher" && toolLvl == 1) co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.BUY_FIRST_AUTO);
		}
	}
	,destroy: function() {
	}
	,__class__: co.doubleduck.pinata.core.tools.ToolItem
});
co.doubleduck.pinata.core.tools.ToolsScr = function() {
	openfl.display.Sprite.call(this);
	this._isOpened = false;
	this._toolsData = co.doubleduck.pinata.data.GameplayDB.getTools();
	this._notifOnTools = new Array();
	this._tabBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/btn_tools.png"));
	this._tabBtn.set_x(this._tabBtn.get_width() / 2 - 2);
	this._tabBtn.set_y(co.doubleduck.pinata.Game.getScreenSize().height / 2 - 45);
	this._tabBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleTabBtn));
	this.addChild(this._tabBtn);
	var notif = co.doubleduck.utils.DDAssets.getImage("images/ui/attention_tag.png");
	var _g = notif;
	_g.set_x(_g.get_x() - notif.get_width() / 2);
	var _g1 = notif;
	_g1.set_y(_g1.get_y() - notif.get_height() / 2);
	this._notif = new openfl.display.Sprite();
	this._notif.addChild(notif);
	this._notif.set_x(this._tabBtn.get_x() + this._tabBtn.get_width() * 0.35);
	this._notif.set_y(this._tabBtn.get_y() - this._tabBtn.get_height() * 0.45);
	this._notif.set_visible(false);
	this.addChild(this._notif);
	this._scrBox = new openfl.display.Sprite();
	this.addChild(this._scrBox);
	this._back = co.doubleduck.utils.DDAssets.getImage("images/tools_menu/bg.png");
	var _g2 = this._scrBox;
	_g2.set_x(_g2.get_x() - this._back.get_width());
	this._topBar = co.doubleduck.utils.DDAssets.getImage("images/tools_menu/header.png");
	this.setupList();
	this._backBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/tools_menu/btn_back.png"));
	this._backBtn.set_x(this._backBtn.get_width() / 2 + 20);
	this._backBtn.set_y(this._backBtn.get_height() / 2 + 5);
	this._backBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleBackBtn));
	this._backBtn.enabled = false;
	this._scrBox.addChild(this._back);
	this._scrBox.addChild(this._toolsList);
	this._scrBox.addChild(this._topBar);
	this._scrBox.addChild(this._backBtn);
	co.doubleduck.pinata.meta.Stats.addListener("UpdateCandiesEvent",$bind(this,this.handlePCandies));
};
$hxClasses["co.doubleduck.pinata.core.tools.ToolsScr"] = co.doubleduck.pinata.core.tools.ToolsScr;
co.doubleduck.pinata.core.tools.ToolsScr.__name__ = ["co","doubleduck","pinata","core","tools","ToolsScr"];
co.doubleduck.pinata.core.tools.ToolsScr.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.core.tools.ToolsScr.prototype = $extend(openfl.display.Sprite.prototype,{
	handlePCandies: function(e) {
		if(!co.doubleduck.pinata.core.TutorOverlay.inst().hasPassedStep(co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN) && !co.doubleduck.pinata.meta.BigInt.isGT(co.doubleduck.pinata.meta.Stats.getPriceForTool("good-ol-bat",2),co.doubleduck.pinata.meta.Stats.getPCandies())) {
			if(co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN)) this.set_visible(true);
		}
	}
	,closeIdOpened: function() {
		if(this._isOpened) this.handleBackBtn(null);
	}
	,addToNotif: function(tool) {
		if(this._notifOnTools.length >= 2) this._notifOnTools.shift().setBuyNotif(false);
		this._notifOnTools.push(tool);
	}
	,setupList: function() {
		if(this._toolsList != null) {
			this._scrBox.removeChild(this._toolsList);
			this._toolsList = null;
		}
		var scrollRect = co.doubleduck.pinata.Game.getScreenSize().clone();
		scrollRect.height -= this._topBar.get_height() + 10;
		this._toolsList = new co.doubleduck.pinata.meta.ScrolledList(scrollRect,true);
		this._toolsList.itemPadding = 10;
		this._toolsList.set_y(co.doubleduck.pinata.Game.getScreenSize().height - scrollRect.height);
		var prevName = "";
		var _g = 0;
		var _g1 = this._toolsData;
		while(_g < _g1.length) {
			var currData = _g1[_g];
			++_g;
			if(currData.showWhenPrev != null) {
				var prevLevel = co.doubleduck.pinata.meta.Stats.getToolLevel(prevName);
				if(prevLevel < Std["int"](currData.showWhenPrev)) break;
			}
			var newItem = new co.doubleduck.pinata.core.tools.ToolItem(currData);
			newItem.addEventListener("UpgradedEvent",$bind(this,this.recheckList));
			newItem.addEventListener("RetestNotifEvent",$bind(this,this.retestNotif));
			this.addToNotif(newItem);
			this._toolsList.addItem(newItem);
			prevName = currData.id;
		}
	}
	,recheckList: function(e) {
		var tool = e.target;
		var prevName = "";
		var _g = 0;
		var _g1 = this._toolsData;
		while(_g < _g1.length) {
			var currData = _g1[_g];
			++_g;
			if(prevName == "") {
				if(currData.id == tool.getToolId()) prevName = currData.id;
				continue;
			}
			if(currData.showWhenPrev != null) {
				var prevLevel = co.doubleduck.pinata.meta.Stats.getToolLevel(prevName);
				if(prevLevel != Std["int"](currData.showWhenPrev)) break;
			}
			var newItem = new co.doubleduck.pinata.core.tools.ToolItem(currData);
			newItem.addEventListener("UpgradedEvent",$bind(this,this.recheckList));
			newItem.addEventListener("RetestNotifEvent",$bind(this,this.retestNotif));
			this.addToNotif(newItem);
			this._toolsList.addItem(newItem);
			prevName = currData.id;
		}
	}
	,retestNotif: function(e) {
		var hasNotif = false;
		var _g1 = 0;
		var _g = this._notifOnTools.length;
		while(_g1 < _g) {
			var i = _g1++;
			var tool = this._notifOnTools[i];
			var toolNotif = false;
			if(tool.capPlayerBuy()) {
				if(i + 1 == this._notifOnTools.length) {
					hasNotif = true;
					toolNotif = true;
				} else {
					var currLevel = co.doubleduck.pinata.meta.Stats.getToolLevel(this._notifOnTools[i].getToolId());
					var nextLevel = co.doubleduck.pinata.meta.Stats.getToolLevel(this._notifOnTools[i + 1].getToolId());
					if(Math.floor(currLevel / 5) <= Math.floor(nextLevel / 5)) {
						hasNotif = true;
						toolNotif = true;
					}
				}
			}
			tool.setBuyNotif(toolNotif);
		}
		this.toggleNotif(hasNotif);
	}
	,toggleNotif: function(flag) {
		if(this._notif.get_visible() == flag) return;
		if(flag) this.animNotif();
		this._notif.set_visible(flag);
	}
	,animNotif: function() {
		co.doubleduck.utils.TweenChain.removeTweens(this._notif);
		this._notif.set_scaleX(this._notif.set_scaleY(1));
		co.doubleduck.utils.TweenChain.get(this._notif).tto({ scaleX : 1.15, scaleY : 1.15},350,motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},250,motion.easing.Sine.get_easeInOut()).call($bind(this,this.animNotif),[]);
	}
	,handleTabBtn: function(e) {
		var _g = this;
		co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.TAP_TAB_BTN);
		this.dispatchEvent(new openfl.events.Event(openfl.events.Event.OPEN));
		this._isOpened = true;
		co.doubleduck.utils.SoundMgr.playSound("menu_open");
		this._tabBtn.enabled = false;
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ x : -this._scrBox.get_x()},300,motion.easing.Sine.get_easeInOut()).call(function() {
			_g._backBtn.enabled = true;
			co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.BUY_FIRST_UPGRADE);
			var newestTool = _g._notifOnTools[_g._notifOnTools.length - 1];
			if(newestTool.getToolId() == "pinata-smasher" && co.doubleduck.pinata.meta.Stats.getToolLevel("pinata-smasher") == 0 && newestTool.capPlayerBuy()) co.doubleduck.pinata.core.TutorOverlay.inst().tryShowStep(co.doubleduck.pinata.core.TutorStep.BUY_FIRST_AUTO);
		});
	}
	,handleBackBtn: function(e) {
		var _g = this;
		this._isOpened = false;
		co.doubleduck.pinata.core.TutorOverlay.inst().actedOnStep(co.doubleduck.pinata.core.TutorStep.EXIT_SHOP);
		co.doubleduck.utils.SoundMgr.playSound("menu_open");
		this._backBtn.enabled = false;
		co.doubleduck.utils.TweenChain.removeTweens(this);
		co.doubleduck.utils.TweenChain.get(this).tto({ x : 0},300,motion.easing.Sine.get_easeInOut()).call(function() {
			_g._tabBtn.enabled = true;
		});
	}
	,__class__: co.doubleduck.pinata.core.tools.ToolsScr
});
co.doubleduck.pinata.data = {};
co.doubleduck.pinata.data.GameplayDB = function() {
	this.data = JSON.parse(openfl.Assets.getText("data/gameplay.js"));
};
$hxClasses["co.doubleduck.pinata.data.GameplayDB"] = co.doubleduck.pinata.data.GameplayDB;
co.doubleduck.pinata.data.GameplayDB.__name__ = ["co","doubleduck","pinata","data","GameplayDB"];
co.doubleduck.pinata.data.GameplayDB._instance = null;
co.doubleduck.pinata.data.GameplayDB.instance = function() {
	if(co.doubleduck.pinata.data.GameplayDB._instance == null) co.doubleduck.pinata.data.GameplayDB._instance = new co.doubleduck.pinata.data.GameplayDB();
	return co.doubleduck.pinata.data.GameplayDB._instance;
};
co.doubleduck.pinata.data.GameplayDB.getLevelData = function(levelId) {
	var levels = co.doubleduck.pinata.data.GameplayDB.getLevels();
	if(levelId <= levels.length && levels[levelId - 1].id == levelId) return levels[levelId - 1];
	var _g = 0;
	while(_g < levels.length) {
		var dat = levels[_g];
		++_g;
		if(dat.id == levelId) return dat;
	}
	return null;
};
co.doubleduck.pinata.data.GameplayDB.getLevels = function() {
	return co.doubleduck.pinata.data.GameplayDB.getData().levelsData;
};
co.doubleduck.pinata.data.GameplayDB.getToolData = function(toolId) {
	var tools = co.doubleduck.pinata.data.GameplayDB.getTools();
	var _g = 0;
	while(_g < tools.length) {
		var dat = tools[_g];
		++_g;
		if(dat.id == toolId) return dat;
	}
	return null;
};
co.doubleduck.pinata.data.GameplayDB.getTools = function() {
	return co.doubleduck.pinata.data.GameplayDB.getData().toolsData;
};
co.doubleduck.pinata.data.GameplayDB.getMissionsData = function() {
	return co.doubleduck.pinata.data.GameplayDB.getData().missionsData;
};
co.doubleduck.pinata.data.GameplayDB.getMissionPack = function(packId) {
	var packs = co.doubleduck.pinata.data.GameplayDB.getMissionsData().data;
	var _g = 0;
	while(_g < packs.length) {
		var dat = packs[_g];
		++_g;
		if(Std["int"](dat.packId) == packId) return dat;
	}
	return null;
};
co.doubleduck.pinata.data.GameplayDB.getMissionTypeData = function(typeId) {
	var typesData = co.doubleduck.pinata.data.GameplayDB.getMissionsData().types;
	var _g = 0;
	while(_g < typesData.length) {
		var dat = typesData[_g];
		++_g;
		if(dat.id == typeId) return dat;
	}
	return null;
};
co.doubleduck.pinata.data.GameplayDB.getMissionData = function(packId,missionInd) {
	var pack = co.doubleduck.pinata.data.GameplayDB.getMissionPack(packId);
	var mission = pack.missions[missionInd];
	var typeData = co.doubleduck.pinata.data.GameplayDB.getMissionTypeData(mission.id);
	var data = { };
	data.id = mission.id;
	data.desc = typeData.desc;
	data.value = mission.value;
	return data;
};
co.doubleduck.pinata.data.GameplayDB.getData = function() {
	return co.doubleduck.pinata.data.GameplayDB.instance().data;
};
co.doubleduck.pinata.data.GameplayDB.setData = function(data) {
	co.doubleduck.pinata.data.GameplayDB.instance().data = data;
};
co.doubleduck.pinata.data.GameplayDB.prototype = {
	__class__: co.doubleduck.pinata.data.GameplayDB
};
co.doubleduck.pinata.data.Persistence = function() { };
$hxClasses["co.doubleduck.pinata.data.Persistence"] = co.doubleduck.pinata.data.Persistence;
co.doubleduck.pinata.data.Persistence.__name__ = ["co","doubleduck","pinata","data","Persistence"];
co.doubleduck.pinata.data.Persistence._storageAdapter = null;
co.doubleduck.pinata.data.Persistence.init = function(domain) {
	if(domain == null) domain = "";
	co.doubleduck.pinata.data.Persistence._storageAdapter = co.doubleduck.utils.data.StorageAdapter.get(domain,co.doubleduck.utils.data.StorageAdapterType.LOCAL_STORAGE);
};
co.doubleduck.pinata.data.Persistence.initGameData = function() {
	co.doubleduck.pinata.data.Persistence.initString(co.doubleduck.pinata.data.DataKey.MUTE_STATE,"false");
	co.doubleduck.pinata.data.Persistence.initString(co.doubleduck.pinata.data.DataKey.PLAYER_CANDIES,"0K");
	co.doubleduck.pinata.data.Persistence.initString(co.doubleduck.pinata.data.DataKey.TOOLS_STATE,"good-ol-bat" + ":1");
	co.doubleduck.pinata.data.Persistence.initString(co.doubleduck.pinata.data.DataKey.TUTOR_STEP,"");
	co.doubleduck.pinata.data.Persistence.initString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT,"0,1,2,3,4,5,6,7,8");
	co.doubleduck.pinata.data.Persistence.initString(co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT,"");
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL,1);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL,1);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.LATEST_TIME_KEPT,0);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.TUTOR_STAGE,0);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.RUNS_COUNTER,0);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT,0);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK,1);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND,0);
	co.doubleduck.pinata.data.Persistence.initInt(co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION,0);
};
co.doubleduck.pinata.data.Persistence.getInt = function(key) {
	return co.doubleduck.pinata.data.Persistence._storageAdapter.getInt(key);
};
co.doubleduck.pinata.data.Persistence.setInt = function(key,val) {
	co.doubleduck.pinata.data.Persistence._storageAdapter.setInt(key,val);
};
co.doubleduck.pinata.data.Persistence.initInt = function(key,defaultValue) {
	if(defaultValue == null) defaultValue = 0;
	co.doubleduck.pinata.data.Persistence._storageAdapter.initInt(key,defaultValue);
};
co.doubleduck.pinata.data.Persistence.getFloat = function(key) {
	return co.doubleduck.pinata.data.Persistence._storageAdapter.getFloat(key);
};
co.doubleduck.pinata.data.Persistence.setFloat = function(key,val) {
	co.doubleduck.pinata.data.Persistence._storageAdapter.setFloat(key,val);
};
co.doubleduck.pinata.data.Persistence.initFloat = function(key,defaultValue) {
	if(defaultValue == null) defaultValue = 0;
	co.doubleduck.pinata.data.Persistence._storageAdapter.initFloat(key,defaultValue);
};
co.doubleduck.pinata.data.Persistence.getString = function(key) {
	return co.doubleduck.pinata.data.Persistence._storageAdapter.getString(key);
};
co.doubleduck.pinata.data.Persistence.setString = function(key,val) {
	co.doubleduck.pinata.data.Persistence._storageAdapter.setString(key,val);
};
co.doubleduck.pinata.data.Persistence.initString = function(key,defaultValue) {
	if(defaultValue == null) defaultValue = "";
	co.doubleduck.pinata.data.Persistence._storageAdapter.initString(key,defaultValue);
};
co.doubleduck.pinata.data.Persistence.clear = function() {
	co.doubleduck.pinata.data.Persistence._storageAdapter.clear();
};
co.doubleduck.pinata.data.Persistence.adapter = function() {
	return co.doubleduck.pinata.data.Persistence._storageAdapter;
};
co.doubleduck.pinata.data.DataKey = $hxClasses["co.doubleduck.pinata.data.DataKey"] = { __ename__ : ["co","doubleduck","pinata","data","DataKey"], __constructs__ : ["MUTE_STATE","PLAYER_CANDIES","ACTIVE_LEVEL","TOOLS_STATE","UNLOCKED_LEVEL","LATEST_TIME_KEPT","TUTOR_STAGE","TUTOR_STEP","RUNS_COUNTER","PINATA_KILL_COUNT","CURR_MISSION_PACK","CURR_MISSION_IND","CURR_PIECES_LEFT","CURR_PIECES_GOT","PINATAS_BEAT_MISSION"] };
co.doubleduck.pinata.data.DataKey.MUTE_STATE = ["MUTE_STATE",0];
co.doubleduck.pinata.data.DataKey.MUTE_STATE.toString = $estr;
co.doubleduck.pinata.data.DataKey.MUTE_STATE.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.PLAYER_CANDIES = ["PLAYER_CANDIES",1];
co.doubleduck.pinata.data.DataKey.PLAYER_CANDIES.toString = $estr;
co.doubleduck.pinata.data.DataKey.PLAYER_CANDIES.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL = ["ACTIVE_LEVEL",2];
co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL.toString = $estr;
co.doubleduck.pinata.data.DataKey.ACTIVE_LEVEL.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.TOOLS_STATE = ["TOOLS_STATE",3];
co.doubleduck.pinata.data.DataKey.TOOLS_STATE.toString = $estr;
co.doubleduck.pinata.data.DataKey.TOOLS_STATE.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL = ["UNLOCKED_LEVEL",4];
co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL.toString = $estr;
co.doubleduck.pinata.data.DataKey.UNLOCKED_LEVEL.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.LATEST_TIME_KEPT = ["LATEST_TIME_KEPT",5];
co.doubleduck.pinata.data.DataKey.LATEST_TIME_KEPT.toString = $estr;
co.doubleduck.pinata.data.DataKey.LATEST_TIME_KEPT.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.TUTOR_STAGE = ["TUTOR_STAGE",6];
co.doubleduck.pinata.data.DataKey.TUTOR_STAGE.toString = $estr;
co.doubleduck.pinata.data.DataKey.TUTOR_STAGE.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.TUTOR_STEP = ["TUTOR_STEP",7];
co.doubleduck.pinata.data.DataKey.TUTOR_STEP.toString = $estr;
co.doubleduck.pinata.data.DataKey.TUTOR_STEP.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.RUNS_COUNTER = ["RUNS_COUNTER",8];
co.doubleduck.pinata.data.DataKey.RUNS_COUNTER.toString = $estr;
co.doubleduck.pinata.data.DataKey.RUNS_COUNTER.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT = ["PINATA_KILL_COUNT",9];
co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT.toString = $estr;
co.doubleduck.pinata.data.DataKey.PINATA_KILL_COUNT.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK = ["CURR_MISSION_PACK",10];
co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK.toString = $estr;
co.doubleduck.pinata.data.DataKey.CURR_MISSION_PACK.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND = ["CURR_MISSION_IND",11];
co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND.toString = $estr;
co.doubleduck.pinata.data.DataKey.CURR_MISSION_IND.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT = ["CURR_PIECES_LEFT",12];
co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT.toString = $estr;
co.doubleduck.pinata.data.DataKey.CURR_PIECES_LEFT.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT = ["CURR_PIECES_GOT",13];
co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT.toString = $estr;
co.doubleduck.pinata.data.DataKey.CURR_PIECES_GOT.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION = ["PINATAS_BEAT_MISSION",14];
co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION.toString = $estr;
co.doubleduck.pinata.data.DataKey.PINATAS_BEAT_MISSION.__enum__ = co.doubleduck.pinata.data.DataKey;
co.doubleduck.pinata.meta.AwayModal = function(reward) {
	openfl.display.Sprite.call(this);
	this._over = new openfl.display.Sprite();
	this._over.get_graphics().beginFill(0);
	this._over.get_graphics().drawRect(0,0,co.doubleduck.pinata.Game.getScreenSize().width,co.doubleduck.pinata.Game.getScreenSize().height);
	this._over.get_graphics().endFill();
	this._over.set_alpha(0.7);
	var _g = this._over;
	_g.set_x(_g.get_x() - co.doubleduck.pinata.Game.getScreenSize().width / 2);
	var _g1 = this._over;
	_g1.set_y(_g1.get_y() - co.doubleduck.pinata.Game.getScreenSize().height / 2);
	this.addChild(this._over);
	this._back = co.doubleduck.utils.DDAssets.getImage("images/ui/modal_away/bg.png");
	var _g2 = this._back;
	_g2.set_x(_g2.get_x() - this._back.get_width() / 2);
	var _g3 = this._back;
	_g3.set_y(_g3.get_y() - this._back.get_height() / 2);
	this.addChild(this._back);
	this._reward = co.doubleduck.utils.Fonter.getString("$" + reward.toString(),"images/fonts/yellow_big/");
	this._reward.set_y(this._back.get_y() + this._back.get_height() * 0.6);
	this.addChild(this._reward);
	this._okBtn = new co.doubleduck.utils.Button(co.doubleduck.utils.DDAssets.getRawImage("images/ui/modal_away/btn_ok.png"));
	this._okBtn.addEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleOk));
	this._okBtn.set_y(this._back.get_y() + this._back.get_height() * 0.8);
	this.addChild(this._okBtn);
};
$hxClasses["co.doubleduck.pinata.meta.AwayModal"] = co.doubleduck.pinata.meta.AwayModal;
co.doubleduck.pinata.meta.AwayModal.__name__ = ["co","doubleduck","pinata","meta","AwayModal"];
co.doubleduck.pinata.meta.AwayModal.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.meta.AwayModal.prototype = $extend(openfl.display.Sprite.prototype,{
	handleOk: function(e) {
		var _g = this;
		this._okBtn.enabled = false;
		this._okBtn.removeEventListener("BUTTON_ACT_EVENT",$bind(this,this.handleOk));
		co.doubleduck.utils.TweenChain.get(this).wait(50).tto({ alpha : 0.01},150).call(function() {
			if(_g.callWhenDone != null) _g.callWhenDone();
			if(_g.parent != null) _g.parent.removeChild(_g);
		});
	}
	,__class__: co.doubleduck.pinata.meta.AwayModal
});
co.doubleduck.pinata.meta.BigInt = function(dat) {
	this._data = dat;
};
$hxClasses["co.doubleduck.pinata.meta.BigInt"] = co.doubleduck.pinata.meta.BigInt;
co.doubleduck.pinata.meta.BigInt.__name__ = ["co","doubleduck","pinata","meta","BigInt"];
co.doubleduck.pinata.meta.BigInt.fromString = function(val) {
	if(co.doubleduck.pinata.meta.BigInt.isAlpha(HxOverrides.cca(val,val.length - 1))) {
		var suff = val.charAt(val.length - 1);
		val = HxOverrides.substr(val,0,val.length - 1);
		var zeros = (co.doubleduck.pinata.meta.BigInt.SUFFIX.indexOf(suff) + 1) * 3;
		while(zeros > 0) {
			val = val + "0";
			zeros--;
		}
	}
	while(val.length % 3 > 0) val = "0" + val;
	var res = new Array();
	while(val.length > 0) {
		var part = HxOverrides.substr(val,val.length - 3,3);
		res.push(Std.parseInt(part));
		val = HxOverrides.substr(val,0,val.length - 3);
	}
	while(res.length > 1 && res[res.length - 1] == 0) res.pop();
	return new co.doubleduck.pinata.meta.BigInt(res);
};
co.doubleduck.pinata.meta.BigInt.fromInt = function(val) {
	return co.doubleduck.pinata.meta.BigInt.fromString("" + val);
};
co.doubleduck.pinata.meta.BigInt.add = function(lval,rval) {
	if(co.doubleduck.pinata.meta.BigInt.isZero(lval)) return rval.clone(); else if(co.doubleduck.pinata.meta.BigInt.isZero(rval)) return lval.clone();
	var level = 0;
	var carry = 0;
	var done = false;
	var res = new Array();
	var ldat = lval._data;
	var rdat = rval._data;
	while(!done) {
		var curr = carry;
		if(level < ldat.length) curr += ldat[level]; else curr += 0;
		if(level < rdat.length) curr += rdat[level]; else curr += 0;
		carry = Math.floor(curr / 1000);
		curr -= carry * 1000;
		res.push(curr);
		level++;
		done = carry == 0 && (level >= ldat.length && level >= rdat.length);
	}
	while(res.length > 1 && res[res.length - 1] == 0) res.pop();
	return new co.doubleduck.pinata.meta.BigInt(res);
};
co.doubleduck.pinata.meta.BigInt.subtract = function(lval,rval) {
	if(co.doubleduck.pinata.meta.BigInt.isZero(rval)) return lval.clone(); else if(!co.doubleduck.pinata.meta.BigInt.isGT(lval,rval)) return co.doubleduck.pinata.meta.BigInt.fromInt(0);
	var level = 0;
	var carry = 0;
	var done = false;
	var res = new Array();
	var ldat = lval._data;
	var rdat = rval._data;
	while(!done) {
		var curr = carry;
		if(level < ldat.length) curr += ldat[level]; else curr += 0;
		if(level < rdat.length) curr -= rdat[level]; else curr -= 0;
		carry = Math.floor(curr / 1000);
		curr -= carry * 1000;
		res.push(curr);
		level++;
		done = carry == 0 && (level >= ldat.length && level >= rdat.length);
	}
	while(res.length > 1 && res[res.length - 1] == 0) res.pop();
	return new co.doubleduck.pinata.meta.BigInt(res);
};
co.doubleduck.pinata.meta.BigInt.roughDiv = function(lval,rval) {
	var accuracy = 8;
	var ldat = lval.toFullString();
	var rdat = rval.toFullString();
	var fixDat = function(val) {
		if(val.length == 0) return "0";
		return val;
	};
	while(ldat.length > accuracy || rdat.length > accuracy) {
		ldat = fixDat(ldat);
		rdat = fixDat(rdat);
		ldat = HxOverrides.substr(ldat,0,ldat.length - 1);
		rdat = HxOverrides.substr(rdat,0,rdat.length - 1);
	}
	ldat = fixDat(ldat);
	rdat = fixDat(rdat);
	var lint = Std.parseInt(ldat);
	var rint = Std.parseInt(rdat);
	if(rint == 0) return Math.POSITIVE_INFINITY;
	return lint / rint;
};
co.doubleduck.pinata.meta.BigInt.mulScalar = function(lval,rval) {
	if(rval == 0 || co.doubleduck.pinata.meta.BigInt.isZero(lval)) return co.doubleduck.pinata.meta.BigInt.fromInt(0); else if(rval == 1) return lval.clone();
	var ldat = lval._data;
	var res = new Array();
	var _g1 = 0;
	var _g = ldat.length;
	while(_g1 < _g) {
		var i = _g1++;
		var miniRes = ldat[i] * rval;
		res[i] = Math.floor(miniRes);
		miniRes -= Math.floor(miniRes);
		var addTo = i - 1;
		while(addTo >= 0) {
			miniRes *= 1000;
			res[addTo] += Math.floor(miniRes);
			miniRes -= Math.floor(miniRes);
			addTo--;
		}
	}
	var done = false;
	var curr = 0;
	var carry = 0;
	while(!done) {
		if(curr >= res.length) res.push(0);
		res[curr] += carry;
		carry = Math.floor(res[curr] / 1000);
		res[curr] -= carry * 1000;
		curr++;
		done = curr >= res.length && carry == 0;
	}
	while(res.length > 1 && res[res.length - 1] == 0) res.pop();
	return new co.doubleduck.pinata.meta.BigInt(res);
};
co.doubleduck.pinata.meta.BigInt.isGT = function(lval,rval) {
	var ldat = lval._data;
	var rdat = rval._data;
	if(ldat.length != rdat.length) return ldat.length > rdat.length; else {
		var _g1 = 0;
		var _g = ldat.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(ldat[ldat.length - i - 1] != rdat[rdat.length - i - 1]) return ldat[ldat.length - i - 1] > rdat[rdat.length - i - 1];
		}
	}
	return false;
};
co.doubleduck.pinata.meta.BigInt.isEqual = function(lval,rval) {
	var ldat = lval._data;
	var rdat = rval._data;
	if(ldat.length != rdat.length) return false; else {
		var _g1 = 0;
		var _g = ldat.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(ldat[i] != rdat[i]) return false;
		}
	}
	return true;
};
co.doubleduck.pinata.meta.BigInt.isZero = function(val) {
	var dat = val._data;
	return dat.length == 1 && dat[0] == 0;
};
co.doubleduck.pinata.meta.BigInt.isNum = function(code) {
	return code >= HxOverrides.cca("0",0) && code <= HxOverrides.cca("9",0);
};
co.doubleduck.pinata.meta.BigInt.isAlpha = function(code) {
	return code >= HxOverrides.cca("a",0) && code <= HxOverrides.cca("z",0) || code >= HxOverrides.cca("A",0) && code <= HxOverrides.cca("Z",0);
};
co.doubleduck.pinata.meta.BigInt.prototype = {
	toString: function() {
		var level = this._data.length - 1;
		var num;
		if(this._data[this._data.length - 1] < 10 && this._data.length > 1) {
			num = this._data[this._data.length - 1] * 1000;
			num += this._data[this._data.length - 2];
			level--;
		} else num = this._data[this._data.length - 1];
		var res = co.doubleduck.utils.Fonter.commafyNum(num);
		if(level > 0) res += co.doubleduck.pinata.meta.BigInt.SUFFIX.charAt(level - 1);
		return res;
	}
	,toFullString: function() {
		var res = "";
		var _g1 = 0;
		var _g = this._data.length;
		while(_g1 < _g) {
			var i = _g1++;
			var curr = "" + this._data[i];
			while(curr.length < 3) curr = "0" + curr;
			res = curr + res;
		}
		while(res.charAt(0) == "0" && res.length > 1) res = HxOverrides.substr(res,1,res.length - 1);
		return res;
	}
	,dataString: function() {
		return "" + Std.string(this._data);
	}
	,clone: function() {
		var dat = this._data.slice();
		return new co.doubleduck.pinata.meta.BigInt(dat);
	}
	,__class__: co.doubleduck.pinata.meta.BigInt
};
co.doubleduck.pinata.meta.FlowEvents = function() { };
$hxClasses["co.doubleduck.pinata.meta.FlowEvents"] = co.doubleduck.pinata.meta.FlowEvents;
co.doubleduck.pinata.meta.FlowEvents.__name__ = ["co","doubleduck","pinata","meta","FlowEvents"];
co.doubleduck.pinata.meta.Menu = function(data) {
	openfl.display.Sprite.call(this);
	co.doubleduck.utils.Utils.delayedCall(0.1,$bind(this,this.dispatchEvent),[new openfl.events.Event(co.doubleduck.pinata.meta.FlowEvents.START_SESSION)]);
};
$hxClasses["co.doubleduck.pinata.meta.Menu"] = co.doubleduck.pinata.meta.Menu;
co.doubleduck.pinata.meta.Menu.__name__ = ["co","doubleduck","pinata","meta","Menu"];
co.doubleduck.pinata.meta.Menu.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.meta.Menu.prototype = $extend(openfl.display.Sprite.prototype,{
	destroy: function() {
	}
	,__class__: co.doubleduck.pinata.meta.Menu
});
co.doubleduck.pinata.meta.ScrolledList = function(size,dirVertical) {
	this.scrollable = true;
	this.itemSnap = false;
	this.itemPadding = 0;
	openfl.display.Sprite.call(this);
	this._touch = size.clone();
	this._dirVertical = dirVertical;
	this._items = new Array();
	this._itemBox = new openfl.display.Sprite();
	this.addChild(this._itemBox);
	this._maxPos = new openfl.geom.Point(0,0);
	this.addEventListener(openfl.events.Event.ADDED_TO_STAGE,$bind(this,this.handleStage));
};
$hxClasses["co.doubleduck.pinata.meta.ScrolledList"] = co.doubleduck.pinata.meta.ScrolledList;
co.doubleduck.pinata.meta.ScrolledList.__name__ = ["co","doubleduck","pinata","meta","ScrolledList"];
co.doubleduck.pinata.meta.ScrolledList.__super__ = openfl.display.Sprite;
co.doubleduck.pinata.meta.ScrolledList.prototype = $extend(openfl.display.Sprite.prototype,{
	handleStage: function(e) {
		this.removeEventListener(openfl.events.Event.ADDED_TO_STAGE,$bind(this,this.handleStage));
		this.stage.addEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleOverlay));
	}
	,addItem: function(item) {
		if(this._dirVertical) {
			item.set_y(this._maxPos.y);
			item.set_x(this._touch.width / 2 - item.get_width() / 2);
			this._maxPos.y += item.get_height() + this.itemPadding;
		} else {
			item.set_x(this._maxPos.x);
			item.set_y(this._touch.height / 2 - item.get_height() / 2);
			this._maxPos.x += item.get_width() + this.itemPadding;
		}
		this._items.push(item);
		this._itemBox.addChild(item);
	}
	,getLength: function() {
		return this._items.length;
	}
	,getItem: function(index) {
		return this._items[index];
	}
	,stopScroll: function() {
		if(this._touchPos != null) this.handleOverlay(new openfl.events.MouseEvent(openfl.events.MouseEvent.MOUSE_UP));
	}
	,focusOnIndex: function(index,force) {
		if(force == null) force = false;
		this.focusOnItem(this._items[index],force);
	}
	,focusOnItem: function(item,force) {
		if(force == null) force = false;
		co.doubleduck.utils.TweenChain.removeTweens(this._itemBox);
		if(this._dirVertical) {
			var snapPos = this._touch.y + this._touch.height / 2;
			var target = snapPos - (item.get_y() + item.get_height() / 2);
			target = Math.min(target,0);
			target = Math.max(target,this._touch.height - Math.max(this._maxPos.y,this._touch.height));
			if(force) this._itemBox.set_y(target); else co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ y : target},200,motion.easing.Sine.get_easeOut());
		} else {
			var snapPos1 = this._touch.x + this._touch.width / 2;
			var target1 = snapPos1 - (item.get_x() + item.get_width() / 2);
			target1 = Math.min(target1,0);
			target1 = Math.max(target1,this._touch.width - Math.max(this._maxPos.x,this._touch.width));
			if(force) this._itemBox.set_x(target1); else co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ x : target1},200,motion.easing.Sine.get_easeOut());
		}
	}
	,handleOverlay: function(e) {
		if(!this.scrollable) return;
		var pos = this.globalToLocal(new openfl.geom.Point(e.stageX,e.stageY));
		if(e.type == openfl.events.MouseEvent.MOUSE_DOWN) {
			if(this._touch.contains(pos.x,pos.y) && this.get_visible() && this.get_alpha() > 0) {
				this._touchPos = pos;
				this._srcPos = new openfl.geom.Point(this._itemBox.get_x(),this._itemBox.get_y());
				this._depressed = false;
				this.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleOverlay));
				this.stage.addEventListener(openfl.events.MouseEvent.MOUSE_MOVE,$bind(this,this.handleOverlay));
				this.stage.addEventListener(openfl.events.MouseEvent.MOUSE_UP,$bind(this,this.handleOverlay));
			}
		} else if(e.type == openfl.events.MouseEvent.MOUSE_MOVE) {
			if(this._touchPos != null) {
				var delta;
				if(this._dirVertical) delta = pos.y - this._touchPos.y; else delta = pos.x - this._touchPos.x;
				if(!this._depressed && Math.abs(delta) > 5) {
					this._depressed = true;
					co.doubleduck.utils.TweenChain.removeTweens(this._itemBox);
					var _g1 = 0;
					var _g = this._items.length;
					while(_g1 < _g) {
						var i = _g1++;
						var item = this._items[i];
						item.depressItem();
					}
				}
				var target;
				target = (this._dirVertical?this._srcPos.y:this._srcPos.x) + delta;
				var maxVal;
				if(this._dirVertical) maxVal = this._maxPos.y; else maxVal = this._maxPos.x;
				var touchVal;
				if(this._dirVertical) touchVal = this._touch.height; else touchVal = this._touch.width;
				touchVal = Math.min(touchVal,maxVal);
				if(target > 0) target *= 0.3; else if(target < touchVal - maxVal) target = (target - (touchVal - maxVal)) * 0.3 + (touchVal - maxVal);
				if(this._dirVertical) this._itemBox.set_y(target); else this._itemBox.set_x(target);
			}
		} else if(e.type == openfl.events.MouseEvent.MOUSE_UP) {
			if(this._touchPos != null) {
				this._touchPos = null;
				this._srcPos = null;
				if(this._depressed) {
					co.doubleduck.utils.TweenChain.removeTweens(this._itemBox);
					if(this._dirVertical) {
						if(this._itemBox.get_y() > 0) co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ y : 0},190,motion.easing.Sine.get_easeIn()); else if(this._itemBox.get_y() < this._touch.height - this._maxPos.y) co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ y : this._touch.height - Math.max(this._maxPos.y,this._touch.height)},190,motion.easing.Sine.get_easeIn()); else if(this.itemSnap && this._items.length > 0) {
							if(this._itemBox.get_y() < -4 && this._itemBox.get_y() > this._touch.height - this._maxPos.y + 4) {
								var snapPos = this._touch.y + this._touch.height / 2;
								var closest = this._items[0];
								var closestDist = Math.abs(closest.get_y() + closest.get_height() / 2 + this._itemBox.get_y() - snapPos);
								var _g11 = 1;
								var _g2 = this._items.length;
								while(_g11 < _g2) {
									var i1 = _g11++;
									var item1 = this._items[i1];
									var currDist = Math.abs(item1.get_y() + item1.get_height() / 2 + this._itemBox.get_y() - snapPos);
									if(currDist < closestDist) {
										closest = item1;
										closestDist = currDist;
									}
								}
								co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ y : snapPos - (closest.get_y() + closest.get_height() / 2)},100,motion.easing.Sine.get_easeOut());
							}
						}
					} else if(this._itemBox.get_x() > 0) co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ x : 0},190,motion.easing.Sine.get_easeIn()); else if(this._itemBox.get_x() < this._touch.width - this._maxPos.x) co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ x : this._touch.width - Math.max(this._maxPos.x,this._touch.width)},190,motion.easing.Sine.get_easeIn()); else if(this.itemSnap && this._items.length > 0) {
						if(this._itemBox.get_x() < -4 && this._itemBox.get_x() > this._touch.width - this._maxPos.x + 4) {
							var snapPos1 = this._touch.x + this._touch.width / 2;
							var closest1 = this._items[0];
							var closestDist1 = Math.abs(closest1.get_x() + closest1.get_width() / 2 + this._itemBox.get_x() - snapPos1);
							var _g12 = 1;
							var _g3 = this._items.length;
							while(_g12 < _g3) {
								var i2 = _g12++;
								var item2 = this._items[i2];
								var currDist1 = Math.abs(item2.get_x() + item2.get_width() / 2 + this._itemBox.get_x() - snapPos1);
								if(currDist1 < closestDist1) {
									closest1 = item2;
									closestDist1 = currDist1;
								}
							}
							co.doubleduck.utils.TweenChain.get(this._itemBox).tto({ x : snapPos1 - (closest1.get_x() + closest1.get_width() / 2)},100,motion.easing.Sine.get_easeOut());
						}
					}
				}
				this.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_MOVE,$bind(this,this.handleOverlay));
				this.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_UP,$bind(this,this.handleOverlay));
				this.stage.addEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleOverlay));
			}
		}
	}
	,destroy: function() {
		openfl.Lib.current.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.handleOverlay));
		openfl.Lib.current.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_MOVE,$bind(this,this.handleOverlay));
		openfl.Lib.current.stage.removeEventListener(openfl.events.MouseEvent.MOUSE_UP,$bind(this,this.handleOverlay));
		co.doubleduck.utils.TweenChain.removeTweens(this._itemBox);
		while(this._items.length > 0) {
			var curr = this._items.pop();
			this._itemBox.removeChild(curr);
			curr.destroy();
		}
	}
	,__class__: co.doubleduck.pinata.meta.ScrolledList
});
co.doubleduck.pinata.meta.Stats = function() { };
$hxClasses["co.doubleduck.pinata.meta.Stats"] = co.doubleduck.pinata.meta.Stats;
co.doubleduck.pinata.meta.Stats.__name__ = ["co","doubleduck","pinata","meta","Stats"];
co.doubleduck.pinata.meta.Stats._toolsData = null;
co.doubleduck.pinata.meta.Stats._eventer = null;
co.doubleduck.pinata.meta.Stats._toolsState = null;
co.doubleduck.pinata.meta.Stats._toolHPS = null;
co.doubleduck.pinata.meta.Stats._toolPrice = null;
co.doubleduck.pinata.meta.Stats._currHitVal = null;
co.doubleduck.pinata.meta.Stats._currHPSVal = null;
co.doubleduck.pinata.meta.Stats._playerCandies = null;
co.doubleduck.pinata.meta.Stats.addListener = function(type,listener) {
	co.doubleduck.pinata.meta.Stats.init();
	co.doubleduck.pinata.meta.Stats._eventer.addEventListener(type,listener);
};
co.doubleduck.pinata.meta.Stats.removeListener = function(type,listener) {
	co.doubleduck.pinata.meta.Stats.init();
	co.doubleduck.pinata.meta.Stats._eventer.removeEventListener(type,listener);
};
co.doubleduck.pinata.meta.Stats.notifyOnEvent = function(type) {
	co.doubleduck.pinata.meta.Stats.init();
	if(co.doubleduck.pinata.meta.Stats._eventer.hasEventListener(type)) co.doubleduck.pinata.meta.Stats._eventer.dispatchEvent(new openfl.events.Event(type));
};
co.doubleduck.pinata.meta.Stats.getHitVal = function() {
	if(co.doubleduck.pinata.meta.Stats._currHitVal == null) {
		co.doubleduck.pinata.meta.Stats.init();
		co.doubleduck.pinata.meta.Stats._currHitVal = co.doubleduck.pinata.meta.Stats.getHPSForTool("good-ol-bat");
	}
	return co.doubleduck.pinata.meta.Stats._currHitVal;
};
co.doubleduck.pinata.meta.Stats.getHPS = function() {
	if(co.doubleduck.pinata.meta.Stats._currHPSVal == null) {
		co.doubleduck.pinata.meta.Stats.init();
		co.doubleduck.pinata.meta.Stats._currHPSVal = co.doubleduck.pinata.meta.BigInt.fromInt(0);
		var toolsData = co.doubleduck.pinata.data.GameplayDB.getTools();
		var _g = 0;
		while(_g < toolsData.length) {
			var toolData = toolsData[_g];
			++_g;
			if(toolData.id == "good-ol-bat") continue;
			if(co.doubleduck.pinata.meta.Stats.getToolLevel(toolData.id) >= 1) co.doubleduck.pinata.meta.Stats._currHPSVal = co.doubleduck.pinata.meta.BigInt.add(co.doubleduck.pinata.meta.Stats._currHPSVal,co.doubleduck.pinata.meta.Stats.getHPSForTool(toolData.id));
		}
	}
	return co.doubleduck.pinata.meta.Stats._currHPSVal;
};
co.doubleduck.pinata.meta.Stats.getPCandies = function() {
	if(co.doubleduck.pinata.meta.Stats._playerCandies == null) co.doubleduck.pinata.meta.Stats._playerCandies = co.doubleduck.pinata.meta.BigInt.fromString(co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.PLAYER_CANDIES));
	return co.doubleduck.pinata.meta.Stats._playerCandies;
};
co.doubleduck.pinata.meta.Stats.setPCandies = function(val) {
	co.doubleduck.pinata.meta.Stats.init();
	co.doubleduck.pinata.meta.Stats._playerCandies = val;
	co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.PLAYER_CANDIES,co.doubleduck.pinata.meta.Stats._playerCandies.toFullString());
	co.doubleduck.pinata.meta.Stats.notifyOnEvent("UpdateCandiesEvent");
};
co.doubleduck.pinata.meta.Stats.getToolLevel = function(toolId) {
	co.doubleduck.pinata.meta.Stats.init();
	var _g = 0;
	var _g1 = co.doubleduck.pinata.meta.Stats._toolsState;
	while(_g < _g1.length) {
		var tool = _g1[_g];
		++_g;
		if(tool.id == toolId) return tool.lvl;
	}
	return 0;
};
co.doubleduck.pinata.meta.Stats.setToolLevel = function(toolId,toolLvl) {
	co.doubleduck.pinata.meta.Stats.init();
	var found = false;
	var _g = 0;
	var _g1 = co.doubleduck.pinata.meta.Stats._toolsState;
	while(_g < _g1.length) {
		var tool = _g1[_g];
		++_g;
		if(tool.id == toolId) {
			tool.lvl = toolLvl;
			found = true;
		}
	}
	if(!found) {
		var tool1 = { };
		tool1.id = toolId;
		tool1.lvl = toolLvl;
		co.doubleduck.pinata.meta.Stats._toolsState.push(tool1);
	}
	var datas = "";
	var _g2 = 0;
	var _g11 = co.doubleduck.pinata.meta.Stats._toolsState;
	while(_g2 < _g11.length) {
		var tool2 = _g11[_g2];
		++_g2;
		if(datas.length > 0) datas += ",";
		datas += tool2.id + ":" + tool2.lvl;
	}
	co.doubleduck.pinata.data.Persistence.setString(co.doubleduck.pinata.data.DataKey.TOOLS_STATE,datas);
	co.doubleduck.pinata.meta.Stats.notifyOnEvent("UpdateToolEvent");
	var newToolHPS = co.doubleduck.pinata.meta.Stats.getHPSForTool(toolId);
	if(toolId == "good-ol-bat") co.doubleduck.pinata.meta.Stats._currHitVal = newToolHPS; else {
		if(toolLvl > 1) co.doubleduck.pinata.meta.Stats._currHPSVal = co.doubleduck.pinata.meta.BigInt.subtract(co.doubleduck.pinata.meta.Stats._currHPSVal,co.doubleduck.pinata.meta.Stats.getHPSForTool(toolId,toolLvl - 1));
		co.doubleduck.pinata.meta.Stats._currHPSVal = co.doubleduck.pinata.meta.BigInt.add(co.doubleduck.pinata.meta.Stats._currHPSVal,newToolHPS);
		co.doubleduck.pinata.meta.Stats.notifyOnEvent("UpdateHPSEvent");
	}
};
co.doubleduck.pinata.meta.Stats.getHPSForTool = function(toolId,toolLvl) {
	if(toolLvl == null) toolLvl = -1;
	co.doubleduck.pinata.meta.Stats.init();
	if(toolLvl == -1) toolLvl = co.doubleduck.pinata.meta.Stats.getToolLevel(toolId);
	if(toolLvl == 0) return co.doubleduck.pinata.meta.BigInt.fromInt(0);
	if(co.doubleduck.pinata.meta.Stats._toolHPS.exists(toolId + ":" + toolLvl)) return co.doubleduck.pinata.meta.Stats._toolHPS.get(toolId + ":" + toolLvl);
	var toolDat = co.doubleduck.pinata.data.GameplayDB.getToolData(toolId);
	var hps = co.doubleduck.pinata.meta.Stats.calcValueForLevel(toolDat.hpsData,toolLvl);
	co.doubleduck.pinata.meta.Stats._toolHPS.set(toolId + ":" + toolLvl,hps);
	return hps;
};
co.doubleduck.pinata.meta.Stats.getPriceForTool = function(toolId,toolLvl) {
	if(toolLvl == null) toolLvl = -1;
	co.doubleduck.pinata.meta.Stats.init();
	if(toolLvl == -1) toolLvl = co.doubleduck.pinata.meta.Stats.getToolLevel(toolId);
	if(toolLvl == 0) return co.doubleduck.pinata.meta.BigInt.fromInt(0);
	if(co.doubleduck.pinata.meta.Stats._toolPrice.exists(toolId + ":" + toolLvl)) return co.doubleduck.pinata.meta.Stats._toolPrice.get(toolId + ":" + toolLvl);
	var toolDat = co.doubleduck.pinata.data.GameplayDB.getToolData(toolId);
	var price = co.doubleduck.pinata.meta.Stats.calcValueForLevel(toolDat.priceData,toolLvl);
	co.doubleduck.pinata.meta.Stats._toolPrice.set(toolId + ":" + toolLvl,price);
	return price;
};
co.doubleduck.pinata.meta.Stats.calcValueForLevel = function(valsData,level) {
	var ranges = valsData.split(",");
	var _g1 = 0;
	var _g = ranges.length;
	while(_g1 < _g) {
		var i = _g1++;
		var curr = ranges[i];
		if(i == ranges.length - 1) {
			var prev = ranges[i - 1].split("-")[1];
			var val = co.doubleduck.pinata.meta.BigInt.fromString(prev.split(":")[0]);
			var count = level - Std.parseInt(prev.split(":")[1]);
			var amount = co.doubleduck.pinata.meta.BigInt.fromString(curr);
			return co.doubleduck.pinata.meta.BigInt.add(val,co.doubleduck.pinata.meta.BigInt.mulScalar(amount,count));
		} else {
			var spl = curr.split("-");
			var fromLevel = Std.parseInt(spl[0].split(":")[1]);
			var toLevel = Std.parseInt(spl[1].split(":")[1]);
			if(level >= fromLevel && level <= toLevel) {
				var ratio = co.doubleduck.utils.Utils.map(level,fromLevel,toLevel);
				var intFrom = co.doubleduck.pinata.meta.BigInt.fromString(spl[0].split(":")[0]);
				var intTo = co.doubleduck.pinata.meta.BigInt.fromString(spl[1].split(":")[0]);
				var delta = co.doubleduck.pinata.meta.BigInt.subtract(intTo,intFrom);
				delta = co.doubleduck.pinata.meta.BigInt.mulScalar(delta,ratio);
				return co.doubleduck.pinata.meta.BigInt.add(intFrom,delta);
			}
		}
	}
	return co.doubleduck.pinata.meta.BigInt.fromInt(0);
};
co.doubleduck.pinata.meta.Stats.init = function() {
	if(co.doubleduck.pinata.meta.Stats._toolsState == null) {
		var datas = co.doubleduck.pinata.data.Persistence.getString(co.doubleduck.pinata.data.DataKey.TOOLS_STATE).split(",");
		co.doubleduck.pinata.meta.Stats._toolsState = new Array();
		var _g = 0;
		while(_g < datas.length) {
			var data = datas[_g];
			++_g;
			var parts = data.split(":");
			var tool = { };
			tool.id = parts[0];
			tool.lvl = Std.parseInt(parts[1]);
			co.doubleduck.pinata.meta.Stats._toolsState.push(tool);
		}
	}
	if(co.doubleduck.pinata.meta.Stats._toolHPS == null) co.doubleduck.pinata.meta.Stats._toolHPS = new haxe.ds.StringMap();
	if(co.doubleduck.pinata.meta.Stats._toolPrice == null) co.doubleduck.pinata.meta.Stats._toolPrice = new haxe.ds.StringMap();
	if(co.doubleduck.pinata.meta.Stats._eventer == null) co.doubleduck.pinata.meta.Stats._eventer = new openfl.events.EventDispatcher();
};
co.doubleduck.utils.SimpleAnimSprite = function(sheet,rows,cols,frames,shouldLoop) {
	if(shouldLoop == null) shouldLoop = false;
	var behDatas = new Array();
	behDatas.push(new spritesheet.data.BehaviorData("simple",frames,shouldLoop,24));
	var sprSheet = co.doubleduck.utils.DDAssets.getSpritesheet(sheet,cols,rows,-1,-1,behDatas);
	co.doubleduck.utils.AnimSprite.call(this,sprSheet);
	this.showBehavior("simple");
	this._lastTime = openfl.Lib.getTimer();
	this.addEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDone));
	this.addEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
};
$hxClasses["co.doubleduck.utils.SimpleAnimSprite"] = co.doubleduck.utils.SimpleAnimSprite;
co.doubleduck.utils.SimpleAnimSprite.__name__ = ["co","doubleduck","utils","SimpleAnimSprite"];
co.doubleduck.utils.SimpleAnimSprite.__super__ = co.doubleduck.utils.AnimSprite;
co.doubleduck.utils.SimpleAnimSprite.prototype = $extend(co.doubleduck.utils.AnimSprite.prototype,{
	setAnimFPS: function(fps) {
		this.resolveBehavior("simple").frameRate = fps;
		this.replayAnim();
	}
	,stopAnim: function() {
		this.removeEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
	}
	,replayAnim: function() {
		this.showBehavior("simple",true);
		if(!this.hasEventListener(openfl.events.Event.ENTER_FRAME)) {
			this._lastTime = openfl.Lib.getTimer();
			this.addEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
		}
	}
	,handleTick: function(e) {
		var time = openfl.Lib.getTimer();
		var delta = time - this._lastTime;
		this.update(delta);
		this._lastTime = time;
	}
	,handleDone: function(e) {
		this.removeEventListener(openfl.events.Event.COMPLETE,$bind(this,this.handleDone));
		this.removeEventListener(openfl.events.Event.ENTER_FRAME,$bind(this,this.handleTick));
	}
	,__class__: co.doubleduck.utils.SimpleAnimSprite
});
co.doubleduck.utils.Button = function(asset,centered,data,smoothing) {
	if(smoothing == null) smoothing = false;
	if(centered == null) centered = true;
	this.enabled = true;
	this.clickSound = null;
	openfl.display.Sprite.call(this);
	if(co.doubleduck.utils.Button.DOWN_EVENT == null) {
		co.doubleduck.utils.Button.DOWN_EVENT = openfl.events.MouseEvent.MOUSE_DOWN;
		co.doubleduck.utils.Button.OUT_EVENT = openfl.events.MouseEvent.MOUSE_OUT;
		co.doubleduck.utils.Button.UP_EVENT = openfl.events.MouseEvent.MOUSE_UP;
	}
	this.data = data;
	if(co.doubleduck.utils.Button.NORM_TRANS == null) co.doubleduck.utils.Button.NORM_TRANS = new openfl.geom.ColorTransform();
	if(co.doubleduck.utils.Button.DARK_TRANS == null) {
		co.doubleduck.utils.Button.DARK_TRANS = new openfl.geom.ColorTransform();
		co.doubleduck.utils.Button.DARK_TRANS.redOffset = -50;
		co.doubleduck.utils.Button.DARK_TRANS.greenOffset = -50;
		co.doubleduck.utils.Button.DARK_TRANS.blueOffset = -50;
	}
	if(co.doubleduck.utils.DDAssets.globalSmoothing) smoothing = true;
	this._image = new openfl.display.Bitmap(asset,openfl.display.PixelSnapping.AUTO,smoothing);
	this.addChild(this._image);
	if(centered) {
		this._imagePos = new openfl.geom.Point(-this._image.get_width() / 2,-this._image.get_height() / 2);
		this._image.set_x(this._imagePos.x);
		this._image.set_y(this._imagePos.y);
	} else this._imagePos = new openfl.geom.Point(0,0);
	this.addEventListener(co.doubleduck.utils.Button.DOWN_EVENT,$bind(this,this.handleMouse));
	this.pushMode = co.doubleduck.utils.ButtonPushMode.TINT_SCALE;
	this.actOnPress = false;
	this._effectApplied = false;
};
$hxClasses["co.doubleduck.utils.Button"] = co.doubleduck.utils.Button;
co.doubleduck.utils.Button.__name__ = ["co","doubleduck","utils","Button"];
co.doubleduck.utils.Button.NORM_TRANS = null;
co.doubleduck.utils.Button.DARK_TRANS = null;
co.doubleduck.utils.Button.__super__ = openfl.display.Sprite;
co.doubleduck.utils.Button.prototype = $extend(openfl.display.Sprite.prototype,{
	dePress: function() {
		this.removeEventListener(co.doubleduck.utils.Button.OUT_EVENT,$bind(this,this.handleMouse));
		this.removeEventListener(co.doubleduck.utils.Button.UP_EVENT,$bind(this,this.handleMouse));
		this.endEffect();
	}
	,handleMouse: function(e) {
		if(!this.enabled) return;
		if(e.type == co.doubleduck.utils.Button.DOWN_EVENT) {
			this.applyEffect();
			var effectTween = co.doubleduck.utils.TweenChain.get(this._image);
			if(this.actOnPress) effectTween.wait(10).call($bind(this,this.endEffect)).call($bind(this,this.dispatchEvent),[new openfl.events.Event("BUTTON_ACT_EVENT")]); else {
				effectTween.wait(100).call($bind(this,this.endEffect));
				this.addEventListener(co.doubleduck.utils.Button.OUT_EVENT,$bind(this,this.handleMouse));
				this.addEventListener(co.doubleduck.utils.Button.UP_EVENT,$bind(this,this.handleMouse));
			}
		}
		if(e.type == co.doubleduck.utils.Button.OUT_EVENT) {
			this.removeEventListener(co.doubleduck.utils.Button.OUT_EVENT,$bind(this,this.handleMouse));
			this.removeEventListener(co.doubleduck.utils.Button.UP_EVENT,$bind(this,this.handleMouse));
			this.endEffect();
		}
		if(e.type == co.doubleduck.utils.Button.UP_EVENT) {
			this.removeEventListener(co.doubleduck.utils.Button.OUT_EVENT,$bind(this,this.handleMouse));
			this.removeEventListener(co.doubleduck.utils.Button.UP_EVENT,$bind(this,this.handleMouse));
			this.endEffect();
			this.act();
		}
	}
	,applyEffect: function() {
		this._effectApplied = true;
		if(this.clickSound != null) co.doubleduck.utils.SoundMgr.playSound(this.clickSound); else if(co.doubleduck.utils.Button.defaultClickSound != null) co.doubleduck.utils.SoundMgr.playSound(co.doubleduck.utils.Button.defaultClickSound);
		if(this.pushMode == co.doubleduck.utils.ButtonPushMode.TINT_ONLY || this.pushMode == co.doubleduck.utils.ButtonPushMode.TINT_SCALE) this._image.get_transform().set_colorTransform(co.doubleduck.utils.Button.DARK_TRANS);
		if(this.pushMode == co.doubleduck.utils.ButtonPushMode.SCALE_ONLY || this.pushMode == co.doubleduck.utils.ButtonPushMode.TINT_SCALE) {
			this._image.set_scaleX(this._image.set_scaleY(0.93));
			this._image.set_x(this._imagePos.x * 0.93);
			this._image.set_y(this._imagePos.y * 0.93);
		}
		if(this.pushMode == co.doubleduck.utils.ButtonPushMode.JUICY_JIGGLE) {
			co.doubleduck.utils.TweenChain.removeTweens(this._image);
			this._image.set_scaleX(1.3);
			this._image.set_x(this._imagePos.x * this._image.get_scaleX());
			co.doubleduck.utils.TweenChain.get(this._image).tto({ scaleX : 1, x : this._imagePos.x},600,motion.easing.Elastic.get_easeOut());
			this._image.set_scaleY(0.7);
			this._image.set_y(this._imagePos.y * this._image.get_scaleY());
			co.doubleduck.utils.TweenChain.get(this._image).tto({ scaleY : 1, y : this._imagePos.y},600,motion.easing.Elastic.get_easeOut());
		}
	}
	,endEffect: function() {
		if(!this._effectApplied) return;
		if(this.pushMode == co.doubleduck.utils.ButtonPushMode.TINT_ONLY || this.pushMode == co.doubleduck.utils.ButtonPushMode.TINT_SCALE) this._image.get_transform().set_colorTransform(co.doubleduck.utils.Button.NORM_TRANS);
		if(this.pushMode == co.doubleduck.utils.ButtonPushMode.SCALE_ONLY || this.pushMode == co.doubleduck.utils.ButtonPushMode.TINT_SCALE) {
			this._image.set_scaleX(this._image.set_scaleY(1));
			this._image.set_x(this._imagePos.x);
			this._image.set_y(this._imagePos.y);
		}
		if(this.pushMode == co.doubleduck.utils.ButtonPushMode.JUICY_JIGGLE) {
		}
	}
	,act: function() {
		this.dispatchEvent(new openfl.events.Event("BUTTON_ACT_EVENT"));
	}
	,__class__: co.doubleduck.utils.Button
});
co.doubleduck.utils.ButtonPushMode = $hxClasses["co.doubleduck.utils.ButtonPushMode"] = { __ename__ : ["co","doubleduck","utils","ButtonPushMode"], __constructs__ : ["TINT_ONLY","SCALE_ONLY","TINT_SCALE","JUICY_JIGGLE"] };
co.doubleduck.utils.ButtonPushMode.TINT_ONLY = ["TINT_ONLY",0];
co.doubleduck.utils.ButtonPushMode.TINT_ONLY.toString = $estr;
co.doubleduck.utils.ButtonPushMode.TINT_ONLY.__enum__ = co.doubleduck.utils.ButtonPushMode;
co.doubleduck.utils.ButtonPushMode.SCALE_ONLY = ["SCALE_ONLY",1];
co.doubleduck.utils.ButtonPushMode.SCALE_ONLY.toString = $estr;
co.doubleduck.utils.ButtonPushMode.SCALE_ONLY.__enum__ = co.doubleduck.utils.ButtonPushMode;
co.doubleduck.utils.ButtonPushMode.TINT_SCALE = ["TINT_SCALE",2];
co.doubleduck.utils.ButtonPushMode.TINT_SCALE.toString = $estr;
co.doubleduck.utils.ButtonPushMode.TINT_SCALE.__enum__ = co.doubleduck.utils.ButtonPushMode;
co.doubleduck.utils.ButtonPushMode.JUICY_JIGGLE = ["JUICY_JIGGLE",3];
co.doubleduck.utils.ButtonPushMode.JUICY_JIGGLE.toString = $estr;
co.doubleduck.utils.ButtonPushMode.JUICY_JIGGLE.__enum__ = co.doubleduck.utils.ButtonPushMode;
haxe.ds = {};
haxe.ds.StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe.ds.StringMap;
haxe.ds.StringMap.__name__ = ["haxe","ds","StringMap"];
haxe.ds.StringMap.__interfaces__ = [IMap];
haxe.ds.StringMap.prototype = {
	set: function(key,value) {
		this.h["$" + key] = value;
	}
	,get: function(key) {
		return this.h["$" + key];
	}
	,exists: function(key) {
		return this.h.hasOwnProperty("$" + key);
	}
	,remove: function(key) {
		key = "$" + key;
		if(!this.h.hasOwnProperty(key)) return false;
		delete(this.h[key]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) a.push(key.substr(1));
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref["$" + i];
		}};
	}
	,toString: function() {
		var s = new StringBuf();
		s.b += "{";
		var it = this.keys();
		while( it.hasNext() ) {
			var i = it.next();
			if(i == null) s.b += "null"; else s.b += "" + i;
			s.b += " => ";
			s.add(Std.string(this.get(i)));
			if(it.hasNext()) s.b += ", ";
		}
		s.b += "}";
		return s.b;
	}
	,__class__: haxe.ds.StringMap
};
co.doubleduck.utils.DDAssets = function() { };
$hxClasses["co.doubleduck.utils.DDAssets"] = co.doubleduck.utils.DDAssets;
co.doubleduck.utils.DDAssets.__name__ = ["co","doubleduck","utils","DDAssets"];
co.doubleduck.utils.DDAssets.activeLocale = null;
co.doubleduck.utils.DDAssets.availLocales = null;
co.doubleduck.utils.DDAssets.getRawImage = function(path,cache) {
	if(cache == null) cache = true;
	path = co.doubleduck.utils.DDAssets.getLocalisedPath(path);
	var result = co.doubleduck.utils.DDAssets._cache.get(path);
	if(result == null) {
		result = openfl.Assets.getBitmapData(path,false);
		if(cache) co.doubleduck.utils.DDAssets._cache.set(path,result);
	}
	return result;
};
co.doubleduck.utils.DDAssets.getCenteredImage = function(path,cache) {
	if(cache == null) cache = true;
	var bmp = co.doubleduck.utils.DDAssets.getImage(path,cache);
	var _g = bmp;
	_g.set_x(_g.get_x() - bmp.get_width() / 2);
	var _g1 = bmp;
	_g1.set_y(_g1.get_y() - bmp.get_height() / 2);
	var spr = new openfl.display.Sprite();
	spr.addChild(bmp);
	return spr;
};
co.doubleduck.utils.DDAssets.getImage = function(path,cache) {
	if(cache == null) cache = true;
	var bmp = new openfl.display.Bitmap(co.doubleduck.utils.DDAssets.getRawImage(path,cache));
	bmp.smoothing = co.doubleduck.utils.DDAssets.globalSmoothing;
	return bmp;
};
co.doubleduck.utils.DDAssets.getSpritesheet = function(path,columns,rows,tileWidth,tileHeight,behaviours,cache) {
	if(cache == null) cache = true;
	if(tileHeight == null) tileHeight = 0;
	if(tileWidth == null) tileWidth = 0;
	if(rows == null) rows = 0;
	if(columns == null) columns = 0;
	path = co.doubleduck.utils.DDAssets.getLocalisedPath(path);
	var result = co.doubleduck.utils.DDAssets._spritesheetCache.get(path);
	if(result == null) {
		var bmpData = openfl.Assets.getBitmapData(path,false);
		if(tileWidth == -1) tileWidth = Math.floor(bmpData.width / columns);
		if(tileHeight == -1) tileHeight = Math.floor(bmpData.height / rows);
		result = spritesheet.importers.BitmapImporter.create(bmpData,columns,rows,tileWidth,tileHeight);
		var _g = 0;
		while(_g < behaviours.length) {
			var behaviour = behaviours[_g];
			++_g;
			result.addBehavior(behaviour);
		}
		if(cache) co.doubleduck.utils.DDAssets._spritesheetCache.set(path,result);
	}
	return result;
};
co.doubleduck.utils.DDAssets.getLocalisedPath = function(path) {
	if(!co.doubleduck.utils.DDAssets.localisedPaths.exists(path)) {
		var fileParts = path.split(".");
		var fileName = fileParts[0];
		var fileExt = fileParts[1];
		var localisedVersion = fileName + "-" + co.doubleduck.utils.DDAssets.activeLocale + "." + fileExt;
		if(openfl.Assets.exists(localisedVersion,"IMAGE")) co.doubleduck.utils.DDAssets.localisedPaths.set(path,localisedVersion); else co.doubleduck.utils.DDAssets.localisedPaths.set(path,path);
	}
	return co.doubleduck.utils.DDAssets.localisedPaths.get(path);
};
co.doubleduck.utils.Delayer = function(dur) {
	this._leftDur = this._totalDur = dur;
	this._isRunning = false;
};
$hxClasses["co.doubleduck.utils.Delayer"] = co.doubleduck.utils.Delayer;
co.doubleduck.utils.Delayer.__name__ = ["co","doubleduck","utils","Delayer"];
co.doubleduck.utils.Delayer.prototype = {
	start: function() {
		this._isRunning = true;
		co.doubleduck.utils.TweenChain.get(this).tto({ _leftDur : 0},this._leftDur).call($bind(this,this.act)).call($bind(this,this.restart));
	}
	,pause: function() {
		this._isRunning = false;
		co.doubleduck.utils.TweenChain.removeTweens(this);
	}
	,stop: function() {
		this._isRunning = false;
		co.doubleduck.utils.TweenChain.removeTweens(this);
		this._leftDur = this._totalDur;
	}
	,restart: function() {
		this.stop();
		this.start();
	}
	,isRunning: function() {
		return this._isRunning;
	}
	,setDuration: function(dur) {
		if(this._isRunning) co.doubleduck.utils.TweenChain.removeTweens(this);
		var ratio = this._leftDur / this._totalDur;
		this._totalDur = dur;
		this._leftDur = Math.floor(dur * ratio);
		if(this._isRunning) this.start();
	}
	,act: function() {
		if(this.handler != null) this.handler();
	}
	,__class__: co.doubleduck.utils.Delayer
};
openfl.events.Event = function(type,bubbles,cancelable) {
	if(cancelable == null) cancelable = false;
	if(bubbles == null) bubbles = false;
	this.type = type;
	this.bubbles = bubbles;
	this.cancelable = cancelable;
	this.eventPhase = openfl.events.EventPhase.AT_TARGET;
};
$hxClasses["openfl.events.Event"] = openfl.events.Event;
openfl.events.Event.__name__ = ["openfl","events","Event"];
openfl.events.Event.prototype = {
	clone: function() {
		var event = new openfl.events.Event(this.type,this.bubbles,this.cancelable);
		event.eventPhase = this.eventPhase;
		event.target = this.target;
		event.currentTarget = this.currentTarget;
		return event;
	}
	,isDefaultPrevented: function() {
		return this.__isCancelled || this.__isCancelledNow;
	}
	,stopImmediatePropagation: function() {
		this.__isCancelled = true;
		this.__isCancelledNow = true;
	}
	,stopPropagation: function() {
		this.__isCancelled = true;
	}
	,toString: function() {
		return "[Event type=" + this.type + " bubbles=" + Std.string(this.bubbles) + " cancelable=" + Std.string(this.cancelable) + "]";
	}
	,__class__: openfl.events.Event
};
co.doubleduck.utils.DynamicEvent = function(name,data) {
	openfl.events.Event.call(this,name);
	this.data = data;
};
$hxClasses["co.doubleduck.utils.DynamicEvent"] = co.doubleduck.utils.DynamicEvent;
co.doubleduck.utils.DynamicEvent.__name__ = ["co","doubleduck","utils","DynamicEvent"];
co.doubleduck.utils.DynamicEvent.__super__ = openfl.events.Event;
co.doubleduck.utils.DynamicEvent.prototype = $extend(openfl.events.Event.prototype,{
	__class__: co.doubleduck.utils.DynamicEvent
});
co.doubleduck.utils.Fonter = function() {
	throw "DDError: The static class 'Fonter' should not be instantiated.";
};
$hxClasses["co.doubleduck.utils.Fonter"] = co.doubleduck.utils.Fonter;
co.doubleduck.utils.Fonter.__name__ = ["co","doubleduck","utils","Fonter"];
co.doubleduck.utils.Fonter._kernCache = null;
co.doubleduck.utils.Fonter.commafyNum = function(num) {
	var numStr = "" + num;
	var numSuffix = "";
	if(num - Math.floor(num) != 0) {
		var splitted = numStr.split(".");
		numSuffix = "." + splitted[1];
		numStr = splitted[0];
	}
	var numRes = "";
	while(numStr.length > 0) if(numStr.length > 3) {
		numRes = "," + HxOverrides.substr(numStr,numStr.length - 3,3) + numRes;
		numStr = numStr.substring(0,numStr.length - 3);
	} else {
		numRes = numStr + numRes;
		numStr = "";
	}
	return numRes + numSuffix;
};
co.doubleduck.utils.Fonter.getMultilineString = function(str,bmpFont,delim) {
	if(delim == null) delim = "|";
	var lines = str.split(delim);
	var mlText = new openfl.display.Sprite();
	var hLineHeight = 0;
	var _g = 0;
	while(_g < lines.length) {
		var line = lines[_g];
		++_g;
		var lineImg = co.doubleduck.utils.Fonter.getString(line,bmpFont);
		if(mlText.get_numChildren() > 0) {
			var prevLine = mlText.getChildAt(mlText.get_numChildren() - 1);
			lineImg.set_y(prevLine.get_y() + prevLine.get_height() * 1.2);
		} else hLineHeight = lineImg.get_height() / 2;
		mlText.addChild(lineImg);
	}
	var hHeight = mlText.get_height() / 2;
	var finalText = new openfl.display.Sprite();
	var _g1 = 0;
	var _g2 = mlText.get_numChildren();
	while(_g1 < _g2) {
		var i = _g1++;
		var lineImg1 = mlText.getChildAt(i);
		var _g21 = lineImg1;
		_g21.set_y(_g21.get_y() - (hHeight - hLineHeight));
		while(lineImg1.get_numChildren() > 0) {
			var letter = lineImg1.getChildAt(0);
			lineImg1.removeChild(letter);
			var _g22 = letter;
			_g22.set_x(_g22.get_x() + lineImg1.get_x());
			var _g23 = letter;
			_g23.set_y(_g23.get_y() + lineImg1.get_y());
			finalText.addChild(letter);
		}
	}
	return finalText;
};
co.doubleduck.utils.Fonter.getString = function(str,bmpFont) {
	if(bmpFont == null) {
		if(co.doubleduck.utils.Fonter._defaultFont == null) throw "DDError: Fonter.getString() called with no default font and no specific font.";
		bmpFont = co.doubleduck.utils.Fonter._defaultFont;
	}
	if(bmpFont.charAt(bmpFont.length - 1) != "/") bmpFont += "/";
	var kernDat = co.doubleduck.utils.Fonter.getFontKernData(bmpFont);
	var strBox = new openfl.display.Sprite();
	var _g1 = 0;
	var _g = str.length;
	while(_g1 < _g) {
		var i = _g1++;
		var chr = str.charAt(i);
		var chrBmp = co.doubleduck.utils.Fonter.getChar(chr,bmpFont);
		chrBmp.set_x(0);
		if(strBox.get_numChildren() > 0) {
			var prevChar = strBox.getChildAt(strBox.get_numChildren() - 1);
			chrBmp.set_x(prevChar.get_x() + prevChar.get_width() + co.doubleduck.utils.Fonter.kernFor(str.charAt(i - 1),chr,kernDat) * co.doubleduck.utils.DDAssets.scale);
		}
		strBox.addChild(chrBmp);
	}
	var lastChar = strBox.getChildAt(strBox.get_numChildren() - 1);
	var hWidth = (lastChar.get_x() + lastChar.get_width()) / 2;
	var _g11 = 0;
	var _g2 = strBox.get_numChildren();
	while(_g11 < _g2) {
		var i1 = _g11++;
		var _g21 = strBox.getChildAt(i1);
		_g21.set_x(_g21.get_x() - hWidth);
	}
	return strBox;
};
co.doubleduck.utils.Fonter.getChar = function(chr,bmpFont) {
	var code = co.doubleduck.utils.Fonter.UTF8Code(chr);
	if(bmpFont == null) {
		if(co.doubleduck.utils.Fonter._defaultFont == null) throw "DDError: Fonter.getChar() - requested sprite with no default font and no specific font.";
		bmpFont = co.doubleduck.utils.Fonter._defaultFont;
	}
	if(bmpFont.charAt(bmpFont.length - 1) != "/") bmpFont += "/";
	var fontMap = co.doubleduck.utils.Fonter.getFontMap(bmpFont);
	if(!fontMap.exists(code)) {
		var bmpData = co.doubleduck.utils.DDAssets.getRawImage(bmpFont + "c" + code + ".png",false);
		if(bmpData == null) throw "DDError: Fonter.getChar() - requested char without asset - '" + chr + "' code: " + code + ".";
		fontMap.set(code,bmpData);
		bmpData;
	}
	var smoothing = co.doubleduck.utils.DDAssets.globalSmoothing;
	var chrBmp = new openfl.display.Bitmap(fontMap.get(code),openfl.display.PixelSnapping.AUTO,smoothing);
	var _g = chrBmp;
	_g.set_x(_g.get_x() - chrBmp.get_width() / 2);
	var _g1 = chrBmp;
	_g1.set_y(_g1.get_y() - chrBmp.get_height() / 2);
	return chrBmp;
};
co.doubleduck.utils.Fonter.getFontMap = function(fontUri) {
	if(co.doubleduck.utils.Fonter._fontCache == null) co.doubleduck.utils.Fonter._fontCache = new haxe.ds.StringMap();
	if(!co.doubleduck.utils.Fonter._fontCache.exists(fontUri)) {
		var v = new haxe.ds.IntMap();
		co.doubleduck.utils.Fonter._fontCache.set(fontUri,v);
		v;
	}
	return co.doubleduck.utils.Fonter._fontCache.get(fontUri);
};
co.doubleduck.utils.Fonter.kernFor = function(prev,curr,data) {
	var anyTo = data.get("any");
	if(data.exists(prev)) {
		var prevTo = data.get(prev);
		if(prevTo.exists(curr)) return prevTo.get(curr);
		if(anyTo.exists(curr)) {
			var avg = prevTo.get("any") + anyTo.get(curr);
			avg = avg / 2;
			return avg;
		}
		return prevTo.get("any");
	}
	if(anyTo.exists(curr)) return anyTo.get(curr);
	return anyTo.get("any");
};
co.doubleduck.utils.Fonter.getFontKernData = function(fontUri) {
	if(co.doubleduck.utils.Fonter._kernCache == null) co.doubleduck.utils.Fonter._kernCache = new haxe.ds.StringMap();
	var data;
	if(co.doubleduck.utils.Fonter._kernCache.exists(fontUri)) data = co.doubleduck.utils.Fonter._kernCache.get(fontUri); else {
		data = new haxe.ds.StringMap();
		var rawData = null;
		try {
			var strData = openfl.Assets.getText(fontUri + "kern.txt");
			if(strData != null) rawData = JSON.parse(strData);
		} catch( err ) {
			rawData = null;
		}
		if(rawData != null) {
			var froms = Reflect.fields(rawData);
			var _g = 0;
			while(_g < froms.length) {
				var fromMe = froms[_g];
				++_g;
				if(!data.exists(fromMe)) {
					var value = new haxe.ds.StringMap();
					data.set(fromMe,value);
				}
				var fromDat = Reflect.field(rawData,fromMe);
				var tos = Reflect.fields(fromDat);
				var _g1 = 0;
				while(_g1 < tos.length) {
					var toMe = tos[_g1];
					++_g1;
					var kern = Reflect.field(fromDat,toMe);
					var this1 = data.get(fromMe);
					this1.set(toMe,kern);
				}
			}
		} else {
			var value1 = new haxe.ds.StringMap();
			data.set("any",value1);
			var this2 = data.get("any");
			this2.set("any",0);
		}
		co.doubleduck.utils.Fonter._kernCache.set(fontUri,data);
		data;
	}
	return data;
};
co.doubleduck.utils.Fonter.UTF8Code = function(chr) {
	if(chr.length != 1) throw "DDError: Fonter.UTF8Code() - Got param '" + chr + "' and it's not a single character.";
	var pos = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(chr);
	if(pos == -1) throw "DDError: Fonter.UTF8Code() - Got param '" + chr + "' and it's in the charset.";
	return pos + 32;
};
co.doubleduck.utils.Fonter.prototype = {
	__class__: co.doubleduck.utils.Fonter
};
openfl.display.BitmapData = function(width,height,transparent,fillColor) {
	if(fillColor == null) fillColor = -1;
	if(transparent == null) transparent = true;
	this.transparent = transparent;
	if(width > 0 && height > 0) {
		this.width = width;
		this.height = height;
		this.rect = new openfl.geom.Rectangle(0,0,width,height);
		if(transparent) {
			if((function($this) {
				var $r;
				var $int = fillColor & -16777216;
				$r = $int < 0?4294967296.0 + $int:$int + 0.0;
				return $r;
			}(this)) == 0) fillColor = 0;
		} else fillColor = -16777216 | fillColor & 16777215;
		this.__image = new lime.graphics.Image(null,0,0,width,height,fillColor);
		this.__image.set_transparent(transparent);
		this.__isValid = true;
	}
	this.__createUVs();
};
$hxClasses["openfl.display.BitmapData"] = openfl.display.BitmapData;
openfl.display.BitmapData.__name__ = ["openfl","display","BitmapData"];
openfl.display.BitmapData.__interfaces__ = [openfl.display.IBitmapDrawable];
openfl.display.BitmapData.fromBase64 = function(base64,type,onload) {
	var bitmapData = new openfl.display.BitmapData(0,0,true);
	bitmapData.__loadFromBase64(base64,type,onload);
	return bitmapData;
};
openfl.display.BitmapData.fromBytes = function(bytes,rawAlpha,onload) {
	var bitmapData = new openfl.display.BitmapData(0,0,true);
	bitmapData.__loadFromBytes(bytes,rawAlpha,onload);
	return bitmapData;
};
openfl.display.BitmapData.fromCanvas = function(canvas,transparent) {
	if(transparent == null) transparent = true;
	var bitmapData = new openfl.display.BitmapData(0,0,transparent);
	bitmapData.__loadFromImage(lime.graphics.Image.fromCanvas(canvas));
	bitmapData.__image.set_transparent(transparent);
	return bitmapData;
};
openfl.display.BitmapData.fromFile = function(path,onload,onerror) {
	var bitmapData = new openfl.display.BitmapData(0,0,true);
	bitmapData.__loadFromFile(path,onload,onerror);
	return bitmapData;
};
openfl.display.BitmapData.fromImage = function(image,transparent) {
	if(transparent == null) transparent = true;
	var bitmapData = new openfl.display.BitmapData(0,0,transparent);
	bitmapData.__loadFromImage(image);
	bitmapData.__image.set_transparent(transparent);
	return bitmapData;
};
openfl.display.BitmapData.__flipPixel = function(pixel) {
	return (pixel & 255) << 24 | (pixel >> 8 & 255) << 16 | (pixel >> 16 & 255) << 8 | pixel >> 24 & 255;
};
openfl.display.BitmapData.__ucompare = function(n1,n2) {
	var tmp1;
	var tmp2;
	tmp1 = n1 >> 24 & 255;
	tmp2 = n2 >> 24 & 255;
	if(tmp1 != tmp2) if(tmp1 > tmp2) return 1; else return -1; else {
		tmp1 = n1 >> 16 & 255;
		tmp2 = n2 >> 16 & 255;
		if(tmp1 != tmp2) if(tmp1 > tmp2) return 1; else return -1; else {
			tmp1 = n1 >> 8 & 255;
			tmp2 = n2 >> 8 & 255;
			if(tmp1 != tmp2) if(tmp1 > tmp2) return 1; else return -1; else {
				tmp1 = n1 & 255;
				tmp2 = n2 & 255;
				if(tmp1 != tmp2) if(tmp1 > tmp2) return 1; else return -1; else return 0;
			}
		}
	}
};
openfl.display.BitmapData.prototype = {
	applyFilter: function(sourceBitmapData,sourceRect,destPoint,filter) {
		if(!this.__isValid || sourceBitmapData == null || !sourceBitmapData.__isValid) return;
		lime.graphics.utils.ImageCanvasUtil.convertToCanvas(this.__image);
		lime.graphics.utils.ImageCanvasUtil.createImageData(this.__image);
		lime.graphics.utils.ImageCanvasUtil.convertToCanvas(sourceBitmapData.__image);
		lime.graphics.utils.ImageCanvasUtil.createImageData(sourceBitmapData.__image);
		filter.__applyFilter(this.__image.buffer.__srcImageData,sourceBitmapData.__image.buffer.__srcImageData,sourceRect,destPoint);
		this.__image.dirty = true;
	}
	,clone: function() {
		if(!this.__isValid) return new openfl.display.BitmapData(this.width,this.height,this.transparent); else return openfl.display.BitmapData.fromImage(this.__image.clone(),this.transparent);
	}
	,colorTransform: function(rect,colorTransform) {
		this.__image.colorTransform(rect.__toLimeRectangle(),colorTransform.__toLimeColorMatrix());
	}
	,copyChannel: function(sourceBitmapData,sourceRect,destPoint,sourceChannel,destChannel) {
		if(!this.__isValid) return;
		var sourceChannel1;
		switch(sourceChannel) {
		case 1:
			sourceChannel1 = lime.graphics.ImageChannel.RED;
			break;
		case 2:
			sourceChannel1 = lime.graphics.ImageChannel.GREEN;
			break;
		case 4:
			sourceChannel1 = lime.graphics.ImageChannel.BLUE;
			break;
		case 8:
			sourceChannel1 = lime.graphics.ImageChannel.ALPHA;
			break;
		default:
			return;
		}
		var destChannel1;
		switch(destChannel) {
		case 1:
			destChannel1 = lime.graphics.ImageChannel.RED;
			break;
		case 2:
			destChannel1 = lime.graphics.ImageChannel.GREEN;
			break;
		case 4:
			destChannel1 = lime.graphics.ImageChannel.BLUE;
			break;
		case 8:
			destChannel1 = lime.graphics.ImageChannel.ALPHA;
			break;
		default:
			return;
		}
		this.__image.copyChannel(sourceBitmapData.__image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),sourceChannel1,destChannel1);
	}
	,copyPixels: function(sourceBitmapData,sourceRect,destPoint,alphaBitmapData,alphaPoint,mergeAlpha) {
		if(mergeAlpha == null) mergeAlpha = false;
		if(!this.__isValid || sourceBitmapData == null) return;
		this.__image.copyPixels(sourceBitmapData.__image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),alphaBitmapData != null?alphaBitmapData.__image:null,alphaPoint != null?alphaPoint.__toLimeVector2():null,mergeAlpha);
	}
	,dispose: function() {
		this.__image = null;
		this.width = 0;
		this.height = 0;
		this.rect = null;
		this.__isValid = false;
	}
	,draw: function(source,matrix,colorTransform,blendMode,clipRect,smoothing) {
		if(smoothing == null) smoothing = false;
		if(!this.__isValid) return;
		var _g = this.__image.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.convertToCanvas(this.__image);
			lime.graphics.utils.ImageCanvasUtil.sync(this.__image);
			var buffer = this.__image.buffer;
			var renderSession = new openfl._internal.renderer.RenderSession();
			renderSession.context = buffer.__srcContext;
			renderSession.roundPixels = true;
			if(!smoothing) {
				buffer.__srcContext.mozImageSmoothingEnabled = false;
				buffer.__srcContext.webkitImageSmoothingEnabled = false;
				buffer.__srcContext.imageSmoothingEnabled = false;
			}
			var matrixCache = source.__worldTransform;
			if(matrix != null) source.__worldTransform = matrix; else source.__worldTransform = new openfl.geom.Matrix();
			source.__updateChildren(false);
			source.__renderCanvas(renderSession);
			source.__worldTransform = matrixCache;
			source.__updateChildren(true);
			if(!smoothing) {
				buffer.__srcContext.mozImageSmoothingEnabled = true;
				buffer.__srcContext.webkitImageSmoothingEnabled = true;
				buffer.__srcContext.imageSmoothingEnabled = true;
			}
			buffer.__srcContext.setTransform(1,0,0,1,0,0);
			break;
		default:
		}
	}
	,encode: function(rect,compressor,byteArray) {
		if(!this.__isValid || rect == null) return byteArray = null;
		if(js.Boot.__instanceof(compressor,openfl.display.PNGEncoderOptions)) return byteArray = this.__image.encode("png"); else if(js.Boot.__instanceof(compressor,openfl.display.JPEGEncoderOptions)) return byteArray = this.__image.encode("jpg",(js.Boot.__cast(compressor , openfl.display.JPEGEncoderOptions)).quality);
		return byteArray = null;
	}
	,fillRect: function(rect,color) {
		if(!this.__isValid || rect == null) return;
		this.__image.fillRect(rect.__toLimeRectangle(),color);
	}
	,floodFill: function(x,y,color) {
		if(!this.__isValid) return;
		this.__image.floodFill(x,y,color);
	}
	,generateFilterRect: function(sourceRect,filter) {
		return sourceRect.clone();
	}
	,getBuffer: function(gl) {
		if(this.__buffer == null) {
			var data = [this.width,this.height,0,1,1,0,this.height,0,0,1,this.width,0,0,1,0,0,0,0,0,0];
			this.__buffer = gl.createBuffer();
			gl.bindBuffer(gl.ARRAY_BUFFER,this.__buffer);
			gl.bufferData(gl.ARRAY_BUFFER,new Float32Array(data),gl.STATIC_DRAW);
			gl.bindBuffer(gl.ARRAY_BUFFER,null);
		}
		return this.__buffer;
	}
	,getColorBoundsRect: function(mask,color,findColor) {
		if(findColor == null) findColor = true;
		return this.__image.get_rect().__toFlashRectangle();
	}
	,getPixel: function(x,y) {
		if(!this.__isValid) return 0;
		return this.__image.getPixel(x,y);
	}
	,getPixel32: function(x,y) {
		if(!this.__isValid) return 0;
		return this.__image.getPixel32(x,y);
	}
	,getPixels: function(rect) {
		if(!this.__isValid) return null;
		if(rect == null) rect = this.rect;
		return this.__image.getPixels(rect.__toLimeRectangle());
	}
	,getTexture: function(gl) {
		if(this.__texture == null) {
			this.__texture = gl.createTexture();
			gl.bindTexture(gl.TEXTURE_2D,this.__texture);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR);
			this.__image.dirty = true;
		}
		if(this.__image.dirty) {
			gl.bindTexture(gl.TEXTURE_2D,this.__texture);
			var textureImage = this.__image.clone();
			textureImage.set_premultiplied(true);
			gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,this.width,this.height,0,gl.RGBA,gl.UNSIGNED_BYTE,textureImage.get_data());
			gl.bindTexture(gl.TEXTURE_2D,null);
			this.__image.dirty = false;
		}
		return this.__texture;
	}
	,getVector: function(rect) {
		var pixels = this.getPixels(rect);
		var length = pixels.length / 4 | 0;
		var result;
		var this1;
		this1 = new openfl.VectorData();
		var this2;
		this2 = new Array(length);
		this1.data = this2;
		this1.length = length;
		this1.fixed = true;
		result = this1;
		var _g = 0;
		while(_g < length) {
			var i = _g++;
			var value = pixels.readUnsignedInt();
			if(!result.fixed) {
				if(i >= result.length) result.length = i + 1;
				if(result.data.length < result.length) {
					var data;
					var this3;
					this3 = new Array(result.data.length + 10);
					data = this3;
					haxe.ds._Vector.Vector_Impl_.blit(result.data,0,data,0,result.data.length);
					result.data = data;
				}
			}
			result.data[i] = value;
		}
		return result;
	}
	,histogram: function(hRect) {
		var rect;
		if(hRect != null) rect = hRect; else rect = new openfl.geom.Rectangle(0,0,this.width,this.height);
		var pixels = this.getPixels(rect);
		var result;
		var _g = [];
		var _g1 = 0;
		while(_g1 < 4) {
			var i = _g1++;
			_g.push((function($this) {
				var $r;
				var _g2 = [];
				{
					var _g3 = 0;
					while(_g3 < 256) {
						var j = _g3++;
						_g2.push(0);
					}
				}
				$r = _g2;
				return $r;
			}(this)));
		}
		result = _g;
		var _g21 = 0;
		var _g11 = pixels.length;
		while(_g21 < _g11) {
			var i1 = _g21++;
			++result[i1 % 4][pixels.readUnsignedByte()];
		}
		return result;
	}
	,hitTest: function(firstPoint,firstAlphaThreshold,secondObject,secondBitmapDataPoint,secondAlphaThreshold) {
		if(secondAlphaThreshold == null) secondAlphaThreshold = 1;
		if(!this.__isValid) return false;
		openfl.Lib.notImplemented("BitmapData.hitTest");
		return false;
	}
	,lock: function() {
	}
	,merge: function(sourceBitmapData,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
		if(!this.__isValid || sourceBitmapData == null || !sourceBitmapData.__isValid || sourceRect == null || destPoint == null) return;
		this.__image.merge(sourceBitmapData.__image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	}
	,noise: function(randomSeed,low,high,channelOptions,grayScale) {
		if(grayScale == null) grayScale = false;
		if(channelOptions == null) channelOptions = 7;
		if(high == null) high = 255;
		if(low == null) low = 0;
		if(!this.__isValid) return;
		openfl.Lib.notImplemented("BitmapData.noise");
	}
	,paletteMap: function(sourceBitmapData,sourceRect,destPoint,redArray,greenArray,blueArray,alphaArray) {
		var sw = sourceRect.width | 0;
		var sh = sourceRect.height | 0;
		var pixels = this.getPixels(sourceRect);
		pixels.position = 0;
		var pixelValue;
		var r;
		var g;
		var b;
		var a;
		var color;
		var c1;
		var c2;
		var c3;
		var c4;
		var _g1 = 0;
		var _g = sh * sw;
		while(_g1 < _g) {
			var i = _g1++;
			pixelValue = pixels.readUnsignedInt();
			if(alphaArray == null) c1 = pixelValue & -16777216; else c1 = alphaArray[pixelValue >> 24 & 255];
			if(redArray == null) c2 = pixelValue & 16711680; else c2 = redArray[pixelValue >> 16 & 255];
			if(greenArray == null) c3 = pixelValue & 65280; else c3 = greenArray[pixelValue >> 8 & 255];
			if(blueArray == null) c4 = pixelValue & 255; else c4 = blueArray[pixelValue & 255];
			a = (c1 >> 24 & 255) + (c2 >> 24 & 255) + (c3 >> 24 & 255) + (c4 >> 24 & 255);
			if(a > 255) a == 255;
			r = (c1 >> 16 & 255) + (c2 >> 16 & 255) + (c3 >> 16 & 255) + (c4 >> 16 & 255);
			if(r > 255) r == 255;
			g = (c1 >> 8 & 255) + (c2 >> 8 & 255) + (c3 >> 8 & 255) + (c4 >> 8 & 255);
			if(g > 255) g == 255;
			b = (c1 & 255) + (c2 & 255) + (c3 & 255) + (c4 & 255);
			if(b > 255) b == 255;
			color = a << 24 | r << 16 | g << 8 | b;
			pixels.position = i * 4;
			pixels.writeUnsignedInt(color);
		}
		pixels.position = 0;
		var destRect = new openfl.geom.Rectangle(destPoint.x,destPoint.y,sw,sh);
		this.setPixels(destRect,pixels);
	}
	,perlinNoise: function(baseX,baseY,numOctaves,randomSeed,stitch,fractalNoise,channelOptions,grayScale,offsets) {
		if(grayScale == null) grayScale = false;
		if(channelOptions == null) channelOptions = 7;
		openfl.Lib.notImplemented("BitmapData.perlinNoise");
	}
	,scroll: function(x,y) {
		openfl.Lib.notImplemented("BitmapData.scroll");
	}
	,setPixel: function(x,y,color) {
		if(!this.__isValid) return;
		this.__image.setPixel(x,y,color);
	}
	,setPixel32: function(x,y,color) {
		if(!this.__isValid) return;
		this.__image.setPixel32(x,y,color);
	}
	,setPixels: function(rect,byteArray) {
		if(!this.__isValid || rect == null) return;
		this.__image.setPixels(rect.__toLimeRectangle(),byteArray);
	}
	,setVector: function(rect,inputVector) {
		var byteArray = new lime.utils.ByteArray();
		byteArray.set_length(inputVector.length * 4);
		var _g = 0;
		while(_g < inputVector.length) {
			var color = inputVector.data[_g];
			++_g;
			byteArray.writeUnsignedInt(color);
		}
		byteArray.position = 0;
		this.setPixels(rect,byteArray);
	}
	,threshold: function(sourceBitmapData,sourceRect,destPoint,operation,threshold,color,mask,copySource) {
		if(copySource == null) copySource = false;
		if(mask == null) mask = -1;
		if(color == null) color = 0;
		if(sourceBitmapData == this && sourceRect.equals(this.rect) && destPoint.x == 0 && destPoint.y == 0) {
			var hits = 0;
			threshold = (threshold & 255) << 24 | (threshold >> 8 & 255) << 16 | (threshold >> 16 & 255) << 8 | threshold >> 24 & 255;
			color = (color & 255) << 24 | (color >> 8 & 255) << 16 | (color >> 16 & 255) << 8 | color >> 24 & 255;
			var memory = new lime.utils.ByteArray();
			memory.set_length(this.width * this.height * 4);
			memory = this.getPixels(this.rect);
			memory.position = 0;
			openfl.Memory.select(memory);
			var thresholdMask = threshold & mask;
			var width_yy;
			var position;
			var pixelMask;
			var pixelValue;
			var i;
			var test;
			var _g1 = 0;
			var _g = this.height;
			while(_g1 < _g) {
				var yy = _g1++;
				width_yy = this.width * yy;
				var _g3 = 0;
				var _g2 = this.width;
				while(_g3 < _g2) {
					var xx = _g3++;
					position = (width_yy + xx) * 4;
					pixelValue = openfl.Memory._setPositionTemporarily(position,function() {
						return openfl.Memory.gcRef.readInt();
					});
					pixelMask = pixelValue & mask;
					i = openfl.display.BitmapData.__ucompare(pixelMask,thresholdMask);
					test = false;
					if(operation == "==") test = i == 0; else if(operation == "<") test = i == -1; else if(operation == ">") test = i == 1; else if(operation == "!=") test = i != 0; else if(operation == "<=") test = i == 0 || i == -1; else if(operation == ">=") test = i == 0 || i == 1;
					if(test) {
						openfl.Memory.setI32(position,color);
						hits++;
					}
				}
			}
			memory.position = 0;
			this.setPixels(this.rect,memory);
			openfl.Memory.select(null);
			return hits;
		} else {
			var sx = sourceRect.x | 0;
			var sy = sourceRect.y | 0;
			var sw = sourceBitmapData.width | 0;
			var sh = sourceBitmapData.height | 0;
			var dx = destPoint.x | 0;
			var dy = destPoint.y | 0;
			var bw = this.width - sw - dx;
			var bh = this.height - sh - dy;
			var dw;
			if(bw < 0) dw = sw + (this.width - sw - dx); else dw = sw;
			var dh;
			if(bw < 0) dh = sh + (this.height - sh - dy); else dh = sh;
			var hits1 = 0;
			threshold = (threshold & 255) << 24 | (threshold >> 8 & 255) << 16 | (threshold >> 16 & 255) << 8 | threshold >> 24 & 255;
			color = (color & 255) << 24 | (color >> 8 & 255) << 16 | (color >> 16 & 255) << 8 | color >> 24 & 255;
			var canvasMemory = sw * sh * 4;
			var sourceMemory = 0;
			if(copySource) sourceMemory = sw * sh * 4;
			var totalMemory = canvasMemory + sourceMemory;
			var memory1 = new lime.utils.ByteArray();
			if(memory1.allocated < totalMemory) memory1.___resizeBuffer(memory1.allocated = Std["int"](Math.max(totalMemory,memory1.allocated * 2))); else if(memory1.allocated > totalMemory) memory1.___resizeBuffer(memory1.allocated = totalMemory);
			memory1.length = totalMemory;
			totalMemory;
			memory1.position = 0;
			var bitmapData = sourceBitmapData.clone();
			var pixels = bitmapData.getPixels(sourceRect);
			memory1.writeBytes(pixels);
			memory1.position = canvasMemory;
			if(copySource) memory1.writeBytes(pixels);
			memory1.position = 0;
			openfl.Memory.select(memory1);
			var thresholdMask1 = threshold & mask;
			var position1;
			var pixelMask1;
			var pixelValue1;
			var i1;
			var test1;
			var _g4 = 0;
			while(_g4 < dh) {
				var yy1 = _g4++;
				var _g11 = 0;
				while(_g11 < dw) {
					var xx1 = _g11++;
					position1 = (xx1 + sx + (yy1 + sy) * sw) * 4;
					pixelValue1 = openfl.Memory._setPositionTemporarily(position1,function() {
						return openfl.Memory.gcRef.readInt();
					});
					pixelMask1 = pixelValue1 & mask;
					i1 = openfl.display.BitmapData.__ucompare(pixelMask1,thresholdMask1);
					test1 = false;
					if(operation == "==") test1 = i1 == 0; else if(operation == "<") test1 = i1 == -1; else if(operation == ">") test1 = i1 == 1; else if(operation == "!=") test1 = i1 != 0; else if(operation == "<=") test1 = i1 == 0 || i1 == -1; else if(operation == ">=") test1 = i1 == 0 || i1 == 1;
					if(test1) {
						openfl.Memory.setI32(position1,color);
						hits1++;
					} else if(copySource) openfl.Memory.setI32(position1,openfl.Memory._setPositionTemporarily(canvasMemory + position1,function() {
						return openfl.Memory.gcRef.readInt();
					}));
				}
			}
			memory1.position = 0;
			bitmapData.setPixels(sourceRect,memory1);
			this.copyPixels(bitmapData,bitmapData.rect,destPoint);
			openfl.Memory.select(null);
			return hits1;
		}
	}
	,unlock: function(changeRect) {
	}
	,__createUVs: function() {
		if(this.__uvData == null) this.__uvData = new openfl.display.TextureUvs();
		this.__uvData.x0 = 0;
		this.__uvData.y0 = 0;
		this.__uvData.x1 = 1;
		this.__uvData.y1 = 0;
		this.__uvData.x2 = 1;
		this.__uvData.y2 = 1;
		this.__uvData.x3 = 0;
		this.__uvData.y3 = 1;
	}
	,__loadFromBase64: function(base64,type,onload) {
		var _g = this;
		lime.graphics.Image.fromBase64(base64,type,function(image) {
			_g.__loadFromImage(image);
			if(onload != null) onload(_g);
		});
	}
	,__loadFromBytes: function(bytes,rawAlpha,onload) {
		var _g = this;
		lime.graphics.Image.fromBytes(bytes,function(image) {
			_g.__loadFromImage(image);
			if(rawAlpha != null) {
				lime.graphics.utils.ImageCanvasUtil.convertToCanvas(_g.__image);
				lime.graphics.utils.ImageCanvasUtil.createImageData(_g.__image);
				var data = _g.__image.buffer.data;
				var _g2 = 0;
				var _g1 = rawAlpha.length;
				while(_g2 < _g1) {
					var i = _g2++;
					data[i * 4 + 3] = rawAlpha.readUnsignedByte();
				}
				_g.__image.dirty = true;
			}
			if(onload != null) onload(_g);
		});
	}
	,__loadFromFile: function(path,onload,onerror) {
		var _g = this;
		lime.graphics.Image.fromFile(path,function(image) {
			_g.__loadFromImage(image);
			if(onload != null) onload(_g);
		},onerror);
	}
	,__loadFromImage: function(image) {
		this.__image = image;
		this.width = image.width;
		this.height = image.height;
		this.rect = new openfl.geom.Rectangle(0,0,image.width,image.height);
		this.__isValid = true;
	}
	,__renderCanvas: function(renderSession) {
		if(!this.__isValid) return;
		lime.graphics.utils.ImageCanvasUtil.sync(this.__image);
		var context = renderSession.context;
		if(this.__worldTransform == null) this.__worldTransform = new openfl.geom.Matrix();
		context.globalAlpha = 1;
		var transform = this.__worldTransform;
		if(renderSession.roundPixels) context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx | 0,transform.ty | 0); else context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx,transform.ty);
		context.drawImage(this.__image.buffer.get_src(),0,0);
	}
	,__renderMask: function(renderSession) {
	}
	,__sync: function() {
		lime.graphics.utils.ImageCanvasUtil.sync(this.__image);
	}
	,__updateChildren: function(transformOnly) {
	}
	,__class__: openfl.display.BitmapData
};
co.doubleduck.utils.SplashBG = function(width,height,transparent,fillRGBA,onload) {
	if(fillRGBA == null) fillRGBA = -1;
	if(transparent == null) transparent = true;
	openfl.display.BitmapData.call(this,0,0,transparent,fillRGBA);
	if(co.doubleduck.utils.SplashBG.preload != null) {
		this.__image = co.doubleduck.utils.SplashBG.preload;
		width = this.__image.width;
		height = this.__image.height;
	} else this.__loadFromBase64(haxe.Resource.getString(co.doubleduck.utils.SplashBG.resourceName),co.doubleduck.utils.SplashBG.resourceType,function(b) {
		if(co.doubleduck.utils.SplashBG.preload == null) co.doubleduck.utils.SplashBG.preload = b.__image;
		if(onload != null) onload(b);
	});
};
$hxClasses["co.doubleduck.utils.SplashBG"] = co.doubleduck.utils.SplashBG;
co.doubleduck.utils.SplashBG.__name__ = ["co","doubleduck","utils","SplashBG"];
co.doubleduck.utils.SplashBG.preload = null;
co.doubleduck.utils.SplashBG.__super__ = openfl.display.BitmapData;
co.doubleduck.utils.SplashBG.prototype = $extend(openfl.display.BitmapData.prototype,{
	__class__: co.doubleduck.utils.SplashBG
});
co.doubleduck.utils.ProgBG = function(width,height,transparent,fillRGBA,onload) {
	if(fillRGBA == null) fillRGBA = -1;
	if(transparent == null) transparent = true;
	openfl.display.BitmapData.call(this,0,0,transparent,fillRGBA);
	if(co.doubleduck.utils.ProgBG.preload != null) {
		this.__image = co.doubleduck.utils.ProgBG.preload;
		width = this.__image.width;
		height = this.__image.height;
	} else this.__loadFromBase64(haxe.Resource.getString(co.doubleduck.utils.ProgBG.resourceName),co.doubleduck.utils.ProgBG.resourceType,function(b) {
		if(co.doubleduck.utils.ProgBG.preload == null) co.doubleduck.utils.ProgBG.preload = b.__image;
		if(onload != null) onload(b);
	});
};
$hxClasses["co.doubleduck.utils.ProgBG"] = co.doubleduck.utils.ProgBG;
co.doubleduck.utils.ProgBG.__name__ = ["co","doubleduck","utils","ProgBG"];
co.doubleduck.utils.ProgBG.preload = null;
co.doubleduck.utils.ProgBG.__super__ = openfl.display.BitmapData;
co.doubleduck.utils.ProgBG.prototype = $extend(openfl.display.BitmapData.prototype,{
	__class__: co.doubleduck.utils.ProgBG
});
co.doubleduck.utils.ProgFill = function(width,height,transparent,fillRGBA,onload) {
	if(fillRGBA == null) fillRGBA = -1;
	if(transparent == null) transparent = true;
	openfl.display.BitmapData.call(this,0,0,transparent,fillRGBA);
	if(co.doubleduck.utils.ProgFill.preload != null) {
		this.__image = co.doubleduck.utils.ProgFill.preload;
		width = this.__image.width;
		height = this.__image.height;
	} else this.__loadFromBase64(haxe.Resource.getString(co.doubleduck.utils.ProgFill.resourceName),co.doubleduck.utils.ProgFill.resourceType,function(b) {
		if(co.doubleduck.utils.ProgFill.preload == null) co.doubleduck.utils.ProgFill.preload = b.__image;
		if(onload != null) onload(b);
	});
};
$hxClasses["co.doubleduck.utils.ProgFill"] = co.doubleduck.utils.ProgFill;
co.doubleduck.utils.ProgFill.__name__ = ["co","doubleduck","utils","ProgFill"];
co.doubleduck.utils.ProgFill.preload = null;
co.doubleduck.utils.ProgFill.__super__ = openfl.display.BitmapData;
co.doubleduck.utils.ProgFill.prototype = $extend(openfl.display.BitmapData.prototype,{
	__class__: co.doubleduck.utils.ProgFill
});
co.doubleduck.utils.ProgBar = function(back,fill) {
	this._maskTo = 1;
	this._maskFrom = 0;
	openfl.display.Sprite.call(this);
	this._back = back;
	this._fill = fill;
	this.addChild(this._back);
	this._fillPerc = { };
	this._fillPerc.val = 0;
	this._fillWidth = fill.get_width();
	this._fillHeight = fill.get_height();
	this._mask = new openfl.display.Sprite();
	this.setupMask();
	this.updateMask();
	this._fill.set_mask(this._mask);
	this.addChild(this._fill);
	this.addChild(this._mask);
};
$hxClasses["co.doubleduck.utils.ProgBar"] = co.doubleduck.utils.ProgBar;
co.doubleduck.utils.ProgBar.__name__ = ["co","doubleduck","utils","ProgBar"];
co.doubleduck.utils.ProgBar.__super__ = openfl.display.Sprite;
co.doubleduck.utils.ProgBar.prototype = $extend(openfl.display.Sprite.prototype,{
	setFillVals: function(width,height) {
		this._fillWidth = width;
		this._fillHeight = height;
		this.setupMask();
	}
	,setFillPerc: function(value,duration) {
		if(duration == null) duration = 0;
		if(value == 0) value = 0.001;
		co.doubleduck.utils.TweenChain.removeTweens(this._fillPerc);
		if(duration <= 0) {
			this._fillPerc.val = value;
			this.updateMask();
		} else co.doubleduck.utils.TweenChain.get(this._fillPerc).tto({ val : value},duration,null,$bind(this,this.updateMask));
	}
	,getFillPerc: function() {
		return this._fillPerc.val;
	}
	,set_maskFrom: function(val) {
		this._maskFrom = val;
		this.setupMask();
		return this._maskFrom;
	}
	,set_maskTo: function(val) {
		this._maskTo = val;
		this.setupMask();
		return this._maskTo;
	}
	,setupMask: function() {
		this._mask.get_graphics().clear();
		this._mask.get_graphics().beginFill(0);
		this._mask.get_graphics().drawRect(0,0,this._fillWidth * (this._maskTo - this._maskFrom),this._fillHeight);
		this._mask.get_graphics().endFill();
		this._mask.set_x(this._fillWidth * this._maskFrom);
	}
	,updateMask: function(obj) {
		this._mask.set_scaleX(this._fillPerc.val);
	}
	,__class__: co.doubleduck.utils.ProgBar
	,__properties__: $extend(openfl.display.Sprite.prototype.__properties__,{set_maskTo:"set_maskTo",set_maskFrom:"set_maskFrom"})
});
co.doubleduck.utils.SoundMgr = function() { };
$hxClasses["co.doubleduck.utils.SoundMgr"] = co.doubleduck.utils.SoundMgr;
co.doubleduck.utils.SoundMgr.__name__ = ["co","doubleduck","utils","SoundMgr"];
co.doubleduck.utils.SoundMgr._muted = null;
co.doubleduck.utils.SoundMgr._sounds = null;
co.doubleduck.utils.SoundMgr._perstistence = null;
co.doubleduck.utils.SoundMgr.forceFileType = function(type) {
	co.doubleduck.utils.SoundMgr._fileType = type;
};
co.doubleduck.utils.SoundMgr.init = function(persistence) {
	co.doubleduck.utils.SoundMgr._perstistence = persistence;
	if(co.doubleduck.utils.SoundMgr._sounds == null) {
		co.doubleduck.utils.SoundMgr._sounds = new haxe.ds.StringMap();
		co.doubleduck.utils.SoundMgr._muted = co.doubleduck.utils.SoundMgr._perstistence.getValue("MUTE_STATE") == "true";
	}
	co.doubleduck.utils.SoundMgr.available = true;
};
co.doubleduck.utils.SoundMgr.getMute = function() {
	return co.doubleduck.utils.SoundMgr._muted;
};
co.doubleduck.utils.SoundMgr.setMute = function(value) {
	co.doubleduck.utils.SoundMgr._muted = value;
	if(co.doubleduck.utils.SoundMgr._muted) co.doubleduck.utils.SoundMgr._perstistence.setValue("MUTE_STATE","true"); else co.doubleduck.utils.SoundMgr._perstistence.setValue("MUTE_STATE","true");
	co.doubleduck.utils.SoundMgr.stopAll();
};
co.doubleduck.utils.SoundMgr.isAvailable = function() {
	return co.doubleduck.utils.SoundMgr.available && !(co.doubleduck.utils.SoundMgr.isAndroidBrowser && !co.doubleduck.utils.SoundMgr.isChrome);
	return co.doubleduck.utils.SoundMgr.available;
};
co.doubleduck.utils.SoundMgr.playSound = function(name,loop,startingPos,music,forceType) {
	if(forceType == null) forceType = "";
	if(music == null) music = false;
	if(startingPos == null) startingPos = 0;
	if(loop == null) loop = false;
	if(co.doubleduck.utils.SoundMgr._muted || !co.doubleduck.utils.SoundMgr.isAvailable()) return null;
	var sound;
	var fileType = co.doubleduck.utils.SoundMgr.fileType();
	if(forceType != "") fileType = forceType;
	if(music) {
		if(co.doubleduck.utils.SoundMgr.isChrome) {
			var audio = co.doubleduck.utils.SoundMgr.audios.get("musics/" + name);
			audio.loop = loop;
			audio.play();
			return name;
		}
		sound = openfl.Assets.getSound("musics/" + name + fileType,true);
	} else sound = openfl.Assets.getSound("sounds/" + name + fileType,true);
	if(sound != null) {
		var newHandle = co.doubleduck.utils.SoundMgr.newHandle();
		var loops;
		if(loop) loops = 10000; else loops = 0;
		if(startingPos > 0) {
			if(startingPos >= sound.length * 1000 * 0.925) startingPos = 0;
		}
		var chan = sound.play(startingPos,loops);
		chan.addEventListener(openfl.events.Event.SOUND_COMPLETE,co.doubleduck.utils.SoundMgr.handleSoundFinish);
		var data = { };
		data.sName = name;
		data.sChannel = chan;
		data.isLoop = loop;
		data.isMusic = music;
		data.forceType = forceType;
		co.doubleduck.utils.SoundMgr._sounds.set(newHandle,data);
		return newHandle;
	}
	return null;
};
co.doubleduck.utils.SoundMgr.pauseSound = function(sHandle) {
	if(!co.doubleduck.utils.SoundMgr._sounds.exists(sHandle)) return;
	var sound = co.doubleduck.utils.SoundMgr._sounds.get(sHandle);
	sound.pausePos = sound.sChannel.get_position();
	sound.sChannel.stop();
};
co.doubleduck.utils.SoundMgr.resumeSound = function(sHandle) {
	if(!co.doubleduck.utils.SoundMgr._sounds.exists(sHandle)) return;
	var dat = co.doubleduck.utils.SoundMgr._sounds.get(sHandle);
	co.doubleduck.utils.SoundMgr.stopSound(sHandle);
	co.doubleduck.utils.SoundMgr.forceNextHandle(sHandle);
	co.doubleduck.utils.SoundMgr.playSound(dat.sName,dat.isLoop,dat.pausePos,dat.isMusic,dat.forceType);
};
co.doubleduck.utils.SoundMgr.stopSound = function(handle,isMusic) {
	if(isMusic == null) isMusic = false;
	if(isMusic) {
		if(co.doubleduck.utils.SoundMgr.isChrome) {
			var audio = co.doubleduck.utils.SoundMgr.audios.get("musics/" + handle);
			audio.pause();
			audio.currentTime = 0;
			return;
		}
	}
	if(handle == null || handle.length == 0) return;
	if(co.doubleduck.utils.SoundMgr._sounds.exists(handle)) {
		var data = co.doubleduck.utils.SoundMgr._sounds.get(handle);
		var chan = data.sChannel;
		chan.stop();
		chan.removeEventListener(openfl.events.Event.SOUND_COMPLETE,co.doubleduck.utils.SoundMgr.handleSoundFinish);
		chan = null;
		co.doubleduck.utils.SoundMgr._sounds.remove(handle);
	}
};
co.doubleduck.utils.SoundMgr.setSoundVolume = function(handle,volume,isMusic) {
	if(isMusic == null) isMusic = false;
	if(isMusic) {
		if(co.doubleduck.utils.SoundMgr.isChrome) {
			var audio = co.doubleduck.utils.SoundMgr.audios.get("musics/" + handle);
			audio.volume = volume;
			return;
		}
	}
	if(handle == null || handle.length == 0) return;
	if(co.doubleduck.utils.SoundMgr._sounds.exists(handle)) {
		var data = co.doubleduck.utils.SoundMgr._sounds.get(handle);
		var chan = data.sChannel;
		var soundTransform = chan.get_soundTransform();
		soundTransform.volume = volume;
		chan.set_soundTransform(soundTransform);
	}
};
co.doubleduck.utils.SoundMgr.stopAll = function() {
	var iter = co.doubleduck.utils.SoundMgr._sounds.keys();
	while(iter.hasNext()) {
		var cKey = iter.next();
		co.doubleduck.utils.SoundMgr.stopSound(cKey);
	}
};
co.doubleduck.utils.SoundMgr.handleSoundFinish = function(e) {
	var chan = e.target;
	chan.removeEventListener(openfl.events.Event.SOUND_COMPLETE,co.doubleduck.utils.SoundMgr.handleSoundFinish);
	var $it0 = co.doubleduck.utils.SoundMgr._sounds.keys();
	while( $it0.hasNext() ) {
		var cKey = $it0.next();
		if(co.doubleduck.utils.SoundMgr._sounds.get(cKey).sChannel == chan) {
			co.doubleduck.utils.SoundMgr._sounds.remove(cKey);
			return;
		}
	}
};
co.doubleduck.utils.SoundMgr.forceNextHandle = function(handle) {
	co.doubleduck.utils.SoundMgr._forceHandle = handle;
};
co.doubleduck.utils.SoundMgr.newHandle = function() {
	if(co.doubleduck.utils.SoundMgr._forceHandle != "") {
		var retHandle = co.doubleduck.utils.SoundMgr._forceHandle;
		co.doubleduck.utils.SoundMgr._forceHandle = "";
		return retHandle;
	}
	co.doubleduck.utils.SoundMgr._idCounter++;
	return "snd" + (co.doubleduck.utils.SoundMgr._idCounter - 1);
};
co.doubleduck.utils.SoundMgr.fileType = function() {
	co.doubleduck.utils.SoundMgr._fileType = ".ogg";
	return co.doubleduck.utils.SoundMgr._fileType;
};
co.doubleduck.utils.TweenAnimator = function() { };
$hxClasses["co.doubleduck.utils.TweenAnimator"] = co.doubleduck.utils.TweenAnimator;
co.doubleduck.utils.TweenAnimator.__name__ = ["co","doubleduck","utils","TweenAnimator"];
co.doubleduck.utils.TweenAnimator.spin = function(obj,duration,amount) {
	if(amount == null) amount = 0;
	if(duration == null) duration = 1000;
	obj.set_rotation(0);
	if(amount > 0) {
		amount--;
		if(amount == 0) return;
	}
	co.doubleduck.utils.TweenChain.get(obj).tto({ rotation : 360},duration).call(co.doubleduck.utils.TweenAnimator.spin,[obj,duration,amount]);
};
co.doubleduck.utils.TweenAnimator.nudge = function(obj,duration,amount) {
	if(amount == null) amount = 0;
	if(duration == null) duration = 550;
	obj.set_scaleX(obj.set_scaleY(1));
	if(amount > 0) {
		amount--;
		if(amount == 0) return;
	}
	co.doubleduck.utils.TweenChain.get(obj).tto({ scaleX : 1.15, scaleY : 1.15},Math.floor(duration / 2),motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},Math.floor(duration / 2),motion.easing.Sine.get_easeInOut()).call(co.doubleduck.utils.TweenAnimator.nudge,[obj,duration,amount]);
};
co.doubleduck.utils.TweenAnimator.hover = function(obj,duration,amount) {
	if(amount == null) amount = 0;
	if(duration == null) duration = 1200;
	if(amount > 0) {
		amount--;
		if(amount == 0) return;
	}
	co.doubleduck.utils.TweenChain.get(obj).tto({ y : obj.get_y() - 5},Math.floor(duration / 4),motion.easing.Sine.get_easeOut()).tto({ y : obj.get_y() + 5},Math.floor(duration / 2),motion.easing.Sine.get_easeInOut()).tto({ y : obj.get_y()},Math.floor(duration / 4),motion.easing.Sine.get_easeIn()).call(co.doubleduck.utils.TweenAnimator.hover,[obj,duration,amount]);
};
co.doubleduck.utils.TweenAnimator.slowJiggle = function(obj,factor,duration,amount) {
	if(amount == null) amount = 0;
	if(duration == null) duration = 2400;
	if(factor == null) factor = 0.03;
	if(amount > 0) {
		amount--;
		if(amount == 0) return;
	}
	co.doubleduck.utils.TweenChain.get(obj).tto({ scaleX : 1 + factor, scaleY : 1 - factor},Math.floor(duration / 4),motion.easing.Sine.get_easeOut()).tto({ scaleX : 1 - factor, scaleY : 1 + factor},Math.floor(duration / 2),motion.easing.Sine.get_easeInOut()).tto({ scaleX : 1, scaleY : 1},Math.floor(duration / 4),motion.easing.Sine.get_easeIn()).call(co.doubleduck.utils.TweenAnimator.slowJiggle,[obj,duration,amount]);
};
co.doubleduck.utils.TweenAnimator.shake = function(obj,strength,speed,amount) {
	if(amount == null) amount = 0;
	if(speed == null) speed = 50;
	if(strength == null) strength = 10;
	if(amount > 0) {
		amount--;
		if(amount == 0) return;
	}
	co.doubleduck.utils.TweenChain.get(obj).tto({ x : obj.get_x() - strength / 2 + Math.random() * strength, y : obj.get_y() - strength / 2 + Math.random() * strength},speed,motion.easing.Sine.get_easeOut()).tto({ x : obj.get_x() - strength / 2 + Math.random() * strength, y : obj.get_y() - strength / 2 + Math.random() * strength},2 * speed,motion.easing.Sine.get_easeInOut()).tto({ x : obj.get_x(), y : obj.get_y()},speed,motion.easing.Sine.get_easeIn()).call(co.doubleduck.utils.TweenAnimator.shake,[obj,strength,speed,amount]);
};
co.doubleduck.utils.TweenChain = function(obj,overwrite,debug) {
	if(debug == null) debug = false;
	if(overwrite == null) overwrite = false;
	if(co.doubleduck.utils.TweenChain.allowNew) {
		this._chains = [];
		this._currIndex = 0;
		this._obj = obj;
		this._debug = debug;
		this._overwrite = overwrite;
		this._activated = false;
	} else throw "Wrong call to function new(), use TweenChain.get()";
};
$hxClasses["co.doubleduck.utils.TweenChain"] = co.doubleduck.utils.TweenChain;
co.doubleduck.utils.TweenChain.__name__ = ["co","doubleduck","utils","TweenChain"];
co.doubleduck.utils.TweenChain.get = function(obj,overwrite,debug) {
	if(debug == null) debug = false;
	if(overwrite == null) overwrite = false;
	co.doubleduck.utils.TweenChain.allowNew = true;
	var ret = new co.doubleduck.utils.TweenChain(obj,overwrite,debug);
	co.doubleduck.utils.TweenChain.activeChains.push(ret);
	ret._id = co.doubleduck.utils.TweenChain.count;
	co.doubleduck.utils.TweenChain.count++;
	co.doubleduck.utils.TweenChain.allowNew = false;
	return ret;
};
co.doubleduck.utils.TweenChain.removeTweens = function(obj) {
	var arr = [];
	var _g = 0;
	var _g1 = co.doubleduck.utils.TweenChain.activeChains;
	while(_g < _g1.length) {
		var i = _g1[_g];
		++_g;
		if(i._obj == obj) {
			if(i._runningTween != null) motion.Actuate.stop(obj,null,false,false);
			i._chains = [];
			arr.push(i);
		}
	}
	var _g2 = 0;
	while(_g2 < arr.length) {
		var i1 = arr[_g2];
		++_g2;
		HxOverrides.remove(co.doubleduck.utils.TweenChain.activeChains,i1);
	}
};
co.doubleduck.utils.TweenChain.getActiveChains = function(withoutNulls) {
	if(withoutNulls == null) withoutNulls = false;
	if(withoutNulls) {
		var arr = [];
		var _g = 0;
		var _g1 = co.doubleduck.utils.TweenChain.activeChains;
		while(_g < _g1.length) {
			var i = _g1[_g];
			++_g;
			if(i._obj != null) arr.push(i);
		}
		return arr;
	}
	return co.doubleduck.utils.TweenChain.activeChains;
};
co.doubleduck.utils.TweenChain.purge = function() {
	motion.Actuate.reset();
	co.doubleduck.utils.TweenChain.activeChains = null;
	co.doubleduck.utils.TweenChain.activeChains = [];
};
co.doubleduck.utils.TweenChain.prototype = {
	tto: function(props,duration,ease,onUpdate) {
		var chain = this.getNewChainHash();
		if(duration == 0) chain.set("type",co.doubleduck.utils.ChainTypes.APPLY); else {
			if(ease == null) ease = motion.easing.Linear.get_easeNone();
			chain.set("type",co.doubleduck.utils.ChainTypes.TWEEN);
			chain.set("duration",duration / 1000);
			chain.set("ease",ease);
			chain.set("onUpdate",onUpdate);
		}
		chain.set("props",props);
		this.addToQueue(chain);
		return this;
	}
	,wait: function(duration) {
		if(duration == null) duration = 10;
		if(duration == 0) return this;
		var chain = this.getNewChainHash();
		chain.set("duration",duration / 1000);
		chain.set("type",co.doubleduck.utils.ChainTypes.TIMER);
		this.addToQueue(chain);
		return this;
	}
	,call: function(handler,params) {
		var chain = this.getNewChainHash();
		if(params == null) params = [];
		chain.set("handler",handler);
		chain.set("params",params);
		chain.set("type",co.doubleduck.utils.ChainTypes.CALL);
		this.addToQueue(chain);
		return this;
	}
	,addToQueue: function(d) {
		this._chains.push(d);
		if(!this._activated) {
			if(d.get("duration") == 0) {
				if(d.get("type") == co.doubleduck.utils.ChainTypes.APPLY) motion.Actuate.apply(this._obj,d.get("props")); else if(d.get("type") == co.doubleduck.utils.ChainTypes.CALL) Reflect.callMethod(d.get("handler"),d.get("handler"),d.get("params"));
				this._currIndex++;
			} else {
				this._activated = true;
				this.act();
			}
		}
	}
	,act: function() {
		if(this._currIndex >= this._chains.length) {
			this.destroy();
			return;
		}
		var currChain = this._chains[this._currIndex];
		this._currIndex++;
		this._runningTween = null;
		this.debugTrace(this._currIndex + "/" + this._chains.length + " :: " + Std.string(currChain));
		if(currChain.get("type") == co.doubleduck.utils.ChainTypes.TWEEN) {
			if(currChain.get("onUpdate") == null) this._runningTween = motion.Actuate.tween(this._obj,currChain.get("duration"),currChain.get("props"),this._overwrite).ease(currChain.get("ease")).onComplete($bind(this,this.doneActuateTween)); else this._runningTween = motion.Actuate.tween(this._obj,currChain.get("duration"),currChain.get("props"),this._overwrite).ease(currChain.get("ease")).onUpdate(currChain.get("onUpdate"),[this._obj]).onComplete($bind(this,this.doneActuateTween));
			this._runningTween.autoVisible(co.doubleduck.utils.TweenChain.autoVisible);
		} else if(currChain.get("type") == co.doubleduck.utils.ChainTypes.APPLY) {
			motion.Actuate.apply(this._obj,currChain.get("props"));
			this.act();
		} else if(currChain.get("type") == co.doubleduck.utils.ChainTypes.TIMER) motion.Actuate.timer(currChain.get("duration")).onComplete($bind(this,this.act)); else if(currChain.get("type") == co.doubleduck.utils.ChainTypes.CALL) {
			Reflect.callMethod(currChain.get("handler"),currChain.get("handler"),currChain.get("params"));
			this.act();
		}
	}
	,doneActuateTween: function() {
		var currChain = this._chains[this._currIndex - 1];
		var _g = 0;
		var _g1 = Reflect.fields(currChain.get("props"));
		while(_g < _g1.length) {
			var prop = _g1[_g];
			++_g;
			var val = Reflect.getProperty(currChain.get("props"),prop);
			Reflect.setProperty(this._obj,prop,val);
		}
		this.act();
	}
	,destroy: function() {
		HxOverrides.remove(co.doubleduck.utils.TweenChain.activeChains,this);
		this._chains = null;
		if(this._obj == null) co.doubleduck.utils.TweenChain.removeTweens(this._obj);
	}
	,debugTrace: function(d) {
		if(this._debug) null;
	}
	,getNewChainHash: function() {
		var ret = new haxe.ds.StringMap();
		ret.set("type",null);
		ret.set("duration",0);
		return ret;
	}
	,__class__: co.doubleduck.utils.TweenChain
};
co.doubleduck.utils.ChainTypes = $hxClasses["co.doubleduck.utils.ChainTypes"] = { __ename__ : ["co","doubleduck","utils","ChainTypes"], __constructs__ : ["TWEEN","TIMER","CALL","APPLY"] };
co.doubleduck.utils.ChainTypes.TWEEN = ["TWEEN",0];
co.doubleduck.utils.ChainTypes.TWEEN.toString = $estr;
co.doubleduck.utils.ChainTypes.TWEEN.__enum__ = co.doubleduck.utils.ChainTypes;
co.doubleduck.utils.ChainTypes.TIMER = ["TIMER",1];
co.doubleduck.utils.ChainTypes.TIMER.toString = $estr;
co.doubleduck.utils.ChainTypes.TIMER.__enum__ = co.doubleduck.utils.ChainTypes;
co.doubleduck.utils.ChainTypes.CALL = ["CALL",2];
co.doubleduck.utils.ChainTypes.CALL.toString = $estr;
co.doubleduck.utils.ChainTypes.CALL.__enum__ = co.doubleduck.utils.ChainTypes;
co.doubleduck.utils.ChainTypes.APPLY = ["APPLY",3];
co.doubleduck.utils.ChainTypes.APPLY.toString = $estr;
co.doubleduck.utils.ChainTypes.APPLY.__enum__ = co.doubleduck.utils.ChainTypes;
co.doubleduck.utils.Utils = function() { };
$hxClasses["co.doubleduck.utils.Utils"] = co.doubleduck.utils.Utils;
co.doubleduck.utils.Utils.__name__ = ["co","doubleduck","utils","Utils"];
co.doubleduck.utils.Utils.delayedCall = function(delay,call,args,obj) {
	if(obj != null) co.doubleduck.utils.TweenChain.get(obj).wait(delay * 1000 | 0).call(call,args); else motion.Actuate.timer(delay).onComplete(call,args);
};
co.doubleduck.utils.Utils.rectOverlap = function(r1,r2) {
	if(r2.contains(r1.x,r1.y)) return true;
	if(r2.contains(r1.x + r1.width,r1.y + r1.height)) return true;
	if(r2.contains(r1.x + r1.width,r1.y)) return true;
	if(r2.contains(r1.x,r1.y + r1.height)) return true;
	if(r1.contains(r2.x,r2.y)) return true;
	if(r1.contains(r2.x + r2.width,r2.y + r2.height)) return true;
	if(r1.contains(r2.x + r2.width,r2.y)) return true;
	if(r1.contains(r2.x,r2.y + r2.height)) return true;
	return false;
};
co.doubleduck.utils.Utils.map = function(value,aMin,aMax,bMin,bMax) {
	if(bMax == null) bMax = 1;
	if(bMin == null) bMin = 0;
	if(value <= aMin) return bMin;
	if(value >= aMax) return bMax;
	return (value - aMin) * (bMax - bMin) / (aMax - aMin) + bMin;
};
co.doubleduck.utils.Utils.nrand = function() {
	return (Math.random() + Math.random()) / 2;
};
co.doubleduck.utils.Utils.getDeviceType = function() {
	return co.doubleduck.utils.DeviceType.HTML5;
	return null;
};
co.doubleduck.utils.Utils.shuffleArray = function(arr) {
	var tmp;
	var j;
	var i = arr.length;
	while(i > 0) {
		j = Std["int"](Math.random() * i);
		tmp = arr[--i];
		arr[i] = arr[j];
		arr[j] = tmp;
	}
};
co.doubleduck.utils.Utils.sign = function(n) {
	if(n < 0) return -1;
	return 1;
};
co.doubleduck.utils.DeviceType = $hxClasses["co.doubleduck.utils.DeviceType"] = { __ename__ : ["co","doubleduck","utils","DeviceType"], __constructs__ : ["iPhone3","iPhone4","iPhone5","iPad","iPadRetina","Android","DesktopFlash","DesktopNative","HTML5"] };
co.doubleduck.utils.DeviceType.iPhone3 = ["iPhone3",0];
co.doubleduck.utils.DeviceType.iPhone3.toString = $estr;
co.doubleduck.utils.DeviceType.iPhone3.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.iPhone4 = ["iPhone4",1];
co.doubleduck.utils.DeviceType.iPhone4.toString = $estr;
co.doubleduck.utils.DeviceType.iPhone4.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.iPhone5 = ["iPhone5",2];
co.doubleduck.utils.DeviceType.iPhone5.toString = $estr;
co.doubleduck.utils.DeviceType.iPhone5.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.iPad = ["iPad",3];
co.doubleduck.utils.DeviceType.iPad.toString = $estr;
co.doubleduck.utils.DeviceType.iPad.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.iPadRetina = ["iPadRetina",4];
co.doubleduck.utils.DeviceType.iPadRetina.toString = $estr;
co.doubleduck.utils.DeviceType.iPadRetina.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.Android = ["Android",5];
co.doubleduck.utils.DeviceType.Android.toString = $estr;
co.doubleduck.utils.DeviceType.Android.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.DesktopFlash = ["DesktopFlash",6];
co.doubleduck.utils.DeviceType.DesktopFlash.toString = $estr;
co.doubleduck.utils.DeviceType.DesktopFlash.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.DesktopNative = ["DesktopNative",7];
co.doubleduck.utils.DeviceType.DesktopNative.toString = $estr;
co.doubleduck.utils.DeviceType.DesktopNative.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.DeviceType.HTML5 = ["HTML5",8];
co.doubleduck.utils.DeviceType.HTML5.toString = $estr;
co.doubleduck.utils.DeviceType.HTML5.__enum__ = co.doubleduck.utils.DeviceType;
co.doubleduck.utils.data = {};
co.doubleduck.utils.data.StorageAdapter = function() { };
$hxClasses["co.doubleduck.utils.data.StorageAdapter"] = co.doubleduck.utils.data.StorageAdapter;
co.doubleduck.utils.data.StorageAdapter.__name__ = ["co","doubleduck","utils","data","StorageAdapter"];
co.doubleduck.utils.data.StorageAdapter.get = function(domain,type) {
	if(type == co.doubleduck.utils.data.StorageAdapterType.LOCAL_STORAGE) return new co.doubleduck.utils.data.LocalStorageAdapter(domain); else if(type == co.doubleduck.utils.data.StorageAdapterType.SHARED_OBJECT) return new co.doubleduck.utils.data.SharedObjectAdapter(domain);
	return null;
};
co.doubleduck.utils.data.StorageAdapter.prototype = {
	getValue: function(key) {
		throw "DDException: function not implemented!";
		return null;
	}
	,setValue: function(key,value) {
		throw "DDException: function not implemented!";
		return null;
	}
	,removeValue: function(key) {
		throw "DDException: function not implemented!";
		return null;
	}
	,rawData: function() {
		throw "DDException: function not implemented!";
		return null;
	}
	,clear: function() {
		throw "DDException: function not implemented!";
		return null;
	}
	,getString: function(key) {
		var result = this.getValue(key[0]);
		return result;
	}
	,setString: function(key,value) {
		this.setValue(key[0],value);
	}
	,initString: function(key,defaultValue) {
		if(defaultValue == null) defaultValue = "";
		if(this.getString(key) == null) this.setString(key,defaultValue);
	}
	,getFloat: function(key) {
		var result = this.getValue(key[0]);
		return result;
	}
	,setFloat: function(key,value) {
		this.setValue(key[0],value);
	}
	,initFloat: function(key,defaultValue) {
		if(defaultValue == null) defaultValue = 0;
		if(this.getString(key) == null) this.setFloat(key,defaultValue);
	}
	,getInt: function(key) {
		var result = Std["int"](this.getValue(key[0]));
		return result;
	}
	,setInt: function(key,value) {
		this.setValue(key[0],value);
	}
	,initInt: function(key,defaultValue) {
		if(defaultValue == null) defaultValue = 0;
		if(this.getString(key) == null) this.setInt(key,defaultValue);
	}
	,__class__: co.doubleduck.utils.data.StorageAdapter
};
co.doubleduck.utils.data.LocalStorageAdapter = function(domain) {
	this._domain = domain;
	this._ls = this.getLocalStorage();
};
$hxClasses["co.doubleduck.utils.data.LocalStorageAdapter"] = co.doubleduck.utils.data.LocalStorageAdapter;
co.doubleduck.utils.data.LocalStorageAdapter.__name__ = ["co","doubleduck","utils","data","LocalStorageAdapter"];
co.doubleduck.utils.data.LocalStorageAdapter.__super__ = co.doubleduck.utils.data.StorageAdapter;
co.doubleduck.utils.data.LocalStorageAdapter.prototype = $extend(co.doubleduck.utils.data.StorageAdapter.prototype,{
	getValue: function(key) {
		var result = this._ls.getItem(this._domain + key);
		if(result == null) return null;
		return JSON.parse(result);
	}
	,setValue: function(key,value) {
		this._ls.setItem(this._domain + key,JSON.stringify(value));
	}
	,removeValue: function(key) {
		this._ls.removeItem(this._domain + key);
	}
	,clear: function() {
		this._ls.clear();
	}
	,rawData: function() {
		return this._ls;
	}
	,getLocalStorage: function() {
		var ls = js.Browser.getLocalStorage();
		if(ls != null) try {
			ls.setItem("ddstoragetest","1");
			ls.getItem("ddstoragetest");
			ls.removeItem("ddstoragetest");
			return ls;
		} catch( e ) {
		}
		return new co.doubleduck.utils.data.DummyLocalStorage();
	}
	,__class__: co.doubleduck.utils.data.LocalStorageAdapter
});
co.doubleduck.utils.data.DummyLocalStorage = function() {
	this.data = { };
};
$hxClasses["co.doubleduck.utils.data.DummyLocalStorage"] = co.doubleduck.utils.data.DummyLocalStorage;
co.doubleduck.utils.data.DummyLocalStorage.__name__ = ["co","doubleduck","utils","data","DummyLocalStorage"];
co.doubleduck.utils.data.DummyLocalStorage.prototype = {
	setItem: function(key,value) {
		Reflect.setProperty(this.data,key,value);
	}
	,getItem: function(key) {
		return Reflect.getProperty(this.data,key);
	}
	,removeItem: function(key) {
		Reflect.deleteField(this.data,key);
	}
	,clear: function() {
		this.data = { };
	}
	,__class__: co.doubleduck.utils.data.DummyLocalStorage
};
co.doubleduck.utils.data.SharedObjectAdapter = function(domain) {
	this._domain = domain;
	var localPath = "";
	this._data = openfl.net.SharedObject.getLocal(domain + "savedata",localPath);
};
$hxClasses["co.doubleduck.utils.data.SharedObjectAdapter"] = co.doubleduck.utils.data.SharedObjectAdapter;
co.doubleduck.utils.data.SharedObjectAdapter.__name__ = ["co","doubleduck","utils","data","SharedObjectAdapter"];
co.doubleduck.utils.data.SharedObjectAdapter.__super__ = co.doubleduck.utils.data.StorageAdapter;
co.doubleduck.utils.data.SharedObjectAdapter.prototype = $extend(co.doubleduck.utils.data.StorageAdapter.prototype,{
	getValue: function(key) {
		return Reflect.getProperty(this._data.data,key);
	}
	,setValue: function(key,value) {
		this._data.data[key] = value;
		this._data.flush();
	}
	,removeValue: function(key) {
		Reflect.deleteField(this._data.data,key);
		this._data.flush();
	}
	,clear: function() {
		this._data.clear();
		this._data.flush();
	}
	,rawData: function() {
		return this._data;
	}
	,__class__: co.doubleduck.utils.data.SharedObjectAdapter
});
co.doubleduck.utils.data.StorageAdapterType = $hxClasses["co.doubleduck.utils.data.StorageAdapterType"] = { __ename__ : ["co","doubleduck","utils","data","StorageAdapterType"], __constructs__ : ["LOCAL_STORAGE","SHARED_OBJECT"] };
co.doubleduck.utils.data.StorageAdapterType.LOCAL_STORAGE = ["LOCAL_STORAGE",0];
co.doubleduck.utils.data.StorageAdapterType.LOCAL_STORAGE.toString = $estr;
co.doubleduck.utils.data.StorageAdapterType.LOCAL_STORAGE.__enum__ = co.doubleduck.utils.data.StorageAdapterType;
co.doubleduck.utils.data.StorageAdapterType.SHARED_OBJECT = ["SHARED_OBJECT",1];
co.doubleduck.utils.data.StorageAdapterType.SHARED_OBJECT.toString = $estr;
co.doubleduck.utils.data.StorageAdapterType.SHARED_OBJECT.__enum__ = co.doubleduck.utils.data.StorageAdapterType;
var com = {};
com.funtomic = {};
com.funtomic.GameOpsStatus = $hxClasses["com.funtomic.GameOpsStatus"] = { __ename__ : ["com","funtomic","GameOpsStatus"], __constructs__ : ["UNINITIALIZED","INITIALIZING","INITIALIZED","QUITTING"] };
com.funtomic.GameOpsStatus.UNINITIALIZED = ["UNINITIALIZED",0];
com.funtomic.GameOpsStatus.UNINITIALIZED.toString = $estr;
com.funtomic.GameOpsStatus.UNINITIALIZED.__enum__ = com.funtomic.GameOpsStatus;
com.funtomic.GameOpsStatus.INITIALIZING = ["INITIALIZING",1];
com.funtomic.GameOpsStatus.INITIALIZING.toString = $estr;
com.funtomic.GameOpsStatus.INITIALIZING.__enum__ = com.funtomic.GameOpsStatus;
com.funtomic.GameOpsStatus.INITIALIZED = ["INITIALIZED",2];
com.funtomic.GameOpsStatus.INITIALIZED.toString = $estr;
com.funtomic.GameOpsStatus.INITIALIZED.__enum__ = com.funtomic.GameOpsStatus;
com.funtomic.GameOpsStatus.QUITTING = ["QUITTING",3];
com.funtomic.GameOpsStatus.QUITTING.toString = $estr;
com.funtomic.GameOpsStatus.QUITTING.__enum__ = com.funtomic.GameOpsStatus;
com.funtomic.GameOps = function() { };
$hxClasses["com.funtomic.GameOps"] = com.funtomic.GameOps;
com.funtomic.GameOps.__name__ = ["com","funtomic","GameOps"];
com.funtomic.GameOps.gameVersion = null;
com.funtomic.GameOps.domain = null;
com.funtomic.GameOps.userID = null;
com.funtomic.GameOps.fbId = null;
com.funtomic.GameOps.experimentId = null;
com.funtomic.GameOps.alternativeId = null;
com.funtomic.GameOps.FBAppId = null;
com.funtomic.GameOps.platform = null;
com.funtomic.GameOps.url = null;
com.funtomic.GameOps.lastLevelNumber = null;
com.funtomic.GameOps.gameConfig = null;
com.funtomic.GameOps.elapsedPlayTimeAtInit = null;
com.funtomic.GameOps.elapsedGameTime = null;
com.funtomic.GameOps.levelsWon = null;
com.funtomic.GameOps.sessionId = null;
com.funtomic.GameOps.init = function(pDomain,pGameVersion,pDefaultConfig,pGameState,callback) {
	if(com.funtomic.GameOps.status != com.funtomic.GameOpsStatus.UNINITIALIZED) return;
	com.funtomic.GameOps.status = com.funtomic.GameOpsStatus.INITIALIZING;
	com.funtomic.GameOps.domain = pDomain;
	com.funtomic.GameOps.gameVersion = pGameVersion;
	com.funtomic.GameOps.readLocalStorage();
	com.funtomic.GameOps.readGameStateLocalStorage();
	com.funtomic.GameOps.startUpdateTimers();
	com.funtomic.GameOps.url = window.location.href;
	com.funtomic.GameOps.startTimer("session");
	com.funtomic.GameOps.platform = "web";
	com.funtomic.GameOps.sessionId = com.funtomic.GameOps.generateRandomString(20);
	if(com.funtomic.GameOps.localStorage.installDate == null) {
		com.funtomic.GameOps.localStorage.installDate = Math.round(new Date().getTime() / 1000);
		com.funtomic.GameOps.firstSession = true;
		com.funtomic.GameOps.reportEvent("first_run");
	}
	com.funtomic.GameOps.elapsedGameTime = com.funtomic.GameOps.storageGet("FuntomicGameOps-ElapsedGameTime",0);
	if(com.funtomic.GameOps.localStorage.elapsedGameTime != null) {
		com.funtomic.GameOps.elapsedGameTime = com.funtomic.GameOps.localStorage.elapsedGameTime;
		Reflect.deleteField(com.funtomic.GameOps.localStorage,"elapsedGameTime");
	}
	if(com.funtomic.GameOps.localStorage.originalVersion == null) com.funtomic.GameOps.localStorage.originalVersion = com.funtomic.GameOps.gameVersion;
	com.funtomic.GameOps.elapsedPlayTimeAtInit = com.funtomic.GameOps.elapsedGameTime;
	com.funtomic.GameOps.userID = com.funtomic.GameOps.localStorage.userID;
	try {
		var html5ApiUserId = flambe.System.external.call("HTML5API_getUserId");
		if(html5ApiUserId != null) {
			com.funtomic.GameOpsLogger.verbose(["html5ApiUserId is: " + html5ApiUserId]);
			com.funtomic.GameOps.userID = html5ApiUserId;
		}
	} catch( e ) {
		com.funtomic.GameOpsLogger.verbose(["there is no HTML5API_getUserId function"]);
	}
	com.funtomic.GameOps.levelsWon = 0;
	if(com.funtomic.GameOps.localStorage.config == null || com.funtomic.GameOps.localStorage.configForVersion != null && com.funtomic.GameOps.localStorage.configForVersion != com.funtomic.GameOps.gameVersion) com.funtomic.GameOps.localStorage.config = pDefaultConfig;
	com.funtomic.GameOps.gameConfig = com.funtomic.GameOps.localStorage.config;
	if(com.funtomic.GameOps.localStorage.experimentId != null) com.funtomic.GameOps.experimentId = com.funtomic.GameOps.localStorage.experimentId;
	if(com.funtomic.GameOps.localStorage.alternativeId != null) com.funtomic.GameOps.alternativeId = com.funtomic.GameOps.localStorage.alternativeId;
	var lastSessionEndEvent = com.funtomic.GameOps.storageGet("FuntomicGameOps-SessionEndEvent",null);
	if(lastSessionEndEvent != null) {
		com.funtomic.GameOps.reportEvents([lastSessionEndEvent]);
		com.funtomic.GameOps.storageRemove("FuntomicGameOps-SessionEndEvent");
	}
	var sessionEndTimer = new haxe.Timer(5000);
	sessionEndTimer.run = function() {
		com.funtomic.GameOps.sessionEnd();
	};
	window.addEventListener("pagehide",function(e1) {
		com.funtomic.GameOps.sessionEnd();
	});
	window.addEventListener("beforeunload",function(e2) {
		com.funtomic.GameOps.sessionEnd();
	});
	com.funtomic.GameOps.reportEvent("session_start");
	com.funtomic.GameOps.gameStateGameOpsData.elapsed_game_time = com.funtomic.GameOps.elapsedGameTime;
	com.funtomic.GameOps.gameStateGameOpsData.install_date = com.funtomic.GameOps.localStorage.installDate;
	com.funtomic.GameOps.writeLocalStorage();
	com.funtomic.GameOps.writeGameStateLocalStorage();
	pGameState.game_ops_data = com.funtomic.GameOps.gameStateGameOpsData;
	com.funtomic.GameOps.loadGameConfig(pGameState,callback);
};
com.funtomic.GameOps.loadGameConfig = function(gameState,callback) {
	com.funtomic.GameOpsLogger.verbose(["Fetching game config for: ",com.funtomic.GameOps.domain]);
	var request = new haxe.Http(null);
	//request.url = com.funtomic.GameOps.apiURLPrefix + com.funtomic.GameOps.apiConfigLocation;
	request.setParameter("domain",com.funtomic.GameOps.domain);
	request.setParameter("game_state",JSON.stringify(gameState));
	request.setParameter("game_ops_version",com.funtomic.GameOps.gameOpsVersion);
	request.setParameter("game_version",com.funtomic.GameOps.gameVersion);
	request.setParameter("platform_name",com.funtomic.GameOps.platform);
	if(com.funtomic.GameOps.userID != null) request.setParameter("user_id",com.funtomic.GameOps.userID);
	if(com.funtomic.GameOps.experimentId != null) request.setParameter("experiment_id",com.funtomic.GameOps.experimentId);
	if(com.funtomic.GameOps.alternativeId != null) request.setParameter("alternative_id",com.funtomic.GameOps.alternativeId);
	if(com.funtomic.GameOps.localStorage.userEmail != null) request.setParameter("user_email",com.funtomic.GameOps.localStorage.userEmail);
	if(com.funtomic.GameOps.localStorage.configMd5 != null) request.setParameter("config_md5",com.funtomic.GameOps.localStorage.configMd5);
	request.onData = function(data) {
		com.funtomic.GameOps.onConfigLoadSuccess(data);
		if(callback != null) callback(true);
		com.funtomic.GameOps.afterInit();
	};
	request.onStatus = com.funtomic.GameOps.onConfigLoadReturned;
	request.onError = function(msg) {
		com.funtomic.GameOps.IOErrorHandler(msg);
		com.funtomic.GameOps.status = com.funtomic.GameOpsStatus.UNINITIALIZED;
		if(callback != null) callback(false);
		com.funtomic.GameOps.afterInit();
	};
	request.request(true);
};
com.funtomic.GameOps.onConfigLoadReturned = function(status) {
	switch(status) {
	case 500:
		com.funtomic.GameOps.onConfigLoadFailure();
		break;
	case 0:
		com.funtomic.GameOps.onConfigLoadTimeout();
		break;
	}
};
com.funtomic.GameOps.onConfigLoadTimeout = function() {
	com.funtomic.GameOpsLogger.error(["Timeout while fetching game config from server"]);
};
com.funtomic.GameOps.onConfigLoadFailure = function() {
	com.funtomic.GameOpsLogger.error(["Error loading config"]);
};
com.funtomic.GameOps.IOErrorHandler = function(msg) {
	com.funtomic.GameOpsLogger.error(["Error caught ",msg]);
};
com.funtomic.GameOps.onConfigLoadSuccess = function(resultString) {
	var result = JSON.parse(resultString);
	com.funtomic.GameOpsLogger.verbose(["Config successfuly loaded",resultString]);
	if(result != null) {
		if(result.user_id != null) {
			com.funtomic.GameOps.userID = result.user_id;
			com.funtomic.GameOps.localStorage.userID = result.user_id;
		}
		if(result.is_debug_mode) com.funtomic.GameOps.isDebugMode = result.is_debug_mode;
		if(result.install_date) com.funtomic.GameOps.localStorage.installDate = result.install_date;
		com.funtomic.GameOps.experimentId = result.experiment_id;
		com.funtomic.GameOps.localStorage.experimentId = com.funtomic.GameOps.experimentId;
		com.funtomic.GameOps.alternativeId = result.alternative_id;
		com.funtomic.GameOps.localStorage.alternativeId = com.funtomic.GameOps.alternativeId;
		if(result.config != null) com.funtomic.GameOps.localStorage.config = result.config;
		com.funtomic.GameOps.gameConfig = com.funtomic.GameOps.localStorage.config;
		com.funtomic.GameOps.localStorage.configMd5 = result.config_md5;
		com.funtomic.GameOps.localStorage.configForVersion = com.funtomic.GameOps.gameVersion;
		com.funtomic.GameOps.localStorage.googlePublicKey = result.google_public_key;
		com.funtomic.GameOps.localStorage.appstoreId = result.appstore_id;
		com.funtomic.GameOps.writeLocalStorage();
		com.funtomic.GameOps.status = com.funtomic.GameOpsStatus.INITIALIZED;
		com.funtomic.GameOps.reportUnsentEvents();
	}
};
com.funtomic.GameOps.afterInit = function() {
	com.funtomic.GameOpsLogger.debug(["Executing " + com.funtomic.GameOps.deferredReportEvents.length + " deferred event report calls"]);
	var _g = 0;
	var _g1 = com.funtomic.GameOps.deferredReportEvents;
	while(_g < _g1.length) {
		var repotEventFunc = _g1[_g];
		++_g;
		repotEventFunc();
	}
	com.funtomic.GameOps.deferredReportEvents = new Array();
};
com.funtomic.GameOps.getConfig = function() {
	return com.funtomic.GameOps.gameConfig;
};
com.funtomic.GameOps.getEventsStaticParams = function(events) {
	return { domain : com.funtomic.GameOps.domain, uuid : com.funtomic.GameOps.userID, platform : com.funtomic.GameOps.platform, install_date : com.funtomic.GameOps.localStorage.installDate, original_version : com.funtomic.GameOps.localStorage.originalVersion, partial_data : com.funtomic.GameOps.localStorage.partialData, events : events};
};
com.funtomic.GameOps.reportEvents = function(events) {
	if(com.funtomic.GameOps.status != com.funtomic.GameOpsStatus.INITIALIZED) {
		com.funtomic.GameOps.queueEvents(events);
		return;
	}
	var data = com.funtomic.GameOps.getEventsStaticParams(events);
	var url = com.funtomic.GameOps.apiURLPrefix + com.funtomic.GameOps.apiEventsLocation;
	var request = new haxe.Http(url);
	request.addParameter("data",JSON.stringify(data));
	com.funtomic.GameOpsLogger.verbose(["Posting event to:",url]);
	request.onData = com.funtomic.GameOps.eventReportSucceeded;
	request.onStatus = function(status) {
		com.funtomic.GameOps.onEventReportReturned(status,events);
	};
	request.onError = com.funtomic.GameOps.IOErrorHandler;
	request.request(true);
	com.funtomic.GameOps.sessionEnd();
};
com.funtomic.GameOps.onEventReportReturned = function(status,events) {
	switch(status) {
	case 500:
		com.funtomic.GameOps.eventReportFailed();
		break;
	case 0:
		com.funtomic.GameOps.eventReportTimeout(events);
		break;
	}
};
com.funtomic.GameOps.eventReportTimeout = function(events) {
	com.funtomic.GameOpsLogger.error(["Report event timeout"]);
	com.funtomic.GameOps.queueEvents(events);
};
com.funtomic.GameOps.eventReportFailed = function() {
	com.funtomic.GameOpsLogger.error(["Report event failed"]);
	com.funtomic.GameOps.localStorage.unsentEvents = new Array();
	com.funtomic.GameOps.writeLocalStorage();
};
com.funtomic.GameOps.eventReportSucceeded = function(data) {
	com.funtomic.GameOpsLogger.verbose(["Event Posted " + data]);
	com.funtomic.GameOps.reportUnsentEvents();
};
com.funtomic.GameOps.reportEvent = function(eventType,params) {
	var _g = com.funtomic.GameOps.status;
	switch(_g[1]) {
	case 1:
		com.funtomic.GameOps.deferredReportEvents.push(function() {
			com.funtomic.GameOps.reportEvent(eventType,params);
		});
		break;
	default:
		var event = com.funtomic.GameOps.prepareEventObject(eventType,params);
		com.funtomic.GameOps.reportEvents([event]);
	}
};
com.funtomic.GameOps.prepareEventObject = function(eventType,params) {
	var date = DateTools.format(new Date(),"%Y-%m-%d %H:%M:%S");
	var tmpDate = Std.string(new Date());
	var timezone;
	var pos = tmpDate.indexOf("+");
	timezone = HxOverrides.substr(tmpDate,pos,5);
	date += timezone;
	var event = { event_type : eventType, date : date};
	if(com.funtomic.GameOps.experimentId != null) event.experiment_id = com.funtomic.GameOps.experimentId;
	if(com.funtomic.GameOps.alternativeId != null) event.alternative_id = com.funtomic.GameOps.alternativeId;
	event.elapsed_play_time = Math.round(com.funtomic.GameOps.elapsedPlayTimeAtInit + com.funtomic.GameOps.sampleTimer("session") / 1000);
	event.session_id = com.funtomic.GameOps.sessionId;
	event.game_ops_version = com.funtomic.GameOps.gameOpsVersion;
	event.game_version = com.funtomic.GameOps.gameVersion;
	if(com.funtomic.GameOps.url != null) event.url = com.funtomic.GameOps.url;
	if(com.funtomic.GameOps.firstSession) event.first_session = true;
	if(com.funtomic.GameOps.fbId != null) event.fb_id = com.funtomic.GameOps.fbId;
	event = com.funtomic.GameOps.extendObject(event,params);
	return event;
};
com.funtomic.GameOps.queueEvents = function(events) {
	com.funtomic.GameOpsLogger.verbose(["Queuing events:" + JSON.stringify(events)]);
	if(com.funtomic.GameOps.localStorage.unsentEvents == null) com.funtomic.GameOps.localStorage.unsentEvents = new Array();
	var _g = 0;
	while(_g < events.length) {
		var event = events[_g];
		++_g;
		com.funtomic.GameOps.localStorage.unsentEvents.push(event);
	}
	if(com.funtomic.GameOps.localStorage.unsentEvents.length > com.funtomic.GameOps.MAX_SAVED_UNSENT_EVENTS) {
		com.funtomic.GameOps.localStorage.unsentEvents = new Array();
		com.funtomic.GameOps.localStorage.partialData = true;
	}
	com.funtomic.GameOps.writeLocalStorage();
	com.funtomic.GameOpsLogger.verbose(["There are now " + Std.string(com.funtomic.GameOps.localStorage.unsentEvents.length) + " unsent events."]);
};
com.funtomic.GameOps.reportUnsentEvents = function() {
	if(com.funtomic.GameOps.localStorage.unsentEvents != null && com.funtomic.GameOps.localStorage.unsentEvents.length > 0) {
		com.funtomic.GameOpsLogger.verbose(["reporting unsent events",com.funtomic.GameOps.localStorage.unsentEvents.length]);
		com.funtomic.GameOps.reportEvents(com.funtomic.GameOps.localStorage.unsentEvents);
		com.funtomic.GameOps.localStorage.unsentEvents = new Array();
		com.funtomic.GameOps.writeLocalStorage();
	}
};
com.funtomic.GameOps.levelStarted = function(levelNumber,extraParams,sceneEntityForFps) {
	com.funtomic.GameOps.startTimer("level_" + levelNumber);
	if(sceneEntityForFps != null) com.funtomic.GameOpsFpsDetector.start(sceneEntityForFps);
	com.funtomic.GameOps.levelsNumbers.push(levelNumber);
	if(com.funtomic.GameOps.gameStateGameOpsData.progress == null) com.funtomic.GameOps.gameStateGameOpsData.progress = { };
	if(com.funtomic.GameOps.gameStateGameOpsData.progress.top_level == null || com.funtomic.GameOps.gameStateGameOpsData.progress.top_level < levelNumber) {
		com.funtomic.GameOps.gameStateGameOpsData.progress.top_level = levelNumber;
		com.funtomic.GameOps.writeGameStateLocalStorage();
	}
	var data = { level : levelNumber};
	if(extraParams != null) data = com.funtomic.GameOps.extendObject(extraParams,data);
	com.funtomic.GameOps.reportEvent("level_started",data);
};
com.funtomic.GameOps.levelEnded = function(levelNumber,won,extraParams) {
	var levelDuration = com.funtomic.GameOps.stopTimer("level_" + levelNumber);
	if(levelDuration == -1) {
		com.funtomic.GameOpsLogger.error(["levelEnded was called without a matching startLevel!"]);
		return;
	}
	if(won) com.funtomic.GameOps.levelsWon++;
	var data = { level : levelNumber, level_duration : Math.round(levelDuration / 1000), won : won == null?"null":"" + won};
	var averageFps = com.funtomic.GameOpsFpsDetector.stop();
	if(averageFps != -1) data.average_fps = averageFps;
	if(com.funtomic.GameOps.movesDuration.length > 0) {
		data.moves_duration = com.funtomic.GameOps.movesDuration.join(",");
		com.funtomic.GameOps.movesDuration = new Array();
	}
	if(extraParams != null) data = com.funtomic.GameOps.extendObject(extraParams,data);
	com.funtomic.GameOps.reportEvent("level_ended",data);
	if(won && levelNumber == com.funtomic.GameOps.lastLevelNumber) com.funtomic.GameOps.reportEvent("game_completion");
};
com.funtomic.GameOps.sessionEnd = function(sendInNextPlay,extraParams) {
	if(sendInNextPlay == null) sendInNextPlay = true;
	var sessionDuration = com.funtomic.GameOps.sampleTimer("session");
	if(sessionDuration == -1) {
		com.funtomic.GameOpsLogger.error(["sessionEnd was called without a matching sessionStart!"]);
		return;
	}
	var lnu = new Array();
	var _g = 0;
	var _g1 = com.funtomic.GameOps.levelsNumbers;
	while(_g < _g1.length) {
		var lvlNum = _g1[_g];
		++_g;
		if(HxOverrides.indexOf(lnu,lvlNum,0) == -1) lnu.push(lvlNum);
	}
	var data = { session_duration : Math.round(sessionDuration / 1000), levels_numbers : lnu.toString(), won_percent : 0, levels_count : com.funtomic.GameOps.levelsNumbers.length, levels_won : com.funtomic.GameOps.levelsWon, sent_by : "application"};
	if(extraParams != null) data = com.funtomic.GameOps.extendObject(extraParams,data);
	if(data.levels_count > 0) data.won_percent = com.funtomic.GameOps.levelsWon / com.funtomic.GameOps.levelsNumbers.length * 100;
	com.funtomic.GameOps.updateTotalElapsedTime(sessionDuration / 1000);
	var event = com.funtomic.GameOps.prepareEventObject("session_end",data);
	if(sendInNextPlay) {
		com.funtomic.GameOpsLogger.verbose(["writing session end event to local storage"]);
		com.funtomic.GameOps.storageSet("FuntomicGameOps-SessionEndEvent",event);
	} else com.funtomic.GameOps.reportEvents([event]);
};
com.funtomic.GameOps.setLastLevelNumber = function(pLastLevelNumber) {
	com.funtomic.GameOps.lastLevelNumber = pLastLevelNumber;
};
com.funtomic.GameOps.updateTotalElapsedTime = function(sessionDuration) {
	com.funtomic.GameOps.storageSet("FuntomicGameOps-ElapsedGameTime",com.funtomic.GameOps.elapsedPlayTimeAtInit + sessionDuration);
};
com.funtomic.GameOps.startTimer = function(key) {
	com.funtomic.GameOpsLogger.verbose(["Timer '" + key + "' started."]);
	Reflect.setField(com.funtomic.GameOps.timers,key,[com.funtomic.GameOps.getTimestamp(),0.0]);
};
com.funtomic.GameOps.sampleTimer = function(key,remove) {
	if(remove == null) remove = false;
	if(Reflect.field(com.funtomic.GameOps.timers,key) == null) return -1;
	var elapsed = Reflect.field(com.funtomic.GameOps.timers,key)[1];
	if(remove) Reflect.deleteField(com.funtomic.GameOps.timers,key);
	com.funtomic.GameOpsLogger.verbose(["Timer '" + key + "' sampled. Current elapsed time is " + elapsed]);
	return elapsed;
};
com.funtomic.GameOps.stopTimer = function(key) {
	com.funtomic.GameOpsLogger.verbose(["Timer '" + key + "' stopped"]);
	return com.funtomic.GameOps.sampleTimer(key,true);
};
com.funtomic.GameOps.startUpdateTimers = function() {
	if(com.funtomic.GameOps.setFlag("UpdateTimers")) {
		var updateTimers = new haxe.Timer(5000);
		updateTimers.run = function() {
			var _g = 0;
			var _g1 = Reflect.fields(com.funtomic.GameOps.timers);
			while(_g < _g1.length) {
				var key = _g1[_g];
				++_g;
				var toAdd = com.funtomic.GameOps.getTimestamp() - Reflect.field(com.funtomic.GameOps.timers,key)[0];
				if(toAdd > 5000) toAdd = 5000;
				Reflect.field(com.funtomic.GameOps.timers,key)[1] += toAdd;
			}
		};
	}
};
com.funtomic.GameOps.getTimestamp = function() {
	return new Date().getTime();
};
com.funtomic.GameOps.extendObject = function(obj1,obj2) {
	var _g = 0;
	var _g1 = Reflect.fields(obj2);
	while(_g < _g1.length) {
		var k = _g1[_g];
		++_g;
		var value = Reflect.field(obj2,k);
		var key;
		if(k == null) key = "null"; else key = "" + k;
		obj1[key] = value;
	}
	return obj1;
};
com.funtomic.GameOps.generateRandomString = function(strlen) {
	var chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	var num_chars = chars.length - 1;
	var randomChar = "";
	var _g = 0;
	while(_g < strlen) {
		var i = _g++;
		randomChar += chars.charAt(Math.floor(Math.random() * num_chars));
	}
	return randomChar;
};
com.funtomic.GameOps.storageSet = function(key,value) {
	return flambe.System.storage.set(com.funtomic.GameOps.domain + key,value);
};
com.funtomic.GameOps.storageGet = function(key,defaultValue) {
	return flambe.System.storage.get(com.funtomic.GameOps.domain + key,defaultValue);
};
com.funtomic.GameOps.storageRemove = function(key) {
	return flambe.System.storage.remove(com.funtomic.GameOps.domain + key);
};
com.funtomic.GameOps.writeLocalStorage = function() {
	com.funtomic.GameOps.storageSet("FuntomicGameOps",com.funtomic.GameOps.localStorage);
};
com.funtomic.GameOps.writeGameStateLocalStorage = function() {
	com.funtomic.GameOps.storageSet("FuntomicGameOps-GameState",com.funtomic.GameOps.gameStateGameOpsData);
};
com.funtomic.GameOps.readLocalStorage = function() {
	com.funtomic.GameOps.localStorage = com.funtomic.GameOps.storageGet("FuntomicGameOps",{ });
};
com.funtomic.GameOps.readGameStateLocalStorage = function() {
	com.funtomic.GameOps.gameStateGameOpsData = com.funtomic.GameOps.storageGet("FuntomicGameOps-GameState",{ });
};
com.funtomic.GameOps.setFlag = function(name) {
	if(Reflect.field(com.funtomic.GameOps.flags,name) == true) {
		com.funtomic.GameOpsLogger.debug([name + " is already running."]);
		return false;
	} else {
		com.funtomic.GameOps.flags[name] = true;
		return true;
	}
};
com.funtomic.GameOps.unsetFlag = function(name) {
	Reflect.deleteField(com.funtomic.GameOps.flags,name);
};
var flambe = {};
flambe.debug = {};
flambe.debug.FpsDisplay = function() {
	this._fpsFrames = 0;
	this._fpsTime = 0;
};
$hxClasses["flambe.debug.FpsDisplay"] = flambe.debug.FpsDisplay;
flambe.debug.FpsDisplay.__name__ = ["flambe","debug","FpsDisplay"];
flambe.debug.FpsDisplay.prototype = {
	reset: function() {
	}
	,dispose: function() {
	}
	,onUpdate: function(dt) {
	}
	,__class__: flambe.debug.FpsDisplay
};
com.funtomic.GameOpsFpsDetector = function() {
	flambe.debug.FpsDisplay.call(this);
	this._isCounting = false;
};
$hxClasses["com.funtomic.GameOpsFpsDetector"] = com.funtomic.GameOpsFpsDetector;
com.funtomic.GameOpsFpsDetector.__name__ = ["com","funtomic","GameOpsFpsDetector"];
com.funtomic.GameOpsFpsDetector._instance = null;
com.funtomic.GameOpsFpsDetector.start = function(sceneEntity) {
	sceneEntity.addChild(new flambe.Entity().add(com.funtomic.GameOpsFpsDetector._instance = new com.funtomic.GameOpsFpsDetector()));
	com.funtomic.GameOpsFpsDetector._instance.statrCount();
};
com.funtomic.GameOpsFpsDetector.stop = function() {
	if(com.funtomic.GameOpsFpsDetector._instance == null) return -1;
	return com.funtomic.GameOpsFpsDetector._instance.stopCount();
};
com.funtomic.GameOpsFpsDetector.__super__ = flambe.debug.FpsDisplay;
com.funtomic.GameOpsFpsDetector.prototype = $extend(flambe.debug.FpsDisplay.prototype,{
	onUpdate: function(dt) {
		if(!this._isCounting) return;
		++this._fpsFrames;
		this._fpsTime += dt;
		if(this._fpsTime > 1) {
			this._fpsResults.push(this._fpsFrames / this._fpsTime);
			this.reset();
		}
	}
	,statrCount: function() {
		this.reset();
		this._fpsResults = new Array();
		this._isCounting = true;
	}
	,stopCount: function() {
		if(!this._isCounting || this._fpsResults.length == 0) return -1;
		this._isCounting = false;
		var sum = 0;
		var _g = 0;
		var _g1 = this._fpsResults;
		while(_g < _g1.length) {
			var fps = _g1[_g];
			++_g;
			sum += fps;
		}
		com.funtomic.GameOpsFpsDetector._instance.dispose();
		return (sum / this._fpsResults.length * 100 | 0) / 100;
	}
	,__class__: com.funtomic.GameOpsFpsDetector
});
com.funtomic.GameOpsLogger = function() { };
$hxClasses["com.funtomic.GameOpsLogger"] = com.funtomic.GameOpsLogger;
com.funtomic.GameOpsLogger.__name__ = ["com","funtomic","GameOpsLogger"];
com.funtomic.GameOpsLogger.verbose = function(params) {
	com.funtomic.GameOpsLogger.log(2,params.join(" "));
};
com.funtomic.GameOpsLogger.debug = function(params) {
	com.funtomic.GameOpsLogger.log(1,params.join(" "));
};
com.funtomic.GameOpsLogger.error = function(params) {
	com.funtomic.GameOpsLogger.log(0,"ERROR - " + params.join(" "));
	null;
};
com.funtomic.GameOpsLogger.log = function(logLevel,message) {
	if(logLevel <= com.funtomic.GameOpsLogger.logLevel) {
		var now = new Date();
		var datetimeString = now.getDay() + "." + now.getMonth() + "." + now.getFullYear() + " " + now.getHours() + ":" + now.getMinutes() + ":" + now.getSeconds();
		null;
	}
};
com.funtomic.KiziWidget = function() { };
$hxClasses["com.funtomic.KiziWidget"] = com.funtomic.KiziWidget;
com.funtomic.KiziWidget.__name__ = ["com","funtomic","KiziWidget"];
com.funtomic.KiziWidget.levelStarted = function() {
	try {
		HTML5API_levelStarted();
	} catch( e ) {
	}
};
com.funtomic.KiziWidget.levelEnded = function() {
	try {
		HTML5API_levelEnded();
	} catch( e ) {
	}
};
com.funtomic.KiziWidget.preloaderStarted = function() {
	try {
		HTML5API_preloaderStarted();
	} catch( e ) {
	}
};
com.funtomic.KiziWidget.preloaderEnded = function() {
	try {
		HTML5API_preloaderEnded();
	} catch( e ) {
	}
};
com.funtomic.KiziWidget.getUserId = function() {
	try {
		return HTML5API_getUserId();
	} catch( e ) {
	}
	return null;
};
com.funtomic.KiziWidget.isAdPlaying = function() {
	try {
		return HTML5API_isAdPlaying();
	} catch( e ) {
	}
	return false;
};
com.funtomic.KiziWidget.onAdStart = function(func) {
	try {
		HTML5API_onAdStart(func);
	} catch( e ) {
	}
};
com.funtomic.KiziWidget.onAdComplete = function(func) {
	try {
		HTML5API_onAdComplete(func);
	} catch( e ) {
	}
};
com.funtomic.KiziWidget.showMidroll = function() {
	try {
		return HTML5API_showMidroll();
	} catch( e ) {
	}
	return false;
};
com.funtomic.KiziWidget.setWidgetState = function(params) {
	try {
		HTML5API_setWidgetState(params);
	} catch( e ) {
	}
};
flambe.Disposer = function() { };
$hxClasses["flambe.Disposer"] = flambe.Disposer;
flambe.Disposer.__name__ = ["flambe","Disposer"];
flambe.Entity = function() {
};
$hxClasses["flambe.Entity"] = flambe.Entity;
flambe.Entity.__name__ = ["flambe","Entity"];
flambe.Entity.prototype = {
	addChild: function(something) {
		return null;
	}
	,add: function(something) {
		return null;
	}
	,__class__: flambe.Entity
};
flambe.External = function() {
};
$hxClasses["flambe.External"] = flambe.External;
flambe.External.__name__ = ["flambe","External"];
flambe.External.prototype = {
	call: function(name,params) {
		if(params == null) params = [];
		var object = window;
		var method = object;
		var _g = 0;
		var _g1 = name.split(".");
		while(_g < _g1.length) {
			var fieldName = _g1[_g];
			++_g;
			object = method;
			method = Reflect.field(object,fieldName);
		}
		return method.apply(object,params);
	}
	,__class__: flambe.External
};
flambe.Storage = function() {
};
$hxClasses["flambe.Storage"] = flambe.Storage;
flambe.Storage.__name__ = ["flambe","Storage"];
flambe.Storage._adapter = null;
flambe.Storage._domain = null;
flambe.Storage.setStorageAdapter = function(domain,adapter) {
	flambe.Storage._domain = domain;
	flambe.Storage._adapter = adapter;
};
flambe.Storage.prototype = {
	get: function(key,defaultValue) {
		if(key.indexOf(flambe.Storage._domain) == 0) key = HxOverrides.substr(key,flambe.Storage._domain.length,null);
		if(flambe.Storage._adapter.getValue(key) == null) {
			flambe.Storage._adapter.setValue(key,defaultValue);
			return defaultValue;
		}
		return flambe.Storage._adapter.getValue(key);
	}
	,set: function(key,value) {
		if(key.indexOf(flambe.Storage._domain) == 0) key = HxOverrides.substr(key,flambe.Storage._domain.length,null);
		flambe.Storage._adapter.setValue(key,value);
		return true;
	}
	,remove: function(key) {
		flambe.Storage._adapter.removeValue(key);
	}
	,__class__: flambe.Storage
};
flambe.System = function() { };
$hxClasses["flambe.System"] = flambe.System;
flambe.System.__name__ = ["flambe","System"];
haxe.StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","LocalFunction"] };
haxe.StackItem.CFunction = ["CFunction",0];
haxe.StackItem.CFunction.toString = $estr;
haxe.StackItem.CFunction.__enum__ = haxe.StackItem;
haxe.StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; };
haxe.StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; };
haxe.StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; };
haxe.StackItem.LocalFunction = function(v) { var $x = ["LocalFunction",4,v]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; };
haxe.CallStack = function() { };
$hxClasses["haxe.CallStack"] = haxe.CallStack;
haxe.CallStack.__name__ = ["haxe","CallStack"];
haxe.CallStack.callStack = function() {
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe.StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe.StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe.CallStack.makeStack(new Error().stack);
	a.shift();
	Error.prepareStackTrace = oldValue;
	return a;
};
haxe.CallStack.exceptionStack = function() {
	return [];
};
haxe.CallStack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += "\nCalled from ";
		haxe.CallStack.itemToString(b,s);
	}
	return b.b;
};
haxe.CallStack.itemToString = function(b,s) {
	switch(s[1]) {
	case 0:
		b.b += "a C function";
		break;
	case 1:
		var m = s[2];
		b.b += "module ";
		if(m == null) b.b += "null"; else b.b += "" + m;
		break;
	case 2:
		var line = s[4];
		var file = s[3];
		var s1 = s[2];
		if(s1 != null) {
			haxe.CallStack.itemToString(b,s1);
			b.b += " (";
		}
		if(file == null) b.b += "null"; else b.b += "" + file;
		b.b += " line ";
		if(line == null) b.b += "null"; else b.b += "" + line;
		if(s1 != null) b.b += ")";
		break;
	case 3:
		var meth = s[3];
		var cname = s[2];
		if(cname == null) b.b += "null"; else b.b += "" + cname;
		b.b += ".";
		if(meth == null) b.b += "null"; else b.b += "" + meth;
		break;
	case 4:
		var n = s[2];
		b.b += "local function #";
		if(n == null) b.b += "null"; else b.b += "" + n;
		break;
	}
};
haxe.CallStack.makeStack = function(s) {
	if(typeof(s) == "string") {
		var stack = s.split("\n");
		var m = [];
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			m.push(haxe.StackItem.Module(line));
		}
		return m;
	} else return s;
};
haxe.Http = function(url) {
	this.url = url;
	this.headers = new List();
	this.params = new List();
	this.async = true;
};
$hxClasses["haxe.Http"] = haxe.Http;
haxe.Http.__name__ = ["haxe","Http"];
haxe.Http.prototype = {
	setParameter: function(param,value) {
		this.params = Lambda.filter(this.params,function(p) {
			return p.param != param;
		});
		this.params.push({ param : param, value : value});
		return this;
	}
	,addParameter: function(param,value) {
		this.params.push({ param : param, value : value});
		return this;
	}
	,request: function(post) {
		var me = this;
		me.responseData = null;
		var r = this.req = js.Browser.createXMLHttpRequest();
		var onreadystatechange = function(_) {
			if(r.readyState != 4) return;
			var s;
			try {
				s = r.status;
			} catch( e ) {
				s = null;
			}
			if(s == undefined) s = null;
			if(s != null) me.onStatus(s);
			if(s != null && s >= 200 && s < 400) {
				me.req = null;
				me.onData(me.responseData = r.responseText);
			} else if(s == null) {
				me.req = null;
				me.onError("Failed to connect or resolve host");
			} else switch(s) {
			case 12029:
				me.req = null;
				me.onError("Failed to connect to host");
				break;
			case 12007:
				me.req = null;
				me.onError("Unknown host");
				break;
			default:
				me.req = null;
				me.responseData = r.responseText;
				me.onError("Http Error #" + r.status);
			}
		};
		if(this.async) r.onreadystatechange = onreadystatechange;
		var uri = this.postData;
		if(uri != null) post = true; else {
			var $it0 = this.params.iterator();
			while( $it0.hasNext() ) {
				var p = $it0.next();
				if(uri == null) uri = ""; else uri += "&";
				uri += encodeURIComponent(p.param) + "=" + encodeURIComponent(p.value);
			}
		}
		try {
			if(post) r.open("POST",this.url,this.async); else if(uri != null) {
				var question = this.url.split("?").length <= 1;
				r.open("GET",this.url + (question?"?":"&") + uri,this.async);
				uri = null;
			} else r.open("GET",this.url,this.async);
		} catch( e1 ) {
			me.req = null;
			this.onError(e1.toString());
			return;
		}
		if(!Lambda.exists(this.headers,function(h) {
			return h.header == "Content-Type";
		}) && post && this.postData == null) r.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		var $it1 = this.headers.iterator();
		while( $it1.hasNext() ) {
			var h1 = $it1.next();
			r.setRequestHeader(h1.header,h1.value);
		}
		r.send(uri);
		if(!this.async) onreadystatechange(null);
	}
	,onData: function(data) {
	}
	,onError: function(msg) {
	}
	,onStatus: function(status) {
	}
	,__class__: haxe.Http
};
haxe.Log = function() { };
$hxClasses["haxe.Log"] = haxe.Log;
haxe.Log.__name__ = ["haxe","Log"];
haxe.Log.trace = function(v,infos) {
	js.Boot.__trace(v,infos);
};
haxe.Resource = function() { };
$hxClasses["haxe.Resource"] = haxe.Resource;
haxe.Resource.__name__ = ["haxe","Resource"];
haxe.Resource.content = null;
haxe.Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe.Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) return x.str;
			var b = haxe.crypto.Base64.decode(x.data);
			return b.toString();
		}
	}
	return null;
};
haxe.Resource.getBytes = function(name) {
	var _g = 0;
	var _g1 = haxe.Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) return haxe.io.Bytes.ofString(x.str);
			return haxe.crypto.Base64.decode(x.data);
		}
	}
	return null;
};
haxe.Serializer = function() {
	this.buf = new StringBuf();
	this.cache = new Array();
	this.useCache = haxe.Serializer.USE_CACHE;
	this.useEnumIndex = haxe.Serializer.USE_ENUM_INDEX;
	this.shash = new haxe.ds.StringMap();
	this.scount = 0;
};
$hxClasses["haxe.Serializer"] = haxe.Serializer;
haxe.Serializer.__name__ = ["haxe","Serializer"];
haxe.Serializer.run = function(v) {
	var s = new haxe.Serializer();
	s.serialize(v);
	return s.toString();
};
haxe.Serializer.prototype = {
	toString: function() {
		return this.buf.b;
	}
	,serializeString: function(s) {
		var x = this.shash.get(s);
		if(x != null) {
			this.buf.b += "R";
			if(x == null) this.buf.b += "null"; else this.buf.b += "" + x;
			return;
		}
		this.shash.set(s,this.scount++);
		this.buf.b += "y";
		s = encodeURIComponent(s);
		if(s.length == null) this.buf.b += "null"; else this.buf.b += "" + s.length;
		this.buf.b += ":";
		if(s == null) this.buf.b += "null"; else this.buf.b += "" + s;
	}
	,serializeRef: function(v) {
		var vt = typeof(v);
		var _g1 = 0;
		var _g = this.cache.length;
		while(_g1 < _g) {
			var i = _g1++;
			var ci = this.cache[i];
			if(typeof(ci) == vt && ci == v) {
				this.buf.b += "r";
				if(i == null) this.buf.b += "null"; else this.buf.b += "" + i;
				return true;
			}
		}
		this.cache.push(v);
		return false;
	}
	,serializeFields: function(v) {
		var _g = 0;
		var _g1 = Reflect.fields(v);
		while(_g < _g1.length) {
			var f = _g1[_g];
			++_g;
			this.serializeString(f);
			this.serialize(Reflect.field(v,f));
		}
		this.buf.b += "g";
	}
	,serialize: function(v) {
		{
			var _g = Type["typeof"](v);
			switch(_g[1]) {
			case 0:
				this.buf.b += "n";
				break;
			case 1:
				var v1 = v;
				if(v1 == 0) {
					this.buf.b += "z";
					return;
				}
				this.buf.b += "i";
				if(v1 == null) this.buf.b += "null"; else this.buf.b += "" + v1;
				break;
			case 2:
				var v2 = v;
				if(Math.isNaN(v2)) this.buf.b += "k"; else if(!Math.isFinite(v2)) if(v2 < 0) this.buf.b += "m"; else this.buf.b += "p"; else {
					this.buf.b += "d";
					if(v2 == null) this.buf.b += "null"; else this.buf.b += "" + v2;
				}
				break;
			case 3:
				if(v) this.buf.b += "t"; else this.buf.b += "f";
				break;
			case 6:
				var c = _g[2];
				if(c == String) {
					this.serializeString(v);
					return;
				}
				if(this.useCache && this.serializeRef(v)) return;
				switch(c) {
				case Array:
					var ucount = 0;
					this.buf.b += "a";
					var l = v.length;
					var _g1 = 0;
					while(_g1 < l) {
						var i = _g1++;
						if(v[i] == null) ucount++; else {
							if(ucount > 0) {
								if(ucount == 1) this.buf.b += "n"; else {
									this.buf.b += "u";
									if(ucount == null) this.buf.b += "null"; else this.buf.b += "" + ucount;
								}
								ucount = 0;
							}
							this.serialize(v[i]);
						}
					}
					if(ucount > 0) {
						if(ucount == 1) this.buf.b += "n"; else {
							this.buf.b += "u";
							if(ucount == null) this.buf.b += "null"; else this.buf.b += "" + ucount;
						}
					}
					this.buf.b += "h";
					break;
				case List:
					this.buf.b += "l";
					var v3 = v;
					var $it0 = v3.iterator();
					while( $it0.hasNext() ) {
						var i1 = $it0.next();
						this.serialize(i1);
					}
					this.buf.b += "h";
					break;
				case Date:
					var d = v;
					this.buf.b += "v";
					this.buf.add(HxOverrides.dateStr(d));
					break;
				case haxe.ds.StringMap:
					this.buf.b += "b";
					var v4 = v;
					var $it1 = v4.keys();
					while( $it1.hasNext() ) {
						var k = $it1.next();
						this.serializeString(k);
						this.serialize(v4.get(k));
					}
					this.buf.b += "h";
					break;
				case haxe.ds.IntMap:
					this.buf.b += "q";
					var v5 = v;
					var $it2 = v5.keys();
					while( $it2.hasNext() ) {
						var k1 = $it2.next();
						this.buf.b += ":";
						if(k1 == null) this.buf.b += "null"; else this.buf.b += "" + k1;
						this.serialize(v5.get(k1));
					}
					this.buf.b += "h";
					break;
				case haxe.ds.ObjectMap:
					this.buf.b += "M";
					var v6 = v;
					var $it3 = v6.keys();
					while( $it3.hasNext() ) {
						var k2 = $it3.next();
						var id = Reflect.field(k2,"__id__");
						Reflect.deleteField(k2,"__id__");
						this.serialize(k2);
						k2.__id__ = id;
						this.serialize(v6.h[k2.__id__]);
					}
					this.buf.b += "h";
					break;
				case haxe.io.Bytes:
					var v7 = v;
					var i2 = 0;
					var max = v7.length - 2;
					var charsBuf = new StringBuf();
					var b64 = haxe.Serializer.BASE64;
					while(i2 < max) {
						var b1 = v7.get(i2++);
						var b2 = v7.get(i2++);
						var b3 = v7.get(i2++);
						charsBuf.add(b64.charAt(b1 >> 2));
						charsBuf.add(b64.charAt((b1 << 4 | b2 >> 4) & 63));
						charsBuf.add(b64.charAt((b2 << 2 | b3 >> 6) & 63));
						charsBuf.add(b64.charAt(b3 & 63));
					}
					if(i2 == max) {
						var b11 = v7.get(i2++);
						var b21 = v7.get(i2++);
						charsBuf.add(b64.charAt(b11 >> 2));
						charsBuf.add(b64.charAt((b11 << 4 | b21 >> 4) & 63));
						charsBuf.add(b64.charAt(b21 << 2 & 63));
					} else if(i2 == max + 1) {
						var b12 = v7.get(i2++);
						charsBuf.add(b64.charAt(b12 >> 2));
						charsBuf.add(b64.charAt(b12 << 4 & 63));
					}
					var chars = charsBuf.b;
					this.buf.b += "s";
					if(chars.length == null) this.buf.b += "null"; else this.buf.b += "" + chars.length;
					this.buf.b += ":";
					if(chars == null) this.buf.b += "null"; else this.buf.b += "" + chars;
					break;
				default:
					if(this.useCache) this.cache.pop();
					if(v.hxSerialize != null) {
						this.buf.b += "C";
						this.serializeString(Type.getClassName(c));
						if(this.useCache) this.cache.push(v);
						v.hxSerialize(this);
						this.buf.b += "g";
					} else {
						this.buf.b += "c";
						this.serializeString(Type.getClassName(c));
						if(this.useCache) this.cache.push(v);
						this.serializeFields(v);
					}
				}
				break;
			case 4:
				if(this.useCache && this.serializeRef(v)) return;
				this.buf.b += "o";
				this.serializeFields(v);
				break;
			case 7:
				var e = _g[2];
				if(this.useCache) {
					if(this.serializeRef(v)) return;
					this.cache.pop();
				}
				if(this.useEnumIndex) this.buf.b += "j"; else this.buf.b += "w";
				this.serializeString(Type.getEnumName(e));
				if(this.useEnumIndex) {
					this.buf.b += ":";
					this.buf.b += Std.string(v[1]);
				} else this.serializeString(v[0]);
				this.buf.b += ":";
				var l1 = v.length;
				this.buf.b += Std.string(l1 - 2);
				var _g11 = 2;
				while(_g11 < l1) {
					var i3 = _g11++;
					this.serialize(v[i3]);
				}
				if(this.useCache) this.cache.push(v);
				break;
			case 5:
				throw "Cannot serialize function";
				break;
			default:
				throw "Cannot serialize " + Std.string(v);
			}
		}
	}
	,__class__: haxe.Serializer
};
haxe.Unserializer = function(buf) {
	this.buf = buf;
	this.length = buf.length;
	this.pos = 0;
	this.scache = new Array();
	this.cache = new Array();
	var r = haxe.Unserializer.DEFAULT_RESOLVER;
	if(r == null) {
		r = Type;
		haxe.Unserializer.DEFAULT_RESOLVER = r;
	}
	this.setResolver(r);
};
$hxClasses["haxe.Unserializer"] = haxe.Unserializer;
haxe.Unserializer.__name__ = ["haxe","Unserializer"];
haxe.Unserializer.initCodes = function() {
	var codes = new Array();
	var _g1 = 0;
	var _g = haxe.Unserializer.BASE64.length;
	while(_g1 < _g) {
		var i = _g1++;
		codes[haxe.Unserializer.BASE64.charCodeAt(i)] = i;
	}
	return codes;
};
haxe.Unserializer.prototype = {
	setResolver: function(r) {
		if(r == null) this.resolver = { resolveClass : function(_) {
			return null;
		}, resolveEnum : function(_1) {
			return null;
		}}; else this.resolver = r;
	}
	,get: function(p) {
		return this.buf.charCodeAt(p);
	}
	,readDigits: function() {
		var k = 0;
		var s = false;
		var fpos = this.pos;
		while(true) {
			var c = this.buf.charCodeAt(this.pos);
			if(c != c) break;
			if(c == 45) {
				if(this.pos != fpos) break;
				s = true;
				this.pos++;
				continue;
			}
			if(c < 48 || c > 57) break;
			k = k * 10 + (c - 48);
			this.pos++;
		}
		if(s) k *= -1;
		return k;
	}
	,unserializeObject: function(o) {
		while(true) {
			if(this.pos >= this.length) throw "Invalid object";
			if(this.buf.charCodeAt(this.pos) == 103) break;
			var k = this.unserialize();
			if(!(typeof(k) == "string")) throw "Invalid object key";
			var v = this.unserialize();
			o[k] = v;
		}
		this.pos++;
	}
	,unserializeEnum: function(edecl,tag) {
		if(this.get(this.pos++) != 58) throw "Invalid enum format";
		var nargs = this.readDigits();
		if(nargs == 0) return Type.createEnum(edecl,tag);
		var args = new Array();
		while(nargs-- > 0) args.push(this.unserialize());
		return Type.createEnum(edecl,tag,args);
	}
	,unserialize: function() {
		var _g = this.get(this.pos++);
		switch(_g) {
		case 110:
			return null;
		case 116:
			return true;
		case 102:
			return false;
		case 122:
			return 0;
		case 105:
			return this.readDigits();
		case 100:
			var p1 = this.pos;
			while(true) {
				var c = this.buf.charCodeAt(this.pos);
				if(c >= 43 && c < 58 || c == 101 || c == 69) this.pos++; else break;
			}
			return Std.parseFloat(HxOverrides.substr(this.buf,p1,this.pos - p1));
		case 121:
			var len = this.readDigits();
			if(this.get(this.pos++) != 58 || this.length - this.pos < len) throw "Invalid string length";
			var s = HxOverrides.substr(this.buf,this.pos,len);
			this.pos += len;
			s = decodeURIComponent(s.split("+").join(" "));
			this.scache.push(s);
			return s;
		case 107:
			return Math.NaN;
		case 109:
			return Math.NEGATIVE_INFINITY;
		case 112:
			return Math.POSITIVE_INFINITY;
		case 97:
			var buf = this.buf;
			var a = new Array();
			this.cache.push(a);
			while(true) {
				var c1 = this.buf.charCodeAt(this.pos);
				if(c1 == 104) {
					this.pos++;
					break;
				}
				if(c1 == 117) {
					this.pos++;
					var n = this.readDigits();
					a[a.length + n - 1] = null;
				} else a.push(this.unserialize());
			}
			return a;
		case 111:
			var o = { };
			this.cache.push(o);
			this.unserializeObject(o);
			return o;
		case 114:
			var n1 = this.readDigits();
			if(n1 < 0 || n1 >= this.cache.length) throw "Invalid reference";
			return this.cache[n1];
		case 82:
			var n2 = this.readDigits();
			if(n2 < 0 || n2 >= this.scache.length) throw "Invalid string reference";
			return this.scache[n2];
		case 120:
			throw this.unserialize();
			break;
		case 99:
			var name = this.unserialize();
			var cl = this.resolver.resolveClass(name);
			if(cl == null) throw "Class not found " + name;
			var o1 = Type.createEmptyInstance(cl);
			this.cache.push(o1);
			this.unserializeObject(o1);
			return o1;
		case 119:
			var name1 = this.unserialize();
			var edecl = this.resolver.resolveEnum(name1);
			if(edecl == null) throw "Enum not found " + name1;
			var e = this.unserializeEnum(edecl,this.unserialize());
			this.cache.push(e);
			return e;
		case 106:
			var name2 = this.unserialize();
			var edecl1 = this.resolver.resolveEnum(name2);
			if(edecl1 == null) throw "Enum not found " + name2;
			this.pos++;
			var index = this.readDigits();
			var tag = Type.getEnumConstructs(edecl1)[index];
			if(tag == null) throw "Unknown enum index " + name2 + "@" + index;
			var e1 = this.unserializeEnum(edecl1,tag);
			this.cache.push(e1);
			return e1;
		case 108:
			var l = new List();
			this.cache.push(l);
			var buf1 = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) l.add(this.unserialize());
			this.pos++;
			return l;
		case 98:
			var h = new haxe.ds.StringMap();
			this.cache.push(h);
			var buf2 = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) {
				var s1 = this.unserialize();
				h.set(s1,this.unserialize());
			}
			this.pos++;
			return h;
		case 113:
			var h1 = new haxe.ds.IntMap();
			this.cache.push(h1);
			var buf3 = this.buf;
			var c2 = this.get(this.pos++);
			while(c2 == 58) {
				var i = this.readDigits();
				h1.set(i,this.unserialize());
				c2 = this.get(this.pos++);
			}
			if(c2 != 104) throw "Invalid IntMap format";
			return h1;
		case 77:
			var h2 = new haxe.ds.ObjectMap();
			this.cache.push(h2);
			var buf4 = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) {
				var s2 = this.unserialize();
				h2.set(s2,this.unserialize());
			}
			this.pos++;
			return h2;
		case 118:
			var d;
			var s3 = HxOverrides.substr(this.buf,this.pos,19);
			d = HxOverrides.strDate(s3);
			this.cache.push(d);
			this.pos += 19;
			return d;
		case 115:
			var len1 = this.readDigits();
			var buf5 = this.buf;
			if(this.get(this.pos++) != 58 || this.length - this.pos < len1) throw "Invalid bytes length";
			var codes = haxe.Unserializer.CODES;
			if(codes == null) {
				codes = haxe.Unserializer.initCodes();
				haxe.Unserializer.CODES = codes;
			}
			var i1 = this.pos;
			var rest = len1 & 3;
			var size;
			size = (len1 >> 2) * 3 + (rest >= 2?rest - 1:0);
			var max = i1 + (len1 - rest);
			var bytes = haxe.io.Bytes.alloc(size);
			var bpos = 0;
			while(i1 < max) {
				var c11 = codes[StringTools.fastCodeAt(buf5,i1++)];
				var c21 = codes[StringTools.fastCodeAt(buf5,i1++)];
				bytes.set(bpos++,c11 << 2 | c21 >> 4);
				var c3 = codes[StringTools.fastCodeAt(buf5,i1++)];
				bytes.set(bpos++,c21 << 4 | c3 >> 2);
				var c4 = codes[StringTools.fastCodeAt(buf5,i1++)];
				bytes.set(bpos++,c3 << 6 | c4);
			}
			if(rest >= 2) {
				var c12 = codes[StringTools.fastCodeAt(buf5,i1++)];
				var c22 = codes[StringTools.fastCodeAt(buf5,i1++)];
				bytes.set(bpos++,c12 << 2 | c22 >> 4);
				if(rest == 3) {
					var c31 = codes[StringTools.fastCodeAt(buf5,i1++)];
					bytes.set(bpos++,c22 << 4 | c31 >> 2);
				}
			}
			this.pos += len1;
			this.cache.push(bytes);
			return bytes;
		case 67:
			var name3 = this.unserialize();
			var cl1 = this.resolver.resolveClass(name3);
			if(cl1 == null) throw "Class not found " + name3;
			var o2 = Type.createEmptyInstance(cl1);
			this.cache.push(o2);
			o2.hxUnserialize(this);
			if(this.get(this.pos++) != 103) throw "Invalid custom data";
			return o2;
		default:
		}
		this.pos--;
		throw "Invalid char " + this.buf.charAt(this.pos) + " at position " + this.pos;
	}
	,__class__: haxe.Unserializer
};
haxe.io = {};
haxe.io.Bytes = function(length,b) {
	this.length = length;
	this.b = b;
};
$hxClasses["haxe.io.Bytes"] = haxe.io.Bytes;
haxe.io.Bytes.__name__ = ["haxe","io","Bytes"];
haxe.io.Bytes.alloc = function(length) {
	var a = new Array();
	var _g = 0;
	while(_g < length) {
		var i = _g++;
		a.push(0);
	}
	return new haxe.io.Bytes(length,a);
};
haxe.io.Bytes.ofString = function(s) {
	var a = new Array();
	var i = 0;
	while(i < s.length) {
		var c = StringTools.fastCodeAt(s,i++);
		if(55296 <= c && c <= 56319) c = c - 55232 << 10 | StringTools.fastCodeAt(s,i++) & 1023;
		if(c <= 127) a.push(c); else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe.io.Bytes(a.length,a);
};
haxe.io.Bytes.ofData = function(b) {
	return new haxe.io.Bytes(b.length,b);
};
haxe.io.Bytes.prototype = {
	get: function(pos) {
		return this.b[pos];
	}
	,set: function(pos,v) {
		this.b[pos] = v & 255;
	}
	,getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) throw haxe.io.Error.OutsideBounds;
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) break;
				s += fcc(c);
			} else if(c < 224) s += fcc((c & 63) << 6 | b[i++] & 127); else if(c < 240) {
				var c2 = b[i++];
				s += fcc((c & 31) << 12 | (c2 & 127) << 6 | b[i++] & 127);
			} else {
				var c21 = b[i++];
				var c3 = b[i++];
				var u = (c & 15) << 18 | (c21 & 127) << 12 | (c3 & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe.io.Bytes
};
haxe.crypto = {};
haxe.crypto.Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe.crypto.Base64;
haxe.crypto.Base64.__name__ = ["haxe","crypto","Base64"];
haxe.crypto.Base64.decode = function(str,complement) {
	if(complement == null) complement = true;
	if(complement) while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	return new haxe.crypto.BaseCode(haxe.crypto.Base64.BYTES).decodeBytes(haxe.io.Bytes.ofString(str));
};
haxe.crypto.BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) nbits++;
	if(nbits > 8 || len != 1 << nbits) throw "BaseCode : base length must be a power of two.";
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe.crypto.BaseCode;
haxe.crypto.BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe.crypto.BaseCode.prototype = {
	encodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		var size = b.length * 8 / nbits | 0;
		var out = haxe.io.Bytes.alloc(size + (b.length * 8 % nbits == 0?0:1));
		var buf = 0;
		var curbits = 0;
		var mask = (1 << nbits) - 1;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < nbits) {
				curbits += 8;
				buf <<= 8;
				buf |= b.get(pin++);
			}
			curbits -= nbits;
			out.set(pout++,base.b[buf >> curbits & mask]);
		}
		if(curbits > 0) out.set(pout++,base.b[buf << nbits - curbits & mask]);
		return out;
	}
	,initTable: function() {
		var tbl = new Array();
		var _g = 0;
		while(_g < 256) {
			var i = _g++;
			tbl[i] = -1;
		}
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i1 = _g1++;
			tbl[this.base.b[i1]] = i1;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		if(this.tbl == null) this.initTable();
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = haxe.io.Bytes.alloc(size);
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.get(pin++)];
				if(i == -1) throw "BaseCode : invalid encoded char";
				buf |= i;
			}
			curbits -= 8;
			out.set(pout++,buf >> curbits & 255);
		}
		return out;
	}
	,__class__: haxe.crypto.BaseCode
};
haxe.crypto.Sha1 = function() {
};
$hxClasses["haxe.crypto.Sha1"] = haxe.crypto.Sha1;
haxe.crypto.Sha1.__name__ = ["haxe","crypto","Sha1"];
haxe.crypto.Sha1.encode = function(s) {
	var sh = new haxe.crypto.Sha1();
	var h = sh.doEncode(haxe.crypto.Sha1.str2blks(s));
	return sh.hex(h);
};
haxe.crypto.Sha1.str2blks = function(s) {
	var nblk = (s.length + 8 >> 6) + 1;
	var blks = new Array();
	var _g1 = 0;
	var _g = nblk * 16;
	while(_g1 < _g) {
		var i = _g1++;
		blks[i] = 0;
	}
	var _g11 = 0;
	var _g2 = s.length;
	while(_g11 < _g2) {
		var i1 = _g11++;
		var p = i1 >> 2;
		blks[p] |= HxOverrides.cca(s,i1) << 24 - ((i1 & 3) << 3);
	}
	var i2 = s.length;
	var p1 = i2 >> 2;
	blks[p1] |= 128 << 24 - ((i2 & 3) << 3);
	blks[nblk * 16 - 1] = s.length * 8;
	return blks;
};
haxe.crypto.Sha1.prototype = {
	doEncode: function(x) {
		var w = new Array();
		var a = 1732584193;
		var b = -271733879;
		var c = -1732584194;
		var d = 271733878;
		var e = -1009589776;
		var i = 0;
		while(i < x.length) {
			var olda = a;
			var oldb = b;
			var oldc = c;
			var oldd = d;
			var olde = e;
			var j = 0;
			while(j < 80) {
				if(j < 16) w[j] = x[i + j]; else w[j] = this.rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16],1);
				var t = (a << 5 | a >>> 27) + this.ft(j,b,c,d) + e + w[j] + this.kt(j);
				e = d;
				d = c;
				c = b << 30 | b >>> 2;
				b = a;
				a = t;
				j++;
			}
			a += olda;
			b += oldb;
			c += oldc;
			d += oldd;
			e += olde;
			i += 16;
		}
		return [a,b,c,d,e];
	}
	,rol: function(num,cnt) {
		return num << cnt | num >>> 32 - cnt;
	}
	,ft: function(t,b,c,d) {
		if(t < 20) return b & c | ~b & d;
		if(t < 40) return b ^ c ^ d;
		if(t < 60) return b & c | b & d | c & d;
		return b ^ c ^ d;
	}
	,kt: function(t) {
		if(t < 20) return 1518500249;
		if(t < 40) return 1859775393;
		if(t < 60) return -1894007588;
		return -899497514;
	}
	,hex: function(a) {
		var str = "";
		var hex_chr = "0123456789abcdef";
		var _g = 0;
		while(_g < a.length) {
			var num = a[_g];
			++_g;
			var j = 7;
			while(j >= 0) {
				str += hex_chr.charAt(num >>> (j << 2) & 15);
				j--;
			}
		}
		return str;
	}
	,__class__: haxe.crypto.Sha1
};
haxe.ds.BalancedTree = function() {
};
$hxClasses["haxe.ds.BalancedTree"] = haxe.ds.BalancedTree;
haxe.ds.BalancedTree.__name__ = ["haxe","ds","BalancedTree"];
haxe.ds.BalancedTree.prototype = {
	set: function(key,value) {
		this.root = this.setLoop(key,value,this.root);
	}
	,get: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) return node.value;
			if(c < 0) node = node.left; else node = node.right;
		}
		return null;
	}
	,setLoop: function(k,v,node) {
		if(node == null) return new haxe.ds.TreeNode(null,k,v,null);
		var c = this.compare(k,node.key);
		if(c == 0) return new haxe.ds.TreeNode(node.left,k,v,node.right,node == null?0:node._height); else if(c < 0) {
			var nl = this.setLoop(k,v,node.left);
			return this.balance(nl,node.key,node.value,node.right);
		} else {
			var nr = this.setLoop(k,v,node.right);
			return this.balance(node.left,node.key,node.value,nr);
		}
	}
	,balance: function(l,k,v,r) {
		var hl;
		if(l == null) hl = 0; else hl = l._height;
		var hr;
		if(r == null) hr = 0; else hr = r._height;
		if(hl > hr + 2) {
			if((function($this) {
				var $r;
				var _this = l.left;
				$r = _this == null?0:_this._height;
				return $r;
			}(this)) >= (function($this) {
				var $r;
				var _this1 = l.right;
				$r = _this1 == null?0:_this1._height;
				return $r;
			}(this))) return new haxe.ds.TreeNode(l.left,l.key,l.value,new haxe.ds.TreeNode(l.right,k,v,r)); else return new haxe.ds.TreeNode(new haxe.ds.TreeNode(l.left,l.key,l.value,l.right.left),l.right.key,l.right.value,new haxe.ds.TreeNode(l.right.right,k,v,r));
		} else if(hr > hl + 2) {
			if((function($this) {
				var $r;
				var _this2 = r.right;
				$r = _this2 == null?0:_this2._height;
				return $r;
			}(this)) > (function($this) {
				var $r;
				var _this3 = r.left;
				$r = _this3 == null?0:_this3._height;
				return $r;
			}(this))) return new haxe.ds.TreeNode(new haxe.ds.TreeNode(l,k,v,r.left),r.key,r.value,r.right); else return new haxe.ds.TreeNode(new haxe.ds.TreeNode(l,k,v,r.left.left),r.left.key,r.left.value,new haxe.ds.TreeNode(r.left.right,r.key,r.value,r.right));
		} else return new haxe.ds.TreeNode(l,k,v,r,(hl > hr?hl:hr) + 1);
	}
	,compare: function(k1,k2) {
		return Reflect.compare(k1,k2);
	}
	,__class__: haxe.ds.BalancedTree
};
haxe.ds.TreeNode = function(l,k,v,r,h) {
	if(h == null) h = -1;
	this.left = l;
	this.key = k;
	this.value = v;
	this.right = r;
	if(h == -1) this._height = ((function($this) {
		var $r;
		var _this = $this.left;
		$r = _this == null?0:_this._height;
		return $r;
	}(this)) > (function($this) {
		var $r;
		var _this1 = $this.right;
		$r = _this1 == null?0:_this1._height;
		return $r;
	}(this))?(function($this) {
		var $r;
		var _this2 = $this.left;
		$r = _this2 == null?0:_this2._height;
		return $r;
	}(this)):(function($this) {
		var $r;
		var _this3 = $this.right;
		$r = _this3 == null?0:_this3._height;
		return $r;
	}(this))) + 1; else this._height = h;
};
$hxClasses["haxe.ds.TreeNode"] = haxe.ds.TreeNode;
haxe.ds.TreeNode.__name__ = ["haxe","ds","TreeNode"];
haxe.ds.TreeNode.prototype = {
	__class__: haxe.ds.TreeNode
};
haxe.ds.EnumValueMap = function() {
	haxe.ds.BalancedTree.call(this);
};
$hxClasses["haxe.ds.EnumValueMap"] = haxe.ds.EnumValueMap;
haxe.ds.EnumValueMap.__name__ = ["haxe","ds","EnumValueMap"];
haxe.ds.EnumValueMap.__interfaces__ = [IMap];
haxe.ds.EnumValueMap.__super__ = haxe.ds.BalancedTree;
haxe.ds.EnumValueMap.prototype = $extend(haxe.ds.BalancedTree.prototype,{
	compare: function(k1,k2) {
		var d = k1[1] - k2[1];
		if(d != 0) return d;
		var p1 = k1.slice(2);
		var p2 = k2.slice(2);
		if(p1.length == 0 && p2.length == 0) return 0;
		return this.compareArgs(p1,p2);
	}
	,compareArgs: function(a1,a2) {
		var ld = a1.length - a2.length;
		if(ld != 0) return ld;
		var _g1 = 0;
		var _g = a1.length;
		while(_g1 < _g) {
			var i = _g1++;
			var d = this.compareArg(a1[i],a2[i]);
			if(d != 0) return d;
		}
		return 0;
	}
	,compareArg: function(v1,v2) {
		if(Reflect.isEnumValue(v1) && Reflect.isEnumValue(v2)) return this.compare(v1,v2); else if((v1 instanceof Array) && v1.__enum__ == null && ((v2 instanceof Array) && v2.__enum__ == null)) return this.compareArgs(v1,v2); else return Reflect.compare(v1,v2);
	}
	,__class__: haxe.ds.EnumValueMap
});
haxe.ds.IntMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.IntMap"] = haxe.ds.IntMap;
haxe.ds.IntMap.__name__ = ["haxe","ds","IntMap"];
haxe.ds.IntMap.__interfaces__ = [IMap];
haxe.ds.IntMap.prototype = {
	set: function(key,value) {
		this.h[key] = value;
	}
	,get: function(key) {
		return this.h[key];
	}
	,exists: function(key) {
		return this.h.hasOwnProperty(key);
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) a.push(key | 0);
		}
		return HxOverrides.iter(a);
	}
	,__class__: haxe.ds.IntMap
};
haxe.ds.ObjectMap = function() {
	this.h = { };
	this.h.__keys__ = { };
};
$hxClasses["haxe.ds.ObjectMap"] = haxe.ds.ObjectMap;
haxe.ds.ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe.ds.ObjectMap.__interfaces__ = [IMap];
haxe.ds.ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe.ds.ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,remove: function(key) {
		var id = key.__id__;
		if(this.h.__keys__[id] == null) return false;
		delete(this.h[id]);
		delete(this.h.__keys__[id]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) a.push(this.h.__keys__[key]);
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe.ds.ObjectMap
};
haxe.ds._Vector = {};
haxe.ds._Vector.Vector_Impl_ = function() { };
$hxClasses["haxe.ds._Vector.Vector_Impl_"] = haxe.ds._Vector.Vector_Impl_;
haxe.ds._Vector.Vector_Impl_.__name__ = ["haxe","ds","_Vector","Vector_Impl_"];
haxe.ds._Vector.Vector_Impl_.blit = function(src,srcPos,dest,destPos,len) {
	var _g = 0;
	while(_g < len) {
		var i = _g++;
		dest[destPos + i] = src[srcPos + i];
	}
};
haxe.ds._Vector.Vector_Impl_.toArray = function(this1) {
	var a = new Array();
	var len = this1.length;
	var _g = 0;
	while(_g < len) {
		var i = _g++;
		a[i] = this1[i];
	}
	return a;
};
haxe.io.Eof = function() { };
$hxClasses["haxe.io.Eof"] = haxe.io.Eof;
haxe.io.Eof.__name__ = ["haxe","io","Eof"];
haxe.io.Eof.prototype = {
	toString: function() {
		return "Eof";
	}
	,__class__: haxe.io.Eof
};
haxe.io.Error = $hxClasses["haxe.io.Error"] = { __ename__ : ["haxe","io","Error"], __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe.io.Error.Blocked = ["Blocked",0];
haxe.io.Error.Blocked.toString = $estr;
haxe.io.Error.Blocked.__enum__ = haxe.io.Error;
haxe.io.Error.Overflow = ["Overflow",1];
haxe.io.Error.Overflow.toString = $estr;
haxe.io.Error.Overflow.__enum__ = haxe.io.Error;
haxe.io.Error.OutsideBounds = ["OutsideBounds",2];
haxe.io.Error.OutsideBounds.toString = $estr;
haxe.io.Error.OutsideBounds.__enum__ = haxe.io.Error;
haxe.io.Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe.io.Error; $x.toString = $estr; return $x; };
haxe.io.Path = function(path) {
	var c1 = path.lastIndexOf("/");
	var c2 = path.lastIndexOf("\\");
	if(c1 < c2) {
		this.dir = HxOverrides.substr(path,0,c2);
		path = HxOverrides.substr(path,c2 + 1,null);
		this.backslash = true;
	} else if(c2 < c1) {
		this.dir = HxOverrides.substr(path,0,c1);
		path = HxOverrides.substr(path,c1 + 1,null);
	} else this.dir = null;
	var cp = path.lastIndexOf(".");
	if(cp != -1) {
		this.ext = HxOverrides.substr(path,cp + 1,null);
		this.file = HxOverrides.substr(path,0,cp);
	} else {
		this.ext = null;
		this.file = path;
	}
};
$hxClasses["haxe.io.Path"] = haxe.io.Path;
haxe.io.Path.__name__ = ["haxe","io","Path"];
haxe.io.Path.withoutExtension = function(path) {
	var s = new haxe.io.Path(path);
	s.ext = null;
	return s.toString();
};
haxe.io.Path.prototype = {
	toString: function() {
		return (this.dir == null?"":this.dir + (this.backslash?"\\":"/")) + this.file + (this.ext == null?"":"." + this.ext);
	}
	,__class__: haxe.io.Path
};
var js = {};
js.Boot = function() { };
$hxClasses["js.Boot"] = js.Boot;
js.Boot.__name__ = ["js","Boot"];
js.Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
};
js.Boot.__trace = function(v,i) {
	var msg;
	if(i != null) msg = i.fileName + ":" + i.lineNumber + ": "; else msg = "";
	msg += js.Boot.__string_rec(v,"");
	if(i != null && i.customParams != null) {
		var _g = 0;
		var _g1 = i.customParams;
		while(_g < _g1.length) {
			var v1 = _g1[_g];
			++_g;
			msg += "," + js.Boot.__string_rec(v1,"");
		}
	}
	var d;
	if(typeof(document) != "undefined" && (d = document.getElementById("haxe:trace")) != null) d.innerHTML += js.Boot.__unhtml(msg) + "<br/>"; else if(typeof console != "undefined" && console.log != null) console.log(msg);
};
js.Boot.__clear_trace = function() {
	var d = document.getElementById("haxe:trace");
	if(d != null) d.innerHTML = "";
};
js.Boot.isClass = function(o) {
	return o.__name__;
};
js.Boot.isEnum = function(e) {
	return e.__ename__;
};
js.Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) return Array; else {
		var cl = o.__class__;
		if(cl != null) return cl;
		var name = js.Boot.__nativeClassName(o);
		if(name != null) return js.Boot.__resolveNativeClass(name);
		return null;
	}
};
js.Boot.__string_rec = function(o,s) {
	if(o == null) return "null";
	if(s.length >= 5) return "<...>";
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) t = "object";
	switch(t) {
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) return o[0];
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) str += "," + js.Boot.__string_rec(o[i],s); else str += js.Boot.__string_rec(o[i],s);
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g2 = 0;
			while(_g2 < l) {
				var i2 = _g2++;
				str1 += (i2 > 0?",":"") + js.Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") return s2;
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) str2 += ", \n";
		str2 += s + k + " : " + js.Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "function":
		return "<function>";
	case "string":
		return o;
	default:
		return String(o);
	}
};
js.Boot.__interfLoop = function(cc,cl) {
	if(cc == null) return false;
	if(cc == cl) return true;
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js.Boot.__interfLoop(i1,cl)) return true;
		}
	}
	return js.Boot.__interfLoop(cc.__super__,cl);
};
js.Boot.__instanceof = function(o,cl) {
	if(cl == null) return false;
	switch(cl) {
	case Int:
		return (o|0) === o;
	case Float:
		return typeof(o) == "number";
	case Bool:
		return typeof(o) == "boolean";
	case String:
		return typeof(o) == "string";
	case Array:
		return (o instanceof Array) && o.__enum__ == null;
	case Dynamic:
		return true;
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) return true;
				if(js.Boot.__interfLoop(js.Boot.getClass(o),cl)) return true;
			} else if(typeof(cl) == "object" && js.Boot.__isNativeObj(cl)) {
				if(o instanceof cl) return true;
			}
		} else return false;
		if(cl == Class && o.__name__ != null) return true;
		if(cl == Enum && o.__ename__ != null) return true;
		return o.__enum__ == cl;
	}
};
js.Boot.__cast = function(o,t) {
	if(js.Boot.__instanceof(o,t)) return o; else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
};
js.Boot.__nativeClassName = function(o) {
	var name = js.Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") return null;
	return name;
};
js.Boot.__isNativeObj = function(o) {
	return js.Boot.__nativeClassName(o) != null;
};
js.Boot.__resolveNativeClass = function(name) {
	if(typeof window != "undefined") return window[name]; else return global[name];
};
js.Browser = function() { };
$hxClasses["js.Browser"] = js.Browser;
js.Browser.__name__ = ["js","Browser"];
js.Browser.getLocalStorage = function() {
	try {
		var s = window.localStorage;
		s.getItem("");
		return s;
	} catch( e ) {
		return null;
	}
};
js.Browser.createXMLHttpRequest = function() {
	if(typeof XMLHttpRequest != "undefined") return new XMLHttpRequest();
	if(typeof ActiveXObject != "undefined") return new ActiveXObject("Microsoft.XMLHTTP");
	throw "Unable to create XMLHttpRequest object.";
};
lime.AssetCache = function() {
	this.enabled = true;
	this.audio = new haxe.ds.StringMap();
	this.font = new haxe.ds.StringMap();
	this.image = new haxe.ds.StringMap();
};
$hxClasses["lime.AssetCache"] = lime.AssetCache;
lime.AssetCache.__name__ = ["lime","AssetCache"];
lime.AssetCache.prototype = {
	clear: function(prefix) {
		if(prefix == null) {
			this.audio = new haxe.ds.StringMap();
			this.font = new haxe.ds.StringMap();
			this.image = new haxe.ds.StringMap();
		} else {
			var keys = this.audio.keys();
			while( keys.hasNext() ) {
				var key = keys.next();
				if(StringTools.startsWith(key,prefix)) this.audio.remove(key);
			}
			var keys1 = this.font.keys();
			while( keys1.hasNext() ) {
				var key1 = keys1.next();
				if(StringTools.startsWith(key1,prefix)) this.font.remove(key1);
			}
			var keys2 = this.image.keys();
			while( keys2.hasNext() ) {
				var key2 = keys2.next();
				if(StringTools.startsWith(key2,prefix)) this.image.remove(key2);
			}
		}
	}
	,__class__: lime.AssetCache
};
lime.Assets = function() { };
$hxClasses["lime.Assets"] = lime.Assets;
lime.Assets.__name__ = ["lime","Assets"];
lime.Assets.exists = function(id,type) {
	lime.Assets.initialize();
	if(type == null) type = "BINARY";
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) return library.exists(symbolName,type);
	return false;
};
lime.Assets.getAudioBuffer = function(id,useCache) {
	if(useCache == null) useCache = true;
	lime.Assets.initialize();
	if(useCache && lime.Assets.cache.enabled && lime.Assets.cache.audio.exists(id)) {
		var audio = lime.Assets.cache.audio.get(id);
		if(lime.Assets.isValidAudio(audio)) return audio;
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"SOUND")) {
			if(library.isLocal(symbolName,"SOUND")) {
				var audio1 = library.getAudioBuffer(symbolName);
				if(useCache && lime.Assets.cache.enabled) lime.Assets.cache.audio.set(id,audio1);
				return audio1;
			} else null;
		} else null;
	} else null;
	return null;
};
lime.Assets.getBytes = function(id) {
	lime.Assets.initialize();
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"BINARY")) {
			if(library.isLocal(symbolName,"BINARY")) return library.getBytes(symbolName); else null;
		} else null;
	} else null;
	return null;
};
lime.Assets.getFont = function(id,useCache) {
	if(useCache == null) useCache = true;
	lime.Assets.initialize();
	if(useCache && lime.Assets.cache.enabled && lime.Assets.cache.font.exists(id)) return lime.Assets.cache.font.get(id);
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"FONT")) {
			if(library.isLocal(symbolName,"FONT")) {
				var font = library.getFont(symbolName);
				if(useCache && lime.Assets.cache.enabled) lime.Assets.cache.font.set(id,font);
				return font;
			} else null;
		} else null;
	} else null;
	return null;
};
lime.Assets.getImage = function(id,useCache) {
	if(useCache == null) useCache = true;
	lime.Assets.initialize();
	if(useCache && lime.Assets.cache.enabled && lime.Assets.cache.image.exists(id)) {
		var image = lime.Assets.cache.image.get(id);
		if(lime.Assets.isValidImage(image)) return image;
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"IMAGE")) {
			if(library.isLocal(symbolName,"IMAGE")) {
				var image1 = library.getImage(symbolName);
				if(useCache && lime.Assets.cache.enabled) lime.Assets.cache.image.set(id,image1);
				return image1;
			} else null;
		} else null;
	} else null;
	return null;
};
lime.Assets.getLibrary = function(name) {
	if(name == null || name == "") name = "default";
	return lime.Assets.libraries.get(name);
};
lime.Assets.getPath = function(id) {
	lime.Assets.initialize();
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,null)) return library.getPath(symbolName); else null;
	} else null;
	return null;
};
lime.Assets.getText = function(id) {
	lime.Assets.initialize();
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"TEXT")) {
			if(library.isLocal(symbolName,"TEXT")) return library.getText(symbolName); else null;
		} else null;
	} else null;
	return null;
};
lime.Assets.initialize = function() {
	if(!lime.Assets.initialized) {
		lime.Assets.registerLibrary("default",new DefaultAssetLibrary());
		lime.Assets.initialized = true;
	}
};
lime.Assets.isLocal = function(id,type,useCache) {
	if(useCache == null) useCache = true;
	lime.Assets.initialize();
	if(useCache && lime.Assets.cache.enabled) {
		if(type == "IMAGE" || type == null) {
			if(lime.Assets.cache.image.exists(id)) return true;
		}
		if(type == "FONT" || type == null) {
			if(lime.Assets.cache.font.exists(id)) return true;
		}
		if(type == "SOUND" || type == "MUSIC" || type == null) {
			if(lime.Assets.cache.audio.exists(id)) return true;
		}
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) return library.isLocal(symbolName,type);
	return false;
};
lime.Assets.isValidAudio = function(buffer) {
	return buffer != null;
	return true;
};
lime.Assets.isValidImage = function(buffer) {
	return true;
};
lime.Assets.list = function(type) {
	lime.Assets.initialize();
	var items = [];
	var $it0 = lime.Assets.libraries.iterator();
	while( $it0.hasNext() ) {
		var library = $it0.next();
		var libraryItems = library.list(type);
		if(libraryItems != null) items = items.concat(libraryItems);
	}
	return items;
};
lime.Assets.loadAudioBuffer = function(id,handler,useCache) {
	if(useCache == null) useCache = true;
	lime.Assets.initialize();
	if(useCache && lime.Assets.cache.enabled && lime.Assets.cache.audio.exists(id)) {
		var audio = lime.Assets.cache.audio.get(id);
		if(lime.Assets.isValidAudio(audio)) {
			handler(audio);
			return;
		}
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"SOUND")) {
			if(useCache && lime.Assets.cache.enabled) library.loadAudioBuffer(symbolName,function(audio1) {
				var value = audio1;
				lime.Assets.cache.audio.set(id,value);
				handler(audio1);
			}); else library.loadAudioBuffer(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
lime.Assets.loadBytes = function(id,handler) {
	lime.Assets.initialize();
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"BINARY")) {
			library.loadBytes(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
lime.Assets.loadImage = function(id,handler,useCache) {
	if(useCache == null) useCache = true;
	lime.Assets.initialize();
	if(useCache && lime.Assets.cache.enabled && lime.Assets.cache.image.exists(id)) {
		var image = lime.Assets.cache.image.get(id);
		if(lime.Assets.isValidImage(image)) {
			handler(image);
			return;
		}
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"IMAGE")) {
			if(useCache && lime.Assets.cache.enabled) library.loadImage(symbolName,function(image1) {
				lime.Assets.cache.image.set(id,image1);
				handler(image1);
			}); else library.loadImage(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
lime.Assets.loadLibrary = function(name,handler) {
	lime.Assets.initialize();
	var data = lime.Assets.getText("libraries/" + name + ".json");
	if(data != null && data != "") {
		var info = JSON.parse(data);
		var library = Type.createInstance(Type.resolveClass(info.type),info.args);
		lime.Assets.libraries.set(name,library);
		library.eventCallback = lime.Assets.library_onEvent;
		library.load(handler);
	} else null;
};
lime.Assets.loadText = function(id,handler) {
	lime.Assets.initialize();
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = lime.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"TEXT")) {
			library.loadText(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
lime.Assets.registerLibrary = function(name,library) {
	if(lime.Assets.libraries.exists(name)) lime.Assets.unloadLibrary(name);
	if(library != null) library.eventCallback = lime.Assets.library_onEvent;
	lime.Assets.libraries.set(name,library);
};
lime.Assets.unloadLibrary = function(name) {
	lime.Assets.initialize();
	var library = lime.Assets.libraries.get(name);
	if(library != null) {
		lime.Assets.cache.clear(name + ":");
		library.eventCallback = null;
	}
	lime.Assets.libraries.remove(name);
};
lime.Assets.library_onEvent = function(library,type) {
	if(type == "change") lime.Assets.cache.clear();
};
lime._Assets = {};
lime._Assets.AssetType_Impl_ = function() { };
$hxClasses["lime._Assets.AssetType_Impl_"] = lime._Assets.AssetType_Impl_;
lime._Assets.AssetType_Impl_.__name__ = ["lime","_Assets","AssetType_Impl_"];
lime._backend = {};
lime._backend.html5 = {};
lime._backend.html5.HTML5Application = function(parent) {
	this.parent = parent;
	lime.audio.AudioManager.init();
};
$hxClasses["lime._backend.html5.HTML5Application"] = lime._backend.html5.HTML5Application;
lime._backend.html5.HTML5Application.__name__ = ["lime","_backend","html5","HTML5Application"];
lime._backend.html5.HTML5Application.prototype = {
	convertKeyCode: function(keyCode) {
		if(keyCode >= 65 && keyCode <= 90) return keyCode + 32;
		switch(keyCode) {
		case 16:
			return 1073742049;
		case 17:
			return 1073742048;
		case 18:
			return 1073742050;
		case 20:
			return 1073741881;
		case 144:
			return 1073741907;
		case 37:
			return 1073741904;
		case 38:
			return 1073741906;
		case 39:
			return 1073741903;
		case 40:
			return 1073741905;
		case 45:
			return 1073741897;
		case 46:
			return 127;
		case 36:
			return 1073741898;
		case 35:
			return 1073741901;
		case 33:
			return 1073741899;
		case 34:
			return 1073741902;
		case 112:
			return 1073741882;
		case 113:
			return 1073741883;
		case 114:
			return 1073741884;
		case 115:
			return 1073741885;
		case 116:
			return 1073741886;
		case 117:
			return 1073741887;
		case 118:
			return 1073741888;
		case 119:
			return 1073741889;
		case 120:
			return 1073741890;
		case 121:
			return 1073741891;
		case 122:
			return 1073741892;
		case 123:
			return 1073741893;
		}
		return keyCode;
	}
	,create: function(config) {
		this.parent.config = config;
		if(config != null) {
			var $window = new lime.ui.Window(config);
			var renderer = new lime.graphics.Renderer($window);
			this.parent.addWindow($window);
			this.parent.addRenderer(renderer);
		}
	}
	,exec: function() {
		window.addEventListener("keydown",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("keyup",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("focus",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("blur",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("resize",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("beforeunload",$bind(this,this.handleWindowEvent),false);
		
			var lastTime = 0;
			var vendors = ['ms', 'moz', 'webkit', 'o'];
			for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
				window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
				window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame'] 
										   || window[vendors[x]+'CancelRequestAnimationFrame'];
			}
			
			if (!window.requestAnimationFrame)
				window.requestAnimationFrame = function(callback, element) {
					var currTime = new Date().getTime();
					var timeToCall = Math.max(0, 16 - (currTime - lastTime));
					var id = window.setTimeout(function() { callback(currTime + timeToCall); }, 
					  timeToCall);
					lastTime = currTime + timeToCall;
					return id;
				};
			
			if (!window.cancelAnimationFrame)
				window.cancelAnimationFrame = function(id) {
					clearTimeout(id);
				};
			
			window.requestAnimFrame = window.requestAnimationFrame;
		;
		this.cacheTime = new Date().getTime();
		this.handleUpdateEvent();
		return 0;
	}
	,handleKeyEvent: function(event) {
		if(this.parent.windows[0] != null) {
			var _g = event.keyCode;
			switch(_g) {
			case 32:case 37:case 38:case 39:case 40:
				event.preventDefault();
				break;
			}
			var keyCode = this.convertKeyCode(event.keyCode != null?event.keyCode:event.which);
			var modifier;
			modifier = (event.shiftKey?3:0) | (event.ctrlKey?192:0) | (event.altKey?768:0) | (event.metaKey?3072:0);
			if(event.type == "keydown") {
				var listeners = this.parent.windows[0].onKeyDown.listeners;
				var repeat = this.parent.windows[0].onKeyDown.repeat;
				var length = listeners.length;
				var i = 0;
				while(i < length) {
					listeners[i](keyCode,modifier);
					if(!repeat[i]) {
						this.parent.windows[0].onKeyDown.remove(listeners[i]);
						length--;
					} else i++;
				}
			} else {
				var listeners1 = this.parent.windows[0].onKeyUp.listeners;
				var repeat1 = this.parent.windows[0].onKeyUp.repeat;
				var length1 = listeners1.length;
				var i1 = 0;
				while(i1 < length1) {
					listeners1[i1](keyCode,modifier);
					if(!repeat1[i1]) {
						this.parent.windows[0].onKeyUp.remove(listeners1[i1]);
						length1--;
					} else i1++;
				}
			}
		}
	}
	,handleUpdateEvent: function(__) {
		var currentTime = new Date().getTime();
		var deltaTime = currentTime - this.cacheTime;
		this.cacheTime = currentTime;
		var listeners = this.parent.onUpdate.listeners;
		var repeat = this.parent.onUpdate.repeat;
		var length = listeners.length;
		var i = 0;
		while(i < length) {
			listeners[i](deltaTime | 0);
			if(!repeat[i]) {
				this.parent.onUpdate.remove(listeners[i]);
				length--;
			} else i++;
		}
		if(this.parent.renderers[0] != null) {
			if(!this.initialized) {
				this.initialized = true;
				this.parent.init(this.parent.renderers[0].context);
			}
			var listeners1 = this.parent.renderers[0].onRender.listeners;
			var repeat1 = this.parent.renderers[0].onRender.repeat;
			var length1 = listeners1.length;
			var i1 = 0;
			while(i1 < length1) {
				listeners1[i1](this.parent.renderers[0].context);
				if(!repeat1[i1]) {
					this.parent.renderers[0].onRender.remove(listeners1[i1]);
					length1--;
				} else i1++;
			}
			this.parent.renderers[0].flip();
		}
		window.requestAnimationFrame($bind(this,this.handleUpdateEvent));
	}
	,handleWindowEvent: function(event) {
		if(this.parent.windows[0] != null) {
			var _g = event.type;
			switch(_g) {
			case "focus":
				var listeners = this.parent.windows[0].onWindowFocusIn.listeners;
				var repeat = this.parent.windows[0].onWindowFocusIn.repeat;
				var length = listeners.length;
				var i = 0;
				while(i < length) {
					listeners[i]();
					if(!repeat[i]) {
						this.parent.windows[0].onWindowFocusIn.remove(listeners[i]);
						length--;
					} else i++;
				}
				var listeners1 = this.parent.windows[0].onWindowActivate.listeners;
				var repeat1 = this.parent.windows[0].onWindowActivate.repeat;
				var length1 = listeners1.length;
				var i1 = 0;
				while(i1 < length1) {
					listeners1[i1]();
					if(!repeat1[i1]) {
						this.parent.windows[0].onWindowActivate.remove(listeners1[i1]);
						length1--;
					} else i1++;
				}
				break;
			case "blur":
				var listeners2 = this.parent.windows[0].onWindowFocusOut.listeners;
				var repeat2 = this.parent.windows[0].onWindowFocusOut.repeat;
				var length2 = listeners2.length;
				var i2 = 0;
				while(i2 < length2) {
					listeners2[i2]();
					if(!repeat2[i2]) {
						this.parent.windows[0].onWindowFocusOut.remove(listeners2[i2]);
						length2--;
					} else i2++;
				}
				var listeners3 = this.parent.windows[0].onWindowDeactivate.listeners;
				var repeat3 = this.parent.windows[0].onWindowDeactivate.repeat;
				var length3 = listeners3.length;
				var i3 = 0;
				while(i3 < length3) {
					listeners3[i3]();
					if(!repeat3[i3]) {
						this.parent.windows[0].onWindowDeactivate.remove(listeners3[i3]);
						length3--;
					} else i3++;
				}
				break;
			case "resize":
				var cacheWidth = this.parent.windows[0].width;
				var cacheHeight = this.parent.windows[0].height;
				this.parent.windows[0].backend.handleResize();
				if(this.parent.windows[0].width != cacheWidth || this.parent.windows[0].height != cacheHeight) {
					var listeners4 = this.parent.windows[0].onWindowResize.listeners;
					var repeat4 = this.parent.windows[0].onWindowResize.repeat;
					var length4 = listeners4.length;
					var i4 = 0;
					while(i4 < length4) {
						listeners4[i4](this.parent.windows[0].width,this.parent.windows[0].height);
						if(!repeat4[i4]) {
							this.parent.windows[0].onWindowResize.remove(listeners4[i4]);
							length4--;
						} else i4++;
					}
				}
				break;
			case "beforeunload":
				var listeners5 = this.parent.windows[0].onWindowClose.listeners;
				var repeat5 = this.parent.windows[0].onWindowClose.repeat;
				var length5 = listeners5.length;
				var i5 = 0;
				while(i5 < length5) {
					listeners5[i5]();
					if(!repeat5[i5]) {
						this.parent.windows[0].onWindowClose.remove(listeners5[i5]);
						length5--;
					} else i5++;
				}
				break;
			}
		}
	}
	,__class__: lime._backend.html5.HTML5Application
};
lime._backend.html5.HTML5Mouse = function() { };
$hxClasses["lime._backend.html5.HTML5Mouse"] = lime._backend.html5.HTML5Mouse;
lime._backend.html5.HTML5Mouse.__name__ = ["lime","_backend","html5","HTML5Mouse"];
lime._backend.html5.HTML5Mouse.__cursor = null;
lime._backend.html5.HTML5Mouse.__hidden = null;
lime._backend.html5.HTML5Mouse.hide = function() {
	if(!lime._backend.html5.HTML5Mouse.__hidden) {
		lime._backend.html5.HTML5Mouse.__hidden = true;
		var _g = 0;
		var _g1 = lime.app.Application.current.windows;
		while(_g < _g1.length) {
			var $window = _g1[_g];
			++_g;
			$window.backend.element.style.cursor = "none";
		}
	}
};
lime._backend.html5.HTML5Mouse.show = function() {
	if(lime._backend.html5.HTML5Mouse.__hidden) {
		lime._backend.html5.HTML5Mouse.__hidden = false;
		var cacheValue = lime._backend.html5.HTML5Mouse.__cursor;
		lime._backend.html5.HTML5Mouse.__cursor = null;
		lime._backend.html5.HTML5Mouse.set_cursor(cacheValue);
	}
};
lime._backend.html5.HTML5Mouse.get_cursor = function() {
	if(lime._backend.html5.HTML5Mouse.__cursor == null) return lime.ui.MouseCursor.DEFAULT;
	return lime._backend.html5.HTML5Mouse.__cursor;
};
lime._backend.html5.HTML5Mouse.set_cursor = function(value) {
	if(lime._backend.html5.HTML5Mouse.__cursor != value) {
		if(!lime._backend.html5.HTML5Mouse.__hidden) {
			var _g = 0;
			var _g1 = lime.app.Application.current.windows;
			while(_g < _g1.length) {
				var $window = _g1[_g];
				++_g;
				switch(value[1]) {
				case 0:
					$window.backend.element.style.cursor = "default";
					break;
				case 1:
					$window.backend.element.style.cursor = "crosshair";
					break;
				case 3:
					$window.backend.element.style.cursor = "move";
					break;
				case 4:
					$window.backend.element.style.cursor = "pointer";
					break;
				case 5:
					$window.backend.element.style.cursor = "nesw-resize";
					break;
				case 6:
					$window.backend.element.style.cursor = "ns-resize";
					break;
				case 7:
					$window.backend.element.style.cursor = "nwse-resize";
					break;
				case 8:
					$window.backend.element.style.cursor = "ew-resize";
					break;
				case 9:
					$window.backend.element.style.cursor = "text";
					break;
				case 10:
					$window.backend.element.style.cursor = "wait";
					break;
				case 11:
					$window.backend.element.style.cursor = "wait";
					break;
				default:
					$window.backend.element.style.cursor = "auto";
				}
			}
		}
		lime._backend.html5.HTML5Mouse.__cursor = value;
	}
	return lime._backend.html5.HTML5Mouse.__cursor;
};
lime._backend.html5.HTML5Renderer = function(parent) {
	this.parent = parent;
};
$hxClasses["lime._backend.html5.HTML5Renderer"] = lime._backend.html5.HTML5Renderer;
lime._backend.html5.HTML5Renderer.__name__ = ["lime","_backend","html5","HTML5Renderer"];
lime._backend.html5.HTML5Renderer.prototype = {
	create: function() {
		this.createContext();
		{
			var _g = this.parent.context;
			switch(_g[1]) {
			case 0:
				this.parent.window.backend.canvas.addEventListener("webglcontextlost",$bind(this,this.handleEvent),false);
				this.parent.window.backend.canvas.addEventListener("webglcontextrestored",$bind(this,this.handleEvent),false);
				break;
			default:
			}
		}
	}
	,createContext: function() {
		if(this.parent.window.backend.div != null) this.parent.context = lime.graphics.RenderContext.DOM(this.parent.window.backend.div); else if(this.parent.window.backend.canvas != null) {
			var webgl = null;
			if(webgl == null) this.parent.context = lime.graphics.RenderContext.CANVAS(this.parent.window.backend.canvas.getContext("2d")); else {
				lime.graphics.opengl.GL.context = webgl;
				this.parent.context = lime.graphics.RenderContext.OPENGL(lime.graphics.opengl.GL.context);
			}
		}
	}
	,flip: function() {
	}
	,handleEvent: function(event) {
		var _g = event.type;
		switch(_g) {
		case "webglcontextlost":
			event.preventDefault();
			this.parent.context = null;
			var listeners = this.parent.onRenderContextLost.listeners;
			var repeat = this.parent.onRenderContextLost.repeat;
			var length = listeners.length;
			var i = 0;
			while(i < length) {
				listeners[i]();
				if(!repeat[i]) {
					this.parent.onRenderContextLost.remove(listeners[i]);
					length--;
				} else i++;
			}
			break;
		case "webglcontextrestored":
			this.createContext();
			var listeners1 = this.parent.onRenderContextRestored.listeners;
			var repeat1 = this.parent.onRenderContextRestored.repeat;
			var length1 = listeners1.length;
			var i1 = 0;
			while(i1 < length1) {
				listeners1[i1](this.parent.context);
				if(!repeat1[i1]) {
					this.parent.onRenderContextRestored.remove(listeners1[i1]);
					length1--;
				} else i1++;
			}
			break;
		default:
		}
	}
	,render: function() {
	}
	,__class__: lime._backend.html5.HTML5Renderer
};
lime._backend.html5.HTML5Window = function(parent) {
	this.parent = parent;
	if(parent.config != null && Object.prototype.hasOwnProperty.call(parent.config,"element")) this.element = parent.config.element;
};
$hxClasses["lime._backend.html5.HTML5Window"] = lime._backend.html5.HTML5Window;
lime._backend.html5.HTML5Window.__name__ = ["lime","_backend","html5","HTML5Window"];
lime._backend.html5.HTML5Window.prototype = {
	close: function() {
	}
	,create: function(application) {
		this.setWidth = this.parent.width;
		this.setHeight = this.parent.height;
		if(js.Boot.__instanceof(this.element,HTMLCanvasElement)) this.canvas = this.element; else this.canvas = window.document.createElement("canvas");
		if(this.canvas != null) {
			var style = this.canvas.style;
			style.setProperty("-webkit-transform","translateZ(0)",null);
			style.setProperty("transform","translateZ(0)",null);
		} else if(this.div != null) {
			var style1 = this.div.style;
			style1.setProperty("-webkit-transform","translate3D(0,0,0)",null);
			style1.setProperty("transform","translate3D(0,0,0)",null);
			style1.position = "relative";
			style1.overflow = "hidden";
			style1.setProperty("-webkit-user-select","none",null);
			style1.setProperty("-moz-user-select","none",null);
			style1.setProperty("-ms-user-select","none",null);
			style1.setProperty("-o-user-select","none",null);
		}
		if(this.parent.width == 0 && this.parent.height == 0) {
			if(this.element != null) {
				this.parent.width = this.element.clientWidth;
				this.parent.height = this.element.clientHeight;
			} else {
				this.parent.width = window.innerWidth;
				this.parent.height = window.innerHeight;
			}
			this.parent.fullscreen = true;
		}
		if(this.canvas != null) {
			this.canvas.width = this.parent.width;
			this.canvas.height = this.parent.height;
		} else {
			this.div.style.width = this.parent.width + "px";
			this.div.style.height = this.parent.height + "px";
		}
		this.handleResize();
		if(this.element != null) {
			if(this.canvas != null) {
				if(this.element != this.canvas) this.element.appendChild(this.canvas);
			} else this.element.appendChild(this.div);
			var events = ["mousedown","mousemove","mouseup","wheel"];
			var standardTouch = typeof(window.ontouchstart) != "undefined";
			if(!standardTouch) {
				var _g = 0;
				while(_g < events.length) {
					var event = events[_g];
					++_g;
					this.element.addEventListener(event,$bind(this,this.handleMouseEvent),true);
				}
			}
			window.document.addEventListener("dragstart",function(e) {
				if(e.target.nodeName.toLowerCase() == "img") {
					e.preventDefault();
					return false;
				}
				return true;
			},false);
			this.element.addEventListener("touchstart",$bind(this,this.handleTouchEvent),true);
			this.element.addEventListener("touchmove",$bind(this,this.handleTouchEvent),true);
			this.element.addEventListener("touchend",$bind(this,this.handleTouchEvent),true);
		}
	}
	,handleMouseEvent: function(event) {
		var x = 0.0;
		var y = 0.0;
		if(event.type != "wheel") {
			if(this.element != null) {
				if(this.canvas != null) {
					var rect = this.canvas.getBoundingClientRect();
					x = (event.clientX - rect.left) * (this.parent.width / rect.width);
					y = (event.clientY - rect.top) * (this.parent.height / rect.height);
				} else if(this.div != null) {
					var rect1 = this.div.getBoundingClientRect();
					x = event.clientX - rect1.left;
					y = event.clientY - rect1.top;
				} else {
					var rect2 = this.element.getBoundingClientRect();
					x = (event.clientX - rect2.left) * (this.parent.width / rect2.width);
					y = (event.clientY - rect2.top) * (this.parent.height / rect2.height);
				}
			} else {
				x = event.clientX;
				y = event.clientY;
			}
			var _g = event.type;
			switch(_g) {
			case "mousedown":
				var listeners = this.parent.onMouseDown.listeners;
				var repeat = this.parent.onMouseDown.repeat;
				var length = listeners.length;
				var i = 0;
				while(i < length) {
					listeners[i](x,y,event.button);
					if(!repeat[i]) {
						this.parent.onMouseDown.remove(listeners[i]);
						length--;
					} else i++;
				}
				break;
			case "mouseup":
				var listeners1 = this.parent.onMouseUp.listeners;
				var repeat1 = this.parent.onMouseUp.repeat;
				var length1 = listeners1.length;
				var i1 = 0;
				while(i1 < length1) {
					listeners1[i1](x,y,event.button);
					if(!repeat1[i1]) {
						this.parent.onMouseUp.remove(listeners1[i1]);
						length1--;
					} else i1++;
				}
				break;
			case "mousemove":
				var listeners2 = this.parent.onMouseMove.listeners;
				var repeat2 = this.parent.onMouseMove.repeat;
				var length2 = listeners2.length;
				var i2 = 0;
				while(i2 < length2) {
					listeners2[i2](x,y,event.button);
					if(!repeat2[i2]) {
						this.parent.onMouseMove.remove(listeners2[i2]);
						length2--;
					} else i2++;
				}
				break;
			default:
			}
		} else {
			var listeners3 = this.parent.onMouseWheel.listeners;
			var repeat3 = this.parent.onMouseWheel.repeat;
			var length3 = listeners3.length;
			var i3 = 0;
			while(i3 < length3) {
				listeners3[i3](event.deltaX,event.deltaY);
				if(!repeat3[i3]) {
					this.parent.onMouseWheel.remove(listeners3[i3]);
					length3--;
				} else i3++;
			}
		}
	}
	,handleResize: function() {
		var stretch = this.parent.fullscreen || this.setWidth == 0 && this.setHeight == 0;
		if(this.element != null && (this.div == null || this.div != null && stretch)) {
			if(stretch) {
				if(this.parent.width != this.element.clientWidth || this.parent.height != this.element.clientHeight) {
					this.parent.width = this.element.clientWidth;
					this.parent.height = this.element.clientHeight;
					if(this.canvas != null) {
						if(this.element != this.canvas) {
							this.canvas.width = this.element.clientWidth;
							this.canvas.height = this.element.clientHeight;
						}
					} else {
						this.div.style.width = this.element.clientWidth + "px";
						this.div.style.height = this.element.clientHeight + "px";
					}
				}
			} else {
				var scaleX = this.element.clientWidth / this.setWidth;
				var scaleY = this.element.clientHeight / this.setHeight;
				var currentRatio = scaleX / scaleY;
				var targetRatio = Math.min(scaleX,scaleY);
				if(this.canvas != null) {
					if(this.element != this.canvas) {
						this.canvas.style.width = this.setWidth * targetRatio + "px";
						this.canvas.style.height = this.setHeight * targetRatio + "px";
						this.canvas.style.marginLeft = (this.element.clientWidth - this.setWidth * targetRatio) / 2 + "px";
						this.canvas.style.marginTop = (this.element.clientHeight - this.setHeight * targetRatio) / 2 + "px";
					}
				} else {
					this.div.style.width = this.setWidth * targetRatio + "px";
					this.div.style.height = this.setHeight * targetRatio + "px";
					this.div.style.marginLeft = (this.element.clientWidth - this.setWidth * targetRatio) / 2 + "px";
					this.div.style.marginTop = (this.element.clientHeight - this.setHeight * targetRatio) / 2 + "px";
				}
			}
		}
	}
	,handleTouchEvent: function(event) {
		event.preventDefault();
		var touch = event.changedTouches[0];
		var id = touch.identifier;
		var x = 0.0;
		var y = 0.0;
		if(this.element != null) {
			if(this.canvas != null) {
				var rect = this.canvas.getBoundingClientRect();
				x = (touch.clientX - rect.left) * (this.parent.width / rect.width);
				y = (touch.clientY - rect.top) * (this.parent.height / rect.height);
			} else if(this.div != null) {
				var rect1 = this.div.getBoundingClientRect();
				x = touch.clientX - rect1.left;
				y = touch.clientY - rect1.top;
			} else {
				var rect2 = this.element.getBoundingClientRect();
				x = (touch.clientX - rect2.left) * (this.parent.width / rect2.width);
				y = (touch.clientY - rect2.top) * (this.parent.height / rect2.height);
			}
		} else {
			x = touch.clientX;
			y = touch.clientY;
		}
		var _g = event.type;
		switch(_g) {
		case "touchstart":
			var listeners = this.parent.onTouchStart.listeners;
			var repeat = this.parent.onTouchStart.repeat;
			var length = listeners.length;
			var i = 0;
			while(i < length) {
				listeners[i](x,y,id);
				if(!repeat[i]) {
					this.parent.onTouchStart.remove(listeners[i]);
					length--;
				} else i++;
			}
			break;
		case "touchmove":
			var listeners1 = this.parent.onTouchMove.listeners;
			var repeat1 = this.parent.onTouchMove.repeat;
			var length1 = listeners1.length;
			var i1 = 0;
			while(i1 < length1) {
				listeners1[i1](x,y,id);
				if(!repeat1[i1]) {
					this.parent.onTouchMove.remove(listeners1[i1]);
					length1--;
				} else i1++;
			}
			break;
		case "touchend":
			var listeners2 = this.parent.onTouchEnd.listeners;
			var repeat2 = this.parent.onTouchEnd.repeat;
			var length2 = listeners2.length;
			var i2 = 0;
			while(i2 < length2) {
				listeners2[i2](x,y,id);
				if(!repeat2[i2]) {
					this.parent.onTouchEnd.remove(listeners2[i2]);
					length2--;
				} else i2++;
			}
			break;
		default:
		}
	}
	,move: function(x,y) {
	}
	,resize: function(width,height) {
	}
	,setIcon: function(image) {
	}
	,__class__: lime._backend.html5.HTML5Window
};
lime.app = {};
lime.app.Module = function() {
};
$hxClasses["lime.app.Module"] = lime.app.Module;
lime.app.Module.__name__ = ["lime","app","Module"];
lime.app.Module.prototype = {
	__class__: lime.app.Module
};
lime.app.Application = function() {
	this.onUpdate = new lime.app.Event();
	lime.app.Module.call(this);
	if(lime.app.Application.current == null) lime.app.Application.current = this;
	this.renderers = new Array();
	this.windows = new Array();
	this.backend = new lime._backend.html5.HTML5Application(this);
	this.onUpdate.add($bind(this,this.update));
};
$hxClasses["lime.app.Application"] = lime.app.Application;
lime.app.Application.__name__ = ["lime","app","Application"];
lime.app.Application.current = null;
lime.app.Application.__super__ = lime.app.Module;
lime.app.Application.prototype = $extend(lime.app.Module.prototype,{
	addRenderer: function(renderer) {
		renderer.onRender.add($bind(this,this.render));
		renderer.onRenderContextLost.add($bind(this,this.onRenderContextLost));
		renderer.onRenderContextRestored.add($bind(this,this.onRenderContextRestored));
		this.renderers.push(renderer);
	}
	,addWindow: function(window) {
		this.windows.push(window);
		window.onKeyDown.add($bind(this,this.onKeyDown));
		window.onKeyUp.add($bind(this,this.onKeyUp));
		window.onMouseDown.add($bind(this,this.onMouseDown));
		window.onMouseMove.add($bind(this,this.onMouseMove));
		window.onMouseUp.add($bind(this,this.onMouseUp));
		window.onMouseWheel.add($bind(this,this.onMouseWheel));
		window.onTouchStart.add($bind(this,this.onTouchStart));
		window.onTouchMove.add($bind(this,this.onTouchMove));
		window.onTouchEnd.add($bind(this,this.onTouchEnd));
		window.onWindowActivate.add($bind(this,this.onWindowActivate));
		window.onWindowClose.add($bind(this,this.onWindowClose));
		window.onWindowDeactivate.add($bind(this,this.onWindowDeactivate));
		window.onWindowFocusIn.add($bind(this,this.onWindowFocusIn));
		window.onWindowFocusOut.add($bind(this,this.onWindowFocusOut));
		window.onWindowMove.add($bind(this,this.onWindowMove));
		window.onWindowResize.add($bind(this,this.onWindowResize));
		window.create(this);
	}
	,create: function(config) {
		this.backend.create(config);
	}
	,exec: function() {
		lime.app.Application.current = this;
		return this.backend.exec();
	}
	,init: function(context) {
	}
	,onKeyDown: function(keyCode,modifier) {
	}
	,onKeyUp: function(keyCode,modifier) {
	}
	,onMouseDown: function(x,y,button) {
	}
	,onMouseMove: function(x,y,button) {
	}
	,onMouseUp: function(x,y,button) {
	}
	,onMouseWheel: function(deltaX,deltaY) {
	}
	,onRenderContextLost: function() {
	}
	,onRenderContextRestored: function(context) {
	}
	,onTouchEnd: function(x,y,id) {
	}
	,onTouchMove: function(x,y,id) {
	}
	,onTouchStart: function(x,y,id) {
	}
	,onWindowActivate: function() {
	}
	,onWindowClose: function() {
	}
	,onWindowDeactivate: function() {
	}
	,onWindowFocusIn: function() {
	}
	,onWindowFocusOut: function() {
	}
	,onWindowMove: function(x,y) {
	}
	,onWindowResize: function(width,height) {
	}
	,removeRenderer: function(renderer) {
		if(renderer != null && HxOverrides.indexOf(this.renderers,renderer,0) > -1) HxOverrides.remove(this.renderers,renderer);
	}
	,removeWindow: function(window) {
		if(window != null && HxOverrides.indexOf(this.windows,window,0) > -1) {
			window.close();
			HxOverrides.remove(this.windows,window);
		}
	}
	,render: function(context) {
	}
	,update: function(deltaTime) {
	}
	,get_renderer: function() {
		return this.renderers[0];
	}
	,get_window: function() {
		return this.windows[0];
	}
	,__class__: lime.app.Application
	,__properties__: {get_window:"get_window",get_renderer:"get_renderer"}
});
lime.app.Event = function() {
	this.listeners = new Array();
	this.priorities = new Array();
	this.repeat = new Array();
};
$hxClasses["lime.app.Event"] = lime.app.Event;
lime.app.Event.__name__ = ["lime","app","Event"];
lime.app.Event.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) priority = 0;
		if(once == null) once = false;
		var _g1 = 0;
		var _g = this.priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.priorities[i]) {
				this.listeners.splice(i,0,listener);
				this.priorities.splice(i,0,priority);
				this.repeat.splice(i,0,!once);
				return;
			}
		}
		this.listeners.push(listener);
		this.priorities.push(priority);
		this.repeat.push(!once);
	}
	,remove: function(listener) {
		var index = HxOverrides.indexOf(this.listeners,listener,0);
		if(index > -1) {
			this.listeners.splice(index,1);
			this.priorities.splice(index,1);
			this.repeat.splice(index,1);
		}
	}
	,__class__: lime.app.Event
};
lime.app.Preloader = function() {
	this.total = 0;
	this.loaded = 0;
};
$hxClasses["lime.app.Preloader"] = lime.app.Preloader;
lime.app.Preloader.__name__ = ["lime","app","Preloader"];
lime.app.Preloader.prototype = {
	create: function(config) {
	}
	,load: function(urls,types) {
		var url = null;
		var _g1 = 0;
		var _g = urls.length;
		while(_g1 < _g) {
			var i = _g1++;
			url = urls[i];
			var _g2 = types[i];
			switch(_g2) {
			case "IMAGE":
				var image = new Image();
				lime.app.Preloader.images.set(url,image);
				image.onload = $bind(this,this.image_onLoad);
				image.onerror = $bind(this,this.handleLoadError);
				image.src = url + "?ver=" + GlobalVars.gameVersion;
				this.total++;
				break;
			case "BINARY":
				var loader = new lime.net.URLLoader();
				loader.set_dataFormat(lime.net.URLLoaderDataFormat.BINARY);
				lime.app.Preloader.loaders.set(url,loader);
				this.total++;
				break;
			case "TEXT":
				var urlLoader = { };
				urlLoader.dataFormat = openfl.net.URLLoaderDataFormat.BINARY;
				urlLoader.data = ApplicationMain.embeddedFiles.shift();
				var value = urlLoader;
				lime.app.Preloader.loaders.set(url,value);
				this.total++;
				break;
			case "FONT":
				this.total++;
				this.loadFont(url);
				break;
			default:
			}
		}
		var $it0 = lime.app.Preloader.loaders.keys();
		while( $it0.hasNext() ) {
			var url1 = $it0.next();
			var loader1 = lime.app.Preloader.loaders.get(url1);
			if(loader1.data == null) {
				loader1.onComplete.add($bind(this,this.loader_onComplete));
				loader1.load(new lime.net.URLRequest(url1));
			} else this.loader_onComplete(null);
		}
		if(this.total == 0) this.start();
	}
	,loadFont: function(font) {
		var _g = this;
		if(window.document.fonts && window.document.fonts.load) window.document.fonts.load("1em '" + font + "'").then(function() {
			_g.loaded++;
			_g.update(_g.loaded,_g.total);
			if(_g.loaded == _g.total) _g.start();
		}); else {
			var node = window.document.createElement("span");
			node.innerHTML = "giItT1WQy@!-/#";
			var style = node.style;
			style.position = "absolute";
			style.left = "-10000px";
			style.top = "-10000px";
			style.fontSize = "300px";
			style.fontFamily = "sans-serif";
			style.fontVariant = "normal";
			style.fontStyle = "normal";
			style.fontWeight = "normal";
			style.letterSpacing = "0";
			window.document.body.appendChild(node);
			var width = node.offsetWidth;
			style.fontFamily = "'" + font + "', sans-serif";
			var interval = null;
			var found = false;
			var checkFont = function() {
				if(node.offsetWidth != width) {
					if(!found) {
						found = true;
						return false;
					}
					_g.loaded++;
					if(interval != null) window.clearInterval(interval);
					node.parentNode.removeChild(node);
					node = null;
					_g.update(_g.loaded,_g.total);
					if(_g.loaded == _g.total) _g.start();
					return true;
				}
				return false;
			};
			if(!checkFont()) interval = window.setInterval(checkFont,50);
		}
	}
	,start: function() {
		if(this.onComplete != null) this.onComplete();
	}
	,update: function(loaded,total) {
	}
	,image_onLoad: function(_) {
		this.loaded++;
		this.update(this.loaded,this.total);
		if(this.loaded == this.total) this.start();
	}
	,handleLoadError: function(e) {
		var target = e.target;
		var src = target.src;
		window.setTimeout(function() {
			target.src = src;
		},2000);
	}
	,loader_onComplete: function(loader) {
		this.loaded++;
		this.update(this.loaded,this.total);
		if(this.loaded == this.total) this.start();
	}
	,__class__: lime.app.Preloader
};
lime.audio = {};
lime.audio.ALAudioContext = function() {
	this.EXPONENT_DISTANCE_CLAMPED = 53254;
	this.EXPONENT_DISTANCE = 53253;
	this.LINEAR_DISTANCE_CLAMPED = 53252;
	this.LINEAR_DISTANCE = 53251;
	this.INVERSE_DISTANCE_CLAMPED = 53250;
	this.INVERSE_DISTANCE = 53249;
	this.DISTANCE_MODEL = 53248;
	this.DOPPLER_VELOCITY = 49153;
	this.SPEED_OF_SOUND = 49155;
	this.DOPPLER_FACTOR = 49152;
	this.EXTENSIONS = 45060;
	this.RENDERER = 45059;
	this.VERSION = 45058;
	this.VENDOR = 45057;
	this.OUT_OF_MEMORY = 40965;
	this.INVALID_OPERATION = 40964;
	this.INVALID_VALUE = 40963;
	this.INVALID_ENUM = 40962;
	this.INVALID_NAME = 40961;
	this.NO_ERROR = 0;
	this.SIZE = 8196;
	this.CHANNELS = 8195;
	this.BITS = 8194;
	this.FREQUENCY = 8193;
	this.FORMAT_STEREO16 = 4355;
	this.FORMAT_STEREO8 = 4354;
	this.FORMAT_MONO16 = 4353;
	this.FORMAT_MONO8 = 4352;
	this.UNDETERMINED = 4144;
	this.STREAMING = 4137;
	this.STATIC = 4136;
	this.SOURCE_TYPE = 4135;
	this.BYTE_OFFSET = 4134;
	this.SAMPLE_OFFSET = 4133;
	this.SEC_OFFSET = 4132;
	this.MAX_DISTANCE = 4131;
	this.CONE_OUTER_GAIN = 4130;
	this.ROLLOFF_FACTOR = 4129;
	this.REFERENCE_DISTANCE = 4128;
	this.BUFFERS_PROCESSED = 4118;
	this.BUFFERS_QUEUED = 4117;
	this.STOPPED = 4116;
	this.PAUSED = 4115;
	this.PLAYING = 4114;
	this.INITIAL = 4113;
	this.SOURCE_STATE = 4112;
	this.ORIENTATION = 4111;
	this.MAX_GAIN = 4110;
	this.MIN_GAIN = 4109;
	this.GAIN = 4106;
	this.BUFFER = 4105;
	this.LOOPING = 4103;
	this.VELOCITY = 4102;
	this.DIRECTION = 4101;
	this.POSITION = 4100;
	this.PITCH = 4099;
	this.CONE_OUTER_ANGLE = 4098;
	this.CONE_INNER_ANGLE = 4097;
	this.SOURCE_RELATIVE = 514;
	this.TRUE = 1;
	this.FALSE = 0;
	this.NONE = 0;
};
$hxClasses["lime.audio.ALAudioContext"] = lime.audio.ALAudioContext;
lime.audio.ALAudioContext.__name__ = ["lime","audio","ALAudioContext"];
lime.audio.ALAudioContext.prototype = {
	bufferData: function(buffer,format,data,size,freq) {
		lime.audio.openal.AL.bufferData(buffer,format,data,size,freq);
	}
	,buffer3f: function(buffer,param,value1,value2,value3) {
		lime.audio.openal.AL.buffer3f(buffer,param,value1,value2,value3);
	}
	,buffer3i: function(buffer,param,value1,value2,value3) {
		lime.audio.openal.AL.buffer3i(buffer,param,value1,value2,value3);
	}
	,bufferf: function(buffer,param,value) {
		lime.audio.openal.AL.bufferf(buffer,param,value);
	}
	,bufferfv: function(buffer,param,values) {
		lime.audio.openal.AL.bufferfv(buffer,param,values);
	}
	,bufferi: function(buffer,param,value) {
		lime.audio.openal.AL.bufferi(buffer,param,value);
	}
	,bufferiv: function(buffer,param,values) {
		lime.audio.openal.AL.bufferiv(buffer,param,values);
	}
	,deleteBuffer: function(buffer) {
		lime.audio.openal.AL.deleteBuffer(buffer);
	}
	,deleteBuffers: function(buffers) {
		lime.audio.openal.AL.deleteBuffers(buffers);
	}
	,deleteSource: function(source) {
		lime.audio.openal.AL.deleteSource(source);
	}
	,deleteSources: function(sources) {
		lime.audio.openal.AL.deleteSources(sources);
	}
	,disable: function(capability) {
		lime.audio.openal.AL.disable(capability);
	}
	,distanceModel: function(distanceModel) {
		lime.audio.openal.AL.distanceModel(distanceModel);
	}
	,dopplerFactor: function(value) {
		lime.audio.openal.AL.dopplerFactor(value);
	}
	,dopplerVelocity: function(value) {
		lime.audio.openal.AL.dopplerVelocity(value);
	}
	,enable: function(capability) {
		lime.audio.openal.AL.enable(capability);
	}
	,genSource: function() {
		return lime.audio.openal.AL.genSource();
	}
	,genSources: function(n) {
		return lime.audio.openal.AL.genSources(n);
	}
	,genBuffer: function() {
		return lime.audio.openal.AL.genBuffer();
	}
	,genBuffers: function(n) {
		return lime.audio.openal.AL.genBuffers(n);
	}
	,getBoolean: function(param) {
		return lime.audio.openal.AL.getBoolean(param);
	}
	,getBooleanv: function(param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getBooleanv(param,count);
	}
	,getBuffer3f: function(buffer,param) {
		return lime.audio.openal.AL.getBuffer3f(buffer,param);
	}
	,getBuffer3i: function(buffer,param) {
		return lime.audio.openal.AL.getBuffer3i(buffer,param);
	}
	,getBufferf: function(buffer,param) {
		return lime.audio.openal.AL.getBufferf(buffer,param);
	}
	,getBufferfv: function(buffer,param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getBufferfv(buffer,param,count);
	}
	,getBufferi: function(buffer,param) {
		return lime.audio.openal.AL.getBufferi(buffer,param);
	}
	,getBufferiv: function(buffer,param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getBufferiv(buffer,param,count);
	}
	,getDouble: function(param) {
		return lime.audio.openal.AL.getDouble(param);
	}
	,getDoublev: function(param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getDoublev(param,count);
	}
	,getEnumValue: function(ename) {
		return lime.audio.openal.AL.getEnumValue(ename);
	}
	,getError: function() {
		return lime.audio.openal.AL.getError();
	}
	,getErrorString: function() {
		return lime.audio.openal.AL.getErrorString();
	}
	,getFloat: function(param) {
		return lime.audio.openal.AL.getFloat(param);
	}
	,getFloatv: function(param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getFloatv(param,count);
	}
	,getInteger: function(param) {
		return lime.audio.openal.AL.getInteger(param);
	}
	,getIntegerv: function(param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getIntegerv(param,count);
	}
	,getListener3f: function(param) {
		return lime.audio.openal.AL.getListener3f(param);
	}
	,getListener3i: function(param) {
		return lime.audio.openal.AL.getListener3i(param);
	}
	,getListenerf: function(param) {
		return lime.audio.openal.AL.getListenerf(param);
	}
	,getListenerfv: function(param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getListenerfv(param,count);
	}
	,getListeneri: function(param) {
		return lime.audio.openal.AL.getListeneri(param);
	}
	,getListeneriv: function(param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getListeneriv(param,count);
	}
	,getProcAddress: function(fname) {
		return lime.audio.openal.AL.getProcAddress(fname);
	}
	,getSource3f: function(source,param) {
		return lime.audio.openal.AL.getSource3f(source,param);
	}
	,getSourcef: function(source,param) {
		return lime.audio.openal.AL.getSourcef(source,param);
	}
	,getSource3i: function(source,param) {
		return lime.audio.openal.AL.getSource3i(source,param);
	}
	,getSourcefv: function(source,param) {
		return lime.audio.openal.AL.getSourcefv(source,param);
	}
	,getSourcei: function(source,param) {
		return lime.audio.openal.AL.getSourcei(source,param);
	}
	,getSourceiv: function(source,param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.AL.getSourceiv(source,param,count);
	}
	,getString: function(param) {
		return lime.audio.openal.AL.getString(param);
	}
	,isBuffer: function(buffer) {
		return lime.audio.openal.AL.isBuffer(buffer);
	}
	,isEnabled: function(capability) {
		return lime.audio.openal.AL.isEnabled(capability);
	}
	,isExtensionPresent: function(extname) {
		return lime.audio.openal.AL.isExtensionPresent(extname);
	}
	,isSource: function(source) {
		return lime.audio.openal.AL.isSource(source);
	}
	,listener3f: function(param,value1,value2,value3) {
		lime.audio.openal.AL.listener3f(param,value1,value2,value3);
	}
	,listener3i: function(param,value1,value2,value3) {
		lime.audio.openal.AL.listener3i(param,value1,value2,value3);
	}
	,listenerf: function(param,value) {
		lime.audio.openal.AL.listenerf(param,value);
	}
	,listenerfv: function(param,values) {
		lime.audio.openal.AL.listenerfv(param,values);
	}
	,listeneri: function(param,value) {
		lime.audio.openal.AL.listeneri(param,value);
	}
	,listeneriv: function(param,values) {
		lime.audio.openal.AL.listeneriv(param,values);
	}
	,source3f: function(source,param,value1,value2,value3) {
		lime.audio.openal.AL.source3f(source,param,value1,value2,value3);
	}
	,source3i: function(source,param,value1,value2,value3) {
		lime.audio.openal.AL.source3i(source,param,value1,value2,value3);
	}
	,sourcef: function(source,param,value) {
		lime.audio.openal.AL.sourcef(source,param,value);
	}
	,sourcefv: function(source,param,values) {
		lime.audio.openal.AL.sourcefv(source,param,values);
	}
	,sourcei: function(source,param,value) {
		lime.audio.openal.AL.sourcei(source,param,value);
	}
	,sourceiv: function(source,param,values) {
		lime.audio.openal.AL.sourceiv(source,param,values);
	}
	,sourcePlay: function(source) {
		lime.audio.openal.AL.sourcePlay(source);
	}
	,sourcePlayv: function(sources) {
		lime.audio.openal.AL.sourcePlayv(sources);
	}
	,sourceStop: function(source) {
		lime.audio.openal.AL.sourceStop(source);
	}
	,sourceStopv: function(sources) {
		lime.audio.openal.AL.sourceStopv(sources);
	}
	,sourceRewind: function(source) {
		lime.audio.openal.AL.sourceRewind(source);
	}
	,sourceRewindv: function(sources) {
		lime.audio.openal.AL.sourceRewindv(sources);
	}
	,sourcePause: function(source) {
		lime.audio.openal.AL.sourcePause(source);
	}
	,sourcePausev: function(sources) {
		lime.audio.openal.AL.sourcePausev(sources);
	}
	,sourceQueueBuffer: function(source,buffer) {
		lime.audio.openal.AL.sourceQueueBuffer(source,buffer);
	}
	,sourceQueueBuffers: function(source,nb,buffers) {
		lime.audio.openal.AL.sourceQueueBuffers(source,nb,buffers);
	}
	,sourceUnqueueBuffer: function(source) {
		return lime.audio.openal.AL.sourceUnqueueBuffer(source);
	}
	,sourceUnqueueBuffers: function(source,nb) {
		return lime.audio.openal.AL.sourceUnqueueBuffers(source,nb);
	}
	,speedOfSound: function(value) {
		lime.audio.openal.AL.speedOfSound(value);
	}
	,__class__: lime.audio.ALAudioContext
};
lime.audio.ALCAudioContext = function() {
	this.ALL_DEVICES_SPECIFIER = 4115;
	this.DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
	this.ENUMERATE_ALL_EXT = 1;
	this.EXTENSIONS = 4102;
	this.DEVICE_SPECIFIER = 4101;
	this.DEFAULT_DEVICE_SPECIFIER = 4100;
	this.ALL_ATTRIBUTES = 4099;
	this.ATTRIBUTES_SIZE = 4098;
	this.OUT_OF_MEMORY = 40965;
	this.INVALID_VALUE = 40964;
	this.INVALID_ENUM = 40963;
	this.INVALID_CONTEXT = 40962;
	this.INVALID_DEVICE = 40961;
	this.NO_ERROR = 0;
	this.STEREO_SOURCES = 4113;
	this.MONO_SOURCES = 4112;
	this.SYNC = 4105;
	this.REFRESH = 4104;
	this.FREQUENCY = 4103;
	this.TRUE = 1;
	this.FALSE = 0;
};
$hxClasses["lime.audio.ALCAudioContext"] = lime.audio.ALCAudioContext;
lime.audio.ALCAudioContext.__name__ = ["lime","audio","ALCAudioContext"];
lime.audio.ALCAudioContext.prototype = {
	closeDevice: function(device) {
		return lime.audio.openal.ALC.closeDevice(device);
	}
	,createContext: function(device,attrlist) {
		return lime.audio.openal.ALC.createContext(device,attrlist);
	}
	,destroyContext: function(context) {
		lime.audio.openal.ALC.destroyContext(context);
	}
	,getContextsDevice: function(context) {
		return lime.audio.openal.ALC.getContextsDevice(context);
	}
	,getCurrentContext: function() {
		return lime.audio.openal.ALC.getCurrentContext();
	}
	,getError: function(device) {
		return lime.audio.openal.ALC.getError(device);
	}
	,getErrorString: function(device) {
		return lime.audio.openal.ALC.getErrorString(device);
	}
	,getIntegerv: function(device,param,count) {
		if(count == null) count = 1;
		return lime.audio.openal.ALC.getIntegerv(device,param,count);
	}
	,getString: function(device,param) {
		return lime.audio.openal.ALC.getString(device,param);
	}
	,makeContextCurrent: function(context) {
		return lime.audio.openal.ALC.makeContextCurrent(context);
	}
	,openDevice: function(deviceName) {
		return lime.audio.openal.ALC.openDevice(deviceName);
	}
	,processContext: function(context) {
		lime.audio.openal.ALC.processContext(context);
	}
	,suspendContext: function(context) {
		lime.audio.openal.ALC.suspendContext(context);
	}
	,__class__: lime.audio.ALCAudioContext
};
lime.audio.AudioBuffer = function() {
	this.id = 0;
};
$hxClasses["lime.audio.AudioBuffer"] = lime.audio.AudioBuffer;
lime.audio.AudioBuffer.__name__ = ["lime","audio","AudioBuffer"];
lime.audio.AudioBuffer.fromBytes = function(bytes) {
	return null;
};
lime.audio.AudioBuffer.fromFile = function(path) {
	return null;
};
lime.audio.AudioBuffer.fromURL = function(url,handler) {
};
lime.audio.AudioBuffer.prototype = {
	dispose: function() {
	}
	,__class__: lime.audio.AudioBuffer
};
lime.audio.AudioContext = $hxClasses["lime.audio.AudioContext"] = { __ename__ : ["lime","audio","AudioContext"], __constructs__ : ["OPENAL","HTML5","WEB","FLASH","CUSTOM"] };
lime.audio.AudioContext.OPENAL = function(alc,al) { var $x = ["OPENAL",0,alc,al]; $x.__enum__ = lime.audio.AudioContext; $x.toString = $estr; return $x; };
lime.audio.AudioContext.HTML5 = function(context) { var $x = ["HTML5",1,context]; $x.__enum__ = lime.audio.AudioContext; $x.toString = $estr; return $x; };
lime.audio.AudioContext.WEB = function(context) { var $x = ["WEB",2,context]; $x.__enum__ = lime.audio.AudioContext; $x.toString = $estr; return $x; };
lime.audio.AudioContext.FLASH = function(context) { var $x = ["FLASH",3,context]; $x.__enum__ = lime.audio.AudioContext; $x.toString = $estr; return $x; };
lime.audio.AudioContext.CUSTOM = function(data) { var $x = ["CUSTOM",4,data]; $x.__enum__ = lime.audio.AudioContext; $x.toString = $estr; return $x; };
lime.audio.AudioManager = function() { };
$hxClasses["lime.audio.AudioManager"] = lime.audio.AudioManager;
lime.audio.AudioManager.__name__ = ["lime","audio","AudioManager"];
lime.audio.AudioManager.context = null;
lime.audio.AudioManager.init = function(context) {
	if(lime.audio.AudioManager.context == null) {
		if(context == null) try {
			window.AudioContext = window.AudioContext || window.webkitAudioContext;;
			lime.audio.AudioManager.context = lime.audio.AudioContext.WEB(new AudioContext ());
		} catch( e ) {
			lime.audio.AudioManager.context = lime.audio.AudioContext.HTML5(new lime.audio.HTML5AudioContext());
		} else lime.audio.AudioManager.context = context;
	}
};
lime.audio.AudioManager.resume = function() {
	if(lime.audio.AudioManager.context != null) {
		var _g = lime.audio.AudioManager.context;
		switch(_g[1]) {
		case 0:
			var al = _g[3];
			var alc = _g[2];
			alc.processContext(alc.getCurrentContext());
			break;
		default:
		}
	}
};
lime.audio.AudioManager.shutdown = function() {
	if(lime.audio.AudioManager.context != null) {
		var _g = lime.audio.AudioManager.context;
		switch(_g[1]) {
		case 0:
			var al = _g[3];
			var alc = _g[2];
			var currentContext = alc.getCurrentContext();
			if(currentContext != null) {
				var device = alc.getContextsDevice(currentContext);
				alc.makeContextCurrent(null);
				alc.destroyContext(currentContext);
				alc.closeDevice(device);
			}
			break;
		default:
		}
	}
};
lime.audio.AudioManager.suspend = function() {
	if(lime.audio.AudioManager.context != null) {
		var _g = lime.audio.AudioManager.context;
		switch(_g[1]) {
		case 0:
			var al = _g[3];
			var alc = _g[2];
			alc.suspendContext(alc.getCurrentContext());
			break;
		default:
		}
	}
};
lime.audio.AudioSource = function(buffer) {
	this.onComplete = new lime.app.Event();
	this.buffer = buffer;
	this.id = 0;
	this.pauseTime = 0;
	if(buffer != null) this.init();
};
$hxClasses["lime.audio.AudioSource"] = lime.audio.AudioSource;
lime.audio.AudioSource.__name__ = ["lime","audio","AudioSource"];
lime.audio.AudioSource.prototype = {
	init: function() {
		{
			var _g = lime.audio.AudioManager.context;
			switch(_g[1]) {
			case 0:
				var al = _g[3];
				var alc = _g[2];
				if((function($this) {
					var $r;
					var $int = $this.buffer.id;
					$r = $int < 0?4294967296.0 + $int:$int + 0.0;
					return $r;
				}(this)) == 0) {
					this.buffer.id = al.genBuffer();
					var format = 0;
					if(this.buffer.channels == 1) {
						if(this.buffer.bitsPerSample == 8) format = al.FORMAT_MONO8; else if(this.buffer.bitsPerSample == 16) format = al.FORMAT_MONO16;
					} else if(this.buffer.channels == 2) {
						if(this.buffer.bitsPerSample == 8) format = al.FORMAT_STEREO8; else if(this.buffer.bitsPerSample == 16) format = al.FORMAT_STEREO16;
					}
					al.bufferData(this.buffer.id,format,this.buffer.data,this.buffer.data.length,this.buffer.sampleRate);
				}
				this.id = al.genSource();
				al.sourcei(this.id,al.BUFFER,this.buffer.id);
				break;
			default:
			}
		}
	}
	,play: function() {
	}
	,pause: function() {
	}
	,stop: function() {
	}
	,get_gain: function() {
		return 1;
	}
	,set_gain: function(value) {
		return 1;
	}
	,get_timeOffset: function() {
		return 0;
	}
	,set_timeOffset: function(value) {
		return 0;
	}
	,__class__: lime.audio.AudioSource
	,__properties__: {set_timeOffset:"set_timeOffset",get_timeOffset:"get_timeOffset",set_gain:"set_gain",get_gain:"get_gain"}
};
lime.audio.FlashAudioContext = function() {
};
$hxClasses["lime.audio.FlashAudioContext"] = lime.audio.FlashAudioContext;
lime.audio.FlashAudioContext.__name__ = ["lime","audio","FlashAudioContext"];
lime.audio.FlashAudioContext.prototype = {
	createBuffer: function(stream,context) {
		return null;
	}
	,getBytesLoaded: function(buffer) {
		return 0;
	}
	,getBytesTotal: function(buffer) {
		return 0;
	}
	,getID3: function(buffer) {
		return null;
	}
	,getIsBuffering: function(buffer) {
		return false;
	}
	,getIsURLInaccessible: function(buffer) {
		return false;
	}
	,getLength: function(buffer) {
		return 0;
	}
	,getURL: function(buffer) {
		return null;
	}
	,close: function(buffer) {
	}
	,extract: function(buffer,target,length,startPosition) {
		if(startPosition == null) startPosition = -1;
		return 0;
	}
	,load: function(buffer,stream,context) {
	}
	,loadCompressedDataFromByteArray: function(buffer,bytes,bytesLength) {
	}
	,loadPCMFromByteArray: function(buffer,bytes,samples,format,stereo,sampleRate) {
		if(sampleRate == null) sampleRate = 44100;
		if(stereo == null) stereo = true;
	}
	,play: function(buffer,startTime,loops,sndTransform) {
		if(loops == null) loops = 0;
		if(startTime == null) startTime = 0;
		return null;
	}
	,__class__: lime.audio.FlashAudioContext
};
lime.audio.HTML5AudioContext = function() {
	this.NETWORK_NO_SOURCE = 3;
	this.NETWORK_LOADING = 2;
	this.NETWORK_IDLE = 1;
	this.NETWORK_EMPTY = 0;
	this.HAVE_NOTHING = 0;
	this.HAVE_METADATA = 1;
	this.HAVE_FUTURE_DATA = 3;
	this.HAVE_ENOUGH_DATA = 4;
	this.HAVE_CURRENT_DATA = 2;
};
$hxClasses["lime.audio.HTML5AudioContext"] = lime.audio.HTML5AudioContext;
lime.audio.HTML5AudioContext.__name__ = ["lime","audio","HTML5AudioContext"];
lime.audio.HTML5AudioContext.prototype = {
	canPlayType: function(buffer,type) {
		if(buffer.src != null) return buffer.src.canPlayType(type);
		return null;
	}
	,createBuffer: function(urlString) {
		var buffer = new lime.audio.AudioBuffer();
		buffer.src = new Audio();
		buffer.src.src = urlString;
		return buffer;
	}
	,getAudioDecodedByteCount: function(buffer) {
		if(buffer.src != null) return buffer.src.audioDecodedByteCount;
		return 0;
	}
	,getAutoplay: function(buffer) {
		if(buffer.src != null) return buffer.src.autoplay;
		return false;
	}
	,getBuffered: function(buffer) {
		if(buffer.src != null) return buffer.src.buffered;
		return null;
	}
	,getController: function(buffer) {
		if(buffer.src != null) return buffer.src.controller;
		return null;
	}
	,getCurrentSrc: function(buffer) {
		if(buffer.src != null) return buffer.src.currentSrc;
		return null;
	}
	,getCurrentTime: function(buffer) {
		if(buffer.src != null) return buffer.src.currentTime;
		return 0;
	}
	,getDefaultPlaybackRate: function(buffer) {
		if(buffer.src != null) return buffer.src.defaultPlaybackRate;
		return 1;
	}
	,getDuration: function(buffer) {
		if(buffer.src != null) return buffer.src.duration;
		return 0;
	}
	,getEnded: function(buffer) {
		if(buffer.src != null) return buffer.src.ended;
		return false;
	}
	,getError: function(buffer) {
		if(buffer.src != null) return buffer.src.error;
		return null;
	}
	,getInitialTime: function(buffer) {
		if(buffer.src != null) return buffer.src.initialTime;
		return 0;
	}
	,getLoop: function(buffer) {
		if(buffer.src != null) return buffer.src.loop;
		return false;
	}
	,getMediaGroup: function(buffer) {
		if(buffer.src != null) return buffer.src.mediaGroup;
		return null;
	}
	,getMuted: function(buffer) {
		if(buffer.src != null) return buffer.src.muted;
		return false;
	}
	,getNetworkState: function(buffer) {
		if(buffer.src != null) return buffer.src.networkState;
		return 0;
	}
	,getPaused: function(buffer) {
		if(buffer.src != null) return buffer.src.paused;
		return false;
	}
	,getPlaybackRate: function(buffer) {
		if(buffer.src != null) return buffer.src.playbackRate;
		return 1;
	}
	,getPlayed: function(buffer) {
		if(buffer.src != null) return buffer.src.played;
		return null;
	}
	,getPreload: function(buffer) {
		if(buffer.src != null) return buffer.src.preload;
		return null;
	}
	,getReadyState: function(buffer) {
		if(buffer.src != null) return buffer.src.readyState;
		return 0;
	}
	,getSeekable: function(buffer) {
		if(buffer.src != null) return buffer.src.seekable;
		return null;
	}
	,getSeeking: function(buffer) {
		if(buffer.src != null) return buffer.src.seeking;
		return false;
	}
	,getSrc: function(buffer) {
		if(buffer.src != null) return buffer.src.src;
		return null;
	}
	,getStartTime: function(buffer) {
		if(buffer.src != null) return buffer.src.playbackRate;
		return 0;
	}
	,getVolume: function(buffer) {
		if(buffer.src != null) return buffer.src.volume;
		return 1;
	}
	,load: function(buffer) {
		if(buffer.src != null) return buffer.src.load();
	}
	,pause: function(buffer) {
		if(buffer.src != null) return buffer.src.pause();
	}
	,play: function(buffer) {
		if(buffer.src != null) return buffer.src.play();
	}
	,setAutoplay: function(buffer,value) {
		if(buffer.src != null) buffer.src.autoplay = value;
	}
	,setController: function(buffer,value) {
		if(buffer.src != null) buffer.src.controller = value;
	}
	,setCurrentTime: function(buffer,value) {
		if(buffer.src != null) buffer.src.currentTime = value;
	}
	,setDefaultPlaybackRate: function(buffer,value) {
		if(buffer.src != null) buffer.src.defaultPlaybackRate = value;
	}
	,setLoop: function(buffer,value) {
		if(buffer.src != null) buffer.src.loop = value;
	}
	,setMediaGroup: function(buffer,value) {
		if(buffer.src != null) buffer.src.mediaGroup = value;
	}
	,setMuted: function(buffer,value) {
		if(buffer.src != null) buffer.src.muted = value;
	}
	,setPlaybackRate: function(buffer,value) {
		if(buffer.src != null) buffer.src.playbackRate = value;
	}
	,setPreload: function(buffer,value) {
		if(buffer.src != null) buffer.src.preload = value;
	}
	,setSrc: function(buffer,value) {
		if(buffer.src != null) buffer.src.src = value;
	}
	,setVolume: function(buffer,value) {
		if(buffer.src != null) buffer.src.volume = value;
	}
	,__class__: lime.audio.HTML5AudioContext
};
lime.audio.openal = {};
lime.audio.openal.AL = function() { };
$hxClasses["lime.audio.openal.AL"] = lime.audio.openal.AL;
lime.audio.openal.AL.__name__ = ["lime","audio","openal","AL"];
lime.audio.openal.AL.bufferData = function(buffer,format,data,size,freq) {
};
lime.audio.openal.AL.buffer3f = function(buffer,param,value1,value2,value3) {
};
lime.audio.openal.AL.buffer3i = function(buffer,param,value1,value2,value3) {
};
lime.audio.openal.AL.bufferf = function(buffer,param,value) {
};
lime.audio.openal.AL.bufferfv = function(buffer,param,values) {
};
lime.audio.openal.AL.bufferi = function(buffer,param,value) {
};
lime.audio.openal.AL.bufferiv = function(buffer,param,values) {
};
lime.audio.openal.AL.deleteBuffer = function(buffer) {
};
lime.audio.openal.AL.deleteBuffers = function(buffers) {
};
lime.audio.openal.AL.deleteSource = function(source) {
};
lime.audio.openal.AL.deleteSources = function(sources) {
};
lime.audio.openal.AL.disable = function(capability) {
};
lime.audio.openal.AL.distanceModel = function(distanceModel) {
};
lime.audio.openal.AL.dopplerFactor = function(value) {
};
lime.audio.openal.AL.dopplerVelocity = function(value) {
};
lime.audio.openal.AL.enable = function(capability) {
};
lime.audio.openal.AL.genSource = function() {
	return 0;
};
lime.audio.openal.AL.genSources = function(n) {
	return null;
};
lime.audio.openal.AL.genBuffer = function() {
	return 0;
};
lime.audio.openal.AL.genBuffers = function(n) {
	return null;
};
lime.audio.openal.AL.getBoolean = function(param) {
	return false;
};
lime.audio.openal.AL.getBooleanv = function(param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getBuffer3f = function(buffer,param) {
	return null;
};
lime.audio.openal.AL.getBuffer3i = function(buffer,param) {
	return null;
};
lime.audio.openal.AL.getBufferf = function(buffer,param) {
	return 0;
};
lime.audio.openal.AL.getBufferfv = function(buffer,param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getBufferi = function(buffer,param) {
	return 0;
};
lime.audio.openal.AL.getBufferiv = function(buffer,param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getDouble = function(param) {
	return 0;
};
lime.audio.openal.AL.getDoublev = function(param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getEnumValue = function(ename) {
	return 0;
};
lime.audio.openal.AL.getError = function() {
	return 0;
};
lime.audio.openal.AL.getErrorString = function() {
	var _g = lime.audio.openal.AL.getError();
	switch(_g) {
	case 40961:
		return "INVALID_NAME: Invalid parameter name";
	case 40962:
		return "INVALID_ENUM: Invalid enum value";
	case 40963:
		return "INVALID_VALUE: Invalid parameter value";
	case 40964:
		return "INVALID_OPERATION: Illegal operation or call";
	case 40965:
		return "OUT_OF_MEMORY: OpenAL has run out of memory";
	default:
		return "";
	}
};
lime.audio.openal.AL.getFloat = function(param) {
	return 0;
};
lime.audio.openal.AL.getFloatv = function(param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getInteger = function(param) {
	return 0;
};
lime.audio.openal.AL.getIntegerv = function(param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getListener3f = function(param) {
	return null;
};
lime.audio.openal.AL.getListener3i = function(param) {
	return null;
};
lime.audio.openal.AL.getListenerf = function(param) {
	return 0;
};
lime.audio.openal.AL.getListenerfv = function(param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getListeneri = function(param) {
	return 0;
};
lime.audio.openal.AL.getListeneriv = function(param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getProcAddress = function(fname) {
	return null;
};
lime.audio.openal.AL.getSource3f = function(source,param) {
	return null;
};
lime.audio.openal.AL.getSourcef = function(source,param) {
	return 0;
};
lime.audio.openal.AL.getSource3i = function(source,param) {
	return null;
};
lime.audio.openal.AL.getSourcefv = function(source,param) {
	return null;
};
lime.audio.openal.AL.getSourcei = function(source,param) {
	return 0;
};
lime.audio.openal.AL.getSourceiv = function(source,param,count) {
	if(count == null) count = 1;
	return null;
};
lime.audio.openal.AL.getString = function(param) {
	return null;
};
lime.audio.openal.AL.isBuffer = function(buffer) {
	return false;
};
lime.audio.openal.AL.isEnabled = function(capability) {
	return false;
};
lime.audio.openal.AL.isExtensionPresent = function(extname) {
	return false;
};
lime.audio.openal.AL.isSource = function(source) {
	return false;
};
lime.audio.openal.AL.listener3f = function(param,value1,value2,value3) {
};
lime.audio.openal.AL.listener3i = function(param,value1,value2,value3) {
};
lime.audio.openal.AL.listenerf = function(param,value) {
};
lime.audio.openal.AL.listenerfv = function(param,values) {
};
lime.audio.openal.AL.listeneri = function(param,value) {
};
lime.audio.openal.AL.listeneriv = function(param,values) {
};
lime.audio.openal.AL.source3f = function(source,param,value1,value2,value3) {
};
lime.audio.openal.AL.source3i = function(source,param,value1,value2,value3) {
};
lime.audio.openal.AL.sourcef = function(source,param,value) {
};
lime.audio.openal.AL.sourcefv = function(source,param,values) {
};
lime.audio.openal.AL.sourcei = function(source,param,value) {
};
lime.audio.openal.AL.sourceiv = function(source,param,values) {
};
lime.audio.openal.AL.sourcePlay = function(source) {
};
lime.audio.openal.AL.sourcePlayv = function(sources) {
};
lime.audio.openal.AL.sourceStop = function(source) {
};
lime.audio.openal.AL.sourceStopv = function(sources) {
};
lime.audio.openal.AL.sourceRewind = function(source) {
};
lime.audio.openal.AL.sourceRewindv = function(sources) {
};
lime.audio.openal.AL.sourcePause = function(source) {
};
lime.audio.openal.AL.sourcePausev = function(sources) {
};
lime.audio.openal.AL.sourceQueueBuffer = function(source,buffer) {
};
lime.audio.openal.AL.sourceQueueBuffers = function(source,nb,buffers) {
};
lime.audio.openal.AL.sourceUnqueueBuffer = function(source) {
	return 0;
};
lime.audio.openal.AL.sourceUnqueueBuffers = function(source,nb) {
	return null;
};
lime.audio.openal.AL.speedOfSound = function(value) {
};
lime.audio.openal.ALC = function() { };
$hxClasses["lime.audio.openal.ALC"] = lime.audio.openal.ALC;
lime.audio.openal.ALC.__name__ = ["lime","audio","openal","ALC"];
lime.audio.openal.ALC.closeDevice = function(device) {
	return false;
};
lime.audio.openal.ALC.createContext = function(device,attrlist) {
	return null;
};
lime.audio.openal.ALC.destroyContext = function(context) {
};
lime.audio.openal.ALC.getContextsDevice = function(context) {
	return null;
};
lime.audio.openal.ALC.getCurrentContext = function() {
	return null;
};
lime.audio.openal.ALC.getError = function(device) {
	return 0;
};
lime.audio.openal.ALC.getErrorString = function(device) {
	var _g = lime.audio.openal.ALC.getError(device);
	switch(_g) {
	case 40961:
		return "INVALID_DEVICE: Invalid device (or no device?)";
	case 40962:
		return "INVALID_CONTEXT: Invalid context (or no context?)";
	case 40963:
		return "INVALID_ENUM: Invalid enum value";
	case 40964:
		return "INVALID_VALUE: Invalid param value";
	case 40965:
		return "OUT_OF_MEMORY: OpenAL has run out of memory";
	default:
		return "";
	}
};
lime.audio.openal.ALC.getIntegerv = function(device,param,size) {
	return null;
};
lime.audio.openal.ALC.getString = function(device,param) {
	return null;
};
lime.audio.openal.ALC.makeContextCurrent = function(context) {
	return false;
};
lime.audio.openal.ALC.openDevice = function(deviceName) {
	return null;
};
lime.audio.openal.ALC.processContext = function(context) {
};
lime.audio.openal.ALC.suspendContext = function(context) {
};
lime.audio.openal._ALContext = {};
lime.audio.openal._ALContext.ALContext_Impl_ = function() { };
$hxClasses["lime.audio.openal._ALContext.ALContext_Impl_"] = lime.audio.openal._ALContext.ALContext_Impl_;
lime.audio.openal._ALContext.ALContext_Impl_.__name__ = ["lime","audio","openal","_ALContext","ALContext_Impl_"];
lime.audio.openal._ALContext.ALContext_Impl_._new = function(handle) {
	return handle;
};
lime.audio.openal._ALDevice = {};
lime.audio.openal._ALDevice.ALDevice_Impl_ = function() { };
$hxClasses["lime.audio.openal._ALDevice.ALDevice_Impl_"] = lime.audio.openal._ALDevice.ALDevice_Impl_;
lime.audio.openal._ALDevice.ALDevice_Impl_.__name__ = ["lime","audio","openal","_ALDevice","ALDevice_Impl_"];
lime.audio.openal._ALDevice.ALDevice_Impl_._new = function(handle) {
	return handle;
};
lime.graphics = {};
lime.graphics.ConsoleRenderContext = function() {
};
$hxClasses["lime.graphics.ConsoleRenderContext"] = lime.graphics.ConsoleRenderContext;
lime.graphics.ConsoleRenderContext.__name__ = ["lime","graphics","ConsoleRenderContext"];
lime.graphics.ConsoleRenderContext.prototype = {
	clear: function() {
	}
	,clearColor: function(r,g,b,a) {
	}
	,clearDepth: function(depth) {
	}
	,clearStencil: function(stencil) {
	}
	,__class__: lime.graphics.ConsoleRenderContext
};
lime.graphics.FlashRenderContext = function() {
};
$hxClasses["lime.graphics.FlashRenderContext"] = lime.graphics.FlashRenderContext;
lime.graphics.FlashRenderContext.__name__ = ["lime","graphics","FlashRenderContext"];
lime.graphics.FlashRenderContext.prototype = {
	addChild: function(child) {
		return null;
	}
	,addChildAt: function(child,index) {
		return null;
	}
	,addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) useWeakReference = false;
		if(priority == null) priority = 0;
		if(useCapture == null) useCapture = false;
	}
	,areInaccessibleObjectsUnderPoint: function(point) {
		return false;
	}
	,contains: function(child) {
		return false;
	}
	,dispatchEvent: function(event) {
		return false;
	}
	,getBounds: function(targetCoordinateSpace) {
		return null;
	}
	,getChildAt: function(index) {
		return null;
	}
	,getChildByName: function(name) {
		return null;
	}
	,getChildIndex: function(child) {
		return 0;
	}
	,getObjectsUnderPoint: function(point) {
		return null;
	}
	,getRect: function(targetCoordinateSpace) {
		return null;
	}
	,globalToLocal: function(point) {
		return null;
	}
	,globalToLocal3D: function(point) {
		return null;
	}
	,hasEventListener: function(type) {
		return false;
	}
	,hitTestObject: function(obj) {
		return false;
	}
	,hitTestPoint: function(x,y,shapeFlag) {
		if(shapeFlag == null) shapeFlag = false;
		return false;
	}
	,local3DToGlobal: function(point3d) {
		return null;
	}
	,localToGlobal: function(point) {
		return null;
	}
	,removeChild: function(child) {
		return null;
	}
	,removeChildAt: function(index) {
		return null;
	}
	,removeChildren: function(beginIndex,endIndex) {
		if(endIndex == null) endIndex = 2147483647;
		if(beginIndex == null) beginIndex = 0;
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) useCapture = false;
	}
	,requestSoftKeyboard: function() {
		return false;
	}
	,setChildIndex: function(child,index) {
	}
	,startDrag: function(lockCenter,bounds) {
		if(lockCenter == null) lockCenter = false;
	}
	,startTouchDrag: function(touchPointID,lockCenter,bounds) {
		if(lockCenter == null) lockCenter = false;
	}
	,stopAllMovieClips: function() {
	}
	,stopDrag: function() {
	}
	,stopTouchDrag: function(touchPointID) {
	}
	,swapChildren: function(child1,child2) {
	}
	,swapChildrenAt: function(index1,index2) {
	}
	,toString: function() {
		return null;
	}
	,willTrigger: function(type) {
		return false;
	}
	,__class__: lime.graphics.FlashRenderContext
};
lime.graphics.Font = function(fontName) {
	this.fontName = fontName;
	this.glyphs = new haxe.ds.IntMap();
};
$hxClasses["lime.graphics.Font"] = lime.graphics.Font;
lime.graphics.Font.__name__ = ["lime","graphics","Font"];
lime.graphics.Font.fromBytes = function(bytes) {
	var font = new lime.graphics.Font();
	return font;
};
lime.graphics.Font.fromFile = function(path) {
	var font = new lime.graphics.Font();
	font.__fromFile(path);
	return font;
};
lime.graphics.Font.prototype = {
	createImage: function() {
		this.glyphs = new haxe.ds.IntMap();
		return null;
	}
	,decompose: function() {
		return null;
	}
	,loadRange: function(size,start,end) {
	}
	,loadGlyphs: function(size,glyphs) {
		if(glyphs == null) glyphs = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^`'\"/\\&*()[]{}<>|:;_-+=?,. ";
	}
	,__fromFile: function(path) {
		this.__fontPath = path;
	}
	,__class__: lime.graphics.Font
};
lime.graphics.GlyphRect = function(x,y,width,height,xOffset,yOffset) {
	if(yOffset == null) yOffset = 0;
	if(xOffset == null) xOffset = 0;
	this.x = x;
	this.y = y;
	this.xOffset = xOffset;
	this.yOffset = yOffset;
	this.width = width;
	this.height = height;
};
$hxClasses["lime.graphics.GlyphRect"] = lime.graphics.GlyphRect;
lime.graphics.GlyphRect.__name__ = ["lime","graphics","GlyphRect"];
lime.graphics.GlyphRect.prototype = {
	__class__: lime.graphics.GlyphRect
};
lime.graphics.Image = function(buffer,offsetX,offsetY,width,height,color,type) {
	if(height == null) height = 0;
	if(width == null) width = 0;
	if(offsetY == null) offsetY = 0;
	if(offsetX == null) offsetX = 0;
	this.offsetX = offsetX;
	this.offsetY = offsetY;
	this.width = width;
	this.height = height;
	if(type == null) {
		if(lime.app.Application.current != null && lime.app.Application.current.renderers[0] != null) {
			var _g = lime.app.Application.current.renderers[0].context;
			switch(_g[1]) {
			case 2:case 1:
				this.type = lime.graphics.ImageType.CANVAS;
				break;
			case 3:
				this.type = lime.graphics.ImageType.FLASH;
				break;
			default:
				this.type = lime.graphics.ImageType.DATA;
			}
		} else this.type = lime.graphics.ImageType.DATA;
	} else this.type = type;
	if(buffer == null) {
		if(width > 0 && height > 0) {
			var _g1 = this.type;
			switch(_g1[1]) {
			case 0:
				this.buffer = new lime.graphics.ImageBuffer(null,width,height);
				lime.graphics.utils.ImageCanvasUtil.createCanvas(this,width,height);
				if(color != null) this.fillRect(new lime.math.Rectangle(0,0,width,height),color);
				break;
			case 1:
				this.buffer = new lime.graphics.ImageBuffer(new Uint8Array(width * height * 4),width,height);
				if(color != null) this.fillRect(new lime.math.Rectangle(0,0,width,height),color);
				break;
			case 2:
				break;
			default:
			}
		}
	} else this.__fromImageBuffer(buffer);
};
$hxClasses["lime.graphics.Image"] = lime.graphics.Image;
lime.graphics.Image.__name__ = ["lime","graphics","Image"];
lime.graphics.Image.__base64Encoder = null;
lime.graphics.Image.fromBase64 = function(base64,type,onload) {
	var image = new lime.graphics.Image();
	image.__fromBase64(base64,type,onload);
	return image;
};
lime.graphics.Image.fromBitmapData = function(bitmapData) {
	var buffer = new lime.graphics.ImageBuffer(null,bitmapData.width,bitmapData.height);
	buffer.__srcBitmapData = bitmapData;
	return new lime.graphics.Image(buffer);
};
lime.graphics.Image.fromBytes = function(bytes,onload) {
	var image = new lime.graphics.Image();
	image.__fromBytes(bytes,onload);
	return image;
};
lime.graphics.Image.fromCanvas = function(canvas) {
	var buffer = new lime.graphics.ImageBuffer(null,canvas.width,canvas.height);
	buffer.set_src(canvas);
	return new lime.graphics.Image(buffer);
};
lime.graphics.Image.fromFile = function(path,onload,onerror) {
	var image = new lime.graphics.Image();
	image.__fromFile(path,onload,onerror);
	return image;
};
lime.graphics.Image.fromImageElement = function(image) {
	var buffer = new lime.graphics.ImageBuffer(null,image.width,image.height);
	buffer.set_src(image);
	return new lime.graphics.Image(buffer);
};
lime.graphics.Image.__base64Encode = function(bytes) {
	var extension;
	var _g = bytes.length % 3;
	switch(_g) {
	case 1:
		extension = "==";
		break;
	case 2:
		extension = "=";
		break;
	default:
		extension = "";
	}
	if(lime.graphics.Image.__base64Encoder == null) lime.graphics.Image.__base64Encoder = new haxe.crypto.BaseCode(haxe.io.Bytes.ofString(lime.graphics.Image.__base64Chars));
	return lime.graphics.Image.__base64Encoder.encodeBytes(haxe.io.Bytes.ofData(bytes.byteView)).toString() + extension;
};
lime.graphics.Image.__isJPG = function(bytes) {
	bytes.position = 0;
	return bytes.readUnsignedByte() == 255 && bytes.readUnsignedByte() == 216;
};
lime.graphics.Image.__isPNG = function(bytes) {
	bytes.position = 0;
	return bytes.readUnsignedByte() == 137 && bytes.readUnsignedByte() == 80 && bytes.readUnsignedByte() == 78 && bytes.readUnsignedByte() == 71 && bytes.readUnsignedByte() == 13 && bytes.readUnsignedByte() == 10 && bytes.readUnsignedByte() == 26 && bytes.readUnsignedByte() == 10;
};
lime.graphics.Image.__isGIF = function(bytes) {
	bytes.position = 0;
	if(bytes.readUnsignedByte() == 71 && bytes.readUnsignedByte() == 73 && bytes.readUnsignedByte() == 70 && bytes.readUnsignedByte() == 56) {
		var b = bytes.readUnsignedByte();
		return (b == 55 || b == 57) && bytes.readUnsignedByte() == 97;
	}
	return false;
};
lime.graphics.Image.prototype = {
	clone: function() {
		lime.graphics.utils.ImageCanvasUtil.sync(this);
		var image;
		if(this.buffer.__srcImage != null) image = new lime.graphics.Image(this.buffer.clone(),this.offsetX,this.offsetY,this.width,this.height,null,this.type); else {
			image = new lime.graphics.Image(null,this.offsetX,this.offsetY,this.width,this.height,null,this.type);
			image.buffer.__srcContext.drawImage(this.buffer.get_src(),0,0);
		}
		return image;
	}
	,colorTransform: function(rect,colorMatrix) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.colorTransform(this,rect,colorMatrix);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.colorTransform(this,rect,colorMatrix);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.colorTransform(rect.__toFlashRectangle(),lime.math._ColorMatrix.ColorMatrix_Impl_.__toFlashColorTransform(colorMatrix));
			break;
		default:
		}
	}
	,copyChannel: function(sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
		sourceRect = this.__clipRect(sourceRect);
		if(this.buffer == null || sourceRect == null) return;
		if(destChannel == lime.graphics.ImageChannel.ALPHA && !this.get_transparent()) return;
		if(sourceRect.width <= 0 || sourceRect.height <= 0) return;
		if(sourceRect.x + sourceRect.width > sourceImage.width) sourceRect.width = sourceImage.width - sourceRect.x;
		if(sourceRect.y + sourceRect.height > sourceImage.height) sourceRect.height = sourceImage.height - sourceRect.y;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.copyChannel(this,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.copyChannel(this,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
			break;
		case 2:
			var srcChannel;
			switch(sourceChannel[1]) {
			case 0:
				srcChannel = 1;
				break;
			case 1:
				srcChannel = 2;
				break;
			case 2:
				srcChannel = 4;
				break;
			case 3:
				srcChannel = 8;
				break;
			}
			var dstChannel;
			switch(destChannel[1]) {
			case 0:
				dstChannel = 1;
				break;
			case 1:
				dstChannel = 2;
				break;
			case 2:
				dstChannel = 4;
				break;
			case 3:
				dstChannel = 8;
				break;
			}
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.copyChannel(sourceImage.buffer.get_src(),sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),srcChannel,dstChannel);
			break;
		default:
		}
	}
	,copyPixels: function(sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
		if(mergeAlpha == null) mergeAlpha = false;
		if(this.buffer == null || sourceImage == null) return;
		if(sourceRect.x + sourceRect.width > sourceImage.width) sourceRect.width = sourceImage.width - sourceRect.x;
		if(sourceRect.y + sourceRect.height > sourceImage.height) sourceRect.height = sourceImage.height - sourceRect.y;
		if(sourceRect.width <= 0 || sourceRect.height <= 0) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.convertToCanvas(this);
			lime.graphics.utils.ImageCanvasUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageCanvasUtil.convertToData(sourceImage);
			lime.graphics.utils.ImageDataUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			break;
		case 2:
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			if(alphaImage != null && alphaPoint != null) alphaPoint.offset(alphaImage.offsetX,alphaImage.offsetY);
			this.buffer.__srcBitmapData.copyPixels(sourceImage.buffer.__srcBitmapData,sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),alphaImage != null?alphaImage.buffer.get_src():null,alphaPoint != null?alphaPoint.__toFlashPoint():null,mergeAlpha);
			break;
		default:
		}
	}
	,encode: function(format,quality) {
		if(quality == null) quality = 90;
		if(format == null) format = "png";
		return null;
	}
	,fillRect: function(rect,color) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.fillRect(this,rect,color);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.fillRect(this,rect,color);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.fillRect(rect.__toFlashRectangle(),color);
			break;
		default:
		}
	}
	,floodFill: function(x,y,color) {
		if(this.buffer == null) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.floodFill(this,x,y,color);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.floodFill(this,x,y,color);
			break;
		case 2:
			this.buffer.__srcBitmapData.floodFill(x + this.offsetX,y + this.offsetY,color);
			break;
		default:
		}
	}
	,getPixel: function(x,y) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) return 0;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			return lime.graphics.utils.ImageCanvasUtil.getPixel(this,x,y);
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			return lime.graphics.utils.ImageDataUtil.getPixel(this,x,y);
		case 2:
			return this.buffer.__srcBitmapData.getPixel(x + this.offsetX,y + this.offsetY);
		default:
			return 0;
		}
	}
	,getPixel32: function(x,y) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) return 0;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			return lime.graphics.utils.ImageCanvasUtil.getPixel32(this,x,y);
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			return lime.graphics.utils.ImageDataUtil.getPixel32(this,x,y);
		case 2:
			return this.buffer.__srcBitmapData.getPixel32(x + this.offsetX,y + this.offsetY);
		default:
			return 0;
		}
	}
	,getPixels: function(rect) {
		if(this.buffer == null) return null;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			return lime.graphics.utils.ImageCanvasUtil.getPixels(this,rect);
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			return lime.graphics.utils.ImageDataUtil.getPixels(this,rect);
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			return this.buffer.__srcBitmapData.getPixels(rect.__toFlashRectangle());
		default:
			return null;
		}
	}
	,merge: function(sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
		if(this.buffer == null || sourceImage == null) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.convertToCanvas(this);
			lime.graphics.utils.ImageCanvasUtil.merge(this,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageCanvasUtil.convertToData(sourceImage);
			lime.graphics.utils.ImageDataUtil.merge(this,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		case 2:
			sourceRect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.merge(sourceImage.buffer.__srcBitmapData,sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		default:
			return null;
		}
	}
	,resize: function(newWidth,newHeight) {
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.resize(this,newWidth,newHeight);
			break;
		case 1:
			lime.graphics.utils.ImageDataUtil.resize(this,newWidth,newHeight);
			break;
		case 2:
			break;
		default:
		}
		this.buffer.width = newWidth;
		this.buffer.height = newHeight;
		this.offsetX = 0;
		this.offsetY = 0;
		this.width = newWidth;
		this.height = newHeight;
	}
	,setPixel: function(x,y,color) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.setPixel(this,x,y,color);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.setPixel(this,x,y,color);
			break;
		case 2:
			this.buffer.__srcBitmapData.setPixel(x + this.offsetX,y + this.offsetX,color);
			break;
		default:
		}
	}
	,setPixel32: function(x,y,color) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.setPixel32(this,x,y,color);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.setPixel32(this,x,y,color);
			break;
		case 2:
			this.buffer.__srcBitmapData.setPixel32(x + this.offsetX,y + this.offsetY,color);
			break;
		default:
		}
	}
	,setPixels: function(rect,byteArray) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) return;
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime.graphics.utils.ImageCanvasUtil.setPixels(this,rect,byteArray);
			break;
		case 1:
			lime.graphics.utils.ImageCanvasUtil.convertToData(this);
			lime.graphics.utils.ImageDataUtil.setPixels(this,rect,byteArray);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.setPixels(rect.__toFlashRectangle(),byteArray);
			break;
		default:
		}
	}
	,__clipRect: function(r) {
		if(r == null) return null;
		if(r.x < 0) {
			r.width -= -r.x;
			r.x = 0;
			if(r.x + r.width <= 0) return null;
		}
		if(r.y < 0) {
			r.height -= -r.y;
			r.y = 0;
			if(r.y + r.height <= 0) return null;
		}
		if(r.x + r.width >= this.width) {
			r.width -= r.x + r.width - this.width;
			if(r.width <= 0) return null;
		}
		if(r.y + r.height >= this.height) {
			r.height -= r.y + r.height - this.height;
			if(r.height <= 0) return null;
		}
		return r;
	}
	,__fromBase64: function(base64,type,onload) {
		var _g = this;
		var image = new Image();
		var image_onLoaded = function(event) {
			_g.buffer = new lime.graphics.ImageBuffer(null,image.width,image.height);
			_g.buffer.__srcImage = image;
			_g.offsetX = 0;
			_g.offsetY = 0;
			_g.width = _g.buffer.width;
			_g.height = _g.buffer.height;
			if(onload != null) onload(_g);
		};
		image.addEventListener("load",image_onLoaded,false);
		image.src = "data:" + type + ";base64," + base64;
	}
	,__fromBytes: function(bytes,onload) {
		var type = "";
		if(lime.graphics.Image.__isPNG(bytes)) type = "image/png"; else if(lime.graphics.Image.__isJPG(bytes)) type = "image/jpeg"; else if(lime.graphics.Image.__isGIF(bytes)) type = "image/gif"; else throw "Image tried to read a PNG/JPG ByteArray, but found an invalid header.";
		this.__fromBase64(lime.graphics.Image.__base64Encode(bytes),type,onload);
	}
	,__fromFile: function(path,onload,onerror) {
		var _g = this;
		var image = new Image();
		image.onload = function(_) {
			_g.buffer = new lime.graphics.ImageBuffer(null,image.width,image.height);
			_g.buffer.__srcImage = image;
			_g.width = image.width;
			_g.height = image.height;
			if(onload != null) onload(_g);
		};
		image.onerror = function(_1) {
			if(onerror != null) onerror();
		};
		image.src = path;
		if(image.complete) {
		}
	}
	,__fromImageBuffer: function(buffer) {
		this.buffer = buffer;
		if(buffer != null) {
			if(this.width == 0) this.width = buffer.width;
			if(this.height == 0) this.height = buffer.height;
		}
	}
	,get_data: function() {
		if(this.buffer.data == null && this.buffer.width > 0 && this.buffer.height > 0) {
			lime.graphics.utils.ImageCanvasUtil.convertToCanvas(this);
			lime.graphics.utils.ImageCanvasUtil.createImageData(this);
		}
		return this.buffer.data;
	}
	,set_data: function(value) {
		return this.buffer.data = value;
	}
	,get_powerOfTwo: function() {
		return this.buffer.width != 0 && (this.buffer.width & ~this.buffer.width + 1) == this.buffer.width && (this.buffer.height != 0 && (this.buffer.height & ~this.buffer.height + 1) == this.buffer.height);
	}
	,set_powerOfTwo: function(value) {
		if(value != this.get_powerOfTwo()) {
			var newWidth = 1;
			var newHeight = 1;
			while(newWidth < this.buffer.width) newWidth <<= 1;
			while(newHeight < this.buffer.height) newHeight <<= 1;
			var _g = this.type;
			switch(_g[1]) {
			case 0:
				break;
			case 1:
				lime.graphics.utils.ImageDataUtil.resizeBuffer(this,newWidth,newHeight);
				break;
			case 2:
				break;
			default:
			}
		}
		return value;
	}
	,get_premultiplied: function() {
		return this.buffer.premultiplied;
	}
	,set_premultiplied: function(value) {
		if(value && !this.buffer.premultiplied) {
			var _g = this.type;
			switch(_g[1]) {
			case 1:
				lime.graphics.utils.ImageCanvasUtil.convertToData(this);
				lime.graphics.utils.ImageDataUtil.multiplyAlpha(this);
				break;
			default:
			}
		} else if(!value && this.buffer.premultiplied) {
			var _g1 = this.type;
			switch(_g1[1]) {
			case 1:
				lime.graphics.utils.ImageCanvasUtil.convertToData(this);
				lime.graphics.utils.ImageDataUtil.unmultiplyAlpha(this);
				break;
			default:
			}
		}
		return value;
	}
	,get_rect: function() {
		return new lime.math.Rectangle(0,0,this.width,this.height);
	}
	,get_src: function() {
		return this.buffer.get_src();
	}
	,set_src: function(value) {
		return this.buffer.set_src(value);
	}
	,get_transparent: function() {
		return this.buffer.transparent;
	}
	,set_transparent: function(value) {
		return this.buffer.transparent = value;
	}
	,__class__: lime.graphics.Image
	,__properties__: {set_transparent:"set_transparent",get_transparent:"get_transparent",set_src:"set_src",get_src:"get_src",get_rect:"get_rect",set_premultiplied:"set_premultiplied",get_premultiplied:"get_premultiplied",set_powerOfTwo:"set_powerOfTwo",get_powerOfTwo:"get_powerOfTwo",set_data:"set_data",get_data:"get_data"}
};
lime.graphics.ImageChannel = $hxClasses["lime.graphics.ImageChannel"] = { __ename__ : ["lime","graphics","ImageChannel"], __constructs__ : ["RED","GREEN","BLUE","ALPHA"] };
lime.graphics.ImageChannel.RED = ["RED",0];
lime.graphics.ImageChannel.RED.toString = $estr;
lime.graphics.ImageChannel.RED.__enum__ = lime.graphics.ImageChannel;
lime.graphics.ImageChannel.GREEN = ["GREEN",1];
lime.graphics.ImageChannel.GREEN.toString = $estr;
lime.graphics.ImageChannel.GREEN.__enum__ = lime.graphics.ImageChannel;
lime.graphics.ImageChannel.BLUE = ["BLUE",2];
lime.graphics.ImageChannel.BLUE.toString = $estr;
lime.graphics.ImageChannel.BLUE.__enum__ = lime.graphics.ImageChannel;
lime.graphics.ImageChannel.ALPHA = ["ALPHA",3];
lime.graphics.ImageChannel.ALPHA.toString = $estr;
lime.graphics.ImageChannel.ALPHA.__enum__ = lime.graphics.ImageChannel;
lime.graphics.ImageBuffer = function(data,width,height,bitsPerPixel) {
	if(bitsPerPixel == null) bitsPerPixel = 4;
	if(height == null) height = 0;
	if(width == null) width = 0;
	this.data = data;
	this.width = width;
	this.height = height;
	this.bitsPerPixel = bitsPerPixel;
	this.transparent = true;
};
$hxClasses["lime.graphics.ImageBuffer"] = lime.graphics.ImageBuffer;
lime.graphics.ImageBuffer.__name__ = ["lime","graphics","ImageBuffer"];
lime.graphics.ImageBuffer.prototype = {
	clone: function() {
		var buffer = new lime.graphics.ImageBuffer(this.data,this.width,this.height,this.bitsPerPixel);
		buffer.set_src(this.get_src());
		buffer.premultiplied = this.premultiplied;
		buffer.transparent = this.transparent;
		return buffer;
	}
	,get_src: function() {
		if(this.__srcImage != null) return this.__srcImage;
		return this.__srcCanvas;
	}
	,set_src: function(value) {
		if(js.Boot.__instanceof(value,Image)) this.__srcImage = value; else if(js.Boot.__instanceof(value,HTMLCanvasElement)) {
			this.__srcCanvas = value;
			this.__srcContext = this.__srcCanvas.getContext("2d");
		}
		return value;
	}
	,__class__: lime.graphics.ImageBuffer
	,__properties__: {set_src:"set_src",get_src:"get_src"}
};
lime.graphics.ImageType = $hxClasses["lime.graphics.ImageType"] = { __ename__ : ["lime","graphics","ImageType"], __constructs__ : ["CANVAS","DATA","FLASH","CUSTOM"] };
lime.graphics.ImageType.CANVAS = ["CANVAS",0];
lime.graphics.ImageType.CANVAS.toString = $estr;
lime.graphics.ImageType.CANVAS.__enum__ = lime.graphics.ImageType;
lime.graphics.ImageType.DATA = ["DATA",1];
lime.graphics.ImageType.DATA.toString = $estr;
lime.graphics.ImageType.DATA.__enum__ = lime.graphics.ImageType;
lime.graphics.ImageType.FLASH = ["FLASH",2];
lime.graphics.ImageType.FLASH.toString = $estr;
lime.graphics.ImageType.FLASH.__enum__ = lime.graphics.ImageType;
lime.graphics.ImageType.CUSTOM = ["CUSTOM",3];
lime.graphics.ImageType.CUSTOM.toString = $estr;
lime.graphics.ImageType.CUSTOM.__enum__ = lime.graphics.ImageType;
lime.graphics.RenderContext = $hxClasses["lime.graphics.RenderContext"] = { __ename__ : ["lime","graphics","RenderContext"], __constructs__ : ["OPENGL","CANVAS","DOM","FLASH","CONSOLE","CUSTOM"] };
lime.graphics.RenderContext.OPENGL = function(gl) { var $x = ["OPENGL",0,gl]; $x.__enum__ = lime.graphics.RenderContext; $x.toString = $estr; return $x; };
lime.graphics.RenderContext.CANVAS = function(context) { var $x = ["CANVAS",1,context]; $x.__enum__ = lime.graphics.RenderContext; $x.toString = $estr; return $x; };
lime.graphics.RenderContext.DOM = function(element) { var $x = ["DOM",2,element]; $x.__enum__ = lime.graphics.RenderContext; $x.toString = $estr; return $x; };
lime.graphics.RenderContext.FLASH = function(stage) { var $x = ["FLASH",3,stage]; $x.__enum__ = lime.graphics.RenderContext; $x.toString = $estr; return $x; };
lime.graphics.RenderContext.CONSOLE = function(context) { var $x = ["CONSOLE",4,context]; $x.__enum__ = lime.graphics.RenderContext; $x.toString = $estr; return $x; };
lime.graphics.RenderContext.CUSTOM = function(data) { var $x = ["CUSTOM",5,data]; $x.__enum__ = lime.graphics.RenderContext; $x.toString = $estr; return $x; };
lime.graphics.Renderer = function(window) {
	this.onRender = new lime.app.Event();
	this.onRenderContextRestored = new lime.app.Event();
	this.onRenderContextLost = new lime.app.Event();
	this.window = window;
	this.backend = new lime._backend.html5.HTML5Renderer(this);
	this.window.currentRenderer = this;
};
$hxClasses["lime.graphics.Renderer"] = lime.graphics.Renderer;
lime.graphics.Renderer.__name__ = ["lime","graphics","Renderer"];
lime.graphics.Renderer.prototype = {
	create: function() {
		this.backend.create();
	}
	,flip: function() {
		this.backend.flip();
	}
	,render: function() {
		this.backend.render();
	}
	,__class__: lime.graphics.Renderer
};
lime.graphics.format = {};
lime.graphics.format.BMP = function() { };
$hxClasses["lime.graphics.format.BMP"] = lime.graphics.format.BMP;
lime.graphics.format.BMP.__name__ = ["lime","graphics","format","BMP"];
lime.graphics.format.BMP.encode = function(image,type) {
	if(type == null) type = lime.graphics.format.BMPType.RGB;
	var fileHeaderLength = 14;
	var infoHeaderLength = 40;
	var pixelValuesLength = image.width * image.height * 4;
	switch(type[1]) {
	case 1:
		infoHeaderLength = 108;
		break;
	case 2:
		fileHeaderLength = 0;
		pixelValuesLength += image.width * image.height;
		break;
	default:
	}
	var data = new lime.utils.ByteArray(fileHeaderLength + infoHeaderLength + pixelValuesLength);
	if(fileHeaderLength > 0) {
		data.writeByte(66);
		data.writeByte(77);
		data.writeInt(data.length);
		data.writeInt(0);
		data.writeInt(fileHeaderLength + infoHeaderLength);
	}
	data.writeInt(infoHeaderLength);
	data.writeInt(image.width);
	if(type == lime.graphics.format.BMPType.ICO) data.writeInt(image.height * 2); else data.writeInt(image.height);
	data.writeShort(1);
	data.writeShort(32);
	switch(type[1]) {
	case 1:
		data.writeInt(3);
		break;
	default:
		data.writeInt(0);
	}
	data.writeInt(pixelValuesLength);
	data.writeInt(11824);
	data.writeInt(11824);
	data.writeInt(0);
	data.writeInt(0);
	if(type == lime.graphics.format.BMPType.BITFIELD) {
		data.writeInt(16711680);
		data.writeInt(65280);
		data.writeInt(255);
		data.writeInt(-16777216);
		data.writeByte(32);
		data.writeByte(110);
		data.writeByte(105);
		data.writeByte(87);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
		data.writeInt(0);
	}
	var pixels = image.getPixels(new lime.math.Rectangle(0,0,image.width,image.height));
	var a;
	var r;
	var g;
	var b;
	if(type != lime.graphics.format.BMPType.ICO) {
		var _g1 = 0;
		var _g = image.height;
		while(_g1 < _g) {
			var y = _g1++;
			pixels.position = (image.height - 1 - y) * 4 * image.width;
			var _g3 = 0;
			var _g2 = image.width;
			while(_g3 < _g2) {
				var x = _g3++;
				a = pixels.readByte();
				r = pixels.readByte();
				g = pixels.readByte();
				b = pixels.readByte();
				data.writeByte(b);
				data.writeByte(g);
				data.writeByte(r);
				data.writeByte(a);
			}
		}
	} else {
		var andMask = new lime.utils.ByteArray(image.width * image.height);
		var _g11 = 0;
		var _g4 = image.height;
		while(_g11 < _g4) {
			var y1 = _g11++;
			pixels.position = (image.height - 1 - y1) * 4 * image.width;
			var _g31 = 0;
			var _g21 = image.width;
			while(_g31 < _g21) {
				var x1 = _g31++;
				a = pixels.readByte();
				r = pixels.readByte();
				g = pixels.readByte();
				b = pixels.readByte();
				data.writeByte(b);
				data.writeByte(g);
				data.writeByte(r);
				data.writeByte(a);
				andMask.writeByte(0);
			}
		}
		data.writeBytes(andMask);
	}
	return data;
};
lime.graphics.format.BMPType = $hxClasses["lime.graphics.format.BMPType"] = { __ename__ : ["lime","graphics","format","BMPType"], __constructs__ : ["RGB","BITFIELD","ICO"] };
lime.graphics.format.BMPType.RGB = ["RGB",0];
lime.graphics.format.BMPType.RGB.toString = $estr;
lime.graphics.format.BMPType.RGB.__enum__ = lime.graphics.format.BMPType;
lime.graphics.format.BMPType.BITFIELD = ["BITFIELD",1];
lime.graphics.format.BMPType.BITFIELD.toString = $estr;
lime.graphics.format.BMPType.BITFIELD.__enum__ = lime.graphics.format.BMPType;
lime.graphics.format.BMPType.ICO = ["ICO",2];
lime.graphics.format.BMPType.ICO.toString = $estr;
lime.graphics.format.BMPType.ICO.__enum__ = lime.graphics.format.BMPType;
lime.graphics.format.JPEG = function() { };
$hxClasses["lime.graphics.format.JPEG"] = lime.graphics.format.JPEG;
lime.graphics.format.JPEG.__name__ = ["lime","graphics","format","JPEG"];
lime.graphics.format.JPEG.encode = function(image,quality) {
	return null;
};
lime.graphics.format.PNG = function() { };
$hxClasses["lime.graphics.format.PNG"] = lime.graphics.format.PNG;
lime.graphics.format.PNG.__name__ = ["lime","graphics","format","PNG"];
lime.graphics.format.PNG.encode = function(image) {
	return null;
};
lime.graphics.opengl = {};
lime.graphics.opengl.GL = function() { };
$hxClasses["lime.graphics.opengl.GL"] = lime.graphics.opengl.GL;
lime.graphics.opengl.GL.__name__ = ["lime","graphics","opengl","GL"];
lime.graphics.opengl.GL.__properties__ = {get_version:"get_version"}
lime.graphics.opengl.GL.version = null;
lime.graphics.opengl.GL.context = null;
lime.graphics.opengl.GL.activeTexture = function(texture) {
	lime.graphics.opengl.GL.context.activeTexture(texture);
};
lime.graphics.opengl.GL.attachShader = function(program,shader) {
	lime.graphics.opengl.GL.context.attachShader(program,shader);
};
lime.graphics.opengl.GL.bindAttribLocation = function(program,index,name) {
	lime.graphics.opengl.GL.context.bindAttribLocation(program,index,name);
};
lime.graphics.opengl.GL.bindBuffer = function(target,buffer) {
	lime.graphics.opengl.GL.context.bindBuffer(target,buffer);
};
lime.graphics.opengl.GL.bindFramebuffer = function(target,framebuffer) {
	lime.graphics.opengl.GL.context.bindFramebuffer(target,framebuffer);
};
lime.graphics.opengl.GL.bindRenderbuffer = function(target,renderbuffer) {
	lime.graphics.opengl.GL.context.bindRenderbuffer(target,renderbuffer);
};
lime.graphics.opengl.GL.bindTexture = function(target,texture) {
	lime.graphics.opengl.GL.context.bindTexture(target,texture);
};
lime.graphics.opengl.GL.blendColor = function(red,green,blue,alpha) {
	lime.graphics.opengl.GL.context.blendColor(red,green,blue,alpha);
};
lime.graphics.opengl.GL.blendEquation = function(mode) {
	lime.graphics.opengl.GL.context.blendEquation(mode);
};
lime.graphics.opengl.GL.blendEquationSeparate = function(modeRGB,modeAlpha) {
	lime.graphics.opengl.GL.context.blendEquationSeparate(modeRGB,modeAlpha);
};
lime.graphics.opengl.GL.blendFunc = function(sfactor,dfactor) {
	lime.graphics.opengl.GL.context.blendFunc(sfactor,dfactor);
};
lime.graphics.opengl.GL.blendFuncSeparate = function(srcRGB,dstRGB,srcAlpha,dstAlpha) {
	lime.graphics.opengl.GL.context.blendFuncSeparate(srcRGB,dstRGB,srcAlpha,dstAlpha);
};
lime.graphics.opengl.GL.bufferData = function(target,data,usage) {
	lime.graphics.opengl.GL.context.bufferData(target,data,usage);
};
lime.graphics.opengl.GL.bufferSubData = function(target,offset,data) {
	lime.graphics.opengl.GL.context.bufferSubData(target,offset,data);
};
lime.graphics.opengl.GL.checkFramebufferStatus = function(target) {
	return lime.graphics.opengl.GL.context.checkFramebufferStatus(target);
};
lime.graphics.opengl.GL.clear = function(mask) {
	lime.graphics.opengl.GL.context.clear(mask);
};
lime.graphics.opengl.GL.clearColor = function(red,green,blue,alpha) {
	lime.graphics.opengl.GL.context.clearColor(red,green,blue,alpha);
};
lime.graphics.opengl.GL.clearDepth = function(depth) {
	lime.graphics.opengl.GL.context.clearDepth(depth);
};
lime.graphics.opengl.GL.clearStencil = function(s) {
	lime.graphics.opengl.GL.context.clearStencil(s);
};
lime.graphics.opengl.GL.colorMask = function(red,green,blue,alpha) {
	lime.graphics.opengl.GL.context.colorMask(red,green,blue,alpha);
};
lime.graphics.opengl.GL.compileShader = function(shader) {
	lime.graphics.opengl.GL.context.compileShader(shader);
};
lime.graphics.opengl.GL.compressedTexImage2D = function(target,level,internalformat,width,height,border,data) {
	lime.graphics.opengl.GL.context.compressedTexImage2D(target,level,internalformat,width,height,border,data);
};
lime.graphics.opengl.GL.compressedTexSubImage2D = function(target,level,xoffset,yoffset,width,height,format,data) {
	lime.graphics.opengl.GL.context.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,data);
};
lime.graphics.opengl.GL.copyTexImage2D = function(target,level,internalformat,x,y,width,height,border) {
	lime.graphics.opengl.GL.context.copyTexImage2D(target,level,internalformat,x,y,width,height,border);
};
lime.graphics.opengl.GL.copyTexSubImage2D = function(target,level,xoffset,yoffset,x,y,width,height) {
	lime.graphics.opengl.GL.context.copyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height);
};
lime.graphics.opengl.GL.createBuffer = function() {
	return lime.graphics.opengl.GL.context.createBuffer();
};
lime.graphics.opengl.GL.createFramebuffer = function() {
	return lime.graphics.opengl.GL.context.createFramebuffer();
};
lime.graphics.opengl.GL.createProgram = function() {
	return lime.graphics.opengl.GL.context.createProgram();
};
lime.graphics.opengl.GL.createRenderbuffer = function() {
	return lime.graphics.opengl.GL.context.createRenderbuffer();
};
lime.graphics.opengl.GL.createShader = function(type) {
	return lime.graphics.opengl.GL.context.createShader(type);
};
lime.graphics.opengl.GL.createTexture = function() {
	return lime.graphics.opengl.GL.context.createTexture();
};
lime.graphics.opengl.GL.cullFace = function(mode) {
	lime.graphics.opengl.GL.context.cullFace(mode);
};
lime.graphics.opengl.GL.deleteBuffer = function(buffer) {
	lime.graphics.opengl.GL.context.deleteBuffer(buffer);
};
lime.graphics.opengl.GL.deleteFramebuffer = function(framebuffer) {
	lime.graphics.opengl.GL.context.deleteFramebuffer(framebuffer);
};
lime.graphics.opengl.GL.deleteProgram = function(program) {
	lime.graphics.opengl.GL.context.deleteProgram(program);
};
lime.graphics.opengl.GL.deleteRenderbuffer = function(renderbuffer) {
	lime.graphics.opengl.GL.context.deleteRenderbuffer(renderbuffer);
};
lime.graphics.opengl.GL.deleteShader = function(shader) {
	lime.graphics.opengl.GL.context.deleteShader(shader);
};
lime.graphics.opengl.GL.deleteTexture = function(texture) {
	lime.graphics.opengl.GL.context.deleteTexture(texture);
};
lime.graphics.opengl.GL.depthFunc = function(func) {
	lime.graphics.opengl.GL.context.depthFunc(func);
};
lime.graphics.opengl.GL.depthMask = function(flag) {
	lime.graphics.opengl.GL.context.depthMask(flag);
};
lime.graphics.opengl.GL.depthRange = function(zNear,zFar) {
	lime.graphics.opengl.GL.context.depthRange(zNear,zFar);
};
lime.graphics.opengl.GL.detachShader = function(program,shader) {
	lime.graphics.opengl.GL.context.detachShader(program,shader);
};
lime.graphics.opengl.GL.disable = function(cap) {
	lime.graphics.opengl.GL.context.disable(cap);
};
lime.graphics.opengl.GL.disableVertexAttribArray = function(index) {
	lime.graphics.opengl.GL.context.disableVertexAttribArray(index);
};
lime.graphics.opengl.GL.drawArrays = function(mode,first,count) {
	lime.graphics.opengl.GL.context.drawArrays(mode,first,count);
};
lime.graphics.opengl.GL.drawElements = function(mode,count,type,offset) {
	lime.graphics.opengl.GL.context.drawElements(mode,count,type,offset);
};
lime.graphics.opengl.GL.enable = function(cap) {
	lime.graphics.opengl.GL.context.enable(cap);
};
lime.graphics.opengl.GL.enableVertexAttribArray = function(index) {
	lime.graphics.opengl.GL.context.enableVertexAttribArray(index);
};
lime.graphics.opengl.GL.finish = function() {
	lime.graphics.opengl.GL.context.finish();
};
lime.graphics.opengl.GL.flush = function() {
	lime.graphics.opengl.GL.context.flush();
};
lime.graphics.opengl.GL.framebufferRenderbuffer = function(target,attachment,renderbuffertarget,renderbuffer) {
	lime.graphics.opengl.GL.context.framebufferRenderbuffer(target,attachment,renderbuffertarget,renderbuffer);
};
lime.graphics.opengl.GL.framebufferTexture2D = function(target,attachment,textarget,texture,level) {
	lime.graphics.opengl.GL.context.framebufferTexture2D(target,attachment,textarget,texture,level);
};
lime.graphics.opengl.GL.frontFace = function(mode) {
	lime.graphics.opengl.GL.context.frontFace(mode);
};
lime.graphics.opengl.GL.generateMipmap = function(target) {
	lime.graphics.opengl.GL.context.generateMipmap(target);
};
lime.graphics.opengl.GL.getActiveAttrib = function(program,index) {
	return lime.graphics.opengl.GL.context.getActiveAttrib(program,index);
};
lime.graphics.opengl.GL.getActiveUniform = function(program,index) {
	return lime.graphics.opengl.GL.context.getActiveUniform(program,index);
};
lime.graphics.opengl.GL.getAttachedShaders = function(program) {
	return lime.graphics.opengl.GL.context.getAttachedShaders(program);
};
lime.graphics.opengl.GL.getAttribLocation = function(program,name) {
	return lime.graphics.opengl.GL.context.getAttribLocation(program,name);
};
lime.graphics.opengl.GL.getBufferParameter = function(target,pname) {
	return lime.graphics.opengl.GL.context.getBufferParameter(target,pname);
};
lime.graphics.opengl.GL.getContextAttributes = function() {
	return lime.graphics.opengl.GL.context.getContextAttributes();
};
lime.graphics.opengl.GL.getError = function() {
	return lime.graphics.opengl.GL.context.getError();
};
lime.graphics.opengl.GL.getExtension = function(name) {
	return lime.graphics.opengl.GL.context.getExtension(name);
};
lime.graphics.opengl.GL.getFramebufferAttachmentParameter = function(target,attachment,pname) {
	return lime.graphics.opengl.GL.context.getFramebufferAttachmentParameter(target,attachment,pname);
};
lime.graphics.opengl.GL.getParameter = function(pname) {
	return lime.graphics.opengl.GL.context.getParameter(pname);
};
lime.graphics.opengl.GL.getProgramInfoLog = function(program) {
	return lime.graphics.opengl.GL.context.getProgramInfoLog(program);
};
lime.graphics.opengl.GL.getProgramParameter = function(program,pname) {
	return lime.graphics.opengl.GL.context.getProgramParameter(program,pname);
};
lime.graphics.opengl.GL.getRenderbufferParameter = function(target,pname) {
	return lime.graphics.opengl.GL.context.getRenderbufferParameter(target,pname);
};
lime.graphics.opengl.GL.getShaderInfoLog = function(shader) {
	return lime.graphics.opengl.GL.context.getShaderInfoLog(shader);
};
lime.graphics.opengl.GL.getShaderParameter = function(shader,pname) {
	return lime.graphics.opengl.GL.context.getShaderParameter(shader,pname);
};
lime.graphics.opengl.GL.getShaderPrecisionFormat = function(shadertype,precisiontype) {
	return lime.graphics.opengl.GL.context.getShaderPrecisionFormat(shadertype,precisiontype);
};
lime.graphics.opengl.GL.getShaderSource = function(shader) {
	return lime.graphics.opengl.GL.context.getShaderSource(shader);
};
lime.graphics.opengl.GL.getSupportedExtensions = function() {
	return lime.graphics.opengl.GL.context.getSupportedExtensions();
};
lime.graphics.opengl.GL.getTexParameter = function(target,pname) {
	return lime.graphics.opengl.GL.context.getTexParameter(target,pname);
};
lime.graphics.opengl.GL.getUniform = function(program,location) {
	return lime.graphics.opengl.GL.context.getUniform(program,location);
};
lime.graphics.opengl.GL.getUniformLocation = function(program,name) {
	return lime.graphics.opengl.GL.context.getUniformLocation(program,name);
};
lime.graphics.opengl.GL.getVertexAttrib = function(index,pname) {
	return lime.graphics.opengl.GL.context.getVertexAttrib(index,pname);
};
lime.graphics.opengl.GL.getVertexAttribOffset = function(index,pname) {
	return lime.graphics.opengl.GL.context.getVertexAttribOffset(index,pname);
};
lime.graphics.opengl.GL.hint = function(target,mode) {
	lime.graphics.opengl.GL.context.hint(target,mode);
};
lime.graphics.opengl.GL.isBuffer = function(buffer) {
	return lime.graphics.opengl.GL.context.isBuffer(buffer);
};
lime.graphics.opengl.GL.isContextLost = function() {
	return lime.graphics.opengl.GL.context.isContextLost();
};
lime.graphics.opengl.GL.isEnabled = function(cap) {
	return lime.graphics.opengl.GL.context.isEnabled(cap);
};
lime.graphics.opengl.GL.isFramebuffer = function(framebuffer) {
	return lime.graphics.opengl.GL.context.isFramebuffer(framebuffer);
};
lime.graphics.opengl.GL.isProgram = function(program) {
	return lime.graphics.opengl.GL.context.isProgram(program);
};
lime.graphics.opengl.GL.isRenderbuffer = function(renderbuffer) {
	return lime.graphics.opengl.GL.context.isRenderbuffer(renderbuffer);
};
lime.graphics.opengl.GL.isShader = function(shader) {
	return lime.graphics.opengl.GL.context.isShader(shader);
};
lime.graphics.opengl.GL.isTexture = function(texture) {
	return lime.graphics.opengl.GL.context.isTexture(texture);
};
lime.graphics.opengl.GL.lineWidth = function(width) {
	lime.graphics.opengl.GL.context.lineWidth(width);
};
lime.graphics.opengl.GL.linkProgram = function(program) {
	lime.graphics.opengl.GL.context.linkProgram(program);
};
lime.graphics.opengl.GL.pixelStorei = function(pname,param) {
	lime.graphics.opengl.GL.context.pixelStorei(pname,param);
};
lime.graphics.opengl.GL.polygonOffset = function(factor,units) {
	lime.graphics.opengl.GL.context.polygonOffset(factor,units);
};
lime.graphics.opengl.GL.readPixels = function(x,y,width,height,format,type,pixels) {
	lime.graphics.opengl.GL.context.readPixels(x,y,width,height,format,type,pixels);
};
lime.graphics.opengl.GL.renderbufferStorage = function(target,internalformat,width,height) {
	lime.graphics.opengl.GL.context.renderbufferStorage(target,internalformat,width,height);
};
lime.graphics.opengl.GL.sampleCoverage = function(value,invert) {
	lime.graphics.opengl.GL.context.sampleCoverage(value,invert);
};
lime.graphics.opengl.GL.scissor = function(x,y,width,height) {
	lime.graphics.opengl.GL.context.scissor(x,y,width,height);
};
lime.graphics.opengl.GL.shaderSource = function(shader,source) {
	lime.graphics.opengl.GL.context.shaderSource(shader,source);
};
lime.graphics.opengl.GL.stencilFunc = function(func,ref,mask) {
	lime.graphics.opengl.GL.context.stencilFunc(func,ref,mask);
};
lime.graphics.opengl.GL.stencilFuncSeparate = function(face,func,ref,mask) {
	lime.graphics.opengl.GL.context.stencilFuncSeparate(face,func,ref,mask);
};
lime.graphics.opengl.GL.stencilMask = function(mask) {
	lime.graphics.opengl.GL.context.stencilMask(mask);
};
lime.graphics.opengl.GL.stencilMaskSeparate = function(face,mask) {
	lime.graphics.opengl.GL.context.stencilMaskSeparate(face,mask);
};
lime.graphics.opengl.GL.stencilOp = function(fail,zfail,zpass) {
	lime.graphics.opengl.GL.context.stencilOp(fail,zfail,zpass);
};
lime.graphics.opengl.GL.stencilOpSeparate = function(face,fail,zfail,zpass) {
	lime.graphics.opengl.GL.context.stencilOpSeparate(face,fail,zfail,zpass);
};
lime.graphics.opengl.GL.texImage2D = function(target,level,internalformat,width,height,border,format,type,pixels) {
	lime.graphics.opengl.GL.context.texImage2D(target,level,internalformat,width,height,border,format,type,pixels);
};
lime.graphics.opengl.GL.texParameterf = function(target,pname,param) {
	lime.graphics.opengl.GL.context.texParameterf(target,pname,param);
};
lime.graphics.opengl.GL.texParameteri = function(target,pname,param) {
	lime.graphics.opengl.GL.context.texParameteri(target,pname,param);
};
lime.graphics.opengl.GL.texSubImage2D = function(target,level,xoffset,yoffset,width,height,format,type,pixels) {
	lime.graphics.opengl.GL.context.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixels);
};
lime.graphics.opengl.GL.uniform1f = function(location,x) {
	lime.graphics.opengl.GL.context.uniform1f(location,x);
};
lime.graphics.opengl.GL.uniform1fv = function(location,x) {
	lime.graphics.opengl.GL.context.uniform1fv(location,x);
};
lime.graphics.opengl.GL.uniform1i = function(location,x) {
	lime.graphics.opengl.GL.context.uniform1i(location,x);
};
lime.graphics.opengl.GL.uniform1iv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform1iv(location,v);
};
lime.graphics.opengl.GL.uniform2f = function(location,x,y) {
	lime.graphics.opengl.GL.context.uniform2f(location,x,y);
};
lime.graphics.opengl.GL.uniform2fv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform2fv(location,v);
};
lime.graphics.opengl.GL.uniform2i = function(location,x,y) {
	lime.graphics.opengl.GL.context.uniform2i(location,x,y);
};
lime.graphics.opengl.GL.uniform2iv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform2iv(location,v);
};
lime.graphics.opengl.GL.uniform3f = function(location,x,y,z) {
	lime.graphics.opengl.GL.context.uniform3f(location,x,y,z);
};
lime.graphics.opengl.GL.uniform3fv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform3fv(location,v);
};
lime.graphics.opengl.GL.uniform3i = function(location,x,y,z) {
	lime.graphics.opengl.GL.context.uniform3i(location,x,y,z);
};
lime.graphics.opengl.GL.uniform3iv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform3iv(location,v);
};
lime.graphics.opengl.GL.uniform4f = function(location,x,y,z,w) {
	lime.graphics.opengl.GL.context.uniform4f(location,x,y,z,w);
};
lime.graphics.opengl.GL.uniform4fv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform4fv(location,v);
};
lime.graphics.opengl.GL.uniform4i = function(location,x,y,z,w) {
	lime.graphics.opengl.GL.context.uniform4i(location,x,y,z,w);
};
lime.graphics.opengl.GL.uniform4iv = function(location,v) {
	lime.graphics.opengl.GL.context.uniform4iv(location,v);
};
lime.graphics.opengl.GL.uniformMatrix2fv = function(location,transpose,v) {
	lime.graphics.opengl.GL.context.uniformMatrix2fv(location,transpose,v);
};
lime.graphics.opengl.GL.uniformMatrix3fv = function(location,transpose,v) {
	lime.graphics.opengl.GL.context.uniformMatrix3fv(location,transpose,v);
};
lime.graphics.opengl.GL.uniformMatrix4fv = function(location,transpose,v) {
	lime.graphics.opengl.GL.context.uniformMatrix4fv(location,transpose,v);
};
lime.graphics.opengl.GL.useProgram = function(program) {
	lime.graphics.opengl.GL.context.useProgram(program);
};
lime.graphics.opengl.GL.validateProgram = function(program) {
	lime.graphics.opengl.GL.context.validateProgram(program);
};
lime.graphics.opengl.GL.vertexAttrib1f = function(indx,x) {
	lime.graphics.opengl.GL.context.vertexAttrib1f(indx,x);
};
lime.graphics.opengl.GL.vertexAttrib1fv = function(indx,values) {
	lime.graphics.opengl.GL.context.vertexAttrib1fv(indx,values);
};
lime.graphics.opengl.GL.vertexAttrib2f = function(indx,x,y) {
	lime.graphics.opengl.GL.context.vertexAttrib2f(indx,x,y);
};
lime.graphics.opengl.GL.vertexAttrib2fv = function(indx,values) {
	lime.graphics.opengl.GL.context.vertexAttrib2fv(indx,values);
};
lime.graphics.opengl.GL.vertexAttrib3f = function(indx,x,y,z) {
	lime.graphics.opengl.GL.context.vertexAttrib3f(indx,x,y,z);
};
lime.graphics.opengl.GL.vertexAttrib3fv = function(indx,values) {
	lime.graphics.opengl.GL.context.vertexAttrib3fv(indx,values);
};
lime.graphics.opengl.GL.vertexAttrib4f = function(indx,x,y,z,w) {
	lime.graphics.opengl.GL.context.vertexAttrib4f(indx,x,y,z,w);
};
lime.graphics.opengl.GL.vertexAttrib4fv = function(indx,values) {
	lime.graphics.opengl.GL.context.vertexAttrib4fv(indx,values);
};
lime.graphics.opengl.GL.vertexAttribPointer = function(indx,size,type,normalized,stride,offset) {
	lime.graphics.opengl.GL.context.vertexAttribPointer(indx,size,type,normalized,stride,offset);
};
lime.graphics.opengl.GL.viewport = function(x,y,width,height) {
	lime.graphics.opengl.GL.context.viewport(x,y,width,height);
};
lime.graphics.opengl.GL.get_version = function() {
	return 2;
};
lime.graphics.utils = {};
lime.graphics.utils.ImageCanvasUtil = function() { };
$hxClasses["lime.graphics.utils.ImageCanvasUtil"] = lime.graphics.utils.ImageCanvasUtil;
lime.graphics.utils.ImageCanvasUtil.__name__ = ["lime","graphics","utils","ImageCanvasUtil"];
lime.graphics.utils.ImageCanvasUtil.colorTransform = function(image,rect,colorMatrix) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.colorTransform(image,rect,colorMatrix);
};
lime.graphics.utils.ImageCanvasUtil.convertToCanvas = function(image) {
	var buffer = image.buffer;
	if(buffer.__srcImage != null) {
		if(buffer.__srcCanvas == null) {
			lime.graphics.utils.ImageCanvasUtil.createCanvas(image,buffer.__srcImage.width,buffer.__srcImage.height);
			buffer.__srcContext.drawImage(buffer.__srcImage,0,0);
		}
		buffer.__srcImage = null;
	}
};
lime.graphics.utils.ImageCanvasUtil.convertToData = function(image) {
	if(image.buffer.data == null) {
		lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
		lime.graphics.utils.ImageCanvasUtil.createImageData(image);
		image.buffer.__srcCanvas = null;
		image.buffer.__srcContext = null;
	}
};
lime.graphics.utils.ImageCanvasUtil.copyChannel = function(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(sourceImage);
	lime.graphics.utils.ImageCanvasUtil.createImageData(sourceImage);
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.copyChannel(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
};
lime.graphics.utils.ImageCanvasUtil.copyPixels = function(image,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
	if(mergeAlpha == null) mergeAlpha = false;
	if(alphaImage != null && alphaImage.get_transparent()) {
		if(alphaPoint == null) alphaPoint = new lime.math.Vector2();
		var tempData = image.clone();
		tempData.copyChannel(alphaImage,new lime.math.Rectangle(alphaPoint.x,alphaPoint.y,sourceRect.width,sourceRect.height),new lime.math.Vector2(sourceRect.x,sourceRect.y),lime.graphics.ImageChannel.ALPHA,lime.graphics.ImageChannel.ALPHA);
		sourceImage = tempData;
	}
	lime.graphics.utils.ImageCanvasUtil.sync(image);
	if(!mergeAlpha) {
		if(image.get_transparent() && sourceImage.get_transparent()) image.buffer.__srcContext.clearRect(destPoint.x + image.offsetX,destPoint.y + image.offsetY,sourceRect.width + image.offsetX,sourceRect.height + image.offsetY);
	}
	lime.graphics.utils.ImageCanvasUtil.sync(sourceImage);
	if(sourceImage.buffer.get_src() != null) image.buffer.__srcContext.drawImage(sourceImage.buffer.get_src(),sourceRect.x + sourceImage.offsetX | 0,sourceRect.y + sourceImage.offsetY | 0,sourceRect.width | 0,sourceRect.height | 0,destPoint.x + image.offsetX | 0,destPoint.y + image.offsetY | 0,sourceRect.width | 0,sourceRect.height | 0);
};
lime.graphics.utils.ImageCanvasUtil.createCanvas = function(image,width,height) {
	var buffer = image.buffer;
	if(buffer.__srcCanvas == null) {
		buffer.__srcCanvas = window.document.createElement("canvas");
		buffer.__srcCanvas.width = width;
		buffer.__srcCanvas.height = height;
		if(!image.get_transparent()) {
			if(!image.get_transparent()) buffer.__srcCanvas.setAttribute("moz-opaque","true");
			buffer.__srcContext = buffer.__srcCanvas.getContext ("2d", { alpha: false });
		} else buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
		buffer.__srcContext.mozImageSmoothingEnabled = false;
		buffer.__srcContext.webkitImageSmoothingEnabled = false;
		buffer.__srcContext.imageSmoothingEnabled = false;
	}
};
lime.graphics.utils.ImageCanvasUtil.createImageData = function(image) {
	var buffer = image.buffer;
	if(buffer.data == null) {
		buffer.__srcImageData = buffer.__srcContext.getImageData(0,0,buffer.width,buffer.height);
		buffer.data = buffer.__srcImageData.data;
	}
};
lime.graphics.utils.ImageCanvasUtil.fillRect = function(image,rect,color) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.sync(image);
	if(rect.x == 0 && rect.y == 0 && rect.width == image.width && rect.height == image.height) {
		if(image.get_transparent() && (color & -16777216) == 0) {
			image.buffer.__srcCanvas.width = image.buffer.width;
			return;
		}
	}
	var a;
	if(image.get_transparent()) a = (color & -16777216) >>> 24; else a = 255;
	var r = (color & 16711680) >>> 16;
	var g = (color & 65280) >>> 8;
	var b = color & 255;
	image.buffer.__srcContext.fillStyle = "rgba(" + r + ", " + g + ", " + b + ", " + a / 255 + ")";
	image.buffer.__srcContext.fillRect(rect.x + image.offsetX,rect.y + image.offsetY,rect.width + image.offsetX,rect.height + image.offsetY);
};
lime.graphics.utils.ImageCanvasUtil.floodFill = function(image,x,y,color) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.floodFill(image,x,y,color);
};
lime.graphics.utils.ImageCanvasUtil.getPixel = function(image,x,y) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	return lime.graphics.utils.ImageDataUtil.getPixel(image,x,y);
};
lime.graphics.utils.ImageCanvasUtil.getPixel32 = function(image,x,y) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	return lime.graphics.utils.ImageDataUtil.getPixel32(image,x,y);
};
lime.graphics.utils.ImageCanvasUtil.getPixels = function(image,rect) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	return lime.graphics.utils.ImageDataUtil.getPixels(image,rect);
};
lime.graphics.utils.ImageCanvasUtil.merge = function(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(sourceImage);
	lime.graphics.utils.ImageCanvasUtil.createImageData(sourceImage);
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.merge(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
};
lime.graphics.utils.ImageCanvasUtil.resize = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	if(buffer.__srcCanvas == null) {
		lime.graphics.utils.ImageCanvasUtil.createCanvas(image,newWidth,newHeight);
		buffer.__srcContext.drawImage(buffer.get_src(),0,0,newWidth,newHeight);
	} else {
		var sourceCanvas = buffer.__srcCanvas;
		buffer.__srcCanvas = null;
		lime.graphics.utils.ImageCanvasUtil.createCanvas(image,newWidth,newHeight);
		buffer.__srcContext.drawImage(sourceCanvas,0,0,newWidth,newHeight);
	}
};
lime.graphics.utils.ImageCanvasUtil.setPixel = function(image,x,y,color) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.setPixel(image,x,y,color);
};
lime.graphics.utils.ImageCanvasUtil.setPixel32 = function(image,x,y,color) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.setPixel32(image,x,y,color);
};
lime.graphics.utils.ImageCanvasUtil.setPixels = function(image,rect,byteArray) {
	lime.graphics.utils.ImageCanvasUtil.convertToCanvas(image);
	lime.graphics.utils.ImageCanvasUtil.createImageData(image);
	lime.graphics.utils.ImageDataUtil.setPixels(image,rect,byteArray);
};
lime.graphics.utils.ImageCanvasUtil.sync = function(image) {
	if(image.dirty && image.type != lime.graphics.ImageType.DATA) {
		image.buffer.__srcContext.putImageData(image.buffer.__srcImageData,0,0);
		image.buffer.data = null;
		image.dirty = false;
	}
};
lime.graphics.utils.ImageDataUtil = function() { };
$hxClasses["lime.graphics.utils.ImageDataUtil"] = lime.graphics.utils.ImageDataUtil;
lime.graphics.utils.ImageDataUtil.__name__ = ["lime","graphics","utils","ImageDataUtil"];
lime.graphics.utils.ImageDataUtil.__alpha16 = null;
lime.graphics.utils.ImageDataUtil.__clamp = null;
lime.graphics.utils.ImageDataUtil.colorTransform = function(image,rect,colorMatrix) {
	var data = image.buffer.data;
	var stride = image.buffer.width * 4;
	var offset;
	var rowStart = Std["int"](rect.get_top() + image.offsetY);
	var rowEnd = Std["int"](rect.get_bottom() + image.offsetY);
	var columnStart = Std["int"](rect.get_left() + image.offsetX);
	var columnEnd = Std["int"](rect.get_right() + image.offsetX);
	var r;
	var g;
	var b;
	var a;
	var ex = 0;
	var _g = rowStart;
	while(_g < rowEnd) {
		var row = _g++;
		var _g1 = columnStart;
		while(_g1 < columnEnd) {
			var column = _g1++;
			offset = row * stride + column * 4;
			a = data[offset + 3] * colorMatrix[18] + colorMatrix[19] * 255 | 0;
			if(a > 255) ex = a - 255; else ex = 0;
			b = data[offset + 2] * colorMatrix[12] + colorMatrix[14] * 255 + ex | 0;
			if(b > 255) ex = b - 255; else ex = 0;
			g = data[offset + 1] * colorMatrix[6] + colorMatrix[9] * 255 + ex | 0;
			if(g > 255) ex = g - 255; else ex = 0;
			r = data[offset] * colorMatrix[0] + colorMatrix[4] * 255 + ex | 0;
			if(r > 255) data[offset] = 255; else data[offset] = r;
			if(g > 255) data[offset + 1] = 255; else data[offset + 1] = g;
			if(b > 255) data[offset + 2] = 255; else data[offset + 2] = b;
			if(a > 255) data[offset + 3] = 255; else data[offset + 3] = a;
		}
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.copyChannel = function(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
	var destIdx;
	switch(destChannel[1]) {
	case 0:
		destIdx = 0;
		break;
	case 1:
		destIdx = 1;
		break;
	case 2:
		destIdx = 2;
		break;
	case 3:
		destIdx = 3;
		break;
	}
	var srcIdx;
	switch(sourceChannel[1]) {
	case 0:
		srcIdx = 0;
		break;
	case 1:
		srcIdx = 1;
		break;
	case 2:
		srcIdx = 2;
		break;
	case 3:
		srcIdx = 3;
		break;
	}
	var srcStride = sourceImage.buffer.width * 4 | 0;
	var srcPosition = (sourceRect.x + sourceImage.offsetX) * 4 + srcStride * (sourceRect.y + sourceImage.offsetY) + srcIdx | 0;
	var srcRowOffset = srcStride - (4 * (sourceRect.width + sourceImage.offsetX) | 0);
	var srcRowEnd = 4 * (sourceRect.x + sourceImage.offsetX + sourceRect.width) | 0;
	var srcData = sourceImage.buffer.data;
	var destStride = image.buffer.width * 4 | 0;
	var destPosition = (destPoint.x + image.offsetX) * 4 + destStride * (destPoint.y + image.offsetY) + destIdx | 0;
	var destRowOffset = destStride - (4 * (sourceRect.width + image.offsetX) | 0);
	var destRowEnd = 4 * (destPoint.x + image.offsetX + sourceRect.width) | 0;
	var destData = image.buffer.data;
	var length = sourceRect.width * sourceRect.height | 0;
	var _g = 0;
	while(_g < length) {
		var i = _g++;
		destData[destPosition] = srcData[srcPosition];
		srcPosition += 4;
		destPosition += 4;
		if(srcPosition % srcStride > srcRowEnd) srcPosition += srcRowOffset;
		if(destPosition % destStride > destRowEnd) destPosition += destRowOffset;
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.copyPixels = function(image,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
	if(mergeAlpha == null) mergeAlpha = false;
	if(alphaImage != null && alphaImage.get_transparent()) {
		if(alphaPoint == null) alphaPoint = new lime.math.Vector2();
		var tempData = image.clone();
		tempData.copyChannel(alphaImage,new lime.math.Rectangle(alphaPoint.x,alphaPoint.y,sourceRect.width,sourceRect.height),new lime.math.Vector2(sourceRect.x,sourceRect.y),lime.graphics.ImageChannel.ALPHA,lime.graphics.ImageChannel.ALPHA);
		sourceImage = tempData;
	}
	var rowOffset = destPoint.y + image.offsetY - sourceRect.y - sourceImage.offsetY | 0;
	var columnOffset = destPoint.x + image.offsetX - sourceRect.x - sourceImage.offsetY | 0;
	var sourceData = sourceImage.buffer.data;
	var sourceStride = sourceImage.buffer.width * 4;
	var sourceOffset = 0;
	var data = image.buffer.data;
	var stride = image.buffer.width * 4;
	var offset = 0;
	if(!mergeAlpha || !sourceImage.get_transparent()) {
		var _g1 = Std["int"](sourceRect.get_top() + sourceImage.offsetY);
		var _g = Std["int"](sourceRect.get_bottom() + sourceImage.offsetY);
		while(_g1 < _g) {
			var row = _g1++;
			var _g3 = Std["int"](sourceRect.get_left() + sourceImage.offsetX);
			var _g2 = Std["int"](sourceRect.get_right() + sourceImage.offsetX);
			while(_g3 < _g2) {
				var column = _g3++;
				sourceOffset = row * sourceStride + column * 4;
				offset = (row + rowOffset) * stride + (column + columnOffset) * 4;
				data[offset] = sourceData[sourceOffset];
				data[offset + 1] = sourceData[sourceOffset + 1];
				data[offset + 2] = sourceData[sourceOffset + 2];
				data[offset + 3] = sourceData[sourceOffset + 3];
			}
		}
	} else {
		var sourceAlpha;
		var oneMinusSourceAlpha;
		var _g11 = Std["int"](sourceRect.get_top() + sourceImage.offsetY);
		var _g4 = Std["int"](sourceRect.get_bottom() + sourceImage.offsetY);
		while(_g11 < _g4) {
			var row1 = _g11++;
			var _g31 = Std["int"](sourceRect.get_left() + sourceImage.offsetX);
			var _g21 = Std["int"](sourceRect.get_right() + sourceImage.offsetX);
			while(_g31 < _g21) {
				var column1 = _g31++;
				sourceOffset = row1 * sourceStride + column1 * 4;
				offset = (row1 + rowOffset) * stride + (column1 + columnOffset) * 4;
				sourceAlpha = sourceData[sourceOffset + 3] / 255;
				oneMinusSourceAlpha = 1 - sourceAlpha;
				data[offset] = lime.graphics.utils.ImageDataUtil.__clamp[sourceData[sourceOffset] + data[offset] * oneMinusSourceAlpha | 0];
				data[offset + 1] = lime.graphics.utils.ImageDataUtil.__clamp[sourceData[sourceOffset + 1] + data[offset + 1] * oneMinusSourceAlpha | 0];
				data[offset + 2] = lime.graphics.utils.ImageDataUtil.__clamp[sourceData[sourceOffset + 2] + data[offset + 2] * oneMinusSourceAlpha | 0];
				data[offset + 3] = lime.graphics.utils.ImageDataUtil.__clamp[sourceData[sourceOffset + 3] + data[offset + 3] * oneMinusSourceAlpha | 0];
			}
		}
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.fillRect = function(image,rect,color) {
	var a;
	if(image.get_transparent()) a = (color & -16777216) >>> 24; else a = 255;
	var r = (color & 16711680) >>> 16;
	var g = (color & 65280) >>> 8;
	var b = color & 255;
	var rgba = r | g << 8 | b << 16 | a << 24;
	var data = image.buffer.data;
	if(rect.width == image.buffer.width && rect.height == image.buffer.height && rect.x == 0 && rect.y == 0 && image.offsetX == 0 && image.offsetY == 0) {
		var length = image.buffer.width * image.buffer.height;
		var j = 0;
		var _g = 0;
		while(_g < length) {
			var i = _g++;
			j = i * 4;
			data[j] = r;
			data[j + 1] = g;
			data[j + 2] = b;
			data[j + 3] = a;
		}
	} else {
		var stride = image.buffer.width * 4;
		var offset;
		var rowStart = rect.y + image.offsetY | 0;
		var rowEnd = Std["int"](rect.get_bottom() + image.offsetY);
		var columnStart = rect.x + image.offsetX | 0;
		var columnEnd = Std["int"](rect.get_right() + image.offsetX);
		var _g1 = rowStart;
		while(_g1 < rowEnd) {
			var row = _g1++;
			var _g11 = columnStart;
			while(_g11 < columnEnd) {
				var column = _g11++;
				offset = row * stride + column * 4;
				data[offset] = r;
				data[offset + 1] = g;
				data[offset + 2] = b;
				data[offset + 3] = a;
			}
		}
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.floodFill = function(image,x,y,color) {
	var data = image.buffer.data;
	var offset = (y + image.offsetY) * (image.buffer.width * 4) + (x + image.offsetX) * 4;
	var hitColorR = data[offset];
	var hitColorG = data[offset + 1];
	var hitColorB = data[offset + 2];
	var hitColorA;
	if(image.get_transparent()) hitColorA = data[offset + 3]; else hitColorA = 255;
	var r = (color & 16711680) >>> 16;
	var g = (color & 65280) >>> 8;
	var b = color & 255;
	var a;
	if(image.get_transparent()) a = (color & -16777216) >>> 24; else a = 255;
	if(hitColorR == r && hitColorG == g && hitColorB == b && hitColorA == a) return;
	var dx = [0,-1,1,0];
	var dy = [-1,0,0,1];
	var minX = -image.offsetX;
	var minY = -image.offsetY;
	var maxX = minX + image.width;
	var maxY = minY + image.height;
	var queue = new Array();
	queue.push(x);
	queue.push(y);
	while(queue.length > 0) {
		var curPointY = queue.pop();
		var curPointX = queue.pop();
		var _g = 0;
		while(_g < 4) {
			var i = _g++;
			var nextPointX = curPointX + dx[i];
			var nextPointY = curPointY + dy[i];
			if(nextPointX < minX || nextPointY < minY || nextPointX >= maxX || nextPointY >= maxY) continue;
			var nextPointOffset = (nextPointY * image.width + nextPointX) * 4;
			if(data[nextPointOffset] == hitColorR && data[nextPointOffset + 1] == hitColorG && data[nextPointOffset + 2] == hitColorB && data[nextPointOffset + 3] == hitColorA) {
				data[nextPointOffset] = r;
				data[nextPointOffset + 1] = g;
				data[nextPointOffset + 2] = b;
				data[nextPointOffset + 3] = a;
				queue.push(nextPointX);
				queue.push(nextPointY);
			}
		}
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.getPixel = function(image,x,y) {
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	if(image.get_premultiplied()) {
		var unmultiply = 255.0 / data[offset + 3];
		return lime.graphics.utils.ImageDataUtil.__clamp[data[offset] * unmultiply | 0] << 16 | lime.graphics.utils.ImageDataUtil.__clamp[data[offset + 1] * unmultiply | 0] << 8 | lime.graphics.utils.ImageDataUtil.__clamp[data[offset + 2] * unmultiply | 0];
	} else return data[offset] << 16 | data[offset + 1] << 8 | data[offset + 2];
};
lime.graphics.utils.ImageDataUtil.getPixel32 = function(image,x,y) {
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var a;
	if(image.get_transparent()) a = data[offset + 3]; else a = 255;
	if(image.get_premultiplied() && a != 0) {
		var unmultiply = 255.0 / a;
		return a << 24 | (function($this) {
			var $r;
			var index = Math.round(data[offset] * unmultiply);
			$r = lime.graphics.utils.ImageDataUtil.__clamp[index];
			return $r;
		}(this)) << 16 | lime.graphics.utils.ImageDataUtil.__clamp[data[offset + 1] * unmultiply | 0] << 8 | lime.graphics.utils.ImageDataUtil.__clamp[data[offset + 2] * unmultiply | 0];
	} else return a << 24 | data[offset] << 16 | data[offset + 1] << 8 | data[offset + 2];
};
lime.graphics.utils.ImageDataUtil.getPixels = function(image,rect) {
	var byteArray = new lime.utils.ByteArray(image.width * image.height * 4);
	var srcData = image.buffer.data;
	var srcStride = image.buffer.width * 4 | 0;
	var srcPosition = rect.x * 4 + srcStride * rect.y | 0;
	var srcRowOffset = srcStride - (4 * rect.width | 0);
	var srcRowEnd = 4 * (rect.x + rect.width) | 0;
	var length = rect.width * rect.height | 0;
	byteArray.set_length(length * 4);
	var _g = 0;
	while(_g < length) {
		var i = _g++;
		byteArray.__set(i * 4 + 1,srcData[srcPosition++]);
		byteArray.__set(i * 4 + 2,srcData[srcPosition++]);
		byteArray.__set(i * 4 + 3,srcData[srcPosition++]);
		byteArray.__set(i * 4,srcData[srcPosition++]);
		if(srcPosition % srcStride > srcRowEnd) srcPosition += srcRowOffset;
	}
	byteArray.position = 0;
	return byteArray;
};
lime.graphics.utils.ImageDataUtil.merge = function(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	var rowOffset = destPoint.y + image.offsetY - sourceRect.y - sourceImage.offsetY | 0;
	var columnOffset = destPoint.x + image.offsetX - sourceRect.x - sourceImage.offsetY | 0;
	var sourceData = sourceImage.buffer.data;
	var sourceStride = sourceImage.buffer.width * 4;
	var sourceOffset = 0;
	var data = image.buffer.data;
	var stride = image.buffer.width * 4;
	var offset = 0;
	var _g1 = Std["int"](sourceRect.get_top() + sourceImage.offsetY);
	var _g = Std["int"](sourceRect.get_bottom() + sourceImage.offsetY);
	while(_g1 < _g) {
		var row = _g1++;
		var _g3 = Std["int"](sourceRect.get_left() + sourceImage.offsetX);
		var _g2 = Std["int"](sourceRect.get_right() + sourceImage.offsetX);
		while(_g3 < _g2) {
			var column = _g3++;
			sourceOffset = row * sourceStride + column * 4;
			offset = (row + rowOffset) * stride + (column + columnOffset) * 4;
			data[offset] = (sourceData[offset] * redMultiplier + data[offset] * (256 - redMultiplier)) / 256 | 0;
			data[offset + 1] = (sourceData[offset + 1] * greenMultiplier + data[offset + 1] * (256 - greenMultiplier)) / 256 | 0;
			data[offset + 2] = (sourceData[offset + 2] * blueMultiplier + data[offset + 2] * (256 - blueMultiplier)) / 256 | 0;
			data[offset + 3] = (sourceData[offset + 3] * alphaMultiplier + data[offset + 3] * (256 - alphaMultiplier)) / 256 | 0;
		}
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.multiplyAlpha = function(image) {
	var data = image.buffer.data;
	if(data == null) return;
	var index;
	var a16;
	var length = data.length / 4 | 0;
	var _g = 0;
	while(_g < length) {
		var i = _g++;
		index = i * 4;
		var a161 = lime.graphics.utils.ImageDataUtil.__alpha16[data[index + 3]];
		data[index] = data[index] * a161 >> 16;
		data[index + 1] = data[index + 1] * a161 >> 16;
		data[index + 2] = data[index + 2] * a161 >> 16;
	}
	image.buffer.premultiplied = true;
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.resize = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	var newBuffer = new lime.graphics.ImageBuffer(new Uint8Array(newWidth * newHeight * 4),newWidth,newHeight);
	var imageWidth = image.width;
	var imageHeight = image.height;
	var data = image.get_data();
	var newData = newBuffer.data;
	var sourceIndex;
	var sourceIndexX;
	var sourceIndexY;
	var sourceIndexXY;
	var index;
	var sourceX;
	var sourceY;
	var u;
	var v;
	var uRatio;
	var vRatio;
	var uOpposite;
	var vOpposite;
	var _g = 0;
	while(_g < newHeight) {
		var y = _g++;
		var _g1 = 0;
		while(_g1 < newWidth) {
			var x = _g1++;
			u = (x + 0.5) / newWidth * imageWidth - 0.5;
			v = (y + 0.5) / newHeight * imageHeight - 0.5;
			sourceX = u | 0;
			sourceY = v | 0;
			sourceIndex = (sourceY * imageWidth + sourceX) * 4;
			if(sourceX < imageWidth - 1) sourceIndexX = sourceIndex + 4; else sourceIndexX = sourceIndex;
			if(sourceY < imageHeight - 1) sourceIndexY = sourceIndex + imageWidth * 4; else sourceIndexY = sourceIndex;
			if(sourceIndexX != sourceIndex) sourceIndexXY = sourceIndexY + 4; else sourceIndexXY = sourceIndexY;
			index = (y * newWidth + x) * 4;
			uRatio = u - sourceX;
			vRatio = v - sourceY;
			uOpposite = 1 - uRatio;
			vOpposite = 1 - vRatio;
			newData[index] = (data[sourceIndex] * uOpposite + data[sourceIndexX] * uRatio) * vOpposite + (data[sourceIndexY] * uOpposite + data[sourceIndexXY] * uRatio) * vRatio | 0;
			newData[index + 1] = (data[sourceIndex + 1] * uOpposite + data[sourceIndexX + 1] * uRatio) * vOpposite + (data[sourceIndexY + 1] * uOpposite + data[sourceIndexXY + 1] * uRatio) * vRatio | 0;
			newData[index + 2] = (data[sourceIndex + 2] * uOpposite + data[sourceIndexX + 2] * uRatio) * vOpposite + (data[sourceIndexY + 2] * uOpposite + data[sourceIndexXY + 2] * uRatio) * vRatio | 0;
			if(data[sourceIndexX + 3] == 0 || data[sourceIndexY + 3] == 0 || data[sourceIndexXY + 3] == 0) newData[index + 3] = 0; else newData[index + 3] = data[sourceIndex + 3];
		}
	}
	buffer.data = newData;
	buffer.width = newWidth;
	buffer.height = newHeight;
};
lime.graphics.utils.ImageDataUtil.resizeBuffer = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	var data = image.get_data();
	var newData = new Uint8Array(newWidth * newHeight * 4);
	var sourceIndex;
	var index;
	var _g1 = 0;
	var _g = buffer.height;
	while(_g1 < _g) {
		var y = _g1++;
		var _g3 = 0;
		var _g2 = buffer.width;
		while(_g3 < _g2) {
			var x = _g3++;
			sourceIndex = (y * buffer.width + x) * 4;
			index = (y * newWidth + x) * 4;
			newData[index] = data[sourceIndex];
			newData[index + 1] = data[sourceIndex + 1];
			newData[index + 2] = data[sourceIndex + 2];
			newData[index + 3] = data[sourceIndex + 3];
		}
	}
	buffer.data = newData;
	buffer.width = newWidth;
	buffer.height = newHeight;
};
lime.graphics.utils.ImageDataUtil.setPixel = function(image,x,y,color) {
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	data[offset] = (color & 16711680) >>> 16;
	data[offset + 1] = (color & 65280) >>> 8;
	data[offset + 2] = color & 255;
	if(image.get_transparent()) data[offset + 3] = 255;
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.setPixel32 = function(image,x,y,color) {
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var a;
	if(image.get_transparent()) a = (color & -16777216) >>> 24; else a = 255;
	if(image.get_transparent() && image.get_premultiplied()) {
		var a16 = lime.graphics.utils.ImageDataUtil.__alpha16[a];
		data[offset] = ((color & 16711680) >>> 16) * a16 >> 16;
		data[offset + 1] = ((color & 65280) >>> 8) * a16 >> 16;
		data[offset + 2] = (color & 255) * a16 >> 16;
		data[offset + 3] = a;
	} else {
		data[offset] = (color & 16711680) >>> 16;
		data[offset + 1] = (color & 65280) >>> 8;
		data[offset + 2] = color & 255;
		data[offset + 3] = a;
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.setPixels = function(image,rect,byteArray) {
	var len = Math.round(rect.width * rect.height);
	var data = image.buffer.data;
	var offset = Math.round(image.buffer.width * (rect.y + image.offsetX) + (rect.x + image.offsetY));
	var pos = offset * 4;
	var boundR = Math.round(rect.x + rect.width + image.offsetX);
	var width = image.buffer.width;
	var color;
	var _g = 0;
	while(_g < len) {
		var i = _g++;
		if(pos % (width * 4) >= boundR * 4) pos += (width - boundR) * 4;
		color = byteArray.readUnsignedInt();
		data[pos++] = (color & 16711680) >>> 16;
		data[pos++] = (color & 65280) >>> 8;
		data[pos++] = color & 255;
		data[pos++] = (color & -16777216) >>> 24;
	}
	image.dirty = true;
};
lime.graphics.utils.ImageDataUtil.unmultiplyAlpha = function(image) {
	var data = image.buffer.data;
	var index;
	var a;
	var unmultiply;
	var length = data.length / 4 | 0;
	var _g = 0;
	while(_g < length) {
		var i = _g++;
		index = i * 4;
		a = data[index + 3];
		if(a != 0) {
			unmultiply = 255.0 / a;
			data[index] = lime.graphics.utils.ImageDataUtil.__clamp[data[index] * unmultiply | 0];
			data[index + 1] = lime.graphics.utils.ImageDataUtil.__clamp[data[index + 1] * unmultiply | 0];
			data[index + 2] = lime.graphics.utils.ImageDataUtil.__clamp[data[index + 2] * unmultiply | 0];
		}
	}
	image.buffer.premultiplied = false;
	image.dirty = true;
};
lime.math = {};
lime.math._ColorMatrix = {};
lime.math._ColorMatrix.ColorMatrix_Impl_ = function() { };
$hxClasses["lime.math._ColorMatrix.ColorMatrix_Impl_"] = lime.math._ColorMatrix.ColorMatrix_Impl_;
lime.math._ColorMatrix.ColorMatrix_Impl_.__name__ = ["lime","math","_ColorMatrix","ColorMatrix_Impl_"];
lime.math._ColorMatrix.ColorMatrix_Impl_.__properties__ = {set_redOffset:"set_redOffset",get_redOffset:"get_redOffset",set_redMultiplier:"set_redMultiplier",get_redMultiplier:"get_redMultiplier",set_greenOffset:"set_greenOffset",get_greenOffset:"get_greenOffset",set_greenMultiplier:"set_greenMultiplier",get_greenMultiplier:"get_greenMultiplier",set_color:"set_color",get_color:"get_color",set_blueOffset:"set_blueOffset",get_blueOffset:"get_blueOffset",set_blueMultiplier:"set_blueMultiplier",get_blueMultiplier:"get_blueMultiplier",set_alphaOffset:"set_alphaOffset",get_alphaOffset:"get_alphaOffset",set_alphaMultiplier:"set_alphaMultiplier",get_alphaMultiplier:"get_alphaMultiplier"}
lime.math._ColorMatrix.ColorMatrix_Impl_._new = function(data) {
	var this1;
	if(data != null && data.length == 20) this1 = data; else this1 = new Float32Array(lime.math._ColorMatrix.ColorMatrix_Impl_.__identity);
	return this1;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.clone = function(this1) {
	return lime.math._ColorMatrix.ColorMatrix_Impl_._new(new Float32Array(this1));
};
lime.math._ColorMatrix.ColorMatrix_Impl_.concat = function(this1,second) {
	var _g = this1;
	var value = _g[0] + second[0];
	_g[0] = value;
	value;
	var _g1 = this1;
	var value1 = _g1[6] + second[6];
	_g1[6] = value1;
	value1;
	var _g2 = this1;
	var value2 = _g2[12] + second[12];
	_g2[12] = value2;
	value2;
	var _g3 = this1;
	var value3 = _g3[18] + second[18];
	_g3[18] = value3;
	value3;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.copyFrom = function(this1,other) {
	this1.set(other);
};
lime.math._ColorMatrix.ColorMatrix_Impl_.identity = function(this1) {
	this1[0] = 1;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 0;
	this1[6] = 1;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 0;
	this1[11] = 0;
	this1[12] = 1;
	this1[13] = 0;
	this1[14] = 0;
	this1[15] = 0;
	this1[16] = 0;
	this1[17] = 0;
	this1[18] = 1;
	this1[19] = 0;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.__toFlashColorTransform = function(this1) {
	return null;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_alphaMultiplier = function(this1) {
	return this1[18];
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_alphaMultiplier = function(this1,value) {
	this1[18] = value;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_alphaOffset = function(this1) {
	return this1[19] * 255;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_alphaOffset = function(this1,value) {
	this1[19] = value / 255;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_blueMultiplier = function(this1) {
	return this1[12];
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_blueMultiplier = function(this1,value) {
	this1[12] = value;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_blueOffset = function(this1) {
	return this1[14] * 255;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_blueOffset = function(this1,value) {
	this1[14] = value / 255;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_color = function(this1) {
	return (this1[4] * 255 | 0) << 16 | (this1[9] * 255 | 0) << 8 | (this1[14] * 255 | 0);
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_color = function(this1,value) {
	var value1 = value >> 16 & 255;
	this1[4] = value1 / 255;
	value1;
	var value2 = value >> 8 & 255;
	this1[9] = value2 / 255;
	value2;
	var value3 = value & 255;
	this1[14] = value3 / 255;
	value3;
	this1[0] = 0;
	0;
	this1[6] = 0;
	0;
	this1[12] = 0;
	0;
	return lime.math._ColorMatrix.ColorMatrix_Impl_.get_color(this1);
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_greenMultiplier = function(this1) {
	return this1[6];
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_greenMultiplier = function(this1,value) {
	this1[6] = value;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_greenOffset = function(this1) {
	return this1[9] * 255;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_greenOffset = function(this1,value) {
	this1[9] = value / 255;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_redMultiplier = function(this1) {
	return this1[0];
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_redMultiplier = function(this1,value) {
	this1[0] = value;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get_redOffset = function(this1) {
	return this1[4] * 255;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set_redOffset = function(this1,value) {
	this1[4] = value / 255;
	return value;
};
lime.math._ColorMatrix.ColorMatrix_Impl_.get = function(this1,index) {
	return this1[index];
};
lime.math._ColorMatrix.ColorMatrix_Impl_.set = function(this1,index,value) {
	this1[index] = value;
	return value;
};
lime.math.Matrix3 = function(a,b,c,d,tx,ty) {
	if(ty == null) ty = 0;
	if(tx == null) tx = 0;
	if(d == null) d = 1;
	if(c == null) c = 0;
	if(b == null) b = 0;
	if(a == null) a = 1;
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	this.tx = tx;
	this.ty = ty;
};
$hxClasses["lime.math.Matrix3"] = lime.math.Matrix3;
lime.math.Matrix3.__name__ = ["lime","math","Matrix3"];
lime.math.Matrix3.prototype = {
	clone: function() {
		return new lime.math.Matrix3(this.a,this.b,this.c,this.d,this.tx,this.ty);
	}
	,concat: function(m) {
		var a1 = this.a * m.a + this.b * m.c;
		this.b = this.a * m.b + this.b * m.d;
		this.a = a1;
		var c1 = this.c * m.a + this.d * m.c;
		this.d = this.c * m.b + this.d * m.d;
		this.c = c1;
		var tx1 = this.tx * m.a + this.ty * m.c + m.tx;
		this.ty = this.tx * m.b + this.ty * m.d + m.ty;
		this.tx = tx1;
	}
	,copyColumnFrom: function(column,vector4) {
		if(column > 2) throw "Column " + column + " out of bounds (2)"; else if(column == 0) {
			this.a = vector4.x;
			this.c = vector4.y;
		} else if(column == 1) {
			this.b = vector4.x;
			this.d = vector4.y;
		} else {
			this.tx = vector4.x;
			this.ty = vector4.y;
		}
	}
	,copyColumnTo: function(column,vector4) {
		if(column > 2) throw "Column " + column + " out of bounds (2)"; else if(column == 0) {
			vector4.x = this.a;
			vector4.y = this.c;
			vector4.z = 0;
		} else if(column == 1) {
			vector4.x = this.b;
			vector4.y = this.d;
			vector4.z = 0;
		} else {
			vector4.x = this.tx;
			vector4.y = this.ty;
			vector4.z = 1;
		}
	}
	,copyFrom: function(sourceMatrix3) {
		this.a = sourceMatrix3.a;
		this.b = sourceMatrix3.b;
		this.c = sourceMatrix3.c;
		this.d = sourceMatrix3.d;
		this.tx = sourceMatrix3.tx;
		this.ty = sourceMatrix3.ty;
	}
	,copyRowFrom: function(row,vector4) {
		if(row > 2) throw "Row " + row + " out of bounds (2)"; else if(row == 0) {
			this.a = vector4.x;
			this.c = vector4.y;
		} else if(row == 1) {
			this.b = vector4.x;
			this.d = vector4.y;
		} else {
			this.tx = vector4.x;
			this.ty = vector4.y;
		}
	}
	,copyRowTo: function(row,vector4) {
		if(row > 2) throw "Row " + row + " out of bounds (2)"; else if(row == 0) {
			vector4.x = this.a;
			vector4.y = this.b;
			vector4.z = this.tx;
		} else if(row == 1) {
			vector4.x = this.c;
			vector4.y = this.d;
			vector4.z = this.ty;
		} else {
			vector4.x = 0;
			vector4.y = 0;
			vector4.z = 1;
		}
	}
	,createBox: function(scaleX,scaleY,rotation,tx,ty) {
		if(ty == null) ty = 0;
		if(tx == null) tx = 0;
		if(rotation == null) rotation = 0;
		this.a = scaleX;
		this.d = scaleY;
		this.b = rotation;
		this.tx = tx;
		this.ty = ty;
	}
	,createGradientBox: function(width,height,rotation,tx,ty) {
		if(ty == null) ty = 0;
		if(tx == null) tx = 0;
		if(rotation == null) rotation = 0;
		this.a = width / 1638.4;
		this.d = height / 1638.4;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.b = sin * this.d;
			this.c = -sin * this.a;
			this.a *= cos;
			this.d *= cos;
		} else {
			this.b = 0;
			this.c = 0;
		}
		this.tx = tx + width / 2;
		this.ty = ty + height / 2;
	}
	,equals: function(Matrix3) {
		return Matrix3 != null && this.tx == Matrix3.tx && this.ty == Matrix3.ty && this.a == Matrix3.a && this.b == Matrix3.b && this.c == Matrix3.c && this.d == Matrix3.d;
	}
	,deltaTransformVector2: function(Vector2) {
		return new lime.math.Vector2(Vector2.x * this.a + Vector2.y * this.c,Vector2.x * this.b + Vector2.y * this.d);
	}
	,identity: function() {
		this.a = 1;
		this.b = 0;
		this.c = 0;
		this.d = 1;
		this.tx = 0;
		this.ty = 0;
	}
	,invert: function() {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			this.a = this.b = this.c = this.d = 0;
			this.tx = -this.tx;
			this.ty = -this.ty;
		} else {
			norm = 1.0 / norm;
			var a1 = this.d * norm;
			this.d = this.a * norm;
			this.a = a1;
			this.b *= -norm;
			this.c *= -norm;
			var tx1 = -this.a * this.tx - this.c * this.ty;
			this.ty = -this.b * this.tx - this.d * this.ty;
			this.tx = tx1;
		}
		return this;
	}
	,mult: function(m) {
		var result = new lime.math.Matrix3(this.a,this.b,this.c,this.d,this.tx,this.ty);
		result.concat(m);
		return result;
	}
	,rotate: function(theta) {
		var cos = Math.cos(theta);
		var sin = Math.sin(theta);
		var a1 = this.a * cos - this.b * sin;
		this.b = this.a * sin + this.b * cos;
		this.a = a1;
		var c1 = this.c * cos - this.d * sin;
		this.d = this.c * sin + this.d * cos;
		this.c = c1;
		var tx1 = this.tx * cos - this.ty * sin;
		this.ty = this.tx * sin + this.ty * cos;
		this.tx = tx1;
	}
	,scale: function(sx,sy) {
		this.a *= sx;
		this.b *= sy;
		this.c *= sx;
		this.d *= sy;
		this.tx *= sx;
		this.ty *= sy;
	}
	,setRotation: function(theta,scale) {
		if(scale == null) scale = 1;
		this.a = Math.cos(theta) * scale;
		this.c = Math.sin(theta) * scale;
		this.b = -this.c;
		this.d = this.a;
	}
	,setTo: function(a,b,c,d,tx,ty) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		this.tx = tx;
		this.ty = ty;
	}
	,to3DString: function(roundPixels) {
		if(roundPixels == null) roundPixels = false;
		if(roundPixels) return "Matrix33d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + (this.tx | 0) + ", " + (this.ty | 0) + ", 0, 1)"; else return "Matrix33d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + this.tx + ", " + this.ty + ", 0, 1)";
	}
	,toMozString: function() {
		return "Matrix3(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + "px, " + this.ty + "px)";
	}
	,toString: function() {
		return "Matrix3(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + ", " + this.ty + ")";
	}
	,transformVector2: function(pos) {
		return new lime.math.Vector2(pos.x * this.a + pos.y * this.c + this.tx,pos.x * this.b + pos.y * this.d + this.ty);
	}
	,translate: function(dx,dy) {
		var m = new lime.math.Matrix3();
		m.tx = dx;
		m.ty = dy;
		this.concat(m);
	}
	,__cleanValues: function() {
		this.a = Math.round(this.a * 1000) / 1000;
		this.b = Math.round(this.b * 1000) / 1000;
		this.c = Math.round(this.c * 1000) / 1000;
		this.d = Math.round(this.d * 1000) / 1000;
		this.tx = Math.round(this.tx * 10) / 10;
		this.ty = Math.round(this.ty * 10) / 10;
	}
	,__transformX: function(pos) {
		return pos.x * this.a + pos.y * this.c + this.tx;
	}
	,__transformY: function(pos) {
		return pos.x * this.b + pos.y * this.d + this.ty;
	}
	,__translateTransformed: function(pos) {
		this.tx = pos.x * this.a + pos.y * this.c + this.tx;
		this.ty = pos.x * this.b + pos.y * this.d + this.ty;
	}
	,__class__: lime.math.Matrix3
};
lime.math._Matrix4 = {};
lime.math._Matrix4.Matrix4_Impl_ = function() { };
$hxClasses["lime.math._Matrix4.Matrix4_Impl_"] = lime.math._Matrix4.Matrix4_Impl_;
lime.math._Matrix4.Matrix4_Impl_.__name__ = ["lime","math","_Matrix4","Matrix4_Impl_"];
lime.math._Matrix4.Matrix4_Impl_.__properties__ = {set_position:"set_position",get_position:"get_position",get_determinant:"get_determinant"}
lime.math._Matrix4.Matrix4_Impl_._new = function(data) {
	var this1;
	if(data != null && data.length == 16) this1 = data; else this1 = new Float32Array(lime.math._Matrix4.Matrix4_Impl_.__identity);
	return this1;
};
lime.math._Matrix4.Matrix4_Impl_.append = function(this1,lhs) {
	var m111 = this1[0];
	var m121 = this1[4];
	var m131 = this1[8];
	var m141 = this1[12];
	var m112 = this1[1];
	var m122 = this1[5];
	var m132 = this1[9];
	var m142 = this1[13];
	var m113 = this1[2];
	var m123 = this1[6];
	var m133 = this1[10];
	var m143 = this1[14];
	var m114 = this1[3];
	var m124 = this1[7];
	var m134 = this1[11];
	var m144 = this1[15];
	var m211 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,0);
	var m221 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,4);
	var m231 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,8);
	var m241 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,12);
	var m212 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,1);
	var m222 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,5);
	var m232 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,9);
	var m242 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,13);
	var m213 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,2);
	var m223 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,6);
	var m233 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,10);
	var m243 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,14);
	var m214 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,3);
	var m224 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,7);
	var m234 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,11);
	var m244 = lime.math._Matrix4.Matrix4_Impl_.get(lhs,15);
	this1[0] = m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241;
	this1[1] = m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242;
	this1[2] = m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243;
	this1[3] = m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244;
	this1[4] = m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241;
	this1[5] = m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242;
	this1[6] = m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243;
	this1[7] = m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244;
	this1[8] = m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241;
	this1[9] = m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242;
	this1[10] = m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243;
	this1[11] = m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244;
	this1[12] = m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241;
	this1[13] = m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242;
	this1[14] = m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243;
	this1[15] = m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244;
};
lime.math._Matrix4.Matrix4_Impl_.appendRotation = function(this1,degrees,axis,pivotPoint) {
	var m = lime.math._Matrix4.Matrix4_Impl_.getAxisRotation(axis.x,axis.y,axis.z,degrees);
	if(pivotPoint != null) {
		var p = pivotPoint;
		lime.math._Matrix4.Matrix4_Impl_.appendTranslation(m,p.x,p.y,p.z);
	}
	lime.math._Matrix4.Matrix4_Impl_.append(this1,m);
};
lime.math._Matrix4.Matrix4_Impl_.appendScale = function(this1,xScale,yScale,zScale) {
	lime.math._Matrix4.Matrix4_Impl_.append(this1,lime.math._Matrix4.Matrix4_Impl_._new(new Float32Array([xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0])));
};
lime.math._Matrix4.Matrix4_Impl_.appendTranslation = function(this1,x,y,z) {
	this1[12] = this1[12] + x;
	this1[13] = this1[13] + y;
	this1[14] = this1[14] + z;
};
lime.math._Matrix4.Matrix4_Impl_.clone = function(this1) {
	return lime.math._Matrix4.Matrix4_Impl_._new(new Float32Array(this1));
};
lime.math._Matrix4.Matrix4_Impl_.copyColumnFrom = function(this1,column,vector) {
	switch(column) {
	case 0:
		this1[0] = vector.x;
		this1[1] = vector.y;
		this1[2] = vector.z;
		this1[3] = vector.w;
		break;
	case 1:
		this1[4] = vector.x;
		this1[5] = vector.y;
		this1[6] = vector.z;
		this1[7] = vector.w;
		break;
	case 2:
		this1[8] = vector.x;
		this1[9] = vector.y;
		this1[10] = vector.z;
		this1[11] = vector.w;
		break;
	case 3:
		this1[12] = vector.x;
		this1[13] = vector.y;
		this1[14] = vector.z;
		this1[15] = vector.w;
		break;
	default:
		throw "Error, Column " + column + " out of bounds [0, ..., 3]";
	}
};
lime.math._Matrix4.Matrix4_Impl_.copyColumnTo = function(this1,column,vector) {
	switch(column) {
	case 0:
		vector.x = this1[0];
		vector.y = this1[1];
		vector.z = this1[2];
		vector.w = this1[3];
		break;
	case 1:
		vector.x = this1[4];
		vector.y = this1[5];
		vector.z = this1[6];
		vector.w = this1[7];
		break;
	case 2:
		vector.x = this1[8];
		vector.y = this1[9];
		vector.z = this1[10];
		vector.w = this1[11];
		break;
	case 3:
		vector.x = this1[12];
		vector.y = this1[13];
		vector.z = this1[14];
		vector.w = this1[15];
		break;
	default:
		throw "Error, Column " + column + " out of bounds [0, ..., 3]";
	}
};
lime.math._Matrix4.Matrix4_Impl_.copyFrom = function(this1,other) {
	this1.set(other);
};
lime.math._Matrix4.Matrix4_Impl_.copythisFrom = function(this1,array,index,transposeValues) {
	if(transposeValues == null) transposeValues = false;
	if(index == null) index = 0;
	if(transposeValues) lime.math._Matrix4.Matrix4_Impl_.transpose(this1);
	var l = array.length - index;
	var _g = 0;
	while(_g < l) {
		var c = _g++;
		this1[c] = array[c + index];
	}
	if(transposeValues) lime.math._Matrix4.Matrix4_Impl_.transpose(this1);
};
lime.math._Matrix4.Matrix4_Impl_.copythisTo = function(this1,array,index,transposeValues) {
	if(transposeValues == null) transposeValues = false;
	if(index == null) index = 0;
	if(transposeValues) lime.math._Matrix4.Matrix4_Impl_.transpose(this1);
	var l = this1.length;
	var _g = 0;
	while(_g < l) {
		var c = _g++;
		array[c + index] = this1[c];
	}
	if(transposeValues) lime.math._Matrix4.Matrix4_Impl_.transpose(this1);
};
lime.math._Matrix4.Matrix4_Impl_.copyRowFrom = function(this1,row,vector) {
	switch(row) {
	case 0:
		this1[0] = vector.x;
		this1[4] = vector.y;
		this1[8] = vector.z;
		this1[12] = vector.w;
		break;
	case 1:
		this1[1] = vector.x;
		this1[5] = vector.y;
		this1[9] = vector.z;
		this1[13] = vector.w;
		break;
	case 2:
		this1[2] = vector.x;
		this1[6] = vector.y;
		this1[10] = vector.z;
		this1[14] = vector.w;
		break;
	case 3:
		this1[3] = vector.x;
		this1[7] = vector.y;
		this1[11] = vector.z;
		this1[15] = vector.w;
		break;
	default:
		throw "Error, Row " + Std.string((function($this) {
			var $r;
			var $int = row;
			$r = $int < 0?4294967296.0 + $int:$int + 0.0;
			return $r;
		}(this))) + " out of bounds [0, ..., 3]";
	}
};
lime.math._Matrix4.Matrix4_Impl_.create2D = function(x,y,scale,rotation) {
	if(rotation == null) rotation = 0;
	if(scale == null) scale = 1;
	var theta = rotation * Math.PI / 180.0;
	var c = Math.cos(theta);
	var s = Math.sin(theta);
	return lime.math._Matrix4.Matrix4_Impl_._new(new Float32Array([c * scale,-s * scale,0,0,s * scale,c * scale,0,0,0,0,1,0,x,y,0,1]));
};
lime.math._Matrix4.Matrix4_Impl_.createABCD = function(a,b,c,d,tx,ty) {
	return lime.math._Matrix4.Matrix4_Impl_._new(new Float32Array([a,b,0,0,c,d,0,0,0,0,1,0,tx,ty,0,1]));
};
lime.math._Matrix4.Matrix4_Impl_.createOrtho = function(x0,x1,y0,y1,zNear,zFar) {
	var sx = 1.0 / (x1 - x0);
	var sy = 1.0 / (y1 - y0);
	var sz = 1.0 / (zFar - zNear);
	return lime.math._Matrix4.Matrix4_Impl_._new(new Float32Array([2.0 * sx,0,0,0,0,2.0 * sy,0,0,0,0,-2. * sz,0,-(x0 + x1) * sx,-(y0 + y1) * sy,-(zNear + zFar) * sz,1]));
};
lime.math._Matrix4.Matrix4_Impl_.copyRowTo = function(this1,row,vector) {
	switch(row) {
	case 0:
		vector.x = this1[0];
		vector.y = this1[4];
		vector.z = this1[8];
		vector.w = this1[12];
		break;
	case 1:
		vector.x = this1[1];
		vector.y = this1[5];
		vector.z = this1[9];
		vector.w = this1[13];
		break;
	case 2:
		vector.x = this1[2];
		vector.y = this1[6];
		vector.z = this1[10];
		vector.w = this1[14];
		break;
	case 3:
		vector.x = this1[3];
		vector.y = this1[7];
		vector.z = this1[11];
		vector.w = this1[15];
		break;
	default:
		throw "Error, Row " + row + " out of bounds [0, ..., 3]";
	}
};
lime.math._Matrix4.Matrix4_Impl_.copyToMatrix4 = function(this1,other) {
	(js.Boot.__cast(other , Float32Array)).set(this1);
};
lime.math._Matrix4.Matrix4_Impl_.deltaTransformVector = function(this1,v) {
	var x = v.x;
	var y = v.y;
	var z = v.z;
	return new lime.math.Vector4(x * this1[0] + y * this1[4] + z * this1[8] + this1[3],x * this1[1] + y * this1[5] + z * this1[9] + this1[7],x * this1[2] + y * this1[6] + z * this1[10] + this1[11],0);
};
lime.math._Matrix4.Matrix4_Impl_.identity = function(this1) {
	this1[0] = 1;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 1;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 1;
	this1[11] = 0;
	this1[12] = 0;
	this1[13] = 0;
	this1[14] = 0;
	this1[15] = 1;
};
lime.math._Matrix4.Matrix4_Impl_.interpolate = function(thisMat,toMat,percent) {
	var m = lime.math._Matrix4.Matrix4_Impl_._new();
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		lime.math._Matrix4.Matrix4_Impl_.set(m,i,lime.math._Matrix4.Matrix4_Impl_.get(thisMat,i) + (lime.math._Matrix4.Matrix4_Impl_.get(toMat,i) - lime.math._Matrix4.Matrix4_Impl_.get(thisMat,i)) * percent);
	}
	return m;
};
lime.math._Matrix4.Matrix4_Impl_.interpolateTo = function(this1,toMat,percent) {
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		this1[i] = this1[i] + (lime.math._Matrix4.Matrix4_Impl_.get(toMat,i) - this1[i]) * percent;
	}
};
lime.math._Matrix4.Matrix4_Impl_.invert = function(this1) {
	var d = lime.math._Matrix4.Matrix4_Impl_.get_determinant(this1);
	var invertable = Math.abs(d) > 0.00000000001;
	if(invertable) {
		d = 1 / d;
		var m11 = this1[0];
		var m21 = this1[4];
		var m31 = this1[8];
		var m41 = this1[12];
		var m12 = this1[1];
		var m22 = this1[5];
		var m32 = this1[9];
		var m42 = this1[13];
		var m13 = this1[2];
		var m23 = this1[6];
		var m33 = this1[10];
		var m43 = this1[14];
		var m14 = this1[3];
		var m24 = this1[7];
		var m34 = this1[11];
		var m44 = this1[15];
		this1[0] = d * (m22 * (m33 * m44 - m43 * m34) - m32 * (m23 * m44 - m43 * m24) + m42 * (m23 * m34 - m33 * m24));
		this1[1] = -d * (m12 * (m33 * m44 - m43 * m34) - m32 * (m13 * m44 - m43 * m14) + m42 * (m13 * m34 - m33 * m14));
		this1[2] = d * (m12 * (m23 * m44 - m43 * m24) - m22 * (m13 * m44 - m43 * m14) + m42 * (m13 * m24 - m23 * m14));
		this1[3] = -d * (m12 * (m23 * m34 - m33 * m24) - m22 * (m13 * m34 - m33 * m14) + m32 * (m13 * m24 - m23 * m14));
		this1[4] = -d * (m21 * (m33 * m44 - m43 * m34) - m31 * (m23 * m44 - m43 * m24) + m41 * (m23 * m34 - m33 * m24));
		this1[5] = d * (m11 * (m33 * m44 - m43 * m34) - m31 * (m13 * m44 - m43 * m14) + m41 * (m13 * m34 - m33 * m14));
		this1[6] = -d * (m11 * (m23 * m44 - m43 * m24) - m21 * (m13 * m44 - m43 * m14) + m41 * (m13 * m24 - m23 * m14));
		this1[7] = d * (m11 * (m23 * m34 - m33 * m24) - m21 * (m13 * m34 - m33 * m14) + m31 * (m13 * m24 - m23 * m14));
		this1[8] = d * (m21 * (m32 * m44 - m42 * m34) - m31 * (m22 * m44 - m42 * m24) + m41 * (m22 * m34 - m32 * m24));
		this1[9] = -d * (m11 * (m32 * m44 - m42 * m34) - m31 * (m12 * m44 - m42 * m14) + m41 * (m12 * m34 - m32 * m14));
		this1[10] = d * (m11 * (m22 * m44 - m42 * m24) - m21 * (m12 * m44 - m42 * m14) + m41 * (m12 * m24 - m22 * m14));
		this1[11] = -d * (m11 * (m22 * m34 - m32 * m24) - m21 * (m12 * m34 - m32 * m14) + m31 * (m12 * m24 - m22 * m14));
		this1[12] = -d * (m21 * (m32 * m43 - m42 * m33) - m31 * (m22 * m43 - m42 * m23) + m41 * (m22 * m33 - m32 * m23));
		this1[13] = d * (m11 * (m32 * m43 - m42 * m33) - m31 * (m12 * m43 - m42 * m13) + m41 * (m12 * m33 - m32 * m13));
		this1[14] = -d * (m11 * (m22 * m43 - m42 * m23) - m21 * (m12 * m43 - m42 * m13) + m41 * (m12 * m23 - m22 * m13));
		this1[15] = d * (m11 * (m22 * m33 - m32 * m23) - m21 * (m12 * m33 - m32 * m13) + m31 * (m12 * m23 - m22 * m13));
	}
	return invertable;
};
lime.math._Matrix4.Matrix4_Impl_.pointAt = function(this1,pos,at,up) {
	if(at == null) at = new lime.math.Vector4(0,0,-1);
	if(up == null) up = new lime.math.Vector4(0,-1,0);
	var dir = new lime.math.Vector4(at.x - pos.x,at.y - pos.y,at.z - pos.z);
	var vup = new lime.math.Vector4(up.x,up.y,up.z,up.w);
	var right;
	dir.normalize();
	vup.normalize();
	var dir2 = new lime.math.Vector4(dir.x,dir.y,dir.z,dir.w);
	dir2.scaleBy(vup.x * dir.x + vup.y * dir.y + vup.z * dir.z);
	vup = new lime.math.Vector4(vup.x - dir2.x,vup.y - dir2.y,vup.z - dir2.z);
	if(Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z) > 0) vup.normalize(); else if(dir.x != 0) vup = new lime.math.Vector4(-dir.y,dir.x,0); else vup = new lime.math.Vector4(1,0,0);
	right = new lime.math.Vector4(vup.y * dir.z - vup.z * dir.y,vup.z * dir.x - vup.x * dir.z,vup.x * dir.y - vup.y * dir.x,1);
	right.normalize();
	this1[0] = right.x;
	this1[4] = right.y;
	this1[8] = right.z;
	this1[12] = 0.0;
	this1[1] = vup.x;
	this1[5] = vup.y;
	this1[9] = vup.z;
	this1[13] = 0.0;
	this1[2] = dir.x;
	this1[6] = dir.y;
	this1[10] = dir.z;
	this1[14] = 0.0;
	this1[3] = pos.x;
	this1[7] = pos.y;
	this1[11] = pos.z;
	this1[15] = 1.0;
};
lime.math._Matrix4.Matrix4_Impl_.prepend = function(this1,rhs) {
	var m111 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,0);
	var m121 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,4);
	var m131 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,8);
	var m141 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,12);
	var m112 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,1);
	var m122 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,5);
	var m132 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,9);
	var m142 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,13);
	var m113 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,2);
	var m123 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,6);
	var m133 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,10);
	var m143 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,14);
	var m114 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,3);
	var m124 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,7);
	var m134 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,11);
	var m144 = lime.math._Matrix4.Matrix4_Impl_.get(rhs,15);
	var m211 = this1[0];
	var m221 = this1[4];
	var m231 = this1[8];
	var m241 = this1[12];
	var m212 = this1[1];
	var m222 = this1[5];
	var m232 = this1[9];
	var m242 = this1[13];
	var m213 = this1[2];
	var m223 = this1[6];
	var m233 = this1[10];
	var m243 = this1[14];
	var m214 = this1[3];
	var m224 = this1[7];
	var m234 = this1[11];
	var m244 = this1[15];
	this1[0] = m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241;
	this1[1] = m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242;
	this1[2] = m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243;
	this1[3] = m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244;
	this1[4] = m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241;
	this1[5] = m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242;
	this1[6] = m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243;
	this1[7] = m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244;
	this1[8] = m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241;
	this1[9] = m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242;
	this1[10] = m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243;
	this1[11] = m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244;
	this1[12] = m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241;
	this1[13] = m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242;
	this1[14] = m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243;
	this1[15] = m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244;
};
lime.math._Matrix4.Matrix4_Impl_.prependRotation = function(this1,degrees,axis,pivotPoint) {
	var m = lime.math._Matrix4.Matrix4_Impl_.getAxisRotation(axis.x,axis.y,axis.z,degrees);
	if(pivotPoint != null) {
		var p = pivotPoint;
		lime.math._Matrix4.Matrix4_Impl_.appendTranslation(m,p.x,p.y,p.z);
	}
	lime.math._Matrix4.Matrix4_Impl_.prepend(this1,m);
};
lime.math._Matrix4.Matrix4_Impl_.prependScale = function(this1,xScale,yScale,zScale) {
	lime.math._Matrix4.Matrix4_Impl_.prepend(this1,lime.math._Matrix4.Matrix4_Impl_._new(new Float32Array([xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0])));
};
lime.math._Matrix4.Matrix4_Impl_.prependTranslation = function(this1,x,y,z) {
	var m = lime.math._Matrix4.Matrix4_Impl_._new();
	lime.math._Matrix4.Matrix4_Impl_.set_position(m,new lime.math.Vector4(x,y,z));
	lime.math._Matrix4.Matrix4_Impl_.prepend(this1,m);
};
lime.math._Matrix4.Matrix4_Impl_.transformVector = function(this1,v) {
	var x = v.x;
	var y = v.y;
	var z = v.z;
	return new lime.math.Vector4(x * this1[0] + y * this1[4] + z * this1[8] + this1[12],x * this1[1] + y * this1[5] + z * this1[9] + this1[13],x * this1[2] + y * this1[6] + z * this1[10] + this1[14],x * this1[3] + y * this1[7] + z * this1[11] + this1[15]);
};
lime.math._Matrix4.Matrix4_Impl_.transformVectors = function(this1,ain,aout) {
	var i = 0;
	while(i + 3 <= ain.length) {
		var x = ain[i];
		var y = ain[i + 1];
		var z = ain[i + 2];
		aout[i] = x * this1[0] + y * this1[4] + z * this1[8] + this1[12];
		aout[i + 1] = x * this1[1] + y * this1[5] + z * this1[9] + this1[13];
		aout[i + 2] = x * this1[2] + y * this1[6] + z * this1[10] + this1[14];
		i += 3;
	}
};
lime.math._Matrix4.Matrix4_Impl_.transpose = function(this1) {
	var othis = new Float32Array(this1);
	this1[1] = othis[4];
	this1[2] = othis[8];
	this1[3] = othis[12];
	this1[4] = othis[1];
	this1[6] = othis[9];
	this1[7] = othis[13];
	this1[8] = othis[2];
	this1[9] = othis[6];
	this1[11] = othis[14];
	this1[12] = othis[3];
	this1[13] = othis[7];
	this1[14] = othis[11];
};
lime.math._Matrix4.Matrix4_Impl_.getAxisRotation = function(x,y,z,degrees) {
	var m = lime.math._Matrix4.Matrix4_Impl_._new();
	var a1 = new lime.math.Vector4(x,y,z);
	var rad = -degrees * (Math.PI / 180);
	var c = Math.cos(rad);
	var s = Math.sin(rad);
	var t = 1.0 - c;
	lime.math._Matrix4.Matrix4_Impl_.set(m,0,c + a1.x * a1.x * t);
	lime.math._Matrix4.Matrix4_Impl_.set(m,5,c + a1.y * a1.y * t);
	lime.math._Matrix4.Matrix4_Impl_.set(m,10,c + a1.z * a1.z * t);
	var tmp1 = a1.x * a1.y * t;
	var tmp2 = a1.z * s;
	lime.math._Matrix4.Matrix4_Impl_.set(m,4,tmp1 + tmp2);
	lime.math._Matrix4.Matrix4_Impl_.set(m,1,tmp1 - tmp2);
	tmp1 = a1.x * a1.z * t;
	tmp2 = a1.y * s;
	lime.math._Matrix4.Matrix4_Impl_.set(m,8,tmp1 - tmp2);
	lime.math._Matrix4.Matrix4_Impl_.set(m,2,tmp1 + tmp2);
	tmp1 = a1.y * a1.z * t;
	tmp2 = a1.x * s;
	lime.math._Matrix4.Matrix4_Impl_.set(m,9,tmp1 + tmp2);
	lime.math._Matrix4.Matrix4_Impl_.set(m,6,tmp1 - tmp2);
	return m;
};
lime.math._Matrix4.Matrix4_Impl_.get_determinant = function(this1) {
	return (this1[0] * this1[5] - this1[4] * this1[1]) * (this1[10] * this1[15] - this1[14] * this1[11]) - (this1[0] * this1[9] - this1[8] * this1[1]) * (this1[6] * this1[15] - this1[14] * this1[7]) + (this1[0] * this1[13] - this1[12] * this1[1]) * (this1[6] * this1[11] - this1[10] * this1[7]) + (this1[4] * this1[9] - this1[8] * this1[5]) * (this1[2] * this1[15] - this1[14] * this1[3]) - (this1[4] * this1[13] - this1[12] * this1[5]) * (this1[2] * this1[11] - this1[10] * this1[3]) + (this1[8] * this1[13] - this1[12] * this1[9]) * (this1[2] * this1[7] - this1[6] * this1[3]);
};
lime.math._Matrix4.Matrix4_Impl_.get_position = function(this1) {
	return new lime.math.Vector4(this1[12],this1[13],this1[14]);
};
lime.math._Matrix4.Matrix4_Impl_.set_position = function(this1,val) {
	this1[12] = val.x;
	this1[13] = val.y;
	this1[14] = val.z;
	return val;
};
lime.math._Matrix4.Matrix4_Impl_.get = function(this1,index) {
	return this1[index];
};
lime.math._Matrix4.Matrix4_Impl_.set = function(this1,index,value) {
	this1[index] = value;
	return value;
};
lime.math.Rectangle = function(x,y,width,height) {
	if(height == null) height = 0;
	if(width == null) width = 0;
	if(y == null) y = 0;
	if(x == null) x = 0;
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
};
$hxClasses["lime.math.Rectangle"] = lime.math.Rectangle;
lime.math.Rectangle.__name__ = ["lime","math","Rectangle"];
lime.math.Rectangle.prototype = {
	clone: function() {
		return new lime.math.Rectangle(this.x,this.y,this.width,this.height);
	}
	,contains: function(x,y) {
		return x >= this.x && y >= this.y && x < this.get_right() && y < this.get_bottom();
	}
	,containsPoint: function(point) {
		return this.contains(point.x,point.y);
	}
	,containsRect: function(rect) {
		if(rect.width <= 0 || rect.height <= 0) return rect.x > this.x && rect.y > this.y && rect.get_right() < this.get_right() && rect.get_bottom() < this.get_bottom(); else return rect.x >= this.x && rect.y >= this.y && rect.get_right() <= this.get_right() && rect.get_bottom() <= this.get_bottom();
	}
	,copyFrom: function(sourceRect) {
		this.x = sourceRect.x;
		this.y = sourceRect.y;
		this.width = sourceRect.width;
		this.height = sourceRect.height;
	}
	,equals: function(toCompare) {
		return toCompare != null && this.x == toCompare.x && this.y == toCompare.y && this.width == toCompare.width && this.height == toCompare.height;
	}
	,inflate: function(dx,dy) {
		this.x -= dx;
		this.width += dx * 2;
		this.y -= dy;
		this.height += dy * 2;
	}
	,inflatePoint: function(point) {
		this.inflate(point.x,point.y);
	}
	,intersection: function(toIntersect) {
		var x0;
		if(this.x < toIntersect.x) x0 = toIntersect.x; else x0 = this.x;
		var x1;
		if(this.get_right() > toIntersect.get_right()) x1 = toIntersect.get_right(); else x1 = this.get_right();
		if(x1 <= x0) return new lime.math.Rectangle();
		var y0;
		if(this.y < toIntersect.y) y0 = toIntersect.y; else y0 = this.y;
		var y1;
		if(this.get_bottom() > toIntersect.get_bottom()) y1 = toIntersect.get_bottom(); else y1 = this.get_bottom();
		if(y1 <= y0) return new lime.math.Rectangle();
		return new lime.math.Rectangle(x0,y0,x1 - x0,y1 - y0);
	}
	,intersects: function(toIntersect) {
		var x0;
		if(this.x < toIntersect.x) x0 = toIntersect.x; else x0 = this.x;
		var x1;
		if(this.get_right() > toIntersect.get_right()) x1 = toIntersect.get_right(); else x1 = this.get_right();
		if(x1 <= x0) return false;
		var y0;
		if(this.y < toIntersect.y) y0 = toIntersect.y; else y0 = this.y;
		var y1;
		if(this.get_bottom() > toIntersect.get_bottom()) y1 = toIntersect.get_bottom(); else y1 = this.get_bottom();
		return y1 > y0;
	}
	,isEmpty: function() {
		return this.width <= 0 || this.height <= 0;
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,offsetPoint: function(point) {
		this.x += point.x;
		this.y += point.y;
	}
	,setEmpty: function() {
		this.x = this.y = this.width = this.height = 0;
	}
	,setTo: function(xa,ya,widtha,heighta) {
		this.x = xa;
		this.y = ya;
		this.width = widtha;
		this.height = heighta;
	}
	,transform: function(m) {
		var tx0 = m.a * this.x + m.c * this.y;
		var tx1 = tx0;
		var ty0 = m.b * this.x + m.d * this.y;
		var ty1 = tx0;
		var tx = m.a * (this.x + this.width) + m.c * this.y;
		var ty = m.b * (this.x + this.width) + m.d * this.y;
		if(tx < tx0) tx0 = tx;
		if(ty < ty0) ty0 = ty;
		if(tx > tx1) tx1 = tx;
		if(ty > ty1) ty1 = ty;
		tx = m.a * (this.x + this.width) + m.c * (this.y + this.height);
		ty = m.b * (this.x + this.width) + m.d * (this.y + this.height);
		if(tx < tx0) tx0 = tx;
		if(ty < ty0) ty0 = ty;
		if(tx > tx1) tx1 = tx;
		if(ty > ty1) ty1 = ty;
		tx = m.a * this.x + m.c * (this.y + this.height);
		ty = m.b * this.x + m.d * (this.y + this.height);
		if(tx < tx0) tx0 = tx;
		if(ty < ty0) ty0 = ty;
		if(tx > tx1) tx1 = tx;
		if(ty > ty1) ty1 = ty;
		return new lime.math.Rectangle(tx0 + m.tx,ty0 + m.ty,tx1 - tx0,ty1 - ty0);
	}
	,union: function(toUnion) {
		if(this.width == 0 || this.height == 0) return toUnion.clone(); else if(toUnion.width == 0 || toUnion.height == 0) return this.clone();
		var x0;
		if(this.x > toUnion.x) x0 = toUnion.x; else x0 = this.x;
		var x1;
		if(this.get_right() < toUnion.get_right()) x1 = toUnion.get_right(); else x1 = this.get_right();
		var y0;
		if(this.y > toUnion.y) y0 = toUnion.y; else y0 = this.y;
		var y1;
		if(this.get_bottom() < toUnion.get_bottom()) y1 = toUnion.get_bottom(); else y1 = this.get_bottom();
		return new lime.math.Rectangle(x0,y0,x1 - x0,y1 - y0);
	}
	,__contract: function(x,y,width,height) {
		if(this.width == 0 && this.height == 0) return;
		var cacheRight = this.get_right();
		var cacheBottom = this.get_bottom();
		if(this.x < x) this.x = x;
		if(this.y < y) this.y = y;
		if(this.get_right() > x + width) this.width = x + width - this.x;
		if(this.get_bottom() > y + height) this.height = y + height - this.y;
	}
	,__expand: function(x,y,width,height) {
		if(this.width == 0 && this.height == 0) {
			this.x = x;
			this.y = y;
			this.width = width;
			this.height = height;
			return;
		}
		var cacheRight = this.get_right();
		var cacheBottom = this.get_bottom();
		if(this.x > x) this.x = x;
		if(this.y > y) this.y = y;
		if(cacheRight < x + width) this.width = x + width - this.x;
		if(cacheBottom < y + height) this.height = y + height - this.y;
	}
	,__toFlashRectangle: function() {
		return null;
	}
	,get_bottom: function() {
		return this.y + this.height;
	}
	,set_bottom: function(b) {
		this.height = b - this.y;
		return b;
	}
	,get_bottomRight: function() {
		return new lime.math.Vector2(this.x + this.width,this.y + this.height);
	}
	,set_bottomRight: function(p) {
		this.width = p.x - this.x;
		this.height = p.y - this.y;
		return p.clone();
	}
	,get_left: function() {
		return this.x;
	}
	,set_left: function(l) {
		this.width -= l - this.x;
		this.x = l;
		return l;
	}
	,get_right: function() {
		return this.x + this.width;
	}
	,set_right: function(r) {
		this.width = r - this.x;
		return r;
	}
	,get_size: function() {
		return new lime.math.Vector2(this.width,this.height);
	}
	,set_size: function(p) {
		this.width = p.x;
		this.height = p.y;
		return p.clone();
	}
	,get_top: function() {
		return this.y;
	}
	,set_top: function(t) {
		this.height -= t - this.y;
		this.y = t;
		return t;
	}
	,get_topLeft: function() {
		return new lime.math.Vector2(this.x,this.y);
	}
	,set_topLeft: function(p) {
		this.x = p.x;
		this.y = p.y;
		return p.clone();
	}
	,__class__: lime.math.Rectangle
	,__properties__: {set_topLeft:"set_topLeft",get_topLeft:"get_topLeft",set_top:"set_top",get_top:"get_top",set_size:"set_size",get_size:"get_size",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_bottomRight:"set_bottomRight",get_bottomRight:"get_bottomRight",set_bottom:"set_bottom",get_bottom:"get_bottom"}
};
lime.math.Vector2 = function(x,y) {
	if(y == null) y = 0;
	if(x == null) x = 0;
	this.x = x;
	this.y = y;
};
$hxClasses["lime.math.Vector2"] = lime.math.Vector2;
lime.math.Vector2.__name__ = ["lime","math","Vector2"];
lime.math.Vector2.distance = function(pt1,pt2) {
	var dx = pt1.x - pt2.x;
	var dy = pt1.y - pt2.y;
	return Math.sqrt(dx * dx + dy * dy);
};
lime.math.Vector2.interpolate = function(pt1,pt2,f) {
	return new lime.math.Vector2(pt2.x + f * (pt1.x - pt2.x),pt2.y + f * (pt1.y - pt2.y));
};
lime.math.Vector2.polar = function(len,angle) {
	return new lime.math.Vector2(len * Math.cos(angle),len * Math.sin(angle));
};
lime.math.Vector2.prototype = {
	add: function(v) {
		return new lime.math.Vector2(v.x + this.x,v.y + this.y);
	}
	,clone: function() {
		return new lime.math.Vector2(this.x,this.y);
	}
	,equals: function(toCompare) {
		return toCompare != null && toCompare.x == this.x && toCompare.y == this.y;
	}
	,normalize: function(thickness) {
		if(this.x == 0 && this.y == 0) return; else {
			var norm = thickness / Math.sqrt(this.x * this.x + this.y * this.y);
			this.x *= norm;
			this.y *= norm;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,setTo: function(xa,ya) {
		this.x = xa;
		this.y = ya;
	}
	,subtract: function(v) {
		return new lime.math.Vector2(this.x - v.x,this.y - v.y);
	}
	,__toFlashPoint: function() {
		return null;
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y);
	}
	,__class__: lime.math.Vector2
	,__properties__: {get_length:"get_length"}
};
lime.math.Vector4 = function(x,y,z,w) {
	if(w == null) w = 0.;
	if(z == null) z = 0.;
	if(y == null) y = 0.;
	if(x == null) x = 0.;
	this.w = w;
	this.x = x;
	this.y = y;
	this.z = z;
};
$hxClasses["lime.math.Vector4"] = lime.math.Vector4;
lime.math.Vector4.__name__ = ["lime","math","Vector4"];
lime.math.Vector4.__properties__ = {get_Z_AXIS:"get_Z_AXIS",get_Y_AXIS:"get_Y_AXIS",get_X_AXIS:"get_X_AXIS"}
lime.math.Vector4.X_AXIS = null;
lime.math.Vector4.Y_AXIS = null;
lime.math.Vector4.Z_AXIS = null;
lime.math.Vector4.angleBetween = function(a,b) {
	var a0 = new lime.math.Vector4(a.x,a.y,a.z,a.w);
	a0.normalize();
	var b0 = new lime.math.Vector4(b.x,b.y,b.z,b.w);
	b0.normalize();
	return Math.acos(a0.x * b0.x + a0.y * b0.y + a0.z * b0.z);
};
lime.math.Vector4.distance = function(pt1,pt2) {
	var x = pt2.x - pt1.x;
	var y = pt2.y - pt1.y;
	var z = pt2.z - pt1.z;
	return Math.sqrt(x * x + y * y + z * z);
};
lime.math.Vector4.get_X_AXIS = function() {
	return new lime.math.Vector4(1,0,0);
};
lime.math.Vector4.get_Y_AXIS = function() {
	return new lime.math.Vector4(0,1,0);
};
lime.math.Vector4.get_Z_AXIS = function() {
	return new lime.math.Vector4(0,0,1);
};
lime.math.Vector4.prototype = {
	add: function(a) {
		return new lime.math.Vector4(this.x + a.x,this.y + a.y,this.z + a.z);
	}
	,clone: function() {
		return new lime.math.Vector4(this.x,this.y,this.z,this.w);
	}
	,copyFrom: function(sourceVector4) {
		this.x = sourceVector4.x;
		this.y = sourceVector4.y;
		this.z = sourceVector4.z;
	}
	,crossProduct: function(a) {
		return new lime.math.Vector4(this.y * a.z - this.z * a.y,this.z * a.x - this.x * a.z,this.x * a.y - this.y * a.x,1);
	}
	,decrementBy: function(a) {
		this.x -= a.x;
		this.y -= a.y;
		this.z -= a.z;
	}
	,dotProduct: function(a) {
		return this.x * a.x + this.y * a.y + this.z * a.z;
	}
	,equals: function(toCompare,allFour) {
		if(allFour == null) allFour = false;
		return this.x == toCompare.x && this.y == toCompare.y && this.z == toCompare.z && (!allFour || this.w == toCompare.w);
	}
	,incrementBy: function(a) {
		this.x += a.x;
		this.y += a.y;
		this.z += a.z;
	}
	,nearEquals: function(toCompare,tolerance,allFour) {
		if(allFour == null) allFour = false;
		return Math.abs(this.x - toCompare.x) < tolerance && Math.abs(this.y - toCompare.y) < tolerance && Math.abs(this.z - toCompare.z) < tolerance && (!allFour || Math.abs(this.w - toCompare.w) < tolerance);
	}
	,negate: function() {
		this.x *= -1;
		this.y *= -1;
		this.z *= -1;
	}
	,normalize: function() {
		var l = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
		if(l != 0) {
			this.x /= l;
			this.y /= l;
			this.z /= l;
		}
		return l;
	}
	,project: function() {
		this.x /= this.w;
		this.y /= this.w;
		this.z /= this.w;
	}
	,scaleBy: function(s) {
		this.x *= s;
		this.y *= s;
		this.z *= s;
	}
	,setTo: function(xa,ya,za) {
		this.x = xa;
		this.y = ya;
		this.z = za;
	}
	,subtract: function(a) {
		return new lime.math.Vector4(this.x - a.x,this.y - a.y,this.z - a.z);
	}
	,toString: function() {
		return "Vector4(" + this.x + ", " + this.y + ", " + this.z + ")";
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
	}
	,get_lengthSquared: function() {
		return this.x * this.x + this.y * this.y + this.z * this.z;
	}
	,__class__: lime.math.Vector4
	,__properties__: {get_lengthSquared:"get_lengthSquared",get_length:"get_length"}
};
lime.net = {};
lime.net.URLLoader = function(request) {
	this.onSecurityError = new lime.app.Event();
	this.onProgress = new lime.app.Event();
	this.onOpen = new lime.app.Event();
	this.onIOError = new lime.app.Event();
	this.onHTTPStatus = new lime.app.Event();
	this.onComplete = new lime.app.Event();
	this.bytesLoaded = 0;
	this.bytesTotal = 0;
	this.set_dataFormat(lime.net.URLLoaderDataFormat.TEXT);
	if(request != null) this.load(request);
};
$hxClasses["lime.net.URLLoader"] = lime.net.URLLoader;
lime.net.URLLoader.__name__ = ["lime","net","URLLoader"];
lime.net.URLLoader.prototype = {
	close: function() {
	}
	,getData: function() {
		return null;
	}
	,load: function(request) {
		this.requestUrl(request.url,request.method,request.data,request.formatRequestHeaders());
	}
	,registerEvents: function(subject) {
		var _g = this;
		var self = this;
		if(typeof XMLHttpRequestProgressEvent != "undefined") subject.addEventListener("progress",$bind(this,this.__onProgress),false);
		subject.onreadystatechange = function() {
			if(subject.readyState != 4) return;
			var s;
			try {
				s = subject.status;
			} catch( e ) {
				s = null;
			}
			if(s == undefined) s = null;
			if(s != null) {
				var listeners = self.onHTTPStatus.listeners;
				var repeat = self.onHTTPStatus.repeat;
				var length = listeners.length;
				var i = 0;
				while(i < length) {
					listeners[i](_g,s);
					if(!repeat[i]) {
						self.onHTTPStatus.remove(listeners[i]);
						length--;
					} else i++;
				}
			}
			if(s != null && s >= 200 && s < 400) self.__onData(subject.response); else if(s == null) {
				var listeners1 = self.onIOError.listeners;
				var repeat1 = self.onIOError.repeat;
				var length1 = listeners1.length;
				var i1 = 0;
				while(i1 < length1) {
					listeners1[i1](_g,"Failed to connect or resolve host");
					if(!repeat1[i1]) {
						self.onIOError.remove(listeners1[i1]);
						length1--;
					} else i1++;
				}
			} else if(s == 12029) {
				var listeners2 = self.onIOError.listeners;
				var repeat2 = self.onIOError.repeat;
				var length2 = listeners2.length;
				var i2 = 0;
				while(i2 < length2) {
					listeners2[i2](_g,"Failed to connect to host");
					if(!repeat2[i2]) {
						self.onIOError.remove(listeners2[i2]);
						length2--;
					} else i2++;
				}
			} else if(s == 12007) {
				var listeners3 = self.onIOError.listeners;
				var repeat3 = self.onIOError.repeat;
				var length3 = listeners3.length;
				var i3 = 0;
				while(i3 < length3) {
					listeners3[i3](_g,"Unknown host");
					if(!repeat3[i3]) {
						self.onIOError.remove(listeners3[i3]);
						length3--;
					} else i3++;
				}
			} else if(s == 0) {
				var listeners4 = self.onIOError.listeners;
				var repeat4 = self.onIOError.repeat;
				var length4 = listeners4.length;
				var i4 = 0;
				while(i4 < length4) {
					listeners4[i4](_g,"Unable to make request (may be blocked due to cross-domain permissions)");
					if(!repeat4[i4]) {
						self.onIOError.remove(listeners4[i4]);
						length4--;
					} else i4++;
				}
				var listeners5 = self.onSecurityError.listeners;
				var repeat5 = self.onSecurityError.repeat;
				var length5 = listeners5.length;
				var i5 = 0;
				while(i5 < length5) {
					listeners5[i5](_g,"Unable to make request (may be blocked due to cross-domain permissions)");
					if(!repeat5[i5]) {
						self.onSecurityError.remove(listeners5[i5]);
						length5--;
					} else i5++;
				}
			} else {
				var listeners6 = self.onIOError.listeners;
				var repeat6 = self.onIOError.repeat;
				var length6 = listeners6.length;
				var i6 = 0;
				while(i6 < length6) {
					listeners6[i6](_g,"Http Error #" + subject.status);
					if(!repeat6[i6]) {
						self.onIOError.remove(listeners6[i6]);
						length6--;
					} else i6++;
				}
			}
		};
	}
	,requestUrl: function(url,method,data,requestHeaders) {
		var xmlHttpRequest = new XMLHttpRequest();
		this.registerEvents(xmlHttpRequest);
		var uri = "";
		if(js.Boot.__instanceof(data,lime.utils.ByteArray)) {
			var data1 = data;
			var _g = this.dataFormat;
			switch(_g[1]) {
			case 0:
				uri = data1.data.buffer;
				break;
			default:
				uri = data1.readUTFBytes(data1.length);
			}
		} else if(js.Boot.__instanceof(data,lime.net.URLVariables)) {
			var data2 = data;
			var _g1 = 0;
			var _g11 = Reflect.fields(data2);
			while(_g1 < _g11.length) {
				var p = _g11[_g1];
				++_g1;
				if(uri.length != 0) uri += "&";
				uri += encodeURIComponent(p) + "=" + StringTools.urlEncode(Reflect.field(data2,p));
			}
		} else if(data != null) uri = data.toString();
		try {
			if(method == "GET" && uri != null && uri != "") {
				var question = url.split("?").length <= 1;
				xmlHttpRequest.open("GET",url + (question?"?":"&") + Std.string(uri),true);
				uri = "";
			} else xmlHttpRequest.open(js.Boot.__cast(method , String),url,true);
		} catch( e ) {
			var listeners = this.onIOError.listeners;
			var repeat = this.onIOError.repeat;
			var length = listeners.length;
			var i = 0;
			while(i < length) {
				listeners[i](this,e.toString());
				if(!repeat[i]) {
					this.onIOError.remove(listeners[i]);
					length--;
				} else i++;
			}
			return;
		}
		var _g2 = this.dataFormat;
		switch(_g2[1]) {
		case 0:
			xmlHttpRequest.responseType = "arraybuffer";
			break;
		default:
		}
		var _g3 = 0;
		while(_g3 < requestHeaders.length) {
			var header = requestHeaders[_g3];
			++_g3;
			xmlHttpRequest.setRequestHeader(header.name,header.value);
		}
		xmlHttpRequest.send(uri);
		var listeners1 = this.onOpen.listeners;
		var repeat1 = this.onOpen.repeat;
		var length1 = listeners1.length;
		var i1 = 0;
		while(i1 < length1) {
			listeners1[i1](this);
			if(!repeat1[i1]) {
				this.onOpen.remove(listeners1[i1]);
				length1--;
			} else i1++;
		}
		this.getData = function() {
			if(xmlHttpRequest.response != null) return xmlHttpRequest.response; else return xmlHttpRequest.responseText;
		};
	}
	,__onData: function(_) {
		var content = this.getData();
		var _g = this.dataFormat;
		switch(_g[1]) {
		case 0:
			this.data = lime.utils.ByteArray.__ofBuffer(content);
			break;
		default:
			this.data = Std.string(content);
		}
		var listeners = this.onComplete.listeners;
		var repeat = this.onComplete.repeat;
		var length = listeners.length;
		var i = 0;
		while(i < length) {
			listeners[i](this);
			if(!repeat[i]) {
				this.onComplete.remove(listeners[i]);
				length--;
			} else i++;
		}
	}
	,__onProgress: function(event) {
		this.bytesLoaded = event.loaded;
		this.bytesTotal = event.total;
		var listeners = this.onProgress.listeners;
		var repeat = this.onProgress.repeat;
		var length = listeners.length;
		var i = 0;
		while(i < length) {
			listeners[i](this,this.bytesLoaded,this.bytesTotal);
			if(!repeat[i]) {
				this.onProgress.remove(listeners[i]);
				length--;
			} else i++;
		}
	}
	,set_dataFormat: function(inputVal) {
		if(inputVal == lime.net.URLLoaderDataFormat.BINARY && !Reflect.hasField(window,"ArrayBuffer")) this.dataFormat = lime.net.URLLoaderDataFormat.TEXT; else this.dataFormat = inputVal;
		return this.dataFormat;
	}
	,__class__: lime.net.URLLoader
	,__properties__: {set_dataFormat:"set_dataFormat"}
};
lime.net.URLLoaderDataFormat = $hxClasses["lime.net.URLLoaderDataFormat"] = { __ename__ : ["lime","net","URLLoaderDataFormat"], __constructs__ : ["BINARY","TEXT","VARIABLES"] };
lime.net.URLLoaderDataFormat.BINARY = ["BINARY",0];
lime.net.URLLoaderDataFormat.BINARY.toString = $estr;
lime.net.URLLoaderDataFormat.BINARY.__enum__ = lime.net.URLLoaderDataFormat;
lime.net.URLLoaderDataFormat.TEXT = ["TEXT",1];
lime.net.URLLoaderDataFormat.TEXT.toString = $estr;
lime.net.URLLoaderDataFormat.TEXT.__enum__ = lime.net.URLLoaderDataFormat;
lime.net.URLLoaderDataFormat.VARIABLES = ["VARIABLES",2];
lime.net.URLLoaderDataFormat.VARIABLES.toString = $estr;
lime.net.URLLoaderDataFormat.VARIABLES.__enum__ = lime.net.URLLoaderDataFormat;
lime.net.URLRequest = function(inURL) {
	if(inURL != null) this.url = inURL;
	this.requestHeaders = [];
	this.method = "GET";
	this.contentType = null;
};
$hxClasses["lime.net.URLRequest"] = lime.net.URLRequest;
lime.net.URLRequest.__name__ = ["lime","net","URLRequest"];
lime.net.URLRequest.prototype = {
	formatRequestHeaders: function() {
		var res = this.requestHeaders;
		if(res == null) res = [];
		if(this.method == "GET" || this.data == null) return res;
		if(typeof(this.data) == "string" || js.Boot.__instanceof(this.data,lime.utils.ByteArray)) {
			res = res.slice();
			res.push(new lime.net.URLRequestHeader("Content-Type",this.contentType != null?this.contentType:"application/x-www-form-urlencoded"));
		}
		return res;
	}
	,__class__: lime.net.URLRequest
};
lime.net.URLRequestHeader = function(name,value) {
	if(value == null) value = "";
	if(name == null) name = "";
	this.name = name;
	this.value = value;
};
$hxClasses["lime.net.URLRequestHeader"] = lime.net.URLRequestHeader;
lime.net.URLRequestHeader.__name__ = ["lime","net","URLRequestHeader"];
lime.net.URLRequestHeader.prototype = {
	__class__: lime.net.URLRequestHeader
};
lime.net._URLRequestMethod = {};
lime.net._URLRequestMethod.URLRequestMethod_Impl_ = function() { };
$hxClasses["lime.net._URLRequestMethod.URLRequestMethod_Impl_"] = lime.net._URLRequestMethod.URLRequestMethod_Impl_;
lime.net._URLRequestMethod.URLRequestMethod_Impl_.__name__ = ["lime","net","_URLRequestMethod","URLRequestMethod_Impl_"];
lime.net.URLVariables = function(inEncoded) {
	if(inEncoded != null) this.decode(inEncoded);
};
$hxClasses["lime.net.URLVariables"] = lime.net.URLVariables;
lime.net.URLVariables.__name__ = ["lime","net","URLVariables"];
lime.net.URLVariables.prototype = {
	decode: function(inVars) {
		var fields = Reflect.fields(this);
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			Reflect.deleteField(this,f);
		}
		var fields1 = inVars.split(";").join("&").split("&");
		var _g1 = 0;
		while(_g1 < fields1.length) {
			var f1 = fields1[_g1];
			++_g1;
			var eq = f1.indexOf("=");
			if(eq > 0) Reflect.setField(this,StringTools.urlDecode(HxOverrides.substr(f1,0,eq)),StringTools.urlDecode(HxOverrides.substr(f1,eq + 1,null))); else if(eq != 0) Reflect.setField(this,decodeURIComponent(f1.split("+").join(" ")),"");
		}
	}
	,toString: function() {
		var result = new Array();
		var fields = Reflect.fields(this);
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			result.push(encodeURIComponent(f) + "=" + StringTools.urlEncode(Reflect.field(this,f)));
		}
		return result.join("&");
	}
	,__class__: lime.net.URLVariables
};
lime.ui = {};
lime.ui._KeyCode = {};
lime.ui._KeyCode.KeyCode_Impl_ = function() { };
$hxClasses["lime.ui._KeyCode.KeyCode_Impl_"] = lime.ui._KeyCode.KeyCode_Impl_;
lime.ui._KeyCode.KeyCode_Impl_.__name__ = ["lime","ui","_KeyCode","KeyCode_Impl_"];
lime.ui._KeyModifier = {};
lime.ui._KeyModifier.KeyModifier_Impl_ = function() { };
$hxClasses["lime.ui._KeyModifier.KeyModifier_Impl_"] = lime.ui._KeyModifier.KeyModifier_Impl_;
lime.ui._KeyModifier.KeyModifier_Impl_.__name__ = ["lime","ui","_KeyModifier","KeyModifier_Impl_"];
lime.ui._KeyModifier.KeyModifier_Impl_.__properties__ = {set_shiftKey:"set_shiftKey",get_shiftKey:"get_shiftKey",set_numLock:"set_numLock",get_numLock:"get_numLock",set_metaKey:"set_metaKey",get_metaKey:"get_metaKey",set_ctrlKey:"set_ctrlKey",get_ctrlKey:"get_ctrlKey",set_capsLock:"set_capsLock",get_capsLock:"get_capsLock",set_altKey:"set_altKey",get_altKey:"get_altKey"}
lime.ui._KeyModifier.KeyModifier_Impl_.get_altKey = function(this1) {
	return (this1 & 256) > 0 || (this1 & 512) > 0;
};
lime.ui._KeyModifier.KeyModifier_Impl_.set_altKey = function(this1,value) {
	if(value) this1 |= 768; else this1 &= 268435455 - 768;
	return value;
};
lime.ui._KeyModifier.KeyModifier_Impl_.get_capsLock = function(this1) {
	return (this1 & 8192) > 0 || (this1 & 8192) > 0;
};
lime.ui._KeyModifier.KeyModifier_Impl_.set_capsLock = function(this1,value) {
	if(value) this1 |= 8192; else this1 &= 268435455 - 8192;
	return value;
};
lime.ui._KeyModifier.KeyModifier_Impl_.get_ctrlKey = function(this1) {
	return (this1 & 64) > 0 || (this1 & 128) > 0;
};
lime.ui._KeyModifier.KeyModifier_Impl_.set_ctrlKey = function(this1,value) {
	if(value) this1 |= 192; else this1 &= 268435455 - 192;
	return value;
};
lime.ui._KeyModifier.KeyModifier_Impl_.get_metaKey = function(this1) {
	return (this1 & 1024) > 0 || (this1 & 2048) > 0;
};
lime.ui._KeyModifier.KeyModifier_Impl_.set_metaKey = function(this1,value) {
	if(value) this1 |= 3072; else this1 &= 268435455 - 3072;
	return value;
};
lime.ui._KeyModifier.KeyModifier_Impl_.get_numLock = function(this1) {
	return (this1 & 4096) > 0 || (this1 & 4096) > 0;
};
lime.ui._KeyModifier.KeyModifier_Impl_.set_numLock = function(this1,value) {
	if(value) this1 |= 4096; else this1 &= 268435455 - 4096;
	return value;
};
lime.ui._KeyModifier.KeyModifier_Impl_.get_shiftKey = function(this1) {
	return (this1 & 1) > 0 || (this1 & 2) > 0;
};
lime.ui._KeyModifier.KeyModifier_Impl_.set_shiftKey = function(this1,value) {
	if(value) this1 |= 3; else this1 &= 268435455 - 3;
	return value;
};
lime.ui.Mouse = function() { };
$hxClasses["lime.ui.Mouse"] = lime.ui.Mouse;
lime.ui.Mouse.__name__ = ["lime","ui","Mouse"];
lime.ui.Mouse.__properties__ = {set_cursor:"set_cursor",get_cursor:"get_cursor"}
lime.ui.Mouse.hide = function() {
	lime._backend.html5.HTML5Mouse.hide();
};
lime.ui.Mouse.show = function() {
	lime._backend.html5.HTML5Mouse.show();
};
lime.ui.Mouse.get_cursor = function() {
	return lime._backend.html5.HTML5Mouse.get_cursor();
};
lime.ui.Mouse.set_cursor = function(value) {
	return lime._backend.html5.HTML5Mouse.set_cursor(value);
};
lime.ui.MouseCursor = $hxClasses["lime.ui.MouseCursor"] = { __ename__ : ["lime","ui","MouseCursor"], __constructs__ : ["ARROW","CROSSHAIR","DEFAULT","MOVE","POINTER","RESIZE_NESW","RESIZE_NS","RESIZE_NWSE","RESIZE_WE","TEXT","WAIT","WAIT_ARROW","CUSTOM"] };
lime.ui.MouseCursor.ARROW = ["ARROW",0];
lime.ui.MouseCursor.ARROW.toString = $estr;
lime.ui.MouseCursor.ARROW.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.CROSSHAIR = ["CROSSHAIR",1];
lime.ui.MouseCursor.CROSSHAIR.toString = $estr;
lime.ui.MouseCursor.CROSSHAIR.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.DEFAULT = ["DEFAULT",2];
lime.ui.MouseCursor.DEFAULT.toString = $estr;
lime.ui.MouseCursor.DEFAULT.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.MOVE = ["MOVE",3];
lime.ui.MouseCursor.MOVE.toString = $estr;
lime.ui.MouseCursor.MOVE.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.POINTER = ["POINTER",4];
lime.ui.MouseCursor.POINTER.toString = $estr;
lime.ui.MouseCursor.POINTER.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.RESIZE_NESW = ["RESIZE_NESW",5];
lime.ui.MouseCursor.RESIZE_NESW.toString = $estr;
lime.ui.MouseCursor.RESIZE_NESW.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.RESIZE_NS = ["RESIZE_NS",6];
lime.ui.MouseCursor.RESIZE_NS.toString = $estr;
lime.ui.MouseCursor.RESIZE_NS.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.RESIZE_NWSE = ["RESIZE_NWSE",7];
lime.ui.MouseCursor.RESIZE_NWSE.toString = $estr;
lime.ui.MouseCursor.RESIZE_NWSE.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.RESIZE_WE = ["RESIZE_WE",8];
lime.ui.MouseCursor.RESIZE_WE.toString = $estr;
lime.ui.MouseCursor.RESIZE_WE.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.TEXT = ["TEXT",9];
lime.ui.MouseCursor.TEXT.toString = $estr;
lime.ui.MouseCursor.TEXT.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.WAIT = ["WAIT",10];
lime.ui.MouseCursor.WAIT.toString = $estr;
lime.ui.MouseCursor.WAIT.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.WAIT_ARROW = ["WAIT_ARROW",11];
lime.ui.MouseCursor.WAIT_ARROW.toString = $estr;
lime.ui.MouseCursor.WAIT_ARROW.__enum__ = lime.ui.MouseCursor;
lime.ui.MouseCursor.CUSTOM = ["CUSTOM",12];
lime.ui.MouseCursor.CUSTOM.toString = $estr;
lime.ui.MouseCursor.CUSTOM.__enum__ = lime.ui.MouseCursor;
lime.ui.Window = function(config) {
	this.onWindowResize = new lime.app.Event();
	this.onWindowMove = new lime.app.Event();
	this.onWindowFocusOut = new lime.app.Event();
	this.onWindowFocusIn = new lime.app.Event();
	this.onWindowDeactivate = new lime.app.Event();
	this.onWindowClose = new lime.app.Event();
	this.onWindowActivate = new lime.app.Event();
	this.onTouchStart = new lime.app.Event();
	this.onTouchMove = new lime.app.Event();
	this.onTouchEnd = new lime.app.Event();
	this.onMouseWheel = new lime.app.Event();
	this.onMouseUp = new lime.app.Event();
	this.onMouseMove = new lime.app.Event();
	this.onMouseDown = new lime.app.Event();
	this.onKeyUp = new lime.app.Event();
	this.onKeyDown = new lime.app.Event();
	this.config = config;
	this.width = 0;
	this.height = 0;
	this.fullscreen = false;
	this.x = 0;
	this.y = 0;
	if(config != null) {
		if(Object.prototype.hasOwnProperty.call(config,"width")) this.width = config.width;
		if(Object.prototype.hasOwnProperty.call(config,"height")) this.height = config.height;
		if(Object.prototype.hasOwnProperty.call(config,"fullscreen")) this.fullscreen = config.fullscreen;
	}
	this.backend = new lime._backend.html5.HTML5Window(this);
};
$hxClasses["lime.ui.Window"] = lime.ui.Window;
lime.ui.Window.__name__ = ["lime","ui","Window"];
lime.ui.Window.prototype = {
	close: function() {
		this.backend.close();
	}
	,create: function(application) {
		this.backend.create(application);
		if(this.currentRenderer != null) this.currentRenderer.create();
	}
	,move: function(x,y) {
		this.backend.move(x,y);
		this.x = x;
		this.y = y;
	}
	,resize: function(width,height) {
		this.backend.resize(width,height);
		this.width = width;
		this.height = height;
	}
	,setIcon: function(image) {
		if(image == null) return;
		this.backend.setIcon(image);
	}
	,__class__: lime.ui.Window
};
lime.utils.CompressionAlgorithm = $hxClasses["lime.utils.CompressionAlgorithm"] = { __ename__ : ["lime","utils","CompressionAlgorithm"], __constructs__ : ["DEFLATE","ZLIB","LZMA","GZIP"] };
lime.utils.CompressionAlgorithm.DEFLATE = ["DEFLATE",0];
lime.utils.CompressionAlgorithm.DEFLATE.toString = $estr;
lime.utils.CompressionAlgorithm.DEFLATE.__enum__ = lime.utils.CompressionAlgorithm;
lime.utils.CompressionAlgorithm.ZLIB = ["ZLIB",1];
lime.utils.CompressionAlgorithm.ZLIB.toString = $estr;
lime.utils.CompressionAlgorithm.ZLIB.__enum__ = lime.utils.CompressionAlgorithm;
lime.utils.CompressionAlgorithm.LZMA = ["LZMA",2];
lime.utils.CompressionAlgorithm.LZMA.toString = $estr;
lime.utils.CompressionAlgorithm.LZMA.__enum__ = lime.utils.CompressionAlgorithm;
lime.utils.CompressionAlgorithm.GZIP = ["GZIP",3];
lime.utils.CompressionAlgorithm.GZIP.toString = $estr;
lime.utils.CompressionAlgorithm.GZIP.__enum__ = lime.utils.CompressionAlgorithm;
lime.utils.GLUtils = function() { };
$hxClasses["lime.utils.GLUtils"] = lime.utils.GLUtils;
lime.utils.GLUtils.__name__ = ["lime","utils","GLUtils"];
lime.utils.GLUtils.compileShader = function(source,type) {
	var shader = lime.graphics.opengl.GL.context.createShader(type);
	lime.graphics.opengl.GL.context.shaderSource(shader,source);
	lime.graphics.opengl.GL.context.compileShader(shader);
	if(lime.graphics.opengl.GL.context.getShaderParameter(shader,35713) == 0) switch(type) {
	case 35633:
		throw "Error compiling vertex shader";
		break;
	case 35632:
		throw "Error compiling fragment shader";
		break;
	default:
		throw "Error compiling unknown shader type";
	}
	return shader;
};
lime.utils.GLUtils.createProgram = function(vertexSource,fragmentSource) {
	var vertexShader = lime.utils.GLUtils.compileShader(vertexSource,35633);
	var fragmentShader = lime.utils.GLUtils.compileShader(fragmentSource,35632);
	var program = lime.graphics.opengl.GL.context.createProgram();
	lime.graphics.opengl.GL.context.attachShader(program,vertexShader);
	lime.graphics.opengl.GL.context.attachShader(program,fragmentShader);
	lime.graphics.opengl.GL.context.linkProgram(program);
	if(lime.graphics.opengl.GL.context.getProgramParameter(program,35714) == 0) throw "Unable to initialize the shader program.";
	return program;
};
lime.utils.IDataInput = function() { };
$hxClasses["lime.utils.IDataInput"] = lime.utils.IDataInput;
lime.utils.IDataInput.__name__ = ["lime","utils","IDataInput"];
lime.utils.IDataInput.prototype = {
	__class__: lime.utils.IDataInput
	,__properties__: {set_endian:"set_endian",get_endian:"get_endian",get_bytesAvailable:"get_bytesAvailable"}
};
lime.utils.IMemoryRange = function() { };
$hxClasses["lime.utils.IMemoryRange"] = lime.utils.IMemoryRange;
lime.utils.IMemoryRange.__name__ = ["lime","utils","IMemoryRange"];
lime.utils.IMemoryRange.prototype = {
	__class__: lime.utils.IMemoryRange
};
var motion = {};
motion.actuators = {};
motion.actuators.IGenericActuator = function() { };
$hxClasses["motion.actuators.IGenericActuator"] = motion.actuators.IGenericActuator;
motion.actuators.IGenericActuator.__name__ = ["motion","actuators","IGenericActuator"];
motion.actuators.IGenericActuator.prototype = {
	__class__: motion.actuators.IGenericActuator
};
motion.actuators.GenericActuator = function(target,duration,properties) {
	this._autoVisible = true;
	this._delay = 0;
	this._reflect = false;
	this._repeat = 0;
	this._reverse = false;
	this._smartRotation = false;
	this._snapping = false;
	this.special = false;
	this.target = target;
	this.properties = properties;
	this.duration = duration;
	this._ease = motion.Actuate.defaultEase;
};
$hxClasses["motion.actuators.GenericActuator"] = motion.actuators.GenericActuator;
motion.actuators.GenericActuator.__name__ = ["motion","actuators","GenericActuator"];
motion.actuators.GenericActuator.__interfaces__ = [motion.actuators.IGenericActuator];
motion.actuators.GenericActuator.prototype = {
	apply: function() {
		var _g = 0;
		var _g1 = Reflect.fields(this.properties);
		while(_g < _g1.length) {
			var i = _g1[_g];
			++_g;
			if(Object.prototype.hasOwnProperty.call(this.target,i)) Reflect.setField(this.target,i,Reflect.field(this.properties,i)); else Reflect.setProperty(this.target,i,Reflect.field(this.properties,i));
		}
	}
	,autoVisible: function(value) {
		if(value == null) value = true;
		this._autoVisible = value;
		return this;
	}
	,callMethod: function(method,params) {
		if(params == null) params = [];
		return method.apply(method,params);
	}
	,change: function() {
		if(this._onUpdate != null) this.callMethod(this._onUpdate,this._onUpdateParams);
	}
	,complete: function(sendEvent) {
		if(sendEvent == null) sendEvent = true;
		if(sendEvent) {
			this.change();
			if(this._onComplete != null) this.callMethod(this._onComplete,this._onCompleteParams);
		}
		motion.Actuate.unload(this);
	}
	,delay: function(duration) {
		this._delay = duration;
		return this;
	}
	,ease: function(easing) {
		this._ease = easing;
		return this;
	}
	,move: function() {
	}
	,onComplete: function(handler,parameters) {
		this._onComplete = handler;
		if(parameters == null) this._onCompleteParams = []; else this._onCompleteParams = parameters;
		if(this.duration == 0) this.complete();
		return this;
	}
	,onRepeat: function(handler,parameters) {
		this._onRepeat = handler;
		if(parameters == null) this._onRepeatParams = []; else this._onRepeatParams = parameters;
		return this;
	}
	,onUpdate: function(handler,parameters) {
		this._onUpdate = handler;
		if(parameters == null) this._onUpdateParams = []; else this._onUpdateParams = parameters;
		return this;
	}
	,onPause: function(handler,parameters) {
		this._onPause = handler;
		if(parameters == null) this._onPauseParams = []; else this._onPauseParams = parameters;
		return this;
	}
	,onResume: function(handler,parameters) {
		this._onResume = handler;
		if(parameters == null) this._onResumeParams = []; else this._onResumeParams = parameters;
		return this;
	}
	,pause: function() {
		if(this._onPause != null) this.callMethod(this._onPause,this._onPauseParams);
	}
	,reflect: function(value) {
		if(value == null) value = true;
		this._reflect = value;
		this.special = true;
		return this;
	}
	,repeat: function(times) {
		if(times == null) times = -1;
		this._repeat = times;
		return this;
	}
	,resume: function() {
		if(this._onResume != null) this.callMethod(this._onResume,this._onResumeParams);
	}
	,reverse: function(value) {
		if(value == null) value = true;
		this._reverse = value;
		this.special = true;
		return this;
	}
	,smartRotation: function(value) {
		if(value == null) value = true;
		this._smartRotation = value;
		this.special = true;
		return this;
	}
	,snapping: function(value) {
		if(value == null) value = true;
		this._snapping = value;
		this.special = true;
		return this;
	}
	,stop: function(properties,complete,sendEvent) {
	}
	,__class__: motion.actuators.GenericActuator
};
motion.actuators.SimpleActuator = function(target,duration,properties) {
	this.active = true;
	this.propertyDetails = new Array();
	this.sendChange = false;
	this.paused = false;
	this.cacheVisible = false;
	this.initialized = false;
	this.setVisible = false;
	this.toggleVisible = false;
	this.startTime = openfl.Lib.getTimer() / 1000;
	motion.actuators.GenericActuator.call(this,target,duration,properties);
	if(!motion.actuators.SimpleActuator.addedEvent) {
		motion.actuators.SimpleActuator.addedEvent = true;
		openfl.Lib.current.stage.addEventListener(openfl.events.Event.ENTER_FRAME,motion.actuators.SimpleActuator.stage_onEnterFrame);
	}
};
$hxClasses["motion.actuators.SimpleActuator"] = motion.actuators.SimpleActuator;
motion.actuators.SimpleActuator.__name__ = ["motion","actuators","SimpleActuator"];
motion.actuators.SimpleActuator.stage_onEnterFrame = function(event) {
	var currentTime = openfl.Lib.getTimer() / 1000;
	var actuator;
	var j = 0;
	var cleanup = false;
	var _g1 = 0;
	var _g = motion.actuators.SimpleActuator.actuatorsLength;
	while(_g1 < _g) {
		var i = _g1++;
		actuator = motion.actuators.SimpleActuator.actuators[j];
		if(actuator != null && actuator.active) {
			if(currentTime >= actuator.timeOffset) actuator.update(currentTime);
			j++;
		} else {
			motion.actuators.SimpleActuator.actuators.splice(j,1);
			--motion.actuators.SimpleActuator.actuatorsLength;
		}
	}
};
motion.actuators.SimpleActuator.__super__ = motion.actuators.GenericActuator;
motion.actuators.SimpleActuator.prototype = $extend(motion.actuators.GenericActuator.prototype,{
	setField_motion_actuators_SimpleActuator_T: function(target,propertyName,value) {
		if(Object.prototype.hasOwnProperty.call(target,propertyName)) target[propertyName] = value; else Reflect.setProperty(target,propertyName,value);
	}
	,autoVisible: function(value) {
		if(value == null) value = true;
		this._autoVisible = value;
		if(!value) {
			this.toggleVisible = false;
			if(this.setVisible) this.setField_motion_actuators_SimpleActuator_T(this.target,"visible",this.cacheVisible);
		}
		return this;
	}
	,delay: function(duration) {
		this._delay = duration;
		this.timeOffset = this.startTime + duration;
		return this;
	}
	,getField: function(target,propertyName) {
		var value = null;
		if(Object.prototype.hasOwnProperty.call(target,propertyName)) value = Reflect.field(target,propertyName); else value = Reflect.getProperty(target,propertyName);
		return value;
	}
	,initialize: function() {
		var details;
		var start;
		var _g = 0;
		var _g1 = Reflect.fields(this.properties);
		while(_g < _g1.length) {
			var i = _g1[_g];
			++_g;
			var isField = true;
			if(Object.prototype.hasOwnProperty.call(this.target,i) && !(this.target.__properties__ && this.target.__properties__["set_" + i])) start = Reflect.field(this.target,i); else {
				isField = false;
				start = Reflect.getProperty(this.target,i);
			}
			if(typeof(start) == "number") {
				details = new motion.actuators.PropertyDetails(this.target,i,start,this.getField(this.properties,i) - start,isField);
				this.propertyDetails.push(details);
			}
		}
		this.detailsLength = this.propertyDetails.length;
		this.initialized = true;
	}
	,move: function() {
		this.toggleVisible = Object.prototype.hasOwnProperty.call(this.properties,"alpha") && js.Boot.__instanceof(this.target,openfl.display.DisplayObject);
		if(this.toggleVisible && this.properties.alpha != 0 && !this.getField(this.target,"visible")) {
			this.setVisible = true;
			this.cacheVisible = this.getField(this.target,"visible");
			this.setField_motion_actuators_SimpleActuator_T(this.target,"visible",true);
		}
		this.timeOffset = this.startTime;
		motion.actuators.SimpleActuator.actuators.push(this);
		++motion.actuators.SimpleActuator.actuatorsLength;
	}
	,onUpdate: function(handler,parameters) {
		this._onUpdate = handler;
		if(parameters == null) this._onUpdateParams = []; else this._onUpdateParams = parameters;
		this.sendChange = true;
		return this;
	}
	,pause: function() {
		if(!this.paused) {
			this.paused = true;
			motion.actuators.GenericActuator.prototype.pause.call(this);
			this.pauseTime = openfl.Lib.getTimer();
		}
	}
	,resume: function() {
		if(this.paused) {
			this.paused = false;
			this.timeOffset += (openfl.Lib.getTimer() - this.pauseTime) / 1000;
			motion.actuators.GenericActuator.prototype.resume.call(this);
		}
	}
	,setProperty: function(details,value) {
		if(details.isField) details.target[details.propertyName] = value; else Reflect.setProperty(details.target,details.propertyName,value);
	}
	,stop: function(properties,complete,sendEvent) {
		if(this.active) {
			if(properties == null) {
				this.active = false;
				if(complete) this.apply();
				this.complete(sendEvent);
				return;
			}
			var _g = 0;
			var _g1 = Reflect.fields(properties);
			while(_g < _g1.length) {
				var i = _g1[_g];
				++_g;
				if(Object.prototype.hasOwnProperty.call(this.properties,i)) {
					this.active = false;
					if(complete) this.apply();
					this.complete(sendEvent);
					return;
				}
			}
		}
	}
	,update: function(currentTime) {
		if(!this.paused) {
			var details;
			var easing;
			var i;
			var tweenPosition = (currentTime - this.timeOffset) / this.duration;
			if(tweenPosition > 1) tweenPosition = 1;
			if(!this.initialized) this.initialize();
			if(!this.special) {
				easing = this._ease.calculate(tweenPosition);
				var _g1 = 0;
				var _g = this.detailsLength;
				while(_g1 < _g) {
					var i1 = _g1++;
					details = this.propertyDetails[i1];
					this.setProperty(details,details.start + details.change * easing);
				}
			} else {
				if(!this._reverse) easing = this._ease.calculate(tweenPosition); else easing = this._ease.calculate(1 - tweenPosition);
				var endValue;
				var _g11 = 0;
				var _g2 = this.detailsLength;
				while(_g11 < _g2) {
					var i2 = _g11++;
					details = this.propertyDetails[i2];
					if(this._smartRotation && (details.propertyName == "rotation" || details.propertyName == "rotationX" || details.propertyName == "rotationY" || details.propertyName == "rotationZ")) {
						var rotation = details.change % 360;
						if(rotation > 180) rotation -= 360; else if(rotation < -180) rotation += 360;
						endValue = details.start + rotation * easing;
					} else endValue = details.start + details.change * easing;
					if(!this._snapping) {
						if(details.isField) details.target[details.propertyName] = endValue; else Reflect.setProperty(details.target,details.propertyName,endValue);
					} else this.setProperty(details,Math.round(endValue));
				}
			}
			if(tweenPosition == 1) {
				if(this._repeat == 0) {
					this.active = false;
					if(this.toggleVisible && this.getField(this.target,"alpha") == 0) this.setField_motion_actuators_SimpleActuator_T(this.target,"visible",false);
					this.complete(true);
					return;
				} else {
					if(this._onRepeat != null) this.callMethod(this._onRepeat,this._onRepeatParams);
					if(this._reflect) this._reverse = !this._reverse;
					this.startTime = currentTime;
					this.timeOffset = this.startTime + this._delay;
					if(this._repeat > 0) this._repeat--;
				}
			}
			if(this.sendChange) this.change();
		}
	}
	,__class__: motion.actuators.SimpleActuator
});
motion.easing = {};
motion.easing.Expo = function() { };
$hxClasses["motion.easing.Expo"] = motion.easing.Expo;
motion.easing.Expo.__name__ = ["motion","easing","Expo"];
motion.easing.Expo.__properties__ = {get_easeOut:"get_easeOut",get_easeInOut:"get_easeInOut",get_easeIn:"get_easeIn"}
motion.easing.Expo.get_easeIn = function() {
	return new motion.easing.ExpoEaseIn();
};
motion.easing.Expo.get_easeInOut = function() {
	return new motion.easing.ExpoEaseInOut();
};
motion.easing.Expo.get_easeOut = function() {
	return new motion.easing.ExpoEaseOut();
};
motion.easing.IEasing = function() { };
$hxClasses["motion.easing.IEasing"] = motion.easing.IEasing;
motion.easing.IEasing.__name__ = ["motion","easing","IEasing"];
motion.easing.IEasing.prototype = {
	__class__: motion.easing.IEasing
};
motion.easing.ExpoEaseOut = function() {
};
$hxClasses["motion.easing.ExpoEaseOut"] = motion.easing.ExpoEaseOut;
motion.easing.ExpoEaseOut.__name__ = ["motion","easing","ExpoEaseOut"];
motion.easing.ExpoEaseOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.ExpoEaseOut.prototype = {
	calculate: function(k) {
		if(k == 1) return 1; else return 1 - Math.pow(2,-10 * k);
	}
	,ease: function(t,b,c,d) {
		if(t == d) return b + c; else return c * (1 - Math.pow(2,-10 * t / d)) + b;
	}
	,__class__: motion.easing.ExpoEaseOut
};
motion.Actuate = function() { };
$hxClasses["motion.Actuate"] = motion.Actuate;
motion.Actuate.__name__ = ["motion","Actuate"];
motion.Actuate.apply = function(target,properties,customActuator) {
	motion.Actuate.stop(target,properties);
	if(customActuator == null) customActuator = motion.Actuate.defaultActuator;
	var actuator = Type.createInstance(customActuator,[target,0,properties]);
	actuator.apply();
	return actuator;
};
motion.Actuate.effects = function(target,duration,overwrite) {
	if(overwrite == null) overwrite = true;
	return new motion._Actuate.EffectsOptions(target,duration,overwrite);
};
motion.Actuate.getLibrary = function(target,allowCreation) {
	if(allowCreation == null) allowCreation = true;
	if(!(motion.Actuate.targetLibraries.h.__keys__[target.__id__] != null) && allowCreation) motion.Actuate.targetLibraries.set(target,new Array());
	return motion.Actuate.targetLibraries.h[target.__id__];
};
motion.Actuate.isActive = function() {
	var result = false;
	var $it0 = motion.Actuate.targetLibraries.iterator();
	while( $it0.hasNext() ) {
		var library = $it0.next();
		result = true;
		break;
	}
	return result;
};
motion.Actuate.motionPath = function(target,duration,properties,overwrite) {
	if(overwrite == null) overwrite = true;
	return motion.Actuate.tween(target,duration,properties,overwrite,motion.actuators.MotionPathActuator);
};
motion.Actuate.pause = function(target) {
	if(js.Boot.__instanceof(target,motion.actuators.IGenericActuator)) {
		var actuator = target;
		actuator.pause();
	} else {
		var library = motion.Actuate.getLibrary(target,false);
		if(library != null) {
			var _g = 0;
			while(_g < library.length) {
				var actuator1 = library[_g];
				++_g;
				actuator1.pause();
			}
		}
	}
};
motion.Actuate.pauseAll = function() {
	var $it0 = motion.Actuate.targetLibraries.iterator();
	while( $it0.hasNext() ) {
		var library = $it0.next();
		var _g = 0;
		while(_g < library.length) {
			var actuator = library[_g];
			++_g;
			actuator.pause();
		}
	}
};
motion.Actuate.reset = function() {
	var $it0 = motion.Actuate.targetLibraries.iterator();
	while( $it0.hasNext() ) {
		var library = $it0.next();
		var i = library.length - 1;
		while(i >= 0) {
			library[i].stop(null,false,false);
			i--;
		}
	}
	motion.Actuate.targetLibraries = new haxe.ds.ObjectMap();
};
motion.Actuate.resume = function(target) {
	if(js.Boot.__instanceof(target,motion.actuators.IGenericActuator)) {
		var actuator = target;
		actuator.resume();
	} else {
		var library = motion.Actuate.getLibrary(target,false);
		if(library != null) {
			var _g = 0;
			while(_g < library.length) {
				var actuator1 = library[_g];
				++_g;
				actuator1.resume();
			}
		}
	}
};
motion.Actuate.resumeAll = function() {
	var $it0 = motion.Actuate.targetLibraries.iterator();
	while( $it0.hasNext() ) {
		var library = $it0.next();
		var _g = 0;
		while(_g < library.length) {
			var actuator = library[_g];
			++_g;
			actuator.resume();
		}
	}
};
motion.Actuate.stop = function(target,properties,complete,sendEvent) {
	if(sendEvent == null) sendEvent = true;
	if(complete == null) complete = false;
	if(target != null) {
		if(js.Boot.__instanceof(target,motion.actuators.IGenericActuator)) {
			var actuator = target;
			actuator.stop(null,complete,sendEvent);
		} else {
			var library = motion.Actuate.getLibrary(target,false);
			if(library != null) {
				if(typeof(properties) == "string") {
					var temp = { };
					Reflect.setField(temp,properties,null);
					properties = temp;
				} else if((properties instanceof Array) && properties.__enum__ == null) {
					var temp1 = { };
					var _g = 0;
					var _g1;
					_g1 = js.Boot.__cast(properties , Array);
					while(_g < _g1.length) {
						var property = _g1[_g];
						++_g;
						Reflect.setField(temp1,property,null);
					}
					properties = temp1;
				}
				var i = library.length - 1;
				while(i >= 0) {
					library[i].stop(properties,complete,sendEvent);
					i--;
				}
			}
		}
	}
};
motion.Actuate.timer = function(duration,customActuator) {
	return motion.Actuate.tween(new motion._Actuate.TweenTimer(0),duration,new motion._Actuate.TweenTimer(1),false,customActuator);
};
motion.Actuate.transform = function(target,duration,overwrite) {
	if(overwrite == null) overwrite = true;
	if(duration == null) duration = 0;
	return new motion._Actuate.TransformOptions(target,duration,overwrite);
};
motion.Actuate.tween = function(target,duration,properties,overwrite,customActuator) {
	if(overwrite == null) overwrite = true;
	if(target != null) {
		if(duration > 0) {
			if(customActuator == null) customActuator = motion.Actuate.defaultActuator;
			var actuator = Type.createInstance(customActuator,[target,duration,properties]);
			var library = motion.Actuate.getLibrary(actuator.target);
			if(overwrite) {
				var i = library.length - 1;
				while(i >= 0) {
					library[i].stop(actuator.properties,false,false);
					i--;
				}
				library = motion.Actuate.getLibrary(actuator.target);
			}
			library.push(actuator);
			actuator.move();
			return actuator;
		} else return motion.Actuate.apply(target,properties,customActuator);
	}
	return null;
};
motion.Actuate.unload = function(actuator) {
	var target = actuator.target;
	if(motion.Actuate.targetLibraries.h.__keys__[target.__id__] != null) {
		HxOverrides.remove(motion.Actuate.targetLibraries.h[target.__id__],actuator);
		if(motion.Actuate.targetLibraries.h[target.__id__].length == 0) motion.Actuate.targetLibraries.remove(target);
	}
};
motion.Actuate.update = function(target,duration,start,end,overwrite) {
	if(overwrite == null) overwrite = true;
	var properties = { start : start, end : end};
	return motion.Actuate.tween(target,duration,properties,overwrite,motion.actuators.MethodActuator);
};
motion._Actuate = {};
motion._Actuate.EffectsOptions = function(target,duration,overwrite) {
	this.target = target;
	this.duration = duration;
	this.overwrite = overwrite;
};
$hxClasses["motion._Actuate.EffectsOptions"] = motion._Actuate.EffectsOptions;
motion._Actuate.EffectsOptions.__name__ = ["motion","_Actuate","EffectsOptions"];
motion._Actuate.EffectsOptions.prototype = {
	filter: function(reference,properties) {
		properties.filter = reference;
		return motion.Actuate.tween(this.target,this.duration,properties,this.overwrite,motion.actuators.FilterActuator);
	}
	,__class__: motion._Actuate.EffectsOptions
};
motion._Actuate.TransformOptions = function(target,duration,overwrite) {
	this.target = target;
	this.duration = duration;
	this.overwrite = overwrite;
};
$hxClasses["motion._Actuate.TransformOptions"] = motion._Actuate.TransformOptions;
motion._Actuate.TransformOptions.__name__ = ["motion","_Actuate","TransformOptions"];
motion._Actuate.TransformOptions.prototype = {
	color: function(value,strength,alpha) {
		if(strength == null) strength = 1;
		if(value == null) value = 0;
		var properties = { colorValue : value, colorStrength : strength};
		if(alpha != null) properties.colorAlpha = alpha;
		return motion.Actuate.tween(this.target,this.duration,properties,this.overwrite,motion.actuators.TransformActuator);
	}
	,sound: function(volume,pan) {
		var properties = { };
		if(volume != null) properties.soundVolume = volume;
		if(pan != null) properties.soundPan = pan;
		return motion.Actuate.tween(this.target,this.duration,properties,this.overwrite,motion.actuators.TransformActuator);
	}
	,__class__: motion._Actuate.TransformOptions
};
motion._Actuate.TweenTimer = function(progress) {
	this.progress = progress;
};
$hxClasses["motion._Actuate.TweenTimer"] = motion._Actuate.TweenTimer;
motion._Actuate.TweenTimer.__name__ = ["motion","_Actuate","TweenTimer"];
motion._Actuate.TweenTimer.prototype = {
	__class__: motion._Actuate.TweenTimer
};
motion.MotionPath = function() {
	this._x = new motion.ComponentPath();
	this._y = new motion.ComponentPath();
	this._rotation = null;
};
$hxClasses["motion.MotionPath"] = motion.MotionPath;
motion.MotionPath.__name__ = ["motion","MotionPath"];
motion.MotionPath.prototype = {
	bezier: function(x,y,controlX,controlY,strength) {
		if(strength == null) strength = 1;
		this._x.addPath(new motion.BezierPath(x,controlX,strength));
		this._y.addPath(new motion.BezierPath(y,controlY,strength));
		return this;
	}
	,line: function(x,y,strength) {
		if(strength == null) strength = 1;
		this._x.addPath(new motion.LinearPath(x,strength));
		this._y.addPath(new motion.LinearPath(y,strength));
		return this;
	}
	,get_rotation: function() {
		if(this._rotation == null) this._rotation = new motion.RotationPath(this._x,this._y);
		return this._rotation;
	}
	,get_x: function() {
		return this._x;
	}
	,get_y: function() {
		return this._y;
	}
	,__class__: motion.MotionPath
	,__properties__: {get_y:"get_y",get_x:"get_x",get_rotation:"get_rotation"}
};
motion.IComponentPath = function() { };
$hxClasses["motion.IComponentPath"] = motion.IComponentPath;
motion.IComponentPath.__name__ = ["motion","IComponentPath"];
motion.IComponentPath.prototype = {
	__class__: motion.IComponentPath
};
motion.ComponentPath = function() {
	this.paths = new Array();
	this.start = 0;
	this.totalStrength = 0;
};
$hxClasses["motion.ComponentPath"] = motion.ComponentPath;
motion.ComponentPath.__name__ = ["motion","ComponentPath"];
motion.ComponentPath.__interfaces__ = [motion.IComponentPath];
motion.ComponentPath.prototype = {
	addPath: function(path) {
		this.paths.push(path);
		this.totalStrength += path.strength;
	}
	,calculate: function(k) {
		if(this.paths.length == 1) return this.paths[0].calculate(this.start,k); else {
			var ratio = k * this.totalStrength;
			var lastEnd = this.start;
			var _g = 0;
			var _g1 = this.paths;
			while(_g < _g1.length) {
				var path = _g1[_g];
				++_g;
				if(ratio > path.strength) {
					ratio -= path.strength;
					lastEnd = path.end;
				} else return path.calculate(lastEnd,ratio / path.strength);
			}
		}
		return 0;
	}
	,get_end: function() {
		if(this.paths.length > 0) {
			var path = this.paths[this.paths.length - 1];
			return path.end;
		} else return this.start;
	}
	,__class__: motion.ComponentPath
	,__properties__: {get_end:"get_end"}
};
motion.BezierPath = function(end,control,strength) {
	this.end = end;
	this.control = control;
	this.strength = strength;
};
$hxClasses["motion.BezierPath"] = motion.BezierPath;
motion.BezierPath.__name__ = ["motion","BezierPath"];
motion.BezierPath.prototype = {
	calculate: function(start,k) {
		return (1 - k) * (1 - k) * start + 2 * (1 - k) * k * this.control + k * k * this.end;
	}
	,__class__: motion.BezierPath
};
motion.LinearPath = function(end,strength) {
	motion.BezierPath.call(this,end,0,strength);
};
$hxClasses["motion.LinearPath"] = motion.LinearPath;
motion.LinearPath.__name__ = ["motion","LinearPath"];
motion.LinearPath.__super__ = motion.BezierPath;
motion.LinearPath.prototype = $extend(motion.BezierPath.prototype,{
	calculate: function(start,k) {
		return start + k * (this.end - start);
	}
	,__class__: motion.LinearPath
});
motion.RotationPath = function(x,y) {
	this.step = 0.01;
	this._x = x;
	this._y = y;
	this.offset = 0;
	this.start = this.calculate(0.0);
};
$hxClasses["motion.RotationPath"] = motion.RotationPath;
motion.RotationPath.__name__ = ["motion","RotationPath"];
motion.RotationPath.__interfaces__ = [motion.IComponentPath];
motion.RotationPath.prototype = {
	calculate: function(k) {
		var dX = this._x.calculate(k) - this._x.calculate(k + this.step);
		var dY = this._y.calculate(k) - this._y.calculate(k + this.step);
		var angle = Math.atan2(dY,dX) * (180 / Math.PI);
		angle = (angle + this.offset) % 360;
		return angle;
	}
	,get_end: function() {
		return this.calculate(1.0);
	}
	,__class__: motion.RotationPath
	,__properties__: {get_end:"get_end"}
};
motion.actuators.FilterActuator = function(target,duration,properties) {
	this.filterIndex = -1;
	motion.actuators.SimpleActuator.call(this,target,duration,properties);
	if(js.Boot.__instanceof(properties.filter,Class)) {
		this.filterClass = properties.filter;
		if(target.get_filters().length == 0) target.set_filters([Type.createInstance(this.filterClass,[])]);
		var _g = 0;
		var _g1 = target.get_filters();
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			if(js.Boot.__instanceof(filter,this.filterClass)) this.filter = filter;
		}
	} else {
		this.filterIndex = properties.filter;
		this.filter = target.get_filters()[this.filterIndex];
	}
};
$hxClasses["motion.actuators.FilterActuator"] = motion.actuators.FilterActuator;
motion.actuators.FilterActuator.__name__ = ["motion","actuators","FilterActuator"];
motion.actuators.FilterActuator.__super__ = motion.actuators.SimpleActuator;
motion.actuators.FilterActuator.prototype = $extend(motion.actuators.SimpleActuator.prototype,{
	setField_openfl_display_DisplayObject: function(target,propertyName,value) {
		if(Object.prototype.hasOwnProperty.call(target,propertyName)) target[propertyName] = value; else Reflect.setProperty(target,propertyName,value);
	}
	,apply: function() {
		var _g = 0;
		var _g1 = Reflect.fields(this.properties);
		while(_g < _g1.length) {
			var propertyName = _g1[_g];
			++_g;
			if(propertyName != "filter") Reflect.setField(this.filter,propertyName,Reflect.field(this.properties,propertyName));
		}
		var filters = this.getField(this.target,"filters");
		Reflect.setField(filters,this.properties.filter,this.filter);
		this.setField_openfl_display_DisplayObject(this.target,"filters",filters);
	}
	,initialize: function() {
		var details;
		var start;
		var _g = 0;
		var _g1 = Reflect.fields(this.properties);
		while(_g < _g1.length) {
			var propertyName = _g1[_g];
			++_g;
			if(propertyName != "filter") {
				start = this.getField(this.filter,propertyName);
				details = new motion.actuators.PropertyDetails(this.filter,propertyName,start,Reflect.field(this.properties,propertyName) - start);
				this.propertyDetails.push(details);
			}
		}
		this.detailsLength = this.propertyDetails.length;
		this.initialized = true;
	}
	,update: function(currentTime) {
		motion.actuators.SimpleActuator.prototype.update.call(this,currentTime);
		var filters = this.target.get_filters();
		if(this.filterIndex > -1) Reflect.setField(filters,this.properties.filter,this.filter); else {
			var _g1 = 0;
			var _g = filters.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(js.Boot.__instanceof(filters[i],this.filterClass)) filters[i] = this.filter;
			}
		}
		this.setField_openfl_display_DisplayObject(this.target,"filters",filters);
	}
	,__class__: motion.actuators.FilterActuator
});
motion.actuators.MethodActuator = function(target,duration,properties) {
	this.currentParameters = new Array();
	this.tweenProperties = { };
	motion.actuators.SimpleActuator.call(this,target,duration,properties);
	if(!Object.prototype.hasOwnProperty.call(properties,"start")) this.properties.start = new Array();
	if(!Object.prototype.hasOwnProperty.call(properties,"end")) this.properties.end = this.properties.start;
	var _g1 = 0;
	var _g = this.properties.start.length;
	while(_g1 < _g) {
		var i = _g1++;
		this.currentParameters.push(this.properties.start[i]);
	}
};
$hxClasses["motion.actuators.MethodActuator"] = motion.actuators.MethodActuator;
motion.actuators.MethodActuator.__name__ = ["motion","actuators","MethodActuator"];
motion.actuators.MethodActuator.__super__ = motion.actuators.SimpleActuator;
motion.actuators.MethodActuator.prototype = $extend(motion.actuators.SimpleActuator.prototype,{
	apply: function() {
		this.callMethod(this.target,this.properties.end);
	}
	,initialize: function() {
		var details;
		var propertyName;
		var start;
		var _g1 = 0;
		var _g = this.properties.start.length;
		while(_g1 < _g) {
			var i = _g1++;
			propertyName = "param" + i;
			start = this.properties.start[i];
			this.tweenProperties[propertyName] = start;
			if(typeof(start) == "number" || ((start | 0) === start)) {
				details = new motion.actuators.PropertyDetails(this.tweenProperties,propertyName,start,this.properties.end[i] - start);
				this.propertyDetails.push(details);
			}
		}
		this.detailsLength = this.propertyDetails.length;
		this.initialized = true;
	}
	,update: function(currentTime) {
		motion.actuators.SimpleActuator.prototype.update.call(this,currentTime);
		if(this.active) {
			var _g1 = 0;
			var _g = this.properties.start.length;
			while(_g1 < _g) {
				var i = _g1++;
				this.currentParameters[i] = Reflect.field(this.tweenProperties,"param" + i);
			}
			this.callMethod(this.target,this.currentParameters);
		}
	}
	,__class__: motion.actuators.MethodActuator
});
motion.actuators.MotionPathActuator = function(target,duration,properties) {
	motion.actuators.SimpleActuator.call(this,target,duration,properties);
};
$hxClasses["motion.actuators.MotionPathActuator"] = motion.actuators.MotionPathActuator;
motion.actuators.MotionPathActuator.__name__ = ["motion","actuators","MotionPathActuator"];
motion.actuators.MotionPathActuator.__super__ = motion.actuators.SimpleActuator;
motion.actuators.MotionPathActuator.prototype = $extend(motion.actuators.SimpleActuator.prototype,{
	setField_motion_actuators_MotionPathActuator_T: function(target,propertyName,value) {
		if(Object.prototype.hasOwnProperty.call(target,propertyName)) target[propertyName] = value; else Reflect.setProperty(target,propertyName,value);
	}
	,apply: function() {
		var _g = 0;
		var _g1 = Reflect.fields(this.properties);
		while(_g < _g1.length) {
			var propertyName = _g1[_g];
			++_g;
			if(Object.prototype.hasOwnProperty.call(this.target,propertyName)) Reflect.setField(this.target,propertyName,(js.Boot.__cast(Reflect.field(this.properties,propertyName) , motion.IComponentPath)).get_end()); else Reflect.setProperty(this.target,propertyName,(js.Boot.__cast(Reflect.field(this.properties,propertyName) , motion.IComponentPath)).get_end());
		}
	}
	,initialize: function() {
		var details;
		var path;
		var _g = 0;
		var _g1 = Reflect.fields(this.properties);
		while(_g < _g1.length) {
			var propertyName = _g1[_g];
			++_g;
			path = js.Boot.__cast(Reflect.field(this.properties,propertyName) , motion.IComponentPath);
			if(path != null) {
				var isField = true;
				if(Object.prototype.hasOwnProperty.call(this.target,propertyName)) path.start = Reflect.field(this.target,propertyName); else {
					isField = false;
					path.start = Reflect.getProperty(this.target,propertyName);
				}
				details = new motion.actuators.PropertyPathDetails(this.target,propertyName,path,isField);
				this.propertyDetails.push(details);
			}
		}
		this.detailsLength = this.propertyDetails.length;
		this.initialized = true;
	}
	,update: function(currentTime) {
		if(!this.paused) {
			var details;
			var easing;
			var tweenPosition = (currentTime - this.timeOffset) / this.duration;
			if(tweenPosition > 1) tweenPosition = 1;
			if(!this.initialized) this.initialize();
			if(!this.special) {
				easing = this._ease.calculate(tweenPosition);
				var _g = 0;
				var _g1 = this.propertyDetails;
				while(_g < _g1.length) {
					var details1 = _g1[_g];
					++_g;
					if(details1.isField) Reflect.setField(details1.target,details1.propertyName,(js.Boot.__cast(details1 , motion.actuators.PropertyPathDetails)).path.calculate(easing)); else Reflect.setProperty(details1.target,details1.propertyName,(js.Boot.__cast(details1 , motion.actuators.PropertyPathDetails)).path.calculate(easing));
				}
			} else {
				if(!this._reverse) easing = this._ease.calculate(tweenPosition); else easing = this._ease.calculate(1 - tweenPosition);
				var endValue;
				var _g2 = 0;
				var _g11 = this.propertyDetails;
				while(_g2 < _g11.length) {
					var details2 = _g11[_g2];
					++_g2;
					if(!this._snapping) {
						if(details2.isField) Reflect.setField(details2.target,details2.propertyName,(js.Boot.__cast(details2 , motion.actuators.PropertyPathDetails)).path.calculate(easing)); else Reflect.setProperty(details2.target,details2.propertyName,(js.Boot.__cast(details2 , motion.actuators.PropertyPathDetails)).path.calculate(easing));
					} else if(details2.isField) Reflect.setField(details2.target,details2.propertyName,Math.round((js.Boot.__cast(details2 , motion.actuators.PropertyPathDetails)).path.calculate(easing))); else Reflect.setProperty(details2.target,details2.propertyName,Math.round((js.Boot.__cast(details2 , motion.actuators.PropertyPathDetails)).path.calculate(easing)));
				}
			}
			if(tweenPosition == 1) {
				if(this._repeat == 0) {
					this.active = false;
					if(this.toggleVisible && this.getField(this.target,"alpha") == 0) this.setField_motion_actuators_MotionPathActuator_T(this.target,"visible",false);
					this.complete(true);
					return;
				} else {
					if(this._onRepeat != null) this.callMethod(this._onRepeat,this._onRepeatParams);
					if(this._reflect) this._reverse = !this._reverse;
					this.startTime = currentTime;
					this.timeOffset = this.startTime + this._delay;
					if(this._repeat > 0) this._repeat--;
				}
			}
			if(this.sendChange) this.change();
		}
	}
	,__class__: motion.actuators.MotionPathActuator
});
motion.actuators.PropertyDetails = function(target,propertyName,start,change,isField) {
	if(isField == null) isField = true;
	this.target = target;
	this.propertyName = propertyName;
	this.start = start;
	this.change = change;
	this.isField = isField;
};
$hxClasses["motion.actuators.PropertyDetails"] = motion.actuators.PropertyDetails;
motion.actuators.PropertyDetails.__name__ = ["motion","actuators","PropertyDetails"];
motion.actuators.PropertyDetails.prototype = {
	__class__: motion.actuators.PropertyDetails
};
motion.actuators.PropertyPathDetails = function(target,propertyName,path,isField) {
	if(isField == null) isField = true;
	motion.actuators.PropertyDetails.call(this,target,propertyName,0,0,isField);
	this.path = path;
};
$hxClasses["motion.actuators.PropertyPathDetails"] = motion.actuators.PropertyPathDetails;
motion.actuators.PropertyPathDetails.__name__ = ["motion","actuators","PropertyPathDetails"];
motion.actuators.PropertyPathDetails.__super__ = motion.actuators.PropertyDetails;
motion.actuators.PropertyPathDetails.prototype = $extend(motion.actuators.PropertyDetails.prototype,{
	__class__: motion.actuators.PropertyPathDetails
});
motion.actuators.TransformActuator = function(target,duration,properties) {
	motion.actuators.SimpleActuator.call(this,target,duration,properties);
};
$hxClasses["motion.actuators.TransformActuator"] = motion.actuators.TransformActuator;
motion.actuators.TransformActuator.__name__ = ["motion","actuators","TransformActuator"];
motion.actuators.TransformActuator.__super__ = motion.actuators.SimpleActuator;
motion.actuators.TransformActuator.prototype = $extend(motion.actuators.SimpleActuator.prototype,{
	setField_openfl_geom_Transform: function(target,propertyName,value) {
		if(Object.prototype.hasOwnProperty.call(target,propertyName)) target[propertyName] = value; else Reflect.setProperty(target,propertyName,value);
	}
	,setField_motion_actuators_TransformActuator_T: function(target,propertyName,value) {
		if(Object.prototype.hasOwnProperty.call(target,propertyName)) target[propertyName] = value; else Reflect.setProperty(target,propertyName,value);
	}
	,apply: function() {
		this.initialize();
		if(this.endColorTransform != null) {
			var transform = this.getField(this.target,"transform");
			this.setField_openfl_geom_Transform(transform,"colorTransform",this.endColorTransform);
		}
		if(this.endSoundTransform != null) this.setField_motion_actuators_TransformActuator_T(this.target,"soundTransform",this.endSoundTransform);
	}
	,initialize: function() {
		if(Object.prototype.hasOwnProperty.call(this.properties,"colorValue") && js.Boot.__instanceof(this.target,openfl.display.DisplayObject)) this.initializeColor();
		if(Object.prototype.hasOwnProperty.call(this.properties,"soundVolume") || Object.prototype.hasOwnProperty.call(this.properties,"soundPan")) this.initializeSound();
		this.detailsLength = this.propertyDetails.length;
		this.initialized = true;
	}
	,initializeColor: function() {
		this.endColorTransform = new openfl.geom.ColorTransform();
		var color = this.properties.colorValue;
		var strength = this.properties.colorStrength;
		if(strength < 1) {
			var multiplier;
			var offset;
			if(strength < 0.5) {
				multiplier = 1;
				offset = strength * 2;
			} else {
				multiplier = 1 - (strength - 0.5) * 2;
				offset = 1;
			}
			this.endColorTransform.redMultiplier = multiplier;
			this.endColorTransform.greenMultiplier = multiplier;
			this.endColorTransform.blueMultiplier = multiplier;
			this.endColorTransform.redOffset = offset * (color >> 16 & 255);
			this.endColorTransform.greenOffset = offset * (color >> 8 & 255);
			this.endColorTransform.blueOffset = offset * (color & 255);
		} else {
			this.endColorTransform.redMultiplier = 0;
			this.endColorTransform.greenMultiplier = 0;
			this.endColorTransform.blueMultiplier = 0;
			this.endColorTransform.redOffset = color >> 16 & 255;
			this.endColorTransform.greenOffset = color >> 8 & 255;
			this.endColorTransform.blueOffset = color & 255;
		}
		var propertyNames = ["redMultiplier","greenMultiplier","blueMultiplier","redOffset","greenOffset","blueOffset"];
		if(Object.prototype.hasOwnProperty.call(this.properties,"colorAlpha")) {
			this.endColorTransform.alphaMultiplier = this.properties.colorAlpha;
			propertyNames.push("alphaMultiplier");
		} else this.endColorTransform.alphaMultiplier = this.getField(this.target,"alpha");
		var transform = this.getField(this.target,"transform");
		var begin = this.getField(transform,"colorTransform");
		this.tweenColorTransform = new openfl.geom.ColorTransform();
		var details;
		var start;
		var _g = 0;
		while(_g < propertyNames.length) {
			var propertyName = propertyNames[_g];
			++_g;
			start = this.getField(begin,propertyName);
			details = new motion.actuators.PropertyDetails(this.tweenColorTransform,propertyName,start,this.getField(this.endColorTransform,propertyName) - start);
			this.propertyDetails.push(details);
		}
	}
	,initializeSound: function() {
		if(this.getField(this.target,"soundTransform") == null) this.setField_motion_actuators_TransformActuator_T(this.target,"soundTransform",new openfl.media.SoundTransform());
		var start = this.getField(this.target,"soundTransform");
		this.endSoundTransform = this.getField(this.target,"soundTransform");
		this.tweenSoundTransform = new openfl.media.SoundTransform();
		if(Object.prototype.hasOwnProperty.call(this.properties,"soundVolume")) {
			this.endSoundTransform.volume = this.properties.soundVolume;
			this.propertyDetails.push(new motion.actuators.PropertyDetails(this.tweenSoundTransform,"volume",start.volume,this.endSoundTransform.volume - start.volume));
		}
		if(Object.prototype.hasOwnProperty.call(this.properties,"soundPan")) {
			this.endSoundTransform.pan = this.properties.soundPan;
			this.propertyDetails.push(new motion.actuators.PropertyDetails(this.tweenSoundTransform,"pan",start.pan,this.endSoundTransform.pan - start.pan));
		}
	}
	,update: function(currentTime) {
		motion.actuators.SimpleActuator.prototype.update.call(this,currentTime);
		if(this.endColorTransform != null) {
			var transform = this.getField(this.target,"transform");
			this.setField_openfl_geom_Transform(transform,"colorTransform",this.tweenColorTransform);
		}
		if(this.endSoundTransform != null) this.setField_motion_actuators_TransformActuator_T(this.target,"soundTransform",this.tweenSoundTransform);
	}
	,__class__: motion.actuators.TransformActuator
});
motion.easing.Bounce = function() { };
$hxClasses["motion.easing.Bounce"] = motion.easing.Bounce;
motion.easing.Bounce.__name__ = ["motion","easing","Bounce"];
motion.easing.Bounce.__properties__ = {get_easeOut:"get_easeOut",get_easeInOut:"get_easeInOut",get_easeIn:"get_easeIn"}
motion.easing.Bounce.get_easeIn = function() {
	return new motion.easing.BounceEaseIn();
};
motion.easing.Bounce.get_easeInOut = function() {
	return new motion.easing.BounceEaseInOut();
};
motion.easing.Bounce.get_easeOut = function() {
	return new motion.easing.BounceEaseOut();
};
motion.easing.BounceEaseIn = function() {
};
$hxClasses["motion.easing.BounceEaseIn"] = motion.easing.BounceEaseIn;
motion.easing.BounceEaseIn.__name__ = ["motion","easing","BounceEaseIn"];
motion.easing.BounceEaseIn.__interfaces__ = [motion.easing.IEasing];
motion.easing.BounceEaseIn._ease = function(t,b,c,d) {
	return c - motion.easing.BounceEaseOut._ease(d - t,0,c,d) + b;
};
motion.easing.BounceEaseIn.prototype = {
	calculate: function(k) {
		return 1 - motion.easing.BounceEaseOut._ease(1 - k,0,1,1);
	}
	,ease: function(t,b,c,d) {
		return c - motion.easing.BounceEaseOut._ease(d - t,0,c,d) + b;
	}
	,__class__: motion.easing.BounceEaseIn
};
motion.easing.BounceEaseInOut = function() {
};
$hxClasses["motion.easing.BounceEaseInOut"] = motion.easing.BounceEaseInOut;
motion.easing.BounceEaseInOut.__name__ = ["motion","easing","BounceEaseInOut"];
motion.easing.BounceEaseInOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.BounceEaseInOut.prototype = {
	calculate: function(k) {
		if(k < .5) return (1 - motion.easing.BounceEaseOut._ease(1 - k * 2,0,1,1)) * .5; else return motion.easing.BounceEaseOut._ease(k * 2 - 1,0,1,1) * .5 + .5;
	}
	,ease: function(t,b,c,d) {
		if(t < d / 2) return (c - motion.easing.BounceEaseOut._ease(d - t * 2,0,c,d)) * .5 + b; else return motion.easing.BounceEaseOut._ease(t * 2 - d,0,c,d) * .5 + c * .5 + b;
	}
	,__class__: motion.easing.BounceEaseInOut
};
motion.easing.BounceEaseOut = function() {
};
$hxClasses["motion.easing.BounceEaseOut"] = motion.easing.BounceEaseOut;
motion.easing.BounceEaseOut.__name__ = ["motion","easing","BounceEaseOut"];
motion.easing.BounceEaseOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.BounceEaseOut._ease = function(t,b,c,d) {
	if((t /= d) < 0.363636363636363646) return c * (7.5625 * t * t) + b; else if(t < 0.727272727272727293) return c * (7.5625 * (t -= 0.545454545454545414) * t + .75) + b; else if(t < 0.909090909090909061) return c * (7.5625 * (t -= 0.818181818181818232) * t + .9375) + b; else return c * (7.5625 * (t -= 0.954545454545454586) * t + .984375) + b;
};
motion.easing.BounceEaseOut.prototype = {
	calculate: function(k) {
		return motion.easing.BounceEaseOut._ease(k,0,1,1);
	}
	,ease: function(t,b,c,d) {
		return motion.easing.BounceEaseOut._ease(t,b,c,d);
	}
	,__class__: motion.easing.BounceEaseOut
};
motion.easing.Cubic = function() { };
$hxClasses["motion.easing.Cubic"] = motion.easing.Cubic;
motion.easing.Cubic.__name__ = ["motion","easing","Cubic"];
motion.easing.Cubic.__properties__ = {get_easeOut:"get_easeOut",get_easeInOut:"get_easeInOut",get_easeIn:"get_easeIn"}
motion.easing.Cubic.get_easeIn = function() {
	return new motion.easing.CubicEaseIn();
};
motion.easing.Cubic.get_easeInOut = function() {
	return new motion.easing.CubicEaseInOut();
};
motion.easing.Cubic.get_easeOut = function() {
	return new motion.easing.CubicEaseOut();
};
motion.easing.CubicEaseIn = function() {
};
$hxClasses["motion.easing.CubicEaseIn"] = motion.easing.CubicEaseIn;
motion.easing.CubicEaseIn.__name__ = ["motion","easing","CubicEaseIn"];
motion.easing.CubicEaseIn.__interfaces__ = [motion.easing.IEasing];
motion.easing.CubicEaseIn.prototype = {
	calculate: function(k) {
		return k * k * k;
	}
	,ease: function(t,b,c,d) {
		return c * (t /= d) * t * t + b;
	}
	,__class__: motion.easing.CubicEaseIn
};
motion.easing.CubicEaseInOut = function() {
};
$hxClasses["motion.easing.CubicEaseInOut"] = motion.easing.CubicEaseInOut;
motion.easing.CubicEaseInOut.__name__ = ["motion","easing","CubicEaseInOut"];
motion.easing.CubicEaseInOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.CubicEaseInOut.prototype = {
	calculate: function(k) {
		if((k /= 0.5) < 1) return 0.5 * k * k * k; else return 0.5 * ((k -= 2) * k * k + 2);
	}
	,ease: function(t,b,c,d) {
		if((t /= d / 2) < 1) return c / 2 * t * t * t + b; else return c / 2 * ((t -= 2) * t * t + 2) + b;
	}
	,__class__: motion.easing.CubicEaseInOut
};
motion.easing.CubicEaseOut = function() {
};
$hxClasses["motion.easing.CubicEaseOut"] = motion.easing.CubicEaseOut;
motion.easing.CubicEaseOut.__name__ = ["motion","easing","CubicEaseOut"];
motion.easing.CubicEaseOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.CubicEaseOut.prototype = {
	calculate: function(k) {
		return --k * k * k + 1;
	}
	,ease: function(t,b,c,d) {
		return c * ((t = t / d - 1) * t * t + 1) + b;
	}
	,__class__: motion.easing.CubicEaseOut
};
motion.easing.Elastic = function() { };
$hxClasses["motion.easing.Elastic"] = motion.easing.Elastic;
motion.easing.Elastic.__name__ = ["motion","easing","Elastic"];
motion.easing.Elastic.__properties__ = {get_easeOut:"get_easeOut",get_easeInOut:"get_easeInOut",get_easeIn:"get_easeIn"}
motion.easing.Elastic.get_easeIn = function() {
	return new motion.easing.ElasticEaseIn(0.1,0.4);
};
motion.easing.Elastic.get_easeInOut = function() {
	return new motion.easing.ElasticEaseInOut(0.1,0.4);
};
motion.easing.Elastic.get_easeOut = function() {
	return new motion.easing.ElasticEaseOut(0.1,0.4);
};
motion.easing.ElasticEaseIn = function(a,p) {
	this.a = a;
	this.p = p;
};
$hxClasses["motion.easing.ElasticEaseIn"] = motion.easing.ElasticEaseIn;
motion.easing.ElasticEaseIn.__name__ = ["motion","easing","ElasticEaseIn"];
motion.easing.ElasticEaseIn.__interfaces__ = [motion.easing.IEasing];
motion.easing.ElasticEaseIn.prototype = {
	calculate: function(k) {
		if(k == 0) return 0;
		if(k == 1) return 1;
		var s;
		if(this.a < 1) {
			this.a = 1;
			s = this.p / 4;
		} else s = this.p / (2 * Math.PI) * Math.asin(1 / this.a);
		return -(this.a * Math.pow(2,10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / this.p));
	}
	,ease: function(t,b,c,d) {
		if(t == 0) return b;
		if((t /= d) == 1) return b + c;
		var s;
		if(this.a < Math.abs(c)) {
			this.a = c;
			s = this.p / 4;
		} else s = this.p / (2 * Math.PI) * Math.asin(c / this.a);
		return -(this.a * Math.pow(2,10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / this.p)) + b;
	}
	,__class__: motion.easing.ElasticEaseIn
};
motion.easing.ElasticEaseInOut = function(a,p) {
	this.a = a;
	this.p = p;
};
$hxClasses["motion.easing.ElasticEaseInOut"] = motion.easing.ElasticEaseInOut;
motion.easing.ElasticEaseInOut.__name__ = ["motion","easing","ElasticEaseInOut"];
motion.easing.ElasticEaseInOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.ElasticEaseInOut.prototype = {
	calculate: function(k) {
		if(k == 0) return 0;
		if((k /= 0.5) == 2) return 1;
		var p = 0.449999999999999956;
		var a = 1;
		var s = p / 4;
		if(k < 1) return -0.5 * (Math.pow(2,10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
		return Math.pow(2,-10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * 0.5 + 1;
	}
	,ease: function(t,b,c,d) {
		if(t == 0) return b;
		if((t /= d / 2) == 2) return b + c;
		var s;
		if(this.a < Math.abs(c)) {
			this.a = c;
			s = this.p / 4;
		} else s = this.p / (2 * Math.PI) * Math.asin(c / this.a);
		if(t < 1) return -0.5 * (this.a * Math.pow(2,10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / this.p)) + b;
		return this.a * Math.pow(2,-10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / this.p) * 0.5 + c + b;
	}
	,__class__: motion.easing.ElasticEaseInOut
};
motion.easing.ElasticEaseOut = function(a,p) {
	this.a = a;
	this.p = p;
};
$hxClasses["motion.easing.ElasticEaseOut"] = motion.easing.ElasticEaseOut;
motion.easing.ElasticEaseOut.__name__ = ["motion","easing","ElasticEaseOut"];
motion.easing.ElasticEaseOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.ElasticEaseOut.prototype = {
	calculate: function(k) {
		if(k == 0) return 0;
		if(k == 1) return 1;
		var s;
		if(this.a < 1) {
			this.a = 1;
			s = this.p / 4;
		} else s = this.p / (2 * Math.PI) * Math.asin(1 / this.a);
		return this.a * Math.pow(2,-10 * k) * Math.sin((k - s) * (2 * Math.PI) / this.p) + 1;
	}
	,ease: function(t,b,c,d) {
		if(t == 0) return b;
		if((t /= d) == 1) return b + c;
		var s;
		if(this.a < Math.abs(c)) {
			this.a = c;
			s = this.p / 4;
		} else s = this.p / (2 * Math.PI) * Math.asin(c / this.a);
		return this.a * Math.pow(2,-10 * t) * Math.sin((t * d - s) * (2 * Math.PI) / this.p) + c + b;
	}
	,__class__: motion.easing.ElasticEaseOut
};
motion.easing.ExpoEaseIn = function() {
};
$hxClasses["motion.easing.ExpoEaseIn"] = motion.easing.ExpoEaseIn;
motion.easing.ExpoEaseIn.__name__ = ["motion","easing","ExpoEaseIn"];
motion.easing.ExpoEaseIn.__interfaces__ = [motion.easing.IEasing];
motion.easing.ExpoEaseIn.prototype = {
	calculate: function(k) {
		if(k == 0) return 0; else return Math.pow(2,10 * (k - 1));
	}
	,ease: function(t,b,c,d) {
		if(t == 0) return b; else return c * Math.pow(2,10 * (t / d - 1)) + b;
	}
	,__class__: motion.easing.ExpoEaseIn
};
motion.easing.ExpoEaseInOut = function() {
};
$hxClasses["motion.easing.ExpoEaseInOut"] = motion.easing.ExpoEaseInOut;
motion.easing.ExpoEaseInOut.__name__ = ["motion","easing","ExpoEaseInOut"];
motion.easing.ExpoEaseInOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.ExpoEaseInOut.prototype = {
	calculate: function(k) {
		if(k == 0) return 0;
		if(k == 1) return 1;
		if((k /= 0.5) < 1.0) return 0.5 * Math.pow(2,10 * (k - 1));
		return 0.5 * (2 - Math.pow(2,-10 * --k));
	}
	,ease: function(t,b,c,d) {
		if(t == 0) return b;
		if(t == d) return b + c;
		if((t /= d / 2.0) < 1.0) return c / 2 * Math.pow(2,10 * (t - 1)) + b;
		return c / 2 * (2 - Math.pow(2,-10 * --t)) + b;
	}
	,__class__: motion.easing.ExpoEaseInOut
};
motion.easing.Linear = function() { };
$hxClasses["motion.easing.Linear"] = motion.easing.Linear;
motion.easing.Linear.__name__ = ["motion","easing","Linear"];
motion.easing.Linear.__properties__ = {get_easeNone:"get_easeNone"}
motion.easing.Linear.get_easeNone = function() {
	return new motion.easing.LinearEaseNone();
};
motion.easing.LinearEaseNone = function() {
};
$hxClasses["motion.easing.LinearEaseNone"] = motion.easing.LinearEaseNone;
motion.easing.LinearEaseNone.__name__ = ["motion","easing","LinearEaseNone"];
motion.easing.LinearEaseNone.__interfaces__ = [motion.easing.IEasing];
motion.easing.LinearEaseNone.prototype = {
	calculate: function(k) {
		return k;
	}
	,ease: function(t,b,c,d) {
		return c * t / d + b;
	}
	,__class__: motion.easing.LinearEaseNone
};
motion.easing.Sine = function() { };
$hxClasses["motion.easing.Sine"] = motion.easing.Sine;
motion.easing.Sine.__name__ = ["motion","easing","Sine"];
motion.easing.Sine.__properties__ = {get_easeOut:"get_easeOut",get_easeInOut:"get_easeInOut",get_easeIn:"get_easeIn"}
motion.easing.Sine.get_easeIn = function() {
	return new motion.easing.SineEaseIn();
};
motion.easing.Sine.get_easeInOut = function() {
	return new motion.easing.SineEaseInOut();
};
motion.easing.Sine.get_easeOut = function() {
	return new motion.easing.SineEaseOut();
};
motion.easing.SineEaseIn = function() {
};
$hxClasses["motion.easing.SineEaseIn"] = motion.easing.SineEaseIn;
motion.easing.SineEaseIn.__name__ = ["motion","easing","SineEaseIn"];
motion.easing.SineEaseIn.__interfaces__ = [motion.easing.IEasing];
motion.easing.SineEaseIn.prototype = {
	calculate: function(k) {
		return 1 - Math.cos(k * (Math.PI / 2));
	}
	,ease: function(t,b,c,d) {
		return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;
	}
	,__class__: motion.easing.SineEaseIn
};
motion.easing.SineEaseInOut = function() {
};
$hxClasses["motion.easing.SineEaseInOut"] = motion.easing.SineEaseInOut;
motion.easing.SineEaseInOut.__name__ = ["motion","easing","SineEaseInOut"];
motion.easing.SineEaseInOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.SineEaseInOut.prototype = {
	calculate: function(k) {
		return -(Math.cos(Math.PI * k) - 1) / 2;
	}
	,ease: function(t,b,c,d) {
		return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
	}
	,__class__: motion.easing.SineEaseInOut
};
motion.easing.SineEaseOut = function() {
};
$hxClasses["motion.easing.SineEaseOut"] = motion.easing.SineEaseOut;
motion.easing.SineEaseOut.__name__ = ["motion","easing","SineEaseOut"];
motion.easing.SineEaseOut.__interfaces__ = [motion.easing.IEasing];
motion.easing.SineEaseOut.prototype = {
	calculate: function(k) {
		return Math.sin(k * (Math.PI / 2));
	}
	,ease: function(t,b,c,d) {
		return c * Math.sin(t / d * (Math.PI / 2)) + b;
	}
	,__class__: motion.easing.SineEaseOut
};
openfl.IAssetCache = function() { };
$hxClasses["openfl.IAssetCache"] = openfl.IAssetCache;
openfl.IAssetCache.__name__ = ["openfl","IAssetCache"];
openfl.IAssetCache.prototype = {
	__class__: openfl.IAssetCache
};
openfl.AssetCache = function() {
	this.__enabled = true;
	this.bitmapData = new haxe.ds.StringMap();
	this.font = new haxe.ds.StringMap();
	this.sound = new haxe.ds.StringMap();
};
$hxClasses["openfl.AssetCache"] = openfl.AssetCache;
openfl.AssetCache.__name__ = ["openfl","AssetCache"];
openfl.AssetCache.__interfaces__ = [openfl.IAssetCache];
openfl.AssetCache.prototype = {
	clear: function(prefix) {
		if(prefix == null) {
			this.bitmapData = new haxe.ds.StringMap();
			this.font = new haxe.ds.StringMap();
			this.sound = new haxe.ds.StringMap();
		} else {
			var keys = this.bitmapData.keys();
			while( keys.hasNext() ) {
				var key = keys.next();
				if(StringTools.startsWith(key,prefix)) this.bitmapData.remove(key);
			}
			var keys1 = this.font.keys();
			while( keys1.hasNext() ) {
				var key1 = keys1.next();
				if(StringTools.startsWith(key1,prefix)) this.font.remove(key1);
			}
			var keys2 = this.sound.keys();
			while( keys2.hasNext() ) {
				var key2 = keys2.next();
				if(StringTools.startsWith(key2,prefix)) this.sound.remove(key2);
			}
		}
	}
	,getBitmapData: function(id) {
		return this.bitmapData.get(id);
	}
	,getFont: function(id) {
		return this.font.get(id);
	}
	,getSound: function(id) {
		return this.sound.get(id);
	}
	,hasBitmapData: function(id) {
		return this.bitmapData.exists(id);
	}
	,hasFont: function(id) {
		return this.font.exists(id);
	}
	,hasSound: function(id) {
		return this.sound.exists(id);
	}
	,removeBitmapData: function(id) {
		return this.bitmapData.remove(id);
	}
	,removeFont: function(id) {
		return this.font.remove(id);
	}
	,removeSound: function(id) {
		return this.sound.remove(id);
	}
	,setBitmapData: function(id,bitmapData) {
		this.bitmapData.set(id,bitmapData);
	}
	,setFont: function(id,font) {
		this.font.set(id,font);
	}
	,setSound: function(id,sound) {
		this.sound.set(id,sound);
	}
	,get_enabled: function() {
		return this.__enabled;
	}
	,set_enabled: function(value) {
		return this.__enabled = value;
	}
	,__class__: openfl.AssetCache
	,__properties__: {set_enabled:"set_enabled",get_enabled:"get_enabled"}
};
openfl.Assets = function() { };
$hxClasses["openfl.Assets"] = openfl.Assets;
openfl.Assets.__name__ = ["openfl","Assets"];
openfl.Assets.addEventListener = function(type,listener,useCapture,priority,useWeakReference) {
	if(useWeakReference == null) useWeakReference = false;
	if(priority == null) priority = 0;
	if(useCapture == null) useCapture = false;
	openfl.Assets.dispatcher.addEventListener(type,listener,useCapture,priority,useWeakReference);
};
openfl.Assets.dispatchEvent = function(event) {
	return openfl.Assets.dispatcher.dispatchEvent(event);
};
openfl.Assets.exists = function(id,type) {
	return lime.Assets.exists(id,type);
};
openfl.Assets.getBitmapData = function(id,useCache) {
	if(useCache == null) useCache = true;
	if(useCache && openfl.Assets.cache.get_enabled() && openfl.Assets.cache.hasBitmapData(id)) {
		var bitmapData = openfl.Assets.cache.getBitmapData(id);
		if(openfl.Assets.isValidBitmapData(bitmapData)) return bitmapData;
	}
	var image = lime.Assets.getImage(id,false);
	if(image != null) {
		var bitmapData1 = openfl.display.BitmapData.fromImage(image);
		if(useCache && openfl.Assets.cache.get_enabled()) openfl.Assets.cache.setBitmapData(id,bitmapData1);
		return bitmapData1;
	}
	return null;
};
openfl.Assets.getBytes = function(id) {
	return lime.Assets.getBytes(id);
};
openfl.Assets.getFont = function(id,useCache) {
	if(useCache == null) useCache = true;
	if(useCache && openfl.Assets.cache.get_enabled() && openfl.Assets.cache.hasFont(id)) return openfl.Assets.cache.getFont(id);
	var font = lime.Assets.getFont(id,false);
	if(font != null) return font;
	return new openfl.text.Font();
};
openfl.Assets.getLibrary = function(name) {
	if(name == null || name == "") name = "default";
	return lime.Assets.libraries.get(name);
};
openfl.Assets.getMovieClip = function(id) {
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = openfl.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"MOVIE_CLIP")) {
			if(library.isLocal(symbolName,"MOVIE_CLIP")) return library.getMovieClip(symbolName); else null;
		} else null;
	} else null;
	return null;
};
openfl.Assets.getMusic = function(id,useCache) {
	if(useCache == null) useCache = true;
	var path = lime.Assets.getPath(id);
	if(path != null) return new openfl.media.Sound(new openfl.net.URLRequest(path));
	return null;
};
openfl.Assets.getPath = function(id) {
	return lime.Assets.getPath(id);
};
openfl.Assets.getSound = function(id,useCache) {
	if(useCache == null) useCache = true;
	if(useCache && openfl.Assets.cache.get_enabled() && openfl.Assets.cache.hasSound(id)) {
		var sound = openfl.Assets.cache.getSound(id);
		if(openfl.Assets.isValidSound(sound)) return sound;
	}
	var path = lime.Assets.getPath(id);
	if(path != null) return new openfl.media.Sound(new openfl.net.URLRequest(path));
	return null;
};
openfl.Assets.getText = function(id) {
	return lime.Assets.getText(id);
};
openfl.Assets.hasEventListener = function(type) {
	return openfl.Assets.dispatcher.hasEventListener(type);
};
openfl.Assets.isLocal = function(id,type,useCache) {
	if(useCache == null) useCache = true;
	if(useCache && openfl.Assets.cache.get_enabled()) {
		if(type == "IMAGE" || type == null) {
			if(openfl.Assets.cache.hasBitmapData(id)) return true;
		}
		if(type == "FONT" || type == null) {
			if(openfl.Assets.cache.hasFont(id)) return true;
		}
		if(type == "SOUND" || type == "MUSIC" || type == null) {
			if(openfl.Assets.cache.hasSound(id)) return true;
		}
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = openfl.Assets.getLibrary(libraryName);
	if(library != null) return library.isLocal(symbolName,type);
	return false;
};
openfl.Assets.isValidBitmapData = function(bitmapData) {
	return bitmapData != null;
	return true;
};
openfl.Assets.isValidSound = function(sound) {
	return true;
};
openfl.Assets.list = function(type) {
	return lime.Assets.list(type);
};
openfl.Assets.loadBitmapData = function(id,handler,useCache) {
	if(useCache == null) useCache = true;
	if(useCache && openfl.Assets.cache.get_enabled() && openfl.Assets.cache.hasBitmapData(id)) {
		var bitmapData = openfl.Assets.cache.getBitmapData(id);
		if(openfl.Assets.isValidBitmapData(bitmapData)) {
			handler(bitmapData);
			return;
		}
	}
	lime.Assets.loadImage(id,function(image) {
		if(image != null) {
			var bitmapData1 = openfl.display.BitmapData.fromImage(image);
			if(useCache && openfl.Assets.cache.get_enabled()) openfl.Assets.cache.setBitmapData(id,bitmapData1);
			handler(bitmapData1);
		}
	},false);
};
openfl.Assets.loadBytes = function(id,handler) {
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = openfl.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"BINARY")) {
			library.loadBytes(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
openfl.Assets.loadFont = function(id,handler,useCache) {
	if(useCache == null) useCache = true;
	if(useCache && openfl.Assets.cache.get_enabled() && openfl.Assets.cache.hasFont(id)) {
		handler(openfl.Assets.cache.getFont(id));
		return;
	}
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = openfl.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"FONT")) {
			if(useCache && openfl.Assets.cache.get_enabled()) library.loadFont(symbolName,function(font) {
				openfl.Assets.cache.setFont(id,font);
				handler(font);
			}); else library.loadFont(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
openfl.Assets.loadLibrary = function(name,handler) {
	lime.Assets.loadLibrary(name,handler);
};
openfl.Assets.loadMusic = function(id,handler,useCache) {
	if(useCache == null) useCache = true;
	handler(openfl.Assets.getMusic(id,useCache));
};
openfl.Assets.loadMovieClip = function(id,handler) {
	var libraryName = id.substring(0,id.indexOf(":"));
	var symbolName;
	var pos = id.indexOf(":") + 1;
	symbolName = HxOverrides.substr(id,pos,null);
	var library = openfl.Assets.getLibrary(libraryName);
	if(library != null) {
		if(library.exists(symbolName,"MOVIE_CLIP")) {
			library.loadMovieClip(symbolName,handler);
			return;
		} else null;
	} else null;
	handler(null);
};
openfl.Assets.loadSound = function(id,handler,useCache) {
	if(useCache == null) useCache = true;
	handler(openfl.Assets.getSound(id,useCache));
};
openfl.Assets.loadText = function(id,handler) {
	lime.Assets.loadText(id,handler);
};
openfl.Assets.registerLibrary = function(name,library) {
	lime.Assets.registerLibrary(name,library);
};
openfl.Assets.removeEventListener = function(type,listener,capture) {
	if(capture == null) capture = false;
	openfl.Assets.dispatcher.removeEventListener(type,listener,capture);
};
openfl.Assets.resolveClass = function(name) {
	return Type.resolveClass(name);
};
openfl.Assets.resolveEnum = function(name) {
	var value = Type.resolveEnum(name);
	return value;
};
openfl.Assets.unloadLibrary = function(name) {
	lime.Assets.unloadLibrary(name);
};
openfl.Assets.library_onEvent = function(library,type) {
	if(type == "change") {
		openfl.Assets.cache.clear();
		openfl.Assets.dispatchEvent(new openfl.events.Event(openfl.events.Event.CHANGE));
	}
};
openfl.AssetLibrary = function() {
	lime.AssetLibrary.call(this);
};
$hxClasses["openfl.AssetLibrary"] = openfl.AssetLibrary;
openfl.AssetLibrary.__name__ = ["openfl","AssetLibrary"];
openfl.AssetLibrary.__super__ = lime.AssetLibrary;
openfl.AssetLibrary.prototype = $extend(lime.AssetLibrary.prototype,{
	getMovieClip: function(id) {
		return null;
	}
	,getMusic: function(id) {
		return this.getSound(id);
	}
	,getSound: function(id) {
		return null;
	}
	,loadMovieClip: function(id,handler) {
		handler(this.getMovieClip(id));
	}
	,loadMusic: function(id,handler) {
		handler(this.getMusic(id));
	}
	,loadSound: function(id,handler) {
		handler(this.getSound(id));
	}
	,__class__: openfl.AssetLibrary
});
openfl._Assets = {};
openfl._Assets.AssetType_Impl_ = function() { };
$hxClasses["openfl._Assets.AssetType_Impl_"] = openfl._Assets.AssetType_Impl_;
openfl._Assets.AssetType_Impl_.__name__ = ["openfl","_Assets","AssetType_Impl_"];
openfl.display.MovieClip = function() {
	openfl.display.Sprite.call(this);
	this.__currentFrame = 0;
	this.__currentLabels = [];
	this.__totalFrames = 0;
	this.enabled = true;
};
$hxClasses["openfl.display.MovieClip"] = openfl.display.MovieClip;
openfl.display.MovieClip.__name__ = ["openfl","display","MovieClip"];
openfl.display.MovieClip.__super__ = openfl.display.Sprite;
openfl.display.MovieClip.prototype = $extend(openfl.display.Sprite.prototype,{
	gotoAndPlay: function(frame,scene) {
	}
	,gotoAndStop: function(frame,scene) {
	}
	,nextFrame: function() {
	}
	,play: function() {
	}
	,prevFrame: function() {
	}
	,stop: function() {
	}
	,get_currentFrame: function() {
		return this.__currentFrame;
	}
	,get_currentFrameLabel: function() {
		return this.__currentFrameLabel;
	}
	,get_currentLabel: function() {
		return this.__currentLabel;
	}
	,get_currentLabels: function() {
		return this.__currentLabels;
	}
	,get_framesLoaded: function() {
		return this.__totalFrames;
	}
	,get_totalFrames: function() {
		return this.__totalFrames;
	}
	,__class__: openfl.display.MovieClip
	,__properties__: $extend(openfl.display.Sprite.prototype.__properties__,{get_totalFrames:"get_totalFrames",get_framesLoaded:"get_framesLoaded",get_currentLabels:"get_currentLabels",get_currentLabel:"get_currentLabel",get_currentFrameLabel:"get_currentFrameLabel",get_currentFrame:"get_currentFrame"})
});
openfl.display.LoaderInfo = function() {
	openfl.events.EventDispatcher.call(this);
	this.applicationDomain = openfl.system.ApplicationDomain.currentDomain;
	this.bytesLoaded = 0;
	this.bytesTotal = 0;
	this.childAllowsParent = true;
	this.parameters = { };
};
$hxClasses["openfl.display.LoaderInfo"] = openfl.display.LoaderInfo;
openfl.display.LoaderInfo.__name__ = ["openfl","display","LoaderInfo"];
openfl.display.LoaderInfo.create = function(loader) {
	var loaderInfo = new openfl.display.LoaderInfo();
	loaderInfo.uncaughtErrorEvents = new openfl.events.UncaughtErrorEvents();
	if(loader != null) loaderInfo.loader = loader; else loaderInfo.url = openfl.display.LoaderInfo.__rootURL;
	return loaderInfo;
};
openfl.display.LoaderInfo.__super__ = openfl.events.EventDispatcher;
openfl.display.LoaderInfo.prototype = $extend(openfl.events.EventDispatcher.prototype,{
	__class__: openfl.display.LoaderInfo
});
openfl.system = {};
openfl.system.ApplicationDomain = function(parentDomain) {
	if(parentDomain != null) this.parentDomain = parentDomain; else this.parentDomain = openfl.system.ApplicationDomain.currentDomain;
};
$hxClasses["openfl.system.ApplicationDomain"] = openfl.system.ApplicationDomain;
openfl.system.ApplicationDomain.__name__ = ["openfl","system","ApplicationDomain"];
openfl.system.ApplicationDomain.prototype = {
	getDefinition: function(name) {
		return Type.resolveClass(name);
	}
	,hasDefinition: function(name) {
		return Type.resolveClass(name) != null;
	}
	,__class__: openfl.system.ApplicationDomain
};
openfl.events.UncaughtErrorEvents = function(target) {
	openfl.events.EventDispatcher.call(this,target);
};
$hxClasses["openfl.events.UncaughtErrorEvents"] = openfl.events.UncaughtErrorEvents;
openfl.events.UncaughtErrorEvents.__name__ = ["openfl","events","UncaughtErrorEvents"];
openfl.events.UncaughtErrorEvents.__super__ = openfl.events.EventDispatcher;
openfl.events.UncaughtErrorEvents.prototype = $extend(openfl.events.EventDispatcher.prototype,{
	__class__: openfl.events.UncaughtErrorEvents
});
openfl.geom = {};
openfl.geom.Matrix = function(a,b,c,d,tx,ty) {
	if(ty == null) ty = 0;
	if(tx == null) tx = 0;
	if(d == null) d = 1;
	if(c == null) c = 0;
	if(b == null) b = 0;
	if(a == null) a = 1;
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	this.tx = tx;
	this.ty = ty;
	this.__array = new Float32Array([a,b,c,d,tx,ty,0,0,1]);
};
$hxClasses["openfl.geom.Matrix"] = openfl.geom.Matrix;
openfl.geom.Matrix.__name__ = ["openfl","geom","Matrix"];
openfl.geom.Matrix.prototype = {
	clone: function() {
		return new openfl.geom.Matrix(this.a,this.b,this.c,this.d,this.tx,this.ty);
	}
	,concat: function(m) {
		var a1 = this.a * m.a + this.b * m.c;
		this.b = this.a * m.b + this.b * m.d;
		this.a = a1;
		var c1 = this.c * m.a + this.d * m.c;
		this.d = this.c * m.b + this.d * m.d;
		this.c = c1;
		var tx1 = this.tx * m.a + this.ty * m.c + m.tx;
		this.ty = this.tx * m.b + this.ty * m.d + m.ty;
		this.tx = tx1;
	}
	,copyColumnFrom: function(column,vector3D) {
		if(column > 2) throw "Column " + column + " out of bounds (2)"; else if(column == 0) {
			this.a = vector3D.x;
			this.c = vector3D.y;
		} else if(column == 1) {
			this.b = vector3D.x;
			this.d = vector3D.y;
		} else {
			this.tx = vector3D.x;
			this.ty = vector3D.y;
		}
	}
	,copyColumnTo: function(column,vector3D) {
		if(column > 2) throw "Column " + column + " out of bounds (2)"; else if(column == 0) {
			vector3D.x = this.a;
			vector3D.y = this.c;
			vector3D.z = 0;
		} else if(column == 1) {
			vector3D.x = this.b;
			vector3D.y = this.d;
			vector3D.z = 0;
		} else {
			vector3D.x = this.tx;
			vector3D.y = this.ty;
			vector3D.z = 1;
		}
	}
	,copyFrom: function(sourceMatrix) {
		this.a = sourceMatrix.a;
		this.b = sourceMatrix.b;
		this.c = sourceMatrix.c;
		this.d = sourceMatrix.d;
		this.tx = sourceMatrix.tx;
		this.ty = sourceMatrix.ty;
	}
	,copyRowFrom: function(row,vector3D) {
		if(row > 2) throw "Row " + row + " out of bounds (2)"; else if(row == 0) {
			this.a = vector3D.x;
			this.c = vector3D.y;
		} else if(row == 1) {
			this.b = vector3D.x;
			this.d = vector3D.y;
		} else {
			this.tx = vector3D.x;
			this.ty = vector3D.y;
		}
	}
	,copyRowTo: function(row,vector3D) {
		if(row > 2) throw "Row " + row + " out of bounds (2)"; else if(row == 0) {
			vector3D.x = this.a;
			vector3D.y = this.b;
			vector3D.z = this.tx;
		} else if(row == 1) {
			vector3D.x = this.c;
			vector3D.y = this.d;
			vector3D.z = this.ty;
		} else {
			vector3D.x = 0;
			vector3D.y = 0;
			vector3D.z = 1;
		}
	}
	,createBox: function(scaleX,scaleY,rotation,tx,ty) {
		if(ty == null) ty = 0;
		if(tx == null) tx = 0;
		if(rotation == null) rotation = 0;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.a = cos * scaleX;
			this.b = sin * scaleY;
			this.c = -sin * scaleX;
			this.d = cos * scaleY;
		} else {
			this.a = scaleX;
			this.b = 0;
			this.c = 0;
			this.d = scaleY;
		}
		this.tx = tx;
		this.ty = ty;
	}
	,createGradientBox: function(width,height,rotation,tx,ty) {
		if(ty == null) ty = 0;
		if(tx == null) tx = 0;
		if(rotation == null) rotation = 0;
		this.a = width / 1638.4;
		this.d = height / 1638.4;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.b = sin * this.d;
			this.c = -sin * this.a;
			this.a *= cos;
			this.d *= cos;
		} else {
			this.b = 0;
			this.c = 0;
		}
		this.tx = tx + width / 2;
		this.ty = ty + height / 2;
	}
	,deltaTransformPoint: function(point) {
		return new openfl.geom.Point(point.x * this.a + point.y * this.c,point.x * this.b + point.y * this.d);
	}
	,equals: function(matrix) {
		return matrix != null && this.tx == matrix.tx && this.ty == matrix.ty && this.a == matrix.a && this.b == matrix.b && this.c == matrix.c && this.d == matrix.d;
	}
	,identity: function() {
		this.a = 1;
		this.b = 0;
		this.c = 0;
		this.d = 1;
		this.tx = 0;
		this.ty = 0;
	}
	,invert: function() {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			this.a = this.b = this.c = this.d = 0;
			this.tx = -this.tx;
			this.ty = -this.ty;
		} else {
			norm = 1.0 / norm;
			var a1 = this.d * norm;
			this.d = this.a * norm;
			this.a = a1;
			this.b *= -norm;
			this.c *= -norm;
			var tx1 = -this.a * this.tx - this.c * this.ty;
			this.ty = -this.b * this.tx - this.d * this.ty;
			this.tx = tx1;
		}
		return this;
	}
	,mult: function(m) {
		var result = new openfl.geom.Matrix();
		result.a = this.a * m.a + this.b * m.c;
		result.b = this.a * m.b + this.b * m.d;
		result.c = this.c * m.a + this.d * m.c;
		result.d = this.c * m.b + this.d * m.d;
		result.tx = this.tx * m.a + this.ty * m.c + m.tx;
		result.ty = this.tx * m.b + this.ty * m.d + m.ty;
		return result;
	}
	,rotate: function(theta) {
		var cos = Math.cos(theta);
		var sin = Math.sin(theta);
		var a1 = this.a * cos - this.b * sin;
		this.b = this.a * sin + this.b * cos;
		this.a = a1;
		var c1 = this.c * cos - this.d * sin;
		this.d = this.c * sin + this.d * cos;
		this.c = c1;
		var tx1 = this.tx * cos - this.ty * sin;
		this.ty = this.tx * sin + this.ty * cos;
		this.tx = tx1;
	}
	,scale: function(sx,sy) {
		this.a *= sx;
		this.b *= sy;
		this.c *= sx;
		this.d *= sy;
		this.tx *= sx;
		this.ty *= sy;
	}
	,setRotation: function(theta,scale) {
		if(scale == null) scale = 1;
		this.a = Math.cos(theta) * scale;
		this.c = Math.sin(theta) * scale;
		this.b = -this.c;
		this.d = this.a;
	}
	,setTo: function(a,b,c,d,tx,ty) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		this.tx = tx;
		this.ty = ty;
	}
	,to3DString: function(roundPixels) {
		if(roundPixels == null) roundPixels = false;
		if(roundPixels) return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + (this.tx | 0) + ", " + (this.ty | 0) + ", 0, 1)"; else return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + this.tx + ", " + this.ty + ", 0, 1)";
	}
	,toMozString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + "px, " + this.ty + "px)";
	}
	,toString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + ", " + this.ty + ")";
	}
	,transformPoint: function(pos) {
		return new openfl.geom.Point(pos.x * this.a + pos.y * this.c + this.tx,pos.x * this.b + pos.y * this.d + this.ty);
	}
	,translate: function(dx,dy) {
		var m = new openfl.geom.Matrix();
		m.tx = dx;
		m.ty = dy;
		this.concat(m);
	}
	,toArray: function(transpose) {
		if(transpose == null) transpose = false;
		if(transpose) {
			this.__array[0] = this.a;
			this.__array[1] = this.c;
			this.__array[2] = 0;
			this.__array[3] = this.b;
			this.__array[4] = this.d;
			this.__array[5] = 0;
			this.__array[6] = this.tx;
			this.__array[7] = this.ty;
			this.__array[8] = 1;
		} else {
			this.__array[0] = this.a;
			this.__array[1] = this.b;
			this.__array[2] = this.tx;
			this.__array[3] = this.c;
			this.__array[4] = this.d;
			this.__array[5] = this.ty;
			this.__array[6] = 0;
			this.__array[7] = 0;
			this.__array[8] = 1;
		}
		return this.__array;
	}
	,__cleanValues: function() {
		this.a = Math.round(this.a * 1000) / 1000;
		this.b = Math.round(this.b * 1000) / 1000;
		this.c = Math.round(this.c * 1000) / 1000;
		this.d = Math.round(this.d * 1000) / 1000;
		this.tx = Math.round(this.tx * 10) / 10;
		this.ty = Math.round(this.ty * 10) / 10;
	}
	,__transformX: function(pos) {
		return pos.x * this.a + pos.y * this.c + this.tx;
	}
	,__transformY: function(pos) {
		return pos.x * this.b + pos.y * this.d + this.ty;
	}
	,__translateTransformed: function(pos) {
		this.tx = pos.x * this.a + pos.y * this.c + this.tx;
		this.ty = pos.x * this.b + pos.y * this.d + this.ty;
	}
	,__class__: openfl.geom.Matrix
};
openfl.Lib = function() { };
$hxClasses["openfl.Lib"] = openfl.Lib;
openfl.Lib.__name__ = ["openfl","Lib"];
openfl.Lib.application = null;
openfl.Lib["as"] = function(v,c) {
	if(js.Boot.__instanceof(v,c)) return v; else return null;
};
openfl.Lib.attach = function(name) {
	return new openfl.display.MovieClip();
};
openfl.Lib.embed = $hx_exports.openfl.embed = function(elementName,width,height,background,assetsPrefix) {
	lime.system.System.embed(elementName,width,height,background,assetsPrefix);
};
openfl.Lib.getTimer = function() {
	return lime.system.System.getTimer();
};
openfl.Lib.getURL = function(request,target) {
	if(target == null) target = "_blank";
	window.open(request.url,target);
};
openfl.Lib.notImplemented = function(api) {
	if(!openfl.Lib.__sentWarnings.exists(api)) {
		openfl.Lib.__sentWarnings.set(api,true);
		null;
	}
};
openfl.Lib.preventDefaultTouchMove = function() {
	window.document.addEventListener("touchmove",function(evt) {
		evt.preventDefault();
	},false);
};
openfl.Lib.trace = function(arg) {
	haxe.Log.trace(arg,{ fileName : "Lib.hx", lineNumber : 146, className : "openfl.Lib", methodName : "trace"});
};
openfl.Memory = function() { };
$hxClasses["openfl.Memory"] = openfl.Memory;
openfl.Memory.__name__ = ["openfl","Memory"];
openfl.Memory.gcRef = null;
openfl.Memory.len = null;
openfl.Memory._setPositionTemporarily = function(position,action) {
	var oldPosition = openfl.Memory.gcRef.position;
	openfl.Memory.gcRef.position = position;
	var value = action();
	openfl.Memory.gcRef.position = oldPosition;
	return value;
};
openfl.Memory.getByte = function(addr) {
	return openfl.Memory.gcRef.data.getInt8(addr);
};
openfl.Memory.getDouble = function(addr) {
	return openfl.Memory._setPositionTemporarily(addr,function() {
		return openfl.Memory.gcRef.readDouble();
	});
};
openfl.Memory.getFloat = function(addr) {
	return openfl.Memory._setPositionTemporarily(addr,function() {
		return openfl.Memory.gcRef.readFloat();
	});
};
openfl.Memory.getI32 = function(addr) {
	return openfl.Memory._setPositionTemporarily(addr,function() {
		return openfl.Memory.gcRef.readInt();
	});
};
openfl.Memory.getUI16 = function(addr) {
	return openfl.Memory._setPositionTemporarily(addr,function() {
		return openfl.Memory.gcRef.readUnsignedShort();
	});
};
openfl.Memory.select = function(inBytes) {
	openfl.Memory.gcRef = inBytes;
	if(inBytes != null) openfl.Memory.len = inBytes.length; else openfl.Memory.len = 0;
};
openfl.Memory.setByte = function(addr,v) {
	openfl.Memory.gcRef.data.setUint8(addr,v);
};
openfl.Memory.setDouble = function(addr,v) {
	openfl.Memory._setPositionTemporarily(addr,function() {
		openfl.Memory.gcRef.writeDouble(v);
	});
};
openfl.Memory.setFloat = function(addr,v) {
	openfl.Memory._setPositionTemporarily(addr,function() {
		openfl.Memory.gcRef.writeFloat(v);
	});
};
openfl.Memory.setI16 = function(addr,v) {
	openfl.Memory._setPositionTemporarily(addr,function() {
		openfl.Memory.gcRef.writeUnsignedShort(v);
	});
};
openfl.Memory.setI32 = function(addr,v) {
	openfl.Memory._setPositionTemporarily(addr,function() {
		openfl.Memory.gcRef.writeInt(v);
	});
};
openfl._Vector = {};
openfl._Vector.Vector_Impl_ = function() { };
$hxClasses["openfl._Vector.Vector_Impl_"] = openfl._Vector.Vector_Impl_;
openfl._Vector.Vector_Impl_.__name__ = ["openfl","_Vector","Vector_Impl_"];
openfl._Vector.Vector_Impl_.__properties__ = {set_fixed:"set_fixed",get_fixed:"get_fixed",set_length:"set_length",get_length:"get_length"}
openfl._Vector.Vector_Impl_._new = function(length,fixed) {
	if(fixed == null) fixed = false;
	if(length == null) length = 0;
	var this1;
	this1 = new openfl.VectorData();
	var this2;
	this2 = new Array(length);
	this1.data = this2;
	this1.length = length;
	this1.fixed = fixed;
	return this1;
};
openfl._Vector.Vector_Impl_.concat = function(this1,a) {
	var vectorData = new openfl.VectorData();
	if(a != null) vectorData.length = this1.length + a.length; else vectorData.length = this1.length;
	vectorData.fixed = false;
	var this2;
	this2 = new Array(vectorData.length);
	vectorData.data = this2;
	haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,vectorData.data,0,this1.length);
	if(a != null) haxe.ds._Vector.Vector_Impl_.blit(a.data,0,vectorData.data,this1.length,a.length);
	return vectorData;
};
openfl._Vector.Vector_Impl_.copy = function(this1) {
	var vectorData = new openfl.VectorData();
	vectorData.length = this1.length;
	vectorData.fixed = this1.fixed;
	var this2;
	this2 = new Array(this1.length);
	vectorData.data = this2;
	haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,vectorData.data,0,this1.length);
	return vectorData;
};
openfl._Vector.Vector_Impl_.iterator = function(this1) {
	return new openfl.VectorDataIterator(this1);
};
openfl._Vector.Vector_Impl_.join = function(this1,sep) {
	var output = "";
	var _g1 = 0;
	var _g = this1.length;
	while(_g1 < _g) {
		var i = _g1++;
		if(i > 0) output += sep;
		output += Std.string(this1.data[i]);
	}
	return output;
};
openfl._Vector.Vector_Impl_.pop = function(this1) {
	var value = null;
	if(!this1.fixed) {
		if(this1.length > 0) {
			this1.length--;
			value = this1.data[this1.length];
		}
	}
	return value;
};
openfl._Vector.Vector_Impl_.push = function(this1,x) {
	if(!this1.fixed) {
		this1.length++;
		if(this1.data.length < this1.length) {
			var data;
			var this2;
			this2 = new Array(this1.data.length + 10);
			data = this2;
			haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,data,0,this1.data.length);
			this1.data = data;
		}
		this1.data[this1.length - 1] = x;
	}
	return this1.length;
};
openfl._Vector.Vector_Impl_.reverse = function(this1) {
	var data;
	var this2;
	this2 = new Array(this1.length);
	data = this2;
	var _g1 = 0;
	var _g = this1.length;
	while(_g1 < _g) {
		var i = _g1++;
		data[this1.length - 1 - i] = this1.data[i];
	}
	this1.data = data;
};
openfl._Vector.Vector_Impl_.shift = function(this1) {
	if(!this1.fixed && this1.length > 0) {
		this1.length--;
		var value = this1.data[0];
		haxe.ds._Vector.Vector_Impl_.blit(this1.data,1,this1.data,0,this1.length);
		return value;
	}
	return null;
};
openfl._Vector.Vector_Impl_.unshift = function(this1,x) {
	if(!this1.fixed) {
		this1.length++;
		if(this1.data.length < this1.length) {
			var data;
			var this2;
			this2 = new Array(this1.length + 10);
			data = this2;
			haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,data,1,this1.data.length);
			this1.data = data;
		} else haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,this1.data,1,this1.length - 1);
		this1.data[0] = x;
	}
};
openfl._Vector.Vector_Impl_.slice = function(this1,pos,end) {
	if(end == null) end = 0;
	if(pos == null) pos = 0;
	if(pos < 0) pos += this1.length;
	if(end <= 0) end += this1.length;
	if(end > this1.length) end = this1.length;
	var length = end - pos;
	if(length <= 0 || length > this1.length) length = this1.length;
	var vectorData = new openfl.VectorData();
	vectorData.length = end - pos;
	vectorData.fixed = true;
	var this2;
	this2 = new Array(length);
	vectorData.data = this2;
	haxe.ds._Vector.Vector_Impl_.blit(this1.data,pos,vectorData.data,0,length);
	return vectorData;
};
openfl._Vector.Vector_Impl_.sort = function(this1,f) {
	var array = haxe.ds._Vector.Vector_Impl_.toArray(this1.data);
	array.sort(f);
	var vec;
	var this2;
	this2 = new Array(array.length);
	vec = this2;
	var _g1 = 0;
	var _g = array.length;
	while(_g1 < _g) {
		var i = _g1++;
		vec[i] = array[i];
	}
	this1.data = vec;
};
openfl._Vector.Vector_Impl_.splice = function(this1,pos,len) {
	if(pos < 0) pos += this1.length;
	if(pos + len > this1.length) len = this1.length - pos;
	if(len < 0) len = 0;
	var vectorData = new openfl.VectorData();
	vectorData.length = len;
	vectorData.fixed = false;
	var this2;
	this2 = new Array(len);
	vectorData.data = this2;
	haxe.ds._Vector.Vector_Impl_.blit(this1.data,pos,vectorData.data,0,len);
	if(len > 0) {
		this1.length -= len;
		haxe.ds._Vector.Vector_Impl_.blit(this1.data,pos + len,this1.data,pos,this1.length - pos);
	}
	return vectorData;
};
openfl._Vector.Vector_Impl_.toString = function(this1) {
	return haxe.ds._Vector.Vector_Impl_.toArray(this1.data).toString();
};
openfl._Vector.Vector_Impl_.indexOf = function(this1,x,from) {
	if(from == null) from = 0;
	var value = -1;
	var _g1 = from;
	var _g = this1.length;
	while(_g1 < _g) {
		var i = _g1++;
		if(this1.data[i] == x) {
			value = i;
			break;
		}
	}
	return value;
};
openfl._Vector.Vector_Impl_.lastIndexOf = function(this1,x,from) {
	if(from == null) from = 0;
	var value = -1;
	var i = this1.length - 1;
	while(i >= from) {
		if(this1.data[i] == x) {
			value = i;
			break;
		}
		i--;
	}
	return value;
};
openfl._Vector.Vector_Impl_.ofArray = function(a) {
	var vectorData = new openfl.VectorData();
	vectorData.length = a.length;
	vectorData.fixed = true;
	var vec;
	var this1;
	this1 = new Array(a.length);
	vec = this1;
	var _g1 = 0;
	var _g = a.length;
	while(_g1 < _g) {
		var i = _g1++;
		vec[i] = a[i];
	}
	vectorData.data = vec;
	return vectorData;
};
openfl._Vector.Vector_Impl_.convert = function(v) {
	return v;
};
openfl._Vector.Vector_Impl_.get = function(this1,index) {
	return this1.data[index];
};
openfl._Vector.Vector_Impl_.set = function(this1,key,value) {
	if(!this1.fixed) {
		if(key >= this1.length) this1.length = key + 1;
		if(this1.data.length < this1.length) {
			var data;
			var this2;
			this2 = new Array(this1.data.length + 10);
			data = this2;
			haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,data,0,this1.data.length);
			this1.data = data;
		}
	}
	return this1.data[key] = value;
};
openfl._Vector.Vector_Impl_.fromArray = function(value) {
	var vectorData = new openfl.VectorData();
	vectorData.length = value.length;
	vectorData.fixed = true;
	var vec;
	var this1;
	this1 = new Array(value.length);
	vec = this1;
	var _g1 = 0;
	var _g = value.length;
	while(_g1 < _g) {
		var i = _g1++;
		vec[i] = value[i];
	}
	vectorData.data = vec;
	return vectorData;
};
openfl._Vector.Vector_Impl_.toArray = function(this1) {
	var value = new Array();
	var _g1 = 0;
	var _g = this1.data.length;
	while(_g1 < _g) {
		var i = _g1++;
		value.push(this1.data[i]);
	}
	return value;
};
openfl._Vector.Vector_Impl_.fromHaxeVector = function(value) {
	var vectorData = new openfl.VectorData();
	vectorData.length = value.length;
	vectorData.fixed = true;
	vectorData.data = value;
	return vectorData;
};
openfl._Vector.Vector_Impl_.toHaxeVector = function(this1) {
	return this1.data;
};
openfl._Vector.Vector_Impl_.fromVectorData = function(value) {
	return value;
};
openfl._Vector.Vector_Impl_.toVectorData = function(this1) {
	return this1;
};
openfl._Vector.Vector_Impl_.get_length = function(this1) {
	return this1.length;
};
openfl._Vector.Vector_Impl_.set_length = function(this1,value) {
	if(!this1.fixed) {
		if(value > this1.length) {
			var data;
			var this2;
			this2 = new Array(value);
			data = this2;
			haxe.ds._Vector.Vector_Impl_.blit(this1.data,0,data,0,Std["int"](Math.min(this1.data.length,value)));
			this1.data = data;
		}
		this1.length = value;
	}
	return value;
};
openfl._Vector.Vector_Impl_.get_fixed = function(this1) {
	return this1.fixed;
};
openfl._Vector.Vector_Impl_.set_fixed = function(this1,value) {
	return this1.fixed = value;
};
openfl.VectorData = function() {
	this.length = 0;
};
$hxClasses["openfl.VectorData"] = openfl.VectorData;
openfl.VectorData.__name__ = ["openfl","VectorData"];
openfl.VectorData.prototype = {
	__class__: openfl.VectorData
};
openfl.VectorDataIterator = function(data) {
	this.index = 0;
	this.vectorData = data;
};
$hxClasses["openfl.VectorDataIterator"] = openfl.VectorDataIterator;
openfl.VectorDataIterator.__name__ = ["openfl","VectorDataIterator"];
openfl.VectorDataIterator.prototype = {
	hasNext: function() {
		return this.index < this.vectorData.length;
	}
	,next: function() {
		var index = this.index++;
		return this.vectorData.data[index];
	}
	,__class__: openfl.VectorDataIterator
};
openfl._internal = {};
openfl._internal.renderer = {};
openfl._internal.renderer.AbstractRenderer = function(width,height) {
	this.width = width;
	this.height = height;
};
$hxClasses["openfl._internal.renderer.AbstractRenderer"] = openfl._internal.renderer.AbstractRenderer;
openfl._internal.renderer.AbstractRenderer.__name__ = ["openfl","_internal","renderer","AbstractRenderer"];
openfl._internal.renderer.AbstractRenderer.prototype = {
	render: function(stage) {
	}
	,renderShape: function(shape) {
	}
	,resize: function(width,height) {
	}
	,__class__: openfl._internal.renderer.AbstractRenderer
};
openfl._internal.renderer.RenderSession = function() {
};
$hxClasses["openfl._internal.renderer.RenderSession"] = openfl._internal.renderer.RenderSession;
openfl._internal.renderer.RenderSession.__name__ = ["openfl","_internal","renderer","RenderSession"];
openfl._internal.renderer.RenderSession.prototype = {
	__class__: openfl._internal.renderer.RenderSession
};
openfl._internal.renderer.canvas = {};
openfl._internal.renderer.canvas.CanvasBitmap = function() { };
$hxClasses["openfl._internal.renderer.canvas.CanvasBitmap"] = openfl._internal.renderer.canvas.CanvasBitmap;
openfl._internal.renderer.canvas.CanvasBitmap.__name__ = ["openfl","_internal","renderer","canvas","CanvasBitmap"];
openfl._internal.renderer.canvas.CanvasBitmap.render = function(bitmap,renderSession) {
	if(!bitmap.__renderable || bitmap.__worldAlpha <= 0) return;
	var context = renderSession.context;
	if(bitmap.bitmapData != null && bitmap.bitmapData.__isValid) {
		if(bitmap.__mask != null) renderSession.maskManager.pushMask(bitmap.__mask);
		bitmap.bitmapData.__sync();
		context.globalAlpha = bitmap.__worldAlpha;
		var transform = bitmap.__worldTransform;
		var scrollRect = bitmap.get_scrollRect();
		if(renderSession.roundPixels) context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx | 0,transform.ty | 0); else context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx,transform.ty);
		if(!bitmap.smoothing) {
			context.mozImageSmoothingEnabled = false;
			context.webkitImageSmoothingEnabled = false;
			context.imageSmoothingEnabled = false;
		}
		if(scrollRect == null) context.drawImage(bitmap.bitmapData.__image.get_src(),0,0); else context.drawImage(bitmap.bitmapData.__image.get_src(),scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height,scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height);
		if(!bitmap.smoothing) {
			context.mozImageSmoothingEnabled = true;
			context.webkitImageSmoothingEnabled = true;
			context.imageSmoothingEnabled = true;
		}
		if(bitmap.__mask != null) renderSession.maskManager.popMask();
	}
};
openfl._internal.renderer.canvas.CanvasGraphics = function() { };
$hxClasses["openfl._internal.renderer.canvas.CanvasGraphics"] = openfl._internal.renderer.canvas.CanvasGraphics;
openfl._internal.renderer.canvas.CanvasGraphics.__name__ = ["openfl","_internal","renderer","canvas","CanvasGraphics"];
openfl._internal.renderer.canvas.CanvasGraphics.bounds = null;
openfl._internal.renderer.canvas.CanvasGraphics.hasFill = null;
openfl._internal.renderer.canvas.CanvasGraphics.hasStroke = null;
openfl._internal.renderer.canvas.CanvasGraphics.inPath = null;
openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix = null;
openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix = null;
openfl._internal.renderer.canvas.CanvasGraphics.positionX = null;
openfl._internal.renderer.canvas.CanvasGraphics.positionY = null;
openfl._internal.renderer.canvas.CanvasGraphics.setFill = null;
openfl._internal.renderer.canvas.CanvasGraphics.context = null;
openfl._internal.renderer.canvas.CanvasGraphics.pattern = null;
openfl._internal.renderer.canvas.CanvasGraphics.beginPath = function() {
	if(!openfl._internal.renderer.canvas.CanvasGraphics.inPath) {
		openfl._internal.renderer.canvas.CanvasGraphics.context.beginPath();
		openfl._internal.renderer.canvas.CanvasGraphics.inPath = true;
	}
};
openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill = function(bitmapFill,bitmapRepeat) {
	if(openfl._internal.renderer.canvas.CanvasGraphics.setFill || bitmapFill == null) return;
	if(openfl._internal.renderer.canvas.CanvasGraphics.pattern == null) openfl._internal.renderer.canvas.CanvasGraphics.pattern = openfl._internal.renderer.canvas.CanvasGraphics.context.createPattern(bitmapFill.__image.get_src(),bitmapRepeat?"repeat":"no-repeat");
	openfl._internal.renderer.canvas.CanvasGraphics.context.fillStyle = openfl._internal.renderer.canvas.CanvasGraphics.pattern;
	openfl._internal.renderer.canvas.CanvasGraphics.setFill = true;
};
openfl._internal.renderer.canvas.CanvasGraphics.closePath = function(closeFill) {
	if(openfl._internal.renderer.canvas.CanvasGraphics.inPath) {
		if(openfl._internal.renderer.canvas.CanvasGraphics.hasFill) {
			openfl._internal.renderer.canvas.CanvasGraphics.context.translate(-openfl._internal.renderer.canvas.CanvasGraphics.bounds.x,-openfl._internal.renderer.canvas.CanvasGraphics.bounds.y);
			if(openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix != null) {
				openfl._internal.renderer.canvas.CanvasGraphics.context.transform(openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.a,openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.b,openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.c,openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.d,openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.tx,openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.ty);
				openfl._internal.renderer.canvas.CanvasGraphics.context.fill();
				openfl._internal.renderer.canvas.CanvasGraphics.context.transform(openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.a,openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.b,openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.c,openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.d,openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.tx,openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.ty);
			} else openfl._internal.renderer.canvas.CanvasGraphics.context.fill();
			openfl._internal.renderer.canvas.CanvasGraphics.context.translate(openfl._internal.renderer.canvas.CanvasGraphics.bounds.x,openfl._internal.renderer.canvas.CanvasGraphics.bounds.y);
		}
		openfl._internal.renderer.canvas.CanvasGraphics.context.closePath();
		if(openfl._internal.renderer.canvas.CanvasGraphics.hasStroke) openfl._internal.renderer.canvas.CanvasGraphics.context.stroke();
	}
	openfl._internal.renderer.canvas.CanvasGraphics.inPath = false;
	if(closeFill) {
		openfl._internal.renderer.canvas.CanvasGraphics.hasFill = false;
		openfl._internal.renderer.canvas.CanvasGraphics.hasStroke = false;
		openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix = null;
		openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix = null;
	}
};
openfl._internal.renderer.canvas.CanvasGraphics.drawRoundRect = function(x,y,width,height,rx,ry) {
	if(ry == -1) ry = rx;
	rx *= 0.5;
	ry *= 0.5;
	if(rx > width / 2) rx = width / 2;
	if(ry > height / 2) ry = height / 2;
	var xe = x + width;
	var ye = y + height;
	var cx1 = -rx + rx * openfl._internal.renderer.canvas.CanvasGraphics.SIN45;
	var cx2 = -rx + rx * openfl._internal.renderer.canvas.CanvasGraphics.TAN22;
	var cy1 = -ry + ry * openfl._internal.renderer.canvas.CanvasGraphics.SIN45;
	var cy2 = -ry + ry * openfl._internal.renderer.canvas.CanvasGraphics.TAN22;
	openfl._internal.renderer.canvas.CanvasGraphics.context.moveTo(xe,ye - ry);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(xe,ye + cy2,xe + cx1,ye + cy1);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(xe + cx2,ye,xe - rx,ye);
	openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x + rx,ye);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(x - cx2,ye,x - cx1,ye + cy1);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(x,ye + cy2,x,ye - ry);
	openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x,y + ry);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(x,y - cy2,x - cx1,y - cy1);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(x - cx2,y,x + rx,y);
	openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(xe - rx,y);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(xe + cx2,y,xe + cx1,y - cy1);
	openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(xe,y - cy2,xe,y + ry);
	openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(xe,ye - ry);
};
openfl._internal.renderer.canvas.CanvasGraphics.render = function(graphics,renderSession) {
	if(graphics.__dirty) {
		openfl._internal.renderer.canvas.CanvasGraphics.bounds = graphics.__bounds;
		openfl._internal.renderer.canvas.CanvasGraphics.hasFill = false;
		openfl._internal.renderer.canvas.CanvasGraphics.hasStroke = false;
		openfl._internal.renderer.canvas.CanvasGraphics.inPath = false;
		openfl._internal.renderer.canvas.CanvasGraphics.positionX = 0;
		openfl._internal.renderer.canvas.CanvasGraphics.positionY = 0;
		if(!graphics.__visible || graphics.__commands.length == 0 || openfl._internal.renderer.canvas.CanvasGraphics.bounds == null || openfl._internal.renderer.canvas.CanvasGraphics.bounds.width == 0 || openfl._internal.renderer.canvas.CanvasGraphics.bounds.height == 0) {
			graphics.__canvas = null;
			graphics.__context = null;
		} else {
			if(graphics.__canvas == null) {
				graphics.__canvas = window.document.createElement("canvas");
				graphics.__context = graphics.__canvas.getContext("2d");
			}
			openfl._internal.renderer.canvas.CanvasGraphics.context = graphics.__context;
			graphics.__canvas.width = Math.ceil(openfl._internal.renderer.canvas.CanvasGraphics.bounds.width);
			graphics.__canvas.height = Math.ceil(openfl._internal.renderer.canvas.CanvasGraphics.bounds.height);
			var offsetX = openfl._internal.renderer.canvas.CanvasGraphics.bounds.x;
			var offsetY = openfl._internal.renderer.canvas.CanvasGraphics.bounds.y;
			var bitmapFill = null;
			var bitmapRepeat = false;
			var _g = 0;
			var _g1 = graphics.__commands;
			try {
				while(_g < _g1.length) {
					var command = _g1[_g];
					++_g;
					switch(command[1]) {
					case 0:
						var smooth = command[5];
						var repeat = command[4];
						var matrix = command[3];
						var bitmap = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.closePath(false);
						if(bitmap != bitmapFill || repeat != bitmapRepeat) {
							bitmapFill = bitmap;
							bitmapRepeat = repeat;
							openfl._internal.renderer.canvas.CanvasGraphics.pattern = null;
							openfl._internal.renderer.canvas.CanvasGraphics.setFill = false;
							bitmap.__sync();
						}
						if(matrix != null) {
							openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix = matrix;
							openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix = new openfl.geom.Matrix(matrix.a,matrix.b,matrix.c,matrix.d,matrix.tx,matrix.ty);
							openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.invert();
						} else {
							openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix = null;
							openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix = null;
						}
						openfl._internal.renderer.canvas.CanvasGraphics.hasFill = true;
						break;
					case 1:
						var alpha = command[3];
						var rgb = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.closePath(false);
						if(alpha == 1) openfl._internal.renderer.canvas.CanvasGraphics.context.fillStyle = "#" + StringTools.hex(rgb,6); else {
							var r = (rgb & 16711680) >>> 16;
							var g = (rgb & 65280) >>> 8;
							var b = rgb & 255;
							openfl._internal.renderer.canvas.CanvasGraphics.context.fillStyle = "rgba(" + r + ", " + g + ", " + b + ", " + alpha + ")";
						}
						bitmapFill = null;
						openfl._internal.renderer.canvas.CanvasGraphics.setFill = true;
						openfl._internal.renderer.canvas.CanvasGraphics.hasFill = true;
						break;
					case 2:
						var y = command[7];
						var x = command[6];
						var cy2 = command[5];
						var cx2 = command[4];
						var cy1 = command[3];
						var cx1 = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.context.bezierCurveTo(cx1 - offsetX,cy1 - offsetY,cx2 - offsetX,cy2 - offsetY,x - offsetX,y - offsetY);
						openfl._internal.renderer.canvas.CanvasGraphics.positionX = x;
						openfl._internal.renderer.canvas.CanvasGraphics.positionY = y;
						break;
					case 3:
						var y1 = command[5];
						var x1 = command[4];
						var cy = command[3];
						var cx = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.context.quadraticCurveTo(cx - offsetX,cy - offsetY,x1 - offsetX,y1 - offsetY);
						openfl._internal.renderer.canvas.CanvasGraphics.positionX = x1;
						openfl._internal.renderer.canvas.CanvasGraphics.positionY = y1;
						break;
					case 4:
						var radius = command[4];
						var y2 = command[3];
						var x2 = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.context.moveTo(x2 - offsetX + radius,y2 - offsetY);
						openfl._internal.renderer.canvas.CanvasGraphics.context.arc(x2 - offsetX,y2 - offsetY,radius,0,Math.PI * 2,true);
						break;
					case 5:
						var height = command[5];
						var width = command[4];
						var y3 = command[3];
						var x3 = command[2];
						x3 -= offsetX;
						y3 -= offsetY;
						var kappa = .5522848;
						var ox = width / 2 * kappa;
						var oy = height / 2 * kappa;
						var xe = x3 + width;
						var ye = y3 + height;
						var xm = x3 + width / 2;
						var ym = y3 + height / 2;
						openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.context.moveTo(x3,ym);
						openfl._internal.renderer.canvas.CanvasGraphics.context.bezierCurveTo(x3,ym - oy,xm - ox,y3,xm,y3);
						openfl._internal.renderer.canvas.CanvasGraphics.context.bezierCurveTo(xm + ox,y3,xe,ym - oy,xe,ym);
						openfl._internal.renderer.canvas.CanvasGraphics.context.bezierCurveTo(xe,ym + oy,xm + ox,ye,xm,ye);
						openfl._internal.renderer.canvas.CanvasGraphics.context.bezierCurveTo(xm - ox,ye,x3,ym + oy,x3,ym);
						break;
					case 6:
						var height1 = command[5];
						var width1 = command[4];
						var y4 = command[3];
						var x4 = command[2];
						var optimizationUsed = false;
						if(bitmapFill != null) {
							var st = 0;
							var sr = 0;
							var sb = 0;
							var sl = 0;
							var canOptimizeMatrix = true;
							if(openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix != null) {
								if(openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.b != 0 || openfl._internal.renderer.canvas.CanvasGraphics.pendingMatrix.c != 0) canOptimizeMatrix = false; else {
									var stl = openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.transformPoint(new openfl.geom.Point(x4,y4));
									var sbr = openfl._internal.renderer.canvas.CanvasGraphics.inversePendingMatrix.transformPoint(new openfl.geom.Point(x4 + width1,y4 + height1));
									st = stl.y;
									sl = stl.x;
									sb = sbr.y;
									sr = sbr.x;
								}
							} else {
								st = y4;
								sl = x4;
								sb = y4 + height1;
								sr = x4 + width1;
							}
							if(canOptimizeMatrix && st >= 0 && sl >= 0 && sr <= bitmapFill.width && sb <= bitmapFill.height) {
								optimizationUsed = true;
								openfl._internal.renderer.canvas.CanvasGraphics.context.drawImage(bitmapFill.__image.get_src(),sl,st,sr - sl,sb - st,x4 - offsetX,y4 - offsetY,width1,height1);
							}
						}
						if(!optimizationUsed) {
							openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
							openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
							openfl._internal.renderer.canvas.CanvasGraphics.context.rect(x4 - offsetX,y4 - offsetY,width1,height1);
						}
						break;
					case 7:
						var ry = command[7];
						var rx = command[6];
						var height2 = command[5];
						var width2 = command[4];
						var y5 = command[3];
						var x5 = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.drawRoundRect(x5 - offsetX,y5 - offsetY,width2,height2,rx,ry);
						break;
					case 8:
						var count = command[6];
						var flags = command[5];
						var smooth1 = command[4];
						var tileData = command[3];
						var sheet = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.closePath(false);
						var useScale = (flags & 1) > 0;
						var useRotation = (flags & 2) > 0;
						var useTransform = (flags & 16) > 0;
						var useRGB = (flags & 4) > 0;
						var useAlpha = (flags & 8) > 0;
						var useRect = (flags & 32) > 0;
						var useOrigin = (flags & 64) > 0;
						var useBlendAdd = (flags & 65536) > 0;
						if(useTransform) {
							useScale = false;
							useRotation = false;
						}
						var scaleIndex = 0;
						var rotationIndex = 0;
						var rgbIndex = 0;
						var alphaIndex = 0;
						var transformIndex = 0;
						var numValues = 3;
						if(useRect) if(useOrigin) numValues = 8; else numValues = 6;
						if(useScale) {
							scaleIndex = numValues;
							numValues++;
						}
						if(useRotation) {
							rotationIndex = numValues;
							numValues++;
						}
						if(useTransform) {
							transformIndex = numValues;
							numValues += 4;
						}
						if(useRGB) {
							rgbIndex = numValues;
							numValues += 3;
						}
						if(useAlpha) {
							alphaIndex = numValues;
							numValues++;
						}
						var totalCount = tileData.length;
						if(count >= 0 && totalCount > count) totalCount = count;
						var itemCount = totalCount / numValues | 0;
						var index = 0;
						var rect = null;
						var center = null;
						var previousTileID = -1;
						var surface;
						sheet.__bitmap.__sync();
						surface = sheet.__bitmap.__image.get_src();
						if(useBlendAdd) openfl._internal.renderer.canvas.CanvasGraphics.context.globalCompositeOperation = "lighter";
						while(index < totalCount) {
							var tileID;
							if(!useRect) tileID = tileData[index + 2] | 0; else tileID = -1;
							if(!useRect && tileID != previousTileID) {
								rect = sheet.__tileRects[tileID];
								center = sheet.__centerPoints[tileID];
								previousTileID = tileID;
							} else if(useRect) {
								rect = sheet.__rectTile;
								rect.setTo(tileData[index + 2],tileData[index + 3],tileData[index + 4],tileData[index + 5]);
								center = sheet.__point;
								if(useOrigin) {
									center.x = tileData[index + 6];
									center.y = tileData[index + 7];
								} else {
									center.x = 0;
									center.y = 0;
								}
							}
							if(rect != null && rect.width > 0 && rect.height > 0 && center != null) {
								openfl._internal.renderer.canvas.CanvasGraphics.context.save();
								openfl._internal.renderer.canvas.CanvasGraphics.context.translate(tileData[index],tileData[index + 1]);
								if(useRotation) openfl._internal.renderer.canvas.CanvasGraphics.context.rotate(tileData[index + rotationIndex]);
								var scale = 1.0;
								if(useScale) scale = tileData[index + scaleIndex];
								if(useTransform) openfl._internal.renderer.canvas.CanvasGraphics.context.transform(tileData[index + transformIndex],tileData[index + transformIndex + 1],tileData[index + transformIndex + 2],tileData[index + transformIndex + 3],0,0);
								if(useAlpha) openfl._internal.renderer.canvas.CanvasGraphics.context.globalAlpha = tileData[index + alphaIndex];
								openfl._internal.renderer.canvas.CanvasGraphics.context.drawImage(surface,rect.x,rect.y,rect.width,rect.height,-center.x * scale,-center.y * scale,rect.width * scale,rect.height * scale);
								openfl._internal.renderer.canvas.CanvasGraphics.context.restore();
							}
							index += numValues;
						}
						if(useBlendAdd) openfl._internal.renderer.canvas.CanvasGraphics.context.globalCompositeOperation = "source-over";
						break;
					case 10:
						openfl._internal.renderer.canvas.CanvasGraphics.closePath(true);
						break;
					case 11:
						var miterLimit = command[9];
						var joints = command[8];
						var caps = command[7];
						var scaleMode = command[6];
						var pixelHinting = command[5];
						var alpha1 = command[4];
						var color = command[3];
						var thickness = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.closePath(false);
						if(thickness == null) openfl._internal.renderer.canvas.CanvasGraphics.hasStroke = false; else {
							openfl._internal.renderer.canvas.CanvasGraphics.context.lineWidth = thickness;
							if(joints == null) openfl._internal.renderer.canvas.CanvasGraphics.context.lineJoin = "round"; else openfl._internal.renderer.canvas.CanvasGraphics.context.lineJoin = Std.string(joints).toLowerCase();
							if(caps == null) openfl._internal.renderer.canvas.CanvasGraphics.context.lineCap = "round"; else switch(caps[1]) {
							case 0:
								openfl._internal.renderer.canvas.CanvasGraphics.context.lineCap = "butt";
								break;
							default:
								openfl._internal.renderer.canvas.CanvasGraphics.context.lineCap = Std.string(caps).toLowerCase();
							}
							if(miterLimit == null) openfl._internal.renderer.canvas.CanvasGraphics.context.miterLimit = 3; else openfl._internal.renderer.canvas.CanvasGraphics.context.miterLimit = miterLimit;
							if(alpha1 == 1 || alpha1 == null) if(color == null) openfl._internal.renderer.canvas.CanvasGraphics.context.strokeStyle = "#000000"; else openfl._internal.renderer.canvas.CanvasGraphics.context.strokeStyle = "#" + StringTools.hex(color & 16777215,6); else {
								var r1 = (color & 16711680) >>> 16;
								var g1 = (color & 65280) >>> 8;
								var b1 = color & 255;
								if(color == null) openfl._internal.renderer.canvas.CanvasGraphics.context.strokeStyle = "#000000"; else openfl._internal.renderer.canvas.CanvasGraphics.context.strokeStyle = "rgba(" + r1 + ", " + g1 + ", " + b1 + ", " + alpha1 + ")";
							}
							openfl._internal.renderer.canvas.CanvasGraphics.hasStroke = true;
						}
						break;
					case 12:
						var y6 = command[3];
						var x6 = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.beginPatternFill(bitmapFill,bitmapRepeat);
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x6 - offsetX,y6 - offsetY);
						openfl._internal.renderer.canvas.CanvasGraphics.positionX = x6;
						openfl._internal.renderer.canvas.CanvasGraphics.positionY = y6;
						break;
					case 13:
						var y7 = command[3];
						var x7 = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.beginPath();
						openfl._internal.renderer.canvas.CanvasGraphics.context.moveTo(x7 - offsetX,y7 - offsetY);
						openfl._internal.renderer.canvas.CanvasGraphics.positionX = x7;
						openfl._internal.renderer.canvas.CanvasGraphics.positionY = y7;
						break;
					case 9:
						var culling = command[5];
						var uvtData = command[4];
						var indices = command[3];
						var vertices = command[2];
						openfl._internal.renderer.canvas.CanvasGraphics.closePath(false);
						var v = vertices;
						var ind = indices;
						var uvt = uvtData;
						var pattern = null;
						var colorFill = bitmapFill == null;
						if(colorFill && uvt != null) throw "__break__";
						if(!colorFill) {
							if(uvtData == null) {
								var this1;
								this1 = new openfl.VectorData();
								var this2;
								this2 = new Array(0);
								this1.data = this2;
								this1.length = 0;
								this1.fixed = false;
								uvtData = this1;
								var _g3 = 0;
								var _g2 = v.length / 2 | 0;
								while(_g3 < _g2) {
									var i = _g3++;
									if(!uvtData.fixed) {
										uvtData.length++;
										if(uvtData.data.length < uvtData.length) {
											var data;
											var this3;
											this3 = new Array(uvtData.data.length + 10);
											data = this3;
											haxe.ds._Vector.Vector_Impl_.blit(uvtData.data,0,data,0,uvtData.data.length);
											uvtData.data = data;
										}
										uvtData.data[uvtData.length - 1] = v.data[i * 2] / bitmapFill.width;
									}
									uvtData.length;
									if(!uvtData.fixed) {
										uvtData.length++;
										if(uvtData.data.length < uvtData.length) {
											var data1;
											var this4;
											this4 = new Array(uvtData.data.length + 10);
											data1 = this4;
											haxe.ds._Vector.Vector_Impl_.blit(uvtData.data,0,data1,0,uvtData.data.length);
											uvtData.data = data1;
										}
										uvtData.data[uvtData.length - 1] = v.data[i * 2 + 1] / bitmapFill.height;
									}
									uvtData.length;
								}
							}
							var skipT = uvtData.length != v.length;
							var normalizedUvt = openfl._internal.renderer.canvas.CanvasGraphics.normalizeUvt(uvtData,skipT);
							var maxUvt = normalizedUvt.max;
							uvt = normalizedUvt.uvt;
							if(maxUvt > 1) pattern = openfl._internal.renderer.canvas.CanvasGraphics.createTempPatternCanvas(bitmapFill,bitmapRepeat,openfl._internal.renderer.canvas.CanvasGraphics.bounds.width,openfl._internal.renderer.canvas.CanvasGraphics.bounds.height); else pattern = openfl._internal.renderer.canvas.CanvasGraphics.createTempPatternCanvas(bitmapFill,bitmapRepeat,bitmapFill.width,bitmapFill.height);
						}
						var i1 = 0;
						var l = ind.length;
						var a;
						var b2;
						var c;
						var iax;
						var iay;
						var ibx;
						var iby;
						var icx;
						var icy;
						var x11;
						var y11;
						var x21;
						var y21;
						var x31;
						var y31;
						var uvx1;
						var uvy1;
						var uvx2;
						var uvy2;
						var uvx3;
						var uvy3;
						var denom;
						var t1;
						var t2;
						var t3;
						var t4;
						var dx;
						var dy;
						while(i1 < l) {
							a = i1;
							b2 = i1 + 1;
							c = i1 + 2;
							iax = ind.data[a] * 2;
							iay = ind.data[a] * 2 + 1;
							ibx = ind.data[b2] * 2;
							iby = ind.data[b2] * 2 + 1;
							icx = ind.data[c] * 2;
							icy = ind.data[c] * 2 + 1;
							x11 = v.data[iax];
							y11 = v.data[iay];
							x21 = v.data[ibx];
							y21 = v.data[iby];
							x31 = v.data[icx];
							y31 = v.data[icy];
							switch(culling[1]) {
							case 2:
								if(!((x21 - x11) * (y31 - y11) - (y21 - y11) * (x31 - x11) < 0)) {
									i1 += 3;
									continue;
								}
								break;
							case 0:
								if((x21 - x11) * (y31 - y11) - (y21 - y11) * (x31 - x11) < 0) {
									i1 += 3;
									continue;
								}
								break;
							default:
							}
							if(colorFill) {
								openfl._internal.renderer.canvas.CanvasGraphics.context.beginPath();
								openfl._internal.renderer.canvas.CanvasGraphics.context.moveTo(x11,y11);
								openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x21,y21);
								openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x31,y31);
								openfl._internal.renderer.canvas.CanvasGraphics.context.closePath();
								openfl._internal.renderer.canvas.CanvasGraphics.context.fill();
								i1 += 3;
								continue;
							}
							openfl._internal.renderer.canvas.CanvasGraphics.context.save();
							openfl._internal.renderer.canvas.CanvasGraphics.context.beginPath();
							openfl._internal.renderer.canvas.CanvasGraphics.context.moveTo(x11,y11);
							openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x21,y21);
							openfl._internal.renderer.canvas.CanvasGraphics.context.lineTo(x31,y31);
							openfl._internal.renderer.canvas.CanvasGraphics.context.closePath();
							openfl._internal.renderer.canvas.CanvasGraphics.context.clip();
							uvx1 = uvt.data[iax] * pattern.width;
							uvx2 = uvt.data[ibx] * pattern.width;
							uvx3 = uvt.data[icx] * pattern.width;
							uvy1 = uvt.data[iay] * pattern.height;
							uvy2 = uvt.data[iby] * pattern.height;
							uvy3 = uvt.data[icy] * pattern.height;
							denom = uvx1 * (uvy3 - uvy2) - uvx2 * uvy3 + uvx3 * uvy2 + (uvx2 - uvx3) * uvy1;
							if(denom == 0) {
								i1 += 3;
								continue;
							}
							t1 = -(uvy1 * (x31 - x21) - uvy2 * x31 + uvy3 * x21 + (uvy2 - uvy3) * x11) / denom;
							t2 = (uvy2 * y31 + uvy1 * (y21 - y31) - uvy3 * y21 + (uvy3 - uvy2) * y11) / denom;
							t3 = (uvx1 * (x31 - x21) - uvx2 * x31 + uvx3 * x21 + (uvx2 - uvx3) * x11) / denom;
							t4 = -(uvx2 * y31 + uvx1 * (y21 - y31) - uvx3 * y21 + (uvx3 - uvx2) * y11) / denom;
							dx = (uvx1 * (uvy3 * x21 - uvy2 * x31) + uvy1 * (uvx2 * x31 - uvx3 * x21) + (uvx3 * uvy2 - uvx2 * uvy3) * x11) / denom;
							dy = (uvx1 * (uvy3 * y21 - uvy2 * y31) + uvy1 * (uvx2 * y31 - uvx3 * y21) + (uvx3 * uvy2 - uvx2 * uvy3) * y11) / denom;
							openfl._internal.renderer.canvas.CanvasGraphics.context.transform(t1,t2,t3,t4,dx,dy);
							openfl._internal.renderer.canvas.CanvasGraphics.context.drawImage(pattern,0,0);
							openfl._internal.renderer.canvas.CanvasGraphics.context.restore();
							i1 += 3;
						}
						break;
					}
				}
			} catch( e ) { if( e != "__break__" ) throw e; }
		}
		graphics.__dirty = false;
		openfl._internal.renderer.canvas.CanvasGraphics.closePath(false);
	}
};
openfl._internal.renderer.canvas.CanvasGraphics.renderMask = function(graphics,renderSession) {
	if(graphics.__commands.length != 0) {
		var context = renderSession.context;
		var positionX = 0.0;
		var positionY = 0.0;
		var offsetX = 0;
		var offsetY = 0;
		var _g = 0;
		var _g1 = graphics.__commands;
		while(_g < _g1.length) {
			var command = _g1[_g];
			++_g;
			switch(command[1]) {
			case 2:
				var y = command[7];
				var x = command[6];
				var cy2 = command[5];
				var cy1 = command[4];
				var cx2 = command[3];
				var cx1 = command[2];
				context.bezierCurveTo(cx1 - offsetX,cy1 - offsetY,cx2 - offsetX,cy2 - offsetY,x - offsetX,y - offsetY);
				positionX = x;
				positionY = y;
				break;
			case 3:
				var y1 = command[5];
				var x1 = command[4];
				var cy = command[3];
				var cx = command[2];
				context.quadraticCurveTo(cx - offsetX,cy - offsetY,x1 - offsetX,y1 - offsetY);
				positionX = x1;
				positionY = y1;
				break;
			case 4:
				var radius = command[4];
				var y2 = command[3];
				var x2 = command[2];
				context.arc(x2 - offsetX,y2 - offsetY,radius,0,Math.PI * 2,true);
				break;
			case 5:
				var height = command[5];
				var width = command[4];
				var y3 = command[3];
				var x3 = command[2];
				x3 -= offsetX;
				y3 -= offsetY;
				var kappa = .5522848;
				var ox = width / 2 * kappa;
				var oy = height / 2 * kappa;
				var xe = x3 + width;
				var ye = y3 + height;
				var xm = x3 + width / 2;
				var ym = y3 + height / 2;
				context.moveTo(x3,ym);
				context.bezierCurveTo(x3,ym - oy,xm - ox,y3,xm,y3);
				context.bezierCurveTo(xm + ox,y3,xe,ym - oy,xe,ym);
				context.bezierCurveTo(xe,ym + oy,xm + ox,ye,xm,ye);
				context.bezierCurveTo(xm - ox,ye,x3,ym + oy,x3,ym);
				break;
			case 6:
				var height1 = command[5];
				var width1 = command[4];
				var y4 = command[3];
				var x4 = command[2];
				context.rect(x4 - offsetX,y4 - offsetY,width1,height1);
				break;
			case 7:
				var ry = command[7];
				var rx = command[6];
				var height2 = command[5];
				var width2 = command[4];
				var y5 = command[3];
				var x5 = command[2];
				openfl._internal.renderer.canvas.CanvasGraphics.drawRoundRect(x5 - offsetX,y5 - offsetY,width2,height2,rx,ry);
				break;
			case 12:
				var y6 = command[3];
				var x6 = command[2];
				context.lineTo(x6 - offsetX,y6 - offsetY);
				positionX = x6;
				positionY = y6;
				break;
			case 13:
				var y7 = command[3];
				var x7 = command[2];
				context.moveTo(x7 - offsetX,y7 - offsetY);
				positionX = x7;
				positionY = y7;
				break;
			default:
			}
		}
	}
};
openfl._internal.renderer.canvas.CanvasGraphics.createTempPatternCanvas = function(bitmap,repeat,width,height) {
	var canvas = window.document.createElement("canvas");
	var context = canvas.getContext("2d");
	canvas.width = Math.ceil(width);
	canvas.height = Math.ceil(height);
	context.fillStyle = context.createPattern(bitmap.__image.get_src(),repeat?"repeat":"no-repeat");
	context.beginPath();
	context.moveTo(0,0);
	context.lineTo(0,height);
	context.lineTo(width,height);
	context.lineTo(width,0);
	context.lineTo(0,0);
	context.closePath();
	context.fill();
	return canvas;
};
openfl._internal.renderer.canvas.CanvasGraphics.isCCW = function(x1,y1,x2,y2,x3,y3) {
	return (x2 - x1) * (y3 - y1) - (y2 - y1) * (x3 - x1) < 0;
};
openfl._internal.renderer.canvas.CanvasGraphics.normalizeUvt = function(uvt,skipT) {
	if(skipT == null) skipT = false;
	var max = Math.NEGATIVE_INFINITY;
	var tmp = Math.NEGATIVE_INFINITY;
	var len = uvt.length;
	var _g1 = 1;
	var _g = len + 1;
	while(_g1 < _g) {
		var t = _g1++;
		if(skipT && t % 3 == 0) continue;
		tmp = uvt.data[t - 1];
		if(max < tmp) max = tmp;
	}
	var result;
	var this1;
	this1 = new openfl.VectorData();
	var this2;
	this2 = new Array(0);
	this1.data = this2;
	this1.length = 0;
	this1.fixed = false;
	result = this1;
	var _g11 = 1;
	var _g2 = len + 1;
	while(_g11 < _g2) {
		var t1 = _g11++;
		if(skipT && t1 % 3 == 0) continue;
		if(!result.fixed) {
			result.length++;
			if(result.data.length < result.length) {
				var data;
				var this3;
				this3 = new Array(result.data.length + 10);
				data = this3;
				haxe.ds._Vector.Vector_Impl_.blit(result.data,0,data,0,result.data.length);
				result.data = data;
			}
			result.data[result.length - 1] = uvt.data[t1 - 1] / max;
		}
		result.length;
	}
	return { max : max, uvt : result};
};
openfl._internal.renderer.canvas.CanvasRenderer = function(width,height,context) {
	openfl._internal.renderer.AbstractRenderer.call(this,width,height);
	this.context = context;
	this.renderSession = new openfl._internal.renderer.RenderSession();
	this.renderSession.context = context;
	this.renderSession.roundPixels = true;
	this.renderSession.renderer = this;
	this.renderSession.maskManager = new openfl._internal.renderer.canvas.MaskManager(this.renderSession);
};
$hxClasses["openfl._internal.renderer.canvas.CanvasRenderer"] = openfl._internal.renderer.canvas.CanvasRenderer;
openfl._internal.renderer.canvas.CanvasRenderer.__name__ = ["openfl","_internal","renderer","canvas","CanvasRenderer"];
openfl._internal.renderer.canvas.CanvasRenderer.__super__ = openfl._internal.renderer.AbstractRenderer;
openfl._internal.renderer.canvas.CanvasRenderer.prototype = $extend(openfl._internal.renderer.AbstractRenderer.prototype,{
	render: function(stage) {
		this.context.setTransform(1,0,0,1,0,0);
		this.context.globalAlpha = 1;
		if(!stage.__transparent && stage.__clearBeforeRender) {
			this.context.fillStyle = stage.__colorString;
			this.context.fillRect(0,0,stage.stageWidth,stage.stageHeight);
		} else if(stage.__transparent && stage.__clearBeforeRender) this.context.clearRect(0,0,stage.stageWidth,stage.stageHeight);
		stage.__renderCanvas(this.renderSession);
	}
	,__class__: openfl._internal.renderer.canvas.CanvasRenderer
});
openfl._internal.renderer.canvas.CanvasShape = function() { };
$hxClasses["openfl._internal.renderer.canvas.CanvasShape"] = openfl._internal.renderer.canvas.CanvasShape;
openfl._internal.renderer.canvas.CanvasShape.__name__ = ["openfl","_internal","renderer","canvas","CanvasShape"];
openfl._internal.renderer.canvas.CanvasShape.render = function(shape,renderSession) {
	if(!shape.__renderable || shape.__worldAlpha <= 0) return;
	var graphics = shape.__graphics;
	if(graphics != null) {
		openfl._internal.renderer.canvas.CanvasGraphics.render(graphics,renderSession);
		if(graphics.__canvas != null) {
			if(shape.__mask != null) renderSession.maskManager.pushMask(shape.__mask);
			var context = renderSession.context;
			var scrollRect = shape.get_scrollRect();
			context.globalAlpha = shape.__worldAlpha;
			var transform = shape.__worldTransform;
			if(renderSession.roundPixels) context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx | 0,transform.ty | 0); else context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx,transform.ty);
			if(scrollRect == null) context.drawImage(graphics.__canvas,graphics.__bounds.x,graphics.__bounds.y); else context.drawImage(graphics.__canvas,scrollRect.x - graphics.__bounds.x,scrollRect.y - graphics.__bounds.y,scrollRect.width,scrollRect.height,graphics.__bounds.x + scrollRect.x,graphics.__bounds.y + scrollRect.y,scrollRect.width,scrollRect.height);
			if(shape.__mask != null) renderSession.maskManager.popMask();
		}
	}
};
openfl._internal.renderer.canvas.CanvasTextField = function() { };
$hxClasses["openfl._internal.renderer.canvas.CanvasTextField"] = openfl._internal.renderer.canvas.CanvasTextField;
openfl._internal.renderer.canvas.CanvasTextField.__name__ = ["openfl","_internal","renderer","canvas","CanvasTextField"];
openfl._internal.renderer.canvas.CanvasTextField.context = null;
openfl._internal.renderer.canvas.CanvasTextField.render = function(textField,renderSession) {
	if(!textField.__renderable || textField.__worldAlpha <= 0) return;
	openfl._internal.renderer.canvas.CanvasTextField.update(textField);
	if(textField.__canvas != null) {
		var context = renderSession.context;
		context.globalAlpha = textField.__worldAlpha;
		var transform = textField.__worldTransform;
		var scrollRect = textField.get_scrollRect();
		if(renderSession.roundPixels) context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx | 0,transform.ty | 0); else context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx,transform.ty);
		if(scrollRect == null) context.drawImage(textField.__canvas,0,0); else context.drawImage(textField.__canvas,scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height,scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height);
	}
};
openfl._internal.renderer.canvas.CanvasTextField.renderText = function(textField,text,format,offsetX) {
	openfl._internal.renderer.canvas.CanvasTextField.context.font = textField.__getFont(format);
	openfl._internal.renderer.canvas.CanvasTextField.context.textBaseline = "top";
	openfl._internal.renderer.canvas.CanvasTextField.context.fillStyle = "#" + StringTools.hex(format.color,6);
	var lines = text.split("\n");
	var yOffset = 0;
	var _g = 0;
	while(_g < lines.length) {
		var line = lines[_g];
		++_g;
		var _g1 = format.align;
		switch(_g1[1]) {
		case 3:
			openfl._internal.renderer.canvas.CanvasTextField.context.textAlign = "center";
			openfl._internal.renderer.canvas.CanvasTextField.context.fillText(line,textField.__width / 2,2 + yOffset,textField.__width - 4);
			break;
		case 1:
			openfl._internal.renderer.canvas.CanvasTextField.context.textAlign = "end";
			openfl._internal.renderer.canvas.CanvasTextField.context.fillText(line,textField.__width - 2,2 + yOffset,textField.__width - 4);
			break;
		default:
			openfl._internal.renderer.canvas.CanvasTextField.context.textAlign = "start";
			openfl._internal.renderer.canvas.CanvasTextField.context.fillText(line,2 + offsetX,2 + yOffset,textField.__width - 4);
		}
		yOffset += textField.get_textHeight();
	}
};
openfl._internal.renderer.canvas.CanvasTextField.update = function(textField) {
	if(textField.__dirty) {
		if((textField.__text == null || textField.__text == "") && !textField.background && !textField.border || (textField.get_width() <= 0 || textField.get_height() <= 0) && textField.autoSize != openfl.text.TextFieldAutoSize.LEFT) {
			textField.__canvas = null;
			textField.__context = null;
			textField.__dirty = false;
		} else {
			if(textField.__canvas == null) {
				textField.__canvas = window.document.createElement("canvas");
				textField.__context = textField.__canvas.getContext("2d");
			}
			openfl._internal.renderer.canvas.CanvasTextField.context = textField.__context;
			if(textField.__text != null && textField.__text != "") {
				var text = textField.get_text();
				if(textField.displayAsPassword) {
					var length = text.length;
					var mask = "";
					var _g = 0;
					while(_g < length) {
						var i = _g++;
						mask += "*";
					}
					text = mask;
				}
				var measurements = textField.__measureText();
				var textWidth = 0.0;
				var _g1 = 0;
				while(_g1 < measurements.length) {
					var measurement = measurements[_g1];
					++_g1;
					textWidth += measurement;
				}
				if(textField.autoSize == openfl.text.TextFieldAutoSize.LEFT) textField.__width = textWidth + 4;
				textField.__canvas.width = Math.ceil(textField.__width);
				textField.__canvas.height = Math.ceil(textField.__height);
				if(textField.border || textField.background) {
					textField.__context.rect(0.5,0.5,textField.__width - 1,textField.__height - 1);
					if(textField.background) {
						openfl._internal.renderer.canvas.CanvasTextField.context.fillStyle = "#" + StringTools.hex(textField.backgroundColor,6);
						openfl._internal.renderer.canvas.CanvasTextField.context.fill();
					}
					if(textField.border) {
						openfl._internal.renderer.canvas.CanvasTextField.context.lineWidth = 1;
						openfl._internal.renderer.canvas.CanvasTextField.context.strokeStyle = "#" + StringTools.hex(textField.borderColor,6);
						openfl._internal.renderer.canvas.CanvasTextField.context.stroke();
					}
				}
				if(textField.__hasFocus && textField.__selectionStart == textField.__cursorPosition && textField.__showCursor) {
					var cursorOffset = textField.__getTextWidth(text.substring(0,textField.__cursorPosition));
					openfl._internal.renderer.canvas.CanvasTextField.context.fillStyle = "#" + StringTools.hex(textField.__textFormat.color,6);
					openfl._internal.renderer.canvas.CanvasTextField.context.fillRect(cursorOffset,5,1,textField.__textFormat.size - 5);
				} else if(textField.__hasFocus && Math.abs(textField.__selectionStart - textField.__cursorPosition) > 0 && !textField.__isKeyDown) {
					var lowPos = Std["int"](Math.min(textField.__selectionStart,textField.__cursorPosition));
					var highPos = Std["int"](Math.max(textField.__selectionStart,textField.__cursorPosition));
					var xPos = textField.__getTextWidth(text.substring(0,lowPos));
					var widthPos = textField.__getTextWidth(text.substring(lowPos,highPos));
					openfl._internal.renderer.canvas.CanvasTextField.context.fillStyle = "#" + StringTools.hex(textField.__textFormat.color,6);
					openfl._internal.renderer.canvas.CanvasTextField.context.fillRect(xPos,5,widthPos,textField.__textFormat.size - 5);
				}
				if(textField.__ranges == null) openfl._internal.renderer.canvas.CanvasTextField.renderText(textField,text,textField.__textFormat,0); else {
					var currentIndex = 0;
					var range;
					var offsetX = 0.0;
					var _g11 = 0;
					var _g2 = textField.__ranges.length;
					while(_g11 < _g2) {
						var i1 = _g11++;
						range = textField.__ranges[i1];
						openfl._internal.renderer.canvas.CanvasTextField.renderText(textField,text.substring(range.start,range.end),range.format,offsetX);
						offsetX += measurements[i1];
					}
				}
			} else {
				if(textField.autoSize == openfl.text.TextFieldAutoSize.LEFT) textField.__width = 4;
				textField.__canvas.width = Math.ceil(textField.__width);
				textField.__canvas.height = Math.ceil(textField.__height);
				if(textField.border || textField.background) {
					if(textField.border) openfl._internal.renderer.canvas.CanvasTextField.context.rect(0.5,0.5,textField.__width - 1,textField.__height - 1); else textField.__context.rect(0,0,textField.__width,textField.__height);
					if(textField.background) {
						openfl._internal.renderer.canvas.CanvasTextField.context.fillStyle = "#" + StringTools.hex(textField.backgroundColor,6);
						openfl._internal.renderer.canvas.CanvasTextField.context.fill();
					}
					if(textField.border) {
						openfl._internal.renderer.canvas.CanvasTextField.context.lineWidth = 1;
						openfl._internal.renderer.canvas.CanvasTextField.context.lineCap = "square";
						openfl._internal.renderer.canvas.CanvasTextField.context.strokeStyle = "#" + StringTools.hex(textField.borderColor,6);
						openfl._internal.renderer.canvas.CanvasTextField.context.stroke();
					}
				}
			}
			textField.__dirty = false;
			return true;
		}
	}
	return false;
};
openfl._internal.renderer.canvas.MaskManager = function(renderSession) {
	this.renderSession = renderSession;
};
$hxClasses["openfl._internal.renderer.canvas.MaskManager"] = openfl._internal.renderer.canvas.MaskManager;
openfl._internal.renderer.canvas.MaskManager.__name__ = ["openfl","_internal","renderer","canvas","MaskManager"];
openfl._internal.renderer.canvas.MaskManager.prototype = {
	pushMask: function(mask) {
		var context = this.renderSession.context;
		context.save();
		var transform = mask.__getTransform();
		context.setTransform(transform.a,transform.c,transform.b,transform.d,transform.tx,transform.ty);
		context.beginPath();
		mask.__renderMask(this.renderSession);
		context.clip();
	}
	,pushRect: function(rect,transform) {
		var context = this.renderSession.context;
		context.save();
		context.setTransform(transform.a,transform.c,transform.b,transform.d,transform.tx,transform.ty);
		context.beginPath();
		context.rect(rect.x,rect.y,rect.width,rect.height);
		context.clip();
	}
	,popMask: function() {
		this.renderSession.context.restore();
	}
	,__class__: openfl._internal.renderer.canvas.MaskManager
};
openfl._internal.renderer.dom = {};
openfl._internal.renderer.dom.DOMBitmap = function() { };
$hxClasses["openfl._internal.renderer.dom.DOMBitmap"] = openfl._internal.renderer.dom.DOMBitmap;
openfl._internal.renderer.dom.DOMBitmap.__name__ = ["openfl","_internal","renderer","dom","DOMBitmap"];
openfl._internal.renderer.dom.DOMBitmap.render = function(bitmap,renderSession) {
	if(bitmap.stage != null && bitmap.__worldVisible && bitmap.__renderable && bitmap.bitmapData != null && bitmap.bitmapData.__isValid) {
		if(bitmap.bitmapData.__image.buffer.__srcImage != null) openfl._internal.renderer.dom.DOMBitmap.renderImage(bitmap,renderSession); else openfl._internal.renderer.dom.DOMBitmap.renderCanvas(bitmap,renderSession);
	} else {
		if(bitmap.__image != null) {
			renderSession.element.removeChild(bitmap.__image);
			bitmap.__image = null;
			bitmap.__style = null;
		}
		if(bitmap.__canvas != null) {
			renderSession.element.removeChild(bitmap.__canvas);
			bitmap.__canvas = null;
			bitmap.__style = null;
		}
	}
};
openfl._internal.renderer.dom.DOMBitmap.renderCanvas = function(bitmap,renderSession) {
	if(bitmap.__image != null) {
		renderSession.element.removeChild(bitmap.__image);
		bitmap.__image = null;
	}
	if(bitmap.__canvas == null) {
		bitmap.__canvas = window.document.createElement("canvas");
		bitmap.__context = bitmap.__canvas.getContext("2d");
		if(!bitmap.smoothing) {
			bitmap.__context.mozImageSmoothingEnabled = false;
			bitmap.__context.webkitImageSmoothingEnabled = false;
			bitmap.__context.imageSmoothingEnabled = false;
		}
		openfl._internal.renderer.dom.DOMRenderer.initializeElement(bitmap,bitmap.__canvas,renderSession);
	}
	bitmap.bitmapData.__sync();
	bitmap.__canvas.width = bitmap.bitmapData.width;
	bitmap.__canvas.height = bitmap.bitmapData.height;
	bitmap.__context.globalAlpha = bitmap.__worldAlpha;
	bitmap.__context.drawImage(bitmap.bitmapData.__image.buffer.__srcCanvas,0,0);
	openfl._internal.renderer.dom.DOMRenderer.applyStyle(bitmap,renderSession,true,false,true);
};
openfl._internal.renderer.dom.DOMBitmap.renderImage = function(bitmap,renderSession) {
	if(bitmap.__canvas != null) {
		renderSession.element.removeChild(bitmap.__canvas);
		bitmap.__canvas = null;
	}
	if(bitmap.__image == null) {
		bitmap.__image = window.document.createElement("img");
		bitmap.__image.src = bitmap.bitmapData.__image.buffer.__srcImage.src;
		openfl._internal.renderer.dom.DOMRenderer.initializeElement(bitmap,bitmap.__image,renderSession);
	}
	openfl._internal.renderer.dom.DOMRenderer.applyStyle(bitmap,renderSession,true,true,true);
};
openfl._internal.renderer.dom.DOMRenderer = function(width,height,element) {
	openfl._internal.renderer.AbstractRenderer.call(this,width,height);
	this.element = element;
	this.renderSession = new openfl._internal.renderer.RenderSession();
	this.renderSession.element = element;
	this.renderSession.roundPixels = true;
	var prefix = (function () {
		  var styles = window.getComputedStyle(document.documentElement, ''),
			pre = (Array.prototype.slice
			  .call(styles)
			  .join('') 
			  .match(/-(moz|webkit|ms)-/) || (styles.OLink === '' && ['', 'o'])
			)[1],
			dom = ('WebKit|Moz|MS|O').match(new RegExp('(' + pre + ')', 'i'))[1];
		  return {
			dom: dom,
			lowercase: pre,
			css: '-' + pre + '-',
			js: pre[0].toUpperCase() + pre.substr(1)
		  };
		})();
	this.renderSession.vendorPrefix = prefix.lowercase;
	if(prefix.lowercase == "webkit") this.renderSession.transformProperty = "-webkit-transform"; else this.renderSession.transformProperty = "transform";
	if(prefix.lowercase == "webkit") this.renderSession.transformOriginProperty = "-webkit-transform-origin"; else this.renderSession.transformOriginProperty = "transform-origin";
	this.renderSession.renderer = this;
};
$hxClasses["openfl._internal.renderer.dom.DOMRenderer"] = openfl._internal.renderer.dom.DOMRenderer;
openfl._internal.renderer.dom.DOMRenderer.__name__ = ["openfl","_internal","renderer","dom","DOMRenderer"];
openfl._internal.renderer.dom.DOMRenderer.applyStyle = function(displayObject,renderSession,setTransform,setAlpha,setClip) {
	var style = displayObject.__style;
	if(setTransform && displayObject.__worldTransformChanged) style.setProperty(renderSession.transformProperty,displayObject.__worldTransform.to3DString(renderSession.roundPixels),null);
	if(displayObject.__worldZ != ++renderSession.z) {
		displayObject.__worldZ = renderSession.z;
		style.setProperty("z-index",displayObject.__worldZ == null?"null":"" + displayObject.__worldZ,null);
	}
	if(setAlpha && displayObject.__worldAlphaChanged) {
		if(displayObject.__worldAlpha < 1) style.setProperty("opacity",displayObject.__worldAlpha == null?"null":"" + displayObject.__worldAlpha,null); else style.removeProperty("opacity");
	}
	if(setClip && displayObject.__worldClipChanged) {
		if(displayObject.__worldClip == null) style.removeProperty("clip"); else {
			var clip = displayObject.__worldClip.transform(displayObject.__worldTransform.clone().invert());
			style.setProperty("clip","rect(" + clip.y + "px, " + clip.get_right() + "px, " + clip.get_bottom() + "px, " + clip.x + "px)",null);
		}
	}
};
openfl._internal.renderer.dom.DOMRenderer.initializeElement = function(displayObject,element,renderSession) {
	var style = displayObject.__style = element.style;
	style.setProperty("position","absolute",null);
	style.setProperty("top","0",null);
	style.setProperty("left","0",null);
	style.setProperty(renderSession.transformOriginProperty,"0 0 0",null);
	renderSession.element.appendChild(element);
	displayObject.__worldAlphaChanged = true;
	displayObject.__worldClipChanged = true;
	displayObject.__worldTransformChanged = true;
	displayObject.__worldVisibleChanged = true;
	displayObject.__worldZ = -1;
};
openfl._internal.renderer.dom.DOMRenderer.__super__ = openfl._internal.renderer.AbstractRenderer;
openfl._internal.renderer.dom.DOMRenderer.prototype = $extend(openfl._internal.renderer.AbstractRenderer.prototype,{
	render: function(stage) {
		this.element.style.background = stage.__colorString;
		this.renderSession.z = 1;
		stage.__renderDOM(this.renderSession);
	}
	,__class__: openfl._internal.renderer.dom.DOMRenderer
});
openfl._internal.renderer.dom.DOMShape = function() { };
$hxClasses["openfl._internal.renderer.dom.DOMShape"] = openfl._internal.renderer.dom.DOMShape;
openfl._internal.renderer.dom.DOMShape.__name__ = ["openfl","_internal","renderer","dom","DOMShape"];
openfl._internal.renderer.dom.DOMShape.render = function(shape,renderSession) {
	var graphics = shape.__graphics;
	if(shape.stage != null && shape.__worldVisible && shape.__renderable && graphics != null) {
		if(graphics.__dirty || shape.__worldAlphaChanged || shape.__canvas == null && graphics.__canvas != null) {
			openfl._internal.renderer.canvas.CanvasGraphics.render(graphics,renderSession);
			if(graphics.__canvas != null) {
				if(shape.__canvas == null) {
					shape.__canvas = window.document.createElement("canvas");
					shape.__context = shape.__canvas.getContext("2d");
					openfl._internal.renderer.dom.DOMRenderer.initializeElement(shape,shape.__canvas,renderSession);
				}
				shape.__canvas.width = graphics.__canvas.width;
				shape.__canvas.height = graphics.__canvas.height;
				shape.__context.globalAlpha = shape.__worldAlpha;
				shape.__context.drawImage(graphics.__canvas,0,0);
			} else if(shape.__canvas != null) {
				renderSession.element.removeChild(shape.__canvas);
				shape.__canvas = null;
				shape.__style = null;
			}
		}
		if(shape.__canvas != null) {
			if(shape.__worldTransformChanged || graphics.__transformDirty) {
				graphics.__transformDirty = false;
				var transform = new openfl.geom.Matrix();
				transform.translate(graphics.__bounds.x,graphics.__bounds.y);
				transform = transform.mult(shape.__worldTransform);
				shape.__style.setProperty(renderSession.transformProperty,renderSession.roundPixels?"matrix3d(" + transform.a + ", " + transform.b + ", " + "0, 0, " + transform.c + ", " + transform.d + ", " + "0, 0, 0, 0, 1, 0, " + (transform.tx | 0) + ", " + (transform.ty | 0) + ", 0, 1)":"matrix3d(" + transform.a + ", " + transform.b + ", " + "0, 0, " + transform.c + ", " + transform.d + ", " + "0, 0, 0, 0, 1, 0, " + transform.tx + ", " + transform.ty + ", 0, 1)",null);
			}
			openfl._internal.renderer.dom.DOMRenderer.applyStyle(shape,renderSession,false,false,true);
		}
	} else if(shape.__canvas != null) {
		renderSession.element.removeChild(shape.__canvas);
		shape.__canvas = null;
		shape.__style = null;
	}
};
openfl._internal.renderer.dom.DOMTextField = function() { };
$hxClasses["openfl._internal.renderer.dom.DOMTextField"] = openfl._internal.renderer.dom.DOMTextField;
openfl._internal.renderer.dom.DOMTextField.__name__ = ["openfl","_internal","renderer","dom","DOMTextField"];
openfl._internal.renderer.dom.DOMTextField.render = function(textField,renderSession) {
	if(textField.stage != null && textField.__worldVisible && textField.__renderable) {
		if(textField.__dirty || textField.__div == null) {
			if(textField.__text != "" || textField.background || textField.border) {
				if(textField.__div == null) {
					textField.__div = window.document.createElement("div");
					openfl._internal.renderer.dom.DOMRenderer.initializeElement(textField,textField.__div,renderSession);
					textField.__style.setProperty("cursor","inherit",null);
				}
				var style = textField.__style;
				textField.__div.innerHTML = textField.__text;
				if(textField.background) style.setProperty("background-color","#" + StringTools.hex(textField.backgroundColor,6),null); else style.removeProperty("background-color");
				if(textField.border) style.setProperty("border","solid 1px #" + StringTools.hex(textField.borderColor,6),null); else style.removeProperty("border");
				style.setProperty("font",textField.__getFont(textField.__textFormat),null);
				style.setProperty("color","#" + StringTools.hex(textField.__textFormat.color,6),null);
				if(textField.autoSize != openfl.text.TextFieldAutoSize.NONE) style.setProperty("width","auto",null); else style.setProperty("width",textField.__width + "px",null);
				style.setProperty("height",textField.__height + "px",null);
				var _g = textField.__textFormat.align;
				switch(_g[1]) {
				case 3:
					style.setProperty("text-align","center",null);
					break;
				case 1:
					style.setProperty("text-align","right",null);
					break;
				default:
					style.setProperty("text-align","left",null);
				}
				textField.__dirty = false;
			} else if(textField.__div != null) {
				renderSession.element.removeChild(textField.__div);
				textField.__div = null;
			}
		}
		if(textField.__div != null) openfl._internal.renderer.dom.DOMRenderer.applyStyle(textField,renderSession,true,true,false);
	} else if(textField.__div != null) {
		renderSession.element.removeChild(textField.__div);
		textField.__div = null;
		textField.__style = null;
	}
};
openfl._internal.renderer.opengl = {};
openfl._internal.renderer.opengl.GLBitmap = function() { };
$hxClasses["openfl._internal.renderer.opengl.GLBitmap"] = openfl._internal.renderer.opengl.GLBitmap;
openfl._internal.renderer.opengl.GLBitmap.__name__ = ["openfl","_internal","renderer","opengl","GLBitmap"];
openfl._internal.renderer.opengl.GLBitmap.render = function(bitmap,renderSession) {
	if(!bitmap.__renderable || bitmap.__worldAlpha <= 0) return;
	var i;
	var j;
	renderSession.spriteBatch.render(bitmap);
};
openfl._internal.renderer.opengl.GLRenderer = function(width,height,gl,transparent,antialias,preserveDrawingBuffer) {
	if(preserveDrawingBuffer == null) preserveDrawingBuffer = false;
	if(antialias == null) antialias = false;
	if(transparent == null) transparent = false;
	if(height == null) height = 600;
	if(width == null) width = 800;
	openfl._internal.renderer.AbstractRenderer.call(this,width,height);
	this.transparent = transparent;
	this.preserveDrawingBuffer = preserveDrawingBuffer;
	this.width = width;
	this.height = height;
	this.options = { alpha : transparent, antialias : antialias, premultipliedAlpha : transparent, stencil : true, preserveDrawingBuffer : preserveDrawingBuffer};
	this._glContextId = openfl._internal.renderer.opengl.GLRenderer.glContextId++;
	this.gl = gl;
	openfl._internal.renderer.opengl.GLRenderer.glContexts[this._glContextId] = gl;
	if(openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL == null) {
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL = new haxe.ds.EnumValueMap();
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.NORMAL,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.ADD,[gl.SRC_ALPHA,gl.DST_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.MULTIPLY,[gl.DST_COLOR,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.SCREEN,[gl.SRC_ALPHA,gl.ONE]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.ALPHA,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.DARKEN,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.DIFFERENCE,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.ERASE,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.HARDLIGHT,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.INVERT,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.LAYER,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.LIGHTEN,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.OVERLAY,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
		openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.set(openfl.display.BlendMode.SUBTRACT,[gl.ONE,gl.ONE_MINUS_SRC_ALPHA]);
	}
	this.projection = new openfl.geom.Point();
	this.projection.x = this.width / 2;
	this.projection.y = -this.height / 2;
	this.offset = new openfl.geom.Point(0,0);
	this.resize(this.width,this.height);
	this.contextLost = false;
	this.shaderManager = new openfl._internal.renderer.opengl.utils.ShaderManager(gl);
	this.spriteBatch = new openfl._internal.renderer.opengl.utils.SpriteBatch(gl);
	this.maskManager = new openfl._internal.renderer.opengl.utils.MaskManager(gl);
	this.filterManager = new openfl._internal.renderer.opengl.utils.FilterManager(gl,this.transparent);
	this.stencilManager = new openfl._internal.renderer.opengl.utils.StencilManager(gl);
	this.blendModeManager = new openfl._internal.renderer.opengl.utils.BlendModeManager(gl);
	this.renderSession = new openfl._internal.renderer.RenderSession();
	this.renderSession.gl = this.gl;
	this.renderSession.drawCount = 0;
	this.renderSession.shaderManager = this.shaderManager;
	this.renderSession.maskManager = this.maskManager;
	this.renderSession.filterManager = this.filterManager;
	this.renderSession.blendModeManager = this.blendModeManager;
	this.renderSession.spriteBatch = this.spriteBatch;
	this.renderSession.stencilManager = this.stencilManager;
	this.renderSession.renderer = this;
	gl.useProgram(this.shaderManager.defaultShader.program);
	gl.disable(gl.DEPTH_TEST);
	gl.disable(gl.CULL_FACE);
	gl.enable(gl.BLEND);
	gl.colorMask(true,true,true,this.transparent);
};
$hxClasses["openfl._internal.renderer.opengl.GLRenderer"] = openfl._internal.renderer.opengl.GLRenderer;
openfl._internal.renderer.opengl.GLRenderer.__name__ = ["openfl","_internal","renderer","opengl","GLRenderer"];
openfl._internal.renderer.opengl.GLRenderer.__super__ = openfl._internal.renderer.AbstractRenderer;
openfl._internal.renderer.opengl.GLRenderer.prototype = $extend(openfl._internal.renderer.AbstractRenderer.prototype,{
	destroy: function() {
		openfl._internal.renderer.opengl.GLRenderer.glContexts[this._glContextId] = null;
		this.projection = null;
		this.offset = null;
		this.shaderManager.destroy();
		this.spriteBatch.destroy();
		this.maskManager.destroy();
		this.filterManager.destroy();
		this.shaderManager = null;
		this.spriteBatch = null;
		this.maskManager = null;
		this.filterManager = null;
		this.gl = null;
		this.renderSession = null;
	}
	,handleContextLost: function(event) {
		event.preventDefault();
		this.contextLost = true;
	}
	,handleContextRestored: function() {
		var gl = this.gl;
		openfl._internal.renderer.opengl.GLRenderer.glContextId++;
		this.shaderManager.setContext(gl);
		this.spriteBatch.setContext(gl);
		this.maskManager.setContext(gl);
		this.filterManager.setContext(gl);
		this.renderSession.gl = gl;
		gl.disable(gl.DEPTH_TEST);
		gl.disable(gl.CULL_FACE);
		gl.enable(gl.BLEND);
		gl.colorMask(true,true,true,this.transparent);
		gl.viewport(0,0,this.width,this.height);
		this.contextLost = false;
	}
	,render: function(stage) {
		if(this.contextLost) return;
		var gl = this.gl;
		gl.viewport(0,0,this.width,this.height);
		gl.bindFramebuffer(gl.FRAMEBUFFER,null);
		if(this.transparent) gl.clearColor(0,0,0,0); else gl.clearColor(stage.__colorSplit[0] | 0,stage.__colorSplit[1] | 0,stage.__colorSplit[2] | 0,1);
		gl.clear(gl.COLOR_BUFFER_BIT);
		this.renderDisplayObject(stage,this.projection);
	}
	,renderDisplayObject: function(displayObject,projection,buffer) {
		this.renderSession.blendModeManager.setBlendMode(openfl.display.BlendMode.NORMAL);
		this.renderSession.drawCount = 0;
		this.renderSession.currentBlendMode = null;
		this.renderSession.projection = projection;
		this.renderSession.offset = this.offset;
		this.spriteBatch.begin(this.renderSession);
		this.filterManager.begin(this.renderSession,buffer);
		displayObject.__renderGL(this.renderSession);
		this.spriteBatch.end();
	}
	,resize: function(width,height) {
		openfl._internal.renderer.AbstractRenderer.prototype.resize.call(this,width,height);
		this.gl.viewport(0,0,width,height);
		this.projection.x = width / 2;
		this.projection.y = -height / 2;
	}
	,__class__: openfl._internal.renderer.opengl.GLRenderer
});
openfl._internal.renderer.opengl.GLTextField = function() { };
$hxClasses["openfl._internal.renderer.opengl.GLTextField"] = openfl._internal.renderer.opengl.GLTextField;
openfl._internal.renderer.opengl.GLTextField.__name__ = ["openfl","_internal","renderer","opengl","GLTextField"];
openfl._internal.renderer.opengl.GLTextField.render = function(textField,renderSession) {
	if(!textField.__renderable || textField.__worldAlpha <= 0) return;
	var gl = renderSession.gl;
	var changed = openfl._internal.renderer.canvas.CanvasTextField.update(textField);
	if(textField.__texture == null) {
		textField.__texture = gl.createTexture();
		gl.bindTexture(gl.TEXTURE_2D,textField.__texture);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR);
		changed = true;
	}
	if(changed) {
		gl.bindTexture(gl.TEXTURE_2D,textField.__texture);
		gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,gl.RGBA,gl.UNSIGNED_BYTE,textField.__canvas);
		gl.bindTexture(gl.TEXTURE_2D,null);
	}
};
openfl._internal.renderer.opengl.shaders = {};
openfl._internal.renderer.opengl.shaders.AbstractShader = function(gl) {
	this._UID = openfl._internal.renderer.opengl.shaders.AbstractShader.__UID++;
	this.gl = gl;
	this.program = null;
	this.attributes = [];
};
$hxClasses["openfl._internal.renderer.opengl.shaders.AbstractShader"] = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.AbstractShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","AbstractShader"];
openfl._internal.renderer.opengl.shaders.AbstractShader.compileProgram = function(gl,vertexSrc,fragmentSrc) {
	var fragmentShader = openfl._internal.renderer.opengl.shaders.AbstractShader.CompileFragmentShader(gl,fragmentSrc);
	var vertexShader = openfl._internal.renderer.opengl.shaders.AbstractShader.CompileVertexShader(gl,vertexSrc);
	var shaderProgram = gl.createProgram();
	if(fragmentShader != null && vertexShader != null) {
		gl.attachShader(shaderProgram,vertexShader);
		gl.attachShader(shaderProgram,fragmentShader);
		gl.linkProgram(shaderProgram);
		if(gl.getProgramParameter(shaderProgram,gl.LINK_STATUS) == 0) null;
	}
	return shaderProgram;
};
openfl._internal.renderer.opengl.shaders.AbstractShader.CompileVertexShader = function(gl,shaderSrc) {
	return openfl._internal.renderer.opengl.shaders.AbstractShader._CompileShader(gl,shaderSrc,gl.VERTEX_SHADER);
};
openfl._internal.renderer.opengl.shaders.AbstractShader.CompileFragmentShader = function(gl,shaderSrc) {
	return openfl._internal.renderer.opengl.shaders.AbstractShader._CompileShader(gl,shaderSrc,gl.FRAGMENT_SHADER);
};
openfl._internal.renderer.opengl.shaders.AbstractShader._CompileShader = function(gl,shaderSrc,shaderType) {
	var src = shaderSrc.join("\n");
	var shader = gl.createShader(shaderType);
	gl.shaderSource(shader,src);
	gl.compileShader(shader);
	if(gl.getShaderParameter(shader,gl.COMPILE_STATUS) == 0) return null;
	return shader;
};
openfl._internal.renderer.opengl.shaders.AbstractShader.prototype = {
	destroy: function() {
		if(this.program != null) this.gl.deleteProgram(this.program);
		this.uniforms = null;
		this.gl = null;
		this.attributes = null;
	}
	,init: function() {
		var gl = this.gl;
		var program = openfl._internal.renderer.opengl.shaders.AbstractShader.compileProgram(gl,this.vertexSrc,this.fragmentSrc);
		gl.useProgram(program);
		this.program = program;
	}
	,__class__: openfl._internal.renderer.opengl.shaders.AbstractShader
};
openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.fragmentSrc = ["precision mediump float;","varying vec4 vColor;","void main(void) {","   gl_FragColor = vColor;","}"];
	this.vertexSrc = ["attribute vec2 aVertexPosition;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform vec3 tint;","uniform float alpha;","uniform vec3 color;","varying vec4 vColor;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","   vColor = vec4(color * alpha * tint, alpha);","}"];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader"] = openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader;
openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","ComplexPrimitiveShader"];
openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		var gl = this.gl;
		this.projectionVector = gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = gl.getUniformLocation(this.program,"offsetVector");
		this.tintColor = gl.getUniformLocation(this.program,"tint");
		this.color = gl.getUniformLocation(this.program,"color");
		this.aVertexPosition = gl.getAttribLocation(this.program,"aVertexPosition");
		this.attributes = [this.aVertexPosition];
		this.translationMatrix = gl.getUniformLocation(this.program,"translationMatrix");
		this.alpha = gl.getUniformLocation(this.program,"alpha");
	}
	,__class__: openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader
});
openfl._internal.renderer.opengl.shaders.DefaultShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.fragmentSrc = ["precision lowp float;","varying vec2 vTextureCoord;","varying vec4 vColor;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord) * vColor ;","}"];
	this.textureCount = 0;
	this.attributes = [];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.DefaultShader"] = openfl._internal.renderer.opengl.shaders.DefaultShader;
openfl._internal.renderer.opengl.shaders.DefaultShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","DefaultShader"];
openfl._internal.renderer.opengl.shaders.DefaultShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.DefaultShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		if(this.vertexSrc == null) this.vertexSrc = openfl._internal.renderer.opengl.shaders.DefaultShader.defaultVertexSrc;
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		var gl = this.gl;
		this.uSampler = gl.getUniformLocation(this.program,"uSampler");
		this.projectionVector = gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = gl.getUniformLocation(this.program,"offsetVector");
		this.dimensions = gl.getUniformLocation(this.program,"dimensions");
		this.aVertexPosition = gl.getAttribLocation(this.program,"aVertexPosition");
		this.aTextureCoord = gl.getAttribLocation(this.program,"aTextureCoord");
		this.colorAttribute = gl.getAttribLocation(this.program,"aColor");
		if(this.colorAttribute == -1) this.colorAttribute = 2;
		this.attributes = [this.aVertexPosition,this.aTextureCoord,this.colorAttribute];
		if(this.uniforms != null) {
			var $it0 = this.uniforms.keys();
			while( $it0.hasNext() ) {
				var key = $it0.next();
				this.uniforms.get(key).uniformLocation = gl.getUniformLocation(this.program,key);
			}
		}
		this.initUniforms();
	}
	,initSampler2D: function(uniform) {
		if(uniform.value == null || uniform.value.baseTexture == null || uniform.value.baseTexture.hasLoaded == null) return;
		var gl = this.gl;
		gl.activeTexture(Reflect.field(gl,"TEXTURE" + this.textureCount));
		gl.bindTexture(gl.TEXTURE_2D,uniform.value.baseTexture._glTextures[openfl._internal.renderer.opengl.GLRenderer.glContextId]);
		if(uniform.textureData != null) {
			var data = uniform.textureData;
			var magFilter;
			if(data.magFilter != 0) magFilter = data.magFilter; else magFilter = gl.LINEAR;
			var minFilter;
			if(data.minFilter != 0) minFilter = data.minFilter; else minFilter = gl.LINEAR;
			var wrapS;
			if(data.wrapS != 0) wrapS = data.wrapS; else wrapS = gl.CLAMP_TO_EDGE;
			var wrapT;
			if(data.wrapT != 0) wrapT = data.wrapT; else wrapT = gl.CLAMP_TO_EDGE;
			var format;
			if(data.luminance != 0) format = gl.LUMINANCE; else format = gl.RGBA;
			if(data.repeat) {
				wrapS = gl.REPEAT;
				wrapT = gl.REPEAT;
			}
			gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL,data.flip);
			if(data.width != 0) {
				var width;
				if(data.width != 0) width = data.width; else width = 512;
				var height;
				if(data.height != 0) height = data.height; else height = 2;
				var border;
				if(data.border != 0) border = data.border; else border = 0;
				gl.texImage2D(gl.TEXTURE_2D,0,format,width,height,border,format,gl.UNSIGNED_BYTE,null);
			} else gl.texImage2D(gl.TEXTURE_2D,0,format,gl.RGBA,gl.UNSIGNED_BYTE,uniform.value.baseTexture.source);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,magFilter);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,minFilter);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,wrapS);
			gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,wrapT);
		}
		gl.uniform1i(uniform.uniformLocation,this.textureCount);
		uniform._init = true;
		this.textureCount++;
	}
	,initUniforms: function() {
		this.textureCount = 1;
		var gl = this.gl;
		var uniform;
		if(this.uniforms == null) return;
		var $it0 = this.uniforms.keys();
		while( $it0.hasNext() ) {
			var key = $it0.next();
			uniform = this.uniforms.get(key);
			var type = uniform.type;
			if(type == "sampler2D") {
				uniform._init = false;
				if(uniform.value != null) this.initSampler2D(uniform);
			} else if(type == "mat2" || type == "mat3" || type == "mat4") {
				uniform.glMatrix = true;
				uniform.glValueLength = 1;
				if(type == "mat2") uniform.glFunc = $bind(gl,gl.uniformMatrix2fv); else if(type == "mat3") uniform.glFunc = $bind(gl,gl.uniformMatrix3fv); else if(type == "mat4") uniform.glFunc = $bind(gl,gl.uniformMatrix4fv);
			} else {
				uniform.glFunc = Reflect.field(gl,"uniform" + type);
				if(type == "2f" || type == "2i") uniform.glValueLength = 2; else if(type == "3f" || type == "3i") uniform.glValueLength = 3; else if(type == "4f" || type == "4i") uniform.glValueLength = 4; else uniform.glValueLength = 1;
			}
		}
	}
	,syncUniforms: function() {
		this.textureCount = 1;
		var uniform;
		var gl = this.gl;
		if(this.uniforms == null) return;
		var $it0 = this.uniforms.keys();
		while( $it0.hasNext() ) {
			var key = $it0.next();
			uniform = this.uniforms.get(key);
			if(uniform.glValueLength == 1) {
				if(uniform.glMatrix == true) uniform.glFunc.call(gl,uniform.uniformLocation,uniform.transpose,uniform.value); else uniform.glFunc.call(gl,uniform.uniformLocation,uniform.value);
			} else if(uniform.glValueLength == 2) uniform.glFunc.call(gl,uniform.uniformLocation,uniform.value.x,uniform.value.y); else if(uniform.glValueLength == 3) uniform.glFunc.call(gl,uniform.uniformLocation,uniform.value.x,uniform.value.y,uniform.value.z); else if(uniform.glValueLength == 4) uniform.glFunc.call(gl,uniform.uniformLocation,uniform.value.x,uniform.value.y,uniform.value.z,uniform.value.w); else if(uniform.type == "sampler2D") {
				if(uniform._init) {
					gl.activeTexture(Reflect.field(gl,"TEXTURE" + this.textureCount));
					var tex = uniform.value.getTexture();
					gl.bindTexture(gl.TEXTURE_2D,tex);
					gl.uniform1i(uniform.uniformLocation,this.textureCount);
					this.textureCount++;
				} else this.initSampler2D(uniform);
			}
		}
	}
	,__class__: openfl._internal.renderer.opengl.shaders.DefaultShader
});
openfl._internal.renderer.opengl.shaders.DrawTrianglesShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.vertexSrc = ["attribute vec2 aVertexPosition;","attribute vec2 aTextureCoord;","attribute vec4 aColor;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","varying vec2 vPos;","varying vec4 vColor;","void main(void) {","   vec3 v = vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","   vPos = aTextureCoord;","   vColor = aColor;","}"];
	this.fragmentSrc = ["precision mediump float;","uniform sampler2D sampler;","uniform vec3 color;","uniform bool useTexture;","uniform float alpha;","varying vec2 vPos;","varying vec4 vColor;","vec4 tmp;","void main(void) {","   if(useTexture) {","       tmp = texture2D(sampler, vPos);","   } else {","       tmp = vec4(color, 1.);","   }","   float a = tmp.a * vColor.a * alpha;","   gl_FragColor = vec4(vec3((tmp.rgb * vColor.rgb) * a), a);","}"];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.DrawTrianglesShader"] = openfl._internal.renderer.opengl.shaders.DrawTrianglesShader;
openfl._internal.renderer.opengl.shaders.DrawTrianglesShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","DrawTrianglesShader"];
openfl._internal.renderer.opengl.shaders.DrawTrianglesShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.DrawTrianglesShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		this.translationMatrix = this.gl.getUniformLocation(this.program,"translationMatrix");
		this.projectionVector = this.gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = this.gl.getUniformLocation(this.program,"offsetVector");
		this.sampler = this.gl.getUniformLocation(this.program,"sampler");
		this.alpha = this.gl.getUniformLocation(this.program,"alpha");
		this.color = this.gl.getUniformLocation(this.program,"color");
		this.useTexture = this.gl.getUniformLocation(this.program,"useTexture");
		this.aVertexPosition = this.gl.getAttribLocation(this.program,"aVertexPosition");
		this.aTextureCoord = this.gl.getAttribLocation(this.program,"aTextureCoord");
		this.colorAttribute = this.gl.getAttribLocation(this.program,"aColor");
		this.attributes = [this.aVertexPosition,this.aTextureCoord,this.colorAttribute];
	}
	,__class__: openfl._internal.renderer.opengl.shaders.DrawTrianglesShader
});
openfl._internal.renderer.opengl.shaders.FastShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.fragmentSrc = ["precision lowp float;","varying vec2 vTextureCoord;","varying float vColor;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vTextureCoord) * vColor ;","}"];
	this.vertexSrc = ["attribute vec2 aVertexPosition;","attribute vec2 aPositionCoord;","attribute vec2 aScale;","attribute float aRotation;","attribute vec2 aTextureCoord;","attribute float aColor;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform mat3 uMatrix;","varying vec2 vTextureCoord;","varying float vColor;","const vec2 center = vec2(-1.0, 1.0);","void main(void) {","   vec2 v;","   vec2 sv = aVertexPosition * aScale;","   v.x = (sv.x) * cos(aRotation) - (sv.y) * sin(aRotation);","   v.y = (sv.x) * sin(aRotation) + (sv.y) * cos(aRotation);","   v = ( uMatrix * vec3(v + aPositionCoord , 1.0) ).xy ;","   gl_Position = vec4( ( v / projectionVector) + center , 0.0, 1.0);","   vTextureCoord = aTextureCoord;","   vColor = aColor;","}"];
	this.textureCount = 0;
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.FastShader"] = openfl._internal.renderer.opengl.shaders.FastShader;
openfl._internal.renderer.opengl.shaders.FastShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","FastShader"];
openfl._internal.renderer.opengl.shaders.FastShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.FastShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		var gl = this.gl;
		this.uSampler = gl.getUniformLocation(this.program,"uSampler");
		this.projectionVector = gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = gl.getUniformLocation(this.program,"offsetVector");
		this.dimensions = gl.getUniformLocation(this.program,"dimensions");
		this.uMatrix = gl.getUniformLocation(this.program,"uMatrix");
		this.aVertexPosition = gl.getAttribLocation(this.program,"aVertexPosition");
		this.aPositionCoord = gl.getAttribLocation(this.program,"aPositionCoord");
		this.aScale = gl.getAttribLocation(this.program,"aScale");
		this.aRotation = gl.getAttribLocation(this.program,"aRotation");
		this.aTextureCoord = gl.getAttribLocation(this.program,"aTextureCoord");
		this.colorAttribute = gl.getAttribLocation(this.program,"aColor");
		if(this.colorAttribute == -1) this.colorAttribute = 2;
		this.attributes = [this.aVertexPosition,this.aPositionCoord,this.aScale,this.aRotation,this.aTextureCoord,this.colorAttribute];
	}
	,__class__: openfl._internal.renderer.opengl.shaders.FastShader
});
openfl._internal.renderer.opengl.shaders.FillShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.vertexSrc = ["attribute vec2 aVertexPosition;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","}"];
	this.fragmentSrc = ["precision mediump float;","uniform vec3 color;","uniform float alpha;","void main(void) {","   gl_FragColor = vec4((color * alpha), alpha);","}"];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.FillShader"] = openfl._internal.renderer.opengl.shaders.FillShader;
openfl._internal.renderer.opengl.shaders.FillShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","FillShader"];
openfl._internal.renderer.opengl.shaders.FillShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.FillShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		this.translationMatrix = this.gl.getUniformLocation(this.program,"translationMatrix");
		this.projectionVector = this.gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = this.gl.getUniformLocation(this.program,"offsetVector");
		this.color = this.gl.getUniformLocation(this.program,"color");
		this.alpha = this.gl.getUniformLocation(this.program,"alpha");
		this.aVertexPosition = this.gl.getAttribLocation(this.program,"aVertexPosition");
		this.attributes = [this.aVertexPosition];
	}
	,__class__: openfl._internal.renderer.opengl.shaders.FillShader
});
openfl._internal.renderer.opengl.shaders.PatternFillShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.vertexSrc = ["attribute vec2 aVertexPosition;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform mat3 patternMatrix;","varying vec2 vPos;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","   vPos = (patternMatrix * vec3(aVertexPosition, 1)).xy;","}"];
	this.fragmentSrc = ["precision mediump float;","uniform float alpha;","uniform vec2 patternTL;","uniform vec2 patternBR;","uniform sampler2D sampler;","varying vec2 vPos;","void main(void) {","   vec2 pos = mix(patternTL, patternBR, vPos);","   vec4 tcol = texture2D(sampler, pos);","   gl_FragColor = vec4(tcol.rgb * alpha, tcol.a * alpha);","}"];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.PatternFillShader"] = openfl._internal.renderer.opengl.shaders.PatternFillShader;
openfl._internal.renderer.opengl.shaders.PatternFillShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","PatternFillShader"];
openfl._internal.renderer.opengl.shaders.PatternFillShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.PatternFillShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		this.translationMatrix = this.gl.getUniformLocation(this.program,"translationMatrix");
		this.projectionVector = this.gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = this.gl.getUniformLocation(this.program,"offsetVector");
		this.patternMatrix = this.gl.getUniformLocation(this.program,"patternMatrix");
		this.patternTL = this.gl.getUniformLocation(this.program,"patternTL");
		this.patternBR = this.gl.getUniformLocation(this.program,"patternBR");
		this.sampler = this.gl.getUniformLocation(this.program,"sampler");
		this.alpha = this.gl.getUniformLocation(this.program,"alpha");
		this.aVertexPosition = this.gl.getAttribLocation(this.program,"aVertexPosition");
		this.attributes = [this.aVertexPosition];
	}
	,__class__: openfl._internal.renderer.opengl.shaders.PatternFillShader
});
openfl._internal.renderer.opengl.shaders.PrimitiveShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.fragmentSrc = ["precision mediump float;","varying vec4 vColor;","void main(void) {","   gl_FragColor = vColor;","}"];
	this.vertexSrc = ["attribute vec2 aVertexPosition;","attribute vec4 aColor;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","uniform float alpha;","uniform vec3 tint;","varying vec4 vColor;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","   vColor = aColor;","}"];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.PrimitiveShader"] = openfl._internal.renderer.opengl.shaders.PrimitiveShader;
openfl._internal.renderer.opengl.shaders.PrimitiveShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","PrimitiveShader"];
openfl._internal.renderer.opengl.shaders.PrimitiveShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.PrimitiveShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		var gl = this.gl;
		this.projectionVector = gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = gl.getUniformLocation(this.program,"offsetVector");
		this.tintColor = gl.getUniformLocation(this.program,"tint");
		this.aVertexPosition = gl.getAttribLocation(this.program,"aVertexPosition");
		this.colorAttribute = gl.getAttribLocation(this.program,"aColor");
		this.attributes = [this.aVertexPosition,this.colorAttribute];
		this.translationMatrix = gl.getUniformLocation(this.program,"translationMatrix");
		this.alpha = gl.getUniformLocation(this.program,"alpha");
	}
	,__class__: openfl._internal.renderer.opengl.shaders.PrimitiveShader
});
openfl._internal.renderer.opengl.shaders.StripShader = function(gl) {
	openfl._internal.renderer.opengl.shaders.AbstractShader.call(this,gl);
	this.fragmentSrc = ["precision mediump float;","varying vec2 vTextureCoord;","uniform float alpha;","uniform sampler2D uSampler;","void main(void) {","   gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.x, vTextureCoord.y));","}"];
	this.vertexSrc = ["attribute vec2 aVertexPosition;","attribute vec2 aTextureCoord;","uniform mat3 translationMatrix;","uniform vec2 projectionVector;","uniform vec2 offsetVector;","varying vec2 vTextureCoord;","void main(void) {","   vec3 v = translationMatrix * vec3(aVertexPosition , 1.0);","   v -= offsetVector.xyx;","   gl_Position = vec4( v.x / projectionVector.x -1.0, v.y / -projectionVector.y + 1.0 , 0.0, 1.0);","   vTextureCoord = aTextureCoord;","}"];
	this.init();
};
$hxClasses["openfl._internal.renderer.opengl.shaders.StripShader"] = openfl._internal.renderer.opengl.shaders.StripShader;
openfl._internal.renderer.opengl.shaders.StripShader.__name__ = ["openfl","_internal","renderer","opengl","shaders","StripShader"];
openfl._internal.renderer.opengl.shaders.StripShader.__super__ = openfl._internal.renderer.opengl.shaders.AbstractShader;
openfl._internal.renderer.opengl.shaders.StripShader.prototype = $extend(openfl._internal.renderer.opengl.shaders.AbstractShader.prototype,{
	init: function() {
		openfl._internal.renderer.opengl.shaders.AbstractShader.prototype.init.call(this);
		var gl = this.gl;
		this.uSampler = gl.getUniformLocation(this.program,"uSampler");
		this.projectionVector = gl.getUniformLocation(this.program,"projectionVector");
		this.offsetVector = gl.getUniformLocation(this.program,"offsetVector");
		this.colorAttribute = gl.getAttribLocation(this.program,"aColor");
		this.aVertexPosition = gl.getAttribLocation(this.program,"aVertexPosition");
		this.aTextureCoord = gl.getAttribLocation(this.program,"aTextureCoord");
		this.attributes = [this.aVertexPosition,this.aTextureCoord];
		this.translationMatrix = gl.getUniformLocation(this.program,"translationMatrix");
		this.alpha = gl.getUniformLocation(this.program,"alpha");
	}
	,__class__: openfl._internal.renderer.opengl.shaders.StripShader
});
openfl._internal.renderer.opengl.utils = {};
openfl._internal.renderer.opengl.utils.BlendModeManager = function(gl) {
	this.gl = gl;
	this.currentBlendMode = null;
};
$hxClasses["openfl._internal.renderer.opengl.utils.BlendModeManager"] = openfl._internal.renderer.opengl.utils.BlendModeManager;
openfl._internal.renderer.opengl.utils.BlendModeManager.__name__ = ["openfl","_internal","renderer","opengl","utils","BlendModeManager"];
openfl._internal.renderer.opengl.utils.BlendModeManager.prototype = {
	destroy: function() {
		this.gl = null;
	}
	,setBlendMode: function(blendMode) {
		if(blendMode == null) blendMode = openfl.display.BlendMode.NORMAL;
		if(this.currentBlendMode == blendMode) return false;
		this.currentBlendMode = blendMode;
		var blendModeWebGL = openfl._internal.renderer.opengl.GLRenderer.blendModesWebGL.get(this.currentBlendMode);
		this.gl.blendFunc(blendModeWebGL[0],blendModeWebGL[1]);
		return true;
	}
	,__class__: openfl._internal.renderer.opengl.utils.BlendModeManager
};
openfl._internal.renderer.opengl.utils.DrawPath = function() {
	this.type = openfl._internal.renderer.opengl.utils.GraphicType.Polygon;
	this.points = [];
	this.isRemovable = true;
	this.fillIndex = 0;
	this.line = new openfl._internal.renderer.opengl.utils.LineStyle();
	this.fill = openfl._internal.renderer.opengl.utils.FillType.None;
};
$hxClasses["openfl._internal.renderer.opengl.utils.DrawPath"] = openfl._internal.renderer.opengl.utils.DrawPath;
openfl._internal.renderer.opengl.utils.DrawPath.__name__ = ["openfl","_internal","renderer","opengl","utils","DrawPath"];
openfl._internal.renderer.opengl.utils.DrawPath.getStack = function(graphics,gl) {
	return openfl._internal.renderer.opengl.utils.PathBuiler.build(graphics,gl);
};
openfl._internal.renderer.opengl.utils.DrawPath.prototype = {
	update: function(line,fill,fillIndex) {
		this.updateLine(line);
		this.fill = fill;
		this.fillIndex = fillIndex;
	}
	,updateLine: function(line) {
		this.line.width = line.width;
		this.line.color = line.color & 16777215;
		if(line.alpha == null) this.line.alpha = 1; else this.line.alpha = line.alpha;
		if(line.scaleMode == null) this.line.scaleMode = openfl.display.LineScaleMode.NORMAL; else this.line.scaleMode = line.scaleMode;
		if(line.caps == null) this.line.caps = openfl.display.CapsStyle.ROUND; else this.line.caps = line.caps;
		if(line.joints == null) this.line.joints = openfl.display.JointStyle.ROUND; else this.line.joints = line.joints;
		this.line.miterLimit = line.miterLimit;
	}
	,__class__: openfl._internal.renderer.opengl.utils.DrawPath
};
openfl._internal.renderer.opengl.utils.PathBuiler = function() { };
$hxClasses["openfl._internal.renderer.opengl.utils.PathBuiler"] = openfl._internal.renderer.opengl.utils.PathBuiler;
openfl._internal.renderer.opengl.utils.PathBuiler.__name__ = ["openfl","_internal","renderer","opengl","utils","PathBuiler"];
openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = null;
openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths = null;
openfl._internal.renderer.opengl.utils.PathBuiler.__line = null;
openfl._internal.renderer.opengl.utils.PathBuiler.__fill = null;
openfl._internal.renderer.opengl.utils.PathBuiler.closePath = function() {
	var l = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length;
	if(l <= 0) return;
	if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type == openfl._internal.renderer.opengl.utils.GraphicType.Polygon && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.fill != openfl._internal.renderer.opengl.utils.FillType.None) {
		var sx = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points[0];
		var sy = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points[1];
		var ex = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points[l - 2];
		var ey = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points[l - 1];
		if(!(sx == ex && sy == ey)) {
			openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.push(sx);
			openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.push(sy);
		}
	}
};
openfl._internal.renderer.opengl.utils.PathBuiler.endFill = function() {
	openfl._internal.renderer.opengl.utils.PathBuiler.__fill = openfl._internal.renderer.opengl.utils.FillType.None;
	openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex++;
};
openfl._internal.renderer.opengl.utils.PathBuiler.moveTo = function(x,y) {
	if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
	openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
	openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
	openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Polygon;
	openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.push(x);
	openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.push(y);
	openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
};
openfl._internal.renderer.opengl.utils.PathBuiler.graphicDataPop = function() {
	if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
};
openfl._internal.renderer.opengl.utils.PathBuiler.build = function(graphics,gl) {
	var glStack = null;
	var bounds = graphics.__bounds;
	openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths = new Array();
	openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
	openfl._internal.renderer.opengl.utils.PathBuiler.__line = new openfl._internal.renderer.opengl.utils.LineStyle();
	openfl._internal.renderer.opengl.utils.PathBuiler.__fill = openfl._internal.renderer.opengl.utils.FillType.None;
	openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex = 0;
	glStack = graphics.__glStack[openfl._internal.renderer.opengl.GLRenderer.glContextId];
	if(glStack == null) glStack = graphics.__glStack[openfl._internal.renderer.opengl.GLRenderer.glContextId] = new openfl._internal.renderer.opengl.utils.GLStack(gl);
	if(!graphics.__visible || graphics.__commands.length == 0 || bounds == null || bounds.width == 0 || bounds.height == 0) {
	} else {
		var _g = 0;
		var _g1 = graphics.__commands;
		while(_g < _g1.length) {
			var command = _g1[_g];
			++_g;
			switch(command[1]) {
			case 0:
				var smooth = command[5];
				var repeat = command[4];
				var matrix = command[3];
				var bitmap = command[2];
				openfl._internal.renderer.opengl.utils.PathBuiler.endFill();
				if(bitmap != null) openfl._internal.renderer.opengl.utils.PathBuiler.__fill = openfl._internal.renderer.opengl.utils.FillType.Texture(bitmap,matrix,repeat,smooth); else openfl._internal.renderer.opengl.utils.PathBuiler.__fill = openfl._internal.renderer.opengl.utils.FillType.None;
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) {
					if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [];
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Polygon;
					openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				}
				break;
			case 1:
				var alpha = command[3];
				var rgb = command[2];
				openfl._internal.renderer.opengl.utils.PathBuiler.endFill();
				if(alpha > 0) openfl._internal.renderer.opengl.utils.PathBuiler.__fill = openfl._internal.renderer.opengl.utils.FillType.Color(rgb & 16777215,alpha); else openfl._internal.renderer.opengl.utils.PathBuiler.__fill = openfl._internal.renderer.opengl.utils.FillType.None;
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) {
					if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [];
					openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Polygon;
					openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				}
				break;
			case 2:
				var y = command[7];
				var x = command[6];
				var cy2 = command[5];
				var cx2 = command[4];
				var cy = command[3];
				var cx = command[2];
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.moveTo(0,0);
				var n = 20;
				var dt = 0;
				var dt2 = 0;
				var dt3 = 0;
				var t2 = 0;
				var t3 = 0;
				var points = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points;
				var fromX = points[points.length - 2];
				var fromY = points[points.length - 1];
				var px = 0;
				var py = 0;
				var tmp = 0;
				var _g3 = 1;
				var _g2 = n + 1;
				while(_g3 < _g2) {
					var i = _g3++;
					tmp = i / n;
					dt = 1 - tmp;
					dt2 = dt * dt;
					dt3 = dt2 * dt;
					t2 = tmp * tmp;
					t3 = t2 * tmp;
					px = dt3 * fromX + 3 * dt2 * tmp * cx + 3 * dt * t2 * cx2 + t3 * x;
					py = dt3 * fromY + 3 * dt2 * tmp * cy + 3 * dt * t2 * cy2 + t3 * y;
					points.push(px);
					points.push(py);
				}
				break;
			case 3:
				var y1 = command[5];
				var x1 = command[4];
				var cy1 = command[3];
				var cx1 = command[2];
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.moveTo(0,0);
				var xa = 0;
				var ya = 0;
				var n1 = 20;
				var points1 = openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points;
				var fromX1 = points1[points1.length - 2];
				var fromY1 = points1[points1.length - 1];
				var px1 = 0;
				var py1 = 0;
				var tmp1 = 0;
				var _g31 = 1;
				var _g21 = n1 + 1;
				while(_g31 < _g21) {
					var i1 = _g31++;
					tmp1 = i1 / n1;
					xa = fromX1 + (cx1 - fromX1) * tmp1;
					ya = fromY1 + (cy1 - fromY1) * tmp1;
					px1 = xa + (cx1 + (x1 - cx1) * tmp1 - xa) * tmp1;
					py1 = ya + (cy1 + (y1 - cy1) * tmp1 - ya) * tmp1;
					points1.push(px1);
					points1.push(py1);
				}
				break;
			case 4:
				var radius = command[4];
				var y2 = command[3];
				var x2 = command[2];
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Circle;
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [x2,y2,radius];
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			case 5:
				var height = command[5];
				var width = command[4];
				var y3 = command[3];
				var x3 = command[2];
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Ellipse;
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [x3,y3,width,height];
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			case 6:
				var height1 = command[5];
				var width1 = command[4];
				var y4 = command[3];
				var x4 = command[2];
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Rectangle(false);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [x4,y4,width1,height1];
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			case 7:
				var ry = command[7];
				var rx = command[6];
				var height2 = command[5];
				var width2 = command[4];
				var y5 = command[3];
				var x5 = command[2];
				if(ry == -1) ry = rx;
				rx *= 0.5;
				ry *= 0.5;
				if(rx > width2 / 2) rx = width2 / 2;
				if(ry > height2 / 2) ry = height2 / 2;
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Rectangle(true);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [x5,y5,width2,height2,rx,ry];
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			case 10:
				openfl._internal.renderer.opengl.utils.PathBuiler.endFill();
				break;
			case 11:
				var miterLimit = command[9];
				var joints = command[8];
				var caps = command[7];
				var scaleMode = command[6];
				var pixelHinting = command[5];
				var alpha1 = command[4];
				var color = command[3];
				var thickness = command[2];
				openfl._internal.renderer.opengl.utils.PathBuiler.__line = new openfl._internal.renderer.opengl.utils.LineStyle();
				if(thickness == null || thickness == Math.NaN || thickness < 0) openfl._internal.renderer.opengl.utils.PathBuiler.__line.width = 0; else if(thickness == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__line.width = 1; else openfl._internal.renderer.opengl.utils.PathBuiler.__line.width = thickness;
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__line.color = color;
				openfl._internal.renderer.opengl.utils.PathBuiler.__line.alpha = alpha1;
				openfl._internal.renderer.opengl.utils.PathBuiler.__line.scaleMode = scaleMode;
				openfl._internal.renderer.opengl.utils.PathBuiler.__line.caps = caps;
				openfl._internal.renderer.opengl.utils.PathBuiler.__line.joints = joints;
				openfl._internal.renderer.opengl.utils.PathBuiler.__line.miterLimit = miterLimit;
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points = [];
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.Polygon;
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			case 12:
				var y6 = command[3];
				var x6 = command[2];
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.push(x6);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.push(y6);
				break;
			case 13:
				var y7 = command[3];
				var x7 = command[2];
				openfl._internal.renderer.opengl.utils.PathBuiler.moveTo(x7,y7);
				break;
			case 9:
				var blendMode = command[7];
				var colors = command[6];
				var culling = command[5];
				var uvtData = command[4];
				var indices = command[3];
				var vertices = command[2];
				var isColor;
				{
					var _g22 = openfl._internal.renderer.opengl.utils.PathBuiler.__fill;
					switch(_g22[1]) {
					case 1:
						isColor = true;
						break;
					default:
						isColor = false;
					}
				}
				if(isColor && uvtData != null) continue;
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				if(uvtData == null) {
					var this1;
					this1 = new openfl.VectorData();
					var this2;
					this2 = new Array(0);
					this1.data = this2;
					this1.length = 0;
					this1.fixed = false;
					uvtData = this1;
					{
						var _g23 = openfl._internal.renderer.opengl.utils.PathBuiler.__fill;
						switch(_g23[1]) {
						case 2:
							var b = _g23[2];
							var _g4 = 0;
							var _g32 = vertices.length / 2 | 0;
							while(_g4 < _g32) {
								var i2 = _g4++;
								if(!uvtData.fixed) {
									uvtData.length++;
									if(uvtData.data.length < uvtData.length) {
										var data;
										var this3;
										this3 = new Array(uvtData.data.length + 10);
										data = this3;
										haxe.ds._Vector.Vector_Impl_.blit(uvtData.data,0,data,0,uvtData.data.length);
										uvtData.data = data;
									}
									uvtData.data[uvtData.length - 1] = vertices.data[i2 * 2] / b.width;
								}
								uvtData.length;
								if(!uvtData.fixed) {
									uvtData.length++;
									if(uvtData.data.length < uvtData.length) {
										var data1;
										var this4;
										this4 = new Array(uvtData.data.length + 10);
										data1 = this4;
										haxe.ds._Vector.Vector_Impl_.blit(uvtData.data,0,data1,0,uvtData.data.length);
										uvtData.data = data1;
									}
									uvtData.data[uvtData.length - 1] = vertices.data[i2 * 2 + 1] / b.height;
								}
								uvtData.length;
							}
							break;
						default:
						}
					}
				}
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.DrawTriangles(vertices,indices,uvtData,culling,colors,blendMode);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable = false;
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			case 8:
				var count = command[6];
				var flags = command[5];
				var smooth1 = command[4];
				var tileData = command[3];
				var sheet = command[2];
				if(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable && openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.points.length == 0) openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.pop(); else openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex++;
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath = new openfl._internal.renderer.opengl.utils.DrawPath();
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.update(openfl._internal.renderer.opengl.utils.PathBuiler.__line,openfl._internal.renderer.opengl.utils.PathBuiler.__fill,openfl._internal.renderer.opengl.utils.PathBuiler.__fillIndex);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.type = openfl._internal.renderer.opengl.utils.GraphicType.DrawTiles(sheet,tileData,smooth1,flags,count);
				openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath.isRemovable = false;
				openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths.push(openfl._internal.renderer.opengl.utils.PathBuiler.__currentPath);
				break;
			}
		}
		openfl._internal.renderer.opengl.utils.PathBuiler.closePath();
	}
	graphics.__drawPaths = openfl._internal.renderer.opengl.utils.PathBuiler.__drawPaths;
	return glStack;
};
openfl._internal.renderer.opengl.utils.LineStyle = function() {
	this.width = 0;
	this.color = 0;
	this.alpha = 1;
	this.scaleMode = openfl.display.LineScaleMode.NORMAL;
	this.caps = openfl.display.CapsStyle.ROUND;
	this.joints = openfl.display.JointStyle.ROUND;
	this.miterLimit = 3;
};
$hxClasses["openfl._internal.renderer.opengl.utils.LineStyle"] = openfl._internal.renderer.opengl.utils.LineStyle;
openfl._internal.renderer.opengl.utils.LineStyle.__name__ = ["openfl","_internal","renderer","opengl","utils","LineStyle"];
openfl._internal.renderer.opengl.utils.LineStyle.prototype = {
	__class__: openfl._internal.renderer.opengl.utils.LineStyle
};
openfl._internal.renderer.opengl.utils.FillType = $hxClasses["openfl._internal.renderer.opengl.utils.FillType"] = { __ename__ : ["openfl","_internal","renderer","opengl","utils","FillType"], __constructs__ : ["None","Color","Texture","Gradient"] };
openfl._internal.renderer.opengl.utils.FillType.None = ["None",0];
openfl._internal.renderer.opengl.utils.FillType.None.toString = $estr;
openfl._internal.renderer.opengl.utils.FillType.None.__enum__ = openfl._internal.renderer.opengl.utils.FillType;
openfl._internal.renderer.opengl.utils.FillType.Color = function(color,alpha) { var $x = ["Color",1,color,alpha]; $x.__enum__ = openfl._internal.renderer.opengl.utils.FillType; $x.toString = $estr; return $x; };
openfl._internal.renderer.opengl.utils.FillType.Texture = function(bitmap,matrix,repeat,smooth) { var $x = ["Texture",2,bitmap,matrix,repeat,smooth]; $x.__enum__ = openfl._internal.renderer.opengl.utils.FillType; $x.toString = $estr; return $x; };
openfl._internal.renderer.opengl.utils.FillType.Gradient = ["Gradient",3];
openfl._internal.renderer.opengl.utils.FillType.Gradient.toString = $estr;
openfl._internal.renderer.opengl.utils.FillType.Gradient.__enum__ = openfl._internal.renderer.opengl.utils.FillType;
openfl._internal.renderer.opengl.utils.FilterManager = function(gl,transparent) {
	this.transparent = transparent;
	this.filterStack = [];
	this.offsetX = 0;
	this.offsetY = 0;
	this.setContext(gl);
};
$hxClasses["openfl._internal.renderer.opengl.utils.FilterManager"] = openfl._internal.renderer.opengl.utils.FilterManager;
openfl._internal.renderer.opengl.utils.FilterManager.__name__ = ["openfl","_internal","renderer","opengl","utils","FilterManager"];
openfl._internal.renderer.opengl.utils.FilterManager.prototype = {
	applyFilterPass: function(filter,filterArea,width,height) {
		var gl = this.gl;
		var shader = filter.shaders[openfl._internal.renderer.opengl.GLRenderer.glContextId];
		if(shader == null) {
			shader = new openfl._internal.renderer.opengl.shaders.DefaultShader(gl);
			shader.fragmentSrc = filter.fragmentSrc;
			shader.uniforms = filter.uniforms;
			shader.init();
			filter.shaders[openfl._internal.renderer.opengl.GLRenderer.glContextId] = shader;
		}
		this.renderSession.shaderManager.setShader(shader);
		gl.uniform2f(shader.projectionVector,width / 2,-height / 2);
		gl.uniform2f(shader.offsetVector,0,0);
		if(filter.uniforms.dimensions != null) {
			filter.uniforms.dimensions.value[0] = this.width + 0.0;
			filter.uniforms.dimensions.value[1] = this.height + 0.0;
			filter.uniforms.dimensions.value[2] = this.vertexArray[0];
			filter.uniforms.dimensions.value[3] = this.vertexArray[5];
		}
		shader.syncUniforms();
		gl.bindBuffer(gl.ARRAY_BUFFER,this.vertexBuffer);
		gl.vertexAttribPointer(shader.aVertexPosition,2,gl.FLOAT,false,0,0);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.uvBuffer);
		gl.vertexAttribPointer(shader.aTextureCoord,2,gl.FLOAT,false,0,0);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.colorBuffer);
		gl.vertexAttribPointer(shader.colorAttribute,2,gl.FLOAT,false,0,0);
		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,this.indexBuffer);
		gl.drawElements(gl.TRIANGLES,6,gl.UNSIGNED_SHORT,0);
		this.renderSession.drawCount++;
	}
	,begin: function(renderSession,buffer) {
		this.renderSession = renderSession;
		this.defaultShader = renderSession.shaderManager.defaultShader;
		var projection = renderSession.projection;
		this.width = projection.x * 2 | 0;
		this.height = -projection.y * 2 | 0;
		this.buffer = buffer;
	}
	,destroy: function() {
		var gl = this.gl;
		this.filterStack = null;
		this.offsetX = 0;
		this.offsetY = 0;
		var _g = 0;
		var _g1 = this.texturePool;
		while(_g < _g1.length) {
			var texture = _g1[_g];
			++_g;
			texture.destroy();
		}
		this.texturePool = null;
		gl.deleteBuffer(this.vertexBuffer);
		gl.deleteBuffer(this.uvBuffer);
		gl.deleteBuffer(this.colorBuffer);
		gl.deleteBuffer(this.indexBuffer);
	}
	,initShaderBuffers: function() {
		var gl = this.gl;
		this.vertexBuffer = gl.createBuffer();
		this.uvBuffer = gl.createBuffer();
		this.colorBuffer = gl.createBuffer();
		this.indexBuffer = gl.createBuffer();
		this.vertexArray = new Float32Array([0.0,0.0,1.0,0.0,0.0,1.0,1.0,1.0]);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.vertexBuffer);
		gl.bufferData(gl.ARRAY_BUFFER,this.vertexArray,gl.STATIC_DRAW);
		this.uvArray = new Float32Array([0.0,0.0,1.0,0.0,0.0,1.0,1.0,1.0]);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.uvBuffer);
		gl.bufferData(gl.ARRAY_BUFFER,this.uvArray,gl.STATIC_DRAW);
		this.colorArray = new Float32Array([1.0,16777215,1.0,16777215,1.0,16777215,1.0,16777215]);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.colorBuffer);
		gl.bufferData(gl.ARRAY_BUFFER,this.colorArray,gl.STATIC_DRAW);
		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,this.indexBuffer);
		gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,new Uint16Array([0,1,2,1,3,2]),gl.STATIC_DRAW);
	}
	,popFilter: function() {
		var gl = this.gl;
		var filterBlock = this.filterStack.pop();
		var filterArea = filterBlock._filterArea;
		var texture = filterBlock._glFilterTexture;
		var projection = this.renderSession.projection;
		var offset = this.renderSession.offset;
		if(filterBlock.filterPasses.length > 1) {
			gl.viewport(0,0,filterArea.width | 0,filterArea.height | 0);
			gl.bindBuffer(gl.ARRAY_BUFFER,this.vertexBuffer);
			this.vertexArray[0] = 0;
			this.vertexArray[1] = filterArea.height;
			this.vertexArray[2] = filterArea.width;
			this.vertexArray[3] = filterArea.height;
			this.vertexArray[4] = 0;
			this.vertexArray[5] = 0;
			this.vertexArray[6] = filterArea.width;
			this.vertexArray[7] = 0;
			gl.bufferSubData(gl.ARRAY_BUFFER,0,this.vertexArray);
			gl.bindBuffer(gl.ARRAY_BUFFER,this.uvBuffer);
			this.uvArray[2] = filterArea.width / this.width;
			this.uvArray[5] = filterArea.height / this.height;
			this.uvArray[6] = filterArea.width / this.width;
			this.uvArray[7] = filterArea.height / this.height;
			gl.bufferSubData(gl.ARRAY_BUFFER,0,this.uvArray);
			var inputTexture = texture;
			var outputTexture = this.texturePool.pop();
			if(outputTexture == null) outputTexture = new openfl._internal.renderer.opengl.utils.FilterTexture(gl,this.width,this.height);
			outputTexture.resize(this.width,this.height);
			gl.bindFramebuffer(gl.FRAMEBUFFER,outputTexture.frameBuffer);
			gl.clear(gl.COLOR_BUFFER_BIT);
			gl.disable(gl.BLEND);
			var _g1 = 0;
			var _g = filterBlock.filterPasses.length - 1 | 0;
			while(_g1 < _g) {
				var i = _g1++;
				var filterPass = filterBlock.filterPasses[i];
				gl.bindFramebuffer(gl.FRAMEBUFFER,outputTexture.frameBuffer);
				gl.activeTexture(gl.TEXTURE0);
				gl.bindTexture(gl.TEXTURE_2D,inputTexture.texture);
				this.applyFilterPass(filterPass,filterArea,filterArea.width | 0,filterArea.height | 0);
				var temp = inputTexture;
				inputTexture = outputTexture;
				outputTexture = temp;
			}
			gl.enable(gl.BLEND);
			texture = inputTexture;
			this.texturePool.push(outputTexture);
		}
		var filter = filterBlock.filterPasses[filterBlock.filterPasses.length - 1 | 0];
		this.offsetX -= filterArea.x;
		this.offsetY -= filterArea.y;
		var sizeX = this.width;
		var sizeY = this.height;
		var offsetX = 0.0;
		var offsetY = 0.0;
		var buffer = this.buffer;
		if(this.filterStack.length == 0) gl.colorMask(true,true,true,true); else {
			var currentFilter = this.filterStack[this.filterStack.length - 1];
			filterArea = currentFilter._filterArea;
			sizeX = filterArea.width | 0;
			sizeY = filterArea.height | 0;
			offsetX = filterArea.x;
			offsetY = filterArea.y;
			buffer = currentFilter._glFilterTexture.frameBuffer;
		}
		projection.x = sizeX / 2;
		projection.y = -sizeY / 2;
		offset.x = offsetX;
		offset.y = offsetY;
		filterArea = filterBlock._filterArea;
		var x = filterArea.x - offsetX;
		var y = filterArea.y - offsetY;
		gl.bindBuffer(gl.ARRAY_BUFFER,this.vertexBuffer);
		this.vertexArray[0] = x;
		this.vertexArray[1] = y + filterArea.height;
		this.vertexArray[2] = x + filterArea.width;
		this.vertexArray[3] = y + filterArea.height;
		this.vertexArray[4] = x;
		this.vertexArray[5] = y;
		this.vertexArray[6] = x + filterArea.width;
		this.vertexArray[7] = y;
		gl.bufferSubData(gl.ARRAY_BUFFER,0,this.vertexArray);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.uvBuffer);
		this.uvArray[2] = filterArea.width / this.width;
		this.uvArray[5] = filterArea.height / this.height;
		this.uvArray[6] = filterArea.width / this.width;
		this.uvArray[7] = filterArea.height / this.height;
		gl.bufferSubData(gl.ARRAY_BUFFER,0,this.uvArray);
		gl.viewport(0,0,sizeX,sizeY);
		gl.bindFramebuffer(gl.FRAMEBUFFER,buffer);
		gl.activeTexture(gl.TEXTURE0);
		gl.bindTexture(gl.TEXTURE_2D,texture.texture);
		this.applyFilterPass(filter,filterArea,sizeX,sizeY);
		this.renderSession.shaderManager.setShader(this.defaultShader);
		gl.uniform2f(this.defaultShader.projectionVector,sizeX / 2,-sizeY / 2);
		gl.uniform2f(this.defaultShader.offsetVector,-offsetX,-offsetY);
		this.texturePool.push(texture);
		filterBlock._glFilterTexture = null;
	}
	,pushFilter: function(filterBlock) {
		var gl = this.gl;
		var projection = this.renderSession.projection;
		var offset = this.renderSession.offset;
		if(filterBlock.target.filterArea != null) filterBlock._filterArea = filterBlock.target.filterArea; else filterBlock._filterArea = filterBlock.target.getBounds();
		this.filterStack.push(filterBlock);
		var filter = filterBlock.filterPasses[0];
		this.offsetX += filterBlock._filterArea.x;
		this.offsetY += filterBlock._filterArea.y;
		var texture = this.texturePool.pop();
		if(texture == null) texture = new openfl._internal.renderer.opengl.utils.FilterTexture(gl,this.width,this.height); else texture.resize(this.width,this.height);
		gl.bindTexture(gl.TEXTURE_2D,texture.texture);
		var filterArea = filterBlock._filterArea;
		var padding = filter.padding;
		filterArea.x -= padding;
		filterArea.y -= padding;
		filterArea.width += padding * 2;
		filterArea.height += padding * 2;
		if(filterArea.x < 0) filterArea.x = 0;
		if(filterArea.width > this.width) filterArea.width = this.width;
		if(filterArea.y < 0) filterArea.y = 0;
		if(filterArea.height > this.height) filterArea.height = this.height;
		gl.bindFramebuffer(gl.FRAMEBUFFER,texture.frameBuffer);
		gl.viewport(0,0,filterArea.width | 0,filterArea.height | 0);
		projection.x = filterArea.width / 2;
		projection.y = -filterArea.height / 2;
		offset.x = -filterArea.x;
		offset.y = -filterArea.y;
		this.renderSession.shaderManager.setShader(this.defaultShader);
		gl.uniform2f(this.defaultShader.projectionVector,filterArea.width / 2,-filterArea.height / 2);
		gl.uniform2f(this.defaultShader.offsetVector,-filterArea.x,-filterArea.y);
		gl.colorMask(true,true,true,true);
		gl.clearColor(0,0,0,0);
		gl.clear(gl.COLOR_BUFFER_BIT);
		filterBlock._glFilterTexture = texture;
	}
	,setContext: function(gl) {
		this.gl = gl;
		this.texturePool = [];
		this.initShaderBuffers();
	}
	,__class__: openfl._internal.renderer.opengl.utils.FilterManager
};
openfl._internal.renderer.opengl.utils.FilterTexture = function(gl,width,height,smoothing) {
	if(smoothing == null) smoothing = true;
	this.gl = gl;
	this.frameBuffer = gl.createFramebuffer();
	this.texture = gl.createTexture();
	gl.bindTexture(gl.TEXTURE_2D,this.texture);
	gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,smoothing?gl.LINEAR:gl.NEAREST);
	gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,smoothing?gl.LINEAR:gl.NEAREST);
	gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE);
	gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE);
	gl.bindFramebuffer(gl.FRAMEBUFFER,this.frameBuffer);
	gl.framebufferTexture2D(gl.FRAMEBUFFER,gl.COLOR_ATTACHMENT0,gl.TEXTURE_2D,this.texture,0);
	this.renderBuffer = gl.createRenderbuffer();
	gl.bindRenderbuffer(gl.RENDERBUFFER,this.renderBuffer);
	gl.framebufferRenderbuffer(gl.FRAMEBUFFER,gl.DEPTH_STENCIL_ATTACHMENT,gl.RENDERBUFFER,this.renderBuffer);
	this.resize(width,height);
};
$hxClasses["openfl._internal.renderer.opengl.utils.FilterTexture"] = openfl._internal.renderer.opengl.utils.FilterTexture;
openfl._internal.renderer.opengl.utils.FilterTexture.__name__ = ["openfl","_internal","renderer","opengl","utils","FilterTexture"];
openfl._internal.renderer.opengl.utils.FilterTexture.prototype = {
	clear: function() {
		var gl = this.gl;
		gl.clearColor(0,0,0,0);
		gl.clear(gl.COLOR_BUFFER_BIT);
	}
	,destroy: function() {
		var gl = this.gl;
		gl.deleteFramebuffer(this.frameBuffer);
		gl.deleteTexture(this.texture);
		this.frameBuffer = null;
		this.texture = null;
	}
	,resize: function(width,height) {
		if(this.width == width && this.height == height) return;
		this.width = width;
		this.height = height;
		var gl = this.gl;
		gl.bindTexture(gl.TEXTURE_2D,this.texture);
		gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,width,height,0,gl.RGBA,gl.UNSIGNED_BYTE,null);
		gl.bindRenderbuffer(gl.RENDERBUFFER,this.renderBuffer);
		gl.renderbufferStorage(gl.RENDERBUFFER,gl.DEPTH_STENCIL,width,height);
	}
	,__class__: openfl._internal.renderer.opengl.utils.FilterTexture
};
openfl.geom.Rectangle = function(x,y,width,height) {
	if(height == null) height = 0;
	if(width == null) width = 0;
	if(y == null) y = 0;
	if(x == null) x = 0;
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
};
$hxClasses["openfl.geom.Rectangle"] = openfl.geom.Rectangle;
openfl.geom.Rectangle.__name__ = ["openfl","geom","Rectangle"];
openfl.geom.Rectangle.prototype = {
	clone: function() {
		return new openfl.geom.Rectangle(this.x,this.y,this.width,this.height);
	}
	,contains: function(x,y) {
		return x >= this.x && y >= this.y && x < this.get_right() && y < this.get_bottom();
	}
	,containsPoint: function(point) {
		return this.contains(point.x,point.y);
	}
	,containsRect: function(rect) {
		if(rect.width <= 0 || rect.height <= 0) return rect.x > this.x && rect.y > this.y && rect.get_right() < this.get_right() && rect.get_bottom() < this.get_bottom(); else return rect.x >= this.x && rect.y >= this.y && rect.get_right() <= this.get_right() && rect.get_bottom() <= this.get_bottom();
	}
	,copyFrom: function(sourceRect) {
		this.x = sourceRect.x;
		this.y = sourceRect.y;
		this.width = sourceRect.width;
		this.height = sourceRect.height;
	}
	,equals: function(toCompare) {
		return toCompare != null && this.x == toCompare.x && this.y == toCompare.y && this.width == toCompare.width && this.height == toCompare.height;
	}
	,inflate: function(dx,dy) {
		this.x -= dx;
		this.width += dx * 2;
		this.y -= dy;
		this.height += dy * 2;
	}
	,inflatePoint: function(point) {
		this.inflate(point.x,point.y);
	}
	,intersection: function(toIntersect) {
		var x0;
		if(this.x < toIntersect.x) x0 = toIntersect.x; else x0 = this.x;
		var x1;
		if(this.get_right() > toIntersect.get_right()) x1 = toIntersect.get_right(); else x1 = this.get_right();
		if(x1 <= x0) return new openfl.geom.Rectangle();
		var y0;
		if(this.y < toIntersect.y) y0 = toIntersect.y; else y0 = this.y;
		var y1;
		if(this.get_bottom() > toIntersect.get_bottom()) y1 = toIntersect.get_bottom(); else y1 = this.get_bottom();
		if(y1 <= y0) return new openfl.geom.Rectangle();
		return new openfl.geom.Rectangle(x0,y0,x1 - x0,y1 - y0);
	}
	,intersects: function(toIntersect) {
		var x0;
		if(this.x < toIntersect.x) x0 = toIntersect.x; else x0 = this.x;
		var x1;
		if(this.get_right() > toIntersect.get_right()) x1 = toIntersect.get_right(); else x1 = this.get_right();
		if(x1 <= x0) return false;
		var y0;
		if(this.y < toIntersect.y) y0 = toIntersect.y; else y0 = this.y;
		var y1;
		if(this.get_bottom() > toIntersect.get_bottom()) y1 = toIntersect.get_bottom(); else y1 = this.get_bottom();
		return y1 > y0;
	}
	,isEmpty: function() {
		return this.width <= 0 || this.height <= 0;
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,offsetPoint: function(point) {
		this.x += point.x;
		this.y += point.y;
	}
	,setEmpty: function() {
		this.x = this.y = this.width = this.height = 0;
	}
	,setTo: function(xa,ya,widtha,heighta) {
		this.x = xa;
		this.y = ya;
		this.width = widtha;
		this.height = heighta;
	}
	,transform: function(m) {
		var tx0 = m.a * this.x + m.c * this.y;
		var tx1 = tx0;
		var ty0 = m.b * this.x + m.d * this.y;
		var ty1 = tx0;
		var tx = m.a * (this.x + this.width) + m.c * this.y;
		var ty = m.b * (this.x + this.width) + m.d * this.y;
		if(tx < tx0) tx0 = tx;
		if(ty < ty0) ty0 = ty;
		if(tx > tx1) tx1 = tx;
		if(ty > ty1) ty1 = ty;
		tx = m.a * (this.x + this.width) + m.c * (this.y + this.height);
		ty = m.b * (this.x + this.width) + m.d * (this.y + this.height);
		if(tx < tx0) tx0 = tx;
		if(ty < ty0) ty0 = ty;
		if(tx > tx1) tx1 = tx;
		if(ty > ty1) ty1 = ty;
		tx = m.a * this.x + m.c * (this.y + this.height);
		ty = m.b * this.x + m.d * (this.y + this.height);
		if(tx < tx0) tx0 = tx;
		if(ty < ty0) ty0 = ty;
		if(tx > tx1) tx1 = tx;
		if(ty > ty1) ty1 = ty;
		return new openfl.geom.Rectangle(tx0 + m.tx,ty0 + m.ty,tx1 - tx0,ty1 - ty0);
	}
	,union: function(toUnion) {
		if(this.width == 0 || this.height == 0) return toUnion.clone(); else if(toUnion.width == 0 || toUnion.height == 0) return this.clone();
		var x0;
		if(this.x > toUnion.x) x0 = toUnion.x; else x0 = this.x;
		var x1;
		if(this.get_right() < toUnion.get_right()) x1 = toUnion.get_right(); else x1 = this.get_right();
		var y0;
		if(this.y > toUnion.y) y0 = toUnion.y; else y0 = this.y;
		var y1;
		if(this.get_bottom() < toUnion.get_bottom()) y1 = toUnion.get_bottom(); else y1 = this.get_bottom();
		return new openfl.geom.Rectangle(x0,y0,x1 - x0,y1 - y0);
	}
	,__contract: function(x,y,width,height) {
		if(this.width == 0 && this.height == 0) return;
		var cacheRight = this.get_right();
		var cacheBottom = this.get_bottom();
		if(this.x < x) this.x = x;
		if(this.y < y) this.y = y;
		if(this.get_right() > x + width) this.width = x + width - this.x;
		if(this.get_bottom() > y + height) this.height = y + height - this.y;
	}
	,__expand: function(x,y,width,height) {
		if(this.width == 0 && this.height == 0) {
			this.x = x;
			this.y = y;
			this.width = width;
			this.height = height;
			return;
		}
		var cacheRight = this.get_right();
		var cacheBottom = this.get_bottom();
		if(this.x > x) {
			this.x = x;
			this.width = cacheRight - x;
		}
		if(this.y > y) {
			this.y = y;
			this.height = cacheBottom - y;
		}
		if(cacheRight < x + width) this.width = x + width - this.x;
		if(cacheBottom < y + height) this.height = y + height - this.y;
	}
	,__toLimeRectangle: function() {
		return new lime.math.Rectangle(this.x,this.y,this.width,this.height);
	}
	,get_bottom: function() {
		return this.y + this.height;
	}
	,set_bottom: function(b) {
		this.height = b - this.y;
		return b;
	}
	,get_bottomRight: function() {
		return new openfl.geom.Point(this.x + this.width,this.y + this.height);
	}
	,set_bottomRight: function(p) {
		this.width = p.x - this.x;
		this.height = p.y - this.y;
		return p.clone();
	}
	,get_left: function() {
		return this.x;
	}
	,set_left: function(l) {
		this.width -= l - this.x;
		this.x = l;
		return l;
	}
	,get_right: function() {
		return this.x + this.width;
	}
	,set_right: function(r) {
		this.width = r - this.x;
		return r;
	}
	,get_size: function() {
		return new openfl.geom.Point(this.width,this.height);
	}
	,set_size: function(p) {
		this.width = p.x;
		this.height = p.y;
		return p.clone();
	}
	,get_top: function() {
		return this.y;
	}
	,set_top: function(t) {
		this.height -= t - this.y;
		this.y = t;
		return t;
	}
	,get_topLeft: function() {
		return new openfl.geom.Point(this.x,this.y);
	}
	,set_topLeft: function(p) {
		this.x = p.x;
		this.y = p.y;
		return p.clone();
	}
	,__class__: openfl.geom.Rectangle
	,__properties__: {set_topLeft:"set_topLeft",get_topLeft:"get_topLeft",set_top:"set_top",get_top:"get_top",set_size:"set_size",get_size:"get_size",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_bottomRight:"set_bottomRight",get_bottomRight:"get_bottomRight",set_bottom:"set_bottom",get_bottom:"get_bottom"}
};
openfl.geom.Point = function(x,y) {
	if(y == null) y = 0;
	if(x == null) x = 0;
	this.x = x;
	this.y = y;
};
$hxClasses["openfl.geom.Point"] = openfl.geom.Point;
openfl.geom.Point.__name__ = ["openfl","geom","Point"];
openfl.geom.Point.distance = function(pt1,pt2) {
	var dx = pt1.x - pt2.x;
	var dy = pt1.y - pt2.y;
	return Math.sqrt(dx * dx + dy * dy);
};
openfl.geom.Point.interpolate = function(pt1,pt2,f) {
	return new openfl.geom.Point(pt2.x + f * (pt1.x - pt2.x),pt2.y + f * (pt1.y - pt2.y));
};
openfl.geom.Point.polar = function(len,angle) {
	return new openfl.geom.Point(len * Math.cos(angle),len * Math.sin(angle));
};
openfl.geom.Point.prototype = {
	add: function(v) {
		return new openfl.geom.Point(v.x + this.x,v.y + this.y);
	}
	,clone: function() {
		return new openfl.geom.Point(this.x,this.y);
	}
	,copyFrom: function(sourcePoint) {
		this.x = sourcePoint.x;
		this.y = sourcePoint.y;
	}
	,equals: function(toCompare) {
		return toCompare != null && toCompare.x == this.x && toCompare.y == this.y;
	}
	,normalize: function(thickness) {
		if(this.x == 0 && this.y == 0) return; else {
			var norm = thickness / Math.sqrt(this.x * this.x + this.y * this.y);
			this.x *= norm;
			this.y *= norm;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,setTo: function(xa,ya) {
		this.x = xa;
		this.y = ya;
	}
	,subtract: function(v) {
		return new openfl.geom.Point(this.x - v.x,this.y - v.y);
	}
	,toString: function() {
		return "(x=" + this.x + ", y=" + this.y + ")";
	}
	,__toLimeVector2: function() {
		return new lime.math.Vector2(this.x,this.y);
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y);
	}
	,__class__: openfl.geom.Point
	,__properties__: {get_length:"get_length"}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer = function() { };
$hxClasses["openfl._internal.renderer.opengl.utils.GraphicsRenderer"] = openfl._internal.renderer.opengl.utils.GraphicsRenderer;
openfl._internal.renderer.opengl.utils.GraphicsRenderer.__name__ = ["openfl","_internal","renderer","opengl","utils","GraphicsRenderer"];
openfl._internal.renderer.opengl.utils.GraphicsRenderer.lastVertsBuffer = null;
openfl._internal.renderer.opengl.utils.GraphicsRenderer.lastBucketMode = null;
openfl._internal.renderer.opengl.utils.GraphicsRenderer.lastTexture = null;
openfl._internal.renderer.opengl.utils.GraphicsRenderer.lastTextureRepeat = null;
openfl._internal.renderer.opengl.utils.GraphicsRenderer.lastTextureSmooth = null;
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildCircle = function(path,glStack,localCoords) {
	if(localCoords == null) localCoords = false;
	var rectData = path.points;
	var x = rectData[0];
	var y = rectData[1];
	var width = rectData[2];
	var height;
	if(rectData.length == 3) height = width; else height = rectData[3];
	if(path.type == openfl._internal.renderer.opengl.utils.GraphicType.Ellipse) {
		width /= 2;
		height /= 2;
		x += width;
		y += height;
	}
	if(localCoords) {
		x -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
		y -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
	}
	var totalSegs = 40;
	var seg = Math.PI * 2 / totalSegs;
	var bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
	if(bucket != null) {
		var verts = bucket.verts;
		var indices = bucket.indices;
		var vertPos = verts.length / 2 | 0;
		indices.push(vertPos);
		var _g1 = 0;
		var _g = totalSegs + 1;
		while(_g1 < _g) {
			var i = _g1++;
			verts.push(x);
			verts.push(y);
			verts.push(x + Math.sin(seg * i) * width);
			verts.push(y + Math.cos(seg * i) * height);
			indices.push(vertPos++);
			indices.push(vertPos++);
		}
		indices.push(vertPos - 1);
	}
	if(path.line.width > 0) {
		var tempPoints = path.points;
		path.points = [];
		var _g11 = 0;
		var _g2 = totalSegs + 1;
		while(_g11 < _g2) {
			var i1 = _g11++;
			path.points.push(x + Math.sin(seg * i1) * width);
			path.points.push(y + Math.cos(seg * i1) * height);
		}
		openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildLine(path,bucket.line);
		path.points = tempPoints;
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildComplexPoly = function(path,glStack,localCoords) {
	if(localCoords == null) localCoords = false;
	if(path.points.length < 6) return;
	var points = path.points.slice();
	if(localCoords) {
		var _g1 = 0;
		var _g = points.length / 2 | 0;
		while(_g1 < _g) {
			var i = _g1++;
			points[i * 2] -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
			points[i * 2 + 1] -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
		}
	}
	var bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
	bucket.drawMode = glStack.gl.TRIANGLE_FAN;
	bucket.verts = points;
	var indices = bucket.indices;
	var length = points.length / 2 | 0;
	var _g2 = 0;
	while(_g2 < length) {
		var i1 = _g2++;
		indices.push(i1);
	}
	if(path.line.width > 0) openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildLine(path,bucket.line,localCoords);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildLine = function(path,bucket,localCoords) {
	if(localCoords == null) localCoords = false;
	var points = path.points;
	if(points.length == 0) return;
	if(localCoords) {
		var _g1 = 0;
		var _g = points.length / 2 | 0;
		while(_g1 < _g) {
			var i = _g1++;
			points[i * 2] -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
			points[i * 2 + 1] -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
		}
	}
	if(path.line.width % 2 > 0) {
		var _g11 = 0;
		var _g2 = points.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			points[i1] += 0.5;
		}
	}
	var firstPoint = new openfl.geom.Point(points[0],points[1]);
	var lastPoint = new openfl.geom.Point(points[points.length - 2 | 0],points[points.length - 1 | 0]);
	if(firstPoint.x == lastPoint.x && firstPoint.y == lastPoint.y) {
		points = points.slice();
		points.pop();
		points.pop();
		lastPoint = new openfl.geom.Point(points[points.length - 2 | 0],points[points.length - 1 | 0]);
		var midPointX = lastPoint.x + (firstPoint.x - lastPoint.x) * 0.5;
		var midPointY = lastPoint.y + (firstPoint.y - lastPoint.y) * 0.5;
		points.unshift(midPointY);
		points.unshift(midPointX);
		points.push(midPointX);
		points.push(midPointY);
	}
	var verts = bucket.verts;
	var indices = bucket.indices;
	var length = points.length / 2 | 0;
	var indexCount = points.length;
	var indexStart = verts.length / 6 | 0;
	var width = path.line.width / 2;
	var color = openfl._internal.renderer.opengl.utils.GraphicsRenderer.hex2rgb(path.line.color);
	var alpha = path.line.alpha;
	var r = color[0] * alpha;
	var g = color[1] * alpha;
	var b = color[2] * alpha;
	var px;
	var py;
	var p1x;
	var p1y;
	var p2x;
	var p2y;
	var p3x;
	var p3y;
	var perpx;
	var perpy;
	var perp2x;
	var perp2y;
	var perp3x;
	var perp3y;
	var a1;
	var b1;
	var c1;
	var a2;
	var b2;
	var c2;
	var denom;
	var pdist;
	var dist;
	p1x = points[0];
	p1y = points[1];
	p2x = points[2];
	p2y = points[3];
	perpx = -(p1y - p2y);
	perpy = p1x - p2x;
	dist = Math.sqrt(Math.abs(perpx * perpx + perpy * perpy));
	perpx = perpx / dist;
	perpy = perpy / dist;
	perpx = perpx * width;
	perpy = perpy * width;
	verts.push(p1x - perpx);
	verts.push(p1y - perpy);
	verts.push(r);
	verts.push(g);
	verts.push(b);
	verts.push(alpha);
	verts.push(p1x + perpx);
	verts.push(p1y + perpy);
	verts.push(r);
	verts.push(g);
	verts.push(b);
	verts.push(alpha);
	var _g12 = 1;
	var _g3 = length - 1;
	while(_g12 < _g3) {
		var i2 = _g12++;
		p1x = points[(i2 - 1) * 2];
		p1y = points[(i2 - 1) * 2 + 1];
		p2x = points[i2 * 2];
		p2y = points[i2 * 2 + 1];
		p3x = points[(i2 + 1) * 2];
		p3y = points[(i2 + 1) * 2 + 1];
		perpx = -(p1y - p2y);
		perpy = p1x - p2x;
		dist = Math.sqrt(Math.abs(perpx * perpx + perpy * perpy));
		perpx = perpx / dist;
		perpy = perpy / dist;
		perpx = perpx * width;
		perpy = perpy * width;
		perp2x = -(p2y - p3y);
		perp2y = p2x - p3x;
		dist = Math.sqrt(Math.abs(perp2x * perp2x + perp2y * perp2y));
		perp2x = perp2x / dist;
		perp2y = perp2y / dist;
		perp2x = perp2x * width;
		perp2y = perp2y * width;
		a1 = -perpy + p1y - (-perpy + p2y);
		b1 = -perpx + p2x - (-perpx + p1x);
		c1 = (-perpx + p1x) * (-perpy + p2y) - (-perpx + p2x) * (-perpy + p1y);
		a2 = -perp2y + p3y - (-perp2y + p2y);
		b2 = -perp2x + p2x - (-perp2x + p3x);
		c2 = (-perp2x + p3x) * (-perp2y + p2y) - (-perp2x + p2x) * (-perp2y + p3y);
		denom = a1 * b2 - a2 * b1;
		if(Math.abs(denom) < 0.1) {
			denom += 10.1;
			verts.push(p2x - perpx);
			verts.push(p2y - perpy);
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
			verts.push(p2x + perpx);
			verts.push(p2y + perpy);
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
			continue;
		}
		px = (b1 * c2 - b2 * c1) / denom;
		py = (a2 * c1 - a1 * c2) / denom;
		pdist = (px - p2x) * (px - p2x) + (py - p2y) + (py - p2y);
		if(pdist > 19600) {
			perp3x = perpx - perp2x;
			perp3y = perpy - perp2y;
			dist = Math.sqrt(Math.abs(perp3x * perp3x + perp3y * perp3y));
			perp3x = perp3x / dist;
			perp3y = perp3y / dist;
			perp3x = perp3x * width;
			perp3y = perp3y * width;
			verts.push(p2x - perp3x);
			verts.push(p2y - perp3y);
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
			verts.push(p2x + perp3x);
			verts.push(p2y + perp3y);
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
			verts.push(p2x - perp3x);
			verts.push(p2y - perp3y);
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
			indexCount++;
		} else {
			verts.push(px);
			verts.push(py);
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
			verts.push(p2x - (px - p2x));
			verts.push(p2y - (py - p2y));
			verts.push(r);
			verts.push(g);
			verts.push(b);
			verts.push(alpha);
		}
	}
	p1x = points[(length - 2) * 2];
	p1y = points[(length - 2) * 2 + 1];
	p2x = points[(length - 1) * 2];
	p2y = points[(length - 1) * 2 + 1];
	perpx = -(p1y - p2y);
	perpy = p1x - p2x;
	dist = Math.sqrt(Math.abs(perpx * perpx + perpy * perpy));
	if(!Math.isFinite(dist)) null;
	perpx = perpx / dist;
	perpy = perpy / dist;
	perpx = perpx * width;
	perpy = perpy * width;
	verts.push(p2x - perpx);
	verts.push(p2y - perpy);
	verts.push(r);
	verts.push(g);
	verts.push(b);
	verts.push(alpha);
	verts.push(p2x + perpx);
	verts.push(p2y + perpy);
	verts.push(r);
	verts.push(g);
	verts.push(b);
	verts.push(alpha);
	indices.push(indexStart);
	var _g4 = 0;
	while(_g4 < indexCount) {
		var i3 = _g4++;
		indices.push(indexStart++);
	}
	indices.push(indexStart - 1);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildPoly = function(path,glStack) {
	if(path.points.length < 6) return;
	var points = path.points;
	var l = points.length;
	var sx = points[0];
	var sy = points[1];
	var ex = points[l - 2];
	var ey = points[l - 1];
	if(sx != ex || sy != ey) {
		points.push(sx);
		points.push(sy);
	}
	var length = points.length / 2 | 0;
	var bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
	var verts = bucket.verts;
	var indices = bucket.indices;
	if(bucket != null) {
		var triangles = openfl._internal.renderer.opengl.utils.PolyK.triangulate(points);
		var vertPos = verts.length / 2;
		var i = 0;
		while(i < triangles.length) {
			indices.push(triangles[i] + vertPos | 0);
			indices.push(triangles[i] + vertPos | 0);
			indices.push(triangles[i + 1] + vertPos | 0);
			indices.push(triangles[i + 2] + vertPos | 0);
			indices.push(triangles[i + 2] + vertPos | 0);
			i += 3;
		}
		var _g = 0;
		while(_g < length) {
			var i1 = _g++;
			verts.push(points[i1 * 2]);
			verts.push(points[i1 * 2 + 1]);
		}
	}
	if(path.line.width > 0) openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildLine(path,bucket.line);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildRectangle = function(path,glStack,localCoords) {
	if(localCoords == null) localCoords = false;
	var rectData = path.points;
	var x = rectData[0];
	var y = rectData[1];
	var width = rectData[2];
	var height = rectData[3];
	if(localCoords) {
		x -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
		y -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
	}
	var bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
	if(bucket != null) {
		var verts = bucket.verts;
		var indices = bucket.indices;
		var vertPos = verts.length / 2 | 0;
		verts.push(x);
		verts.push(y);
		verts.push(x + width);
		verts.push(y);
		verts.push(x);
		verts.push(y + height);
		verts.push(x + width);
		verts.push(y + height);
		indices.push(vertPos);
		indices.push(vertPos);
		indices.push(vertPos + 1);
		indices.push(vertPos + 2);
		indices.push(vertPos + 3);
		indices.push(vertPos + 3);
	}
	if(path.line.width > 0) {
		var tempPoints = path.points;
		path.points = [x,y,x + width,y,x + width,y + height,x,y + height,x,y];
		openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildLine(path,bucket.line);
		path.points = tempPoints;
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildRoundedRectangle = function(path,glStack,localCoords) {
	if(localCoords == null) localCoords = false;
	var points = path.points.slice();
	var x = points[0];
	var y = points[1];
	var width = points[2];
	var height = points[3];
	var radius = points[4];
	if(localCoords) {
		x -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
		y -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
	}
	var recPoints = [];
	recPoints.push(x);
	recPoints.push(y + radius);
	recPoints = recPoints.concat(openfl._internal.renderer.opengl.utils.GraphicsRenderer.quadraticBezierCurve(x,y + height - radius,x,y + height,x + radius,y + height));
	recPoints = recPoints.concat(openfl._internal.renderer.opengl.utils.GraphicsRenderer.quadraticBezierCurve(x + width - radius,y + height,x + width,y + height,x + width,y + height - radius));
	recPoints = recPoints.concat(openfl._internal.renderer.opengl.utils.GraphicsRenderer.quadraticBezierCurve(x + width,y + radius,x + width,y,x + width - radius,y));
	recPoints = recPoints.concat(openfl._internal.renderer.opengl.utils.GraphicsRenderer.quadraticBezierCurve(x + radius,y,x,y,x,y + radius));
	var bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
	if(bucket != null) {
		var verts = bucket.verts;
		var indices = bucket.indices;
		var vecPos = verts.length / 2;
		var triangles = openfl._internal.renderer.opengl.utils.PolyK.triangulate(recPoints);
		var i = 0;
		while(i < triangles.length) {
			indices.push(triangles[i] + vecPos | 0);
			indices.push(triangles[i] + vecPos | 0);
			indices.push(triangles[i + 1] + vecPos | 0);
			indices.push(triangles[i + 2] + vecPos | 0);
			indices.push(triangles[i + 2] + vecPos | 0);
			i += 3;
		}
		i = 0;
		while(i < recPoints.length) {
			verts.push(recPoints[i]);
			verts.push(recPoints[++i]);
			i++;
		}
	}
	if(path.line.width > 0) {
		var tempPoints = path.points;
		path.points = recPoints;
		openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildLine(path,bucket.line);
		path.points = tempPoints;
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildDrawTriangles = function(path,object,glStack,localCoords) {
	if(localCoords == null) localCoords = false;
	var args = path.type.slice(2);
	var vertices = args[0];
	var indices = args[1];
	var uvtData = args[2];
	var culling = args[3];
	var colors = args[4];
	var blendMode = args[5];
	var a;
	var b;
	var c;
	var d;
	var tx;
	var ty;
	if(localCoords) {
		a = 1.0;
		b = 0.0;
		c = 0.0;
		d = 1.0;
		tx = 0.0;
		ty = 0.0;
	} else {
		a = object.__worldTransform.a;
		b = object.__worldTransform.b;
		c = object.__worldTransform.c;
		d = object.__worldTransform.d;
		tx = object.__worldTransform.tx;
		ty = object.__worldTransform.ty;
	}
	var hasColors = colors != null && colors.length > 0;
	var bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
	bucket.rawVerts = true;
	bucket.glLength = indices.length;
	bucket.stride = 8;
	var vertsLength = bucket.glLength * bucket.stride;
	var verts;
	if(bucket.glVerts == null || bucket.glVerts.length < vertsLength) {
		verts = new Float32Array(vertsLength);
		bucket.glVerts = verts;
	} else verts = bucket.glVerts;
	var v0 = 0;
	var v1 = 0;
	var v2 = 0;
	var i0 = 0;
	var i1 = 0;
	var i2 = 0;
	var x0 = 0.0;
	var y0 = 0.0;
	var x1 = 0.0;
	var y1 = 0.0;
	var x2 = 0.0;
	var y2 = 0.0;
	var idx = 0;
	var color = [1.,1.,1.,1.];
	var ctmp = color;
	var _g1 = 0;
	var _g = indices.length / 3 | 0;
	while(_g1 < _g) {
		var i = _g1++;
		i0 = indices.data[i * 3];
		i1 = indices.data[i * 3 + 1];
		i2 = indices.data[i * 3 + 2];
		v0 = i0 * 2;
		v1 = i1 * 2;
		v2 = i2 * 2;
		x0 = vertices.data[v0];
		y0 = vertices.data[v0 + 1];
		x1 = vertices.data[v1];
		y1 = vertices.data[v1 + 1];
		x2 = vertices.data[v2];
		y2 = vertices.data[v2 + 1];
		if(localCoords) {
			x0 -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
			y0 -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
			x1 -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
			y1 -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
			x2 -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.x;
			y2 -= openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.y;
		}
		switch(culling[1]) {
		case 2:
			if(!((x1 - x0) * (y2 - y0) - (y1 - y0) * (x2 - x0) < 0)) continue;
			break;
		case 0:
			if((x1 - x0) * (y2 - y0) - (y1 - y0) * (x2 - x0) < 0) continue;
			break;
		default:
		}
		verts[idx++] = a * x0 + c * y0 + tx;
		verts[idx++] = b * x0 + d * y0 + ty;
		verts[idx++] = uvtData.data[v0];
		verts[idx++] = uvtData.data[v0 + 1];
		if(hasColors) {
			ctmp = openfl._internal.renderer.opengl.utils.GraphicsRenderer.hex2rgba(colors.data[i0]);
			verts[idx++] = ctmp[0];
			verts[idx++] = ctmp[1];
			verts[idx++] = ctmp[2];
			verts[idx++] = ctmp[3];
		} else {
			verts[idx++] = color[0];
			verts[idx++] = color[1];
			verts[idx++] = color[2];
			verts[idx++] = color[3];
		}
		verts[idx++] = a * x1 + c * y1 + tx;
		verts[idx++] = b * x1 + d * y1 + ty;
		verts[idx++] = uvtData.data[v1];
		verts[idx++] = uvtData.data[v1 + 1];
		if(hasColors) {
			ctmp = openfl._internal.renderer.opengl.utils.GraphicsRenderer.hex2rgba(colors.data[i1]);
			verts[idx++] = ctmp[0];
			verts[idx++] = ctmp[1];
			verts[idx++] = ctmp[2];
			verts[idx++] = ctmp[3];
		} else {
			verts[idx++] = color[0];
			verts[idx++] = color[1];
			verts[idx++] = color[2];
			verts[idx++] = color[3];
		}
		verts[idx++] = a * x2 + c * y2 + tx;
		verts[idx++] = b * x2 + d * y2 + ty;
		verts[idx++] = uvtData.data[v2];
		verts[idx++] = uvtData.data[v2 + 1];
		if(hasColors) {
			ctmp = openfl._internal.renderer.opengl.utils.GraphicsRenderer.hex2rgba(colors.data[i2]);
			verts[idx++] = ctmp[0];
			verts[idx++] = ctmp[1];
			verts[idx++] = ctmp[2];
			verts[idx++] = ctmp[3];
		} else {
			verts[idx++] = color[0];
			verts[idx++] = color[1];
			verts[idx++] = color[2];
			verts[idx++] = color[3];
		}
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildDrawTiles = function(path,glStack) {
	openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.quadraticBezierCurve = function(fromX,fromY,cpX,cpY,toX,toY) {
	var xa;
	var ya;
	var xb;
	var yb;
	var x;
	var y;
	var n = 20;
	var points = [];
	var getPt = function(n1,n2,perc) {
		var diff = n2 - n1;
		return n1 + diff * perc;
	};
	var j = 0.0;
	var _g1 = 0;
	var _g = n + 1;
	while(_g1 < _g) {
		var i = _g1++;
		j = i / n;
		xa = getPt(fromX,cpX,j);
		ya = getPt(fromY,cpY,j);
		xb = getPt(cpX,toX,j);
		yb = getPt(cpY,toY,j);
		x = getPt(xa,xb,j);
		y = getPt(ya,yb,j);
		points.push(x);
		points.push(y);
	}
	return points;
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.render = function(object,renderSession) {
	var graphics = object.__graphics;
	var spritebatch = renderSession.spriteBatch;
	var dirty = graphics.__dirty;
	if(graphics.__commands.length <= 0) return;
	if(dirty) openfl._internal.renderer.opengl.utils.GraphicsRenderer.updateGraphics(object,renderSession.gl,object.cacheAsBitmap);
	if(object.cacheAsBitmap) {
		if(dirty) {
			var gl = renderSession.gl;
			var bounds = graphics.__bounds;
			var texture = graphics.__cachedTexture;
			var w = Math.floor(bounds.width + 0.5);
			var h = Math.floor(bounds.height + 0.5);
			if(texture == null) {
				texture = new openfl._internal.renderer.opengl.utils.FilterTexture(gl,w,h,false);
				graphics.__cachedTexture = texture;
			}
			texture.resize(w,h);
			gl.bindFramebuffer(gl.FRAMEBUFFER,texture.frameBuffer);
			gl.viewport(0,0,w,h);
			texture.clear();
			openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderGraphics(object,renderSession,new openfl.geom.Point(w / 2,-h / 2),true);
			gl.bindFramebuffer(gl.FRAMEBUFFER,null);
			gl.viewport(0,0,renderSession.renderer.width,renderSession.renderer.height);
		}
		if(!spritebatch.drawing) spritebatch.begin(renderSession);
		spritebatch.renderCachedGraphics(object);
	} else openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderGraphics(object,renderSession,renderSession.projection,false);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderGraphics = function(object,renderSession,projection,localCoords) {
	if(localCoords == null) localCoords = false;
	var graphics = object.__graphics;
	var gl = renderSession.gl;
	var offset = renderSession.offset;
	var glStack = graphics.__glStack[openfl._internal.renderer.opengl.GLRenderer.glContextId];
	var bucket;
	var translationMatrix;
	if(localCoords) translationMatrix = openfl.geom.Matrix.__identity; else translationMatrix = object.__worldTransform;
	var batchDrawing = renderSession.spriteBatch.drawing;
	var _g1 = 0;
	var _g = glStack.buckets.length;
	while(_g1 < _g) {
		var i = _g1++;
		batchDrawing = renderSession.spriteBatch.drawing;
		bucket = glStack.buckets[i];
		var _g2 = bucket.mode;
		switch(_g2[1]) {
		case 1:case 2:
			if(batchDrawing && !localCoords) renderSession.spriteBatch.end();
			renderSession.stencilManager.pushBucket(bucket,renderSession,projection,translationMatrix.toArray(true));
			var shader = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareShader(bucket,renderSession,object,projection,translationMatrix.toArray(false));
			openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderFill(bucket,shader,renderSession);
			renderSession.stencilManager.popBucket(object,bucket,renderSession);
			break;
		case 5:
			if(batchDrawing && !localCoords) renderSession.spriteBatch.end();
			var shader1 = openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareShader(bucket,renderSession,object,projection,null);
			openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderDrawTriangles(bucket,shader1,renderSession);
			break;
		case 6:
			if(!batchDrawing) renderSession.spriteBatch.begin(renderSession);
			openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderDrawTiles(object,bucket,renderSession);
			break;
		default:
		}
		var _g21 = 0;
		var _g3 = bucket.data;
		while(_g21 < _g3.length) {
			var data = _g3[_g21];
			++_g21;
			if(data.line != null && data.line.verts.length > 0) {
				batchDrawing = renderSession.spriteBatch.drawing;
				if(batchDrawing && !localCoords) renderSession.spriteBatch.end();
				var shader2 = renderSession.shaderManager.primitiveShader;
				renderSession.shaderManager.setShader(shader2);
				gl.uniformMatrix3fv(shader2.translationMatrix,false,translationMatrix.toArray(true));
				gl.uniform2f(shader2.projectionVector,projection.x,-projection.y);
				gl.uniform2f(shader2.offsetVector,-offset.x,-offset.y);
				gl.uniform1f(shader2.alpha,object.__worldAlpha);
				gl.bindBuffer(gl.ARRAY_BUFFER,data.line.vertsBuffer);
				gl.vertexAttribPointer(shader2.aVertexPosition,2,gl.FLOAT,false,24,0);
				gl.vertexAttribPointer(shader2.colorAttribute,4,gl.FLOAT,false,24,8);
				gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,data.line.indexBuffer);
				gl.drawElements(gl.TRIANGLE_STRIP,data.line.indices.length,gl.UNSIGNED_SHORT,0);
			}
		}
		batchDrawing = renderSession.spriteBatch.drawing;
		if(!batchDrawing && !localCoords) renderSession.spriteBatch.begin(renderSession);
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.updateGraphics = function(object,gl,localCoords) {
	if(localCoords == null) localCoords = false;
	var graphics = object.__graphics;
	openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectPosition.setTo(object.get_x(),object.get_y());
	if(graphics.__bounds != null) openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectBounds.copyFrom(graphics.__bounds);
	var glStack = null;
	if(graphics.__dirty) glStack = openfl._internal.renderer.opengl.utils.DrawPath.getStack(graphics,gl);
	graphics.__dirty = false;
	var _g = 0;
	var _g1 = glStack.buckets;
	while(_g < _g1.length) {
		var data = _g1[_g];
		++_g;
		data.reset();
		openfl._internal.renderer.opengl.utils.GraphicsRenderer.bucketPool.push(data);
	}
	glStack.reset();
	var _g11 = glStack.lastIndex;
	var _g2 = graphics.__drawPaths.length;
	while(_g11 < _g2) {
		var i = _g11++;
		var path = graphics.__drawPaths[i];
		{
			var _g21 = path.type;
			switch(_g21[1]) {
			case 0:
				openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildComplexPoly(path,glStack,localCoords);
				break;
			case 1:
				var rounded = _g21[2];
				if(rounded) openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildRoundedRectangle(path,glStack,localCoords); else openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildRectangle(path,glStack,localCoords);
				break;
			case 2:case 3:
				openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildCircle(path,glStack,localCoords);
				break;
			case 4:
				openfl._internal.renderer.opengl.utils.GraphicsRenderer.buildDrawTriangles(path,object,glStack,localCoords);
				break;
			case 5:
				openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket(path,glStack);
				break;
			}
		}
		glStack.lastIndex++;
	}
	glStack.upload();
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareBucket = function(path,glStack) {
	var bucket = null;
	{
		var _g = path.fill;
		switch(_g[1]) {
		case 1:
			var a = _g[3];
			var c = _g[2];
			bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.switchBucket(path.fillIndex,glStack,openfl._internal.renderer.opengl.utils.BucketMode.Fill);
			if(c == null) bucket.color = [0,0,0]; else bucket.color = [(c >> 16 & 255) / 255,(c >> 8 & 255) / 255,(c & 255) / 255];
			bucket.alpha = a;
			bucket.uploadTileBuffer = true;
			break;
		case 2:
			var s = _g[5];
			var r = _g[4];
			var m = _g[3];
			var b = _g[2];
			bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.switchBucket(path.fillIndex,glStack,openfl._internal.renderer.opengl.utils.BucketMode.PatternFill);
			bucket.bitmap = b;
			bucket.textureRepeat = r;
			bucket.textureSmooth = s;
			bucket.texture = b.getTexture(glStack.gl);
			bucket.uploadTileBuffer = true;
			var tMatrix = bucket.textureMatrix;
			tMatrix.identity();
			var pMatrix;
			if(m == null) pMatrix = new openfl.geom.Matrix(); else pMatrix = new openfl.geom.Matrix(m.a,m.b,m.c,m.d,m.tx,m.ty);
			pMatrix = pMatrix.invert();
			pMatrix.__translateTransformed(new openfl.geom.Point(-openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectPosition.x,-openfl._internal.renderer.opengl.utils.GraphicsRenderer.objectPosition.y));
			var tx = pMatrix.tx / b.width;
			var ty = pMatrix.ty / b.height;
			tMatrix.concat(pMatrix);
			bucket.textureTL.x = tx;
			bucket.textureTL.y = ty;
			bucket.textureBR.x = tx + 1;
			bucket.textureBR.y = ty + 1;
			tMatrix.scale(1 / b.width,1 / b.height);
			bucket.textureMatrix = tMatrix;
			break;
		default:
			bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.switchBucket(path.fillIndex,glStack,openfl._internal.renderer.opengl.utils.BucketMode.Line);
			bucket.uploadTileBuffer = false;
		}
	}
	{
		var _g1 = path.type;
		switch(_g1[1]) {
		case 4:
			bucket.mode = openfl._internal.renderer.opengl.utils.BucketMode.DrawTriangles;
			bucket.uploadTileBuffer = false;
			break;
		case 5:
			bucket.mode = openfl._internal.renderer.opengl.utils.BucketMode.DrawTiles;
			bucket.uploadTileBuffer = false;
			break;
		default:
		}
	}
	bucket.graphicType = path.type;
	var bucketData = bucket.getData();
	return bucketData;
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.getBucket = function(glStack,mode) {
	var b = openfl._internal.renderer.opengl.utils.GraphicsRenderer.bucketPool.pop();
	if(b == null) b = new openfl._internal.renderer.opengl.utils.GLBucket(glStack.gl);
	b.mode = mode;
	glStack.buckets.push(b);
	return b;
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.switchBucket = function(fillIndex,glStack,mode) {
	var bucket;
	if(glStack.buckets.length == 0) bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.getBucket(glStack,mode); else {
		bucket = glStack.buckets[glStack.buckets.length - 1];
		if(bucket.fillIndex != fillIndex) bucket = openfl._internal.renderer.opengl.utils.GraphicsRenderer.getBucket(glStack,mode);
	}
	bucket.dirty = true;
	bucket.fillIndex = fillIndex;
	return bucket;
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.prepareShader = function(bucket,renderSession,object,projection,translationMatrix) {
	var gl = renderSession.gl;
	var offset = renderSession.offset;
	var shader = null;
	var _g = bucket.mode;
	switch(_g[1]) {
	case 1:
		shader = renderSession.shaderManager.fillShader;
		break;
	case 2:
		shader = renderSession.shaderManager.patternFillShader;
		break;
	case 5:
		shader = renderSession.shaderManager.drawTrianglesShader;
		break;
	default:
		shader = null;
	}
	if(shader == null) return null;
	var newShader = renderSession.shaderManager.setShader(shader);
	gl.uniform2f(shader.projectionVector,projection.x,-projection.y);
	gl.uniform2f(shader.offsetVector,-offset.x,-offset.y);
	gl.uniform1f(shader.alpha,object.__worldAlpha * bucket.alpha);
	var _g1 = bucket.mode;
	switch(_g1[1]) {
	case 1:
		gl.uniformMatrix3fv(shader.translationMatrix,false,translationMatrix);
		gl.uniform3fv(shader.color,new Float32Array(bucket.color));
		break;
	case 2:
		gl.uniformMatrix3fv(shader.translationMatrix,false,translationMatrix);
		gl.uniform1i(shader.sampler,0);
		gl.uniform2f(shader.patternTL,bucket.textureTL.x,bucket.textureTL.y);
		gl.uniform2f(shader.patternBR,bucket.textureBR.x,bucket.textureBR.y);
		gl.uniformMatrix3fv(shader.patternMatrix,false,bucket.textureMatrix.toArray(false));
		break;
	case 5:
		if(bucket.texture != null) {
			gl.uniform1i(shader.useTexture,1);
			gl.uniform1i(shader.sampler,0);
		} else {
			gl.uniform1i(shader.useTexture,0);
			gl.uniform3fv(shader.color,new Float32Array(bucket.color));
		}
		break;
	default:
	}
	return shader;
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderFill = function(bucket,shader,renderSession) {
	var gl = renderSession.gl;
	if(bucket.mode == openfl._internal.renderer.opengl.utils.BucketMode.PatternFill && bucket.texture != null) openfl._internal.renderer.opengl.utils.GraphicsRenderer.bindTexture(gl,bucket);
	gl.bindBuffer(gl.ARRAY_BUFFER,bucket.tileBuffer);
	gl.vertexAttribPointer(shader.aVertexPosition,4,gl.SHORT,false,0,0);
	gl.drawArrays(gl.TRIANGLE_STRIP,0,4);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderDrawTriangles = function(bucket,shader,renderSession) {
	var gl = renderSession.gl;
	var _g = 0;
	var _g1 = bucket.data;
	while(_g < _g1.length) {
		var data = _g1[_g];
		++_g;
		if(data.destroyed) continue;
		if(bucket.texture == null) {
		} else openfl._internal.renderer.opengl.utils.GraphicsRenderer.bindTexture(gl,bucket);
		openfl._internal.renderer.opengl.utils.GraphicsRenderer.bindDrawTrianglesBuffer(gl,shader,data);
		gl.drawArrays(gl.TRIANGLES,data.glStart,data.glLength);
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.renderDrawTiles = function(object,bucket,renderSession) {
	var args = bucket.graphicType.slice(2);
	renderSession.spriteBatch.renderTiles(object,args[0],args[1],args[2],args[3],args[4]);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.bindDrawTrianglesBuffer = function(gl,shader,data) {
	gl.bindBuffer(gl.ARRAY_BUFFER,data.vertsBuffer);
	var stride = data.stride * 4;
	gl.vertexAttribPointer(shader.aVertexPosition,2,gl.FLOAT,false,stride,0);
	gl.vertexAttribPointer(shader.aTextureCoord,2,gl.FLOAT,false,stride,8);
	gl.vertexAttribPointer(shader.colorAttribute,4,gl.FLOAT,false,stride,16);
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.bindTexture = function(gl,bucket) {
	gl.bindTexture(gl.TEXTURE_2D,bucket.texture);
	if(bucket.textureRepeat && bucket.bitmap.__image.get_powerOfTwo()) {
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.REPEAT);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.REPEAT);
	} else {
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE);
	}
	if(bucket.textureSmooth) {
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR);
	} else {
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.NEAREST);
		gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST);
	}
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.isCCW = function(x1,y1,x2,y2,x3,y3) {
	return (x2 - x1) * (y3 - y1) - (y2 - y1) * (x3 - x1) < 0;
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.hex2rgb = function(hex) {
	if(hex == null) return [0,0,0]; else return [(hex >> 16 & 255) / 255,(hex >> 8 & 255) / 255,(hex & 255) / 255];
};
openfl._internal.renderer.opengl.utils.GraphicsRenderer.hex2rgba = function(hex) {
	if(hex == null) return [1,1,1,1]; else return [(hex >> 16 & 255) / 255,(hex >> 8 & 255) / 255,(hex & 255) / 255,(hex >> 24 & 255) / 255];
};
openfl._internal.renderer.opengl.utils.GLStack = function(gl) {
	this.lastIndex = 0;
	this.gl = gl;
	this.buckets = [];
	this.lastIndex = 0;
};
$hxClasses["openfl._internal.renderer.opengl.utils.GLStack"] = openfl._internal.renderer.opengl.utils.GLStack;
openfl._internal.renderer.opengl.utils.GLStack.__name__ = ["openfl","_internal","renderer","opengl","utils","GLStack"];
openfl._internal.renderer.opengl.utils.GLStack.prototype = {
	reset: function() {
		this.buckets = [];
		this.lastIndex = 0;
	}
	,upload: function() {
		var _g = 0;
		var _g1 = this.buckets;
		while(_g < _g1.length) {
			var bucket = _g1[_g];
			++_g;
			if(bucket.dirty) bucket.upload();
		}
	}
	,__class__: openfl._internal.renderer.opengl.utils.GLStack
};
openfl._internal.renderer.opengl.utils.GLBucket = function(gl) {
	this.uploadTileBuffer = true;
	this.textureSmooth = true;
	this.textureRepeat = false;
	this.data = [];
	this.fillIndex = 0;
	this.gl = gl;
	this.color = [0,0,0];
	this.lastIndex = 0;
	this.alpha = 1;
	this.dirty = true;
	this.mode = openfl._internal.renderer.opengl.utils.BucketMode.Fill;
	this.textureMatrix = new openfl.geom.Matrix();
	this.textureTL = new openfl.geom.Point();
	this.textureBR = new openfl.geom.Point(1,1);
};
$hxClasses["openfl._internal.renderer.opengl.utils.GLBucket"] = openfl._internal.renderer.opengl.utils.GLBucket;
openfl._internal.renderer.opengl.utils.GLBucket.__name__ = ["openfl","_internal","renderer","opengl","utils","GLBucket"];
openfl._internal.renderer.opengl.utils.GLBucket.prototype = {
	getData: function() {
		var result = null;
		var remove = false;
		var _g = 0;
		var _g1 = this.data;
		while(_g < _g1.length) {
			var d = _g1[_g];
			++_g;
			if(d.destroyed) {
				result = d;
				remove = true;
				break;
			}
		}
		if(result == null) result = new openfl._internal.renderer.opengl.utils.GLBucketData(this.gl);
		result.destroyed = false;
		result.parent = this;
		if(remove) HxOverrides.remove(this.data,result);
		this.data.push(result);
		return result;
	}
	,reset: function() {
		var _g = 0;
		var _g1 = this.data;
		while(_g < _g1.length) {
			var d = _g1[_g];
			++_g;
			d.destroy();
		}
		this.fillIndex = 0;
		this.uploadTileBuffer = true;
		this.graphicType = openfl._internal.renderer.opengl.utils.GraphicType.Polygon;
	}
	,upload: function() {
		if(this.uploadTileBuffer) {
			if(this.tileBuffer == null) {
				this.tileBuffer = this.gl.createBuffer();
				this.tile = [0,0,0,0,4096,0,1,0,0,4096,0,1,4096,4096,1,1];
				this.glTile = new Int16Array(this.tile);
			}
			this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.tileBuffer);
			this.gl.bufferData(this.gl.ARRAY_BUFFER,this.glTile,this.gl.STATIC_DRAW);
			this.uploadTileBuffer = false;
		}
		var _g = 0;
		var _g1 = this.data;
		while(_g < _g1.length) {
			var d = _g1[_g];
			++_g;
			if(!d.destroyed) d.upload();
		}
		this.dirty = false;
	}
	,__class__: openfl._internal.renderer.opengl.utils.GLBucket
};
openfl._internal.renderer.opengl.utils.GLBucketData = function(gl,initLine) {
	if(initLine == null) initLine = true;
	this.destroyed = false;
	this.rawIndices = false;
	this.stride = 0;
	this.rawVerts = false;
	this.lastVertsSize = 0;
	this.glStart = 0;
	this.glLength = 0;
	this.gl = gl;
	this.drawMode = gl.TRIANGLE_STRIP;
	this.verts = [];
	this.vertsBuffer = gl.createBuffer();
	this.indices = [];
	this.indexBuffer = gl.createBuffer();
	if(initLine) this.line = new openfl._internal.renderer.opengl.utils.GLBucketData(gl,false);
};
$hxClasses["openfl._internal.renderer.opengl.utils.GLBucketData"] = openfl._internal.renderer.opengl.utils.GLBucketData;
openfl._internal.renderer.opengl.utils.GLBucketData.__name__ = ["openfl","_internal","renderer","opengl","utils","GLBucketData"];
openfl._internal.renderer.opengl.utils.GLBucketData.prototype = {
	destroy: function() {
		this.destroyed = true;
		this.verts = [];
		this.indices = [];
		this.glLength = 0;
		this.glStart = 0;
		this.stride = 0;
		this.rawVerts = false;
		this.rawIndices = false;
		if(this.line != null) this.line.destroy();
	}
	,upload: function() {
		if(this.rawVerts && this.glVerts != null && this.glVerts.length > 0 || this.verts.length > 0) {
			if(!this.rawVerts) this.glVerts = new Float32Array(this.verts);
			this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.vertsBuffer);
			if(this.glVerts.length <= this.lastVertsSize) {
				var end = this.glLength * 4 * this.stride;
				if(this.glLength > 0 && this.lastVertsSize > end) {
					var view = this.glVerts.subarray(0,end);
					this.gl.bufferSubData(this.gl.ARRAY_BUFFER,0,view);
					view = null;
				} else this.gl.bufferSubData(this.gl.ARRAY_BUFFER,0,this.glVerts);
			} else {
				this.gl.bufferData(this.gl.ARRAY_BUFFER,this.glVerts,this.gl.STREAM_DRAW);
				this.lastVertsSize = this.glVerts.length;
			}
		}
		if(this.glLength == 0 && (this.rawIndices && this.glIndices != null && this.glIndices.length > 0 || this.indices.length > 0)) {
			if(!this.rawIndices) this.glIndices = new Uint16Array(this.indices);
			this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,this.indexBuffer);
			this.gl.bufferData(this.gl.ELEMENT_ARRAY_BUFFER,this.glIndices,this.gl.STREAM_DRAW);
		}
		if(this.line != null) this.line.upload();
	}
	,__class__: openfl._internal.renderer.opengl.utils.GLBucketData
};
openfl._internal.renderer.opengl.utils.BucketMode = $hxClasses["openfl._internal.renderer.opengl.utils.BucketMode"] = { __ename__ : ["openfl","_internal","renderer","opengl","utils","BucketMode"], __constructs__ : ["None","Fill","PatternFill","Line","PatternLine","DrawTriangles","DrawTiles"] };
openfl._internal.renderer.opengl.utils.BucketMode.None = ["None",0];
openfl._internal.renderer.opengl.utils.BucketMode.None.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.None.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.BucketMode.Fill = ["Fill",1];
openfl._internal.renderer.opengl.utils.BucketMode.Fill.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.Fill.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.BucketMode.PatternFill = ["PatternFill",2];
openfl._internal.renderer.opengl.utils.BucketMode.PatternFill.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.PatternFill.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.BucketMode.Line = ["Line",3];
openfl._internal.renderer.opengl.utils.BucketMode.Line.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.Line.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.BucketMode.PatternLine = ["PatternLine",4];
openfl._internal.renderer.opengl.utils.BucketMode.PatternLine.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.PatternLine.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.BucketMode.DrawTriangles = ["DrawTriangles",5];
openfl._internal.renderer.opengl.utils.BucketMode.DrawTriangles.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.DrawTriangles.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.BucketMode.DrawTiles = ["DrawTiles",6];
openfl._internal.renderer.opengl.utils.BucketMode.DrawTiles.toString = $estr;
openfl._internal.renderer.opengl.utils.BucketMode.DrawTiles.__enum__ = openfl._internal.renderer.opengl.utils.BucketMode;
openfl._internal.renderer.opengl.utils.GLGraphicsData = function(gl) {
	this.indices = [];
	this.data = [];
	this.lastIndex = 0;
	this.mode = 0;
	this.dirty = true;
	this.alpha = 1.0;
	this.tint = [1.0,1.0,1.0];
	this.gl = gl;
	this.dataBuffer = gl.createBuffer();
	this.indexBuffer = gl.createBuffer();
};
$hxClasses["openfl._internal.renderer.opengl.utils.GLGraphicsData"] = openfl._internal.renderer.opengl.utils.GLGraphicsData;
openfl._internal.renderer.opengl.utils.GLGraphicsData.__name__ = ["openfl","_internal","renderer","opengl","utils","GLGraphicsData"];
openfl._internal.renderer.opengl.utils.GLGraphicsData.prototype = {
	reset: function() {
		this.data = [];
		this.indices = [];
		this.lastIndex = 0;
	}
	,upload: function() {
		this.glData = new Float32Array(this.data);
		this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.dataBuffer);
		this.gl.bufferData(this.gl.ARRAY_BUFFER,this.glData,this.gl.STATIC_DRAW);
		this.glIndices = new Uint16Array(this.indices);
		this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,this.indexBuffer);
		this.gl.bufferData(this.gl.ELEMENT_ARRAY_BUFFER,this.glIndices,this.gl.STATIC_DRAW);
		this.dirty = false;
	}
	,__class__: openfl._internal.renderer.opengl.utils.GLGraphicsData
};
openfl._internal.renderer.opengl.utils.PolyK = function() { };
$hxClasses["openfl._internal.renderer.opengl.utils.PolyK"] = openfl._internal.renderer.opengl.utils.PolyK;
openfl._internal.renderer.opengl.utils.PolyK.__name__ = ["openfl","_internal","renderer","opengl","utils","PolyK"];
openfl._internal.renderer.opengl.utils.PolyK.triangulate = function(p) {
	var sign = true;
	var n = p.length >> 1;
	if(n < 3) return [];
	var tgs = [];
	var avl;
	var _g = [];
	var _g1 = 0;
	while(_g1 < n) {
		var i = _g1++;
		_g.push(i);
	}
	avl = _g;
	var i1 = 0;
	var al = n;
	var earFound = false;
	while(al > 3) {
		var i0 = avl[i1 % al];
		var i11 = avl[(i1 + 1) % al];
		var i2 = avl[(i1 + 2) % al];
		var ax = p[2 * i0];
		var ay = p[2 * i0 + 1];
		var bx = p[2 * i11];
		var by = p[2 * i11 + 1];
		var cx = p[2 * i2];
		var cy = p[2 * i2 + 1];
		earFound = false;
		if(openfl._internal.renderer.opengl.utils.PolyK._convex(ax,ay,bx,by,cx,cy,sign)) {
			earFound = true;
			var _g11 = 0;
			while(_g11 < al) {
				var j = _g11++;
				var vi = avl[j];
				if(vi == i0 || vi == i11 || vi == i2) continue;
				if(openfl._internal.renderer.opengl.utils.PolyK._PointInTriangle(p[2 * vi],p[2 * vi + 1],ax,ay,bx,by,cx,cy)) {
					earFound = false;
					break;
				}
			}
		}
		if(earFound) {
			tgs.push(i0);
			tgs.push(i11);
			tgs.push(i2);
			avl.splice((i1 + 1) % al,1);
			al--;
			i1 = 0;
		} else if(i1++ > 3 * al) {
			if(sign) {
				tgs = [];
				var _g12 = [];
				var _g2 = 0;
				while(_g2 < n) {
					var k = _g2++;
					_g12.push(k);
				}
				avl = _g12;
				i1 = 0;
				al = n;
				sign = false;
			} else return [];
		}
	}
	tgs.push(avl[0]);
	tgs.push(avl[1]);
	tgs.push(avl[2]);
	return tgs;
};
openfl._internal.renderer.opengl.utils.PolyK._PointInTriangle = function(px,py,ax,ay,bx,by,cx,cy) {
	var v0x = cx - ax | 0;
	var v0y = cy - ay | 0;
	var v1x = bx - ax | 0;
	var v1y = by - ay | 0;
	var v2x = px - ax | 0;
	var v2y = py - ay | 0;
	var dot00 = v0x * v0x + v0y * v0y;
	var dot01 = v0x * v1x + v0y * v1y;
	var dot02 = v0x * v2x + v0y * v2y;
	var dot11 = v1x * v1x + v1y * v1y;
	var dot12 = v1x * v2x + v1y * v2y;
	var invDenom = 1 / (dot00 * dot11 - dot01 * dot01);
	var u = (dot11 * dot02 - dot01 * dot12) * invDenom;
	var v = (dot00 * dot12 - dot01 * dot02) * invDenom;
	return u >= 0 && v >= 0 && u + v < 1;
};
openfl._internal.renderer.opengl.utils.PolyK._convex = function(ax,ay,bx,by,cx,cy,sign) {
	return (ay - by) * (cx - bx) + (bx - ax) * (cy - by) >= 0 == sign;
};
openfl._internal.renderer.opengl.utils.GraphicType = $hxClasses["openfl._internal.renderer.opengl.utils.GraphicType"] = { __ename__ : ["openfl","_internal","renderer","opengl","utils","GraphicType"], __constructs__ : ["Polygon","Rectangle","Circle","Ellipse","DrawTriangles","DrawTiles"] };
openfl._internal.renderer.opengl.utils.GraphicType.Polygon = ["Polygon",0];
openfl._internal.renderer.opengl.utils.GraphicType.Polygon.toString = $estr;
openfl._internal.renderer.opengl.utils.GraphicType.Polygon.__enum__ = openfl._internal.renderer.opengl.utils.GraphicType;
openfl._internal.renderer.opengl.utils.GraphicType.Rectangle = function(rounded) { var $x = ["Rectangle",1,rounded]; $x.__enum__ = openfl._internal.renderer.opengl.utils.GraphicType; $x.toString = $estr; return $x; };
openfl._internal.renderer.opengl.utils.GraphicType.Circle = ["Circle",2];
openfl._internal.renderer.opengl.utils.GraphicType.Circle.toString = $estr;
openfl._internal.renderer.opengl.utils.GraphicType.Circle.__enum__ = openfl._internal.renderer.opengl.utils.GraphicType;
openfl._internal.renderer.opengl.utils.GraphicType.Ellipse = ["Ellipse",3];
openfl._internal.renderer.opengl.utils.GraphicType.Ellipse.toString = $estr;
openfl._internal.renderer.opengl.utils.GraphicType.Ellipse.__enum__ = openfl._internal.renderer.opengl.utils.GraphicType;
openfl._internal.renderer.opengl.utils.GraphicType.DrawTriangles = function(vertices,indices,uvtData,culling,colors,blendMode) { var $x = ["DrawTriangles",4,vertices,indices,uvtData,culling,colors,blendMode]; $x.__enum__ = openfl._internal.renderer.opengl.utils.GraphicType; $x.toString = $estr; return $x; };
openfl._internal.renderer.opengl.utils.GraphicType.DrawTiles = function(sheet,tileData,smooth,flags,count) { var $x = ["DrawTiles",5,sheet,tileData,smooth,flags,count]; $x.__enum__ = openfl._internal.renderer.opengl.utils.GraphicType; $x.toString = $estr; return $x; };
openfl._internal.renderer.opengl.utils._GraphicsRenderer = {};
openfl._internal.renderer.opengl.utils._GraphicsRenderer.RenderMode_Impl_ = function() { };
$hxClasses["openfl._internal.renderer.opengl.utils._GraphicsRenderer.RenderMode_Impl_"] = openfl._internal.renderer.opengl.utils._GraphicsRenderer.RenderMode_Impl_;
openfl._internal.renderer.opengl.utils._GraphicsRenderer.RenderMode_Impl_.__name__ = ["openfl","_internal","renderer","opengl","utils","_GraphicsRenderer","RenderMode_Impl_"];
openfl._internal.renderer.opengl.utils.MaskManager = function(gl) {
	this.maskStack = [];
	this.maskPosition = 0;
	this.setContext(gl);
	this.reverse = false;
	this.count = 0;
};
$hxClasses["openfl._internal.renderer.opengl.utils.MaskManager"] = openfl._internal.renderer.opengl.utils.MaskManager;
openfl._internal.renderer.opengl.utils.MaskManager.__name__ = ["openfl","_internal","renderer","opengl","utils","MaskManager"];
openfl._internal.renderer.opengl.utils.MaskManager.prototype = {
	destroy: function() {
		this.maskStack = null;
		this.gl = null;
	}
	,popMask: function(maskData,renderSession) {
		var gl = this.gl;
		renderSession.stencilManager.popStencil(maskData,maskData._webGL[openfl._internal.renderer.opengl.GLRenderer.glContextId].data[0],renderSession);
	}
	,pushMask: function(maskData,renderSession) {
		var gl = renderSession.gl;
		if(maskData.dirty) openfl._internal.renderer.opengl.utils.GraphicsRenderer.updateGraphics(maskData,gl);
		if(maskData._webGL[openfl._internal.renderer.opengl.GLRenderer.glContextId].data.length == 0) return;
		renderSession.stencilManager.pushStencil(maskData,maskData._webGL[openfl._internal.renderer.opengl.GLRenderer.glContextId].data[0],renderSession);
	}
	,setContext: function(gl) {
		this.gl = gl;
	}
	,__class__: openfl._internal.renderer.opengl.utils.MaskManager
};
openfl._internal.renderer.opengl.utils.ShaderManager = function(gl) {
	this.maxAttibs = 10;
	this.attribState = [];
	this.tempAttribState = [];
	this.shaderMap = [];
	var _g1 = 0;
	var _g = this.maxAttibs;
	while(_g1 < _g) {
		var i = _g1++;
		this.attribState[i] = false;
	}
	this.setContext(gl);
};
$hxClasses["openfl._internal.renderer.opengl.utils.ShaderManager"] = openfl._internal.renderer.opengl.utils.ShaderManager;
openfl._internal.renderer.opengl.utils.ShaderManager.__name__ = ["openfl","_internal","renderer","opengl","utils","ShaderManager"];
openfl._internal.renderer.opengl.utils.ShaderManager.prototype = {
	destroy: function() {
		this.attribState = null;
		this.tempAttribState = null;
		this.primitiveShader.destroy();
		this.defaultShader.destroy();
		this.fastShader.destroy();
		this.stripShader.destroy();
		this.fillShader.destroy();
		this.patternFillShader.destroy();
		this.drawTrianglesShader.destroy();
		this.gl = null;
	}
	,setAttribs: function(attribs) {
		var _g1 = 0;
		var _g = this.tempAttribState.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.tempAttribState[i] = false;
		}
		var _g11 = 0;
		var _g2 = attribs.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			var attribId = attribs[i1];
			this.tempAttribState[attribId] = true;
		}
		var gl = this.gl;
		var _g12 = 0;
		var _g3 = this.attribState.length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			if(this.attribState[i2] != this.tempAttribState[i2]) {
				this.attribState[i2] = this.tempAttribState[i2];
				if(this.tempAttribState[i2]) gl.enableVertexAttribArray(i2); else gl.disableVertexAttribArray(i2);
			}
		}
	}
	,setContext: function(gl) {
		this.gl = gl;
		this.primitiveShader = new openfl._internal.renderer.opengl.shaders.PrimitiveShader(gl);
		this.complexPrimitiveShader = new openfl._internal.renderer.opengl.shaders.ComplexPrimitiveShader(gl);
		this.defaultShader = new openfl._internal.renderer.opengl.shaders.DefaultShader(gl);
		this.fastShader = new openfl._internal.renderer.opengl.shaders.FastShader(gl);
		this.stripShader = new openfl._internal.renderer.opengl.shaders.StripShader(gl);
		this.fillShader = new openfl._internal.renderer.opengl.shaders.FillShader(gl);
		this.patternFillShader = new openfl._internal.renderer.opengl.shaders.PatternFillShader(gl);
		this.drawTrianglesShader = new openfl._internal.renderer.opengl.shaders.DrawTrianglesShader(gl);
		this.setShader(this.defaultShader);
	}
	,setShader: function(shader) {
		if(this._currentId == shader._UID) return false;
		this._currentId = shader._UID;
		this.currentShader = shader;
		this.gl.useProgram(shader.program);
		this.setAttribs(shader.attributes);
		return true;
	}
	,__class__: openfl._internal.renderer.opengl.utils.ShaderManager
};
openfl._internal.renderer.opengl.utils.SpriteBatch = function(gl) {
	this.states = [];
	this.vertSize = 6;
	this.size = Math.floor(Math.pow(2,16) / this.vertSize);
	var numVerts = this.size * 4 * this.vertSize;
	var numIndices = this.size * 6;
	this.vertices = new Float32Array(numVerts);
	this.indices = new Uint16Array(numIndices);
	this.lastIndexCount = 0;
	var i = 0;
	var j = 0;
	while(i < numIndices) {
		this.indices[i] = j;
		this.indices[i + 1] = j + 1;
		this.indices[i + 2] = j + 2;
		this.indices[i + 3] = j;
		this.indices[i + 4] = j + 2;
		this.indices[i + 5] = j + 3;
		i += 6;
		j += 4;
	}
	this.drawing = false;
	this.currentBatchSize = 0;
	this.currentBaseTexture = null;
	this.setContext(gl);
	this.dirty = true;
	this.currentState = new openfl._internal.renderer.opengl.utils._SpriteBatch.State();
};
$hxClasses["openfl._internal.renderer.opengl.utils.SpriteBatch"] = openfl._internal.renderer.opengl.utils.SpriteBatch;
openfl._internal.renderer.opengl.utils.SpriteBatch.__name__ = ["openfl","_internal","renderer","opengl","utils","SpriteBatch"];
openfl._internal.renderer.opengl.utils.SpriteBatch.prototype = {
	begin: function(renderSession) {
		this.renderSession = renderSession;
		this.shader = renderSession.shaderManager.defaultShader;
		this.drawing = true;
		this.start();
	}
	,destroy: function() {
		this.vertices = null;
		this.indices = null;
		this.gl.deleteBuffer(this.vertexBuffer);
		this.gl.deleteBuffer(this.indexBuffer);
		this.currentBaseTexture = null;
		this.gl = null;
	}
	,end: function() {
		this.flush();
		this.drawing = false;
	}
	,flush: function() {
		if(this.currentBatchSize == 0) return;
		var gl = this.gl;
		this.renderSession.shaderManager.setShader(this.renderSession.shaderManager.defaultShader);
		if(this.dirty) {
			this.dirty = false;
			gl.activeTexture(gl.TEXTURE0);
			gl.bindBuffer(gl.ARRAY_BUFFER,this.vertexBuffer);
			gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,this.indexBuffer);
			var projection = this.renderSession.projection;
			gl.uniform2f(this.shader.projectionVector,projection.x,projection.y);
			var stride = this.vertSize * 4;
			gl.vertexAttribPointer(this.shader.aVertexPosition,2,gl.FLOAT,false,stride,0);
			gl.vertexAttribPointer(this.shader.aTextureCoord,2,gl.FLOAT,false,stride,8);
			gl.vertexAttribPointer(this.shader.colorAttribute,2,gl.FLOAT,false,stride,16);
		}
		if(this.currentBatchSize > this.size * 0.5) gl.bufferSubData(gl.ARRAY_BUFFER,0,this.vertices); else {
			var view = this.vertices.subarray(0,this.currentBatchSize * 4 * this.vertSize);
			gl.bufferSubData(gl.ARRAY_BUFFER,0,view);
		}
		var nextState;
		var batchSize = 0;
		var start = 0;
		this.currentState.texture = null;
		this.currentState.textureSmooth = true;
		this.currentState.blendMode = this.renderSession.blendModeManager.currentBlendMode;
		var j = this.currentBatchSize;
		var _g = 0;
		while(_g < j) {
			var i = _g++;
			nextState = this.states[i];
			if(this.currentState.texture != nextState.texture || this.currentState.blendMode != nextState.blendMode) {
				this.renderBatch(this.currentState,batchSize,start);
				start = i;
				batchSize = 0;
				this.currentState.texture = nextState.texture;
				this.currentState.textureSmooth = nextState.textureSmooth;
				this.currentState.blendMode = nextState.blendMode;
				this.renderSession.blendModeManager.setBlendMode(this.currentState.blendMode);
			}
			batchSize++;
		}
		this.renderBatch(this.currentState,batchSize,start);
		this.currentBatchSize = 0;
	}
	,render: function(sprite) {
		var bitmapData = sprite.bitmapData;
		var texture = bitmapData.getTexture(this.gl);
		if(bitmapData == null) return;
		if(this.currentBatchSize >= this.size) {
			this.flush();
			this.currentState.texture = texture;
		}
		var uvs = bitmapData.__uvData;
		if(uvs == null) return;
		var alpha = sprite.__worldAlpha;
		var tint = 16777215;
		var aX = 0;
		var aY = 0;
		var index = this.currentBatchSize * 4 * this.vertSize;
		this.fillVertices(index,aX,aY,bitmapData.width,bitmapData.height,tint,alpha,uvs,sprite.__worldTransform);
		this.setState(this.currentBatchSize,texture,null,sprite.blendMode);
		this.currentBatchSize++;
	}
	,renderCachedGraphics: function(object) {
		var cachedTexture = object.__graphics.__cachedTexture;
		if(cachedTexture == null) return;
		if(this.currentBatchSize >= this.size) {
			this.flush();
			this.currentBaseTexture = cachedTexture.texture;
		}
		var alpha = object.__worldAlpha;
		var tint = 16777215;
		var aX = 0;
		var aY = 0;
		var uvs = new openfl.display.TextureUvs();
		uvs.x0 = 0;
		uvs.y0 = 1;
		uvs.x1 = 1;
		uvs.y1 = 1;
		uvs.x2 = 1;
		uvs.y2 = 0;
		uvs.x3 = 0;
		uvs.y3 = 0;
		var index = this.currentBatchSize * 4 * this.vertSize;
		var worldTransform = object.__worldTransform.clone();
		worldTransform.__translateTransformed(new openfl.geom.Point(object.__graphics.__bounds.x,object.__graphics.__bounds.y));
		this.fillVertices(index,aX,aY,cachedTexture.width,cachedTexture.height,tint,alpha,uvs,worldTransform);
		this.setState(this.currentBatchSize,cachedTexture.texture,null,object.blendMode);
		this.currentBatchSize++;
	}
	,renderTiles: function(object,sheet,tileData,smooth,flags,count) {
		if(count == null) count = -1;
		if(flags == null) flags = 0;
		if(smooth == null) smooth = false;
		var texture = sheet.__bitmap.getTexture(this.gl);
		if(texture == null) return;
		var useScale = (flags & 1) > 0;
		var useRotation = (flags & 2) > 0;
		var useTransform = (flags & 16) > 0;
		var useRGB = (flags & 4) > 0;
		var useAlpha = (flags & 8) > 0;
		var useRect = (flags & 32) > 0;
		var useOrigin = (flags & 64) > 0;
		var blendMode;
		var _g = flags & 983040;
		switch(_g) {
		case 65536:
			blendMode = openfl.display.BlendMode.ADD;
			break;
		case 131072:
			blendMode = openfl.display.BlendMode.MULTIPLY;
			break;
		case 262144:
			blendMode = openfl.display.BlendMode.SCREEN;
			break;
		default:
			blendMode = openfl.display.BlendMode.NORMAL;
		}
		if(useTransform) {
			useScale = false;
			useRotation = false;
		}
		var scaleIndex = 0;
		var rotationIndex = 0;
		var rgbIndex = 0;
		var alphaIndex = 0;
		var transformIndex = 0;
		var numValues = 3;
		if(useRect) if(useOrigin) numValues = 8; else numValues = 6;
		if(useScale) {
			scaleIndex = numValues;
			numValues++;
		}
		if(useRotation) {
			rotationIndex = numValues;
			numValues++;
		}
		if(useTransform) {
			transformIndex = numValues;
			numValues += 4;
		}
		if(useRGB) {
			rgbIndex = numValues;
			numValues += 3;
		}
		if(useAlpha) {
			alphaIndex = numValues;
			numValues++;
		}
		var totalCount = tileData.length;
		if(count >= 0 && totalCount > count) totalCount = count;
		var itemCount = totalCount / numValues | 0;
		var iIndex = 0;
		var tileID = -1;
		var rect = sheet.__rectTile;
		var tileUV = sheet.__rectUV;
		var center = sheet.__point;
		var x = 0.0;
		var y = 0.0;
		var alpha = 1.0;
		var tint = 16777215;
		var scale = 1.0;
		var rotation = 0.0;
		var cosTheta = 1.0;
		var sinTheta = 0.0;
		var a = 0.0;
		var b = 0.0;
		var c = 0.0;
		var d = 0.0;
		var tx = 0.0;
		var ty = 0.0;
		var ox = 0.0;
		var oy = 0.0;
		var matrix = new openfl.geom.Matrix();
		var oMatrix = object.__worldTransform;
		var uvs = new openfl.display.TextureUvs();
		var bIndex = 0;
		while(iIndex < totalCount) {
			if(this.currentBatchSize >= this.size) {
				this.flush();
				this.currentBaseTexture = texture;
			}
			x = tileData[iIndex];
			y = tileData[iIndex + 1];
			if(useRect) {
				tileID = -1;
				rect.x = tileData[iIndex + 2];
				rect.y = tileData[iIndex + 3];
				rect.width = tileData[iIndex + 4];
				rect.height = tileData[iIndex + 5];
				if(useOrigin) {
					center.x = tileData[iIndex + 6];
					center.y = tileData[iIndex + 7];
				} else {
					center.x = 0;
					center.y = 0;
				}
				tileUV.setTo(rect.get_left() / sheet.__bitmap.width,rect.get_top() / sheet.__bitmap.height,rect.get_right() / sheet.__bitmap.width,rect.get_bottom() / sheet.__bitmap.height);
			} else {
				tileID = (tileData[iIndex + 2] == null?0:tileData[iIndex + 2]) | 0;
				rect = sheet.__tileRects[tileID];
				center = sheet.__centerPoints[tileID];
				tileUV = sheet.__tileUVs[tileID];
			}
			if(rect != null && rect.width > 0 && rect.height > 0 && center != null) {
				alpha = 1;
				tint = 16777215;
				a = 1;
				b = 0;
				c = 0;
				d = 1;
				tx = 0;
				ty = 0;
				scale = 1.0;
				rotation = 0.0;
				cosTheta = 1.0;
				sinTheta = 0.0;
				matrix.identity();
				if(useAlpha) alpha = tileData[iIndex + alphaIndex];
				if(useRGB) tint = (tileData[iIndex + rgbIndex] * 255 | 0) << 16 | (tileData[iIndex + rgbIndex + 1] * 255 | 0) << 8 | (tileData[iIndex + rgbIndex + 2] * 255 | 0);
				if(useScale) scale = tileData[iIndex + scaleIndex];
				if(useRotation) {
					rotation = tileData[iIndex + rotationIndex];
					cosTheta = Math.cos(rotation);
					sinTheta = Math.sin(rotation);
				}
				if(useTransform) {
					a = tileData[iIndex + transformIndex];
					b = tileData[iIndex + transformIndex + 1];
					c = tileData[iIndex + transformIndex + 2];
					d = tileData[iIndex + transformIndex + 3];
				} else {
					a = scale * cosTheta;
					b = scale * sinTheta;
					c = -b;
					d = a;
				}
				ox = center.x * a + center.y * c;
				oy = center.x * b + center.y * d;
				tx = x - ox;
				ty = y - oy;
				matrix.a = a * oMatrix.a + b * oMatrix.c;
				matrix.b = a * oMatrix.b + b * oMatrix.d;
				matrix.c = c * oMatrix.a + d * oMatrix.c;
				matrix.d = c * oMatrix.b + d * oMatrix.d;
				matrix.tx = tx * oMatrix.a + ty * oMatrix.c;
				matrix.ty = tx * oMatrix.b + ty * oMatrix.d;
				uvs.x0 = tileUV.x;
				uvs.y0 = tileUV.y;
				uvs.x1 = tileUV.width;
				uvs.y1 = tileUV.y;
				uvs.x2 = tileUV.width;
				uvs.y2 = tileUV.height;
				uvs.x3 = tileUV.x;
				uvs.y3 = tileUV.height;
				bIndex = this.currentBatchSize * 4 * this.vertSize;
				this.fillVertices(bIndex,0,0,rect.width,rect.height,tint,alpha,uvs,matrix);
				this.setState(this.currentBatchSize,texture,smooth,blendMode);
				this.currentBatchSize++;
			}
			iIndex += numValues;
		}
	}
	,fillVertices: function(index,aX,aY,width,height,tint,alpha,uvs,matrix) {
		var w0;
		var w1;
		var h0;
		var h1;
		w0 = width * (1 - aX);
		w1 = width * -aX;
		h0 = height * (1 - aY);
		h1 = height * -aY;
		var a = matrix.a;
		var b = matrix.b;
		var c = matrix.c;
		var d = matrix.d;
		var tx = matrix.tx;
		var ty = matrix.ty;
		this.vertices[index++] = a * w1 + c * h1 + tx;
		this.vertices[index++] = d * h1 + b * w1 + ty;
		this.vertices[index++] = uvs.x0;
		this.vertices[index++] = uvs.y0;
		this.vertices[index++] = alpha;
		this.vertices[index++] = tint;
		this.vertices[index++] = a * w0 + c * h1 + tx;
		this.vertices[index++] = d * h1 + b * w0 + ty;
		this.vertices[index++] = uvs.x1;
		this.vertices[index++] = uvs.y1;
		this.vertices[index++] = alpha;
		this.vertices[index++] = tint;
		this.vertices[index++] = a * w0 + c * h0 + tx;
		this.vertices[index++] = d * h0 + b * w0 + ty;
		this.vertices[index++] = uvs.x2;
		this.vertices[index++] = uvs.y2;
		this.vertices[index++] = alpha;
		this.vertices[index++] = tint;
		this.vertices[index++] = a * w1 + c * h0 + tx;
		this.vertices[index++] = d * h0 + b * w1 + ty;
		this.vertices[index++] = uvs.x3;
		this.vertices[index++] = uvs.y3;
		this.vertices[index++] = alpha;
		this.vertices[index++] = tint;
	}
	,setState: function(index,texture,smooth,blendMode) {
		if(smooth == null) smooth = true;
		var state = this.states[this.currentBatchSize];
		if(state == null) state = this.states[this.currentBatchSize] = new openfl._internal.renderer.opengl.utils._SpriteBatch.State();
		state.texture = texture;
		state.textureSmooth = smooth;
		state.blendMode = blendMode;
	}
	,renderBatch: function(state,size,startIndex) {
		if(size == 0) return;
		this.gl.bindTexture(this.gl.TEXTURE_2D,state.texture);
		if(state.textureSmooth) {
			this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MAG_FILTER,this.gl.LINEAR);
			this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.LINEAR);
		} else {
			this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MAG_FILTER,this.gl.NEAREST);
			this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.NEAREST);
		}
		this.gl.drawElements(this.gl.TRIANGLES,size * 6,this.gl.UNSIGNED_SHORT,startIndex * 6 * 2);
		this.renderSession.drawCount++;
	}
	,renderTilingSprite: function(tilingSprite) {
	}
	,setContext: function(gl) {
		this.gl = gl;
		this.vertexBuffer = gl.createBuffer();
		this.indexBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,this.indexBuffer);
		gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,this.indices,gl.STATIC_DRAW);
		gl.bindBuffer(gl.ARRAY_BUFFER,this.vertexBuffer);
		gl.bufferData(gl.ARRAY_BUFFER,this.vertices,gl.DYNAMIC_DRAW);
		this.currentBlendMode = null;
	}
	,start: function() {
		this.dirty = true;
	}
	,stop: function() {
		this.flush();
	}
	,__class__: openfl._internal.renderer.opengl.utils.SpriteBatch
};
openfl._internal.renderer.opengl.utils._SpriteBatch = {};
openfl._internal.renderer.opengl.utils._SpriteBatch.State = function() {
	this.textureSmooth = true;
};
$hxClasses["openfl._internal.renderer.opengl.utils._SpriteBatch.State"] = openfl._internal.renderer.opengl.utils._SpriteBatch.State;
openfl._internal.renderer.opengl.utils._SpriteBatch.State.__name__ = ["openfl","_internal","renderer","opengl","utils","_SpriteBatch","State"];
openfl._internal.renderer.opengl.utils._SpriteBatch.State.prototype = {
	__class__: openfl._internal.renderer.opengl.utils._SpriteBatch.State
};
openfl._internal.renderer.opengl.utils.StencilManager = function(gl) {
	this.stencilStack = [];
	this.bucketStack = [];
	this.setContext(gl);
	this.reverse = true;
	this.count = 0;
};
$hxClasses["openfl._internal.renderer.opengl.utils.StencilManager"] = openfl._internal.renderer.opengl.utils.StencilManager;
openfl._internal.renderer.opengl.utils.StencilManager.__name__ = ["openfl","_internal","renderer","opengl","utils","StencilManager"];
openfl._internal.renderer.opengl.utils.StencilManager.prototype = {
	prepareGraphics: function(bucketData,renderSession,projection,translationMatrix) {
		var offset = renderSession.offset;
		var shader = renderSession.shaderManager.fillShader;
		renderSession.shaderManager.setShader(shader);
		this.gl.uniformMatrix3fv(shader.translationMatrix,false,translationMatrix);
		this.gl.uniform2f(shader.projectionVector,projection.x,-projection.y);
		this.gl.uniform2f(shader.offsetVector,-offset.x,-offset.y);
		this.gl.bindBuffer(this.gl.ARRAY_BUFFER,bucketData.vertsBuffer);
		this.gl.vertexAttribPointer(shader.aVertexPosition,2,this.gl.FLOAT,false,8,0);
		this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,bucketData.indexBuffer);
	}
	,pushBucket: function(bucket,renderSession,projection,translationMatrix) {
		if(this.bucketStack.length == 0) {
			this.gl.enable(this.gl.STENCIL_TEST);
			this.gl.clear(this.gl.STENCIL_BUFFER_BIT);
			this.gl.stencilMask(255);
		}
		this.bucketStack.push(bucket);
		this.gl.colorMask(false,false,false,false);
		this.gl.stencilFunc(this.gl.NEVER,1,255);
		this.gl.stencilOp(this.gl.INVERT,this.gl.KEEP,this.gl.KEEP);
		this.gl.clear(this.gl.STENCIL_BUFFER_BIT);
		var _g = 0;
		var _g1 = bucket.data;
		while(_g < _g1.length) {
			var bucketData = _g1[_g];
			++_g;
			if(bucketData.destroyed) continue;
			this.prepareGraphics(bucketData,renderSession,projection,translationMatrix);
			this.gl.drawElements(bucketData.drawMode,bucketData.glIndices.length,this.gl.UNSIGNED_SHORT,0);
		}
		this.gl.colorMask(true,true,true,true);
		this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.KEEP);
		this.gl.stencilFunc(this.gl.EQUAL,255,255);
	}
	,popBucket: function(object,bucket,renderSession) {
		this.bucketStack.pop();
		if(this.bucketStack.length == 0) this.gl.disable(this.gl.STENCIL_TEST);
	}
	,bindGraphics: function(object,glData,renderSession) {
		var graphics = object.__graphics;
		var projection = renderSession.projection;
		var offset = renderSession.offset;
		if(glData.mode == 1) {
			var shader = renderSession.shaderManager.complexPrimitiveShader;
			renderSession.shaderManager.setShader(shader);
			this.gl.uniformMatrix3fv(shader.translationMatrix,false,object.__worldTransform.toArray(true));
			this.gl.uniform2f(shader.projectionVector,projection.x,-projection.y);
			this.gl.uniform2f(shader.offsetVector,-offset.x,-offset.y);
			this.gl.uniform3fv(shader.tintColor,new Float32Array([1.,1.,1.]));
			this.gl.uniform3fv(shader.color,new Float32Array(glData.tint));
			this.gl.uniform1f(shader.alpha,object.__worldAlpha * glData.alpha);
			this.gl.bindBuffer(this.gl.ARRAY_BUFFER,glData.dataBuffer);
			this.gl.vertexAttribPointer(shader.aVertexPosition,2,this.gl.FLOAT,false,8,0);
			this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,glData.indexBuffer);
		} else {
			var shader1 = renderSession.shaderManager.primitiveShader;
			renderSession.shaderManager.setShader(shader1);
			this.gl.uniformMatrix3fv(shader1.translationMatrix,false,object.__worldTransform.toArray(true));
			this.gl.uniform2f(shader1.projectionVector,projection.x,-projection.y);
			this.gl.uniform2f(shader1.offsetVector,-offset.x,-offset.y);
			this.gl.uniform3fv(shader1.tintColor,new Float32Array([1.,1.,1.]));
			this.gl.uniform1f(shader1.alpha,object.__worldAlpha);
			this.gl.bindBuffer(this.gl.ARRAY_BUFFER,glData.dataBuffer);
			this.gl.vertexAttribPointer(shader1.aVertexPosition,2,this.gl.FLOAT,false,24,0);
			this.gl.vertexAttribPointer(shader1.colorAttribute,4,this.gl.FLOAT,false,24,8);
			this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,glData.indexBuffer);
		}
	}
	,destroy: function() {
		this.stencilStack = null;
		this.bucketStack = null;
		this.gl = null;
	}
	,popStencil: function(object,glData,renderSession) {
		this.stencilStack.pop();
		this.count--;
		if(this.stencilStack.length == 0) this.gl.disable(this.gl.STENCIL_TEST); else {
			var level = this.count;
			this.bindGraphics(object,glData,renderSession);
			this.gl.colorMask(false,false,false,false);
			if(glData.mode == 1) {
				this.reverse = !this.reverse;
				if(this.reverse) {
					this.gl.stencilFunc(this.gl.EQUAL,255 - (level + 1),255);
					this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.INCR);
				} else {
					this.gl.stencilFunc(this.gl.EQUAL,level + 1,255);
					this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.DECR);
				}
				this.gl.drawElements(this.gl.TRIANGLE_FAN,4,this.gl.UNSIGNED_SHORT,(glData.indices.length - 4) * 2);
				this.gl.stencilFunc(this.gl.ALWAYS,0,255);
				this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.INVERT);
				this.gl.drawElements(this.gl.TRIANGLE_FAN,glData.indices.length - 4,this.gl.UNSIGNED_SHORT,0);
				if(!this.reverse) this.gl.stencilFunc(this.gl.EQUAL,255 - level,255); else this.gl.stencilFunc(this.gl.EQUAL,level,255);
			} else {
				if(!this.reverse) {
					this.gl.stencilFunc(this.gl.EQUAL,255 - (level + 1),255);
					this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.INCR);
				} else {
					this.gl.stencilFunc(this.gl.EQUAL,level + 1,255);
					this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.DECR);
				}
				this.gl.drawElements(this.gl.TRIANGLE_STRIP,glData.indices.length,this.gl.UNSIGNED_SHORT,0);
				if(!this.reverse) this.gl.stencilFunc(this.gl.EQUAL,255 - level,255); else this.gl.stencilFunc(this.gl.EQUAL,level,255);
			}
			this.gl.colorMask(true,true,true,true);
			this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.KEEP);
		}
	}
	,pushStencil: function(object,glData,renderSession) {
		this.bindGraphics(object,glData,renderSession);
		if(this.stencilStack.length == 0) {
			this.gl.enable(this.gl.STENCIL_TEST);
			this.gl.clear(this.gl.STENCIL_BUFFER_BIT);
			this.reverse = true;
			this.count = 0;
		}
		this.stencilStack.push(glData);
		var level = this.count;
		this.gl.colorMask(false,false,false,false);
		this.gl.stencilFunc(this.gl.ALWAYS,0,255);
		this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.INVERT);
		if(glData.mode == 1) {
			this.gl.drawElements(this.gl.TRIANGLE_FAN,glData.indices.length - 4,this.gl.UNSIGNED_SHORT,0);
			if(this.reverse) {
				this.gl.stencilFunc(this.gl.EQUAL,255 - level,255);
				this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.DECR);
			} else {
				this.gl.stencilFunc(this.gl.EQUAL,level,255);
				this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.INCR);
			}
			this.gl.drawElements(this.gl.TRIANGLE_FAN,4,this.gl.UNSIGNED_SHORT,(glData.indices.length - 4) * 2);
			if(this.reverse) this.gl.stencilFunc(this.gl.EQUAL,255 - (level + 1),255); else this.gl.stencilFunc(this.gl.EQUAL,level + 1,255);
			this.reverse = !this.reverse;
		} else {
			if(!this.reverse) {
				this.gl.stencilFunc(this.gl.EQUAL,255 - level,255);
				this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.DECR);
			} else {
				this.gl.stencilFunc(this.gl.EQUAL,level,255);
				this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.INCR);
			}
			this.gl.drawElements(this.gl.TRIANGLE_STRIP,glData.indices.length,this.gl.UNSIGNED_SHORT,0);
			if(!this.reverse) this.gl.stencilFunc(this.gl.EQUAL,255 - (level + 1),255); else this.gl.stencilFunc(this.gl.EQUAL,level + 1,255);
		}
		this.gl.colorMask(true,true,true,true);
		this.gl.stencilOp(this.gl.KEEP,this.gl.KEEP,this.gl.KEEP);
		this.count++;
	}
	,setContext: function(gl) {
		this.gl = gl;
	}
	,__class__: openfl._internal.renderer.opengl.utils.StencilManager
};
openfl.display.Application = function() {
	this.__mouseOutStack = [];
	lime.app.Application.call(this);
	openfl.display.Application.__fixAndroidMath();
	openfl.Lib.application = this;
};
$hxClasses["openfl.display.Application"] = openfl.display.Application;
openfl.display.Application.__name__ = ["openfl","display","Application"];
openfl.display.Application.__fixAndroidMath = function() {
	if(window.navigator.userAgent.indexOf("Linux; U; Android 4") >= 0) {
		var sin = Math.sin;
		var cos = Math.cos;
		Math.sin = function(x) {
			if(x == 0) return 0; else return sin(x);
		};
		Math.cos = function(x1) {
			if(x1 == 0) return 1; else return cos(x1);
		};
	}
};
openfl.display.Application.__super__ = lime.app.Application;
openfl.display.Application.prototype = $extend(lime.app.Application.prototype,{
	convertKeyCode: function(keyCode) {
		switch(keyCode) {
		case 8:
			return 8;
		case 9:
			return 9;
		case 13:
			return 13;
		case 27:
			return 27;
		case 32:
			return 32;
		case 39:
			return 222;
		case 44:
			return 188;
		case 45:
			return 189;
		case 46:
			return 190;
		case 47:
			return 191;
		case 48:
			return 48;
		case 49:
			return 49;
		case 50:
			return 50;
		case 51:
			return 51;
		case 52:
			return 52;
		case 53:
			return 53;
		case 54:
			return 54;
		case 55:
			return 55;
		case 56:
			return 56;
		case 57:
			return 57;
		case 59:
			return 186;
		case 61:
			return 187;
		case 91:
			return 219;
		case 92:
			return 220;
		case 93:
			return 221;
		case 96:
			return 192;
		case 97:
			return 65;
		case 98:
			return 66;
		case 99:
			return 67;
		case 100:
			return 68;
		case 101:
			return 69;
		case 102:
			return 70;
		case 103:
			return 71;
		case 104:
			return 72;
		case 105:
			return 73;
		case 106:
			return 74;
		case 107:
			return 75;
		case 108:
			return 76;
		case 109:
			return 77;
		case 110:
			return 78;
		case 111:
			return 79;
		case 112:
			return 80;
		case 113:
			return 81;
		case 114:
			return 82;
		case 115:
			return 83;
		case 116:
			return 84;
		case 117:
			return 85;
		case 118:
			return 86;
		case 119:
			return 87;
		case 120:
			return 88;
		case 121:
			return 89;
		case 122:
			return 90;
		case 127:
			return 46;
		case 1073741881:
			return 20;
		case 1073741882:
			return 112;
		case 1073741883:
			return 113;
		case 1073741884:
			return 114;
		case 1073741885:
			return 115;
		case 1073741886:
			return 116;
		case 1073741887:
			return 117;
		case 1073741888:
			return 118;
		case 1073741889:
			return 119;
		case 1073741890:
			return 120;
		case 1073741891:
			return 121;
		case 1073741892:
			return 122;
		case 1073741893:
			return 123;
		case 1073741897:
			return 45;
		case 1073741898:
			return 36;
		case 1073741899:
			return 33;
		case 1073741901:
			return 35;
		case 1073741902:
			return 34;
		case 1073741903:
			return 39;
		case 1073741904:
			return 37;
		case 1073741905:
			return 40;
		case 1073741906:
			return 38;
		case 1073741908:
			return 111;
		case 1073741909:
			return 106;
		case 1073741910:
			return 109;
		case 1073741911:
			return 107;
		case 1073741912:
			return 108;
		case 1073741913:
			return 97;
		case 1073741914:
			return 98;
		case 1073741915:
			return 99;
		case 1073741916:
			return 100;
		case 1073741917:
			return 101;
		case 1073741918:
			return 102;
		case 1073741919:
			return 103;
		case 1073741920:
			return 104;
		case 1073741921:
			return 105;
		case 1073741922:
			return 96;
		case 1073741923:
			return 110;
		case 1073741928:
			return 124;
		case 1073741929:
			return 125;
		case 1073741930:
			return 126;
		case 1073742048:
			return 17;
		case 1073742049:
			return 16;
		case 1073742050:
			return 18;
		case 1073742052:
			return 17;
		case 1073742053:
			return 16;
		case 1073742054:
			return 18;
		default:
			return keyCode;
		}
	}
	,create: function(config) {
		lime.app.Application.prototype.create.call(this,config);
		this.stage = new openfl.display.Stage(this.windows[0].width,this.windows[0].height,config.background);
		this.stage.addChild(openfl.Lib.current);
		this.stage.align = openfl.display.StageAlign.TOP_LEFT;
		this.stage.scaleMode = openfl.display.StageScaleMode.NO_SCALE;
	}
	,onKey: function(event) {
		var stack = new Array();
		if(this.stage.__focus == null) this.stage.__getInteractive(stack); else this.stage.__focus.__getInteractive(stack);
		if(stack.length > 0) {
			stack.reverse();
			this.stage.__fireEvent(event,stack);
		}
	}
	,onKeyDown: function(keyCode,modifier) {
		var keyCode1 = this.convertKeyCode(keyCode);
		var charCode = keyCode1;
		this.onKey(new openfl.events.KeyboardEvent(openfl.events.KeyboardEvent.KEY_DOWN,true,false,charCode,keyCode1,null,lime.ui._KeyModifier.KeyModifier_Impl_.get_ctrlKey(modifier),lime.ui._KeyModifier.KeyModifier_Impl_.get_altKey(modifier),lime.ui._KeyModifier.KeyModifier_Impl_.get_shiftKey(modifier),lime.ui._KeyModifier.KeyModifier_Impl_.get_metaKey(modifier)));
	}
	,onKeyUp: function(keyCode,modifier) {
		var keyCode1 = this.convertKeyCode(keyCode);
		var charCode = keyCode1;
		this.onKey(new openfl.events.KeyboardEvent(openfl.events.KeyboardEvent.KEY_UP,true,false,charCode,keyCode1,null,lime.ui._KeyModifier.KeyModifier_Impl_.get_ctrlKey(modifier),lime.ui._KeyModifier.KeyModifier_Impl_.get_altKey(modifier),lime.ui._KeyModifier.KeyModifier_Impl_.get_shiftKey(modifier),lime.ui._KeyModifier.KeyModifier_Impl_.get_metaKey(modifier)));
	}
	,onMouse: function(type,x,y,button) {
		if(button > 2) return;
		this.stage.__mouseX = x;
		this.stage.__mouseY = y;
		var stack = [];
		var target = null;
		var targetPoint = new openfl.geom.Point(x,y);
		if(this.stage.__hitTest(x,y,false,stack,true)) target = stack[stack.length - 1]; else {
			target = this.stage;
			stack = [this.stage];
		}
		this.stage.__fireEvent(openfl.events.MouseEvent.__create(type,button,target == this.stage?targetPoint:target.globalToLocal(targetPoint),target),stack);
		var clickType;
		switch(type) {
		case openfl.events.MouseEvent.MOUSE_UP:
			clickType = openfl.events.MouseEvent.CLICK;
			break;
		case openfl.events.MouseEvent.MIDDLE_MOUSE_UP:
			clickType = openfl.events.MouseEvent.MIDDLE_CLICK;
			break;
		case openfl.events.MouseEvent.RIGHT_MOUSE_UP:
			clickType = openfl.events.MouseEvent.RIGHT_CLICK;
			break;
		default:
			clickType = null;
		}
		if(clickType != null) {
			this.stage.__fireEvent(openfl.events.MouseEvent.__create(clickType,button,target == this.stage?targetPoint:target.globalToLocal(targetPoint),target),stack);
			if(type == openfl.events.MouseEvent.MOUSE_UP && (js.Boot.__cast(target , openfl.display.InteractiveObject)).doubleClickEnabled) {
				var currentTime = openfl.Lib.getTimer();
				if(currentTime - this.__lastClickTime < 500) {
					this.stage.__fireEvent(openfl.events.MouseEvent.__create(openfl.events.MouseEvent.DOUBLE_CLICK,button,target == this.stage?targetPoint:target.globalToLocal(targetPoint),target),stack);
					this.__lastClickTime = 0;
				} else this.__lastClickTime = currentTime;
			}
		}
		if(js.Boot.__instanceof(target,openfl.display.Sprite)) {
			var targetSprite = target;
			if(targetSprite.buttonMode && targetSprite.useHandCursor) lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.POINTER); else lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.ARROW);
		} else if(js.Boot.__instanceof(target,openfl.display.SimpleButton)) {
			var targetButton = target;
			if(targetButton.useHandCursor) lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.POINTER); else lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.ARROW);
		} else if(js.Boot.__instanceof(target,openfl.text.TextField)) {
			var targetTextField = target;
			if(targetTextField.type == openfl.text.TextFieldType.INPUT) lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.TEXT); else lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.ARROW);
		} else lime.ui.Mouse.set_cursor(lime.ui.MouseCursor.ARROW);
		var _g = 0;
		var _g1 = this.__mouseOutStack;
		while(_g < _g1.length) {
			var target1 = _g1[_g];
			++_g;
			if(HxOverrides.indexOf(stack,target1,0) == -1) {
				HxOverrides.remove(this.__mouseOutStack,target1);
				var localPoint = target1.globalToLocal(targetPoint);
				target1.dispatchEvent(new openfl.events.MouseEvent(openfl.events.MouseEvent.MOUSE_OUT,false,false,localPoint.x,localPoint.y,target1));
			}
		}
		var _g2 = 0;
		while(_g2 < stack.length) {
			var target2 = stack[_g2];
			++_g2;
			if(HxOverrides.indexOf(this.__mouseOutStack,target2,0) == -1) {
				if(target2.hasEventListener(openfl.events.MouseEvent.MOUSE_OVER)) {
					var localPoint1 = target2.globalToLocal(targetPoint);
					target2.dispatchEvent(new openfl.events.MouseEvent(openfl.events.MouseEvent.MOUSE_OVER,false,false,localPoint1.x,localPoint1.y,target2));
				}
				if(target2.hasEventListener(openfl.events.MouseEvent.MOUSE_OUT)) this.__mouseOutStack.push(target2);
			}
		}
		if(this.stage.__dragObject != null) this.stage.__drag(targetPoint);
	}
	,onMouseDown: function(x,y,button) {
		var type;
		switch(button) {
		case 1:
			type = openfl.events.MouseEvent.MIDDLE_MOUSE_DOWN;
			break;
		case 2:
			type = openfl.events.MouseEvent.RIGHT_MOUSE_DOWN;
			break;
		default:
			type = openfl.events.MouseEvent.MOUSE_DOWN;
		}
		this.onMouse(type,x,y,button);
	}
	,onMouseMove: function(x,y,button) {
		this.onMouse(openfl.events.MouseEvent.MOUSE_MOVE,x,y,0);
	}
	,onMouseUp: function(x,y,button) {
		var type;
		switch(button) {
		case 1:
			type = openfl.events.MouseEvent.MIDDLE_MOUSE_UP;
			break;
		case 2:
			type = openfl.events.MouseEvent.RIGHT_MOUSE_UP;
			break;
		default:
			type = openfl.events.MouseEvent.MOUSE_UP;
		}
		this.onMouse(type,x,y,button);
	}
	,onTouch: function(type,x,y,id) {
		var point = new openfl.geom.Point(x,y);
		this.stage.__mouseX = point.x;
		this.stage.__mouseY = point.y;
		var __stack = [];
		var mouseType;
		switch(type) {
		case "touchBegin":
			mouseType = openfl.events.MouseEvent.MOUSE_DOWN;
			break;
		case "touchMove":
			mouseType = openfl.events.MouseEvent.MOUSE_MOVE;
			break;
		case "touchEnd":
			mouseType = openfl.events.MouseEvent.MOUSE_UP;
			break;
		default:
			mouseType = null;
		}
		if(this.stage.__hitTest(x,y,false,__stack,true)) {
			var target = __stack[__stack.length - 1];
			var localPoint = target.globalToLocal(point);
			var touchEvent = openfl.events.TouchEvent.__create(type,null,localPoint,target);
			touchEvent.touchPointID = id;
			touchEvent.isPrimaryTouchPoint = true;
			var mouseEvent = openfl.events.MouseEvent.__create(mouseType,0,localPoint,target);
			mouseEvent.buttonDown = type != "touchEnd";
			this.stage.__fireEvent(touchEvent,__stack);
			this.stage.__fireEvent(mouseEvent,__stack);
		} else {
			var touchEvent1 = openfl.events.TouchEvent.__create(type,null,point,this.stage);
			touchEvent1.touchPointID = id;
			touchEvent1.isPrimaryTouchPoint = true;
			var mouseEvent1 = openfl.events.MouseEvent.__create(mouseType,0,point,this.stage);
			mouseEvent1.buttonDown = type != "touchEnd";
			this.stage.__fireEvent(touchEvent1,[this.stage]);
			this.stage.__fireEvent(mouseEvent1,[this.stage]);
		}
		if(type == "touchMove" && this.stage.__dragObject != null) this.stage.__drag(point);
	}
	,onTouchMove: function(x,y,id) {
		this.onTouch("touchMove",x,y,id);
	}
	,onTouchEnd: function(x,y,id) {
		this.onTouch("touchEnd",x,y,id);
	}
	,onTouchStart: function(x,y,id) {
		this.onTouch("touchBegin",x,y,id);
	}
	,onWindowActivate: function() {
		var event = new openfl.events.Event(openfl.events.Event.ACTIVATE);
		this.stage.__broadcast(event,true);
	}
	,onWindowDeactivate: function() {
		var event = new openfl.events.Event(openfl.events.Event.DEACTIVATE);
		this.stage.__broadcast(event,true);
	}
	,onWindowResize: function(width,height) {
		this.stage.stageWidth = width;
		this.stage.stageHeight = height;
		var event = new openfl.events.Event(openfl.events.Event.RESIZE);
		this.stage.__broadcast(event,false);
	}
	,render: function(context) {
		this.stage.__render(context);
	}
	,__class__: openfl.display.Application
});
openfl.display.Bitmap = function(bitmapData,pixelSnapping,smoothing) {
	if(smoothing == null) smoothing = false;
	openfl.display.DisplayObjectContainer.call(this);
	this.bitmapData = bitmapData;
	this.pixelSnapping = pixelSnapping;
	this.smoothing = smoothing;
	if(pixelSnapping == null) this.pixelSnapping = openfl.display.PixelSnapping.AUTO;
};
$hxClasses["openfl.display.Bitmap"] = openfl.display.Bitmap;
openfl.display.Bitmap.__name__ = ["openfl","display","Bitmap"];
openfl.display.Bitmap.__super__ = openfl.display.DisplayObjectContainer;
openfl.display.Bitmap.prototype = $extend(openfl.display.DisplayObjectContainer.prototype,{
	__getBounds: function(rect,matrix) {
		if(this.bitmapData != null) {
			var bounds = new openfl.geom.Rectangle(0,0,this.bitmapData.width,this.bitmapData.height);
			bounds = bounds.transform(this.__worldTransform);
			rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
		}
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly) {
		if(!this.get_visible() || this.bitmapData == null) return false;
		var point = this.globalToLocal(new openfl.geom.Point(x,y));
		if(point.x > 0 && point.y > 0 && point.x <= this.bitmapData.width && point.y <= this.bitmapData.height) {
			if(stack != null && !interactiveOnly) stack.push(this);
			return true;
		}
		return false;
	}
	,__renderCanvas: function(renderSession) {
		openfl._internal.renderer.canvas.CanvasBitmap.render(this,renderSession);
	}
	,__renderDOM: function(renderSession) {
		if(this.stage != null && this.__worldVisible && this.__renderable && this.bitmapData != null && this.bitmapData.__isValid) {
			if(this.bitmapData.__image.buffer.__srcImage != null) openfl._internal.renderer.dom.DOMBitmap.renderImage(this,renderSession); else openfl._internal.renderer.dom.DOMBitmap.renderCanvas(this,renderSession);
		} else {
			if(this.__image != null) {
				renderSession.element.removeChild(this.__image);
				this.__image = null;
				this.__style = null;
			}
			if(this.__canvas != null) {
				renderSession.element.removeChild(this.__canvas);
				this.__canvas = null;
				this.__style = null;
			}
		}
	}
	,__renderGL: function(renderSession) {
		openfl._internal.renderer.opengl.GLBitmap.render(this,renderSession);
	}
	,__renderMask: function(renderSession) {
		renderSession.context.rect(0,0,this.get_width(),this.get_height());
	}
	,get_height: function() {
		if(this.bitmapData != null) return this.bitmapData.height * this.get_scaleY();
		return 0;
	}
	,set_height: function(value) {
		if(this.bitmapData != null) {
			if(value != this.bitmapData.height) {
				if(!this.__transformDirty) {
					this.__transformDirty = true;
					openfl.display.DisplayObject.__worldTransformDirty++;
				}
				this.set_scaleY(value / this.bitmapData.height);
			}
			return value;
		}
		return 0;
	}
	,get_width: function() {
		if(this.bitmapData != null) return this.bitmapData.width * this.get_scaleX();
		return 0;
	}
	,set_width: function(value) {
		if(this.bitmapData != null) {
			if(value != this.bitmapData.width) {
				if(!this.__transformDirty) {
					this.__transformDirty = true;
					openfl.display.DisplayObject.__worldTransformDirty++;
				}
				this.set_scaleX(value / this.bitmapData.width);
			}
			return value;
		}
		return 0;
	}
	,__class__: openfl.display.Bitmap
});
openfl.display.TextureUvs = function() {
	this.y3 = 0;
	this.y2 = 0;
	this.y1 = 0;
	this.y0 = 0;
	this.x3 = 0;
	this.x2 = 0;
	this.x1 = 0;
	this.x0 = 0;
};
$hxClasses["openfl.display.TextureUvs"] = openfl.display.TextureUvs;
openfl.display.TextureUvs.__name__ = ["openfl","display","TextureUvs"];
openfl.display.TextureUvs.prototype = {
	__class__: openfl.display.TextureUvs
};
openfl.display.BlendMode = $hxClasses["openfl.display.BlendMode"] = { __ename__ : ["openfl","display","BlendMode"], __constructs__ : ["ADD","ALPHA","DARKEN","DIFFERENCE","ERASE","HARDLIGHT","INVERT","LAYER","LIGHTEN","MULTIPLY","NORMAL","OVERLAY","SCREEN","SUBTRACT"] };
openfl.display.BlendMode.ADD = ["ADD",0];
openfl.display.BlendMode.ADD.toString = $estr;
openfl.display.BlendMode.ADD.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.ALPHA = ["ALPHA",1];
openfl.display.BlendMode.ALPHA.toString = $estr;
openfl.display.BlendMode.ALPHA.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.DARKEN = ["DARKEN",2];
openfl.display.BlendMode.DARKEN.toString = $estr;
openfl.display.BlendMode.DARKEN.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.DIFFERENCE = ["DIFFERENCE",3];
openfl.display.BlendMode.DIFFERENCE.toString = $estr;
openfl.display.BlendMode.DIFFERENCE.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.ERASE = ["ERASE",4];
openfl.display.BlendMode.ERASE.toString = $estr;
openfl.display.BlendMode.ERASE.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.HARDLIGHT = ["HARDLIGHT",5];
openfl.display.BlendMode.HARDLIGHT.toString = $estr;
openfl.display.BlendMode.HARDLIGHT.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.INVERT = ["INVERT",6];
openfl.display.BlendMode.INVERT.toString = $estr;
openfl.display.BlendMode.INVERT.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.LAYER = ["LAYER",7];
openfl.display.BlendMode.LAYER.toString = $estr;
openfl.display.BlendMode.LAYER.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.LIGHTEN = ["LIGHTEN",8];
openfl.display.BlendMode.LIGHTEN.toString = $estr;
openfl.display.BlendMode.LIGHTEN.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.MULTIPLY = ["MULTIPLY",9];
openfl.display.BlendMode.MULTIPLY.toString = $estr;
openfl.display.BlendMode.MULTIPLY.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.NORMAL = ["NORMAL",10];
openfl.display.BlendMode.NORMAL.toString = $estr;
openfl.display.BlendMode.NORMAL.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.OVERLAY = ["OVERLAY",11];
openfl.display.BlendMode.OVERLAY.toString = $estr;
openfl.display.BlendMode.OVERLAY.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.SCREEN = ["SCREEN",12];
openfl.display.BlendMode.SCREEN.toString = $estr;
openfl.display.BlendMode.SCREEN.__enum__ = openfl.display.BlendMode;
openfl.display.BlendMode.SUBTRACT = ["SUBTRACT",13];
openfl.display.BlendMode.SUBTRACT.toString = $estr;
openfl.display.BlendMode.SUBTRACT.__enum__ = openfl.display.BlendMode;
openfl.display.CapsStyle = $hxClasses["openfl.display.CapsStyle"] = { __ename__ : ["openfl","display","CapsStyle"], __constructs__ : ["NONE","ROUND","SQUARE"] };
openfl.display.CapsStyle.NONE = ["NONE",0];
openfl.display.CapsStyle.NONE.toString = $estr;
openfl.display.CapsStyle.NONE.__enum__ = openfl.display.CapsStyle;
openfl.display.CapsStyle.ROUND = ["ROUND",1];
openfl.display.CapsStyle.ROUND.toString = $estr;
openfl.display.CapsStyle.ROUND.__enum__ = openfl.display.CapsStyle;
openfl.display.CapsStyle.SQUARE = ["SQUARE",2];
openfl.display.CapsStyle.SQUARE.toString = $estr;
openfl.display.CapsStyle.SQUARE.__enum__ = openfl.display.CapsStyle;
openfl.display.DirectRenderer = function(type) {
	if(type == null) type = "DirectRenderer";
	openfl.display.DisplayObject.call(this);
};
$hxClasses["openfl.display.DirectRenderer"] = openfl.display.DirectRenderer;
openfl.display.DirectRenderer.__name__ = ["openfl","display","DirectRenderer"];
openfl.display.DirectRenderer.__super__ = openfl.display.DisplayObject;
openfl.display.DirectRenderer.prototype = $extend(openfl.display.DisplayObject.prototype,{
	get_render: function() {
		return this.__render;
	}
	,set_render: function(value) {
		return this.__render = value;
	}
	,__class__: openfl.display.DirectRenderer
	,__properties__: $extend(openfl.display.DisplayObject.prototype.__properties__,{set_render:"set_render",get_render:"get_render"})
});
openfl.display.FrameLabel = function(name,frame) {
	openfl.events.EventDispatcher.call(this);
	this.__name = name;
	this.__frame = frame;
};
$hxClasses["openfl.display.FrameLabel"] = openfl.display.FrameLabel;
openfl.display.FrameLabel.__name__ = ["openfl","display","FrameLabel"];
openfl.display.FrameLabel.__super__ = openfl.events.EventDispatcher;
openfl.display.FrameLabel.prototype = $extend(openfl.events.EventDispatcher.prototype,{
	get_frame: function() {
		return this.__frame;
	}
	,get_name: function() {
		return this.__name;
	}
	,__class__: openfl.display.FrameLabel
	,__properties__: {get_name:"get_name",get_frame:"get_frame"}
});
openfl.display.GradientType = $hxClasses["openfl.display.GradientType"] = { __ename__ : ["openfl","display","GradientType"], __constructs__ : ["RADIAL","LINEAR"] };
openfl.display.GradientType.RADIAL = ["RADIAL",0];
openfl.display.GradientType.RADIAL.toString = $estr;
openfl.display.GradientType.RADIAL.__enum__ = openfl.display.GradientType;
openfl.display.GradientType.LINEAR = ["LINEAR",1];
openfl.display.GradientType.LINEAR.toString = $estr;
openfl.display.GradientType.LINEAR.__enum__ = openfl.display.GradientType;
openfl.display.Graphics = function() {
	this.__visible = true;
	this.__glStack = [];
	this.__dirty = true;
	this.__commands = [];
	this.__commands = new Array();
	this.__halfStrokeWidth = 0;
	this.__positionX = 0;
	this.__positionY = 0;
};
$hxClasses["openfl.display.Graphics"] = openfl.display.Graphics;
openfl.display.Graphics.__name__ = ["openfl","display","Graphics"];
openfl.display.Graphics.prototype = {
	beginBitmapFill: function(bitmap,matrix,repeat,smooth) {
		if(smooth == null) smooth = false;
		if(repeat == null) repeat = true;
		this.__commands.push(openfl.display.DrawCommand.BeginBitmapFill(bitmap,matrix != null?new openfl.geom.Matrix(matrix.a,matrix.b,matrix.c,matrix.d,matrix.tx,matrix.ty):null,repeat,smooth));
		this.__visible = true;
	}
	,beginFill: function(color,alpha) {
		if(alpha == null) alpha = 1;
		if(color == null) color = 0;
		this.__commands.push(openfl.display.DrawCommand.BeginFill(color & 16777215,alpha));
		if(alpha > 0) this.__visible = true;
	}
	,beginGradientFill: function(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio) {
		openfl.Lib.notImplemented("Graphics.beginGradientFill");
	}
	,clear: function() {
		this.__commands = new Array();
		this.__halfStrokeWidth = 0;
		if(this.__bounds != null) {
			this.__dirty = true;
			this.__transformDirty = true;
			this.__bounds = null;
		}
		this.__visible = false;
	}
	,copyFrom: function(sourceGraphics) {
		this.__bounds = sourceGraphics.__bounds.clone();
		this.__commands = sourceGraphics.__commands.slice();
		this.__dirty = true;
		this.__halfStrokeWidth = sourceGraphics.__halfStrokeWidth;
		this.__positionX = sourceGraphics.__positionX;
		this.__positionY = sourceGraphics.__positionY;
		this.__transformDirty = true;
		this.__visible = sourceGraphics.__visible;
	}
	,cubicCurveTo: function(controlX1,controlY1,controlX2,controlY2,anchorX,anchorY) {
		this.__inflateBounds(this.__positionX - this.__halfStrokeWidth,this.__positionY - this.__halfStrokeWidth);
		this.__inflateBounds(this.__positionX + this.__halfStrokeWidth,this.__positionY + this.__halfStrokeWidth);
		this.__inflateBounds(controlX1,controlY1);
		this.__inflateBounds(controlX2,controlY2);
		this.__positionX = anchorX;
		this.__positionY = anchorY;
		this.__inflateBounds(this.__positionX - this.__halfStrokeWidth,this.__positionY - this.__halfStrokeWidth);
		this.__inflateBounds(this.__positionX + this.__halfStrokeWidth,this.__positionY + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.CubicCurveTo(controlX1,controlY1,controlX2,controlY2,anchorX,anchorY));
		this.__dirty = true;
	}
	,curveTo: function(controlX,controlY,anchorX,anchorY) {
		this.__inflateBounds(this.__positionX - this.__halfStrokeWidth,this.__positionY - this.__halfStrokeWidth);
		this.__inflateBounds(this.__positionX + this.__halfStrokeWidth,this.__positionY + this.__halfStrokeWidth);
		this.__inflateBounds(controlX,controlY);
		this.__positionX = anchorX;
		this.__positionY = anchorY;
		this.__inflateBounds(this.__positionX - this.__halfStrokeWidth,this.__positionY - this.__halfStrokeWidth);
		this.__inflateBounds(this.__positionX + this.__halfStrokeWidth,this.__positionY + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.CurveTo(controlX,controlY,anchorX,anchorY));
		this.__dirty = true;
	}
	,drawCircle: function(x,y,radius) {
		if(radius <= 0) return;
		this.__inflateBounds(x - radius - this.__halfStrokeWidth,y - radius - this.__halfStrokeWidth);
		this.__inflateBounds(x + radius + this.__halfStrokeWidth,y + radius + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.DrawCircle(x,y,radius));
		this.__dirty = true;
	}
	,drawEllipse: function(x,y,width,height) {
		if(width <= 0 || height <= 0) return;
		this.__inflateBounds(x - this.__halfStrokeWidth,y - this.__halfStrokeWidth);
		this.__inflateBounds(x + width + this.__halfStrokeWidth,y + height + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.DrawEllipse(x,y,width,height));
		this.__dirty = true;
	}
	,drawGraphicsData: function(graphicsData) {
		openfl.Lib.notImplemented("Graphics.drawGraphicsData");
	}
	,drawPath: function(commands,data,winding) {
		var dataIndex = 0;
		var _g = 0;
		while(_g < commands.length) {
			var command = commands.data[_g];
			++_g;
			switch(command) {
			case 1:
				this.moveTo(data.data[dataIndex],data.data[dataIndex + 1]);
				dataIndex += 2;
				break;
			case 2:
				this.lineTo(data.data[dataIndex],data.data[dataIndex + 1]);
				dataIndex += 2;
				break;
			case 3:
				this.curveTo(data.data[dataIndex],data.data[dataIndex + 1],data.data[dataIndex + 2],data.data[dataIndex + 3]);
				dataIndex += 4;
				break;
			case 6:
				this.cubicCurveTo(data.data[dataIndex],data.data[dataIndex + 1],data.data[dataIndex + 2],data.data[dataIndex + 3],data.data[dataIndex + 4],data.data[dataIndex + 5]);
				dataIndex += 6;
				break;
			default:
			}
		}
	}
	,drawRect: function(x,y,width,height) {
		if(width <= 0 || height <= 0) return;
		this.__inflateBounds(x - this.__halfStrokeWidth,y - this.__halfStrokeWidth);
		this.__inflateBounds(x + width + this.__halfStrokeWidth,y + height + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.DrawRect(x,y,width,height));
		this.__dirty = true;
	}
	,drawRoundRect: function(x,y,width,height,rx,ry) {
		if(ry == null) ry = -1;
		if(width <= 0 || height <= 0) return;
		this.__inflateBounds(x - this.__halfStrokeWidth,y - this.__halfStrokeWidth);
		this.__inflateBounds(x + width + this.__halfStrokeWidth,y + height + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.DrawRoundRect(x,y,width,height,rx,ry));
		this.__dirty = true;
	}
	,drawRoundRectComplex: function(x,y,width,height,topLeftRadius,topRightRadius,bottomLeftRadius,bottomRightRadius) {
		openfl.Lib.notImplemented("Graphics.drawRoundRectComplex");
	}
	,drawTiles: function(sheet,tileData,smooth,flags,count) {
		if(count == null) count = -1;
		if(flags == null) flags = 0;
		if(smooth == null) smooth = false;
		this.__inflateBounds(0,0);
		this.__inflateBounds(openfl.Lib.current.stage.stageWidth,openfl.Lib.current.stage.stageHeight);
		this.__commands.push(openfl.display.DrawCommand.DrawTiles(sheet,tileData,smooth,flags,count));
		this.__dirty = true;
		this.__visible = true;
	}
	,drawTriangles: function(vertices,indices,uvtData,culling,colors,blendMode) {
		if(blendMode == null) blendMode = 0;
		var vlen = vertices.length / 2 | 0;
		if(culling == null) culling = openfl.display.TriangleCulling.NONE;
		if(indices == null) {
			if(vlen % 3 != 0) throw new openfl.errors.ArgumentError("Not enough vertices to close a triangle.");
			var this1;
			this1 = new openfl.VectorData();
			var this2;
			this2 = new Array(0);
			this1.data = this2;
			this1.length = 0;
			this1.fixed = false;
			indices = this1;
			var _g = 0;
			while(_g < vlen) {
				var i = _g++;
				if(!indices.fixed) {
					indices.length++;
					if(indices.data.length < indices.length) {
						var data;
						var this3;
						this3 = new Array(indices.data.length + 10);
						data = this3;
						haxe.ds._Vector.Vector_Impl_.blit(indices.data,0,data,0,indices.data.length);
						indices.data = data;
					}
					indices.data[indices.length - 1] = i;
				}
				indices.length;
			}
		}
		this.__inflateBounds(0,0);
		var tmpx = Math.NEGATIVE_INFINITY;
		var tmpy = Math.NEGATIVE_INFINITY;
		var maxX = Math.NEGATIVE_INFINITY;
		var maxY = Math.NEGATIVE_INFINITY;
		var _g1 = 0;
		while(_g1 < vlen) {
			var i1 = _g1++;
			tmpx = vertices.data[i1 * 2];
			tmpy = vertices.data[i1 * 2 + 1];
			if(maxX < tmpx) maxX = tmpx;
			if(maxY < tmpy) maxY = tmpy;
		}
		this.__inflateBounds(maxX,maxY);
		this.__commands.push(openfl.display.DrawCommand.DrawTriangles(vertices,indices,uvtData,culling,colors,blendMode));
		this.__dirty = true;
		this.__visible = true;
	}
	,endFill: function() {
		this.__commands.push(openfl.display.DrawCommand.EndFill);
	}
	,lineBitmapStyle: function(bitmap,matrix,repeat,smooth) {
		if(smooth == null) smooth = false;
		if(repeat == null) repeat = true;
		openfl.Lib.notImplemented("Graphics.lineBitmapStyle");
	}
	,lineGradientStyle: function(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio) {
		openfl.Lib.notImplemented("Graphics.lineGradientStyle");
	}
	,lineStyle: function(thickness,color,alpha,pixelHinting,scaleMode,caps,joints,miterLimit) {
		if(thickness != null) this.__halfStrokeWidth = thickness / 2; else this.__halfStrokeWidth = 0;
		this.__commands.push(openfl.display.DrawCommand.LineStyle(thickness,color,alpha,pixelHinting,scaleMode,caps,joints,miterLimit));
		if(thickness != null) this.__visible = true;
	}
	,lineTo: function(x,y) {
		this.__inflateBounds(this.__positionX - this.__halfStrokeWidth,this.__positionY - this.__halfStrokeWidth);
		this.__inflateBounds(this.__positionX + this.__halfStrokeWidth,this.__positionY + this.__halfStrokeWidth);
		this.__positionX = x;
		this.__positionY = y;
		this.__inflateBounds(this.__positionX - this.__halfStrokeWidth,this.__positionY - this.__halfStrokeWidth);
		this.__inflateBounds(this.__positionX + this.__halfStrokeWidth,this.__positionY + this.__halfStrokeWidth);
		this.__commands.push(openfl.display.DrawCommand.LineTo(x,y));
		this.__dirty = true;
	}
	,moveTo: function(x,y) {
		this.__positionX = x;
		this.__positionY = y;
		this.__commands.push(openfl.display.DrawCommand.MoveTo(x,y));
	}
	,__getBounds: function(rect,matrix) {
		if(this.__bounds == null) return;
		var bounds = this.__bounds.clone().transform(matrix);
		rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
	}
	,__hitTest: function(x,y,shapeFlag,matrix) {
		if(this.__bounds == null) return false;
		var bounds = this.__bounds.clone().transform(matrix);
		return x > bounds.x && y > bounds.y && x <= bounds.get_right() && y <= bounds.get_bottom();
	}
	,__inflateBounds: function(x,y) {
		if(this.__bounds == null) {
			this.__bounds = new openfl.geom.Rectangle(x,y,0,0);
			this.__transformDirty = true;
			return;
		}
		if(x < this.__bounds.x) {
			this.__bounds.width += this.__bounds.x - x;
			this.__bounds.x = x;
			this.__transformDirty = true;
		}
		if(y < this.__bounds.y) {
			this.__bounds.height += this.__bounds.y - y;
			this.__bounds.y = y;
			this.__transformDirty = true;
		}
		if(x > this.__bounds.x + this.__bounds.width) this.__bounds.width = x - this.__bounds.x;
		if(y > this.__bounds.y + this.__bounds.height) this.__bounds.height = y - this.__bounds.y;
	}
	,__class__: openfl.display.Graphics
};
openfl.display.DrawCommand = $hxClasses["openfl.display.DrawCommand"] = { __ename__ : ["openfl","display","DrawCommand"], __constructs__ : ["BeginBitmapFill","BeginFill","CubicCurveTo","CurveTo","DrawCircle","DrawEllipse","DrawRect","DrawRoundRect","DrawTiles","DrawTriangles","EndFill","LineStyle","LineTo","MoveTo"] };
openfl.display.DrawCommand.BeginBitmapFill = function(bitmap,matrix,repeat,smooth) { var $x = ["BeginBitmapFill",0,bitmap,matrix,repeat,smooth]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.BeginFill = function(color,alpha) { var $x = ["BeginFill",1,color,alpha]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.CubicCurveTo = function(controlX1,controlY1,controlX2,controlY2,anchorX,anchorY) { var $x = ["CubicCurveTo",2,controlX1,controlY1,controlX2,controlY2,anchorX,anchorY]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.CurveTo = function(controlX,controlY,anchorX,anchorY) { var $x = ["CurveTo",3,controlX,controlY,anchorX,anchorY]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.DrawCircle = function(x,y,radius) { var $x = ["DrawCircle",4,x,y,radius]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.DrawEllipse = function(x,y,width,height) { var $x = ["DrawEllipse",5,x,y,width,height]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.DrawRect = function(x,y,width,height) { var $x = ["DrawRect",6,x,y,width,height]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.DrawRoundRect = function(x,y,width,height,rx,ry) { var $x = ["DrawRoundRect",7,x,y,width,height,rx,ry]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.DrawTiles = function(sheet,tileData,smooth,flags,count) { var $x = ["DrawTiles",8,sheet,tileData,smooth,flags,count]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.DrawTriangles = function(vertices,indices,uvtData,culling,colors,blendMode) { var $x = ["DrawTriangles",9,vertices,indices,uvtData,culling,colors,blendMode]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.EndFill = ["EndFill",10];
openfl.display.DrawCommand.EndFill.toString = $estr;
openfl.display.DrawCommand.EndFill.__enum__ = openfl.display.DrawCommand;
openfl.display.DrawCommand.LineStyle = function(thickness,color,alpha,pixelHinting,scaleMode,caps,joints,miterLimit) { var $x = ["LineStyle",11,thickness,color,alpha,pixelHinting,scaleMode,caps,joints,miterLimit]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.LineTo = function(x,y) { var $x = ["LineTo",12,x,y]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.DrawCommand.MoveTo = function(x,y) { var $x = ["MoveTo",13,x,y]; $x.__enum__ = openfl.display.DrawCommand; $x.toString = $estr; return $x; };
openfl.display.GraphicsPathCommand = function() { };
$hxClasses["openfl.display.GraphicsPathCommand"] = openfl.display.GraphicsPathCommand;
openfl.display.GraphicsPathCommand.__name__ = ["openfl","display","GraphicsPathCommand"];
openfl.display.GraphicsPathWinding = $hxClasses["openfl.display.GraphicsPathWinding"] = { __ename__ : ["openfl","display","GraphicsPathWinding"], __constructs__ : ["EVEN_ODD","NON_ZERO"] };
openfl.display.GraphicsPathWinding.EVEN_ODD = ["EVEN_ODD",0];
openfl.display.GraphicsPathWinding.EVEN_ODD.toString = $estr;
openfl.display.GraphicsPathWinding.EVEN_ODD.__enum__ = openfl.display.GraphicsPathWinding;
openfl.display.GraphicsPathWinding.NON_ZERO = ["NON_ZERO",1];
openfl.display.GraphicsPathWinding.NON_ZERO.toString = $estr;
openfl.display.GraphicsPathWinding.NON_ZERO.__enum__ = openfl.display.GraphicsPathWinding;
openfl.display.IGraphicsData = function() { };
$hxClasses["openfl.display.IGraphicsData"] = openfl.display.IGraphicsData;
openfl.display.IGraphicsData.__name__ = ["openfl","display","IGraphicsData"];
openfl.display.IGraphicsData.prototype = {
	__class__: openfl.display.IGraphicsData
};
openfl.display.GraphicsDataType = $hxClasses["openfl.display.GraphicsDataType"] = { __ename__ : ["openfl","display","GraphicsDataType"], __constructs__ : ["STROKE","SOLID","GRADIENT","PATH","BITMAP","END"] };
openfl.display.GraphicsDataType.STROKE = ["STROKE",0];
openfl.display.GraphicsDataType.STROKE.toString = $estr;
openfl.display.GraphicsDataType.STROKE.__enum__ = openfl.display.GraphicsDataType;
openfl.display.GraphicsDataType.SOLID = ["SOLID",1];
openfl.display.GraphicsDataType.SOLID.toString = $estr;
openfl.display.GraphicsDataType.SOLID.__enum__ = openfl.display.GraphicsDataType;
openfl.display.GraphicsDataType.GRADIENT = ["GRADIENT",2];
openfl.display.GraphicsDataType.GRADIENT.toString = $estr;
openfl.display.GraphicsDataType.GRADIENT.__enum__ = openfl.display.GraphicsDataType;
openfl.display.GraphicsDataType.PATH = ["PATH",3];
openfl.display.GraphicsDataType.PATH.toString = $estr;
openfl.display.GraphicsDataType.PATH.__enum__ = openfl.display.GraphicsDataType;
openfl.display.GraphicsDataType.BITMAP = ["BITMAP",4];
openfl.display.GraphicsDataType.BITMAP.toString = $estr;
openfl.display.GraphicsDataType.BITMAP.__enum__ = openfl.display.GraphicsDataType;
openfl.display.GraphicsDataType.END = ["END",5];
openfl.display.GraphicsDataType.END.toString = $estr;
openfl.display.GraphicsDataType.END.__enum__ = openfl.display.GraphicsDataType;
openfl.display.InterpolationMethod = $hxClasses["openfl.display.InterpolationMethod"] = { __ename__ : ["openfl","display","InterpolationMethod"], __constructs__ : ["RGB","LINEAR_RGB"] };
openfl.display.InterpolationMethod.RGB = ["RGB",0];
openfl.display.InterpolationMethod.RGB.toString = $estr;
openfl.display.InterpolationMethod.RGB.__enum__ = openfl.display.InterpolationMethod;
openfl.display.InterpolationMethod.LINEAR_RGB = ["LINEAR_RGB",1];
openfl.display.InterpolationMethod.LINEAR_RGB.toString = $estr;
openfl.display.InterpolationMethod.LINEAR_RGB.__enum__ = openfl.display.InterpolationMethod;
openfl.display.JPEGEncoderOptions = function(quality) {
	if(quality == null) quality = 80;
	this.quality = quality;
};
$hxClasses["openfl.display.JPEGEncoderOptions"] = openfl.display.JPEGEncoderOptions;
openfl.display.JPEGEncoderOptions.__name__ = ["openfl","display","JPEGEncoderOptions"];
openfl.display.JPEGEncoderOptions.prototype = {
	__class__: openfl.display.JPEGEncoderOptions
};
openfl.display.JointStyle = $hxClasses["openfl.display.JointStyle"] = { __ename__ : ["openfl","display","JointStyle"], __constructs__ : ["MITER","ROUND","BEVEL"] };
openfl.display.JointStyle.MITER = ["MITER",0];
openfl.display.JointStyle.MITER.toString = $estr;
openfl.display.JointStyle.MITER.__enum__ = openfl.display.JointStyle;
openfl.display.JointStyle.ROUND = ["ROUND",1];
openfl.display.JointStyle.ROUND.toString = $estr;
openfl.display.JointStyle.ROUND.__enum__ = openfl.display.JointStyle;
openfl.display.JointStyle.BEVEL = ["BEVEL",2];
openfl.display.JointStyle.BEVEL.toString = $estr;
openfl.display.JointStyle.BEVEL.__enum__ = openfl.display.JointStyle;
openfl.display.LineScaleMode = $hxClasses["openfl.display.LineScaleMode"] = { __ename__ : ["openfl","display","LineScaleMode"], __constructs__ : ["HORIZONTAL","NONE","NORMAL","VERTICAL"] };
openfl.display.LineScaleMode.HORIZONTAL = ["HORIZONTAL",0];
openfl.display.LineScaleMode.HORIZONTAL.toString = $estr;
openfl.display.LineScaleMode.HORIZONTAL.__enum__ = openfl.display.LineScaleMode;
openfl.display.LineScaleMode.NONE = ["NONE",1];
openfl.display.LineScaleMode.NONE.toString = $estr;
openfl.display.LineScaleMode.NONE.__enum__ = openfl.display.LineScaleMode;
openfl.display.LineScaleMode.NORMAL = ["NORMAL",2];
openfl.display.LineScaleMode.NORMAL.toString = $estr;
openfl.display.LineScaleMode.NORMAL.__enum__ = openfl.display.LineScaleMode;
openfl.display.LineScaleMode.VERTICAL = ["VERTICAL",3];
openfl.display.LineScaleMode.VERTICAL.toString = $estr;
openfl.display.LineScaleMode.VERTICAL.__enum__ = openfl.display.LineScaleMode;
openfl.display.Loader = function() {
	openfl.display.Sprite.call(this);
	this.contentLoaderInfo = openfl.display.LoaderInfo.create(this);
};
$hxClasses["openfl.display.Loader"] = openfl.display.Loader;
openfl.display.Loader.__name__ = ["openfl","display","Loader"];
openfl.display.Loader.__super__ = openfl.display.Sprite;
openfl.display.Loader.prototype = $extend(openfl.display.Sprite.prototype,{
	close: function() {
		openfl.Lib.notImplemented("Loader.close");
	}
	,load: function(request,context) {
		var extension = "";
		var parts = request.url.split(".");
		if(parts.length > 0) extension = parts[parts.length - 1].toLowerCase();
		if(extension.indexOf("?") != -1) extension = extension.split("?")[0];
		var transparent = true;
		this.contentLoaderInfo.url = request.url;
		if(request.contentType == null && request.contentType != "") switch(extension) {
		case "swf":
			this.contentLoaderInfo.contentType = "application/x-shockwave-flash";
			break;
		case "jpg":case "jpeg":
			transparent = false;
			this.contentLoaderInfo.contentType = "image/jpeg";
			break;
		case "png":
			this.contentLoaderInfo.contentType = "image/png";
			break;
		case "gif":
			this.contentLoaderInfo.contentType = "image/gif";
			break;
		default:
			this.contentLoaderInfo.contentType = "application/x-www-form-urlencoded";
		} else this.contentLoaderInfo.contentType = request.contentType;
		openfl.display.BitmapData.fromFile(request.url,$bind(this,this.BitmapData_onLoad),$bind(this,this.BitmapData_onError));
	}
	,loadBytes: function(buffer) {
		openfl.display.BitmapData.fromBytes(buffer,null,$bind(this,this.BitmapData_onLoad));
	}
	,unload: function() {
		if(this.get_numChildren() > 0) {
			while(this.get_numChildren() > 0) this.removeChildAt(0);
			this.content = null;
			this.contentLoaderInfo.url = null;
			this.contentLoaderInfo.contentType = null;
			this.contentLoaderInfo.content = null;
			this.contentLoaderInfo.bytesLoaded = 0;
			this.contentLoaderInfo.bytesTotal = 0;
			this.contentLoaderInfo.width = 0;
			this.contentLoaderInfo.height = 0;
			var event = new openfl.events.Event(openfl.events.Event.UNLOAD);
			event.currentTarget = this;
			this.dispatchEvent(event);
		}
	}
	,unloadAndStop: function(gc) {
		if(gc == null) gc = true;
		openfl.Lib.notImplemented("Loader.unloadAndStop");
	}
	,BitmapData_onLoad: function(bitmapData) {
		this.contentLoaderInfo.content = new openfl.display.Bitmap(bitmapData);
		this.content = this.contentLoaderInfo.content;
		this.addChild(this.contentLoaderInfo.content);
		var event = new openfl.events.Event(openfl.events.Event.COMPLETE);
		event.target = this.contentLoaderInfo;
		event.currentTarget = this.contentLoaderInfo;
		this.contentLoaderInfo.dispatchEvent(event);
	}
	,BitmapData_onError: function() {
		var event = new openfl.events.IOErrorEvent(openfl.events.IOErrorEvent.IO_ERROR);
		event.target = this.contentLoaderInfo;
		event.currentTarget = this.contentLoaderInfo;
		this.contentLoaderInfo.dispatchEvent(event);
	}
	,__class__: openfl.display.Loader
});
openfl.display.OpenGLView = function() {
	openfl.display.DirectRenderer.call(this,"OpenGLView");
	if(!this.__added) {
		this.__added = true;
		null;
	}
};
$hxClasses["openfl.display.OpenGLView"] = openfl.display.OpenGLView;
openfl.display.OpenGLView.__name__ = ["openfl","display","OpenGLView"];
openfl.display.OpenGLView.__properties__ = {get_isSupported:"get_isSupported"}
openfl.display.OpenGLView.isSupported = null;
openfl.display.OpenGLView.get_isSupported = function() {
	if(!window.WebGLRenderingContext) return false;
	if(lime.graphics.opengl.GL.context != null) return true; else {
		var canvas = window.document.createElement("canvas");
		var context = canvas.getContext("webgl");
		if(context == null) context = canvas.getContext("experimental-webgl");
		return context != null;
	}
	return true;
};
openfl.display.OpenGLView.__super__ = openfl.display.DirectRenderer;
openfl.display.OpenGLView.prototype = $extend(openfl.display.DirectRenderer.prototype,{
	__renderCanvas: function(renderSession) {
	}
	,__renderDOM: function(renderSession) {
		if(this.stage != null && this.__worldVisible && this.__renderable) {
			if(!this.__added) {
				renderSession.element.appendChild(this.__canvas);
				this.__added = true;
				openfl._internal.renderer.dom.DOMRenderer.initializeElement(this,this.__canvas,renderSession);
			}
			if(this.__context != null) {
				var rect = null;
				if(this.get_scrollRect() == null) rect = new openfl.geom.Rectangle(0,0,this.stage.stageWidth,this.stage.stageHeight); else rect = new openfl.geom.Rectangle(this.get_x() + this.get_scrollRect().x,this.get_y() + this.get_scrollRect().y,this.get_scrollRect().width,this.get_scrollRect().height);
				if(this.__render != null) this.__render(rect);
			}
		} else if(this.__added) {
			renderSession.element.removeChild(this.__canvas);
			this.__added = false;
		}
	}
	,__renderGL: function(renderSession) {
		if(this.stage != null && this.__renderable) {
			var rect = null;
			if(this.get_scrollRect() == null) rect = new openfl.geom.Rectangle(0,0,this.stage.stageWidth,this.stage.stageHeight); else rect = new openfl.geom.Rectangle(this.get_x() + this.get_scrollRect().x,this.get_y() + this.get_scrollRect().y,this.get_scrollRect().width,this.get_scrollRect().height);
			if(this.__render != null) this.__render(rect);
		}
	}
	,__class__: openfl.display.OpenGLView
});
openfl.display.PNGEncoderOptions = function(fastCompression) {
	if(fastCompression == null) fastCompression = false;
	this.fastCompression = fastCompression;
};
$hxClasses["openfl.display.PNGEncoderOptions"] = openfl.display.PNGEncoderOptions;
openfl.display.PNGEncoderOptions.__name__ = ["openfl","display","PNGEncoderOptions"];
openfl.display.PNGEncoderOptions.prototype = {
	__class__: openfl.display.PNGEncoderOptions
};
openfl.display.PixelSnapping = $hxClasses["openfl.display.PixelSnapping"] = { __ename__ : ["openfl","display","PixelSnapping"], __constructs__ : ["NEVER","AUTO","ALWAYS"] };
openfl.display.PixelSnapping.NEVER = ["NEVER",0];
openfl.display.PixelSnapping.NEVER.toString = $estr;
openfl.display.PixelSnapping.NEVER.__enum__ = openfl.display.PixelSnapping;
openfl.display.PixelSnapping.AUTO = ["AUTO",1];
openfl.display.PixelSnapping.AUTO.toString = $estr;
openfl.display.PixelSnapping.AUTO.__enum__ = openfl.display.PixelSnapping;
openfl.display.PixelSnapping.ALWAYS = ["ALWAYS",2];
openfl.display.PixelSnapping.ALWAYS.toString = $estr;
openfl.display.PixelSnapping.ALWAYS.__enum__ = openfl.display.PixelSnapping;
openfl.display.Preloader = function(display) {
	lime.app.Preloader.call(this);
	if(display != null) {
		this.display = display;
		openfl.Lib.current.addChild(display);
		if(js.Boot.__instanceof(display,NMEPreloader)) (js.Boot.__cast(display , NMEPreloader)).onInit();
	}
};
$hxClasses["openfl.display.Preloader"] = openfl.display.Preloader;
openfl.display.Preloader.__name__ = ["openfl","display","Preloader"];
openfl.display.Preloader.__super__ = lime.app.Preloader;
openfl.display.Preloader.prototype = $extend(lime.app.Preloader.prototype,{
	load: function(urls,types) {
		var sounds = [];
		var musics = [];
		var url = null;
		var isAndroid = /Android/.test(navigator.userAgent);
		var isChrome = /Chrome/.test(navigator.userAgent);
		var _g1 = 0;
		var _g = urls.length;
		while(_g1 < _g) {
			var i = _g1++;
			url = urls[i];
			var _g2 = types[i];
			switch(_g2) {
			case "SOUND":
				var sound = haxe.io.Path.withoutExtension(url);
				if(!HxOverrides.remove(sounds,sound)) this.total++;
				sounds.push(sound);
				break;
			case "MUSIC":
				var music = haxe.io.Path.withoutExtension(url);
				if(isChrome) {
					if(!HxOverrides.remove(musics,music)) this.total++;
					musics.push(music);
				} else {
					var sound1 = haxe.io.Path.withoutExtension(url);
					if(!HxOverrides.remove(sounds,sound1)) this.total++;
					sounds.push(sound1);
				}
				break;
			default:
			}
		}
		if(isAndroid && !isChrome) {
			while(sounds.length > 0) {
				sounds.pop();
				this.total--;
			}
			while(musics.length > 0) {
				musics.pop();
				this.total--;
			}
		}
		var _g3 = 0;
		while(_g3 < sounds.length) {
			var soundName = sounds[_g3];
			++_g3;
			var sound2 = new openfl.media.Sound();
			sound2.addEventListener(openfl.events.Event.COMPLETE,$bind(this,this.sound_onComplete));
			sound2.addEventListener(openfl.events.IOErrorEvent.IO_ERROR,$bind(this,this.sound_onIOError));
			sound2.load(new openfl.net.URLRequest(soundName + ".ogg"));
		}
		var _g4 = 0;
		while(_g4 < musics.length) {
			var musicName = musics[_g4];
			++_g4;
			this.loadAudioTag(musicName);
		}
		lime.app.Preloader.prototype.load.call(this,urls,types);
	}
	,loadAudioTag: function(id) {
		var audio = new Audio();
		co.doubleduck.utils.SoundMgr.audios.set(id,audio);
		audio.addEventListener("canplaythrough",$bind(this,this.audio_onLoad));
		audio.loop = true;
		audio.onerror = $bind(this,this.handleLoadError);
		audio.src = id + ".mp3";
	}
	,audio_onLoad: function(data) {
		var audio = data.target;
		audio.removeEventListener("canplaythrough",$bind(this,this.audio_onLoad));
		this.sound_onComplete(null);
	}
	,start: function() {
		if(this.display != null && js.Boot.__instanceof(this.display,NMEPreloader)) {
			this.display.addEventListener(openfl.events.Event.COMPLETE,$bind(this,this.display_onComplete));
			(js.Boot.__cast(this.display , NMEPreloader)).onLoaded();
		} else lime.app.Preloader.prototype.start.call(this);
	}
	,update: function(loaded,total) {
		if(this.display != null && js.Boot.__instanceof(this.display,NMEPreloader)) (js.Boot.__cast(this.display , NMEPreloader)).onUpdate(loaded,total);
	}
	,display_onComplete: function(event) {
		this.display.removeEventListener(openfl.events.Event.COMPLETE,$bind(this,this.display_onComplete));
		openfl.Lib.current.removeChild(this.display);
		openfl.Lib.current.stage.set_focus(null);
		this.display = null;
		lime.app.Preloader.prototype.start.call(this);
	}
	,sound_onComplete: function(event) {
		this.loaded++;
		this.update(this.loaded,this.total);
		if(this.loaded == this.total) this.start();
	}
	,sound_onIOError: function(event) {
		this.loaded++;
		this.update(this.loaded,this.total);
		if(this.loaded == this.total) this.start();
	}
	,__class__: openfl.display.Preloader
});
openfl.display.Shape = function() {
	openfl.display.DisplayObject.call(this);
};
$hxClasses["openfl.display.Shape"] = openfl.display.Shape;
openfl.display.Shape.__name__ = ["openfl","display","Shape"];
openfl.display.Shape.__super__ = openfl.display.DisplayObject;
openfl.display.Shape.prototype = $extend(openfl.display.DisplayObject.prototype,{
	__getBounds: function(rect,matrix) {
		if(this.__graphics != null) this.__graphics.__getBounds(rect,this.__worldTransform);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly) {
		if(this.get_visible() && this.__graphics != null && this.__graphics.__hitTest(x,y,shapeFlag,this.__getTransform())) {
			if(!interactiveOnly) stack.push(this);
			return true;
		}
		return false;
	}
	,__renderCanvas: function(renderSession) {
		openfl._internal.renderer.canvas.CanvasShape.render(this,renderSession);
	}
	,__renderDOM: function(renderSession) {
		openfl._internal.renderer.dom.DOMShape.render(this,renderSession);
	}
	,__renderGL: function(renderSession) {
		if(!this.__renderable || this.__worldAlpha <= 0) return;
		if(this.__graphics != null) openfl._internal.renderer.opengl.utils.GraphicsRenderer.render(this,renderSession);
	}
	,__renderMask: function(renderSession) {
		if(this.__graphics != null) openfl._internal.renderer.canvas.CanvasGraphics.renderMask(this.__graphics,renderSession);
	}
	,get_graphics: function() {
		if(this.__graphics == null) this.__graphics = new openfl.display.Graphics();
		return this.__graphics;
	}
	,__class__: openfl.display.Shape
	,__properties__: $extend(openfl.display.DisplayObject.prototype.__properties__,{get_graphics:"get_graphics"})
});
openfl.display.SimpleButton = function(upState,overState,downState,hitTestState) {
	openfl.display.DisplayObjectContainer.call(this);
	this.enabled = true;
	this.trackAsMenu = false;
	this.useHandCursor = true;
	this.mouseChildren = false;
	this.set_upState(upState != null?upState:this.__generateDefaultState());
	this.set_overState(overState != null?overState:this.__generateDefaultState());
	this.set_downState(downState != null?downState:this.__generateDefaultState());
	this.set_hitTestState(hitTestState != null?hitTestState:this.__generateDefaultState());
	this.set___currentState(this.upState);
};
$hxClasses["openfl.display.SimpleButton"] = openfl.display.SimpleButton;
openfl.display.SimpleButton.__name__ = ["openfl","display","SimpleButton"];
openfl.display.SimpleButton.__super__ = openfl.display.DisplayObjectContainer;
openfl.display.SimpleButton.prototype = $extend(openfl.display.DisplayObjectContainer.prototype,{
	switchState: function(state) {
		if(this.__currentState != null && this.__currentState.parent == this) this.removeChild(this.__currentState);
		if(state != null) this.addChild(state);
	}
	,__generateDefaultState: function() {
		return new openfl.display.DisplayObject();
	}
	,set_downState: function(downState) {
		if(this.downState != null && this.__currentState == this.downState) this.set___currentState(downState);
		return this.downState = downState;
	}
	,set_hitTestState: function(hitTestState) {
		if(hitTestState != this.hitTestState) {
			if(this.hitTestState != null && this.hitTestState.parent == this) this.removeChild(this.hitTestState);
			this.removeEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.__this_onMouseDown));
			this.removeEventListener(openfl.events.MouseEvent.MOUSE_OUT,$bind(this,this.__this_onMouseOut));
			this.removeEventListener(openfl.events.MouseEvent.MOUSE_OVER,$bind(this,this.__this_onMouseOver));
			this.removeEventListener(openfl.events.MouseEvent.MOUSE_UP,$bind(this,this.__this_onMouseUp));
			if(hitTestState != null) {
				this.addEventListener(openfl.events.MouseEvent.MOUSE_DOWN,$bind(this,this.__this_onMouseDown));
				this.addEventListener(openfl.events.MouseEvent.MOUSE_OUT,$bind(this,this.__this_onMouseOut));
				this.addEventListener(openfl.events.MouseEvent.MOUSE_OVER,$bind(this,this.__this_onMouseOver));
				this.addEventListener(openfl.events.MouseEvent.MOUSE_UP,$bind(this,this.__this_onMouseUp));
				hitTestState.set_alpha(0.0);
				this.addChild(hitTestState);
			}
		}
		return this.hitTestState = hitTestState;
	}
	,set_overState: function(overState) {
		if(this.overState != null && this.__currentState == this.overState) this.set___currentState(overState);
		return this.overState = overState;
	}
	,get_soundTransform: function() {
		if(this.__soundTransform == null) this.__soundTransform = new openfl.media.SoundTransform();
		return new openfl.media.SoundTransform(this.__soundTransform.volume,this.__soundTransform.pan);
	}
	,set_soundTransform: function(value) {
		this.__soundTransform = new openfl.media.SoundTransform(value.volume,value.pan);
		return value;
	}
	,set_upState: function(upState) {
		if(this.upState != null && this.__currentState == this.upState) this.set___currentState(upState);
		return this.upState = upState;
	}
	,set___currentState: function(state) {
		if(this.__currentState == state) return state;
		this.switchState(state);
		return this.__currentState = state;
	}
	,__this_onMouseDown: function(event) {
		this.set___currentState(this.downState);
	}
	,__this_onMouseOut: function(event) {
		if(this.upState != this.__currentState) this.set___currentState(this.upState);
	}
	,__this_onMouseOver: function(event) {
		if(this.overState != this.__currentState) this.set___currentState(this.overState);
	}
	,__this_onMouseUp: function(event) {
		this.set___currentState(this.overState);
	}
	,__class__: openfl.display.SimpleButton
	,__properties__: $extend(openfl.display.DisplayObjectContainer.prototype.__properties__,{set___currentState:"set___currentState",set_upState:"set_upState",set_soundTransform:"set_soundTransform",get_soundTransform:"get_soundTransform",set_overState:"set_overState",set_hitTestState:"set_hitTestState",set_downState:"set_downState"})
});
openfl.display.SpreadMethod = $hxClasses["openfl.display.SpreadMethod"] = { __ename__ : ["openfl","display","SpreadMethod"], __constructs__ : ["REPEAT","REFLECT","PAD"] };
openfl.display.SpreadMethod.REPEAT = ["REPEAT",0];
openfl.display.SpreadMethod.REPEAT.toString = $estr;
openfl.display.SpreadMethod.REPEAT.__enum__ = openfl.display.SpreadMethod;
openfl.display.SpreadMethod.REFLECT = ["REFLECT",1];
openfl.display.SpreadMethod.REFLECT.toString = $estr;
openfl.display.SpreadMethod.REFLECT.__enum__ = openfl.display.SpreadMethod;
openfl.display.SpreadMethod.PAD = ["PAD",2];
openfl.display.SpreadMethod.PAD.toString = $estr;
openfl.display.SpreadMethod.PAD.__enum__ = openfl.display.SpreadMethod;
openfl.display.Stage = function(width,height,color) {
	this.__mouseY = 0;
	this.__mouseX = 0;
	openfl.display.Sprite.call(this);
	if(color == null) {
		this.__transparent = true;
		this.set_color(0);
	} else this.set_color(color);
	this.set_name(null);
	this.__mouseX = 0;
	this.__mouseY = 0;
	this.stageWidth = width;
	this.stageHeight = height;
	this.stage = this;
	this.align = openfl.display.StageAlign.TOP_LEFT;
	this.allowsFullScreen = false;
	this.set_displayState(openfl.display.StageDisplayState.NORMAL);
	this.frameRate = 60;
	this.quality = openfl.display.StageQuality.HIGH;
	this.scaleMode = openfl.display.StageScaleMode.NO_SCALE;
	this.stageFocusRect = true;
	this.__clearBeforeRender = true;
	this.__stack = [];
	var this1;
	this1 = new openfl.VectorData();
	var this2;
	this2 = new Array(0);
	this1.data = this2;
	this1.length = 0;
	this1.fixed = false;
	this.stage3Ds = this1;
	var this3 = this.stage3Ds;
	var x = new openfl.display.Stage3D();
	if(!this3.fixed) {
		this3.length++;
		if(this3.data.length < this3.length) {
			var data;
			var this4;
			this4 = new Array(this3.data.length + 10);
			data = this4;
			haxe.ds._Vector.Vector_Impl_.blit(this3.data,0,data,0,this3.data.length);
			this3.data = data;
		}
		this3.data[this3.length - 1] = x;
	}
	this3.length;
};
$hxClasses["openfl.display.Stage"] = openfl.display.Stage;
openfl.display.Stage.__name__ = ["openfl","display","Stage"];
openfl.display.Stage.__super__ = openfl.display.Sprite;
openfl.display.Stage.prototype = $extend(openfl.display.Sprite.prototype,{
	globalToLocal: function(pos) {
		return pos;
	}
	,invalidate: function() {
		this.__invalidated = true;
	}
	,localToGlobal: function(pos) {
		return pos;
	}
	,__drag: function(mouse) {
		var parent = this.__dragObject.parent;
		if(parent != null) mouse = parent.globalToLocal(mouse);
		var x = mouse.x + this.__dragOffsetX;
		var y = mouse.y + this.__dragOffsetY;
		if(this.__dragBounds != null) {
			if(x < this.__dragBounds.x) x = this.__dragBounds.x; else if(x > this.__dragBounds.get_right()) x = this.__dragBounds.get_right();
			if(y < this.__dragBounds.y) y = this.__dragBounds.y; else if(y > this.__dragBounds.get_bottom()) y = this.__dragBounds.get_bottom();
		}
		this.__dragObject.set_x(x);
		this.__dragObject.set_y(y);
	}
	,__fireEvent: function(event,stack) {
		var length = stack.length;
		if(length == 0) {
			event.eventPhase = openfl.events.EventPhase.AT_TARGET;
			event.target.__broadcast(event,false);
		} else {
			event.eventPhase = openfl.events.EventPhase.CAPTURING_PHASE;
			event.target = stack[stack.length - 1];
			var _g1 = 0;
			var _g = length - 1;
			while(_g1 < _g) {
				var i = _g1++;
				stack[i].__broadcast(event,false);
				if(event.__isCancelled) return;
			}
			event.eventPhase = openfl.events.EventPhase.AT_TARGET;
			event.target.__broadcast(event,false);
			if(event.__isCancelled) return;
			if(event.bubbles) {
				event.eventPhase = openfl.events.EventPhase.BUBBLING_PHASE;
				var i1 = length - 2;
				while(i1 >= 0) {
					stack[i1].__broadcast(event,false);
					if(event.__isCancelled) return;
					i1--;
				}
			}
		}
	}
	,__getInteractive: function(stack) {
		stack.push(this);
	}
	,__render: function(context) {
		this.__broadcast(new openfl.events.Event(openfl.events.Event.ENTER_FRAME),true);
		if(this.__invalidated) {
			this.__invalidated = false;
			this.__broadcast(new openfl.events.Event(openfl.events.Event.RENDER),true);
		}
		this.__renderable = true;
		this.__update(false,true);
		switch(context[1]) {
		case 0:
			var gl = context[2];
			if(this.__renderer == null) this.__renderer = new openfl._internal.renderer.opengl.GLRenderer(this.stageWidth,this.stageHeight,gl);
			this.__renderer.render(this);
			break;
		case 1:
			var context1 = context[2];
			if(this.__renderer == null) this.__renderer = new openfl._internal.renderer.canvas.CanvasRenderer(this.stageWidth,this.stageHeight,context1);
			this.__renderer.render(this);
			break;
		case 2:
			var element = context[2];
			if(this.__renderer == null) this.__renderer = new openfl._internal.renderer.dom.DOMRenderer(this.stageWidth,this.stageHeight,element);
			this.__renderer.render(this);
			break;
		default:
		}
	}
	,__resize: function() {
	}
	,__startDrag: function(sprite,lockCenter,bounds) {
		if(bounds == null) this.__dragBounds = null; else this.__dragBounds = bounds.clone();
		this.__dragObject = sprite;
		if(this.__dragObject != null) {
			if(lockCenter) {
				this.__dragOffsetX = -this.__dragObject.get_width() / 2;
				this.__dragOffsetY = -this.__dragObject.get_height() / 2;
			} else {
				var mouse = new openfl.geom.Point(this.get_mouseX(),this.get_mouseY());
				var parent = this.__dragObject.parent;
				if(parent != null) mouse = parent.globalToLocal(mouse);
				this.__dragOffsetX = this.__dragObject.get_x() - mouse.x;
				this.__dragOffsetY = this.__dragObject.get_y() - mouse.y;
			}
		}
	}
	,__stopDrag: function(sprite) {
		this.__dragBounds = null;
		this.__dragObject = null;
	}
	,__update: function(transformOnly,updateChildren) {
		if(transformOnly) {
			if(openfl.display.DisplayObject.__worldTransformDirty > 0) {
				openfl.display.Sprite.prototype.__update.call(this,true,updateChildren);
				if(updateChildren) {
					openfl.display.DisplayObject.__worldTransformDirty = 0;
					this.__dirty = true;
				}
			}
		} else if(openfl.display.DisplayObject.__worldTransformDirty > 0 || this.__dirty || openfl.display.DisplayObject.__worldRenderDirty > 0) {
			openfl.display.Sprite.prototype.__update.call(this,false,updateChildren);
			if(updateChildren) {
				openfl.display.DisplayObject.__worldTransformDirty = 0;
				openfl.display.DisplayObject.__worldRenderDirty = 0;
				this.__dirty = false;
			}
		}
	}
	,get_mouseX: function() {
		return this.__mouseX;
	}
	,get_mouseY: function() {
		return this.__mouseY;
	}
	,canvas_onContextLost: function(event) {
	}
	,canvas_onContextRestored: function(event) {
	}
	,get_color: function() {
		return this.__color;
	}
	,set_color: function(value) {
		var r = (value & 16711680) >>> 16;
		var g = (value & 65280) >>> 8;
		var b = value & 255;
		this.__colorSplit = [r / 255,g / 255,b / 255];
		this.__colorString = "#" + StringTools.hex(value,6);
		return this.__color = value;
	}
	,get_focus: function() {
		return this.__focus;
	}
	,set_focus: function(value) {
		if(value != this.__focus) {
			if(this.__focus != null) {
				var event = new openfl.events.FocusEvent(openfl.events.FocusEvent.FOCUS_OUT,true,false,value,false,0);
				this.__stack = [];
				this.__focus.__getInteractive(this.__stack);
				this.__stack.reverse();
				this.__fireEvent(event,this.__stack);
			}
			if(value != null) {
				var event1 = new openfl.events.FocusEvent(openfl.events.FocusEvent.FOCUS_IN,true,false,this.__focus,false,0);
				this.__stack = [];
				value.__getInteractive(this.__stack);
				this.__stack.reverse();
				this.__fireEvent(event1,this.__stack);
			}
			this.__focus = value;
		}
		return this.__focus;
	}
	,set_displayState: function(value) {
		this.displayState = value;
		return value;
	}
	,__class__: openfl.display.Stage
	,__properties__: $extend(openfl.display.Sprite.prototype.__properties__,{set_focus:"set_focus",get_focus:"get_focus",set_displayState:"set_displayState",set_color:"set_color",get_color:"get_color"})
});
openfl.display.Stage3D = function() {
	openfl.events.EventDispatcher.call(this);
};
$hxClasses["openfl.display.Stage3D"] = openfl.display.Stage3D;
openfl.display.Stage3D.__name__ = ["openfl","display","Stage3D"];
openfl.display.Stage3D.__super__ = openfl.events.EventDispatcher;
openfl.display.Stage3D.prototype = $extend(openfl.events.EventDispatcher.prototype,{
	requestContext3D: function(context3DRenderMode) {
		if(context3DRenderMode == null) context3DRenderMode = "";
		if(openfl.display.OpenGLView.get_isSupported()) {
			this.context3D = new openfl.display3D.Context3D();
			this.dispatchEvent(new openfl.events.Event(openfl.events.Event.CONTEXT3D_CREATE));
		} else this.dispatchEvent(new openfl.events.ErrorEvent(openfl.events.ErrorEvent.ERROR));
	}
	,__class__: openfl.display.Stage3D
});
openfl.display.StageAlign = $hxClasses["openfl.display.StageAlign"] = { __ename__ : ["openfl","display","StageAlign"], __constructs__ : ["TOP_RIGHT","TOP_LEFT","TOP","RIGHT","LEFT","BOTTOM_RIGHT","BOTTOM_LEFT","BOTTOM"] };
openfl.display.StageAlign.TOP_RIGHT = ["TOP_RIGHT",0];
openfl.display.StageAlign.TOP_RIGHT.toString = $estr;
openfl.display.StageAlign.TOP_RIGHT.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.TOP_LEFT = ["TOP_LEFT",1];
openfl.display.StageAlign.TOP_LEFT.toString = $estr;
openfl.display.StageAlign.TOP_LEFT.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.TOP = ["TOP",2];
openfl.display.StageAlign.TOP.toString = $estr;
openfl.display.StageAlign.TOP.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.RIGHT = ["RIGHT",3];
openfl.display.StageAlign.RIGHT.toString = $estr;
openfl.display.StageAlign.RIGHT.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.LEFT = ["LEFT",4];
openfl.display.StageAlign.LEFT.toString = $estr;
openfl.display.StageAlign.LEFT.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.BOTTOM_RIGHT = ["BOTTOM_RIGHT",5];
openfl.display.StageAlign.BOTTOM_RIGHT.toString = $estr;
openfl.display.StageAlign.BOTTOM_RIGHT.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.BOTTOM_LEFT = ["BOTTOM_LEFT",6];
openfl.display.StageAlign.BOTTOM_LEFT.toString = $estr;
openfl.display.StageAlign.BOTTOM_LEFT.__enum__ = openfl.display.StageAlign;
openfl.display.StageAlign.BOTTOM = ["BOTTOM",7];
openfl.display.StageAlign.BOTTOM.toString = $estr;
openfl.display.StageAlign.BOTTOM.__enum__ = openfl.display.StageAlign;
openfl.display.StageDisplayState = $hxClasses["openfl.display.StageDisplayState"] = { __ename__ : ["openfl","display","StageDisplayState"], __constructs__ : ["NORMAL","FULL_SCREEN","FULL_SCREEN_INTERACTIVE"] };
openfl.display.StageDisplayState.NORMAL = ["NORMAL",0];
openfl.display.StageDisplayState.NORMAL.toString = $estr;
openfl.display.StageDisplayState.NORMAL.__enum__ = openfl.display.StageDisplayState;
openfl.display.StageDisplayState.FULL_SCREEN = ["FULL_SCREEN",1];
openfl.display.StageDisplayState.FULL_SCREEN.toString = $estr;
openfl.display.StageDisplayState.FULL_SCREEN.__enum__ = openfl.display.StageDisplayState;
openfl.display.StageDisplayState.FULL_SCREEN_INTERACTIVE = ["FULL_SCREEN_INTERACTIVE",2];
openfl.display.StageDisplayState.FULL_SCREEN_INTERACTIVE.toString = $estr;
openfl.display.StageDisplayState.FULL_SCREEN_INTERACTIVE.__enum__ = openfl.display.StageDisplayState;
openfl.display.StageQuality = $hxClasses["openfl.display.StageQuality"] = { __ename__ : ["openfl","display","StageQuality"], __constructs__ : ["BEST","HIGH","MEDIUM","LOW"] };
openfl.display.StageQuality.BEST = ["BEST",0];
openfl.display.StageQuality.BEST.toString = $estr;
openfl.display.StageQuality.BEST.__enum__ = openfl.display.StageQuality;
openfl.display.StageQuality.HIGH = ["HIGH",1];
openfl.display.StageQuality.HIGH.toString = $estr;
openfl.display.StageQuality.HIGH.__enum__ = openfl.display.StageQuality;
openfl.display.StageQuality.MEDIUM = ["MEDIUM",2];
openfl.display.StageQuality.MEDIUM.toString = $estr;
openfl.display.StageQuality.MEDIUM.__enum__ = openfl.display.StageQuality;
openfl.display.StageQuality.LOW = ["LOW",3];
openfl.display.StageQuality.LOW.toString = $estr;
openfl.display.StageQuality.LOW.__enum__ = openfl.display.StageQuality;
openfl.display.StageScaleMode = $hxClasses["openfl.display.StageScaleMode"] = { __ename__ : ["openfl","display","StageScaleMode"], __constructs__ : ["SHOW_ALL","NO_SCALE","NO_BORDER","EXACT_FIT"] };
openfl.display.StageScaleMode.SHOW_ALL = ["SHOW_ALL",0];
openfl.display.StageScaleMode.SHOW_ALL.toString = $estr;
openfl.display.StageScaleMode.SHOW_ALL.__enum__ = openfl.display.StageScaleMode;
openfl.display.StageScaleMode.NO_SCALE = ["NO_SCALE",1];
openfl.display.StageScaleMode.NO_SCALE.toString = $estr;
openfl.display.StageScaleMode.NO_SCALE.__enum__ = openfl.display.StageScaleMode;
openfl.display.StageScaleMode.NO_BORDER = ["NO_BORDER",2];
openfl.display.StageScaleMode.NO_BORDER.toString = $estr;
openfl.display.StageScaleMode.NO_BORDER.__enum__ = openfl.display.StageScaleMode;
openfl.display.StageScaleMode.EXACT_FIT = ["EXACT_FIT",3];
openfl.display.StageScaleMode.EXACT_FIT.toString = $estr;
openfl.display.StageScaleMode.EXACT_FIT.__enum__ = openfl.display.StageScaleMode;
openfl.display.Tilesheet = function(image) {
	this.__bitmap = image;
	this.__centerPoints = new Array();
	this.__tileRects = new Array();
	this.__tileUVs = new Array();
	this.__rectTile = new openfl.geom.Rectangle();
	this.__rectUV = new openfl.geom.Rectangle();
	this.__point = new openfl.geom.Point();
};
$hxClasses["openfl.display.Tilesheet"] = openfl.display.Tilesheet;
openfl.display.Tilesheet.__name__ = ["openfl","display","Tilesheet"];
openfl.display.Tilesheet.prototype = {
	addTileRect: function(rectangle,centerPoint) {
		this.__tileRects.push(rectangle);
		if(centerPoint == null) centerPoint = openfl.display.Tilesheet.__defaultPoint;
		this.__centerPoints.push(centerPoint);
		this.__tileUVs.push(new openfl.geom.Rectangle(rectangle.get_left() / this.__bitmap.width,rectangle.get_top() / this.__bitmap.height,rectangle.get_right() / this.__bitmap.width,rectangle.get_bottom() / this.__bitmap.height));
		return this.__tileRects.length - 1;
	}
	,drawTiles: function(graphics,tileData,smooth,flags,count) {
		if(count == null) count = -1;
		if(flags == null) flags = 0;
		if(smooth == null) smooth = false;
		graphics.drawTiles(this,tileData,smooth,flags,count);
	}
	,getTileCenter: function(index) {
		return this.__centerPoints[index];
	}
	,getTileRect: function(index) {
		return this.__tileRects[index];
	}
	,getTileUVs: function(index) {
		return this.__tileUVs[index];
	}
	,__class__: openfl.display.Tilesheet
};
openfl.display.TriangleCulling = $hxClasses["openfl.display.TriangleCulling"] = { __ename__ : ["openfl","display","TriangleCulling"], __constructs__ : ["NEGATIVE","NONE","POSITIVE"] };
openfl.display.TriangleCulling.NEGATIVE = ["NEGATIVE",0];
openfl.display.TriangleCulling.NEGATIVE.toString = $estr;
openfl.display.TriangleCulling.NEGATIVE.__enum__ = openfl.display.TriangleCulling;
openfl.display.TriangleCulling.NONE = ["NONE",1];
openfl.display.TriangleCulling.NONE.toString = $estr;
openfl.display.TriangleCulling.NONE.__enum__ = openfl.display.TriangleCulling;
openfl.display.TriangleCulling.POSITIVE = ["POSITIVE",2];
openfl.display.TriangleCulling.POSITIVE.toString = $estr;
openfl.display.TriangleCulling.POSITIVE.__enum__ = openfl.display.TriangleCulling;
openfl.display3D = {};
openfl.display3D.Context3D = function() {
	this.disposed = false;
	this._yFlip = 1;
	this.vertexBuffersCreated = new Array();
	this.indexBuffersCreated = new Array();
	this.programsCreated = new Array();
	this.texturesCreated = new Array();
	this.samplerParameters = new Array();
	var _g1 = 0;
	var _g = openfl.display3D.Context3D.MAX_SAMPLERS;
	while(_g1 < _g) {
		var i = _g1++;
		this.samplerParameters[i] = new openfl.display3D._Context3D.SamplerState();
		this.samplerParameters[i].wrap = openfl.display3D.Context3DWrapMode.CLAMP;
		this.samplerParameters[i].filter = openfl.display3D.Context3DTextureFilter.LINEAR;
		this.samplerParameters[i].mipfilter = openfl.display3D.Context3DMipFilter.MIPNONE;
	}
	var stage = openfl.Lib.current.stage;
	this.ogl = new openfl.display.OpenGLView();
	this.ogl.set_scrollRect(new openfl.geom.Rectangle(0,0,stage.stageWidth,stage.stageHeight));
	this.scrollRect = this.ogl.get_scrollRect().clone();
	this.ogl.set_width(stage.stageWidth);
	this.ogl.set_height(stage.stageHeight);
	stage.addChildAt(this.ogl,0);
};
$hxClasses["openfl.display3D.Context3D"] = openfl.display3D.Context3D;
openfl.display3D.Context3D.__name__ = ["openfl","display3D","Context3D"];
openfl.display3D.Context3D.prototype = {
	clear: function(red,green,blue,alpha,depth,stencil,mask) {
		if(mask == null) mask = 17664;
		if(stencil == null) stencil = 0;
		if(depth == null) depth = 1;
		if(alpha == null) alpha = 1;
		if(blue == null) blue = 0;
		if(green == null) green = 0;
		if(red == null) red = 0;
		if(!this.drawing) {
			this.__updateBlendStatus();
			this.drawing = true;
		}
		lime.graphics.opengl.GL.context.clearColor(red,green,blue,alpha);
		lime.graphics.opengl.GL.context.clearDepth(depth);
		lime.graphics.opengl.GL.context.clearStencil(stencil);
		lime.graphics.opengl.GL.context.clear(mask);
	}
	,configureBackBuffer: function(width,height,antiAlias,enableDepthAndStencil) {
		if(enableDepthAndStencil == null) enableDepthAndStencil = true;
		if(enableDepthAndStencil) {
			lime.graphics.opengl.GL.context.enable(2929);
			lime.graphics.opengl.GL.context.enable(2960);
		}
		this.ogl.set_scrollRect(new openfl.geom.Rectangle(0,0,width,height));
		this.ogl.set_width(width);
		this.ogl.set_height(height);
		this.scrollRect = this.ogl.get_scrollRect().clone();
		lime.graphics.opengl.GL.context.viewport(this.scrollRect.x | 0,this.scrollRect.y | 0,this.scrollRect.width | 0,this.scrollRect.height | 0);
	}
	,createCubeTexture: function(size,format,optimizeForRenderToTexture,streamingLevels) {
		if(streamingLevels == null) streamingLevels = 0;
		var texture = new openfl.display3D.textures.CubeTexture(lime.graphics.opengl.GL.context.createTexture(),size);
		this.texturesCreated.push(texture);
		return texture;
	}
	,createIndexBuffer: function(numIndices) {
		var indexBuffer = new openfl.display3D.IndexBuffer3D(lime.graphics.opengl.GL.context.createBuffer(),numIndices);
		this.indexBuffersCreated.push(indexBuffer);
		return indexBuffer;
	}
	,createProgram: function() {
		var program = new openfl.display3D.Program3D(lime.graphics.opengl.GL.context.createProgram());
		this.programsCreated.push(program);
		return program;
	}
	,createRectangleTexture: function(width,height,format,optimizeForRenderToTexture) {
		var texture = new openfl.display3D.textures.RectangleTexture(lime.graphics.opengl.GL.context.createTexture(),optimizeForRenderToTexture,width,height);
		this.texturesCreated.push(texture);
		return texture;
	}
	,createTexture: function(width,height,format,optimizeForRenderToTexture,streamingLevels) {
		if(streamingLevels == null) streamingLevels = 0;
		var texture = new openfl.display3D.textures.Texture(lime.graphics.opengl.GL.context.createTexture(),optimizeForRenderToTexture,width,height);
		this.texturesCreated.push(texture);
		return texture;
	}
	,createVertexBuffer: function(numVertices,data32PerVertex) {
		var vertexBuffer = new openfl.display3D.VertexBuffer3D(lime.graphics.opengl.GL.context.createBuffer(),numVertices,data32PerVertex);
		this.vertexBuffersCreated.push(vertexBuffer);
		return vertexBuffer;
	}
	,dispose: function() {
		var _g = 0;
		var _g1 = this.vertexBuffersCreated;
		while(_g < _g1.length) {
			var vertexBuffer = _g1[_g];
			++_g;
			vertexBuffer.dispose();
		}
		this.vertexBuffersCreated = null;
		var _g2 = 0;
		var _g11 = this.indexBuffersCreated;
		while(_g2 < _g11.length) {
			var indexBuffer = _g11[_g2];
			++_g2;
			indexBuffer.dispose();
		}
		this.indexBuffersCreated = null;
		var _g3 = 0;
		var _g12 = this.programsCreated;
		while(_g3 < _g12.length) {
			var program = _g12[_g3];
			++_g3;
			program.dispose();
		}
		this.programsCreated = null;
		this.samplerParameters = null;
		var _g4 = 0;
		var _g13 = this.texturesCreated;
		while(_g4 < _g13.length) {
			var texture = _g13[_g4];
			++_g4;
			texture.dispose();
		}
		this.texturesCreated = null;
		if(this.framebuffer != null) {
			lime.graphics.opengl.GL.context.deleteFramebuffer(this.framebuffer);
			this.framebuffer = null;
		}
		if(this.renderbuffer != null) {
			lime.graphics.opengl.GL.context.deleteRenderbuffer(this.renderbuffer);
			this.renderbuffer = null;
		}
		this.disposed = true;
	}
	,drawToBitmapData: function(destination) {
	}
	,drawTriangles: function(indexBuffer,firstIndex,numTriangles) {
		if(numTriangles == null) numTriangles = -1;
		if(firstIndex == null) firstIndex = 0;
		var location = lime.graphics.opengl.GL.context.getUniformLocation(this.currentProgram.glProgram,"yflip");
		lime.graphics.opengl.GL.context.uniform1f(location,this._yFlip);
		if(!this.drawing) throw new openfl.errors.Error("Need to clear before drawing if the buffer has not been cleared since the last present() call.");
		var numIndices;
		if(numTriangles == -1) numIndices = indexBuffer.numIndices; else numIndices = numTriangles * 3;
		var byteOffset = firstIndex * 2;
		lime.graphics.opengl.GL.context.bindBuffer(34963,indexBuffer.glBuffer);
		lime.graphics.opengl.GL.context.drawElements(4,numIndices,5123,byteOffset);
	}
	,present: function() {
		this.drawing = false;
		lime.graphics.opengl.GL.context.useProgram(null);
		lime.graphics.opengl.GL.context.bindBuffer(34962,null);
		lime.graphics.opengl.GL.context.disable(2884);
		if(this.framebuffer != null) lime.graphics.opengl.GL.context.bindFramebuffer(36160,null);
		if(this.renderbuffer != null) lime.graphics.opengl.GL.context.bindRenderbuffer(36161,null);
	}
	,removeRenderMethod: function(func) {
		this.ogl.set_render(null);
	}
	,setBlendFactors: function(sourceFactor,destinationFactor) {
		this.blendEnabled = true;
		this.blendSourceFactor = sourceFactor;
		this.blendDestinationFactor = destinationFactor;
		this.__updateBlendStatus();
	}
	,setColorMask: function(red,green,blue,alpha) {
		lime.graphics.opengl.GL.context.colorMask(red,green,blue,alpha);
	}
	,setCulling: function(triangleFaceToCull) {
		if(triangleFaceToCull == 0) lime.graphics.opengl.GL.context.disable(2884); else {
			lime.graphics.opengl.GL.context.enable(2884);
			switch(triangleFaceToCull) {
			case 1029:
				lime.graphics.opengl.GL.context.cullFace(1029);
				break;
			case 1028:
				lime.graphics.opengl.GL.context.cullFace(1028);
				break;
			case 1032:
				lime.graphics.opengl.GL.context.cullFace(1032);
				break;
			default:
				throw "Unknown Context3DTriangleFace type.";
			}
		}
		switch(triangleFaceToCull) {
		case 1029:
			this._yFlip = -1;
			break;
		case 1028:
			this._yFlip = 1;
			break;
		case 1032:
			this._yFlip = 1;
			break;
		case 0:
			this._yFlip = 1;
			break;
		default:
			throw "Unknown culling mode " + triangleFaceToCull + ".";
		}
	}
	,setDepthTest: function(depthMask,passCompareMode) {
		lime.graphics.opengl.GL.context.depthFunc(passCompareMode);
		lime.graphics.opengl.GL.context.depthMask(depthMask);
	}
	,setGLSLProgramConstantsFromByteArray: function(locationName,data,byteArrayOffset) {
		if(byteArrayOffset == null) byteArrayOffset = 0;
		data.position = byteArrayOffset;
		var location = lime.graphics.opengl.GL.context.getUniformLocation(this.currentProgram.glProgram,locationName);
		lime.graphics.opengl.GL.uniform4f(location,data.readFloat(),data.readFloat(),data.readFloat(),data.readFloat());
	}
	,setGLSLProgramConstantsFromMatrix: function(locationName,matrix,transposedMatrix) {
		if(transposedMatrix == null) transposedMatrix = false;
		var location = lime.graphics.opengl.GL.context.getUniformLocation(this.currentProgram.glProgram,locationName);
		lime.graphics.opengl.GL.uniformMatrix4fv(location,!transposedMatrix,new Float32Array((function($this) {
			var $r;
			var this1 = matrix.rawData;
			var value = new Array();
			{
				var _g1 = 0;
				var _g = this1.data.length;
				while(_g1 < _g) {
					var i = _g1++;
					value.push(this1.data[i]);
				}
			}
			$r = value;
			return $r;
		}(this))));
	}
	,setGLSLProgramConstantsFromVector4: function(locationName,data,startIndex) {
		if(startIndex == null) startIndex = 0;
		var location = lime.graphics.opengl.GL.context.getUniformLocation(this.currentProgram.glProgram,locationName);
		lime.graphics.opengl.GL.context.uniform4f(location,data[startIndex],data[startIndex + 1],data[startIndex + 2],data[startIndex + 3]);
	}
	,setGLSLTextureAt: function(locationName,texture,textureIndex) {
		switch(textureIndex) {
		case 0:
			lime.graphics.opengl.GL.context.activeTexture(33984);
			break;
		case 1:
			lime.graphics.opengl.GL.context.activeTexture(33985);
			break;
		case 2:
			lime.graphics.opengl.GL.context.activeTexture(33986);
			break;
		case 3:
			lime.graphics.opengl.GL.context.activeTexture(33987);
			break;
		case 4:
			lime.graphics.opengl.GL.context.activeTexture(33988);
			break;
		case 5:
			lime.graphics.opengl.GL.context.activeTexture(33989);
			break;
		case 6:
			lime.graphics.opengl.GL.context.activeTexture(33990);
			break;
		case 7:
			lime.graphics.opengl.GL.context.activeTexture(33991);
			break;
		default:
			throw "Does not support texture8 or more";
		}
		if(texture == null) {
			lime.graphics.opengl.GL.context.bindTexture(3553,null);
			lime.graphics.opengl.GL.context.bindTexture(34067,null);
			return;
		}
		var location = lime.graphics.opengl.GL.context.getUniformLocation(this.currentProgram.glProgram,locationName);
		if(js.Boot.__instanceof(texture,openfl.display3D.textures.Texture)) {
			lime.graphics.opengl.GL.context.bindTexture(3553,(js.Boot.__cast(texture , openfl.display3D.textures.Texture)).glTexture);
			lime.graphics.opengl.GL.context.uniform1i(location,textureIndex);
		} else if(js.Boot.__instanceof(texture,openfl.display3D.textures.RectangleTexture)) {
			lime.graphics.opengl.GL.context.bindTexture(3553,(js.Boot.__cast(texture , openfl.display3D.textures.RectangleTexture)).glTexture);
			lime.graphics.opengl.GL.context.uniform1i(location,textureIndex);
		} else if(js.Boot.__instanceof(texture,openfl.display3D.textures.CubeTexture)) {
			lime.graphics.opengl.GL.context.bindTexture(34067,(js.Boot.__cast(texture , openfl.display3D.textures.CubeTexture)).glTexture);
			lime.graphics.opengl.GL.context.uniform1i(location,textureIndex);
		} else throw "Texture of type " + Type.getClassName(Type.getClass(texture)) + " not supported yet";
		var parameters = this.samplerParameters[textureIndex];
		if(parameters != null) this.setTextureParameters(texture,parameters.wrap,parameters.filter,parameters.mipfilter); else this.setTextureParameters(texture,openfl.display3D.Context3DWrapMode.CLAMP,openfl.display3D.Context3DTextureFilter.NEAREST,openfl.display3D.Context3DMipFilter.MIPNONE);
	}
	,setGLSLVertexBufferAt: function(locationName,buffer,bufferOffset,format) {
		if(bufferOffset == null) bufferOffset = 0;
		var location;
		if(this.currentProgram != null && this.currentProgram.glProgram != null) location = lime.graphics.opengl.GL.context.getAttribLocation(this.currentProgram.glProgram,locationName); else location = -1;
		if(buffer == null) {
			if(location > -1) lime.graphics.opengl.GL.context.disableVertexAttribArray(location);
			return;
		}
		lime.graphics.opengl.GL.context.bindBuffer(34962,buffer.glBuffer);
		var dimension = 4;
		var type = 5126;
		var numBytes = 4;
		if(format == openfl.display3D.Context3DVertexBufferFormat.BYTES_4) {
			dimension = 4;
			type = 5126;
			numBytes = 4;
		} else if(format == openfl.display3D.Context3DVertexBufferFormat.FLOAT_1) {
			dimension = 1;
			type = 5126;
			numBytes = 4;
		} else if(format == openfl.display3D.Context3DVertexBufferFormat.FLOAT_2) {
			dimension = 2;
			type = 5126;
			numBytes = 4;
		} else if(format == openfl.display3D.Context3DVertexBufferFormat.FLOAT_3) {
			dimension = 3;
			type = 5126;
			numBytes = 4;
		} else if(format == openfl.display3D.Context3DVertexBufferFormat.FLOAT_4) {
			dimension = 4;
			type = 5126;
			numBytes = 4;
		} else throw "Buffer format " + Std.string(format) + " is not supported";
		lime.graphics.opengl.GL.context.enableVertexAttribArray(location);
		lime.graphics.opengl.GL.context.vertexAttribPointer(location,dimension,type,false,buffer.data32PerVertex * numBytes,bufferOffset * numBytes);
	}
	,setProgram: function(program3D) {
		var glProgram = null;
		if(program3D != null) glProgram = program3D.glProgram;
		lime.graphics.opengl.GL.context.useProgram(glProgram);
		this.currentProgram = program3D;
	}
	,setProgramConstantsFromByteArray: function(programType,firstRegister,numRegisters,data,byteArrayOffset) {
		data.position = byteArrayOffset;
		var _g = 0;
		while(_g < numRegisters) {
			var i = _g++;
			var locationName = this.__getUniformLocationNameFromAgalRegisterIndex(programType,firstRegister + i);
			this.setGLSLProgramConstantsFromByteArray(locationName,data);
		}
	}
	,setProgramConstantsFromMatrix: function(programType,firstRegister,matrix,transposedMatrix) {
		if(transposedMatrix == null) transposedMatrix = false;
		var d = matrix.rawData;
		if(transposedMatrix) {
			this.setProgramConstantsFromVector(programType,firstRegister,[d.data[0],d.data[4],d.data[8],d.data[12]],1);
			this.setProgramConstantsFromVector(programType,firstRegister + 1,[d.data[1],d.data[