﻿
/*
* Ja86 base on Functions(JBF) for JS 1.01
* 
* Copyright(c) 2010, Fooxee (JA86.CN)
*
* JBF is licensed under the terms of the Open Source GPL 3.0(http://www.gnu.org/licenses/gpl.html) license. 
* 
* JBF's blog: http://www.cnblogs.com/JBF/
* 
* Created by Fooxee. at 2010.02.08  mailTo:hjccjun@163.com
*/

var JBF = window.JBF = window.$$={

	version:'1.01',
	zIndex:1,
	//空函数
	emptyFn:function(){},
	//创建新类
	createClass:function()
	{
		return function()
		{
			this.init.apply(this, arguments);
		}
	},
	//继承
	extend:function(destination, source)
	{
		for (var property in source)
		{
			destination[property] = source[property];
		}
	},
	//邦定
	bind:function(object, fun)
	{
		return function()
		{
			return fun.apply(object, arguments);
		}
	},
	//列举
	each:function(list, fun)
	{
		var i=0;
		for(var v in list)
		{
			fun(v,i++);
		}
		//for (var i = 0, len = list.length; i < len; i++) { fun(list[i], i);}
	},
	//是否为空
	isNull:function(chkVal)
	{
		if(chkVal==null || chkVal=="")
		{
			return true;	
		}
		return false;
	},
	//是否布尔值
	isBool:function(chkVal)
	{
		return (chkVal===true || chkVal===false);
	},
	//是否函数
	isFun:function(chkVal)
	{
		return (typeof(chkVal)=='function');
	},
	//是否对象
	isObj:function(chkVal)
	{
		return (typeof(chkVal)=='object');
	},
	//是否日期
	isDate:function(chkVal)
	{
		//TODO
	}
};


//日期操作相关
JBF.Date={
	
	//添加天数
	addDays:function(rDate,d)
	{
		rDate.setDate(rDate.getDate() + d);
		return rDate;
	},
	//添加周
	addWeeks:function(rDate,w)
	{
		rDate.addDays(w * 7);
		return rDate;
	},
	//添加月
	addMonths:function(rDate,m)
	{
		var d = rDate.getDate();
		rDate.setMonth(rDate.getMonth() + m);
	
		if (rDate.getDate() < d)
		{
			rDate.setDate(0);
		}
		return rDate;
	},
	//添加年
	addYears:function(rDate,y)
	{
		var m = rDate.getMonth();
		rDate.setFullYear(rDate.getFullYear() + y);
	
		if (m < rDate.getMonth()) 
		 {
			rDate.setDate(0);
		 }
		 
		 return rDate;
	},
	//取得指定日期的周一的日期
	getFirstDateOfWeek:function(rDate,offset)
	{
		offset=(offset?offset:0)*7;
		rDate.setDate(rDate.getDate()+1+offset-rDate.getDay());
		return rDate;
	},
	//取得指定日期的周日的日期
	getLastDateOfWeek:function(rDate,offset)
	{
		offset=(offset?offset:0)*7;
		rDate.setDate(rDate.getDate()+7+offset-rDate.getDay());
		return rDate;
	},
	//取得指定月的第一天
	getFirstDateOfMonth:function(year,month,offset)
	{
		offset=offset?offset:0;
		var nd=JBF.Date.addMonths(new Date(year+"/"+month+"/1"),offset);
		var ny=nd.getFullYear();
		var nm=nd.getMonth()+1;
	
		return new Date(ny+"/"+nm+"/1");
	},
	//取得指定月的最后一天
	getLastDateOfMonth:function(year,month,offset)
	{
		offset=offset?offset:0;
		var nd=JBF.Date.addMonths(new Date(year+"/"+month+"/1"),offset);
		var ny=nd.getFullYear();
		var nm=nd.getMonth()+1;
		var nd=new Date(ny,nm,1);
		var ld=(new Date(nd.getTime()-1000*60*60*24)).getDate();
		return new Date(ny+"/"+nm+"/"+ld);
	},
	//取得指定月的季度的第一天
	getFirstDateOfQuarter:function(year,month,offset)
	{
		
		offset=offset?offset:0;
		offset=offset*3;
	
		var nd=JBF.Date.getFirstDateOfMonth(year,month,offset);
		var ny=nd.getFullYear();
		var nm=nd.getMonth()+1;
	
		if(nm>=1 && nm <=3)
		{
			return JBF.Date.getFirstDateOfMonth(ny,1,0);
		}
		else if(nm>=4 && nm <=6)
		{
			return JBF.Date.getFirstDateOfMonth(ny,4,0);
		}
		else if(nm>=7 && nm <=9)
		{
			return JBF.Date.getFirstDateOfMonth(ny,7,0);
		}
		else if(nm>=10 && nm <=12)
		{
			return JBF.Date.getFirstDateOfMonth(ny,10,0);
		}
		
	},
	//取得指定月的季度的最后一天
	getLastDateOfQuarter:function(year,month,offset)
	{
		offset=offset?offset:0;
		offset=offset*3;
	
		var nd=JBF.Date.getFirstDateOfMonth(year,month,offset);
		var ny=nd.getFullYear();
		var nm=nd.getMonth()+1;
		
		if(nm>=1 && nm <=3)
		{
			return JBF.Date.getLastDateOfMonth(ny,3,0);
		}
		else if(nm>=4 && nm <=6)
		{
			return JBF.Date.getLastDateOfMonth(ny,6,0);
		}
		else if(nm>=7 && nm <=9)
		{
			return JBF.Date.getLastDateOfMonth(ny,9,0);
		}
		else if(nm>=10 && nm <=12)
		{
			return JBF.Date.getLastDateOfMonth(ny,12,0);
		}
	}

};

//浏览器相关
JBF.Browser={
	//取得浏览器类型
	getType:function()
	{
		var userAgent=navigator.userAgent.toLowerCase();
		if(/webkit/.test( userAgent ))
		{
			return 'safari';
		}
		else if(/opera/.test( userAgent ))
		{
			return 'opera';
		}
		else if(/msie/.test( userAgent ) && !/opera/.test( userAgent ))
		{
			return 'msie';
		}
		else if(/mozilla/.test( userAgent ) && !/(compatible|webkit)/.test( userAgent ))
		{
			return 'mozilla';
		}
		else if(/webkit/.test( userAgent ))
		{
			return 'safari';
		}
	},
	//取得浏览器版本号
	getVersion:function()
	{
		var userAgent=navigator.userAgent.toLowerCase();
		return (userAgent.match( /.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/ ) || [])[1]
	}
};

//DOM相关操作
JBF.Dom=function(selector,context)
{
	return new JBF.Dom.fn(selector,context);
};
JBF.Dom.fn=function(selector,context)
{
	this.el=function()
	{
		selector = selector || document;
		// Handle DOMElement
		if (selector.nodeType) 
		{
			this[0] = selector;
			this.length = 1;
			return this[0];
		}
		// Handle HTML strings
		if (typeof selector == "string" )
		{
			return document.getElementById(selector);
		}
	}();
	
	this.offset=function(rel)
	{
		var left = 0, top = 0, elem = rel||this.el;
		
		left=elem.offsetParent ? elem.offsetLeft +elem.offsetParent.offsetLeft  : elem.offsetLeft;
		top =elem.offsetParent ? elem.offsetTop + elem.offsetParent.offsetTop : elem.offsetTop;
		return {top:top,left:left};
	};
	
	this.hide=function()
	{
		this.el.style.display='none';
	};
	
	this.show=function()
	{
		this.el.style.display='block';
	};
	
	//设置属性
	this.setAttr=function()
	{
		JBF.each([],function(v,i)
	   {
		   //TODO
	   });
	};
	
	/*名称:为DOM注册事件.
	参数:
		el			dom元素
		evtName		事件名
		evtHandler	句柄函数
		useCapture	是否使用捕获
	返回:无
	*/
	this.addListener=function(evtName, evtHandler,useCapture)
	{
		evtHandler=JBF.isFun(evtHandler)?evtHandler:JBF.emptyFn;
		
		if (this.el.attachEvent)
		{
			this.el.attachEvent('on'+evtName, evtHandler);
		}
		else if(this.el.addEventListener)
		{
			this.el.addEventListener(evtName, evtHandler, !JBF.isBool(useCapture)?false:useCapture);
		}
		else 
		{
			alert("事件注册失败:注册函数不被所在浏览器所支持!");
		}
	};
	//设置或获取el的html
	this.html=function(innerHtml)
	{
		if(JBF.isNull(innerHtml))
		{
			return this.el.innerHTML;	
		}
		else
		{
			this.el.innerHTML=innerHtml;
		}
	};
	
	this.drag=function()
	{
		//TODO
	};
	
	this.drop=function()
	{
		//TODO
	};
};

//Ajax
JBF.Ajax=function(options)
{
	options=options?options:{};
	
	//请求方式
	options.method=(options.method=='GET' || options.method=='POST')?options.method:'GET';
	//是否异步请求
	options.async=(options.async===true || options.async===false)?options.async:true;
	//是否缓存
	options.cache=(options.cache===true || options.cache===false)?options.cache:true;
	
	//回调方法
	options.callback=JBF.isFun(options.callback)?options.callback:JBF.emptyFn;
	//请求发送前
	options.beforeSend=JBF.isFun(options.beforeSend)?options.beforeSend:JBF.emptyFn;
	//请求完成后
	options.complete=JBF.isFun(options.complete)?options.complete:JBF.emptyFn;
	//请求错误时
	options.error=JBF.isFun(options.error)?options.error:JBF.emptyFn;
	
	//请求参数
	options.params=JBF.isObj(options.params)?options.params:null;
	
	if(!options.cache)
	{
		options.params.timespace=new Date().getTime();
	}
	
	//构造参数
	var PostParams=function()
	{
		var tempArr = new Array();
		JBF.each(options.params,function(p,idx)
		{
			tempArr.push(p + "=" + options.params[p]);
		});
		return tempArr.join("&");
	}();
	
	if(options.method=='GET')
	{
		if(options.url.indexOf('?')>3)
		{
			options.url +='&'+PostParams;
		}
		else
		{
			options.url +='?'+PostParams;
		}
	}
	
	var httpObj=(function()
	{
        try {return new ActiveXObject("Microsoft.XMLHTTP");}
        catch(e) {try {return new ActiveXObject("Msxml2.XMLHTTP");}
        catch(e) {try {return new XMLHttpRequest();}catch(e) {return window.createRequest();};};};
	})();
	
	//httpObj.setRequestHeader("Content-Type","text/xml"); 
	options.beforeSend(httpObj);
	httpObj.open(options.method,options.url,options.async);
	if(PostParams)
	{
        httpObj.setRequestHeader("Content-Length", PostParams.length);   
        httpObj.setRequestHeader("Content-type", "application/x-www-form-urlencoded;");
    };
	httpObj.send(options.method=='GET'?null:PostParams);
	httpObj.onreadystatechange=function()
	{
		if(httpObj.readyState==4 && httpObj.status == 200)
		{
			options.callback(httpObj.responseText,httpObj);//httpObj.responseText|httpObj.responseXml
		}
	};
};
//callback(rspText,XMLHttpRequest)
JBF.Ajax.post=function(url,params,callback,async)
{
	return 	JBF.Ajax({url:url,params:params,callback:callback,method:'POST',async:async});
};

JBF.Ajax.get =function(url,params,callback,async)
{
	return 	JBF.Ajax({url:url,params:params,callback:callback,method:'GET',async:async});
};

//Cookie操作
JBF.Cookie={
	
	//设置
	set:function(sName, sValue, iHour)
	{
		var sCookie = sName + "=" + encodeURIComponent(sValue);
		if (iHour)
		{
			var oExpires = new Date( new Date().getTime() + iHour * 3600000);
			sCookie += "; expires=" + oExpires.toGMTString();
		}
		document.cookie = sCookie;
	},
	//获取
	get:function(sName)
	{
		var sRE = "(?:; )?" + sName + "=([^;]*);?";
		var oRE = new RegExp(sRE);
		if (oRE.test(document.cookie))
		{
			return decodeURIComponent(RegExp["$1"]);
		} 
		else
		{
			return null;
		}
	},
	//移除
	remove:function(sName)
	{
		this.set(sName,null,-9999);
	},
	//清除所有Cookie
	clear:function()
	{
		document.cookie=null;
	}
};
