<?php
////////////////////////////////////////////////////
// CDB
//
// Version 1.00
//
// Define an db operation
//
// Author: lingp
// Date:2011-05-20
//
////////////////////////////////////////////////////

class CSqlite
{
	var $db;
	var $result;
	var $row_no;
	var $row_count;
	
	function CSqlite()
	{
		global $Config;
		$DB_STR = "sqlite:".$Config["SQLITE_DB_NAME"];
		$this->db = new PDO($DB_STR);
		$this->row_no = 0;
		$this->row_count = 0;
	}
	
	function SetCharset($charset)
	{}
	
	function ExeSql($sql)
	{
		$this->db->query($sql) or die ("Exesql err:" . $sql);
	}
	
	function ExeQuerySql($sql)
	{
		$this->result = $this->db->query($sql)->fetchAll() or die ("ExeQuery err:" . $sql);
		$this->row_count = sizeof($this->result);
	}
	
	function FetchRow()
	{
		if($this->IsEof()) return false;
		$this->row_no++; 
		return true;
	}
	
	function IsEof()
	{
		return $this->row_no >= $this->row_count;	
	}
	
	function Get($id)
	{
		$index = $this->row_no - 1;
		$entry = $this->result[$index];
		
		return $entry[$id];	
	}
	
	function FreeResult()
	{
		$this->db->close();
	}
};

class CMysql
{	
	var $db;
	var $result;
	var $row_no;
	var $row_count;
	
	function CMysql()
	{
		global $Config;
		$this->db = mysql_connect($Config["DB_HOST"], $Config["DB_USER"], $Config["DB_PWD"]) 	or die ("Could not connect:" . mysql_error());
		mysql_select_db($Config["DB_NAME"]); 
		mysql_query("SET NAMES UTF8", $this->db);
		//mysql_query("SET CHARACTER SET utf8", $this->db);
		
		$this->row_no="";
	}
	
	function ExeSql($sql)
	{
		mysql_query($sql) or die ("Execute sql err:" . mysql_error());
	}
	
	function ExeQuerySql($sql)
	{
		$this->result = mysql_query($sql) or die ("Exequery sql err:" . mysql_error());
		$this->row_count = mysql_num_rows($this->result);
	}
	
	function FetchRow()
	{
		if($this->IsEof()) return false;
		$this->row_no = mysql_fetch_object($this->result);
		if($this->row_no == "") return false;
		return true;
	}
	
	function IsEof()
	{
		return ($this->result == NULL);
	}
	
	function Get($id)
	{
		return $this->row_no->$id;
	}
	
	function FreeResult()
	{
		mysql_free_result($this->result);	
	}
};

class CDB
{
	var $db;
	function CDB($db_type = "mysql")
	{
		global $Config;
		/*
		if($Config["DB_TYPE"] == "mysql")
			$this->db = new CMysql();
		else if($Config["DB_TYPE"] == "sqlite")
			$this->db = new CSqlite();
		*/
		if($db_type == "mysql")
			$this->db = new CMysql();
		else if($db_type == "sqlite")
			$this->db = new CSqlite();
	}
	
	function SetCharset($charset)
	{
		$this->db->SetCharset($charset);
	}
	
	function ExeSql($sql)
	{
		$this->db->ExeSql($sql);
	}
	
	function ExeQuerySql($sql)
	{
		$this->db->ExeQuerySql($sql);
	}
	
	function FetchRow()
	{
		return $this->db->FetchRow();
	}
	
	function IsEof()
	{
		return $this->db->IsEof();
	}
	
	function Get($id)
	{
		return $this->db->Get($id);	
	}
	
	function GetResultCount()
	{
		return $this->db->row_count;	
	}
	
	function FreeResult()
	{
		return $this->db->FreeResult();	
	}
	
	function GetMaxField($tb, $field)
	{
		$sql = "select max(".$field.") max from ".$tb;
		$this->ExeQuerySql($sql);
		if(!$this->FetchRow())
			return 0;
		
		return $this->Get('max');
	}
	
	function GetCount($tb, $query_field, $field_value)
	{
		$sql = "select count(*) nCount from ".$tb." where ".$query_field." = '".	$field_value . "'";
		$this->ExeQuerySql($sql);
		if(!$this->FetchRow())
			return 0;
		return $this->Get('nCount');
	}
};

?>