<?php
/*
名称：GotoWeb
参数：$url 必选
作用：页面跳转
*/
function GotoWeb($url)
{
	echo "<script>";
	echo "document.location.href= '".$url ."'";
	echo "</script>";
}

//显示导航
function NavigatePos($pos_str)
{
	echo "<script>NavigatePos('".$pos_str."');</script>";
}

/*
名称：DEBUG
参数：$errr_msg 必选
作用：打印错误调试信息
*/
function DEBUG($errr_msg)
{
	if($errr_msg)
	{
			echo "发生错误:<br>"; 
			echo $errr_msg;
			exit;
	}
}

/*
名称：htmlStr
参数：$str
作用：替换成html字符
*/
function htmlStr($str)
{
	return str_replace(array("\r","\n"), array('<br>'), htmlspecialchars($str));
}

/*
名称: PhpSetCookie
参数：1 $name 必选 
      2 $value 必选
      3 $permanent 可选
作用: 设置客户端cookie
*/
function PhpSetCookie($name, $value)
{
	global $Config;
	$name = $Config['Cookie_Pre'] . $name;
  $_SESSION[$name] = $value;
}

/*
名称：GetCookie
参数：无
作用：获取客户端Cookie参数
*/
Function GetCookie()
{
	global $UserInfo, $Config;
	
	if (isset($_SESSION[$Config['Cookie_Pre'].'UID'])) 
		$UserInfo["UID"] = intval($_SESSION[$Config['Cookie_Pre'].'UID']);
		
	if (isset($_SESSION[$Config['Cookie_Pre'].'UNAME'])) 
		$UserInfo["UNAME"] = $_SESSION[$Config['Cookie_Pre'].'UNAME'];
	
	if (isset($_SESSION[$Config['Cookie_Pre'].'RNAME'])) 
		$UserInfo["RNAME"] = $_SESSION[$Config['Cookie_Pre'].'RNAME'];
	
	if (isset($_SESSION[$Config['Cookie_Pre'].'LOGIN'])) 
 		$UserInfo["LOGIN"] = $_SESSION[$Config['Cookie_Pre'].'LOGIN'];
 		
 	if (isset($_SESSION[$Config['Cookie_Pre'].'ROLE'])) 
 		$UserInfo["ROLE"] = $_SESSION[$Config['Cookie_Pre'].'ROLE'];
}

//清空cookie
Function CleanCookie()
{
	session_unset();
}

/*
名称：CheckLogin
参数：无
作用：检查是否登陆
*/
function CheckLogin()
{
	global $UserInfo;
	GetCookie();
	if(0 == $UserInfo["LOGIN"])
		GotoWeb("login.php");
}

/*
名称：CheckSysGrade
参数：无
作用：检查系统权限
*/
function CheckSysGrade($check_grade)
{
	global $UserInfo;
	return ($UserInfo["ROLE"] & $check_grade);
}

function CheckViewGrade($check_grade)
{
		if(!CheckSysGrade($check_grade))
			GotoWeb("index.php?job=no_grade");
}
?>