<?php 
class CModuleInfo
{
	var $module_id;
	var $module_name;
	var $module_desc;
	var $parent_id;
	var $parent_name;
	var $manager_id;
	var $manager_name;
	var $modules;
	
	function CModuleInfo()
	{
		$this->modules=array();
	}
	
	function Insert($mod)
	{
		if($this->module_id == $mod->parent_id)
		{
			$mod->parent_name = $this->module_name;
			$this->modules[sizeof($this->modules)] = $mod;
			return true;
		}
		else
		{
			for($i=0;$i<sizeof($this->modules); $i++)
				if($this->modules[$i]->Insert($mod)) return true;	
		}
		
		return false;
	}
	
	function InitTree($db)
	{
		$sql = "select a.*, b.real_name from tb_project_module a, tb_user b where a.parent_module_id=".$this->module_id." and a.user_id = b.user_id order by a.parent_module_id, a.module_id";		
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{			
			$mod = new CModuleInfo();
			
			$mod->module_id 	= $db->Get("module_id");
			$mod->module_name = $db->Get("module_name");
			$mod->module_desc = $db->Get("module_desc");
			$mod->parent_id 	= $db->Get("parent_module_id");
			$mod->manager_id 	= $db->Get("user_id");
			$mod->manager_name= $db->Get("real_name");
			$this->modules[sizeof($this->modules)] = $mod;
		} 
		$db->FreeResult();
		
		for($i=0;$i<sizeof($this->modules);$i++)
			$this->modules[$i]->InitTree($db);		
	}
	
	function DelTree($db)
	{
			for($i=0;$i<sizeof($this->modules);$i++)
				$this->modules[$i]->DelTree($db);
			
			$sql = "delete from tb_project_module where module_id=".$this->module_id;
			$db->ExeSql($sql);
	}
	
	function Display($blank="")
	{
			$span_id = "module_span_".$this->module_id;
			$img_id = "module_img_".$this->module_id;
			
			
			
			echo $blank;
			if(sizeof($this->modules)>0)
				echo "<span class=\"link\" onclick=\"display('".$span_id."', '".$img_id."')\"><img src=\"imgs/dtree/nolines_plus.gif\" id='".$img_id."'></span>";	
			else
				echo "<span class=\"link\"><img src=\"imgs/dtree/empty.gif\" id='".$img_id."'></span>";
		
			echo $this->module_name ."&nbsp;&nbsp;";
			echo $this->manager_name ."&nbsp;&nbsp;";
			echo $this->module_desc ."&nbsp;&nbsp;";
		
			echo "<span class=\"link\" onclick=\"ClickEditModule('add',0, ".$this->module_id.")\"><img src=\"imgs/icon_worklog.gif\" alt=\"增加子模块\"></span>&nbsp;&nbsp;";
			echo "<span class=\"link\" onclick=\"ClickEditModule('mod', ".$this->module_id.", 0)\"><img src=\"imgs/b_edit.png\" alt=\"编辑\"></span>&nbsp;&nbsp;";
			echo "<span class=\"link\" onclick=\"ClickDelModule(".$this->module_id.", '".$this->module_name."')\"><img src=\"imgs/b_drop.png\" alt=\"删除\"></span>";
			
			echo "<br>";
			
			echo "<span id='".$span_id."' style='display:none;'>";
			$blank .= "<img src=\"imgs/dtree/empty.gif\">";
			for($i=0; $i<sizeof($this->modules);$i++)
				$this->modules[$i]->Display($blank);
			echo "</span>";
	}	
};

class CModuleProjectModule extends CModuleBase
{
	function Init($project_id=0)
	{
		$sql = "select a.*, b.real_name from tb_project_module a, tb_user b where a.project_id=".$project_id." and a.user_id = b.user_id order by a.parent_module_id, a.module_id";		
		
		$this->db->ExeQuerySql($sql);
	
		while($this->db->FetchRow())
		{			
			$mod = new CModuleInfo();
			
			$mod->module_id 	= $this->db->Get("module_id");
			$mod->module_name = $this->db->Get("module_name");
			$mod->module_desc = $this->db->Get("module_desc");
			$mod->parent_id 	= $this->db->Get("parent_module_id");
			$mod->manager_id 	= $this->db->Get("user_id");
			$mod->manager_name= $this->db->Get("real_name");
				
			if($mod->parent_id == 0)
				$this->modules[$this->GetSize()] = $mod;
			else
				$this->InsertTree($mod);
		} 
		$this->db->FreeResult();
	}
	
	function InitModule($module_id)
	{
		$this->module = new CModuleInfo();
		$sql = "select a.*, b.real_name from tb_project_module a, tb_user b where a.module_id=".$module_id." and a.user_id = b.user_id";
		$this->db->ExeQuerySql($sql);
	
		if($this->db->FetchRow())
		{
			$this->module->module_id 	= $this->db->Get("module_id");
			$this->module->module_name = $this->db->Get("module_name");
			$this->module->module_desc = $this->db->Get("module_desc");
			$this->module->parent_id 	= $this->db->Get("parent_module_id");
			$this->module->manager_id 	= $this->db->Get("user_id");
			$this->module->manager_name= $this->db->Get("real_name");
		} 
		$this->db->FreeResult();
		$this->module->InitTree($this->db);
	}
	
	function InsertTree($mod)
	{
		for($i=0; $i<sizeof($this->modules); $i++)
			if($this->modules[$i]->Insert($mod)) return true;
			
		return false;	
	}
};
?>
