<?php
////////////////////////////////////////////////////
// CUpload - PHP CUpload class
//
// Version 1.00
//
// Define upload files
//
// Author: lingp
// Date:2012-02-13
//
////////////////////////////////////////////////////

class CUpload
{
	var $err_msg;
	var $tmp_name;
	var $file_name;
	var $file_type;
	
	function CUpload()
	{
		$this->err_msg = "";
	}
	
	function GetError()
	{
		return $this->err_msg;	
	}
	
	function Execute($tmp_file, $save_path, $file_size, $file_type)
	{
		global $FileInfo, $UserInfo;
		if (!isset($_FILES)) 
			global $_FILES;
		
	
		if($_FILES["attach_file"]["error"] != UPLOAD_ERR_OK)
		{
				$this->err_msg = "文件上传失败:".$_FILES["attach_file"]["error"];
				return false;
		}			
		
		if(!$this->CheckFileType($file_type))
		{
			$this->err_msg = "文件上传失败,文件类型不允许上传";
			return false;	
		}
		
		if(!$this->CheckMaxSize($file_size))
		{
			$this->err_msg = "文件上传失败,文件大小超出了限制";
			return false;
		}
		
		$file_id = $UserInfo["UID"].time().rand(0,9);
		$file_name = $save_path . $file_id . "." . $file_type;
		$upload_name = $_SERVER["DOCUMENT_ROOT"].$file_name;
		$this->file_name = $file_name;
		$this->file_type = $file_type;
		
		if(!move_uploaded_file($tmp_file, $upload_name))
		{
			$this->err_msg = "文件上传失败,非法文件或是系统错误sss";
			return false;
		}
		
		return true;
	}	
	
	function CheckFileType($fileName)
	{
		global $FileInfo;
		
		for($i=0;$i<sizeof($FileInfo['ext_arr']);$i++)
		{
			if(strcmp($FileInfo['ext_arr'][$i], $fileName) == 0)
				return true;	
		}
		
		return false;
	}
	
	function CheckMaxSize($fileSize)
	{
		global $FileInfo;
		return $fileSize <= $FileInfo['max_size'];
	}
	
};

?>