<?php
/*
名称：GotoWeb
参数：$url 必选
作用：页面跳转
*/
function GotoWeb($url)
{
	echo "<script>";
	echo "document.location.href= '".$url ."'";
	echo "</script>";
}

//显示导航
function NavigatePos($pos_str)
{
	echo "<script>NavigatePos('".$pos_str."');</script>";
}

/*
名称：DEBUG
参数：$errr_msg 必选
作用：打印错误调试信息
*/
function DEBUG($errr_msg)
{
	if($errr_msg)
	{
			echo "发生错误:<br>"; 
			echo $errr_msg;
			exit;
	}
}

//序列化数组
function SerializeArray($arr)
{
	if(gettype($arr) != "array") return $arr;
	
	$str = "";
	for($i=0;$i<sizeof($arr);$i++)
	{
		if($arr[$i] == "") continue;
		
		if($i>0) $str = $str . ";";
		$str = $str . $arr[$i];	
	}
	return $str;
}
function UnSerializeArray($arr_str)
{
	$arr = explode(";", $arr_str); 
	return $arr;
}

//序列化可选值
function SerializeOption($ops)
{
	if(gettype($ops) != "array") return $ops;
	
	$str = "";
	for($i=0; $i<sizeof($ops); $i++)		
	{
		if($i>0) $str = $str . ";";
		$str = $str . $ops[$i]["id"].":".$ops[$i]["value"];	
	}
	
	return $str;
}
function UnSerializeOption($ops_str)
{
	$ops_arr = array();
	$arr =  explode(";", $ops_str);
	
	for($i=0; $i<sizeof($arr); $i++)
	{
		if($arr[$i] == "") continue;
				
		$op = explode(":",$arr[$i]);
		if(sizeof($op)<2) continue;
				
		$ops_arr[sizeof($ops_arr)] = array("id"=>$op[0], "value"=>$op[1]);		
	}
		
	return $ops_arr;
}
	
/*
名称：htmlStr
参数：$str
作用：替换成html字符
*/
function htmlStr($str)
{
	return str_replace(array("\r","\n"), array('<br>'), htmlspecialchars($str));
}

function EncodeHtml($str)
{
	$str = str_replace("&", "&amp;", $str);
	$str = str_replace("\"", "&quot;", $str);
	$str = str_replace("'", "&#039;", $str);
	$str = str_replace("<", "&lt;", $str);
	$str = str_replace(">", "&gt;", $str);
	return $str;
}

function EncodeSqlStr($str)
{
		return str_replace("'", "''", EncodeHtml($str));
}

/*
名称: PhpSetCookie
参数：1 $name 必选 
      2 $value 必选
      3 $permanent 可选
作用: 设置客户端cookie
*/
function PhpSetCookie($name, $value)
{
	global $Config;
	$name = $Config['Cookie_Pre'] . $name;
	$_SESSION[$name] = $value;
}

/*
名称: PhpUnsetCookie
参数：1 $name 必选 
作用: 取消客户端cookie
*/
function PhpUnsetCookie($name)
{
	if(isset($_SESSION[$name]))
		session_unset($_SESSION[$name]);	
}

/*
名称: PhpGetCookie
参数：1 $name 必选 
作用: 获取客户端cookie
*/
function PhpGetCookie($name)
{
	global $Config;
	$name = $Config['Cookie_Pre'] . $name;
	if(isset($_SESSION[$name]))
		return $_SESSION[$name];
	return "";
} 
//清空cookie
function CleanCookie()
{
	global $Config;
	PhpSetCookie('UID');
	PhpSetCookie('UNAME');
	PhpSetCookie('RNAME');
	PhpSetCookie('LOGIN');
	PhpSetCookie('ROLE');
}
/*
GetUserInfo
参数：无
作用：获取登陆用户信息
*/
function GetUserInfo()
{
	global $UserInfo;

	$UserInfo["UID"] = PhpGetCookie("UID"); 
	$UserInfo["UNAME"] = PhpGetCookie("UNAME");
	$UserInfo["RNAME"] = PhpGetCookie("RNAME");
	$UserInfo["LOGIN"] = PhpGetCookie("LOGIN");
	$UserInfo["ROLE"] = PhpGetCookie("ROLE");
}

/*
名称：CheckLogin
参数：无
作用：检查是否登陆
*/
function CheckLogin()
{
	global $UserInfo;
	GetUserInfo();

	if("" == $UserInfo["LOGIN"])
		GotoWeb("login.php");
}

/*
名称：CheckSysGrade
参数：无
作用：检查系统权限
*/
function CheckSysGrade($check_grade)
{
	global $UserInfo;
	return ($UserInfo["ROLE"] & $check_grade);
}

function CheckViewGrade($check_grade)
{
		if(!CheckSysGrade($check_grade))
			GotoWeb("index.php?job=no_grade");
}

/*
名称: PostMail
参数:
作用: 发送邮件
*/

function PostMail($to, $to_name, $subject, $body, $attachs)
{
	global $Config;
	$mail = new PHPMailer();
	$mail->Host       = $Config["Mail_Host"]; // sets the SMTP server
	$mail->IsSMTP(); // telling the class to use SMTP
	$mail->SMTPDebug  = 1;                  // enables SMTP debug information (for testing)
                                          // 1 = errors and messages
                                    			// 2 = messages only
  $mail->CharSet = $Config["Charset"];
	$mail->SMTPAuth   = true;                  // enable SMTP authentication
	
	$mail->Host       = $Config["Mail_Host"]; // sets the SMTP server
	$mail->Port       = $Config["Mail_Port"];                    // set the SMTP port for the GMAIL server
	$mail->Username   = $Config["Mail_Username"]; // SMTP account username
	$mail->Password   = $Config["Mail_Password"];        // SMTP account password

	$mail->SetFrom($Config["Mail_FromAddress"], $Config["Mail_FromName"]);
	$mail->AddReplyTo($Config["Mail_FromAddress"],$Config["Mail_FromName"]);

	$mail->Subject    = $subject;
	$mail->AltBody    = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
	$mail->MsgHTML($body."<br><br><a href='www.mykis.net'>www.mykis.net.com</a> 做简单易用的软件</font>");
	$mail->AddAddress($to, $to_name);

	for($i=0; $i<sizeof($attachs); $i++)
		$mail->AddAttachment($attachs[$i]);      // attachment

	if(!$mail->Send()) 
  	return $mail->ErrorInfo;

  return "";	
}

?>