﻿<?php 
session_start();
require_once("../common/common.php");
require_once("../module/module.base.php");

class CDaemon
{	
	function execute()
	{
		$job = $_POST["job"];		
		
		switch($job)
		{
		case "getFlowCount": //获取流程数量
			$echo_str = $this->GetFlowCount();
		break;
		case "loadFlow": //装载流程信息
			$echo_str = $this->LoadFlow();
		break;
		case "getDeptMember": //装载部门成员
			$echo_str = $this->GetDeptMember();
		break;
		case "getActionMember"://装载所有动作处理成员
			$echo_str = $this->getActionMember();
		break;
		case "getGroupMember"://装载工作组成员
			$echo_str = $this->getGroupMember();
		break;
		case "getActionField"://装载动作处理字段
			$echo_str = $this->getActionField();
			break;
		case "getActionEditFields"://装载单个动作的可编辑字段
			$echo_str = $this->getActionEditFields();
		break;
		case "getIssueTypes": //获取事物类型
			$echo_str = $this->getIssueTypes();
		break;
		case "getActions"://获取事物动作
			$echo_str = $this->getActions();
		break;
		case "getNextActionMember"://获取下一状态动作处理人
			$echo_str = $this->getNextActionMember();
		break;
		case "getActionStatus": //获取下一动作状态
			$echo_str = $this->getActionStatus();
		break;
		case "getIssueList": //获取事物列表
			$echo_str = $this->getIssueList();
		break;
		case "getIssueStatus"://获取事务状态列表
			$echo_str = $this->getIssueStatus();
		break;
		}
		return $echo_str;
	}
	
	//获取流程数量
	function GetFlowCount()
	{
		require_once('../module/module.flow.php');
		$flow = new CModuleFlow();
		$flow_name = $_POST["flow_name"];
		$flow_id = $_POST["flow_id"];
		return $flow->GetCount($flow_name, $flow_id); 
	}
	
	//装载流程信息
	function LoadFlow()
	{
		require_once('../module/module.flow.php');
		//$flow_id = $_REQUEST["flow_id"];
		$flow_id = $_POST["flow_id"];		
		
		$flow = new CModuleFlow();
		$flow->InitModule($flow_id);
		return $flow->ModuleToJson();
	}
	
	//装载部门成员
	function GetDeptMember()
	{
			require_once('../module/module.user.php');
			$dept_id = $_POST["dept_id"];
			$users = new CModuleUser();
			$users->InitDeptMember($dept_id);
			return $users->ToJson();
	}
	
	//装载动作处理成员
	function getActionMember()
	{
			require_once('../module/module.flow_action.php');
			$flow_id = $_POST["flow_id"];
			$issue_typeid = $_POST["issue_typeid"];
			$action = new CModuleFlowAction();
			$action->Init($flow_id);
			$action->InitMember($issue_typeid);
			return $action->ToJson();
	}
	
	//装载工作组成员
	function getGroupMember()
	{
		$group_id = $_POST["group_id"];
		require_once("../module/module.project_workgroup.php");
		$group = new CModuleWorkGroup();
		$group->InitModule($group_id);
		return $group->ModuleToJson();
	}
	
	//装载动作处理字段
	function getActionField()
	{
			require_once('../module/module.flow_action.php');
			$flow_id = $_POST["flow_id"];
			$issue_typeid = $_POST["issue_typeid"];
			$action = new CModuleFlowAction();
			$action->Init($flow_id);
			$action->InitField($issue_typeid);
			return $action->ToJson();
	}
	
	//装载动作处理字段
	function getActionEditFields()
	{
			require_once('../module/module.flow_action.php');
			$issue_type = $_POST["issue_type"];
			$action_id = $_POST["action_id"];
			$action = new CModuleFlowAction();
			$action->InitModule($action_id);
			$action->InitField($issue_type, 0);
			if(sizeof($action->module->fields) == 0) return "{\"field_count\":0}";
			
			$tb = "<table width=100% border=0 cellspacing=0 cellpadding=0>";
			for($i=0; $i<sizeof($action->module->fields);$i++)
			{
				$tb = $tb . "<tr height=30>";
				$tb = $tb . "<td align=right valign=top width=10%>".$action->module->fields[$i]->field_title.":&nbsp;&nbsp;</td>";
				$tb = $tb . "<td valign=top>".$action->module->fields[$i]->GetEditContent()."</td>";
				$tb = $tb . "</tr>";
			}
			$tb = $tb . "</table>";
			
			return "{\"field_count\":".sizeof($action->module->fields).",\"field_str\":\"".$tb."\"}";
	}
	
	//获取事物类型
	function getIssueTypes()
	{
			global $UserInfo;
			require_once('../module/module.project_issuetype.php');
			$project_id = $_POST["project_id"];			
			$IssueType = new CModuleIssueType();
			$IssueType->InitByUserID($UserInfo["UID"],$project_id);
			return $IssueType->ToJson();
	}
	
	//获取动作
	function getActions()
	{
		global $UserInfo;
			require_once('../module/module.flow_action.php');
			$issue_type = $_POST["issue_type"];			
			$action = new CModuleFlowAction();
			$action->InitActionByIssueType($issue_type, 0, $UserInfo['UID']);
			return $action->ToJson();
	}
	
	//获取下一状态动作处理人
	function getNextActionMember()
	{
			require_once('../module/module.flow_action.php');
			$issue_type = $_POST["issue_type"];	
			$action_id = $_POST["action_id"];		
			$action = new CModuleFlowAction();
			$action->InitModule($action_id);
			$action->InitNextActionMember($issue_type);
			
			$ids = "";
			for($i=0;$i<sizeof($action->module->members); $i++)   
			{
				if($i>0) $ids = $ids . ",";
				$ids = $ids . $action->module->members[$i]->dept_id;
			}				
			require_once('../module/module.dept.php');
			$depts = new CModuleDept();
			$depts->InitByID($ids);
			$action->module->depts = $depts->GetOptions();
			
			return $action->ModuleToJson();
	}
	
	//获取下一动作状态
	function getActionStatus()
	{
		$action_id = $_POST["action_id"];
		require_once('../module/module.flow_action.php');
		$action = new CModuleFlowAction();
		$action->InitModule($action_id);
		return $action->ModuleToJson();
	}
	
	//获取事务状态列表
	function getIssueStatus()
	{
		$issue_type = $_POST["issue_type"];
		require_once('../module/module.project_issuetype.php');
		$types = new CModuleIssueType();
		$types->InitModule($issue_type);
		
		require_once('../module/module.flow.php');
		$flow = new CModuleFlow();
		$flow->InitModule($types->module->flow_id);
		return json_encode($flow->module->status);
	}
	
	//获取事务列表
	function getIssueList()
	{
		$query_id = $_POST["query_id"]; 
		$page = $_POST["page"];
		require_once('../module/module.query.php');
		$query = new CModuleQuery();
		$query->InitModule($query_id, $page);
		return $query->ModuleToJson();
	}
	
};

GetUserInfo();
$daemon = new CDaemon();
echo 	$daemon->execute();
?>